//============================================================================================
/**
 * @file	regulation.c
 * @brief	ogM[Vf[^ANZXp\[X
 * @author	k.ohno
 * @date	2006.1.20
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/regulation.h"
#include "regulation_local.h"

#include "system/pm_str.h"

#include "gflib/strbuf_family.h"


//============================================================================================
//============================================================================================

//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int Regulation_GetWorkSize(void)
{
	return sizeof(REGULATION);
}

//----------------------------------------------------------
/**
 * @brief	ogM[V[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	REGULATION*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
REGULATION* Regulation_AllocWork(u32 heapID)
{
	REGULATION* reg;
	reg = sys_AllocMemory(heapID, sizeof(REGULATION));
	Regulation_Init(reg);
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	REGULATIOÑRs[
 * @param	from	Rs[REGULATIONւ̃|C^
 * @param	to		Rs[REGULATIONւ̃|C^
 */
//----------------------------------------------------------
void Regulation_Copy(const REGULATION *pFrom, REGULATION* pTo)
{
	MI_CpuCopy8(pFrom, pTo, sizeof(REGULATION));
}

//----------------------------------------------------------
/**
 * @brief	REGULATION̔r
 * @param	cmp1   rREGULATIONւ̃|C^
 * @param	cmp2   rREGULATIONւ̃|C^
 * @return  vĂTRUE
 */
//----------------------------------------------------------
int Regulation_Cmp(const REGULATION* pCmp1,const REGULATION* pCmp2)
{
    int i,size = sizeof(REGULATION);
    const u8* pc1 = (const u8*)pCmp1;
    const u8* pc2 = (const u8*)pCmp2;

    for(i = 0; i < size; i++){
        if(*pc1 != *pc2){
            return FALSE;
        }
        pc1++;
        pc2++;
    }
    return TRUE;
}

//============================================================================================
//
//	REGULATION̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ogM[Vf[^̏
 * @param	pReg		REGULATION[Nւ̃|C^
 */
//----------------------------------------------------------
void Regulation_Init(REGULATION* pReg)
{
	memset(pReg, 0, sizeof(REGULATION));
}

//----------------------------------------------------------
/**
 * @brief	JbvZbg
 * @param	pReg	REGULATION[N|C^
 * @param	pCupBuf	Jbvobt@
 */
//----------------------------------------------------------
void Regulation_SetCupName(REGULATION* pReg, const STRBUF *pCupBuf)
{
    STRBUF_GetStringCode(pCupBuf, pReg->cupName, (REGULATION_NAME_SIZE + EOM_SIZE));
}

//----------------------------------------------------------
/**
 * @brief	Jbv擾
 * @param	pReg		    REGULATION[N|C^
 * @param	pReturnCupName	JbvSTRBUF|C^
 * @return	none
 */
//----------------------------------------------------------
void Regulation_GetCupName(const REGULATION* pReg,STRBUF* pReturnCupName)
{
    STRBUF_SetStringCodeOrderLength(pReturnCupName, pReg->cupName, (REGULATION_NAME_SIZE + EOM_SIZE));
}

//----------------------------------------------------------
/**
 * @brief	JbvO擾iSTRBUF𐶐j
 * @param	pReg	[Nւ̃|C^
 * @param	heapID	STRBUF𐶐q[vID
 * @return	STRBUF	Oi[STRBUFւ̃|C^
 */
//----------------------------------------------------------
STRBUF* Regulation_CreateCupName(const REGULATION* pReg, int heapID)
{
	STRBUF* tmpBuf = STRBUF_Create((REGULATION_NAME_SIZE + EOM_SIZE), heapID);
	STRBUF_SetStringCode( tmpBuf, pReg->cupName );
	return tmpBuf;
}

//----------------------------------------------------------
/**
 * @brief	p[^[擾
 * @param	pReg	REGULATION[N|C^
 * @param	type	REGULATION_PARAM_TYPE enum ̂ǂꂩ
 */
//----------------------------------------------------------
int Regulation_GetParam(const REGULATION* pReg, REGULATION_PARAM_TYPE type)
{
    int ret = 0;

    switch(type){
      case REGULATION_POKE_NUM:      //|P
        ret = pReg->num;
        break;
      case REGULATION_LEVEL:         //|P̃x
        ret = pReg->level;
        break;
      case REGULATION_TOTAL_LEVEL:   //|P̃xv
        ret = pReg->totalLevel;
        break;
      case REGULATION_EVOLUTION:     //iO
        ret = pReg->evolution;
        break;
      case REGULATION_HEIGHT:        //g
        ret = pReg->height;
        break;
      case REGULATION_HEIGHT_LIMIT:  //g  -1,0,1
        if(pReg->height>0){
            ret = 1;   // ȏ
        }
        else if(pReg->height<0){
            ret = -1;  // ȉ
        }
        break;
      case REGULATION_WEIGHT:       //̏d
        ret = pReg->weight;
        break;
      case REGULATION_WEIGHT_LIMIT:   //̏d  -1,0,1
        if(pReg->weight>0){
            ret = 1;   // ȏ
        }
        else if(pReg->weight<0){
            ret = -1;  // ȉ
        }
        break;
      case REGULATION_BOTH_ITEM:    //njH
        ret = pReg->bBothItem;
        break;
      case REGULATION_BOTH_MONSTER: //|PnjH
        ret = pReg->bBothMonster;
        break;
      case REGULATION_LEGEND:       // `nL
        ret = pReg->bLegend;
        break;
    }
    return ret;
}

//----------------------------------------------------------
/**
 * @brief	p[^[
 * @param	pReg	REGULATION[N|C^
 * @param	type	REGULATION_PARAM_TYPE enum ̂ǂꂩ
 * @param	param	ޒl
 * @return  񂾂TRUE  sȒl̏ꍇFALSE
 */
//----------------------------------------------------------
BOOL Regulation_SetParam(REGULATION* pReg, REGULATION_PARAM_TYPE type, int param)
{
    switch(type){
      case REGULATION_POKE_NUM:      //|P
        GF_ASSERT_RETURN(param <= _REG_NUM_MAX,FALSE);
        GF_ASSERT_RETURN(param >= _REG_NUM_MIN,FALSE);
        pReg->num = param;
        break;
      case REGULATION_LEVEL:         //|P̃x
        GF_ASSERT_RETURN(param <= _REG_LEVEL_MAX,FALSE);
        GF_ASSERT_RETURN(param >= _REG_LEVEL_MIN,FALSE);
        pReg->level = param;
        break;
      case REGULATION_TOTAL_LEVEL:   //|P̃xv
        GF_ASSERT_RETURN(param <= _REG_TOTAL_LEVEL_MAX,FALSE);
        GF_ASSERT_RETURN(param >= _REG_TOTAL_LEVEL_MIN,FALSE);
        pReg->totalLevel = param;
        break;
      case REGULATION_EVOLUTION:     //iO
        pReg->evolution = param;
        break;
      case REGULATION_HEIGHT:        //g
        pReg->height = param;
        break;
      case REGULATION_HEIGHT_LIMIT:  //g  -1,0,1
        if((param == 1) && (pReg->height < 0)){
            pReg->height = -pReg->height;
        }
        else if((param == -1) && (pReg->height > 0)){
            pReg->height = -pReg->height;
        }
        else{
            pReg->height = 0;
        }
        break;
      case REGULATION_WEIGHT:       //̏d
        GF_ASSERT_RETURN(param <= _REG_WEIGHT_MAX, FALSE);
        GF_ASSERT_RETURN(param >= _REG_WEIGHT_MIN, FALSE);
        pReg->weight;
        break;
      case REGULATION_WEIGHT_LIMIT:   //̏d  -1,0,1
        if((param == 1) && (pReg->weight < 0)){
            pReg->weight = -pReg->weight;
        }
        else if((param == -1) && (pReg->weight > 0)){
            pReg->weight = -pReg->weight;
        }
        else{
            pReg->weight = 0;
        }
        break;
      case REGULATION_BOTH_ITEM:    //njH
        pReg->bBothItem = param;
        break;
      case REGULATION_BOTH_MONSTER: //|PnjH
        pReg->bBothMonster = param;
        break;
      case REGULATION_LEGEND:       // `nL
        pReg->bLegend = param;
        break;
    }
    return TRUE;
}

//----------------------------------------------------------
/**
 * @brief	M[Vf[^ւ̃|C^擾
 * @param	pSave    	Z[uf[^ێ[Nւ̃|C^
 * @return	REGULATION	[Nւ̃|C^
 */
//----------------------------------------------------------
REGULATION* SaveData_GetRegulation(SAVEDATA* pSave)
{
	REGULATION* pReg = NULL;
    
    GF_ASSERT(0);   // @@OOZ[uf[^֓o^܂łĂ܂
//	my = SaveData_Get(sv, GMDATA_ID_REGULATION);
	return pReg;
}

