//============================================================================================
/**
 * @file	regulation_local.h
 * @brief	ogM[Vwb_[(̃fBNĝ݂ł̂ݎQƉ)
 * @author	k.ohno
 * @date	2006.1.20
 */
//============================================================================================

#ifndef __REGULATION_LOCAL_H__
#define __REGULATION_LOCAL_H__

//============================================================================================

#include "savedata/regulation.h"

//----------------------------------------------------------
/**
 * @brief	ogM[Vf[^^`
 */
//----------------------------------------------------------
struct _REGULATION {
	STRCODE cupName[REGULATION_NAME_SIZE + EOM_SIZE];
	u8 num;
	u8 level;
	u8 totalLevel;
    s8 height;
    s8 weight;
    u8 evolution:2;    //  
    u8 bBothItem:1;
    u8 bBothMonster:1;
    u8 bLegend:1;
};


//----------------------------------------------------------
/**
 * @brief	ef[^͈̋
 */
//----------------------------------------------------------
#define _REG_NUM_MAX   (6)    // Qlő
#define _REG_NUM_MIN   (1)    // Qlŏ
#define _REG_LEVEL_MAX   (100)    // levelő
#define _REG_LEVEL_MIN   (1)    // levelŏ
#define _REG_TOTAL_LEVEL_MAX   (_REG_NUM_MAX*_REG_LEVEL_MAX)    // totallevelő
#define _REG_TOTAL_LEVEL_MIN   (_REG_NUM_MIN*_REG_LEVEL_MIN)    // totallevelŏ
#define _REG_WEIGHT_MAX   (99)    // weightő
#define _REG_WEIGHT_MIN   (-99)    // weightŏ


//============================================================================================

#endif //__REGULATION_LOCAL_H__

