//=============================================================================
/**
 * @file	savedata.c
 * @brief	Z[uf[^Ǘ
 * @author	tamada	GAME FREAK Inc.
 * @date	2005.10.12
 */
//=============================================================================

#include "common.h"
#include "gflib/system.h"


#include "system/gamedata.h"

#include "savedata/savedata.h"


//Z[uf[^êɕKvȊ֐QƂ̂߂̃wb_

#include "poketool/poke_tool.h"
#include "../poketool/poke_tool_def.h"

#include "poketool/pokeparty.h"
#include "itemtool/myitem.h"
#include "field/eventflag.h"
#include "field/poketch_data.h"
#include "field/situation.h"
#include "savedata/zukanwork.h"
#include "savedata/sodateyadata.h"
#include "savedata/friendlist.h"
#include "savedata/undergrounddata.h"
#include "savedata/imageclip_data.h"
#include "savedata/honeytree_data.h"
#include "savedata/wifilist.h"

#include "savedata/mail_util.h"
#include "savedata/poruto_util.h"
#include "poketool/boxdata.h"

#include "misc_local.h"


BOOL PMSVLD_Init(void);
BOOL PMSVLD_Save(u32 src, void * dst, u32 len);
BOOL PMSVLD_Load(u32 src, void * dst, u32 len);

//=============================================================================
//=============================================================================

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#define MAGIC_NUMBER	(0x20060220)
#define	PAGE_SIZE	(0x1000)
#define	PAGE_MAX	(31)

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
typedef int (*FUNC_GET_SIZE)(void);

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
typedef void (*FUNC_INIT_WORK)(void *);

typedef enum {
	BLOCK_ID_NORMAL = 0,
	BLOCK_ID_BOX,
}BLOCK_ID;

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^ef[^p̍\̒`
 */
//---------------------------------------------------------------------------
typedef struct {
	GMDATA_ID gmdataID;				///<Z[uf[^ID
	BLOCK_ID	blockID;
	FUNC_GET_SIZE get_size;			///<Z[uf[^TCY擾֐
	FUNC_INIT_WORK	init_work;		///<Z[uf[^֐
}SAVEDATA_TABLE;

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^ubNւ̃|C^
 */
//---------------------------------------------------------------------------
typedef struct {
	GMDATA_ID gmdataID;	///<Z[uf[^ID
	u32 size;			///<f[^TCYi[
	u32 address;		///<f[^Jnʒu
	u32 crc;			///<G[opCRCR[hi[
}SVWK_INDEX;

//---------------------------------------------------------------------------
/**
 * @brief	Z[u[N\
 *
 * ۂ̃Z[u镔̍\
 */
//---------------------------------------------------------------------------
typedef struct {
	u32 magic_number;				///<Z[uf[^
	u32 total_size;					///<Z[uf[^̑S̃TCY
	u32 crc;						///<Z[uf[^ŜCRC
	u8 data[PAGE_SIZE * PAGE_MAX];	///<ۂ̃f[^ێ̈
}SAVEWORK;


//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^\
 *
 * Z[uf[^̂ƁAp[N܂Ƃ߂
 */
//---------------------------------------------------------------------------
struct _SAVEDATA {
	BOOL flash_exists;			///<obNAbvFLASH݂邩ǂ
	BOOL data_exists;			///<f[^݂邩ǂ
	BOOL new_data_flag;			///<u傩ṽf[^ǂ
	MATHCRC16Table crc_table;	///<CRCZope[u
	SVWK_INDEX svwk_idx[GMDATA_ID_MAX];
	SAVEWORK svwk;				///<Z[uf[^{
	//BOX_DATA* boxdata;
};

//=============================================================================
//
//		f[^
//
//=============================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^e`
 */
//---------------------------------------------------------------------------
static const SAVEDATA_TABLE SaveDataTable[] = {
	{	//莝|P
		GMDATA_ID_TEMOTI_POKE,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)PokeParty_GetWorkSize,
		(FUNC_INIT_WORK)PokeParty_InitWork,
	},
	{	//莝ǂ
		GMDATA_ID_TEMOTI_ITEM,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)MyItem_GetWorkSize,
		(FUNC_INIT_WORK)MyItem_Init,
	},
	{	//Cxg[N
		GMDATA_ID_EVENT_WORK,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)EventWork_GetWorkSize,
		(FUNC_INIT_WORK)EventWork_Init,
	},
	{	//|Pb`f[^
		GMDATA_ID_POKETCH_DATA,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)PoketchData_GetWorkSize,
		(FUNC_INIT_WORK)PoketchData_Init,
	},
	{	//󋵃f[^
		GMDATA_ID_SITUATION,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)Situation_GetWorkSize,
		(FUNC_INIT_WORK)Situation_Init,
	},
	{	//f[^
		GMDATA_ID_ZUKANWORK,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)ZukanWork_GetWorkSize,
		(FUNC_INIT_WORK)ZukanWork_Init,
	},
	{	//ĉf[^
		GMDATA_ID_SODATEYA,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)SodateyaWork_GetWorkSize,
		(FUNC_INIT_WORK)SodateyaWork_Init,
	},
	{	//肠O[v
		GMDATA_ID_FRIEND,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)FriendList_GetWorkSize,
		(FUNC_INIT_WORK)FriendList_Init,
	},
	{	//̑f[^
		GMDATA_ID_MISC,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)MISC_GetWorkSize,
		(FUNC_INIT_WORK)MISC_Init,
	},
	{	//tB[hOBJZ[u
		GMDATA_ID_FIELDOBJSV,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)FieldObjSv_GetWorkSize,
		(FUNC_INIT_WORK)FieldObjSv_Init,
	},
	{	//nACef[^+閧nf[^
		GMDATA_ID_UNDERGROUNDDATA,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)UnderGroundData_GetWorkSize,
		(FUNC_INIT_WORK)UnderGroundData_Init,
	},
	{	//|P{bNX̃f[^
		GMDATA_ID_BOXDATA,
		BLOCK_ID_BOX,
		(FUNC_GET_SIZE)BOXDAT_GetTotalSize,
		(FUNC_INIT_WORK)BOXDAT_Init,
	},
	{	//C[WNbṽf[^
		GMDATA_ID_IMAGECLIPDATA,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)ImcSaveData_GetWorkSize,
		(FUNC_INIT_WORK)ImcSaveData_Init,
	},
	{	//hGJEgpf[^
		GMDATA_ID_HONEYTREE,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)HTSave_GetSaveDataSize,
		(FUNC_INIT_WORK)HTSave_InitSaveData,
	},
	{	// WifipAEFB
		GMDATA_ID_WIFILIST,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)WifiList_GetWorkSize,
		(FUNC_INIT_WORK)WifiList_Init,
	},
	{	//[̃f[^
		GMDATA_ID_MAILDATA,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)MAIL_GetBlockWorkSize,
		(FUNC_INIT_WORK)MAIL_Init,
	},
	{	//|g̃f[^
		GMDATA_ID_PORUTODATA,
		BLOCK_ID_NORMAL,
		(FUNC_GET_SIZE)PORUTO_GetSaveWorkSize,
		(FUNC_INIT_WORK)PORUTO_Init,
	},
};

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
static const int SaveDataTableMax = NELEMS(SaveDataTable);


//=============================================================================
//
//			ϐ
//
//=============================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^\̂ւ̃|C^
 *
 * ̃t@CŗBÓImۂϐB
 * Q[JnɏB
 */
//---------------------------------------------------------------------------
static SAVEDATA * SvPointer;


//=============================================================================
//=============================================================================
static void SVDT_Init(SAVEWORK * svwk);
static void SVDT_MakeIndex(SVWK_INDEX * svwk_idx);
static int SVDT_GetDefineSize(void);
static u16 GetCRC(const SAVEDATA * sv);
static BOOL SaveData_CheckCRC(const SAVEDATA * sv);

//=============================================================================
//=============================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^\̏
 */
//---------------------------------------------------------------------------
SAVEDATA * SaveData_System_Init(void)
{
	SAVEDATA * sv;
	BOOL result;

	sv = sys_AllocMemory(HEAPID_BASE_SAVE, sizeof(SAVEDATA));
	memset(sv, 0, sizeof(SAVEDATA));
	SvPointer = sv;
	sv->flash_exists = PMSVLD_Init();
	sv->data_exists = FALSE;
	sv->new_data_flag = TRUE;
	MATH_CRC16CCITTInitTable(&sv->crc_table);
	SVDT_MakeIndex(sv->svwk_idx);

	//sv->boxdata = BOXDAT_Create( HEAPID_BASE_SAVE );

	//Ƃ肠Af[^݃`FbNsĂ
	//Ƃ悢݃`FbN@Load炨邱
	result = SaveData_Load(sv);
	if (!result) {
		SaveData_ClearData(sv);
	}

	return sv;
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^ւ̃|C^擾
 * @return	SAVEDATA	Z[uf[^\ւ̃|C^
 *
 * {Iɂ̓Z[uf[^ւ̃O[oQƂ͔B̂߁Å֐
 * gpӏ͌dɐȂ΂ȂȂBł΃vO}[_[
 * ȂΎgpłȂ悤ɂB
 * ςȃANZXC܂Bgp@ɂ͒ӂĂB
 */
//---------------------------------------------------------------------------
SAVEDATA * SaveData_GetPointer(void)
{
	SAVEWORK * svwk = &SvPointer->svwk;
	GF_ASSERT(SvPointer != NULL);
	GF_ASSERT(svwk->magic_number == MAGIC_NUMBER);	//
	//GF_ASSERT(svwk->total_size == 0);	//
	//GF_ASSERT(svwk->crc == 0);	//
	return SvPointer;
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̃TCY擾
 * @return	u32	Z[uf[^̑傫
 */
//---------------------------------------------------------------------------
u32 SaveData_GetSize(void)
{
	return sizeof(SAVEDATA);
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^ij̃|C^擾
 * @param	sv			Z[uf[^\ւ̃|C^
 * @param	gmdataID	擾Z[uf[^ID
 * @return	KvȃZ[üւ̃|C^
 */
//---------------------------------------------------------------------------
void * SaveData_Get(SAVEDATA * sv, GMDATA_ID gmdataID)
{
	const SVWK_INDEX * idx = sv->svwk_idx;
	int i;
	for (i = 0; i < SaveDataTableMax; i++) {
		if (idx[i].gmdataID == gmdataID) {
			return &(sv->svwk.data[idx[i].address]);
		}
	}
	GF_ASSERT(0);
	return NULL;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
const void * SaveData_GetReadOnlyData(const SAVEDATA * sv, GMDATA_ID gmdataID)
{
	return SaveData_Get((SAVEDATA *)sv, gmdataID);
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̏
 * @param	sv			Z[uf[^\ւ̃|C^
 * @retval	TRUE		ݐ
 * @retval	FALSE		ݎs
 *
 * Z[uf[^NAŃtbVɏށB
 */
//---------------------------------------------------------------------------
BOOL SaveData_Erase(SAVEDATA * sv)
{
	BOOL result;
	//NAf[^FLASHɏ
	memset(&sv->svwk, 0, sizeof(SAVEWORK));
	result = PMSVLD_Save(0, &sv->svwk, sizeof(SAVEWORK));
	sv->data_exists = FALSE;

	SaveData_ClearData(sv);
	return result;
}

//---------------------------------------------------------------------------
/**
 * @brief	[h
 * @param	sv			Z[uf[^\ւ̃|C^
 * @retval	TRUE		ǂݍݐ
 * @retval	FALSE		ǂݍݎs
 */
//---------------------------------------------------------------------------
BOOL SaveData_Load(SAVEDATA * sv)
{
	BOOL result;
	if (!sv->flash_exists) {
		return FALSE;
	}
	result = PMSVLD_Load(0, &sv->svwk, sizeof(SAVEWORK));
	if (!result) {
		return FALSE;
	}
	result = SaveData_CheckCRC(sv);
	if (result) {
		sv->new_data_flag = FALSE;
		sv->data_exists = TRUE;
	}
	return TRUE;
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[u
 * @param	sv			Z[uf[^\ւ̃|C^
 * @retval	TRUE		ݐ
 * @retval	FALSE		ݎs
 */
//---------------------------------------------------------------------------
BOOL SaveData_Save(SAVEDATA * sv)
{
	BOOL result;

	if (!sv->flash_exists) {
		return FALSE;
	}
	sv->svwk.magic_number = MAGIC_NUMBER;
	sv->svwk.crc = GetCRC(sv);
	result = PMSVLD_Save(0, &sv->svwk, sizeof(SAVEWORK));
	if (result) {
		sv->new_data_flag = FALSE;
		sv->data_exists = TRUE;
	}
	return TRUE;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
static BOOL SaveData_CheckCRC(const SAVEDATA * sv)
{
	u16 crc;
	if (!sv->flash_exists) {
		return FALSE;
	}
	crc = GetCRC(sv);
	if (sv->svwk.crc != crc) {
		return FALSE;
	}
	if (sv->svwk.total_size != SVDT_GetDefineSize()) {
		return FALSE;
	}
	if (sv->svwk.magic_number != MAGIC_NUMBER) {
		return FALSE;
	}
	return TRUE;
}
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̏
 * @param	sv			Z[uf[^\ւ̃|C^
 *
 * SaveData_EraseƈႢAtbVɏ܂ȂB
 * Z[uf[^ԂŁu傩vVԏꍇȂǂ̏
 */
//---------------------------------------------------------------------------
void SaveData_ClearData(SAVEDATA * sv)
{
	sv->new_data_flag = TRUE;
	SVDT_Init(&sv->svwk);
	SVDT_MakeIndex(sv->svwk_idx);
	//BOXDAT_Init( sv->boxdata );
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^݃tO擾
 * @param	sv			Z[uf[^\ւ̃|C^
 * @return	BOOL		TRUÊƂAZ[uf[^݂
 */
//---------------------------------------------------------------------------
BOOL SaveData_GetExistFlag(const SAVEDATA * sv)
{
	return sv->data_exists;
}

//---------------------------------------------------------------------------
/**
 * @brief	VKQ[Ԃ擾
 * @param	sv			Z[uf[^\ւ̃|C^
 * @param	BOOL		TRUÊƂAVKQ[ił܂Z[uĂȂj
 */
//---------------------------------------------------------------------------
BOOL SaveData_GetNewDataFlag(const SAVEDATA * sv)
{
	return sv->new_data_flag;
}

//---------------------------------------------------------------------------
/**
 * @brief	{bNXf[^̃|C^擾
 * @param	sv			Z[uf[^\ւ̃|C^
 * @return	BOX_DATA	{bNXf[^ւ̃|C^
 */
//---------------------------------------------------------------------------
BOX_DATA * SaveData_GetBoxData(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_BOXDATA);
	//return sv->boxdata;
}

//=============================================================================
//=============================================================================
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
static int GetWorkSize(int id)
{
	int size;
	const SAVEDATA_TABLE * table = SaveDataTable;
	GF_ASSERT(id < SaveDataTableMax);
	size = table[id].get_size();
	size += 4 - (size % 4);
	return size;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
static u16 GetCRC(const SAVEDATA * sv)
{
	return MATH_CalcCRC16CCITT(&sv->crc_table, &sv->svwk.data, PAGE_SIZE * PAGE_MAX);
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
static void SVDT_MakeIndex(SVWK_INDEX * svwk_idx)
{
	const SAVEDATA_TABLE * table = SaveDataTable;
	int i;
	int block_id = -1;
	int total_size = 0;


	GF_ASSERT(SaveDataTableMax == GMDATA_ID_MAX - 1);

	for (i = 0; i < SaveDataTableMax; i++) {
		svwk_idx[i].gmdataID = table[i].gmdataID;
		svwk_idx[i].size = GetWorkSize(i);
		svwk_idx[i].address = total_size;
		svwk_idx[i].crc = 0;
		total_size += svwk_idx[i].size;
	}
	OS_Printf("%x <= %x\n", total_size, PAGE_MAX * PAGE_SIZE);
	GF_ASSERT(total_size <= PAGE_MAX * PAGE_SIZE);
}
//---------------------------------------------------------------------------
/**
 * @brief	Z[uf[^̃NA
 * @param	svwk	Z[u[Nւ̃|C^
 */
//---------------------------------------------------------------------------
static void SVDT_Init(SAVEWORK * svwk)
{
	const SAVEDATA_TABLE * table = SaveDataTable;
	int i;
	int size;
	int total_size = 0;
	void * page;


	//GF_ASSERT(SaveDataTableMax <= PAGE_MAX);
	MI_CpuClear32(svwk->data, sizeof(svwk->data));
	//OS_Printf("Clear %x bytes\n", sizeof(svwk->data));

	for (i = 0; i <SaveDataTableMax; i++) {
		page = &svwk->data[total_size];
		size = GetWorkSize(i);
		MI_CpuClear32(page, size);
		table[i].init_work(page);
		total_size += size;
		OS_Printf("SAVE:%02d:%08x:%04x\n",i, page, size);
	}
	OS_Printf("SAVE:TOTAL:%4x\n", total_size);

	svwk->magic_number = MAGIC_NUMBER;
	svwk->total_size = total_size;
	svwk->crc = 0;

}

//---------------------------------------------------------------------------
/**
 * @brief	SZ[uf[^̃g[^TCY擾
 * @return	int		SZ[uf[^̃TCY
 *
 * ۂ̃Z[uɕKvȗ̈͂Ƒ傫B
 * PɃZ[uf[^̓eύXʂ邽߂ɎgpĂB
 */
//---------------------------------------------------------------------------
static int SVDT_GetDefineSize(void)
{
	int i;
	int size;
	int total_size = 0;
	for (i = 0; i < SaveDataTableMax; i++) {
		size = GetWorkSize(i);
		total_size += size;
	}
	return total_size;
}


//=============================================================================
//=============================================================================


//---------------------------------------------------------------------------
/**
 * @brief	obNAbvtbV̓mF
 * @retval	TRUE	obNAbvtbVɓ삷
 * @retval	FALSE	퓮삵Ȃi݂ȂAႤނ̃obNAbvfoCXj
 */
//---------------------------------------------------------------------------
BOOL PMSVLD_Init(void)
{
	s32 lock_id;
	BOOL result;

	lock_id = OS_GetLockID();
	GF_ASSERT(lock_id != OS_LOCK_ID_ERROR);
	CARD_LockBackup(lock_id);

	result = CARD_IdentifyBackup(CARD_BACKUP_TYPE_FLASH_2MBITS);

	CARD_UnlockBackup(lock_id);
	OS_ReleaseLockID(lock_id);

	if (result) {
		OS_Printf("Identified 2M FLASH\n");
	}

	return result;
}

//---------------------------------------------------------------------------
/**
 * @brief	Z[u
 */
//---------------------------------------------------------------------------
BOOL PMSVLD_Save(u32 src, void * dst, u32 len)
{
	s32 lock_id;
	BOOL result;

	lock_id = OS_GetLockID();
	GF_ASSERT(lock_id != OS_LOCK_ID_ERROR);
	CARD_LockBackup(lock_id);

	result = CARD_WriteAndVerifyFlash(src, dst, len);

	CARD_UnlockBackup(lock_id);
	OS_ReleaseLockID(lock_id);

	return result;
}

//---------------------------------------------------------------------------
/**
 * @brief	[h
 */
//---------------------------------------------------------------------------
BOOL PMSVLD_Load(u32 src, void * dst, u32 len)
{
	s32 lock_id;
	BOOL result;

	lock_id = OS_GetLockID();
	GF_ASSERT(lock_id != OS_LOCK_ID_ERROR);
	CARD_LockBackup(lock_id);

	result = CARD_ReadFlash(src, dst, len);

	CARD_UnlockBackup(lock_id);
	OS_ReleaseLockID(lock_id);

	return result;
}

