//============================================================================================
/**
 * @file	seedbed.c
 * @author	tamada
 * @date	2005.02.01
 * @brief	̂ݏԃf[^
 */
//============================================================================================

#include "common.h"

#include "seedbed_local.h"
#include "savedata/seedbed.h"

#include "gflib/system.h"
#include "itemtool/nuts.h"

#ifdef	DEBUG_ONLY_FOR_tamada
#define	PUT_SEED_INFO(s,i)	PrintSeedInfo((s),(i))
#else
#define	PUT_SEED_INFO(s,i)	/* Do Nothing */
#endif

//============================================================================================
//				`
//============================================================================================
enum {
		///JԂő吔
		SEED_ROUND_MAX		=	10,

		///ȂԂł̐ԌW
		FRUIT_TIME_RATE		=	4,

		///	yHPől
		GROUND_HP_MAX	= 100,

		///	̂HP̏l
		SEED_HP_MAX = 10,
};

static void InitSeed(SEEDBED * s);
//============================================================================================
//
//
//		Z[uf[^C^[tFCX
//
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	̂ݏԃf[^TCY̎擾
 * @return	int		̂ݏԃf[^̃TCY
 */
//----------------------------------------------------------
int SEEDBED_GetWorkSize(void)
{
	return sizeof(SEEDBED) * SEEDBED_MAX;
}

//----------------------------------------------------------
/**
 * @brief	̂ݏԃf[^pm
 * @param	heapID		mۂq[v̎w
 * @return	SEEDBED		̂ݏԃf[^Ŝւ̃|C^
 */
//----------------------------------------------------------
SEEDBED * SEEDBED_AllocWork(u32 heapID)
{
	SEEDBED * sbed;
	sbed = sys_AllocMemory(heapID, sizeof(SEEDBED) * SEEDBED_MAX);
	return sbed;
}

//----------------------------------------------------------
/**
 * @brief	̂ݏԃf[^Ŝ̏
 * @param	SEEDBED		̂ݏԃf[^Ŝւ̃|C^
 */
//----------------------------------------------------------
void SEEDBED_Init(SEEDBED * sbed)
{
	int i;
	MI_CpuClear8(sbed, sizeof(SEEDBED) * SEEDBED_MAX);

	for (i = 0; i < SEEDBED_MAX; i++) {
		sbed[i].stat = SEEDSTAT_NOTHING;
		sbed[i].type = 0;
#ifdef	PM_DEBUG
		if (i < 4) {
			InitSeed(&sbed[i]);
			sbed[i].stat = SEEDSTAT_FRUIT;
			sbed[i].type = 1;
			sbed[i].nuts_count = 2;
			sbed[i].ground_hp = GROUND_HP_MAX;
			sbed[i].seed_hp = SEED_HP_MAX;
		}
#endif
	}
}

//----------------------------------------------------------
/**
 * @brief	̂ݐpe[u̐
 * @param	heapID
 */
//----------------------------------------------------------
SEED_TABLE * SEEDBED_CreateParamTable(int heapID)
{
	int i;
	SEED_TABLE * tbl;
	NUTSDATA * data;
	tbl = sys_AllocMemory(heapID, sizeof(SEED_TABLE) * ITEM_NUTS_MAX);
	for (i = 0; i < ITEM_NUTS_MAX; i++) {
		data = Nuts_DataLoad(i, heapID);
		tbl[i].grow_speed = Nuts_ParamGet(data, NUTS_PRM_SPEED);
		tbl[i].root_power = Nuts_ParamGet(data, NUTS_PRM_ABSORPTION);
		tbl[i].nuts_rate = Nuts_ParamGet(data, NUTS_PRM_MAGNIFICATION);
		sys_FreeMemoryEz(data);
	}
	return tbl;
}



//============================================================================================
//
//		c[֐
//
//============================================================================================
#ifdef	PM_DEBUG
//----------------------------------------------------------
/**
 * @brief	fobO̕\
 * @param	bed
 * @param	i
 */
//----------------------------------------------------------
static void PrintSeedInfo(const SEEDBED * bed, int i)
{
	const SEEDBED * s = bed + i;
	if (s->stat == SEEDSTAT_NOTHING) {
		return;
	}
	OS_Printf("SEED (ID:%03d) FLAG:%d STAT:%d TYPE:%02d\n",
			i, s->growth_flag, s->stat, s->type);
	OS_Printf("     COMPOST:%d GROUND:%03d NUTS:%d\n",
			s->compost, s->ground_hp, s->nuts_count);
	OS_Printf("     HP:%02d ROUND:%d gtime:%d dtime:%d\n",
			s->seed_hp, s->seed_count,s->grow_time, s->dry_time);
}
#endif

//----------------------------------------------------------
/**
 * @brief	̂݃f[^
 * @param	s	̂ݏԃf[^ւ̃|C^
 */
//----------------------------------------------------------
static void InitSeed(SEEDBED * s)
{
	s->type = 0;
	s->stat = SEEDSTAT_NOTHING;
	s->grow_time = 0;
	s->dry_time = 0;
	s->seed_count = 0;
	s->nuts_count = 0;
	s->ground_hp = 0;
	s->seed_hp = 0;
	s->compost = SEEDCOMPOST_NOTHING;
	s->growth_flag = FALSE;
}

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
static int count_nuts(SEEDBED * s, const SEED_TABLE * prm)
{
	//؂̎HP@~@̔{
	return	prm[s->type -1].nuts_rate * s->seed_hp;
}

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
static int get_grow_time(const SEED_TABLE * prm, int type, int compost)
{
	int time;
	time = prm[type - 1].grow_speed * 60;
	if (compost == SEEDCOMPOST_SUKUSUKU) {
		time = (time * 3) / 4;		// base * 0.75
	} else if (compost == SEEDCOMPOST_YURURI) {
		time = time + (time / 2);	// base * 1.5
	}
	return time;
}
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
static int get_root_power(const SEED_TABLE * prm, int type, int compost)
{
	int power = prm[type - 1].root_power;
	if (compost == SEEDCOMPOST_YURURI) {
		return power / 2;
	} else if (compost == SEEDCOMPOST_SUKUSUKU) {
		return power + power / 2;
	} else {
		return power;
	}
}
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
static int get_nuts_time_rate(const SEEDBED * s)
{
	//~i[RVgĂƂAĂ鎞Ԃ1.5{ɂȂ
	if (s->compost == SEEDCOMPOST_MINAARU) {
		return FRUIT_TIME_RATE + 2;
	} else {
		return FRUIT_TIME_RATE;
	}
}
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
static int get_round_max(const SEEDBED * s)
{
	//˂΂肱₵gĂƂAT񑝂
	if (s->compost == SEEDCOMPOST_NEBARI) {
		return SEED_ROUND_MAX + 5;
	} else {
		return SEED_ROUND_MAX;
	}
}

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
static int get_life_time(SEEDBED * s)
{
	//JԂď܂ł̒
	//ŏ̓y̒+i+s++) * SEED_ROUND_MAX;
	//LIFE_TIME_LEN		=	1+(1+1+1+FRUIT_TIME_RATE) * SEED_ROUND_MAX,
	return 1 + (1+1+1+get_nuts_time_rate(s)) * get_round_max(s);
}



//============================================================================================
//
//
//		̂ݏԃANZXpOJ֐
//
//
//============================================================================================

//----------------------------------------------------------
/**
 * @brief	݂̂̏Ԏ擾
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @return	SEEDSTAT	݂̂̏ԁiseedbed.h̒`QƁj
 */
//----------------------------------------------------------
SEEDSTAT SEEDBED_GetSeedStatus(const SEEDBED * sbed, int id)
{
	return sbed[id].stat;
}
//----------------------------------------------------------
/**
 * @brief	݂̂̎ނ擾
 * @param	sbed		̂ݏԃf[^ւ̃|C^
 * @param	id			݂̂w肷ID
 * @return	int			݂̂̎ށiO`ITEM_NUTS_MAX)
 */
//----------------------------------------------------------
int SEEDBED_GetSeedType(const SEEDBED * sbed, int id)
{
	return sbed[id].type;
}
//----------------------------------------------------------
/**
 * @brief	̏Ԃ擾
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @return	SEEDGROUND	ԁiseedbed.h̒`QƁj
 */
//----------------------------------------------------------
SEEDGROUND SEEDBED_GetGroundStatus(const SEEDBED * sbed, int id)
{
	int gr_hp;
	gr_hp = sbed[id].ground_hp;

	if (gr_hp == 0) {
		return SEEDGROUND_DRY;
	} else if (gr_hp <= 50) {
		return SEEDGROUND_WET;
	} else {
		return SEEDGROUND_FULL;
	}
}

//----------------------------------------------------------
/**
 * @brief	݂̂A
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @param	prm			݂̂̎ޖp[^e[u
 * @param	type		݂̂̎
 */
//----------------------------------------------------------
void SEEDBED_SetNuts(SEEDBED * sbed, int id, const SEED_TABLE * prm, int type)
{
	//InitSeed(&sbed[id]);
	sbed[id].type = type;
	sbed[id].stat = SEEDSTAT_UNDERGROUND;
	sbed[id].grow_time = get_grow_time(prm, type, sbed[id].compost);
	sbed[id].dry_time = 0;
	sbed[id].seed_count = 0;
	sbed[id].nuts_count = 0;
	sbed[id].ground_hp = GROUND_HP_MAX;
	sbed[id].seed_hp = SEED_HP_MAX;
	//sbed[id].compost = co;
	sbed[id].growth_flag = TRUE;
	PUT_SEED_INFO(sbed,id);
}


//----------------------------------------------------------
/**
 * @brief	
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 */
//----------------------------------------------------------
void SEEDBED_SetSeedWater(SEEDBED * sbed, int id)
{
	sbed[id].ground_hp = GROUND_HP_MAX;
}

//----------------------------------------------------------
/**
 * @brief	tO̎擾
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @return	BOOL		TRUÊƂA
 */
//----------------------------------------------------------
BOOL SEEDBED_GetGrowthFlag(const SEEDBED * sbed, int id)
{
	return sbed[id].growth_flag;
}

//----------------------------------------------------------
/**
 * @brief	tÕZbg
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @param	flag		TRUÊƂA
 */
//----------------------------------------------------------
void SEEDBED_SetGrowthFlag(SEEDBED * sbed, int id, BOOL flag)
{
#ifdef	DEBUG_ONLY_FOR_tamada
	OS_Printf("SEED:%d %s\n",id, (flag?"ON":"OFF"));
#endif
	sbed[id].growth_flag = flag;
}

//----------------------------------------------------------
/**
 * @brief	RV̎ނ擾
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @param	compost		RV̎w
 */
//----------------------------------------------------------
SEEDCOMPOST SEEDBED_GetCompost(const SEEDBED * sbed, int id)
{
	return sbed[id].compost;
}

//----------------------------------------------------------
/**
 * @brief	RVZbg
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 * @param	compost		RV̎w
 */
//----------------------------------------------------------
void SEEDBED_SetCompost(SEEDBED * sbed, int id, SEEDCOMPOST compost)
{
	sbed[id].compost = compost;
	PUT_SEED_INFO(sbed,id);
}
//----------------------------------------------------------
/**
 * @brief	݂̂̐擾
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 */
//----------------------------------------------------------
int SEEDBED_GetSeedCount(const SEEDBED * sbed, int id)
{
	return sbed[id].nuts_count;
}

//----------------------------------------------------------
/**
 * @brief	݂̂n
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	id			݂̂w肷ID
 */
//----------------------------------------------------------
int SEEDBED_GetHarvest(SEEDBED * sbed, int id)
{
	int harvest;
	harvest = sbed[id].nuts_count;
	InitSeed(&sbed[id]);
	PUT_SEED_INFO(sbed,id);
	return harvest;
}

//-------------------------------------------------------------------------
/**
 * @brief	݂̂Ă
 * @param	sbed		̂ݏԃf[^ւ̃|C^
 * @param	prm		݂̂̎ޖp[^e[u
 */
//-------------------------------------------------------------------------
static void SeedGrowth(SEEDBED *s, const SEED_TABLE * prm)
{
	switch (s->stat) {

	case SEEDSTAT_NOTHING:		// AĂȂ
		GF_ASSERT(0);
		break;

	case SEEDSTAT_UNDERGROUND:	// A
	case SEEDSTAT_HUTABA:		// otA蒼
	case SEEDSTAT_MIKI:			// A
		s->stat ++;
		break;

	case SEEDSTAT_FLOWER:		// 
		s->nuts_count = count_nuts(s, prm);
		s->stat ++;
		break;

	case SEEDSTAT_FRUIT:		// Ȃ
		s->nuts_count = 0;
		s->stat = SEEDSTAT_HUTABA;
		s->seed_count ++;
		if (s->seed_count == get_round_max(s)) {
			InitSeed(s);
		}
		break;
	}
}

//----------------------------------------------------------
/**
 * @brief	݂̂𐬒
 * @param	sbed		̂ݏԃf[^Ŝւ̃|C^
 * @param	prm		݂̂̎ޖp[^e[u
 * @param	minute		i񂾎ԁiPʁj
 */
//----------------------------------------------------------
void SEEDBED_Growth(SEEDBED * sbed, const SEED_TABLE * prm, int minute)
{
	int i;
	s32 count;
	SEEDBED * s;

	for (i = 0; i < SEEDBED_MAX; i++) {
		s = &sbed[i];
		if ( s->type == 0
				|| s->stat == SEEDSTAT_NOTHING
				|| s->growth_flag == FALSE) {
			//ގw肪ȂA؂̎AĂȂAȂꍇ͎
			continue;
		}
		if (minute >= get_grow_time(prm, s->type, s->compost) * get_life_time(s)) {
			//ȏ̎Ԃo߂ꍇ͏
			InitSeed(s);
			continue;
		}

		//JEg
		count = minute;

		while (count != 0) {
			if (s->grow_time > count) {
				s->grow_time -= count;
				count = 0;
				break;
			}else{
				//
				SeedGrowth(s, prm);
				//̒iK܂ł̃JEgZbg
				count -= s->grow_time;
				s->grow_time = get_grow_time(prm, s->type, s->compost);
				if (s->stat == SEEDSTAT_FRUIT) {
					s->grow_time *= get_nuts_time_rate(s);
				}
				PUT_SEED_INFO(sbed,i);
			}
		}

		//zJEg
		count = minute;
		{
			int root_cnt;
			int root_pow;
			root_pow = get_root_power(prm, s->type, s->compost);
			count += s->dry_time;
			root_cnt = count / 60;		//1ԁP|Cg
			s->dry_time = count % 60;	//܂͏WvĂ
			if (s->ground_hp >= root_pow * root_cnt) {
				//ɗ]n̂Ō炷
				s->ground_hp -= root_pow * root_cnt;
			} else {
				//ɗ]nȂȂ̂Ń|CĝHP炷
				root_cnt -= (s->ground_hp / root_pow) + 1;
				if (s->seed_hp > root_cnt) {
					s->seed_hp -= root_cnt;
				} else {
					s->seed_hp = 0;
				}

			}
		}
	}
}


