//============================================================================================
/**
 * @file	undergrounddata.c
 * @brief	nACef[^ANZXp\[X
 * @author	k.ohno
 * @date	2006.2.21
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/undergrounddata.h"
#include "undergrounddata_local.h"

#include "field/ug_itemtype.h"
#include "itemtool/itemsym.h"

//============================================================================================
//============================================================================================



u16 _convertList[] = {
  ITEM_MANMARUISI,         //܂܂	KASEKI_SUN
  ITEM_KANAMEISI,         //Ȃ	KASEKI_SUN
  ITEM_TAIYOUNOISI,        //悤̂	KASEKI_SUN
  ITEM_HOSINOKAKERA,       //ق̂	KASEKI_STAR
  ITEM_TUKINOISI,          //̂	KASEKI_MOON
  ITEM_KATAIISI,           //	KASEKI_HARD
  ITEM_KAMINARINOISI,      //݂Ȃ̂	KASEKI_KAMINARI
  ITEM_KAWARAZUNOISI,      //炸̂	KASEKI_KAWARAZU
  ITEM_HONOONOISI,         //ق̂̂	KASEKI_HONOO
  ITEM_MIZUNOISI,          //݂̂	KASEKI_MIZU
  ITEM_RIIHUNOISI,         //[t̂	KASEKI_REAF
  ITEM_KINNOTAMA,          //̂	KASEKI_GOLD
  ITEM_KAINOKASEKI,        //̃JZL	KASEKI_KAI
  ITEM_KOURANOKASEKI,      //̃JZL	KASEKI_KOURA
  ITEM_TUMENOKASEKI,       //c̃JZL	KASEKI_TSUME
  ITEM_NEKKONOKASEKI,      //˂̃JZL	KASEKI_NEKKO
  ITEM_HIMITUNOKOHAKU,     //Ђ݂̃RnN	KASEKI_KOHAKU
  ITEM_HUTOIHONE,          //ӂƂzl	KASEKI_BONE
};

//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int UnderGroundData_GetWorkSize(void)
{
    return sizeof(UNDERGROUNDDATA);
}

//----------------------------------------------------------
/**
 * @brief	nACe[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	UNDERGROUNDDATA*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
UNDERGROUNDDATA* UnderGroundData_AllocWork(u32 heapID)
{
	UNDERGROUNDDATA* reg;
	reg = sys_AllocMemory(heapID, sizeof(UNDERGROUNDDATA));
	UnderGroundData_Init(reg);
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	UNDERGROUNDDATÃRs[
 * @param	from	Rs[UNDERGROUNDDATAւ̃|C^
 * @param	to		Rs[UNDERGROUNDDATAւ̃|C^
 */
//----------------------------------------------------------
void UnderGroundData_Copy(const UNDERGROUNDDATA *pFrom, UNDERGROUNDDATA* pTo)
{
	MI_CpuCopy8(pFrom, pTo, sizeof(UNDERGROUNDDATA));
}

//----------------------------------------------------------
/**
 * @brief	[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int SecretBaseData_GetWorkSize(void)
{
	return sizeof(SECRETBASEDATA);
}

//----------------------------------------------------------
/**
 * @brief	nXe[^X[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	SECRETBASEDATA*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
SECRETBASEDATA* SecretBaseData_AllocWork(u32 heapID)
{
	SECRETBASEDATA* reg;
	reg = sys_AllocMemory(heapID, sizeof(SECRETBASEDATA));
	SecretBaseData_Init(reg);
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	R[h̃[NTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int SecretBaseRecord_GetWorkSize(void)
{
	return sizeof(SB_RECORD_DATA);
}

//----------------------------------------------------------
/**
 * @brief	nXe[^XR[h[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	SB_RECORD_DATA*	擾[Nւ̃|C^
 */
//----------------------------------------------------------
SB_RECORD_DATA* SecretBaseRecord_AllocWork(u32 heapID)
{
	SB_RECORD_DATA* reg;
	reg = sys_AllocMemory(heapID, sizeof(SB_RECORD_DATA));
	MI_CpuFill8(reg, 0, sizeof(SB_RECORD_DATA));
	return reg;
}

//----------------------------------------------------------
/**
 * @brief	SECRETBASEDATÃRs[
 * @param	from	Rs[SECRETBASEDATAւ̃|C^
 * @param	to		Rs[SECRETBASEDATAւ̃|C^
 */
//----------------------------------------------------------
void SecretBaseData_Copy(const SECRETBASEDATA *pFrom, SECRETBASEDATA* pTo)
{
	MI_CpuCopy8(pFrom, pTo, sizeof(SECRETBASEDATA));
}


//============================================================================================
//
//	UNDERGROUNDDATÂ߂̊֐
//
//============================================================================================

//----------------------------------------------------------
/**
 * @brief	nXe[^Xf[^̏
 * @param	pSBData		UNDERGROUNDDATA[Nւ̃|C^
 */
//----------------------------------------------------------
void UnderGroundData_Init(UNDERGROUNDDATA* pSBData)
{
	MI_CpuFill8(pSBData, 0, sizeof(UNDERGROUNDDATA));
}


static int _getBagTreasureItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    for(i = 0;i < SECRETBASE_GOODS_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] != GOODS_INVALID ){
            return i;
        }
    }
    return -1;
}

static int _getPcGoodsItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcGoods[i] != GOODS_INVALID ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreePcGoodsItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcGoods[i] == GOODS_INVALID ){
            return i;
        }
    }
    return -1;
}

static int _getBagGoodsItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagGoods[i] != GOODS_INVALID ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreeBagGoodsItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagGoods[i] == GOODS_INVALID ){
            return i;
        }
    }
    return -1;
}

static int _getFreePcStoneItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcStone[i] == STONE_TYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getPcStoneItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcStone[i] != STONE_TYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreeBagStoneItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagStone[i] == STONE_TYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getBagStoneItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagStone[i] != STONE_TYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreePcTreasureItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcTreasure[i] == STONE_TYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getPcTreasureItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcTreasure[i] != STONE_TYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreePcTrapItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcTrap[i] == UG_TRAPTYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getPcTrapItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcTrap[i] != UG_TRAPTYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getBagTreasureItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] != STONE_TYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

static int _getFreeBagTreasureItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] == STONE_TYPE_NONE ){
            return i;
        }
    }
    return -1;
}

static int _getFreeBagTrapItemIndex(UNDERGROUNDDATA* pUGData)
{
    int i;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTrap[i] == UG_TRAPTYPE_NONE ){ // 
            return i;
        }
    }
    return -1;
}

static int _getBagTrapItemIndexSearch(UNDERGROUNDDATA* pUGData, int index)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTrap[i] != UG_TRAPTYPE_NONE ){
            if(index == cnt){
                return i;
            }
            cnt++;
        }
    }
    return -1;
}

//----------------------------------------------------------
/**
 * @brief	nf[^̓Ɋ֌W
 * @param   pSave        Z[uf[^\
 * @param	diff_days    oߓ
 * @return	none
 */
//----------------------------------------------------------

void UnderGroundDataDayUpdate(SAVEDATA* pSave, int diff_days)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(pSave);
    MATHRandContext16 rand;
    u8 upper[]={0,2,2,4,4,6};
    u8 add[]={0,1,1,3,3,5};
    int day,dayMax,carat,type,i;
    
    if(diff_days <= 0){  // ̓tXVɂǂ邩͕s
        return;
    }
    dayMax = diff_days;   // ʂ̐͂XX܂łȂ̂łȏ̓Jbg
    if(diff_days > UG_STONE_CARAT_MAX){
        dayMax = UG_STONE_CARAT_MAX;
    }
    MATH_InitRand16(&rand, pUGData->randSeed);
    for(day = 0; day < dayMax; day++){
        for(i = 0; i < UG_STONE_PLACE_NUM_MAX; i++){
            if(pUGData->groundStoneType[i] != STONE_TYPE_NONE){
                type = pUGData->groundStoneType[i];
                carat = MATH_Rand16(&rand, upper[type]) + add[type] + pUGData->groundStoneCarat[i];
                if(carat < UG_STONE_CARAT_MAX){
                    pUGData->groundStoneCarat[i] = carat;
                }
                else{
                    pUGData->groundStoneCarat[i] = UG_STONE_CARAT_MAX;
                    break;
                }
            }
        }
    }
    pUGData->randSeed += diff_days;
}

//----------------------------------------------------------
/**
 * @brief	ǉ
 * @param   pUGData      nACef[^\
 * @param	pMyStatus    ƂlMYSTATUS
 * @return	none   K
 */
//----------------------------------------------------------

void UnderGroundAddFlag(UNDERGROUNDDATA* pUGData, const MYSTATUS* pMyStatus)
{
	int i = pUGData->newFlagNo;

    MI_CpuCopy8(MyStatus_GetMyName(pMyStatus), pUGData->name[i], (sizeof(STRCODE) * (PERSON_NAME_SIZE+EOM_SIZE)));
    pUGData->id[i] = MyStatus_GetID(pMyStatus);
    pUGData->region_code[i] = MyStatus_GetRegionCode(pMyStatus);
    pUGData->rom_code[i] = MyStatus_GetRomCode(pMyStatus);
    pUGData->newFlagNo++;
    if(pUGData->newFlagNo >= UG_FLAG_NUM_MAX){
        pUGData->newFlagNo = 0;
    }
}

//----------------------------------------------------------
/**
 * @brief	ǂݍ
 * @param   pUGData      nACef[^\
 * @param   heapID       HEAP
 * @param	index        o
 * @return	MYSTATUS*    ̏ꍇNULL
 */
//----------------------------------------------------------

MYSTATUS* UnderGroundGetFlag(const UNDERGROUNDDATA* pUGData,int heapID,int index)
{
    int size = (sizeof(STRCODE) * (PERSON_NAME_SIZE+EOM_SIZE));
    int i;
    MYSTATUS* pMy;
    int no = pUGData->newFlagNo - index - 1;

    if(no < 0){
        no += UG_FLAG_NUM_MAX;
    }
    for(i = 0;i < size;i++){
        if(pUGData->name[no][i] != 0){
            pMy = MyStatus_AllocWork(heapID);
            MyStatus_SetMyName(pMy, pUGData->name[i]);
            MyStatus_SetRomCode(pMy, pUGData->rom_code[i]);
            MyStatus_SetRegionCode(pMy, pUGData->region_code[i]);
            MyStatus_SetID(pMy, pUGData->id[i]);
            return pMy;
        }
    }
    return NULL;
}


//----------------------------------------------------------
/**
 * @brief	ɂĕς闐V[h𓾂
 * @param   pUGData      nACef[^\
 * @return	ɂĕς闐V[h
 */
//----------------------------------------------------------
u32 UnderGroundGetDayRandSeed(UNDERGROUNDDATA* pUGData)
{
    return pUGData->randSeed;
}

//----------------------------------------------------------
/**
 * @brief	܂ACeo
 * @param   pUGData      nACef[^\
 * @param	bDelete      ۂɎoĂ疳ȂꍇTRUE ǂ݂̏ꍇFALSE
 * @return	ITEM_TYPE ɂȂ ITEM_DUMMY_DATA
 */
//----------------------------------------------------------
int UnderGroundGetTreasureBagItem(UNDERGROUNDDATA* pUGData, BOOL bDelete)
{
    int i = _getBagTreasureItemIndex(pUGData);
    int ugitem;

    if(i == -1){
        return ITEM_DUMMY_DATA;
    }
    ugitem = pUGData->bagTreasure[i];
    GF_ASSERT_RETURN(DIG_PARTS_TREASURE_MIN <= ugitem, ITEM_HUTOIHONE);
    GF_ASSERT_RETURN(ugitem < DIG_PARTS_TREASURE_MAX, ITEM_HUTOIHONE);
    ugitem -= DIG_PARTS_TREASURE_MIN;
    if(bDelete){
        pUGData->bagTreasure[i] = DIG_PARTS_NONE;  // 
    }
    return _convertList[ugitem];
}

//----------------------------------------------------------
/**
 * @brief	p\R̃ObY֒ǉ
 * @param   pUGData      nACef[^\
 * @param	goodsNo      ObYԍ
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddGoodsPCItem(UNDERGROUNDDATA* pUGData, int goodsNo)
{
    int i;

    i = _getFreePcGoodsItemIndex(pUGData);
    if(i != -1){
        pUGData->pcGoods[i] = goodsNo;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	p\RɃObYĂ邩mF
 * @param   pUGData      nACef[^\
 * @return	ObY
 */
//----------------------------------------------------------
int UnderGroundGetNumGoodsPCItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcGoods[i] != GOODS_INVALID ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	p\R̃ObYmF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ObYԍ ꍇ GOODS_INVALID
 */
//----------------------------------------------------------
int UnderGroundGetGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getPcGoodsItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->pcGoods[i];
    }
    return GOODS_INVALID;
}

//----------------------------------------------------------
/**
 * @brief	p\RObYƂ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ObYԍ ꍇ GOODS_INVALID
 */
//----------------------------------------------------------
int UnderGroundDelGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    // Ă̂oȂ̂ł炩ߌ邱
    GF_ASSERT_RETURN(!UnderGroundIsEntryGoodsPCItem(pUGData, listIndex),);
    
    ix = _getPcGoodsItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return GOODS_INVALID;
    }
    type = pUGData->pcGoods[ix];
    pUGData->pcGoods[ix] = GOODS_INVALID;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	p\RObYׂɂƂ肾
 *          ۂɂ͎oA}[N܂
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ObYԍ ꍇ GOODS_INVALID
 */
//----------------------------------------------------------
int UnderGroundEntryGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex, int goodsIndex)
{
    int i,ix;

    ix = _getPcGoodsItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return GOODS_INVALID;
    }
    GF_ASSERT_RETURN(goodsIndex >= SECRETBASE_PC_NUM_MAX, GOODS_INVALID);
    GF_ASSERT_RETURN(goodsIndex <= SECRETBASE_GOODS_NUM_MAX, GOODS_INVALID);
    pUGData->secretBasePlace[goodsIndex - SECRETBASE_PC_NUM_MAX] = listIndex + 1;
    return pUGData->pcGoods[ix];
}

//----------------------------------------------------------
/**
 * @brief	Xgԍ̃ACeĂ邩ǂԂ܂
 * @param   pUGData       nACef[^\
 * @param	listIndex     j[Xg̏ UnderGroundEntryGoodsPCItemœn̂Ɠ
 * @return	ĂꍇTRUE
 */
//----------------------------------------------------------

BOOL UnderGroundIsEntryGoodsPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;
    for(i = 0; i < SECRETBASE_GOODS_NUM_MAX; i++){
        if(pUGData->secretBasePlace[ i ] == (listIndex+1)){
            return TRUE;
        }
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	p\R֏ĂObYǂ
 * @param   pUGData      nACef[^\
 * @param	goodsIndex	ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundTrashGoodsPCItem(UNDERGROUNDDATA* pUGData, int goodsIndex)
{
    if((goodsIndex - SECRETBASE_PC_NUM_MAX) >= SECRETBASE_GOODS_NUM_MAX){
        return;
    }
    pUGData->secretBasePlace[goodsIndex - SECRETBASE_PC_NUM_MAX] = 0;
}

//----------------------------------------------------------
/**
 * @brief	p\R֏ĂObYSǂ
 * @param   pUGData      nACef[^\
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundTrashAllGoodsPCItem(UNDERGROUNDDATA* pUGData)
{
    MI_CpuFill8(pUGData->secretBasePlace, 0, SECRETBASE_GOODS_NUM_MAX);
}

//----------------------------------------------------------
/**
 * @brief	obOɃObYĂ邩mF
 * @param   pUGData      nACef[^\
 * @return	ObY
 */
//----------------------------------------------------------
int UnderGroundGetNumGoodsBagItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagGoods[i] != GOODS_INVALID ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	obÕObYmF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ObYԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetGoodsBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getBagGoodsItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->bagGoods[i];
    }
    return GOODS_INVALID;
}

//----------------------------------------------------------
/**
 * @brief	obOObYƂ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @return	ObYԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelGoodsBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getBagGoodsItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return GOODS_INVALID;
    }
    type = pUGData->bagGoods[ix];
    pUGData->bagGoods[ix] = GOODS_INVALID;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	obOփObYǉ
 * @param   pUGData      nACef[^\
 * @param	goodsType    ObYType
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddGoodsBagItem(UNDERGROUNDDATA* pUGData, int goodsType)
{
    int i;

    i = _getFreeBagGoodsItemIndex(pUGData);
    if(i != -1){
        pUGData->bagGoods[i] = goodsType;
        return TRUE;
    }
    return FALSE;
}


//----------------------------------------------------------
/**
 * @brief	p\Rɂ܂Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	ܐ
 */
//----------------------------------------------------------
int UnderGroundGetNumStonePCItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcStone[i] != STONE_TYPE_NONE ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	p\R̂܂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ܔԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetStonePCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getPcStoneItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->pcStone[i];
    }
    return STONE_TYPE_NONE;
}

//----------------------------------------------------------
/**
 * @brief	p\R̂܂̂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	Caratԍ ꍇ1
 */
//----------------------------------------------------------
int UnderGroundGetStoneCaratPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getPcStoneItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->pcStoneCarat[i];
    }
    return 1;
}

//----------------------------------------------------------
/**
 * @brief	p\R炽܂Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ܔԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelStonePCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getPcStoneItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return STONE_TYPE_NONE;
    }
    type = pUGData->pcStone[ix];
    pUGData->pcStone[ix] = STONE_TYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	p\R̂܂֒ǉ
 * @param   pUGData      nACef[^\
 * @param	stoneType    ^}Type
 * @param	carat        ^}̑傫
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddStonePCItem(UNDERGROUNDDATA* pUGData, int stoneType, int carat)
{
    int i;

    i = _getFreePcStoneItemIndex(pUGData);
    if(i != -1){
        pUGData->pcStone[i] = stoneType;
        pUGData->pcStoneCarat[i] = carat;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	΂ɂ܂Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	ܐ
 */
//----------------------------------------------------------
int UnderGroundGetNumStoneBagItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagStone[i] != STONE_TYPE_NONE ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	΂̂܂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ܔԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetStoneBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getBagStoneItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->bagStone[i];
    }
    return STONE_TYPE_NONE;
}

//----------------------------------------------------------
/**
 * @brief	΂̂܂̂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	Caratԍ ꍇ1
 */
//----------------------------------------------------------
int UnderGroundGetStoneCaratBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getBagStoneItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->bagStoneCarat[i];
    }
    return 1;
}

//----------------------------------------------------------
/**
 * @brief	΂񂩂炽܂Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ܔԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelStoneBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getBagStoneItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return STONE_TYPE_NONE;
    }
    type = pUGData->bagStone[ix];
    pUGData->bagStone[ix] = STONE_TYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	΂񂽂܂֒ǉ
 * @param   pUGData      nACef[^\
 * @param	stoneType    ^}Type
 * @param	carat        ^}̑傫
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddStoneBagItem(UNDERGROUNDDATA* pUGData, int stoneType, int carat)
{
    int i;

    i = _getFreeBagStoneItemIndex(pUGData);
    if(i != -1){
        pUGData->bagStone[i] = stoneType;
        pUGData->bagStoneCarat[i] = carat;
        return TRUE;
    }
    return FALSE;
}



//----------------------------------------------------------
/**
 * @brief	p\Rɂ炪Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	琔
 */
//----------------------------------------------------------
int UnderGroundGetNumTreasurePCItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcTreasure[i] != STONE_TYPE_NONE ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	p\R̂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetTreasurePCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getPcTreasureItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->pcTreasure[i];
    }
    return STONE_TYPE_NONE;
}

//----------------------------------------------------------
/**
 * @brief	p\R炨Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelTreasurePCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getPcTreasureItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return STONE_TYPE_NONE;
    }
    type = pUGData->pcTreasure[ix];
    pUGData->pcTreasure[ix] = STONE_TYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	p\Rւǉ
 * @param   pUGData      nACef[^\
 * @param	treasureType    Type
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddTreasurePCItem(UNDERGROUNDDATA* pUGData, int treasureType)
{
    int i;

    i = _getFreePcTreasureItemIndex(pUGData);
    if(i != -1){
        pUGData->pcTreasure[i] = treasureType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	p\R㩂Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	㩐
 */
//----------------------------------------------------------
int UnderGroundGetNumTrapPCItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_PC_NUM_MAX; i++){
        if( pUGData->pcTrap[i] != UG_TRAPTYPE_NONE ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	p\R㩂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	㩔ԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetTrapPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getPcTrapItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->pcTrap[i];
    }
    return UG_TRAPTYPE_NONE;
}

//----------------------------------------------------------
/**
 * @brief	p\R㩂Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	㩔ԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelTrapPCItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getPcTrapItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return UG_TRAPTYPE_NONE;
    }
    type = pUGData->pcTrap[ix];
    pUGData->pcTrap[ix] = UG_TRAPTYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	p\R㩂ǉ
 * @param   pUGData      nACef[^\
 * @param	trapType    Type
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddTrapPCItem(UNDERGROUNDDATA* pUGData, int trapType)
{
    int i;

    i = _getFreePcTrapItemIndex(pUGData);
    if(i != -1){
        pUGData->pcTrap[i] = trapType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obOɂ炪Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	琔
 */
//----------------------------------------------------------
int UnderGroundGetNumTreasureBagItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTreasure[i] != STONE_TYPE_NONE ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	obÔmF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	ԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetTreasureBagItem_List(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getBagTreasureItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->bagTreasure[i];
    }
    return STONE_TYPE_NONE;
}

//----------------------------------------------------------
/**
 * @brief	obO炨Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @param	goodsIndex      zȕ
 * @return	ԍ ꍇ STONE_TYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelTreasureBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getBagTreasureItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return STONE_TYPE_NONE;
    }
    type = pUGData->bagTreasure[ix];
    pUGData->bagTreasure[ix] = STONE_TYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	obOւǉ
 * @param   pUGData      nACef[^\
 * @param	treasureType    Type
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddTreasureBagItem(UNDERGROUNDDATA* pUGData, int treasureType)
{
    int i;

    i = _getFreeBagTreasureItemIndex(pUGData);
    if(i != -1){
        pUGData->bagTreasure[i] = treasureType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂Ă邩mF
 * @param   pUGData      nACef[^\
 * @return	㩐
 */
//----------------------------------------------------------
int UnderGroundGetNumTrapBagItem(UNDERGROUNDDATA* pUGData)
{
    int i,cnt=0;
    
    for(i = 0;i < UG_ITEM_BAG_NUM_MAX; i++){
        if( pUGData->bagTrap[i] != UG_TRAPTYPE_NONE ){
            cnt++;
        }
    }
    return cnt;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂mF
 * @param   pUGData      nACef[^\
 * @param	index      0`̘A  
 * @return	㩔ԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundGetTrapBagItem_List(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i;

    i = _getBagTrapItemIndexSearch(pUGData, listIndex);
    if(i != -1){
        return pUGData->bagTrap[i];
    }
    return UG_TRAPTYPE_NONE;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂Ƃ肾
 * @param   pUGData      nACef[^\
 * @param	listIndex       j[Xg̏
 * @return	㩔ԍ ꍇ UG_TRAPTYPE_NONE
 */
//----------------------------------------------------------
int UnderGroundDelTrapBagItem(UNDERGROUNDDATA* pUGData, int listIndex)
{
    int i,ix,type;

    ix = _getBagTrapItemIndexSearch(pUGData, listIndex);
    if(ix == -1){
        return UG_TRAPTYPE_NONE;
    }
    type = pUGData->bagTrap[ix];
    pUGData->bagTrap[ix] = UG_TRAPTYPE_NONE;
    return type;
}

//----------------------------------------------------------
/**
 * @brief	obO㩂ǉ
 * @param   pUGData      nACef[^\
 * @param	treasureType    Type
 * @return	ȂFALSE
 */
//----------------------------------------------------------
BOOL UnderGroundAddTrapBagItem(UNDERGROUNDDATA* pUGData, int trapType)
{
    int i;

    i = _getFreeBagTrapItemIndex(pUGData);
    if(i != -1){
        pUGData->bagTrap[i] = trapType;
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------
/**
 * @brief	nʂ㩂ǉ
 * @param   pUGData      nACef[^\
 * @param	trapType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundAddTrapGroundItem(UNDERGROUNDDATA* pUGData, int trapType,int index, int x,int z,int order)
{
    GF_ASSERT_RETURN(index < UG_TRAP_PLACE_NUM_MAX,);
    pUGData->groundTrapType[index]=trapType;
    pUGData->groundTrapX[index]=x;
    pUGData->groundTrapZ[index]=z;
    pUGData->groundTrapOrder[index]=order;
}

//----------------------------------------------------------
/**
 * @brief	nʂւ㩃^Cvo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	㩃^Cv
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemType(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundTrapType[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂXWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	XW
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemX(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundTrapX[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂZWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	ZW
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemZ(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundTrapZ[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂ琶Ԃo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	order
 */
//----------------------------------------------------------

int UnderGroundGetTrapGroundItemOrder(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundTrapOrder[index];
}


//----------------------------------------------------------
/**
 * @brief	nʂ֐΂ǉ
 * @param   pUGData      nACef[^\
 * @param	stoneType    Type
 * @return	none
 */
//----------------------------------------------------------
void UnderGroundAddStoneGroundItem(UNDERGROUNDDATA* pUGData, int stoneType,int index, int x,int z,int order,int carat)
{
    GF_ASSERT_RETURN(index < UG_STONE_PLACE_NUM_MAX,);
    pUGData->groundStoneType[index]=stoneType;
    pUGData->groundStoneX[index]=x;
    pUGData->groundStoneZ[index]=z;
    pUGData->groundStoneCarat[index]=carat;
    pUGData->groundStoneOrder[index]=order;
}

//----------------------------------------------------------
/**
 * @brief	nʂւ΃^Cvo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	㩃^Cv
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemType(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneType[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂXWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	XW
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemX(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneX[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂZWo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	ZW
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemZ(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneZ[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂ΂̑傫o
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	΂̑傫
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemCarat(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneCarat[index];
}

//----------------------------------------------------------
/**
 * @brief	nʂ琶Ԃo
 * @param   pUGData      nACef[^\
 * @param	index  Lobt@̏
 * @return	order
 */
//----------------------------------------------------------

int UnderGroundGetStoneGroundItemOrder(UNDERGROUNDDATA* pUGData,int index)
{
    return pUGData->groundStoneOrder[index];
}

//----------------------------------------------------------
/**
 * @brief	nXe[^Xf[^̏
 * @param	pSBData		SECRETBASEDATA[Nւ̃|C^
 */
//----------------------------------------------------------
void SecretBaseData_Init(SECRETBASEDATA* pSBData)
{
	MI_CpuFill8(pSBData, 0, sizeof(SECRETBASEDATA));
}

//----------------------------------------------------------
/**
 * @brief	ObŸʒuݒ肷  ꍇɂ͑SO    p~\
 * @param	pSBData	 SECRETBASEDATA[N|C^
 * @param	goodsIndex	ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @param   type    ObY^Cv
 * @param	x,z      ʒu
 */
//----------------------------------------------------------
void SecretBaseData_SetGoodsPosition(SECRETBASEDATA* pSBData, int goodsIndex, int type, int x, int z)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,);
    GF_ASSERT_RETURN(x < 32,);
    GF_ASSERT_RETURN(z < 32,);
    GF_ASSERT_RETURN(pSBData,);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return;  // p\R̈ʒu͗vȂ
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].x = x;
        pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].z = z;
        pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].type = type;
    }
    else{  // c͊
        pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].x = x;
        pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].z = z;
    }
}

//----------------------------------------------------------
/**
 * @brief	ObŸʒuύX  ꍇɂ͑SO
 * @param	pSBData	 SECRETBASEDATA[N|C^
 * @param	goodsIndex	ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @param	x,z      ʒu
 */
//----------------------------------------------------------
void SecretBaseData_ChangeGoodsPosition(SECRETBASEDATA* pSBData, int goodsIndex, int x, int z)
{
    int type = SecretBaseData_GetGoodsType(pSBData, goodsIndex);
    SecretBaseData_SetGoodsPosition(pSBData, goodsIndex, type, x, z);
}

//----------------------------------------------------------
/**
 * @brief	p\Rtype𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	ObY^Cv+p\R^Cv
 */
//----------------------------------------------------------

static int _getPCType(const SECRETBASEDATA* pSBData)
{
    int num = pSBData->recordData.flagDeliveryCount;
    
    if(FLAG_PLATINA_LV_NUM >= num){
        return GOODS_FLAG_PLATINA_PC;
    }
    else if(FLAG_GOLD_LV_NUM >= num){
        return GOODS_FLAG_GOLD_PC;
    }
    else if(FLAG_SILVER_LV_NUM >= num){
        return GOODS_FLAG_SILVER_PC;
    }
    else if(FLAG_BRONZE_LV_NUM >= num){
        return GOODS_FLAG_BRONZE_PC;
    }
    return GOODS_FLAG_NORMAL_PC;
}

//----------------------------------------------------------
/**
 * @brief	ObYtype𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	goodsIndex	  ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return 	ObY^Cv
 */
//----------------------------------------------------------
int SecretBaseData_GetGoodsType(const SECRETBASEDATA* pSBData, int goodsIndex)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return _getPCType(pSBData);
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        return pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].type;
    }
    else if( (pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].x != _INVALID_POS)
             && (pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].z != _INVALID_POS) ){
        // c͊
        return GOODS_BIG_ROCK;
    }
    return GOODS_INVALID;
}

//----------------------------------------------------------
/**
 * @brief	ObYxʒu𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	goodsIndex	  ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return 	ObYxW
 */
//----------------------------------------------------------
int SecretBaseData_GetGoodsXPos(const SECRETBASEDATA* pSBData, int goodsIndex)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return _PCPOS_X;
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        return pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].x;
    }
      // c͊
    return pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].x;
}

//----------------------------------------------------------
/**
 * @brief	ObYzʒu𓾂
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	goodsIndex	  ObY̏ 0-SECRETBASE_SETUPOBJ_NUM_MAX
 * @return 	ObYzW
 */
//----------------------------------------------------------
int SecretBaseData_GetGoodsZPos(const SECRETBASEDATA* pSBData, int goodsIndex)
{
    GF_ASSERT_RETURN(goodsIndex < SECRETBASE_SETUPOBJ_NUM_MAX,);

    if(SECRETBASE_PC_INDEX_NO == goodsIndex){
        return _PCPOS_Z;
    }
    else if(goodsIndex < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)) { // ObYĂ
        return pSBData->goodsPos[goodsIndex - SECRETBASE_PC_NUM_MAX].z;
    }
    // c͊
    return pSBData->rockPos[goodsIndex - SECRETBASE_PC_NUM_MAX - SECRETBASE_GOODS_NUM_MAX].z;
}

//----------------------------------------------------------
/**
 * @brief	ǂ̂炢ێĂȂƂȂԂ
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	ێ
 */
//----------------------------------------------------------
int SecretBaseData_GetPlaceRockLimit(const SECRETBASEDATA* pSBData)
{
    if(pSBData->recordData.flagDeliveryCount >=  FLAG_PLATINA_LV_NUM){
        return 0;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_GOLD_LV_NUM){
        return 5;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_SILVER_LV_NUM){
        return 10;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_BRONZE_LV_NUM){
        return 15;
    }
    return 16;
}

//----------------------------------------------------------
/**
 * @brief	zu܂ŒuĂ̂Ԃ
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @return 	uĂObY̐
 */
//----------------------------------------------------------
int SecretBaseData_GetPlaceGoodsLimit(const SECRETBASEDATA* pSBData)
{
    if(pSBData->recordData.flagDeliveryCount >=  FLAG_PLATINA_LV_NUM){
        return 15;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_GOLD_LV_NUM){
        return 15;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_SILVER_LV_NUM){
        return 15;
    }
    else if(pSBData->recordData.flagDeliveryCount >= FLAG_BRONZE_LV_NUM){
        return 12;
    }
    return 10;
}

//==============================================================================
/**
 * |Cg	ƂA㩂ɂƂɂ炦|CgB
 * @param   none
 * @retval  |Cg
 */
//==============================================================================
int SecretBaseRecordGetPoint(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->pointCount;
}

//==============================================================================
/**
 * |Cg	ƂA㩂ɂƂɂ炦|CgZ
 * @param   add  Z   Z|Cg
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetPoint(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->pointCount > (_MAX - add))){
        pSBRecord->pointCount = _MAX;
    }
    else if((add < 0) && (pSBRecord->pointCount < (0 - add))){
        pSBRecord->pointCount = 0;
    }
    else{
        pSBRecord->pointCount += add;
    }
}

//==============================================================================
/**
 * łl̐l	ʐMƘb񐔂łBlłPO܂ŃJEg܂B
 * @param   none
 * @retval  łl̐l
 */
//==============================================================================
int SecretBaseRecordGetTalkNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->talkCount;
}

//==============================================================================
/**
 * łl̐l	ʐMƘb񐔂łBlłPO܂ŃJEg܂B
 * @param   
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetTalkNum(SB_RECORD_DATA* pSBRecord, int meetNetID)
{
    if(pSBRecord->talkCount < _MAX){
        pSBRecord->talkCount++;
    }
}

//==============================================================================
/**
 * 	Nɓグ񐔁BlɂĂJEg܂B
 * @param   
 * @retval  none
 */
//==============================================================================
int SecretBaseRecordGetSendItemNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->sendItemCount;
}

//==============================================================================
/**
 * 	Nɓグ񐔁BlɂĂJEg܂B
 * @param   
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetSendItemNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->sendItemCount < _MAX){
        pSBRecord->sendItemCount++;
    }
}

//==============================================================================
/**
 * n^Ƃ	̃n^Ƃ񐔂łBlłJEg܂B
 * @param   none
 * @retval  n^Ƃ
 */
//==============================================================================
int SecretBaseRecordGetFlagConquerNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagConquerCount;
}

//==============================================================================
/**
 * n^Ƃ	̃n^Ƃ񐔂łBlłJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetFlagConquerNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagConquerCount < _MAX){
        pSBRecord->flagConquerCount++;
    }
}

//==============================================================================
/**
 * ^}@	~jQ[ŁA^}@o񐔂łB߂^}@oĂJEg܂B
 * @param   none
 * @retval  ^}@
 */
//==============================================================================
int SecretBaseRecordGetStoneNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->stoneCount;
}

//==============================================================================
/**
 * ^}@	~jQ[ŁA^}@o񐔂łB߂^}@oĂJEg܂B
 * @param   add  
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetStoneNum(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->stoneCount > (_MAX - add))){
        pSBRecord->stoneCount = _MAX;
    }
    else{
        pSBRecord->stoneCount += add;
    }
}

//==============================================================================
/**
 * ΂@	΂@񐔂łB~jQ[Ŏɓꂽ΂̐łB
 * @param   none
 * @retval  ^}@
 */
//==============================================================================
int SecretBaseRecordGetFossilNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->fossilCount;
}

//==============================================================================
/**
 * ΂@	΂@񐔂łB~jQ[Ŏɓꂽ΂̐łB
 * @param   add   
 * @retval  none
 */
//==============================================================================
void SecretBaseRecordSetFossilNum(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->fossilCount > (_MAX - add))){
        pSBRecord->fossilCount = _MAX;
    }
    else{
        pSBRecord->fossilCount += add;
    }
}

//==============================================================================
/**
 * @	@񐔂łB~jQ[Ŏɓꂽ̐łB
 * @param   none
 * @retval  @
 */
//==============================================================================

int SecretBaseRecordGetTreasureNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->treasureCount;
}

//==============================================================================
/**
 * @	@񐔂łB~jQ[Ŏɓꂽ̐łB
 * @param   add   
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTreasureNum(SB_RECORD_DATA* pSBRecord, int add)
{
    if((add > 0) && (pSBRecord->treasureCount > (_MAX - add))){
        pSBRecord->treasureCount = _MAX;
    }
    else{
        pSBRecord->treasureCount += add;
    }
}

//==============================================================================
/**
 * gbv	gbvɂ񐔂łB
 * @param   none
 * @retval  gbv
 */
//==============================================================================

int SecretBaseRecordGetTrapConquerNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->trapConquerCount;
}

//==============================================================================
/**
 * gbv	gbvɂ񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTrapConquerNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->trapConquerCount < _MAX){
        pSBRecord->trapConquerCount++;
    }
}

//==============================================================================
/**
 * gbvɂ	gbvɂ񐔂łB
 * @param   none
 * @retval  gbvɂ
 */
//==============================================================================

int SecretBaseRecordGetTrapTumbleNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->trapTumbleCount;
}

//==============================================================================
/**
 * gbvɂ	gbvɂ񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTrapTumbleNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->trapTumbleCount < _MAX){
        pSBRecord->trapTumbleCount++;
    }
}

//==============================================================================
/**
 * l	gbvɂĂl񐔂łB
 * @param   none
 * @retval  l
 */
//==============================================================================

int SecretBaseRecordGetTrapRescueNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->trapRescueCount;
}

//==============================================================================
/**
 * l	gbvɂĂl񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetTrapRescueNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->trapRescueCount < _MAX){
        pSBRecord->trapRescueCount++;
    }
}

//==============================================================================
/**
 * 	Nɓ񐔂łBЂƂĂAJEg܂B
 * @param   none
 * @retval  
 */
//==============================================================================

int SecretBaseRecordGetItemRecvNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->itemRecvCount;
}

//==============================================================================
/**
 * 	Nɓ񐔂łBЂƂĂAJEg܂B
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetItemRecvNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->itemRecvCount < _MAX){
        pSBRecord->itemRecvCount++;
    }
}

//==============================================================================
/**
 * Ƃꂽ	NɃn^Ƃꂽ񐔂łB
 * @param   none
 * @retval  Ƃꂽ
 */
//==============================================================================

int SecretBaseRecordGetFlagStealNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagStealCount;
}

//==============================================================================
/**
 * Ƃꂽ	NɃn^Ƃꂽ񐔂łB
 * @param   none
 * @retval  none
 */
//==============================================================================

void SecretBaseRecordSetFlagStealNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagStealCount < _MAX){
        pSBRecord->flagStealCount++;
    }
}

//==============================================================================
/**
 * Ԃ	n^Ԃ񐔂łB
 * @param   none
 * @retval  Ƃꂽ
 */
//==============================================================================

int SecretBaseRecordGetFlagReverseNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->flagReverseCount;
}

void SecretBaseRecordSetFlagReverseNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->flagReverseCount < _MAX){
        pSBRecord->flagReverseCount++;
    }
}

//==============================================================================
/**
 * z	z񐔂łB
 * @param   none
 * @retval  z
 */
//==============================================================================

int SecretBaseRecordGetRelocateNum(const SB_RECORD_DATA* pSBRecord)
{
    return pSBRecord->relocateCount;
}

void SecretBaseRecordSetRelocateNum(SB_RECORD_DATA* pSBRecord)
{
    if(pSBRecord->relocateCount < _MAX){
        pSBRecord->relocateCount++;
    }
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒuݒ肷
 * @param	pSec			閧nf[^
 * @param	x,z,dir			ȍꏊ
 * @return	none
 */
//---------------------------------------------------------------------------
void SecretBaseSetSecretBasePosition(SECRETBASEDATA* pSec,int x,int z,int dir)
{
    pSec->xpos = x;         // hÄʒu
    pSec->zpos = z;
    pSec->dir = dir;        // OɏoĂhA̕
    pSec->bMake = TRUE;     //  ǂ
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒuX𓾂邷
 * @param	pSec			閧nf[^
 * @param	x,z,dir			ȍꏊ
 * @return	none
 */
//---------------------------------------------------------------------------
int SecretBaseGetSecretBasePositionX(const SECRETBASEDATA* pSec)
{
    return pSec->xpos;         // hÄʒu
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒuZ𓾂邷
 * @param	pSec			閧nf[^
 * @return	z			ȍꏊ
 */
//---------------------------------------------------------------------------
int SecretBaseGetSecretBasePositionZ(const SECRETBASEDATA* pSec)
{
    return pSec->zpos;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nʒu𓾂邷
 * @param	pSec			閧nf[^
 * @return	dir			ȍꏊ
 */
//---------------------------------------------------------------------------
int SecretBaseGetSecretBasePositionDir(const SECRETBASEDATA* pSec)
{
    return pSec->dir;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nƂ邩ǂ
 * @param	pSec			閧nf[^
 * @return	ĂTRUE
 */
//---------------------------------------------------------------------------
BOOL SecretBaseIsSecretBaseMake(const SECRETBASEDATA* pSec)
{
    return pSec->bMake;     //  ǂ
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nf[^o
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	SECRETBASEDATA	閧nf[^|C^
 */
//---------------------------------------------------------------------------
SECRETBASEDATA* SaveData_GetSecretBaseData(SAVEDATA * sv)
{
	UNDERGROUNDDATA* ugd;
	ugd = SaveData_Get(sv, GMDATA_ID_UNDERGROUNDDATA);
	return &ugd->base;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nR[hf[^o
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	SB_RECORD_DATA	閧nR[hf[^|C^
 */
//---------------------------------------------------------------------------
SB_RECORD_DATA* SaveData_GetSecretBaseRecord(SAVEDATA * sv)
{
	UNDERGROUNDDATA* ugd;
	ugd = SaveData_Get(sv, GMDATA_ID_UNDERGROUNDDATA);
	return &ugd->base.recordData;
}

//---------------------------------------------------------------------------
/**
 * @brief	閧nR[hf[^o
 * @param	pSec			閧nf[^
 * @return	SB_RECORD_DATA	閧nR[hf[^|C^
 */
//---------------------------------------------------------------------------
SB_RECORD_DATA* SecretBaseGetSecretBaseRecord(SECRETBASEDATA* pSec)
{
	return &pSec->recordData;
}


//---------------------------------------------------------------------------
/**
 * @brief	nACef[^Z[uo
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	UNDERGROUNDDATA	nACef[^|C^
 */
//---------------------------------------------------------------------------
UNDERGROUNDDATA* SaveData_GetUnderGroundData(SAVEDATA * sv)
{
	UNDERGROUNDDATA* ugd;
	ugd = SaveData_Get(sv, GMDATA_ID_UNDERGROUNDDATA);
	return ugd;
}

#ifdef PM_DEBUG

//----------------------------------------------------------
/**
 * @brief	fobOpFn󕨂΂
 * @param	pSBData	      UNDERGROUNDDATA[N|C^
 * @param	type     nACe^Cv
 */
//----------------------------------------------------------
void Debug_UnderGroundData_AddTreasure(UNDERGROUNDDATA* pUGData, int type)
{
    int i = _getFreeBagTreasureItemIndex(pUGData);
    if(i == -1){
        return;
    }
    GF_ASSERT(DIG_PARTS_TREASURE_MIN <= type);
    GF_ASSERT(type < DIG_PARTS_TREASURE_MAX);
    pUGData->bagTreasure[i] = type;
}

static SB_LOCK* _getFreeLockBuff(SECRETBASEDATA* pSBData)
{
    int i;
    for(i = 0;i < SECRETBASE_LOCK_NUM_MAX; i++){
        if( (pSBData->rockPos[i].x == _INVALID_POS) &&
            (pSBData->rockPos[i].z == _INVALID_POS) ){
            return &pSBData->rockPos[i];
        }
    }
    return NULL;
}

static SB_GOODS* _getFreeGoodsBuff(SECRETBASEDATA* pSBData)
{
    int i;
    for(i = 0;i < SECRETBASE_GOODS_NUM_MAX; i++){
        if( pSBData->goodsPos[i].type == GOODS_INVALID ){
            return &pSBData->goodsPos[i];
        }
    }
    return NULL;
}

//----------------------------------------------------------
/**
 * @brief	fobOpFObYݒu  (p\Rւo^܂)
 * @param	pSBData	      SECRETBASEDATA[N|C^
 * @param	name	Oւ̃|C^
 * @param	sex		ʎw
 */
//----------------------------------------------------------
void Debug_SecretBaseData_AddGoods(SECRETBASEDATA* pSBData, int goodsType, int x, int z)
{
    if(GOODS_BIG_ROCK == goodsType){
        SB_LOCK* pLock = _getFreeLockBuff(pSBData);
        if(pLock != NULL){
            pLock->x = x;
            pLock->z = z;
        }
    }
    else if(goodsType < GOODS_BIG_ROCK){  // p\R͌Œʒu
    }
    else{
        SB_GOODS* pGoods = _getFreeGoodsBuff(pSBData);
        if(pGoods != NULL){
            pGoods->type = goodsType;
            pGoods->x = x;
            pGoods->z = z;
        }
    }
}


#endif //PM_DEBUG
