//============================================================================================
/**
 * @file	friendlist.c
 * @brief	ԃf[^ANZXp\[X
 * @author	tamada GAME FREAK inc.
 * @date	2005.10.27
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"
#ifdef DWC_NOT_INCLUDE
#include <dwc.h>
#endif

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/wifilist.h"
#include "wifilist_local.h"

#include "system/pm_str.h"

#include "gflib/strbuf_family.h"

//============================================================================================
//============================================================================================




//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԕێ[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int WifiList_GetWorkSize(void)
{
	return sizeof(WIFI_LIST);
}

//----------------------------------------------------------
/**
 * @brief	ԕێ[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	WIFI_LIST	擾[Nւ̃|C^
 */
//----------------------------------------------------------
WIFI_LIST * WifiList_AllocWork(u32 heapID)
{
	int i;
	WIFI_LIST * list;
	list = sys_AllocMemory(heapID, sizeof(WIFI_LIST));
	
	WifiList_Init( list );

	return list;
}

//----------------------------------------------------------
/**
 * @brief	WIFI_LIST̃Rs[
 * @param	from	Rs[WIFI_LISTւ̃|C^
 * @param	to		Rs[WIFI_LISTւ̃|C^
 */
//----------------------------------------------------------
void WifiList_Copy(const WIFI_LIST * from, WIFI_LIST * to)
{
	MI_CpuCopy8(from, to, sizeof(WIFI_LIST));
}

//============================================================================================
//
//	WIFI_LIST̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief			WifipƂXgEpf[^̏
 * @param			
 */
//----------------------------------------------------------
extern void WifiList_Init(WIFI_LIST * list)
{
	int i;
	
	MI_CpuClearFast(list, sizeof(WIFI_LIST));

	for(i=0;i<WIFILIST_FRIEND_MAX;i++){
		list->friend[i].name[0] = EOM_;
	}

}


//==============================================================================
/**
 * $brief   WIFIڑ̃|C^Ԃ
 *
 * @param   list	WIFI_LIST\̂̃|C^
 *
 * @retval  u8*		
 */
//==============================================================================
DWCUserData* WifiList_GetMyUserInfo( WIFI_LIST* list )
{
	return &(list->my_dwcuser);
}



//==============================================================================
/**
 * $brief   WIFIFB^CvɕԂ
 *
 * @param   list	WIFI_LIST\̂̃|C^
 * @param   no		Ԗڂ̗FB
 * @param   type	ݒ肷̃^Cviwifilist.henum錾)
 *
 * @retval  u32		
 */
//==============================================================================
u32 WifiList_GetFriendInfo( WIFI_LIST* list, int no, int type )
{
	u32 result;

	GF_ASSERT( no < WIFILIST_FRIEND_MAX );
	
	switch(type){
	case WIFILIST_FRIEND_ID:
		result = list->friend[no].id;
		break;
	case WIFILIST_FRIEND_BATTLE_NUM:
		result = list->friend[no].battle_count;
		break;
	case WIFILIST_FRIEND_BATTLE_WIN:
		result = list->friend[no].battle_win;
		break;
	case WIFILIST_FRIEND_BATTLE_LOSE:
		result = list->friend[no].battle_lose;
		break;
	case WIFILIST_FRIEND_TRADE_NUM:
		result = list->friend[no].trade_num;
		break;
	}
	return result;
}


//==============================================================================
/**
 * $brief   
 *
 * @param   list	WIFI_LIST\̂̃|C^
 * @param   no		Ԗڂ̗FB
 * @param   type	ݒ肷̃^Cviwifilist.henum錾)
 * @param   value	ݒ肷l
 *
 * @retval  none	
 */
//==============================================================================
void WifiList_SetFriendInfo( WIFI_LIST* list, int no, int type, u32 value )
{
	GF_ASSERT( no < WIFILIST_FRIEND_MAX );

	switch(type){
	case WIFILIST_FRIEND_ID:
		list->friend[no].id = value;
		break;
	case WIFILIST_FRIEND_BATTLE_NUM:
		list->friend[no].battle_count = value;
		break;
	case WIFILIST_FRIEND_BATTLE_WIN:
		list->friend[no].battle_win = value;
		break;
	case WIFILIST_FRIEND_BATTLE_LOSE:
		list->friend[no].battle_lose = value;
		break;
	case WIFILIST_FRIEND_TRADE_NUM:
		list->friend[no].trade_num = value;
		break;
	}
}


//==============================================================================
/**
 * $brief   ƂXgFBWIFIp\̂̃|C^擾
 *
 * @param   list	WIFI_LIST\̂̃|C^
 * @param   no		lڂ̗FB
 *
 * @retval  DWCFriendData	*		
 */
//==============================================================================
DWCFriendData	*WifiList_GetDwcDataPtr( WIFI_LIST* list, int no )
{
	GF_ASSERT( no < WIFILIST_FRIEND_MAX );

	return &(list->friend_dwc[no]);
}


//==============================================================================
/**
 * $brief   
 *
 * @param   list	WIFI_LIST\̂̃|C^
 * @param   no		lڂ̗FB
 *
 * @retval  u8 *		
 */
//==============================================================================
STRCODE *WifiList_GetFriendNamePtr( WIFI_LIST *list, int no )
{
	GF_ASSERT( no < WIFILIST_FRIEND_MAX );

	return list->friend[no].name;
}