//============================================================================================
/**
 * @file	zukanwork.c
 * @brief	}ӏԃANZXp\[X
 * @author	tamada GAME FREAK inc.
 * @date	2005.12.15
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/zukanwork.h"

#include "poketool/monsno.h"
#include "include/application/zukanlist/zkn_world_text_data.h"
#include "src/application/zukanlist/zkn_worldtext.h"

//============================================================================================
//============================================================================================
enum {
	POKEZUKAN_ARRAY_LEN = 16,	///<Ƃ肠̃|P}ӃtOẑ16 * 32 = 512

	POKEZUKAN_UNKNOWN_NUM = 28,	///<ɂ萔̂łƂ肠

	MAGIC_NUMBER = 0xbeefcafe,
};

//----------------------------------------------------------
/**
 * @brief	ԃf[^^`
 */
//----------------------------------------------------------
struct _ZUKAN_WORK {
	u32 zukan_magic;						///<}WbNio[	
	u8 zukan_get;							///<擾tO
	u8 zenkoku_flag;
	u32 get_flag[POKEZUKAN_ARRAY_LEN];		///<߂܂tOp[N
	u32 see_flag[POKEZUKAN_ARRAY_LEN];		///<tOp[N
	u32 sex_flag[2][POKEZUKAN_ARRAY_LEN];	///<IXXtOp[N
	u32 PachiRandom;						///<pb`[pێ[N
	u8 UmiUshiTurn;							///<E~EVpێ[N
	u8 MinoMushTurn;						///<~mVpێ[N
	u8 UnknownTurn[ POKEZUKAN_UNKNOWN_NUM ];///<Am[ԍ
	u8 GraphicVersionUp;					///<OtBbNo[Wp@\gtO
	
	u8 TextVersionUp[ ZKN_WORLD_TEXT_POKE_NUM ];	///<o[WAbv}XN
};

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	f[^p[ÑTCY擾
 * @return	int		ZUKAN_WORK̃TCY
 */
//----------------------------------------------------------
int ZukanWork_GetWorkSize(void)
{
	return sizeof(ZUKAN_WORK);
}
//----------------------------------------------------------
/**
 * @brief	f[^p[N̐
 * @param	heapID		gpq[v̎w
 * @return	ZUKAN_WORK	ZUKAN_WORKւ̃|C^
 */
//----------------------------------------------------------
ZUKAN_WORK * ZukanWork_AllocWork(u32 heapID)
{
	ZUKAN_WORK * zw;
	zw = sys_AllocMemory(heapID, sizeof(ZUKAN_WORK));
	ZukanWork_Init(zw);
	return zw;
}

//----------------------------------------------------------
/**
 * @brief	f[^p[ÑRs[
 * @param	from	Rs[ZUKAN_WORKւ̃|C^
 * @param	to		Rs[ZUKAN_WORKւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_Copy(const ZUKAN_WORK * from, ZUKAN_WORK * to)
{
	MI_CpuCopy8(from, to, sizeof(ZUKAN_WORK));
}

//============================================================================================
//
//				֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	񃏁[N̐`FbN
 */
//----------------------------------------------------------
static inline void zukan_incorrect(const ZUKAN_WORK * zw)
{
	GF_ASSERT(zw->zukan_magic == MAGIC_NUMBER);
}
//----------------------------------------------------------
/**
 * @brief	|Pio[͈̔̓`FbN
 */
//----------------------------------------------------------
static inline BOOL monsno_incorrect(u16 monsno)
{
	if (monsno == 0 || monsno > MONSNO_END) {
		GF_ASSERT_MSG(0, "|Pio[ُF%d\n", monsno);
		return TRUE;
	} else {
		return FALSE;
	}
}

//----------------------------------------------------------
/**
 * @brief	ėprbg`FbN
 */
//----------------------------------------------------------
static inline BOOL check_bit(const u8 * array, u16 flag_id)
{
	flag_id --;
	return 0 != (array[flag_id >> 3] & (1 << (flag_id & 7)));
}
//----------------------------------------------------------
/**
 * @brief	ėprbgZbg
 */
//----------------------------------------------------------
static inline void set_bit(u8 * array, u16 flag_id)
{
	flag_id --;
	array[flag_id >> 3] |= 1 << (flag_id & 7);
}
//----------------------------------------------------------
/**
 * @brief	ėp1rbgf[^Zbg
 * ̃rbgN[ɂĂݒ肵܂
 */
//----------------------------------------------------------
static inline void setnum_bit(u8 * array, u8 num, u16 flag_id)
{
	GF_ASSERT( num < 2 );
	flag_id --;

	array[flag_id >> 3] &= ~(1 << (flag_id & 7));
	array[flag_id >> 3] |= num << (flag_id & 7);
}

#if 0
static inline void reset_bit(u8 * array, u16 flag_id)
{
	array[flag_id >> 3] &= (1 << (flag_id & 7)) ^ 0xff;
}
#endif
//----------------------------------------------------------
/**
 * @brief	ėprbgJEg
 */
//----------------------------------------------------------
static inline u16 count_bit(const u32 * array, u32 array_max)
{
	int count, idx;
	u32 item;
	count = 0;
	for (idx = 0; idx < array_max; idx ++) {
		for (item = array[idx]; item != 0; item >>= 1) {
			if (item & 1) {
				count ++;
			}
		}
	}
	return count;
}


//----------------------------------------------------------
/**
 * @brief	݂rbgݒ
 */
//----------------------------------------------------------
static inline void set_see_bit(ZUKAN_WORK * zw, u16 flag_id)
{
	set_bit((u8*)zw->see_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	܂rbgݒ
 */
//----------------------------------------------------------
static inline void set_get_bit(ZUKAN_WORK * zw, u16 flag_id)
{
	set_bit((u8*)zw->get_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	ʃrbgݒ	ۂɐݒ
 * ŏ̐ʐݒ2vfڂ̔zɂlݒ肷
 * ɂ2vfڂl͈̎Ⴄʂ̃|P݂ĂȂ
 * ƂƂɂȂ
 */
//----------------------------------------------------------
static inline void set_sex_bit_first_second(ZUKAN_WORK * zw, u8 num, u8 no, u16 flag_id)
{
	if( no == ZUKAN_WORK_SEX_FIRST ){
		setnum_bit((u8*)zw->sex_flag[ZUKAN_WORK_SEX_SECOND], num, flag_id);
	}
	setnum_bit((u8*)zw->sex_flag[no], num, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	ʃrbgݒ
 */
//----------------------------------------------------------
static inline void set_sex_bit(ZUKAN_WORK * zw, u8 num, u8 no, u16 monsno)
{
	GF_ASSERT_MSG( num <= 2, "num = %d", num );	// j@@sȊO܂
	if( num == PARA_UNK ){		// UNKNOW
		num = PARA_MALE;		// jɂ
	}
	set_sex_bit_first_second(zw, num, no, monsno);
}
//----------------------------------------------------------
/**
 * @brief	݂rbgONOFF`FbN
 */
//----------------------------------------------------------
static inline BOOL check_see_bit(const ZUKAN_WORK * zw, u16 flag_id)
{
	return check_bit((const u8*)zw->see_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	܂rbgONOFF`FbN
 */
//----------------------------------------------------------
static inline BOOL check_get_bit(const ZUKAN_WORK * zw, u16 flag_id)
{
	return check_bit((const u8*)zw->get_flag, flag_id);
}
//----------------------------------------------------------
/**
 * @brief	ʃrbgONOFF`FbN
 */
//----------------------------------------------------------
static inline u8 check_sex_bit(const ZUKAN_WORK * zw, u16 flag_id, u8 first_second)
{
	return check_bit((const u8*)zw->sex_flag[first_second], flag_id);
}

//----------------------------------------------------------
/**
 * @brief	ő̗ݒ
 */
//----------------------------------------------------------
static inline void SetZukanRandom(ZUKAN_WORK * zw, u16 monsno, u32 rand)
{
	if (monsno == MONSNO_PATTIIRU) {
		zw->PachiRandom = rand;
	}
}

//----------------------------------------------------------
/**
 * @brief	Am[̌ݐݒ萔擾
 */
//----------------------------------------------------------
static inline int get_zukan_unknown_turn_num( const ZUKAN_WORK * zw )
{
	int i;
	for( i=0; i<POKEZUKAN_UNKNOWN_NUM; i++ ){
		if( zw->UnknownTurn[i] == 0xff ){
			break;
		}
	}
	return i;
}
//----------------------------------------------------------
/**
 * @brief	Am[tH[ݒς݂`FbN
 */
//----------------------------------------------------------
static inline BOOL check_zukan_unknown_turn_set( const ZUKAN_WORK * zw, u8 form )
{
	int i;
	for( i=0; i<POKEZUKAN_UNKNOWN_NUM; i++ ){
		if( zw->UnknownTurn[i] == form ){
			return TRUE;
		}
	}
	return FALSE;
}
//----------------------------------------------------------
/**
 * @brief	Am[f[^̍ŌɌ`IDݒ
 */
//----------------------------------------------------------
static inline void SetZukanUnknownTurn( ZUKAN_WORK * zw, int form)
{
	int set_idx;

	// ݒς݂`FbN
	if( check_zukan_unknown_turn_set( zw, form ) ){
		return;
	}

	set_idx = get_zukan_unknown_turn_num( zw );
	if( set_idx < POKEZUKAN_UNKNOWN_NUM ){
		zw->UnknownTurn[ set_idx ] = form;
	}
}

//----------------------------------------------------------
/**
 * @brief	ȃ|P̌f[^̕ۑ
 */
//----------------------------------------------------------
static void SetZukanSpecialTurn(ZUKAN_WORK * zw, u16 monsno, POKEMON_PARAM* pp)
{
	int form;
	
	// Am[@E~EV@~mV̏Ԃ̐ݒ
	if( monsno == MONSNO_ANNOON ){
		form = PokemonUnknownFormGet( pp );
		SetZukanUnknownTurn( zw, form );
	}

	// E~EV@~mV͒n`Agr[gIDۑĂ
}

//----------------------------------------------------------
/**
 * @brief	eLXgo[WzCfbNXX^[io[擾
 */
//----------------------------------------------------------
static inline int get_zukan_textversion_idx(u16 monsno)
{
	return ZKN_WT_GetMonsNo_TEXTVERPokeNum( monsno );
}
//----------------------------------------------------------
/**
 * @brief	eLXgo[WtOݒ
 */
//----------------------------------------------------------
static void SetZukanTextVersionUp(ZUKAN_WORK * zw, u16 monsno, u32 lang)
{
	int idx;
	int zkn_world_text_code;
	
	
	idx = get_zukan_textversion_idx( monsno );
	zkn_world_text_code = ZKN_WT_GetLANG_Code_ZKN_WORLD_TEXT_Code( lang );

	// ̃|PɊOf[^͂Ȃ
	if(idx == ZKN_WORLD_TEXT_POKE_NUM){ return; }

	// ̍̊Of[^͂Ȃ
	if(zkn_world_text_code == ZKN_WORLD_TEXT_NUM){ return; }

	zw->TextVersionUp[ idx ] |= 1 << zkn_world_text_code;
}
//----------------------------------------------------------
/**
 * @brief	ʏ̃|Pʎ擾
 */
//----------------------------------------------------------
static u32 get_normal_poke_sex( const ZUKAN_WORK * zw, u16 monsno, int first_second )
{
	u32 sex_first, sex_second;
	u32 ret_sex;

	// ΂ɕsȃ|Pfirst͕ssecond̓G[Ԃ
	if( PokePersonalParaGet(monsno,ID_PER_sex) == MONS_UNKNOWN ){
		if( first_second == ZUKAN_WORK_SEX_FIRST ){
			return PARA_UNK;
		}else{
			return ZUKAN_WORK_GET_SEX_ERR;
		}
	}
	
	// Ɍʂݒ肳Ă̂`FbN邽߂
	// ǂ̏ꍇłŏɌʂ擾
	sex_first = check_sex_bit( zw, monsno, ZUKAN_WORK_SEX_FIRST );

	// Ɍʂ擾Ȃ玟Ɍʂ擾
	if( first_second == ZUKAN_WORK_SEX_SECOND ){
		sex_second = check_sex_bit( zw, monsno, ZUKAN_WORK_SEX_SECOND );

		// ŏɌʂƈꏏ==܂ĂȂ
		if( sex_second == sex_first ){
			ret_sex = ZUKAN_WORK_GET_SEX_ERR;
		}else{
			ret_sex = sex_second;
		}
	}else{
		ret_sex = sex_first;
	}

	return ret_sex;
}

//----------------------------------------------------------
/**
 * @brief	Am[Ԏ擾
 */
//----------------------------------------------------------
static inline int get_unknown_see_form( const ZUKAN_WORK * zw, int idx )
{
	return zw->UnknownTurn[ idx ];
}

//============================================================================================
//
//			񑀍p̊OJ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief		񃏁[N̏
 * @param	zw		񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_Init(ZUKAN_WORK * zw)
{
	memset(zw, 0, sizeof(ZUKAN_WORK));
	zw->zukan_magic = MAGIC_NUMBER;
	zw->zenkoku_flag = FALSE;

	// ߂܂ԃtOɃ_~[f[^ݒ
	memset( zw->UnknownTurn, 0xff, sizeof(u8) *  POKEZUKAN_UNKNOWN_NUM );
	memset( &zw->UmiUshiTurn, 0xff, sizeof(u8) );
	memset( &zw->MinoMushTurn, 0xff, sizeof(u8) );
}

//----------------------------------------------------------
/**
 * @brief	|P܂̎擾
 * @param	zw		񃏁[Nւ̃|C^
 * @return	u16		߂܂
 */
//----------------------------------------------------------
u16 ZukanWork_GetPokeGetCount(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return count_bit(zw->get_flag, POKEZUKAN_ARRAY_LEN);
}

//----------------------------------------------------------
/**
 * @brief	|P̎擾
 * @param	zw		񃏁[Nւ̃|C^
 * @return	u16		
 */
//----------------------------------------------------------
u16 ZukanWork_GetPokeSeeCount(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return count_bit(zw->see_flag, POKEZUKAN_ARRAY_LEN);
}

//----------------------------------------------------------
/**
 * @brief	|P߂܂ǂ̃tO擾
 * @param	zw		񃏁[Nւ̃|C^
 * @param	monsno	|Pio[
 * @return	BOOL	tO
 */
//----------------------------------------------------------
BOOL ZukanWork_GetPokeGetFlag(const ZUKAN_WORK * zw, u16 monsno)
{
	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return FALSE;
	}
	if (check_get_bit(zw, monsno) && check_see_bit(zw, monsno)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//----------------------------------------------------------
/**
 * @brief	|Pǂ̃tO擾
 * @param	zw		񃏁[Nւ̃|C^
 * @param	monsno	|Pio[
 * @return	BOOL	tO
 */
//----------------------------------------------------------
BOOL ZukanWork_GetPokeSeeFlag(const ZUKAN_WORK * zw, u16 monsno)
{
	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return FALSE;
	}
	return check_see_bit(zw, monsno);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̌擾
 *
 *	@param	zw			}Ӄ[Nւ̃|C^
 *	@param	random_poke	擾|P
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeRandomFlag(const ZUKAN_WORK * zw, u8 random_poke)
{
	u32 random;
	
	zukan_incorrect(zw);

	switch( random_poke ){
	case ZUKAN_WORK_RANDOM_PACHI:		// pb`[
		random = zw->PachiRandom;
		break;
		
	default:
		GF_ASSERT_MSG( 0, "random_poke = %d\n", random_poke );
		break;
	}

	return random;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P\Ƃ̐ʎ擾
 *
 *	@param	zw				񃏁[Nւ̃|C^
 *	@param	monsno			|Pio[
 *	@param	first_second	ŏɌʂɌʂ
 *
 *	@retval	PARA_MALE		IX
 *	@retval	PARA_FEMALE		X
 *	@retval	PARA_UNK		s	
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ʂ܂
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeSexFlag(const ZUKAN_WORK * zw, u16 monsno, int first_second )
{
	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return ZUKAN_WORK_GET_SEX_ERR;
	}
	// ĂȂƂ̓G[R[hԂ
	if( !check_see_bit(zw, monsno) ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}

	// m[}|P
	return get_normal_poke_sex( zw, monsno, first_second );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Am[ݒ
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Am[	(0`27)
 *	
 *	@retval	Am[tH[io[
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeAnoonForm(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);
	// ̐̃Am[tHĂ邩`FbN
	if( get_zukan_unknown_turn_num( zw ) <= count ){
		return ZUKAN_WORK_GET_SEX_ERR;
	}

	// tHԂ
	return get_unknown_see_form( zw, count );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Am[
 *
 *	@param	zw		}Ӄ[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeAnoonSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return get_zukan_unknown_turn_num( zw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	E~EVn`GAID擾
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Ԑ
 *
 *	@retval	n`GAID
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeUmiushiArea(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);
	return ZUKAN_WORK_GET_SEX_ERR;
}

//----------------------------------------------------------------------------
/**
 *	@brief	E~EṼtH
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	E~EṼtH
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeUmiushiSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	~mVtH擾
 *
 *	@param	zw		}Ӄ[N
 *	@param	count	Ԑ
 *
 *	@retval	n`GAID
 *	@retval	ZUKAN_WORK_GET_SEX_ERR	ĂȂ
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeMinomushiArea(const ZUKAN_WORK * zw, int count)
{
	zukan_incorrect(zw);
	return ZUKAN_WORK_GET_SEX_ERR;
}

//----------------------------------------------------------------------------
/**
 *	@brief	E~EṼtH
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	E~EṼtH
 */
//-----------------------------------------------------------------------------
u32 ZukanWork_GetPokeMinomushiSeeNum(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return 0;
}


//----------------------------------------------------------
/**
 * @brief	f[^Zbgij
 * @param	zw		񃏁[Nւ̃|C^
 * @param	pp		|PPOKEMON_PARAMւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_SetPokeSee(ZUKAN_WORK * zw, POKEMON_PARAM * pp)
{
	u16 monsno = PokeParaGet(pp, ID_PARA_monsno, NULL);
	u32 lang = PokeParaGet(pp, ID_PARA_country_code, NULL);
	u32 rand = PokeParaGet(pp, ID_PARA_power_rnd, NULL);
	u32 sex = PokeSexGet(pp);

	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return;
	}
	if (!check_see_bit(zw, monsno)) {
		SetZukanRandom(zw, monsno, rand);			// ő̗
		set_sex_bit( zw, sex, ZUKAN_WORK_SEX_FIRST, monsno );			// ŏɌ
	}else{
		set_sex_bit( zw, sex, ZUKAN_WORK_SEX_SECOND, monsno );			// Ɍ
	}

	SetZukanSpecialTurn(zw, monsno, pp);		// |P̌Ԑݒ
	SetZukanTextVersionUp(zw, monsno, lang);	// R[h
	set_see_bit(zw, monsno);
}

//----------------------------------------------------------
/**
 * @brief	f[^Zbgi߂܂j
 * @param	zw		񃏁[Nւ̃|C^
 * @param	pp		߂܂|PPOKEMON_PARAMւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_SetPokeGet(ZUKAN_WORK * zw, POKEMON_PARAM * pp)
{
	u16 monsno = PokeParaGet(pp, ID_PARA_monsno, NULL);
	u32 lang = PokeParaGet(pp, ID_PARA_country_code, NULL);
	u32 rand = PokeParaGet(pp, ID_PARA_power_rnd, NULL);
	u32 sex = PokeSexGet(pp);

	zukan_incorrect(zw);
	if (monsno_incorrect(monsno)) {
		return;
	}
	if (!check_see_bit(zw, monsno)) {
		SetZukanRandom(zw, monsno, rand);			// ő̗
		set_sex_bit( zw, sex, ZUKAN_WORK_SEX_FIRST, monsno );			// \
	}else{
		set_sex_bit( zw, sex, ZUKAN_WORK_SEX_SECOND, monsno );			// \
	}
	SetZukanSpecialTurn(zw, monsno, pp);		// |P̌Ԑݒ
	SetZukanTextVersionUp(zw, monsno, lang);	// R[h
	set_get_bit(zw, monsno);
	set_see_bit(zw, monsno);
}

//----------------------------------------------------------
/**
 * @brief	S񃂁[hZbg
 * @param	zw		񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
void ZukanWork_SetZenkokuZukanFlag(ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	zw->zenkoku_flag = TRUE;
}

//----------------------------------------------------------
/**
 * @brief	S񃂁[hǂH̖₢킹
 * @param	zw		񃏁[Nւ̃|C^
 * @retval	TRUE	S񃂁[hI[v
 * @retval	FALSE	VIE񃂁[h
 */
//----------------------------------------------------------
BOOL ZukanWork_GetZenkokuZukanFlag(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return zw->zenkoku_flag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNo[Wp@\gtO擾
 *
 *	@param	zw		񃏁[Nւ̃|C^
 *
 *	@retval	TRUE	o[WAbv
 *	@retval	FALSE	o[WAbv
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetGraphicVersionUpFlag(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return zw->GraphicVersionUp;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNo[Wp@\gtOݒ
 *
 *	@param	zw		}Ӄ[Nւ̃|C^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZukanWork_SetGraphicVersionUpFlag(ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	zw->GraphicVersionUp = 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӃeLXgo[W`FbN
 *
 *	@param	zw
 *	@param	monsno
 *	@param	country_code		R[h
 *
 *	@retval	TRUE	̍̃o[W\Ă悢
 *	@retval	FALSE	̍̃o[W\Ă͂Ȃ
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetTextVersionUpFlag(const ZUKAN_WORK * zw, u16 monsno, u32 country_code)
{
	int idx;


	GF_ASSERT( country_code < 8 );		// R[hő吔
	
	zukan_incorrect(zw);
	// eLXgo[Ŵ|P`FbN
	idx = get_zukan_textversion_idx(monsno);
	if( idx == ZKN_WORLD_TEXT_POKE_NUM ){ return FALSE; }

	// OeLXgpio[ɕϊ
	country_code = ZKN_WT_GetLANG_Code_ZKN_WORLD_TEXT_Code( country_code );

	// ̌̃tOĂ邩`FbN
	return (zw->TextVersionUp[idx] & (1<<country_code));
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӕێtO擾
 *
 *	@param	zw	}Ӄ[Nւ̃|C^
 *
 *	@retval	TRUE	ێ
 *	@retval	FALSE	ێĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ZukanWork_GetZukanGetFlag(const ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	return zw->zukan_get;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӕێtOݒ
 *
 *	@param	zw	}Ӄ[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZukanWork_SetZukanGetFlag(ZUKAN_WORK * zw)
{
	zukan_incorrect(zw);
	zw->zukan_get = TRUE;
}

//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	ZUKAN_WORK	񃏁[Nւ̃|C^
 */
//----------------------------------------------------------
ZUKAN_WORK * SaveData_GetZukanWork(SAVEDATA * sv)
{
	ZUKAN_WORK * zs;
	zs = SaveData_Get(sv, GMDATA_ID_ZUKANWORK);
	return zs;
}

//============================================================================================
//============================================================================================
// Am[@E~EV@~mV@̌ԂĂ
static inline void set_debag_special_poke_see_no( ZUKAN_WORK * zw, int monsno )
{
	int i;
	
	// Am[@E~EV@~mV̏Ԃ̐ݒ
	if( monsno == MONSNO_ANNOON ){
		for( i=0; i<POKEZUKAN_UNKNOWN_NUM; i++ ){
			SetZukanUnknownTurn( zw, i );
		}
	}

	// E~EV@~mV͒n`Agr[gIDۑĂ
}

// ʐݒ
static void set_debug_poke_sex( ZUKAN_WORK * zw, int monsno )
{
	int sex = PokePersonalParaGet( monsno, ID_PER_sex );
	
	if( sex == MONS_MALE ){
		// ʐݒ
		set_sex_bit( zw, PARA_MALE, ZUKAN_WORK_SEX_FIRST, monsno );
		return;
	}
	if( sex == MONS_FEMALE ){
		// ʐݒ
		set_sex_bit( zw, PARA_FEMALE, ZUKAN_WORK_SEX_FIRST, monsno );
		return;
	}
	if( sex == MONS_UNKNOWN ){
		// ʐݒ
		set_sex_bit( zw, PARA_UNK, ZUKAN_WORK_SEX_FIRST, monsno );
		return;
	}

	// ʐݒ
	if( monsno % 2 ){
		set_sex_bit( zw, PARA_MALE, ZUKAN_WORK_SEX_FIRST, monsno );
		set_sex_bit( zw, PARA_FEMALE, ZUKAN_WORK_SEX_SECOND, monsno );
	}else{
		set_sex_bit( zw, PARA_FEMALE, ZUKAN_WORK_SEX_FIRST, monsno );
		set_sex_bit( zw, PARA_MALE, ZUKAN_WORK_SEX_SECOND, monsno );
	}
}

//----------------------------------------------------------
/**
 * @brief	fobOpFf[^
 * @param	zw			񃏁[Nւ̃|C^
 * @param	option
 */
//----------------------------------------------------------
void Debug_ZukanWork_Make(ZUKAN_WORK * zw, int option)
{
	int i;
	int rnd;
	zukan_incorrect(zw);
	for (i = 1; i <= MONSNO_END; i++) {
		set_get_bit(zw, i);
		set_see_bit(zw, i);

		// O}Ӑݒ
		SetZukanTextVersionUp(zw, i, LANG_JAPAN);
		SetZukanTextVersionUp(zw, i, LANG_ENGLISH);
		SetZukanTextVersionUp(zw, i, LANG_FRANCE);
		SetZukanTextVersionUp(zw, i, LANG_ITALY);
		SetZukanTextVersionUp(zw, i, LANG_GERMANY);
		SetZukanTextVersionUp(zw, i, LANG_SPAIN);

		// ݒ
		rnd = PokePersonalParaGet(i,ID_PARA_personal_rnd);
		SetZukanRandom( zw, i, rnd );

		// ꌩԐݒ
		set_debag_special_poke_see_no( zw, i );

		// 	
		set_debug_poke_sex( zw, i );
	}

	// OtBbNo[WAbv
	ZukanWork_SetGraphicVersionUpFlag(zw);
}
