
//============================================================================================
/**
 * @file	arc_tool.c
 * @bfief	A[JCopc[vO
 * @author	HisashiSogabe
 * @date	05.05.30
 */
//============================================================================================

#include "common.h"
#define	 __ARC_TOOL_DAT_TBL_	//A[JCot@Ce[uLɂ邽߂̒`
#include "system/arc_tool.h"
#include "arc_tool_def.h"

static	void	ArchiveDataLoadIndex(void *data,const char *name,int index,int ofs,int ofs_size);
static	void	*ArchiveDataLoadIndexMalloc(const char *name,int index,int heap_id,int ofs,int ofs_size,int flag);

void	ArchiveDataLoad(void *data,int file_kind,int index);
void	*ArchiveDataLoadMalloc(int file_kind,int index,int heap_id);
void	*ArchiveDataLoadMallocLo(int file_kind,int index,int heap_id);
void	ArchiveDataLoadOfs(void *data,int file_kind,int index,int ofs,int size);
void	*ArchiveDataLoadMallocOfs(int file_kind,int index,int heap_id,int ofs,int size);
void	*ArchiveDataLoadMallocOfsLo(int file_kind,int index,int heap_id,int ofs,int size);
u16		ArchiveDataFileCntGet(int file_kind,int index);
u32		ArchiveDataSizeGet(int file_kind,int index);

void	ArchiveDataLoadByHandleContinue( ARCHANDLE* handle, u32 size, void* buffer );

#define	ALLOC_HEAD	(0)		//̈mۂƂ擪m
#define	ALLOC_TAIL	(1)		//̈mۂƂ납m

//============================================================================================
/**
 *
 *	nnsarcō쐬A[JCut@Cɑ΂Indexw肵ĔCӂ̃f[^o
 *
 * @param[in]	data		ǂݍ񂾃f[^i[郏[Ñ|C^
 * @param[in]	name		ǂݍރA[JCut@C
 * @param[in]	index		ǂݍރf[^̃A[JCũCfbNXio[
 * @param[in]	ofs			ǂݍރf[^̐擪̃ItZbg
 * @param[in]	ofs_size	ǂݍރf[^TCY
 *
 */
//============================================================================================
static	void	ArchiveDataLoadIndex(void *data,const char *name,int index,int ofs,int ofs_size)
{
	FSFile		p_file;
	u32			size=0;
	u32			fat_top=0;
	u32			fnt_top=0;
	u32			img_top=0;
	u32			top=0;
	u32			bottom=0;
	u16			file_cnt=0;

	FS_InitFile(&p_file);
	FS_OpenFile(&p_file,name);
	FS_SeekFile(&p_file,ARC_HEAD_SIZE_POS,FS_SEEK_SET);				///<A[JCuwb_̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,2);									///<A[JCuwb_TCY[h
	fat_top=size;
	FS_SeekFile(&p_file,fat_top+SIZE_OFFSET,FS_SEEK_SET);			///<FAT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FATTCY[h
	FS_ReadFile(&p_file,&file_cnt,2);								///<FileCount[h
	GF_ASSERT_MSG(file_cnt>index,"ServerArchiveDataLoadIndex file=%s, fileCnt=%d, index=%d", name, file_cnt, index);
	fnt_top=fat_top+size;
	FS_SeekFile(&p_file,fnt_top+SIZE_OFFSET,FS_SEEK_SET);			///<FNT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FNTTCY[h
	img_top=fnt_top+size;
	
	FS_SeekFile(&p_file,fat_top+FAT_HEAD_SIZE+index*8,FS_SEEK_SET);	///<oFATe[uɈړ
	FS_ReadFile(&p_file,&top,4);									///<FATe[utop[h
	FS_ReadFile(&p_file,&bottom,4);									///<FATe[ubottom[h

	FS_SeekFile(&p_file,img_top+IMG_HEAD_SIZE+top+ofs,FS_SEEK_SET);	///<oIMG̐擪Ɉړ
	
	if(ofs_size){
		size=ofs_size;
	}
	else{
		size=bottom-top;
	}

	GF_ASSERT_MSG(size!=0,"ServerArchiveDataLoadIndex:ReadDataSize=0!");
	FS_ReadFile(&p_file,data,size);									///<f[^[h

	FS_CloseFile(&p_file);
}


//============================================================================================
/**
 *
 *	nnsarcō쐬A[JCut@Cɑ΂Indexw肵ĔCӂ̃f[^o
 *	ǂݍ񂾃f[^i[郏[N̊֐ŊmۂāA|C^Ԃ
 *
 * @param[in]	name		ǂݍރA[JCut@C
 * @param[in]	index		ǂݍރf[^̃A[JCũCfbNXio[
 * @param[in]	heap_id		mۂq[v̈ID
 * @param[in]	ofs			ǂݍރf[^̐擪̃ItZbg
 * @param[in]	ofs_size	ǂݍރf[^TCY
 * @param[in]	flag		̈̑Oǂ炩mۂ邩tO
 *
 */
//============================================================================================
static	void	*ArchiveDataLoadIndexMalloc(const char *name,int index,int heap_id,int ofs,int ofs_size,int flag)
{
	FSFile		p_file;
	u32			size=0;
	u32			fat_top=0;
	u32			fnt_top=0;
	u32			img_top=0;
	u32			top=0;
	u32			bottom=0;
	void		*data;
	u16			file_cnt=0;

	FS_InitFile(&p_file);
	FS_OpenFile(&p_file,name);
	FS_SeekFile(&p_file,ARC_HEAD_SIZE_POS,FS_SEEK_SET);				///<A[JCuwb_̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,2);									///<A[JCuwb_TCY[h
	fat_top=size;
	FS_SeekFile(&p_file,fat_top+SIZE_OFFSET,FS_SEEK_SET);			///<FAT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FATTCY[h
	FS_ReadFile(&p_file,&file_cnt,2);								///<FileCount[h
	GF_ASSERT_MSG(file_cnt>index,"ServerArchiveDataLoadIndex file=%s, fileCnt=%d, index=%d", name, file_cnt, index);
	fnt_top=fat_top+size;
	FS_SeekFile(&p_file,fnt_top+SIZE_OFFSET,FS_SEEK_SET);			///<FNT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FNTTCY[h
	img_top=fnt_top+size;
	
	FS_SeekFile(&p_file,fat_top+FAT_HEAD_SIZE+index*8,FS_SEEK_SET);	///<oFATe[uɈړ
	FS_ReadFile(&p_file,&top,4);									///<FATe[utop[h
	FS_ReadFile(&p_file,&bottom,4);									///<FATe[ubottom[h

	FS_SeekFile(&p_file,img_top+IMG_HEAD_SIZE+top+ofs,FS_SEEK_SET);		///<oIMG̐擪Ɉړ

	if(ofs_size){
		size=ofs_size;
	}
	else{
		size=bottom-top;
	}
	GF_ASSERT_MSG(size!=0,"ServerArchiveDataLoadIndex:ReadDataSize=0!");
	if(flag==ALLOC_HEAD){
		data=sys_AllocMemory(heap_id,size);
	}
	else{
		data=sys_AllocMemoryLo(heap_id,size);
	}
	FS_ReadFile(&p_file,data,size);									///<f[^[h

	FS_CloseFile(&p_file);

	return data;
}

//============================================================================================
/**
 * A[JCut@Cf[^[h
 *
 * @param[in]	data		ǂݍ񂾃f[^i[郏[Ñ|C^
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 */
//============================================================================================
void	ArchiveDataLoad(void *data, int arcID, int datID)
{
	ArchiveDataLoadIndex(data, ArchiveFileTable[arcID], datID, OFS_NO_SET, SIZE_NO_SET);
}

//============================================================================================
/**
 * A[JCut@Cf[^[hiǂݍ񂾃f[^i[郏[N֐Ŋmۂo[Wj
 *
 * ֐Ń[NAlloĉŁAOŊJKv܂(sys_FreeMemoryEz(̈|C^)ŊJj
 *
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 * @param[in]	heap_id		mۂq[v̈ID
 *
 * @retval	֐Ŋmۂf[^i[[ÑAhX
 */
//============================================================================================
void* ArchiveDataLoadMalloc(int arcID, int datID, int heapID)
{
	return	ArchiveDataLoadIndexMalloc(ArchiveFileTable[arcID],datID,heapID,OFS_NO_SET,SIZE_NO_SET,ALLOC_HEAD);
}

//============================================================================================
/**
 * A[JCut@Cf[^[hiǂݍ񂾃f[^i[郏[N֐Ŋmۂo[Wï̌납mہjj
 *
 * ֐Ń[NAlloĉŁAOŊJKv܂(sys_FreeMemoryEz(̈|C^)ŊJj
 *
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 * @param[in]	heapID		mۂq[v̈ID
 *
 * @retval	֐Ŋmۂf[^i[[ÑAhX
 */
//============================================================================================
void* ArchiveDataLoadMallocLo(int arcID, int datID, int heapID)
{
	return	ArchiveDataLoadIndexMalloc(ArchiveFileTable[arcID], datID, heapID, OFS_NO_SET, SIZE_NO_SET, ALLOC_TAIL);
}

//============================================================================================
/**
 * A[JCut@Cf[^[hiItZbgw肠j
 *
 * @param[in]	data		ǂݍ񂾃f[^i[郏[Ñ|C^
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 * @param[in]	ofs			ǂݍރf[^̐擪̃ItZbg
 * @param[in]	size		ǂݍރf[^TCY
 */
//============================================================================================
void ArchiveDataLoadOfs(void *data, int arcID, int datID, int ofs, int size)
{
	ArchiveDataLoadIndex(data, ArchiveFileTable[arcID], datID, ofs, size);
}

//============================================================================================
/**
 * A[JCut@Cf[^[hiǂݍ񂾃f[^i[郏[N֐Ŋmۂo[WƃItZbgw肠j
 *
 * ֐Ń[NAlloĉŁAOŊJKv܂(sys_FreeMemoryEz(̈|C^)ŊJj
 *
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 * @param[in]	heapID		mۂq[v̈ID
 * @param[in]	ofs			ǂݍރf[^̐擪̃ItZbg
 * @param[in]	size		ǂݍރf[^TCY
 *
 * @retval	֐Ŋmۂf[^i[[ÑAhX
 */
//============================================================================================
void* ArchiveDataLoadMallocOfs(int arcID, int datID, int heapID, int ofs, int size)
{
	return	ArchiveDataLoadIndexMalloc(ArchiveFileTable[arcID],datID,heapID,ofs,size,ALLOC_HEAD);
}

//============================================================================================
/**
 * A[JCut@Cf[^[hiǂݍ񂾃f[^i[郏[N֐Ŋmۂo[WƃItZbgw肠j
 *
 * ֐Ń[NAlloĉŁAOŊJKv܂(sys_FreeMemoryEz(̈|C^)ŊJj
 *
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 * @param[in]	heapID		mۂq[v̈ID
 * @param[in]	ofs			ǂݍރf[^̐擪̃ItZbg
 * @param[in]	size		ǂݍރf[^TCY
 *
 * @retval	֐Ŋmۂf[^i[[ÑAhX
 */
//============================================================================================
void	*ArchiveDataLoadMallocOfsLo(int arcID, int datID, int heapID, int ofs, int size)
{
	return	ArchiveDataLoadIndexMalloc(ArchiveFileTable[arcID],datID,heapID,ofs,size,ALLOC_TAIL);
}

//============================================================================================
/**
 * A[JCut@Cf[^̃t@C擾
 *
 * @param[in]	arcID	ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 */
//============================================================================================
u16		ArchiveDataFileCntGet(int arcID, int datID)
{
	FSFile		p_file;
	u32			size=0;
	u32			fat_top=0;
	u16			file_cnt=0;

	FS_InitFile(&p_file);
	FS_OpenFile(&p_file,ArchiveFileTable[arcID]);
	FS_SeekFile(&p_file,ARC_HEAD_SIZE_POS,FS_SEEK_SET);				///<A[JCuwb_̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,2);									///<A[JCuwb_TCY[h
	fat_top=size;
	FS_SeekFile(&p_file,fat_top+SIZE_OFFSET,FS_SEEK_SET);			///<FAT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FATTCY[h
	FS_ReadFile(&p_file,&file_cnt,2);								///<FileCount[h

	return	file_cnt;
}

//============================================================================================
/**
 * A[JCut@Cf[^̃TCY擾
 *
 *	ArchiveDataLoadgp鎞Amۂ郁TCY擾̂Ɏgp܂
 *
 * @param[in]	arcID		ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLqj
 * @param[in]	datID		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 */
//============================================================================================
u32		ArchiveDataSizeGet(int arcID,int datID)
{
	FSFile		p_file;
	u32			size=0;
	u32			fat_top=0;
	u32			fnt_top=0;
	u32			img_top=0;
	u32			top=0;
	u32			bottom=0;
	void		*data;
	u16			file_cnt=0;

	FS_InitFile(&p_file);
	FS_OpenFile(&p_file,ArchiveFileTable[arcID]);
	FS_SeekFile(&p_file,ARC_HEAD_SIZE_POS,FS_SEEK_SET);				///<A[JCuwb_̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,2);									///<A[JCuwb_TCY[h
	fat_top=size;
	FS_SeekFile(&p_file,fat_top+SIZE_OFFSET,FS_SEEK_SET);			///<FAT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FATTCY[h
	FS_ReadFile(&p_file,&file_cnt,2);								///<FileCount[h
	GF_ASSERT_MSG(file_cnt>datID,"ServerArchiveDataLoadIndex:FileCnt<Index");
	fnt_top=fat_top+size;
	FS_SeekFile(&p_file,fnt_top+SIZE_OFFSET,FS_SEEK_SET);			///<FNT̃TCYi[ʒuɈړ
	FS_ReadFile(&p_file,&size,4);									///<FNTTCY[h
	img_top=fnt_top+size;
	
	FS_SeekFile(&p_file,fat_top+FAT_HEAD_SIZE+datID*8,FS_SEEK_SET);	///<oFATe[uɈړ
	FS_ReadFile(&p_file,&top,4);									///<FATe[utop[h
	FS_ReadFile(&p_file,&bottom,4);									///<FATe[ubottom[h

	FS_SeekFile(&p_file,img_top+IMG_HEAD_SIZE+top,FS_SEEK_SET);		///<oIMG̐擪Ɉړ
	size=bottom-top;
	GF_ASSERT_MSG(size!=0,"ServerArchiveDataLoadIndex:ReadDataSize=0!");

	return	size;
}




//--------------------------------------------------------
/**
 * A[JCut@C̃nhǗ\
 */
//--------------------------------------------------------
struct _ARCHANDLE{
	FSFile  file;
	u32     fat_top;
	u32     img_top;
	u16		file_cnt;
};


//------------------------------------------------------------------
/**
 * A[JCuf[^̃t@CnhI[v
 *
 * @param   arcId		A[JCuf[^CfbNX
 * @param   heapId		Ǘpq[vhc
 *
 * @retval  ARCHANDLE	I[vꂽnh̃|C^isȂNULLj
 */
//------------------------------------------------------------------
ARCHANDLE* ArchiveDataHandleOpen( u32 arcId, u32 heapId )
{
	ARCHANDLE* handle = sys_AllocMemory( heapId, sizeof(ARCHANDLE) );
	if( handle )
	{
		u32 fnt_top, tmp;

		// QoCgǂݍ񂾎ɃS~Ȃ悤ɂĂ
		handle->fat_top = 0;

		FS_InitFile( &(handle->file) );
		FS_OpenFile( &(handle->file), ArchiveFileTable[arcId] );
		FS_SeekFile( &(handle->file), ARC_HEAD_SIZE_POS, FS_SEEK_SET );
		FS_ReadFile( &(handle->file), &(handle->fat_top), 2 );
		FS_SeekFile( &(handle->file), handle->fat_top+SIZE_OFFSET, FS_SEEK_SET );
		FS_ReadFile( &(handle->file), &tmp, 4 );
		FS_ReadFile( &(handle->file), &(handle->file_cnt), 2 );
		fnt_top = handle->fat_top + tmp;
		FS_SeekFile( &(handle->file), fnt_top+SIZE_OFFSET, FS_SEEK_SET );
		FS_ReadFile( &(handle->file), &tmp, 4 );
		handle->img_top = fnt_top + tmp;

	}
	return handle;
}

//------------------------------------------------------------------
/**
 * A[JCuf[^̃nhN[Y
 *
 * @param   handle			nh|C^
 *
 */
//------------------------------------------------------------------
void ArchiveDataHandleClose( ARCHANDLE* handle )
{
	FS_CloseFile( &(handle->file) );
	sys_FreeMemoryEz( handle );
}

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾iŃAP[gɁj
 *
 * @param   handle			nh|C^
 * @param   datID			A[JCũf[^CfbNX
 * @param   heapID			AP[gp̃q[vhc
 *
 * @retval  u32				f[^TCYioCgj
 */
//------------------------------------------------------------------
void* ArchiveDataLoadAllocByHandle( ARCHANDLE* handle, u32 datId, u32 heapID )
{
	u32 top, bottom;
	void* buf;

	GF_ASSERT_MSG(handle->file_cnt>datId, "DatCount=%d, DatID=%d", handle->file_cnt, datId);

	FS_SeekFile( &(handle->file), handle->fat_top+FAT_HEAD_SIZE+datId*8, FS_SEEK_SET );
	FS_ReadFile( &(handle->file), &top, 4 );
	FS_ReadFile( &(handle->file), &bottom, 4 );
	FS_SeekFile( &(handle->file), handle->img_top+IMG_HEAD_SIZE+top, FS_SEEK_SET );

	buf = sys_AllocMemory(heapID, bottom-top);
	if( buf )
	{
		FS_ReadFile( &(handle->file), buf, bottom-top );
	}

	return buf;
}

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾
 *
 * @param   handle		nh|C^
 * @param   datId		A[JCũf[^CfbNX
 * @param   buffer		f[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
void ArchiveDataLoadByHandle( ARCHANDLE* handle, u32 datId, void* buffer )
{
	u32 top, bottom;

	GF_ASSERT_MSG(handle->file_cnt>datId, "DatCount=%d, DatID=%d", handle->file_cnt, datId);

	FS_SeekFile( &(handle->file), handle->fat_top+FAT_HEAD_SIZE+datId*8, FS_SEEK_SET );
	FS_ReadFile( &(handle->file), &top, 4 );
	FS_ReadFile( &(handle->file), &bottom, 4 );
	FS_SeekFile( &(handle->file), handle->img_top+IMG_HEAD_SIZE+top, FS_SEEK_SET );

	FS_ReadFile( &(handle->file), buffer, bottom-top );
}

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾iǂݍ݊JnItZbgTCYwj
 *
 * @param   handle		nh|C^
 * @param   datId		A[JCũf[^CfbNX
 * @param   ofs			ǂݍ݊JnItZbg
 * @param   size		ǂݍ݃TCY
 * @param   buffer		f[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
void ArchiveDataLoadOfsByHandle( ARCHANDLE* handle, u32 datId, u32 ofs, u32 size, void* buffer )
{
	u32 top;

	GF_ASSERT_MSG(handle->file_cnt>datId, "DatCount=%d, DatID=%d", handle->file_cnt, datId);

	FS_SeekFile( &(handle->file), handle->fat_top+FAT_HEAD_SIZE+datId*8, FS_SEEK_SET );
	FS_ReadFile( &(handle->file), &top, 4 );
	FS_SeekFile( &(handle->file), handle->img_top+IMG_HEAD_SIZE+top+ofs, FS_SEEK_SET );

	FS_ReadFile( &(handle->file), buffer, size );
}

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăC[Wf[^ItZbg擾
 *
 * @param   handle		nh|C^
 * @param   datId		A[JCũf[^CfbNX
 * @param   offset		ItZbgǂݍݐobt@
 *
 */
//------------------------------------------------------------------
void ArchiveDataLoadImgofsByHandle( ARCHANDLE* handle, u32 datId, u32* offset )
{
	u32 top;

	GF_ASSERT_MSG(handle->file_cnt>datId, "DatCount=%d, DatID=%d", handle->file_cnt, datId);

	FS_SeekFile( &(handle->file), handle->fat_top+FAT_HEAD_SIZE+datId*8, FS_SEEK_SET );
	FS_ReadFile( &(handle->file), &top, 4 );
	
	*offset = handle->img_top+IMG_HEAD_SIZE+top;
}

//------------------------------------------------------------------
/**
 * A[JCuf[^nhgăf[^擾it@Cnh̑ǂݍ݁j
 *
 * @param   handle		nh|C^
 * @param   size		ǂݍ݃TCY
 * @param   buffer		f[^ǂݍݐobt@
 *
 */
//------------------------------------------------------------------
void ArchiveDataLoadByHandleContinue( ARCHANDLE* handle, u32 size, void* buffer )
{
	FS_ReadFile( &(handle->file), buffer, size );
}

//------------------------------------------------------------------
/**
 * A[JCuf[^nhăt@CV[N
 *
 * @param   handle		nh|C^
 * @param   size
 *
 */
//------------------------------------------------------------------
void ArchiveDataSeekByHandle( ARCHANDLE* handle, u32 size )
{
	FS_SeekFile( &(handle->file), size, FS_SEEK_SET );
}

