//============================================================================================
/**
 * @file	arc_util.c
 * @bfief	A[JCuf[^֗Ɏg߂̃[eBeB֐Q
 * @author	taya
 * @date	05.08.30
 */
//============================================================================================
#include "common.h"

#include "system\arc_tool.h"
#include "system\arc_util.h"


//==============================================================
// Prototype
//==============================================================



//------------------------------------------------------------------
/**
 * BGް VRAM ]
 *
 * @param   fileIdx			̧ٲޯ
 * @param   dataIndex		ްޯ
 * @param   bgl				BGLް
 * @param   frm				]ڰ
 * @param   offs			]̾āiגPʁj
 * @param	transSize		]黲ށi޲ĒP ==0őS]j
 * @param   compressedFlag	kĂްH
 * @param   heapID			ްǂݍ݁E؂ƂĎg˰ID
 *
 * @return  ]f[^TCYioCgj
 */
//------------------------------------------------------------------
u32 ArcUtil_BgCharSet(u32 fileIdx, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID)
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		NNSG2dCharacterData* charData;

		if( NNS_G2dGetUnpackedBGCharacterData( arcData, &charData ) )
		{
			if( transSize == 0 )
			{
				transSize = charData->szByte;
			}
			GF_BGL_LoadCharacter(bgl, frm, charData->pRawData, transSize, offs);
		}

		sys_FreeMemoryEz( arcData );
	}
    return transSize;
}
//--------------------------------------------------------------------------------------------
/**
 * ذް VRAM ]
 *  BGL ذޯ̧ pӂĂ΁Aذޯ̧ ւ̓]s
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   bgl				BGLް
 * @param   frm				]ڰ
 * @param   offs			]̾āiגPʁj
 * @param	transSize		]黲ށi޲ĒP ==0őS]j
 * @param   compressedFlag	kĂްH
 * @param   heapID			ްǂݍ݁E؂ƂĎg˰ID
 *
 */
//--------------------------------------------------------------------------------------------
void ArcUtil_ScrnSet(u32 fileIdx, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID)
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dScreenData* scrnData;

		if( NNS_G2dGetUnpackedScreenData( arcData, &scrnData ) )
		{
			if( transSize == 0 )
			{
				transSize = scrnData->szByte;
			}

			if( GF_BGL_ScreenAdrsGet( bgl, frm ) != NULL )
			{
				GF_BGL_ScreenBufSet( bgl, frm, scrnData->rawData, transSize );
			}
			GF_BGL_LoadScreen( bgl, frm, scrnData->rawData, transSize, offs );
		}
		sys_FreeMemoryEz( arcData );
	}
}
//------------------------------------------------------------------
/**
 * گް  VRAM ]
 *
 * @param   fileIdx		̧ٲޯ
 * @param   dataIdx		ްޯ
 * @param   palType		گē]
 * @param   offs		گē]̾
 * @param   transSize	گē]ށi0 őS]j
 * @param   heapID		ްǂݍ؂ƂĎg˰ID
 *
 */
//------------------------------------------------------------------
void ArcUtil_PalSet( u32 fileIdx, u32 dataIdx, PALTYPE palType, u32 offs, u32 transSize, u32 heapID )
{
	static void (* const load_func[])(const void*, u32, u32) = {
		GX_LoadBGPltt,
		GX_LoadOBJPltt,
		GX_LoadBGExtPltt,
		GX_LoadOBJExtPltt,
		GXS_LoadBGPltt,
		GXS_LoadOBJPltt,
		GXS_LoadBGExtPltt,
		GXS_LoadOBJExtPltt,
	};

	void* arcData = ArcUtil_Load( fileIdx, dataIdx, FALSE, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dPaletteData* palData;

		if( NNS_G2dGetUnpackedPaletteData( arcData, &palData ) )
		{
			if( transSize == 0 )
			{
				transSize = palData->szByte;
			}
			DC_FlushRange( palData->pRawData, transSize );
			load_func[ palType ]( palData->pRawData, offs, transSize );
		}

		sys_FreeMemoryEz( arcData );
	}
}

//------------------------------------------------------------------
/**
 * OBJ ް  VRAM ]
 *
 * @param   fileIdx				̧ٲޯ
 * @param   dataIdx				ްޯ
 * @param   objType				OBJ(OBJTYPE_MAIN or OBJTYPE_SUBj
 * @param   offs				̾āi޲ĒPʁj
 * @param   transSize			]ށi޲ĒP : 0 őS]j
 * @param   compressedFlag		kꂽްH
 * @param   heapID				ǂݍ݁E؂ƂĎg˰ID
 *
 * @return  ]f[^TCYioCgj
 */
//------------------------------------------------------------------
u32 ArcUtil_ObjCharSet( u32 fileIdx, u32 dataIdx, OBJTYPE objType, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID )
{
	static void (* const load_func[])(const void*, u32, u32) = {
		GX_LoadOBJ,
		GXS_LoadOBJ,
	};

	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dCharacterData* charData;

		if( NNS_G2dGetUnpackedCharacterData( arcData, &charData ) )
		{
			if( transSize == 0 )
			{
				transSize = charData->szByte;
			}

			DC_FlushRange( charData->pRawData, transSize );
			load_func[ objType ]( charData->pRawData, offs, transSize );
		}
		sys_FreeMemoryEz( arcData );
	}
	return transSize;
}

//------------------------------------------------------------------
/**
 * گް  VRAM ] NITRO System گ۷ 쐬
 *i3D, OBJ pɂ̂ݑΉBBG ɂ͎g܂j
 *
 * @param   fileIdx		[in] ̧ٲޯ
 * @param   dataIdx		[in] ްޯ
 * @param   type		[in] ]
 * @param   offs		[in] ]̾
 * @param   heapID		[in] ˰ID
 * @param   proxy		[out]쐬۷ڽ
 *
 *	[ type ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
void ArcUtil_PalSysLoad( u32 fileIdx, u32 dataIdx, NNS_G2D_VRAM_TYPE type, u32 offs, u32 heapID, NNSG2dImagePaletteProxy* proxy )
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, FALSE, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dPaletteData*  palData;
		NNSG2dPaletteCompressInfo*  cmpData;
		BOOL  cmpFlag;

		cmpFlag = NNS_G2dGetUnpackedPaletteCompressInfo( arcData, &cmpData );

		if( NNS_G2dGetUnpackedPaletteData( arcData, &palData ) )
		{
			if( cmpFlag )
			{
				NNS_G2dLoadPaletteEx( palData, cmpData, offs, type, proxy );
			}
			else
			{
				NNS_G2dLoadPalette( palData, offs, type, proxy );
			}
		}

		sys_FreeMemoryEz( arcData );
	}
}
//------------------------------------------------------------------
/**
 * ް  VRAM ] NITRO System Ұ۷ 쐬
 *i3D, OBJ pɂ̂ݑΉBBG ɂ͎g܂j
 *
 *
 * @param   fileIdx			[in] ̧ٲޯ
 * @param   dataIdx			[in] ްޯ
 * @param   compressedFlag	[in] kĂ邩
 * @param   mapType			[in] ϯݸ
 * @param   transSize		[in] ]TCYBOȂS]B
 * @param   vramType		[in] ]
 * @param   offs			[in] ]̾
 * @param   heapID			[in] ؂Ɏg˰ID
 * @param   proxy			[out] 쐬۷ڽ
 *
 *
 *	[ mapType ]
 *		CHAR_MAP_1D = 0,
 *		CHAR_MAP_2D = 1,
 *
 *	 VRAM]^͕ʊ֐ ArcUtil_TranCharSysLoad g
 *
 *	[ vramType ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
void ArcUtil_CharSysLoad( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, CHAR_MAPPING_TYPE mapType, u32 transSize,
	NNS_G2D_VRAM_TYPE vramType, u32 offs, u32 heapID, NNSG2dImageProxy* proxy )
{
	static void (* const load_func[])(const NNSG2dCharacterData*, u32, NNS_G2D_VRAM_TYPE, NNSG2dImageProxy*) = {
		NNS_G2dLoadImage1DMapping,
		NNS_G2dLoadImage2DMapping,
	};

	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dCharacterData* charData;

		if( NNS_G2dGetUnpackedCharacterData( arcData, &charData ) )
		{
			if( transSize )
			{
				charData->szByte = transSize;
			}
			load_func[ mapType ]( charData, offs, vramType, proxy );
		}
		sys_FreeMemoryEz( arcData );
	}
}
//------------------------------------------------------------------
/**
 * ް  VRAM ] NITRO System Ұ۷ 쐬
 *i3D, OBJ pɂ̂ݑΉBBG ɂ͎g܂j
 *
 * ްϯݸӰޒlA݂ڼ޽ݒɍ킹ď܂
 *
 * @param   fileIdx			[in] ̧ٲޯ
 * @param   dataIdx			[in] ްޯ
 * @param   compressedFlag	[in] kĂ邩
 * @param   mapType			[in] ϯݸ
 * @param   transSize		[in] ]TCYBOȂS]B
 * @param   vramType		[in] ]
 * @param   offs			[in] ]̾
 * @param   heapID			[in] ؂Ɏg˰ID
 * @param   proxy			[out] 쐬۷ڽ
 *
 *
 *	[ mapType ]
 *		CHAR_MAP_1D = 0,
 *		CHAR_MAP_2D = 1,
 *
 *	 VRAM]^͕ʊ֐ ArcUtil_TranCharSysLoad g
 *
 *	[ vramType ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
void ArcUtil_CharSysLoadSyncroMappingMode( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, CHAR_MAPPING_TYPE mapType, u32 transSize,
	NNS_G2D_VRAM_TYPE vramType, u32 offs, u32 heapID, NNSG2dImageProxy* proxy )
{
	static void (* const load_func[])(const NNSG2dCharacterData*, u32, NNS_G2D_VRAM_TYPE, NNSG2dImageProxy*) = {
		NNS_G2dLoadImage1DMapping,
		NNS_G2dLoadImage2DMapping,
	};

	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_BOTTOM );

	if( arcData != NULL )
	{
		NNSG2dCharacterData* charData;

		if( NNS_G2dGetUnpackedCharacterData( arcData, &charData ) )
		{
			if( transSize )
			{
				charData->szByte = transSize;
			}

			switch( vramType ){
			case NNS_G2D_VRAM_TYPE_2DMAIN:
				charData->mapingType = GX_GetOBJVRamModeChar();
				break;
			case NNS_G2D_VRAM_TYPE_2DSUB:
				charData->mapingType = GXS_GetOBJVRamModeChar();
				break;
			}
			load_func[ mapType ]( charData, offs, vramType, proxy );
		}
		sys_FreeMemoryEz( arcData );
	}
}

//------------------------------------------------------------------
/**
 * ް  VRAM ] NITRO System Ұ۷ 쐬BVRAM]^̉摜fޗpB
 *
 *  ̊֐gĂAVRAMɉ摜͓]܂
 *    ̊֐۰ން͉܂B߂lconst void*ǗāA
 *    svɂȂsĂB
 *
 * @param   fileIdx			[in] ̧ٲޯ
 * @param   dataIdx			[in] ްޯ
 * @param   compressedFlag	[in] kĂ邩
 * @param   vramType		[in] ]
 * @param   offs			[in] ]̾
 * @param   heapID			[in] ؂Ɏg˰ID
 * @param   proxy			[out] 쐬۷̱ڽ
 * @param   charData		[out] ްڽێ߲̱ڽ
 *
 * @retval  const void*		۰ން̱ڽ
 *
 *	[ vramType ]
 *		NNS_G2D_VRAM_TYPE_3DMAIN = 0,
 *		NNS_G2D_VRAM_TYPE_2DMAIN = 1,
 *		NNS_G2D_VRAM_TYPE_2DSUB  = 2,
 *
 */
//------------------------------------------------------------------
const void* ArcUtil_TransTypeCharSysLoad( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, 
	NNS_G2D_VRAM_TYPE vramType, u32 offs, u32 heapID, NNSG2dImageProxy* proxy, NNSG2dCharacterData** charData )
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedCharacterData( arcData, charData ) )
		{
			NNS_G2dLoadImageVramTransfer( *charData, offs, vramType, proxy );
		}
	}
	return arcData;
}



//------------------------------------------------------------------
/**
 * ް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx				[in] ̧ٲޯ
 * @param   dataIdx				[in] ްޯ
 * @param   compressedFlag		[in] kĂ邩
 * @param   charData			[out] ްڽێ߲̱ڽ
 * @param   heapID				[in] ˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//------------------------------------------------------------------
void* ArcUtil_CharDataGet( u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dCharacterData** charData, u32 heapID )
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedBGCharacterData( arcData, charData ) == FALSE)
		{
			// sNULL
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}
//--------------------------------------------------------------------------------------------
/**
 * ذް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			[in] ̧ٲޯ
 * @param   arcIndex		[in] ްޯ
 * @param   compressedFlag	[in] kĂްH
 * @param   scrnData		[out] ذްڽێ߲̱ڽ
 * @param   heapID			[in] ˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
void* ArcUtil_ScrnDataGet(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dScreenData** scrnData, u32 heapID)
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedScreenData( arcData, scrnData ) == FALSE )
		{
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}
//------------------------------------------------------------------
/**
 * گް۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   palData			گްڽێ߲̱ڽ
 * @param   heapID			˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//------------------------------------------------------------------
void* ArcUtil_PalDataGet( u32 fileIdx, u32 dataIdx, NNSG2dPaletteData** palData, u32 heapID )
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, FALSE, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedPaletteData( arcData, palData ) == FALSE )
		{
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}
//--------------------------------------------------------------------------------------------
/**
 * ݸް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   compressedFlag	kĂްH
 * @param   cellBank		ݸްڽێ߲̱ڽ
 * @param   heapID			˰ID
 * @param   pSize			ݸ޲Ļނ󂯎ϐ߲ivȂNULLŁj
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
void* ArcUtil_CellBankDataGet(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dCellDataBank** cellBank, u32 heapID )
{
	void* arcData;

	arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedCellBank( arcData, cellBank ) == FALSE )
		{
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}
//--------------------------------------------------------------------------------------------
/**
 * ݸް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   fileIdx			̧ٲޯ
 * @param   arcIndex		ްޯ
 * @param   compressedFlag	kĂްH
 * @param   anmBank			ݸްڽێ߲̱ڽ
 * @param   heapID			˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
void* ArcUtil_AnimBankDataGet(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, NNSG2dAnimBankData** anmBank, u32 heapID)
{
	void* arcData = ArcUtil_Load( fileIdx, dataIdx, compressedFlag, heapID, ALLOC_TOP );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedAnimBank( arcData, anmBank ) == FALSE )
		{
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}











//------------------------------------------------------------------
/**
 * LZkA[JCuĂf[^ǂݏoA𓀂ĕԂ
 *
 * @param   fileIdx		A[JCut@CCfbNX
 * @param   dataIdx		A[JCuf[^CfbNX
 * @param   heapID		ǂݏoE𓀂Ɏgq[vhc
 *
 * @retval  void*		𓀌̃f[^ۑAhX
 */
//------------------------------------------------------------------
void* ArcUtil_UnCompress(u32 fileIdx, u32 dataIdx, u32 heapID)
{
	return ArcUtil_Load(fileIdx, dataIdx, TRUE, heapID, ALLOC_TOP);
}

//------------------------------------------------------------------
/**
 * A[JCuf[^̓ǂݏoimۂj
 *
 * @param   fileIdx			A[JCut@CCfbNX
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   compressedFlag	kĂ邩H
 * @param   heapID			mۂɎgq[vhc
 * @param   allocType		q[v̂ǂ̈ʒu烁mۂ邩
 *
 * @retval  void*			ǂݏö|C^
 */
//------------------------------------------------------------------
void* ArcUtil_Load(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, u32 heapID, ALLOC_TYPE allocType)
{
	void* arcData;

	if( compressedFlag || allocType == ALLOC_BOTTOM )
	{
		arcData = sys_AllocMemoryLo( heapID, ArchiveDataSizeGet(fileIdx, dataIdx) );
	}
	else
	{
		arcData = sys_AllocMemory( heapID, ArchiveDataSizeGet(fileIdx, dataIdx) );
	}

	if( arcData != NULL )
	{
		ArchiveDataLoad(arcData, fileIdx, dataIdx);
		if( compressedFlag )
		{
			void* data;

			if( allocType == ALLOC_TOP )
			{
				data = sys_AllocMemory( heapID, MI_GetUncompressedSize( arcData ) );
			}
			else
			{
				data = sys_AllocMemoryLo( heapID, MI_GetUncompressedSize( arcData ) );
			}

			if( data )
			{
				MI_UncompressLZ8( arcData, data );
				sys_FreeMemoryEz( arcData );
			}
			arcData = data;
		}
	}
	return arcData;
}
//------------------------------------------------------------------
/**
 * A[JCuf[^̓ǂݏoiq[v烁mۂj
 *
 * @param   fileIdx			A[JCut@CCfbNX
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   compressedFlag	kĂ邩H
 * @param   heapID			mۂɎgq[vhc
 * @param   allocType		q[v̂ǂ̈ʒu烁mۂ邩
 * @param   pSize			f[^̃oCgTCYikĂꍇ͓WJj
 *
 * @retval  void*			ǂݏö|C^
 */
//------------------------------------------------------------------
void* ArcUtil_LoadEx(u32 fileIdx, u32 dataIdx, BOOL compressedFlag, u32 heapID, ALLOC_TYPE allocType, u32* pSize)
{
	void* arcData;

	*pSize = ArchiveDataSizeGet(fileIdx, dataIdx);

	if( compressedFlag || allocType == ALLOC_BOTTOM )
	{
		arcData = sys_AllocMemoryLo( heapID, *pSize );
	}
	else
	{
		arcData = sys_AllocMemory( heapID, *pSize );
	}

	if( arcData != NULL )
	{
		ArchiveDataLoad(arcData, fileIdx, dataIdx);
		if( compressedFlag )
		{
			void* data;

			*pSize = MI_GetUncompressedSize( arcData );

			if( allocType == ALLOC_TOP )
			{
				data = sys_AllocMemory( heapID, *pSize );
			}
			else
			{
				data = sys_AllocMemoryLo( heapID, *pSize );
			}

			if( data )
			{
				MI_UncompressLZ8( arcData, data );
				sys_FreeMemoryEz( arcData );
			}
			arcData = data;
		}
	}
	return arcData;
}
