//============================================================================================
/**
 * @file	bmp_menu.c
 * @brief	BMPj[
 * @author	Hiroyuki Nakamura
 * @date	2004.11.10
 *
 *	Ej[XN[ȂBMPLISTgp邱
 *	EcÃj[ɑΉ
 */
//============================================================================================
#define	BMP_MENU_H_GLOBAL

#include "common.h"
#include "system/pm_str.h"
#include "system/fontproc.h"
#include "system/palanm.h"
#include "system/window.h"
#include "system/bmp_cursor.h"
#include "system/snd_tool.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_ev_win.h"

#define	BMP_MENU_H_GLOBAL
#include "system/bmp_menu.h"


//============================================================================================
//	V{`
//============================================================================================
enum {
	MV_UP = 0,
	MV_DOWN,
	MV_LEFT,
	MV_RIGHT
};

struct _BMPMENU_WORK {
	BMPMENU_HEADER	hed;
	BMPCURSOR * cursor;
	u32	cancel;
	u8	index;
	u8	cur_pos;
	u8	len;
	u8	px;
	u8	py;
	u8	sx;
	u8	sy;

	u8	mode;		// 擾[h
};



//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BmpMenuWinWriteMain(
				GF_BGL_INI * ini, u8 frm, u8 px, u8 py, u8 sx, u8 sy, u8 pal, u16 cgx );
static void BmpTalkWinWriteMain(
				GF_BGL_INI * ini, u8 frm, u8 px, u8 py, u8 sx, u8 sy, u8 pal, u16 cgx );
static void BmpMenuCursorMove( BMPMENU_WORK * mw, u8 mv, u16 se );
static u8 BmpMenuCursorMoveCheck( BMPMENU_WORK * mw, u8 mv );
static u8 BmpMenuStrLen( BMPMENU_WORK * buf );
static void BmpMenuStrPut( BMPMENU_WORK * mw );
static void BmpMenuCursorPut( BMPMENU_WORK * mw );
static void CursorWritePosGet( BMPMENU_WORK * mw, u8 * x, u8 * y, u8 pos );

//============================================================================================
//	O[oϐ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BMPj[o^iXN[]Ȃj
 *
 * @param	dat			wb_f[^
 * @param	px			ڕ\XW
 * @param	py			ڕ\YW
 * @param	pos			J[\ʒu
 * @aram	mode		擾[h
 * @param	cancel		LZ{^
 *
 * @return	BMPj[[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 */
//--------------------------------------------------------------------------------------------
BMPMENU_WORK * BmpMenuAdd_NoTrans(
					const BMPMENU_HEADER * dat, u8 px, u8 py, u8 pos, u8 mode, u32 cancel )
{
	BMPMENU_WORK * mw = (BMPMENU_WORK *)sys_AllocMemory( mode, sizeof(BMPMENU_WORK) );

	mw->hed		= *dat;
	mw->cursor  = BMPCURSOR_Create( mode );
	mw->cancel  = cancel;
	mw->cur_pos	= pos;
	mw->len		= BmpMenuStrLen( mw );
	mw->mode    = mode;

	mw->px = px;
	mw->py = py;
	mw->sx = FontHeaderGet( dat->font, FONT_HEADER_SIZE_X )
				+ FontHeaderGet( dat->font, FONT_HEADER_SPACE_X );
	mw->sy = FontHeaderGet( dat->font, FONT_HEADER_SIZE_Y )
				+ FontHeaderGet( dat->font, FONT_HEADER_SPACE_Y );

	BmpMenuStrPut( mw );
	BmpMenuCursorPut( mw );

	return mw;
}

//--------------------------------------------------------------------------------------------
/**
 * BMPj[o^iLZ{^wj
 *
 * @param	dat			wb_f[^
 * @param	px			ڕ\XW
 * @param	py			ڕ\YW
 * @param	pos			J[\ʒu
 * @aram	mode		擾[h
 * @param	cancel		LZ{^
 *
 * @return	BMPj[[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 */
//--------------------------------------------------------------------------------------------
BMPMENU_WORK * BmpMenuAddEx(
					const BMPMENU_HEADER * dat, u8 px, u8 py, u8 pos, u8 mode, u32 cancel )
{
	BMPMENU_WORK * mw = BmpMenuAdd_NoTrans( dat, px, py, pos, mode, cancel );

	GF_BGL_BmpWinOn( mw->hed.win );

	return mw;
}

//--------------------------------------------------------------------------------------------
/**
 * BMPj[o^iȈՔŁj
 *
 * @param	dat			wb_f[^
 * @param	pos			J[\ʒu
 * @aram	mode		擾[h
 *
 * @return	BMPj[[N
 *
 * @li	BMPXg[Nsys_AllocMemoryŊm
 * @li	B{^LZ
 */
//--------------------------------------------------------------------------------------------
BMPMENU_WORK * BmpMenuAdd( const BMPMENU_HEADER * dat, u8 pos, u8 mode )
{
	return BmpMenuAddEx(
				dat, FontHeaderGet( dat->font, FONT_HEADER_SIZE_X ), 0,
				pos, mode, PAD_BUTTON_CANCEL );
}

//--------------------------------------------------------------------------------------------
/**
 * BMPj[j
 *
 * @param	mw		BMPj[[N
 * @param	backup	J[\ʒuۑꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpMenuExit( BMPMENU_WORK * mw, u8 * backup )
{
	if( backup != NULL ){
		*backup = mw->cur_pos;
	}
	BMPCURSOR_Delete( mw->cursor );
	sys_FreeMemory( mw->mode, mw );
}


//--------------------------------------------------------------------------------------------
/**
 * j[֐
 *
 * @param	mw		BMPj[[N
 *
 * @return	쌋
 */
//--------------------------------------------------------------------------------------------
u32 BmpMenuMain( BMPMENU_WORK * mw )
{
	if( sys.trg & PAD_BUTTON_DECIDE ){
		Snd_SePlay( SE_DECIDE );
		return mw->hed.menu[ mw->cur_pos ].param;
	}
	if( sys.trg & mw->cancel ){
		Snd_SePlay( SE_CANCEL );
		return BMPMENU_CANCEL;
	}
	if( sys.trg & PAD_KEY_UP ){
		BmpMenuCursorMove( mw, MV_UP, SEQ_SE_DP_SELECT );
		return BMPMENU_NULL;
	}
	if( sys.trg & PAD_KEY_DOWN ){
		BmpMenuCursorMove( mw, MV_DOWN, SEQ_SE_DP_SELECT );
		return BMPMENU_NULL;
	}
	if( sys.trg & PAD_KEY_LEFT ){
		BmpMenuCursorMove( mw, MV_LEFT, SEQ_SE_DP_SELECT );
		return BMPMENU_NULL;
	}
	if( sys.trg & PAD_KEY_RIGHT ){
		BmpMenuCursorMove( mw, MV_RIGHT, SEQ_SE_DP_SELECT );
		return BMPMENU_NULL;
	}

	return BMPMENU_NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * j[֐i\L[SEwłj
 *
 * @param	mw		BMPj[[N
 * @param	key_se	\L[SE
 *
 * @return	쌋
 */
//--------------------------------------------------------------------------------------------
u32 BmpMenuMain_SE( BMPMENU_WORK * mw, u16 key_se )
{
	if( sys.trg & PAD_BUTTON_DECIDE ){
		Snd_SePlay( SE_DECIDE );
		return mw->hed.menu[ mw->cur_pos ].param;
	}
	if( sys.trg & mw->cancel ){
		Snd_SePlay( SE_CANCEL );
		return BMPMENU_CANCEL;
	}
	if( sys.trg & PAD_KEY_UP ){
		BmpMenuCursorMove( mw, MV_UP, key_se );
		return BMPMENU_NULL;
	}
	if( sys.trg & PAD_KEY_DOWN ){
		BmpMenuCursorMove( mw, MV_DOWN, key_se );
		return BMPMENU_NULL;
	}
	if( sys.trg & PAD_KEY_LEFT ){
		BmpMenuCursorMove( mw, MV_LEFT, key_se );
		return BMPMENU_NULL;
	}
	if( sys.trg & PAD_KEY_RIGHT ){
		BmpMenuCursorMove( mw, MV_RIGHT, key_se );
		return BMPMENU_NULL;
	}

	return BMPMENU_NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * J[\ʒu擾
 *
 * @param	mw		BMPj[[N
 *
 * @return	J[\ʒu
 */
//--------------------------------------------------------------------------------------------
u8 BmpMenuCursorPosGet( BMPMENU_WORK * mw )
{
	return mw->cur_pos;
}

//--------------------------------------------------------------------------------------------
/**
 * J[\ړ
 *
 * @param	mw		BMPj[[N
 * @param	mv		ړ
 * @param	se		SE
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BmpMenuCursorMove( BMPMENU_WORK * mw, u8 mv, u16 se )
{
	u8	old = mw->cur_pos;

	if( BmpMenuCursorMoveCheck( mw, mv ) == FALSE ){
		return;
	}

	{
		u8	px, py;
		u8	col;
		
		col = FontHeaderGet( mw->hed.font, FONT_HEADER_B_COLOR );
		CursorWritePosGet( mw, &px, &py, old );
		GF_BGL_BmpWinFill( mw->hed.win, col, px, py, 8, mw->sy );
	}
	BmpMenuCursorPut( mw );
	Snd_SePlay( se );
}

//--------------------------------------------------------------------------------------------
/**
 * J[\ړ`FbN
 *
 * @param	mw		BMPj[[N
 * @param	mv		ړ
 *
 * @retval	"TRUE = ړ"
 * @retval	"FALSE = ړĂȂ"
 */
//--------------------------------------------------------------------------------------------
static u8 BmpMenuCursorMoveCheck( BMPMENU_WORK * mw, u8 mv )
{
	if( mv == MV_UP ){
		if( mw->hed.y_max <= 1 ){ return FALSE; }
		if( ( mw->cur_pos % mw->hed.y_max ) == 0 ){
			if( mw->hed.loop_f == 0 ){ return FALSE; }
			mw->cur_pos += ( mw->hed.y_max - 1 );
		}else{
			mw->cur_pos -= 1;
			return TRUE;
		}
	}else if( mv == MV_DOWN ){
		if( mw->hed.y_max <= 1 ){ return FALSE; }
		if( ( mw->cur_pos % mw->hed.y_max ) == ( mw->hed.y_max - 1 ) ){
			if( mw->hed.loop_f == 0 ){ return FALSE; }
			mw->cur_pos -= ( mw->hed.y_max - 1 );
		}else{
			mw->cur_pos += 1;
			return TRUE;
		}
	}else if( mv == MV_LEFT ){
		if( mw->hed.x_max <= 1 ){ return FALSE; }
		if( mw->cur_pos < mw->hed.y_max ){
			if( mw->hed.loop_f == 0 ){ return FALSE; }
			mw->cur_pos += ( mw->hed.y_max * ( mw->hed.x_max - 1 ) );
		}else{
			mw->cur_pos -= mw->hed.y_max;
			return TRUE;
		}
	}else{
		if( mw->hed.x_max <= 1 ){ return FALSE; }
		if( mw->cur_pos >= ( mw->hed.y_max * ( mw->hed.x_max - 1 ) ) ){
			if( mw->hed.loop_f == 0 ){ return FALSE; }
			mw->cur_pos %= mw->hed.y_max;
		}else{
			mw->cur_pos += mw->hed.y_max;
			return TRUE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------------------------------
/**
 * Œڂ̕擾
 *
 * @param	buf		BMPj[[N
 *
 * @return	Œڂ̕
 */
//--------------------------------------------------------------------------------------------
static u8 BmpMenuStrLen( BMPMENU_WORK * buf )
{
	u8	len = 0;
	u8	i, j;


	for( i=0; i<buf->hed.x_max*buf->hed.y_max; i++ ){
		j = FontProc_GetPrintStrWidth( buf->hed.font, buf->hed.menu[i].str, 0 );
		if( len < j ){ len = j; }
	}

/*
	#ifdef PM_DEBUG
	extern BOOL STRBUF_CheckValid(const void*);

	// {͂ȂƂŃRĂł͂܂BROMopً̋}[uB
	extern const STRCODE* STRBUF_GetStringCodePointer( const STRBUF* strbuf );
	#endif

	const u16 * tmp;
	u8	len = 0;
	u8	i, j;

#if 0	// R[h邽߁A{͓WJȂƃ_
	tmp = (u16 *)MS_AllocWorkArea( GF_BGL_BmpWinGrt_Frame( buf->win ), 64 );
	for( i=0; i<buf->hed.x_max*buf->hed.y_max; i++ ){
		PM_strcpy( tmp, buf->hed.menu[i].str );		// vύX
		j = (u8)PM_strlen( tmp );
		if( len < j ){ len = j; }
	}
	MS_FreeWorkArea( GF_BGL_BmpWinGet_Frame( buf->win ), tmp );
#else
	for( i=0; i<buf->hed.x_max*buf->hed.y_max; i++ ){
		if( STRBUF_CheckValid( buf->hed.menu[i].str ) )
		{
			tmp = STRBUF_GetStringCodePointer( buf->hed.menu[i].str );
		}
		else
		{
			tmp = buf->hed.menu[i].str;
		}
		j = (u8)PM_strlen( tmp );
		if( len < j ){ len = j; }
	}
#endif
*/

	return len;
}

//--------------------------------------------------------------------------------------------
/**
 * j[ڕ\
 *
 * @param	mw		BMPj[[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BmpMenuStrPut( BMPMENU_WORK * mw )
{
	#ifdef PM_DEBUG
	extern BOOL STRBUF_CheckValid(const void*);
	#endif

	const void* str;
	u8	px, py, plus;
	u8	i, j;

	GF_BGL_BmpWinDataFill( mw->hed.win, FontHeaderGet( mw->hed.font, FONT_HEADER_B_COLOR ) );

	px = mw->px;
//	plus = px * ( mw->len + 2 );
	plus = mw->len + mw->sx * 2;
	for( i=0; i<mw->hed.x_max; i++ ){
		for( j=0; j<mw->hed.y_max; j++ ){
			str = mw->hed.menu[i*mw->hed.y_max+j].str;
			py  = ( mw->sy + mw->hed.line_spc ) * j + mw->py;

			#ifdef  PM_DEBUG
			if(STRBUF_CheckValid(str)){
				GF_STR_PrintSimple( mw->hed.win, mw->hed.font, str, px, py, MSG_NO_PUT, NULL );
			}else{
				GF_MSG_Print( mw->hed.win, mw->hed.font, str, px, py, MSG_NO_PUT, NULL );
			}
			#else
				GF_STR_PrintSimple( mw->hed.win, mw->hed.font, str, px, py, MSG_NO_PUT, NULL );
			#endif
		}
		px += plus;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * J[\\
 *
 * @param	mw		BMPj[[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BmpMenuCursorPut( BMPMENU_WORK * mw )
{
	u8	px, py;

	if( mw->hed.c_disp_f == 1 ){ return; }

	CursorWritePosGet( mw, &px, &py, mw->cur_pos );
	BMPCURSOR_Print( mw->cursor, mw->hed.win, px, py );
}

//--------------------------------------------------------------------------------------------
/**
 * J[\\ʒu擾
 *
 * @param	buf		BMPj[f[^
 * @param	x		\XW擾ꏊ
 * @param	y		\YW擾ꏊ
 * @param	pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void CursorWritePosGet( BMPMENU_WORK * mw, u8 * x, u8 * y, u8 pos )
{
//	*x = ( pos / mw->hed.y_max ) * ( mw->len + 2 ) * mw->sx;
	*x = ( pos / mw->hed.y_max ) * ( mw->len + mw->sx * 2 );
	*y = ( pos % mw->hed.y_max ) * ( mw->sy + mw->hed.line_spc ) + mw->py;
}


//============================================================================================
//	͂E
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ͂EEBhEZbg
 *
 * @param	ini		BGLf[^
 * @param	data	EBhEf[^
 * @param	cgx		EBhELʒu
 * @param	pal		EBhEpbgԍ
 * @param	heap	q[vID
 *
 * @return	BMPj[[N
 *
 * @li	BMPEBhEBMPj[[NAllocŎ擾Ă
 */
//--------------------------------------------------------------------------------------------
BMPMENU_WORK * BmpYesNoSelectInit(
					GF_BGL_INI * ini, const BMPWIN_DAT * data, u16 cgx, u8 pal, u32 heap )
{
	BMPMENU_HEADER hed;
	MSGDATA_MANAGER * man;
	BMP_MENULIST_DATA * ld;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_ev_win_dat, heap );
	ld  = BMP_MENULIST_Create( 2, heap );
	BMP_MENULIST_AddArchiveString( ld, man, msg_ev_win_046, 0 );
	BMP_MENULIST_AddArchiveString( ld, man, msg_ev_win_047, BMPMENU_CANCEL );
	MSGMAN_Delete( man );

	hed.menu     = ld;
	hed.win      = GF_BGL_BmpWinAllocGet( heap, 1 );
	hed.font     = FONT_SYSTEM;
	hed.x_max    = 1;
	hed.y_max    = 2;
	hed.line_spc = 0;
	hed.c_disp_f = 0;
	hed.line_spc = 0;

	GF_BGL_BmpWinAddEx( ini, hed.win, data );
	BmpMenuWinWrite( hed.win, WINDOW_TRANS_OFF, cgx, pal );
	return BmpMenuAddEx( &hed, 8, 0, 0, heap, PAD_BUTTON_CANCEL );
}


//--------------------------------------------------------------------------------------------
/**
 * ͂EIEBhE̐
 *
 * @param	ini		BGLf[^
 * @param	heap	q[vID
 *
 * @retval	"BMPMENU_NULL	IĂȂ"
 * @retval	"0				͂I"
 * @retval	"BMPMENU_CANCEL	orLZ"
 */
//--------------------------------------------------------------------------------------------
u32 BmpYesNoSelectMain( BMPMENU_WORK * mw, u32 heap )
{
	u32	ret = BmpMenuMain( mw );

	if( ret != BMPMENU_NULL ){
		BmpYesNoWinDel( mw, heap );
	}
	return	ret;
}

//--------------------------------------------------------------------------------------------
/**
 * ͂EEBhE폜
 *
 * @param	ini		BGLf[^
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpYesNoWinDel( BMPMENU_WORK * mw, u32 heap )
{
	BmpMenuWinClear( mw->hed.win, WINDOW_TRANS_ON );
	GF_BGL_BmpWinDel( mw->hed.win );
	sys_FreeMemory( heap, mw->hed.win );
	BMP_MENULIST_Delete( (BMP_MENULIST_DATA *)mw->hed.menu );
	BmpMenuExit( mw, NULL );
}


//------------------------------------------------------------------
/**
 * EBhEɃJ[\摜`
 *
 * @param   win		EBhE
 * @param   x		`wWihbgj
 * @param   y		`xWihbgj
 *
 */
//------------------------------------------------------------------
void BmpWin_DrawCursorImage(GF_BGL_BMPWIN* win, u32 x, u32 y)
{
	static const u8 CursorBitmapImage[] = {
		0xff,0xff,0xff,0x00,
		0xff,0xff,0xff,0x00,
		0x21,0xff,0xff,0x00,
		0x11,0xf2,0xff,0x00,
		0x11,0x21,0xff,0x00,
		0x11,0x11,0xf2,0x00,
		0x11,0x11,0x21,0x00,
		0x11,0x11,0x22,0x00,

		0x11,0x21,0xf2,0x00,
		0x11,0x22,0xff,0x00,
		0x21,0xf2,0xff,0x00,
		0x22,0xff,0xff,0x00,
		0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,
	};

	GF_BGL_BmpWinPrint( win, (void*)CursorBitmapImage, 0, 0, 8, 16, x, y, 8, 16 );

}

