//============================================================================================
/**
 * @file	bmp_menu_list.h
 * @brief	bmp_menu  bmp_list Ŏgp镶w\̂̏
 * @author	taya
 * @date	2005.12.02
 *
 * bmp_menu  bmp_list őS^Epr̍\̂ʌɒ`Ă̂ł܂Ƃ߂ĂB
 *
 */
//============================================================================================

#include "common.h"

#include "system/bmp_menu_list.h"


//==============================================================
// Prototype
//==============================================================
static BMP_MENULIST_DATA*  SeekEmptyListPos( BMP_MENULIST_DATA* list, u32* heapID );


/// Xg̏I[R[h
#define LIST_ENDCODE		((const void*)0xffffffff)

//------------------------------------------------------------------
/**
 * Xgobt@쐬B
 * 쐬ABMP_MENULIST_AddArchiveString  BMP_MENULIST_AddString gĕZbg
 *
 * @param   maxElems		Xgɓo^镶̍ő匏
 * @param   heapID			Xg쐬q[vID
 *
 * @retval  BMP_MENULIST_DATA*		쐬ꂽXgobt@
 */
//------------------------------------------------------------------
BMP_MENULIST_DATA*  BMP_MENULIST_Create( u32 maxElems, u32 heapID )
{
	// w萔P߂ɍĂAŌɏI[R[huĊǗ
	BMP_MENULIST_DATA* list = sys_AllocMemory( heapID, sizeof(BMP_MENULIST_DATA)*(maxElems+1) );
	if( list )
	{
		u32 i;

		for(i=0; i<maxElems; i++)
		{
			list[i].str = NULL;
			list[i].param = 0;
		}

		list[i].str = LIST_ENDCODE;
		list[i].param = heapID;
	}
	return list;
}


//------------------------------------------------------------------
/**
 * Xgobt@j
 * BMP_MENULIST_Createō쐬̈ȊOnĂ̓_B
 *
 * @param   list		Xgobt@
 *
 */
//------------------------------------------------------------------
void BMP_MENULIST_Delete( BMP_MENULIST_DATA* list_top )
{
	BMP_MENULIST_DATA* list = list_top;
	while( list->str != LIST_ENDCODE )
	{
		if( list->str == NULL )
		{
			break;
		}
		STRBUF_Delete((STRBUF*)(list->str));
		list++;
	}
	sys_FreeMemoryEz(list_top);
}

//------------------------------------------------------------------
/**
 * Xgobt@ɕ񁕃p[^Zbgi}l[WăA[JCuf[^ǂݍ݁j
 *
 * @param   list		[in] Xgobt@
 * @param   man			[in] bZ[Wf[^}l[W
 * @param   strID		ID
 * @param   param		p[^
 *
 */
//------------------------------------------------------------------
void BMP_MENULIST_AddArchiveString( BMP_MENULIST_DATA* list, const MSGDATA_MANAGER* man, u32 strID, u32 param )
{
	u32 dmy;

	list = SeekEmptyListPos(list, &dmy);

	if( list )
	{
		list->str = MSGMAN_AllocString( man, strID );
		list->param = param;
	}
}

//------------------------------------------------------------------
/**
 * Xgobt@ɕ񁕃p[^Zbgi𒼐ڎwj
 *
 * @param   list		[in] Xgobt@
 * @param   str			[in] 
 * @param   param		p[^
 *
 */
//------------------------------------------------------------------
void BMP_MENULIST_AddString( BMP_MENULIST_DATA* list, const STRBUF* str, u32 param )
{
	u32 heapID;

	list = SeekEmptyListPos(list, &heapID);

	if( list )
	{
		list->str = STRBUF_CreateBufferCopy( str, heapID );
		list->param = param;
	}
}




//------------------------------------------------------------------
/**
 * Xg̐擪󂫂ʒuV[N
 *
 * @param   list		[in]  󂫈ʒu|C^iNULLj
 * @param   heapID		[out] Xg쐬ɕۑq[vID󂯎
 *
 * @retval  BMP_MENULIST_DATA*		
 */
//------------------------------------------------------------------
static BMP_MENULIST_DATA*  SeekEmptyListPos( BMP_MENULIST_DATA* list, u32* heapID )
{
	BMP_MENULIST_DATA* ret;

	while( list->str != NULL )
	{
		if( list->str == LIST_ENDCODE )
		{
			GF_ASSERT(0);
			return NULL;
		}
		list++;
	}

	ret = list;

	while( list->str != LIST_ENDCODE )
	{
		list++;
	}

	*heapID = list->param;

	return ret;
}
