//=========================================================================
/*
 *	bmp_tool.c
 *
 */
//=========================================================================
#include "common.h"
#include "system/pm_str.h"
#include "system/bmp_menu.h"
#include "system/pmfprint.h"
#include "system/fontproc.h"

#define __BMP_TOOL_H_GLOBAL__
#include "system/bmp_tool.h"



//--------------------------------------------------------------------------------------------
/**
 * J[w胁bZ[W\
 *
 * @param	bmpwin		BGLf[^
 * @param	fnt_idx		tHgCfbNX
 * @param	px			\XW
 * @param	py			\YW
 * @param	col			\J[
 * @param	wait		EFCg
 * @param	msg			bZ[Wf[^
 *
 * @return	bZ[WCfbNX
 *
 * @li	col[3] = { wipal, pal, epal }
 */
//--------------------------------------------------------------------------------------------
u8 BmpMsgPrintColor(
		GF_BGL_BMPWIN * bmpwin, u8 fnt_idx,
		u8 px, u8 py, const u8 * col, s8 wait, const u16 * msg )
{
	BmpMsgPrintColorEx(
		bmpwin, fnt_idx, px, py,
		FontHeaderGet( fnt_idx, FONT_HEADER_SPACE_X ),
		FontHeaderGet( fnt_idx, FONT_HEADER_SPACE_Y ), col, wait, msg );
}

//--------------------------------------------------------------------------------------------
/**
 * J[w胁bZ[W\EX(ԃXy[Xwł)
 *
 * @param	bmpwin		BGLf[^
 * @param	fnt_idx		tHgCfbNX
 * @param	px			\XW
 * @param	py			\YW
 * @param	sx			ԃXy[XX
 * @param	sy			ԃXy[XY
 * @param	col			\J[
 * @param	wait		EFCg
 * @param	msg			bZ[Wf[^
 *
 * @return	bZ[WCfbNX
 *
 * @li	col[3] = { wipal, pal, epal }
 */
//--------------------------------------------------------------------------------------------
u8 BmpMsgPrintColorEx(
		GF_BGL_BMPWIN * bmpwin, u8 fnt_idx,
		u8 px, u8 py, u8 sx, u8 sy, const u8 * col, s8 wait, const u16 * msg )
{
	MSG_PRINT_HEADER	mph;

	mph.msg       = msg;
	mph.bmpwin    = bmpwin;
	mph.fnt_index = fnt_idx;
	mph.start_x   = px;
	mph.start_y   = py;
	mph.write_x   = px;
	mph.write_y   = py;
	mph.space_x   = sx;
	mph.space_y   = sy;
	mph.style     = 0;
	mph.f_col     = col[1];
	mph.b_col     = col[0];
	mph.s_col     = col[2];
	mph.dot_tbl   = 0;
	mph.dot_wy    = 0;

	return GF_MSG_PrintExpand( &mph, wait, NULL );
}








//--------------------------------------------------------------------------
/**
 * MSG_PrintXy[XΉ
 *
 * @param	ini				BGLf[^
 * @param   win_index		EBhECfbNX
 * @param   fnt_index		tHgCfbNX
 * @param   msg				
 * @param   x				`Jnw
 * @param   y				`Jnx
 * @param   wait			P`悲Ƃ̃EFCg
 * @param   call_back		P`悲Ƃ̃R[obN
 * @param   space_x			Ԋuw
 * @param   space_y			Ԋux
 *
 * @retval  none		
 */
//--------------------------------------------------------------------------
/*
void MSG_PrintSpace(
		GF_BGL_INI * ini, u8 win_index, u8 fnt_index,
		const void * msg, u8 x, u8 y, u8 wait, void * call_back, u16 space_x, u16 space_y)
{
	MSG_PRINT_HEADER mph;

	mph.msg = msg;
	mph.win_index = win_index;
	mph.fnt_index = fnt_index;
	mph.start_x = x;
	mph.start_y = y;
	mph.write_x = x;
	mph.write_y = y;
	mph.space_x = space_x;
	mph.space_y = space_y;
	mph.style = 0;
	mph.f_col = FontHeaderGet(fnt_index, FONT_HEADER_F_COLOR);
	mph.b_col = FontHeaderGet(fnt_index, FONT_HEADER_B_COLOR);
	mph.s_col = FontHeaderGet(fnt_index, FONT_HEADER_S_COLOR);
	mph.dot_tbl   = 0;
	mph.dot_wy    = 0;

	MSG_PrintExpand( ini, &mph, wait, call_back);
}
*/

//--------------------------------------------------------------------------------------------
/**
 * O\
 *
 * @param	u8* name
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
/*
void BmpHeroNamePut(u8 index,u8* name,u16 x,u16 y)
{
	int i;

	i = 0;
	while(myd->my_name[i] != EOM_){
		i++;
	}
	PM_MsgExpand( MsgExpandBuffer, name );
#if 0
	if(i != 5){	
		// bZ[Wzu(ʏ)
		MSG_Print(index,POKE_SYSTEM,MsgExpandBuffer,x,y,MSG_NO_PUT,NULL);
	}else{
		// bZ[Wzu(l)
		MSG_PrintSpace(index,POKE_SYSTEM,MsgExpandBuffer,x,y,MSG_NO_PUT,NULL,0,0);	
	}
#endif	//<<20030903 del
	//Gh̓tHgȂ̂ŁAȂ
	MSG_Print(index,POKE_8x16,MsgExpandBuffer,x,y,MSG_NO_PUT,NULL);
}
*/

//---------------------------------------------------------------------------------------------
/**
 *  CuBMPPRT_BmpPrintƓ̏QoCg݂ōsB
 *	iݐAhXA`wTCYQoCgPʂł邱ƁIj
 *
 * @param	src			ǂݍ݌Lf[^wb_[\̃|C^
 * @param	dest		ݐLf[^wb_[\̃|C^
 * @param	pos_sx		ǂݍ݌ǂݍ݊JnXW
 * @param	pos_sy		ǂݍ݌ǂݍ݊JnYW
 * @param	pos_dx		ݐ揑݊JnXW
 * @param	pos_dy		ݐ揑݊JnYW
 * @param	size_x		`͈XTCY
 * @param	size_y		`͈YTCY
 *
 * @retval	Ȃ
 *
 */
//---------------------------------------------------------------------------------------------
/*
void	BmpPrint2byte(const BMPPRT_HEADER *src,const BMPPRT_HEADER *dest,
								 u16 pos_sx,u16 pos_sy,
								 u16 pos_dx,u16 pos_dy,
								 u16 size_x,u16 size_y
							)
{
#define DPPCALC(adrs, pos_x, pos_y, size_x)		\
	(u8*)((adrs) +								\
	(((pos_x)>>1) & 3) +						\
	(((pos_x)>>3) << 5) +						\
	((((pos_y)>>3) * (size_x)) << 5) +			\
	((u32)((pos_y)<<29)>>27)					\
	)


	int	sx, dx, x_max, sy, dy, y_max;
	int sx_arg, dx_arg;
	u8	*srcadrs, *destadrs;
	u16	dst_dat;

//	STORE();

	if((dest->size_x - pos_dx) < size_x){
		x_max = dest->size_x - pos_dx + pos_sx;
	}else{
		x_max = size_x + pos_sx;
	}

	if((dest->size_y - pos_dy) < size_y){
		y_max = pos_sy + dest->size_y - pos_dy;
	}else{
		y_max = pos_sy + size_y;
	}

//	ASSERT(pos_dx & 1);
//	ASSERT((x_max-pos_sx) & 1);

	sx_arg = (((src->size_x) + (src->size_x&7))>>3);
	dx_arg = (((dest->size_x) + (dest->size_x&7))>>3);

	for(sy=pos_sy, dy=pos_dy; sy < y_max; sy++, dy++){
		for(sx=pos_sx, dx=pos_dx; sx < x_max; sx++, dx++){

			srcadrs=DPPCALC(src->adrs, sx, sy, sx_arg);
			destadrs=DPPCALC(dest->adrs, dx, dy, dx_arg);

			if((u32)destadrs & 1){	//uq`l݊̏ꍇ
				destadrs--;
				if(dx & 1){	//hbg̏ꍇ()
					dst_dat = *(vu16*)(destadrs);
					dst_dat &= 0x0fff;
					if(sx & 1){	//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0xf0) << 8;
					}else{		//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0x0f) << 12;
					}
				}else{		//hbg̏ꍇ()
					dst_dat = *(vu16*)(destadrs);
					dst_dat &= 0xf0ff;
					if(sx & 1){	//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0xf0) << 4;
					}else{		//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0x0f) << 8;
					}
				}
			}else{					//uq`l݋̏ꍇ
				if(dx & 1){	//hbg̏ꍇ
					dst_dat = *(vu16*)(destadrs);
					dst_dat &= 0xff0f;
					if(sx & 1){	//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0xf0) << 0;
					}else{		//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0x0f) << 4;
					}
				}else{		//hbg̏ꍇ
					dst_dat = *(vu16*)(destadrs);
					dst_dat &= 0xfff0;
					if(sx & 1){	//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0xf0) >> 4;
					}else{		//hbg̏ꍇ(ǂݍ)
						dst_dat |= ((*srcadrs) & 0x0f) << 0;
					}
				}
			}
			*(vu16*)destadrs = dst_dat;
		}
	}

#undef DPPCALC

}
*/
