//PxύX
#include "common.h"
#include "system/brightness.h"

enum{
	BRIGHT_CHG_NO = 0,
	BRIGHT_CHG_YES
};

typedef struct BRIGHTNESS_CHG_tag{
	BRIGHT_PARAM BrightParam;
	s8	Dir;

	s16 Dif;
	s16 dps;
	u16 d_rest;
	u16	rest;
	
	s16 Now;

	BOOL Request;

//BRIGHT_PLANEMASK PlaneMask;
//BRIGHT_DISPMASK DisplayMask;	
//u16 Sync;
//s16 Dst;
//s16 Src;
}BRIGHTNESS_CHG;


static BRIGHTNESS_CHG MainBrightCont;
static BRIGHTNESS_CHG SubBrightCont;

static void SetUpBrightness(BRIGHTNESS_CHG	*bright_data,
							const u8 inSync,
							const s16 inDstBright,
							const s16 inSrcBright,
							const BRIGHT_PLANEMASK inPlaneMask,
							const BRIGHT_DISPMASK inDisplayMask);

//==============================================================================
/**
 * PxύX
 *
 * @param	bright_data	PxύX\̂ւ̃|C^
 *
 * @retval  Ȃ
 */
//==============================================================================
static void ChangeBrightness(BRIGHTNESS_CHG *bright_data)
{
	BRIGHT_PARAM *param;
	BOOL finished;
	
	finished = BRIGHT_CHG_NO;
	param = &bright_data->BrightParam;
	
	if ((bright_data->Now + bright_data->Dir*bright_data->dps != param->Dst) &&
			(bright_data->Now != param->Dst)){
		bright_data->Now += bright_data->Dir*bright_data->dps;
		bright_data->rest += bright_data->d_rest;
		if (bright_data->rest>=param->Sync){
			bright_data->Now += bright_data->Dir;

			if (bright_data->Now != param->Dst){
				bright_data->rest -= param->Sync;
			}else{
				finished = BRIGHT_CHG_YES;
			}
		}
	}else{
		bright_data->Now = param->Dst;
		finished = BRIGHT_CHG_YES;
	}

	if (param->DisplayMask & MASK_MAIN_DISPLAY){
		G2_SetBlendBrightness(param->PlaneMask,bright_data->Now);
	}
	else if (param->DisplayMask & MASK_SUB_DISPLAY){
		G2S_SetBlendBrightness(param->PlaneMask,bright_data->Now);
	}

	if (finished == BRIGHT_CHG_YES){
		bright_data->Request = FALSE;
	}

}

//==============================================================================
/**
 * PxZbgAbv
 *
 * @param	*bright_data	PxύX\̂ւ̃|C^
 * @param   inSync			tF[ĥɂSync
 * @param   inDstBright		tF[hI̋Pxidefine)	  I
 * @param   inSrcBright		tF[hJn̋Pxidefine)
 * @param   inPlaneMask		tF[hfBGʁienum)
 * @param   inDisplayMask	tF[hfLCDienum)
 *
 * @retval  Ȃ
 */
//==============================================================================
static void SetUpBrightness(BRIGHTNESS_CHG	*bright_data,
							const u8 inSync,
							const s16 inDstBright,
							const s16 inSrcBright,
							const BRIGHT_PLANEMASK inPlaneMask,
							const BRIGHT_DISPMASK inDisplayMask)
{
	BRIGHT_PARAM *param;
	GF_ASSERT((bright_data->Request == FALSE)&&"PxύXNGXgĂ܂");
	bright_data->Request = TRUE;
	
	param = &bright_data->BrightParam;

	//PxύXʃ}XN
	param->PlaneMask = (u8)inPlaneMask;
	//Pxf\ʃ}XN
	param->DisplayMask = (u8)inDisplayMask;
	//SyncVNŐFς邩
	param->Sync = inSync;
	//ړIPx
	param->Dst = inDstBright;
	//݋Px
	bright_data->Now = inSrcBright;
	//݋PxƎwPx̍Ƃ
	bright_data->Dif = inSrcBright - inDstBright;
	//ƂVNŊ
	//PVN̕ωʁi]͕ۑđ݁A(wVN)𒴂ωʂɒǉj
	
	if (bright_data->Dif>0){
		bright_data->Dir = -1;
	}else{
		bright_data->Dir = 1;
		bright_data->Dif *= (-1);
	}
	bright_data->dps = bright_data->Dif/inSync;
	bright_data->d_rest = bright_data->Dif%inSync;
	bright_data->rest = 0;
}

//==============================================================================
/**
 * PxύXtF[hNGXg
 *
 * @param   inSync			tF[ĥɂSync
 * @param   inDstBright		tF[hI̋Pxidefine)	  I
 * @param   inSrcBright		tF[hJn̋Pxidefine)
 * @param   inPlaneMask		tF[hfBGʁienum)
 * @param   inDisplayMask	tF[hfLCDienum)
 *
 * @retval  Ȃ
 */
//==============================================================================
void ChangeBrightnessRequest(const u8 inSync, const s16 inDstBright, const s16 inSrcBright,
		const BRIGHT_PLANEMASK inPlaneMask, const BRIGHT_DISPMASK inDisplayMask)
{
	BRIGHTNESS_CHG	*bright_data;
	
	//0VNł̋PxύX͕s\Ȃ̂ŁANGXg
	if (inSync == 0){
		return;
	}

	//PxZbg
	if (inDisplayMask & MASK_MAIN_DISPLAY){
		G2_SetBlendBrightness(inPlaneMask,inSrcBright);
		bright_data = &MainBrightCont;
		SetUpBrightness(bright_data,inSync,inDstBright,inSrcBright,
				inPlaneMask, MASK_MAIN_DISPLAY);
	}
	if (inDisplayMask & MASK_SUB_DISPLAY){
		G2S_SetBlendBrightness(inPlaneMask,inSrcBright);
		bright_data = &SubBrightCont;
		SetUpBrightness(bright_data,inSync,inDstBright,inSrcBright,
				inPlaneMask, MASK_SUB_DISPLAY);
	}
	
}

//==============================================================================
/**
 * PxύX
 *
 * @param   inDstBright		Pxidefine)
 * @param   inPlaneMask		tF[hfBGʁienum)
 * @param   inDisplayMask	tF[hfLCDienum)
 *
 * @retval  Ȃ
 */
//==============================================================================
void SetBrightness(	const s16 inDstBright,
					const BRIGHT_PLANEMASK inPlaneMask,
					const BRIGHT_DISPMASK inDisplayMask)
{
	if (inDisplayMask & MASK_MAIN_DISPLAY){
		G2_SetBlendBrightness(inPlaneMask,inDstBright);
	}
	if (inDisplayMask & MASK_SUB_DISPLAY){
		G2S_SetBlendBrightness(inPlaneMask,inDstBright);
	}
}

//==============================================================================
/**
 * PxύX\̏
 *
 * @param	Ȃ
 *
 * @retval  Ȃ
 */
//==============================================================================
void BrightnessChgInit(void)
{
	MainBrightCont.Request = FALSE;
	SubBrightCont.Request = FALSE;
}

//==============================================================================
/**
 * PxύXC
 *
 * @param	Ȃ
 *
 * @retval  Ȃ
 */
//==============================================================================
void BrightnessChgMain(void)
{
	//NGXg`FbN
	if (MainBrightCont.Request){
		ChangeBrightness(&MainBrightCont);
	}
	if (SubBrightCont.Request){
		ChangeBrightness(&SubBrightCont);
	}
}

//==============================================================================
/**
 * I`FbN
 *
 * @param	flg ׂkbcb
 *
 * @retval  IL
 */
//==============================================================================
BOOL IsFinishedBrightnessChg(BRIGHT_DISPMASK flg)
{
	if (flg == MASK_DOUBLE_DISPLAY){
		if (MainBrightCont.Request == FALSE && SubBrightCont.Request == FALSE){
			return TRUE;
		}
	}else if(flg == MASK_MAIN_DISPLAY){
		if (MainBrightCont.Request == FALSE){
			return TRUE;
		}
	}else if (flg == MASK_SUB_DISPLAY){
		if (SubBrightCont.Request == FALSE){
			return TRUE;
		}
	}

	return FALSE;
}

