//==============================================================================
/**
 * @file	clact_tool.h
 * @brief	clactʊ֐S
 * @author	goto
 * @date	2005.09.12()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#ifndef	_CLACT_TOOL_H_
#define _CLACT_TOOL_H_

#include "gflib/clact.h"

#include "system/clact_util.h"
#include "system/render_oam.h"
#include "system/palanm.h"


// -----------------------------------------------------------------------------
//
//
//	LEtOn`
//
//
// -----------------------------------------------------------------------------
// -----------------------------------------
//
//	ψ\[X[h𗘗p
//
//		L = p
//
// -----------------------------------------
#define CATS_CBP_RES_LOAD


// -----------------------------------------
//
//	RENDER 𗘗p
//
//		L = p
//
// -----------------------------------------
#define CATS_RENDER_USE


// -----------------------------------------------------------------------------
//
//
//	
//
//
// -----------------------------------------------------------------------------
// -----------------------------------------
//
//	VXeǗ\
//
//		eAvłPpӂ
//		clact_toolł[ csp ]ŕ\Ă
//
// -----------------------------------------
typedef struct _TCATS_SYSTEM   * CATS_SYS_PTR;


// -----------------------------------------
//
//	\[XǗ\
//
//		PʂƂɗpӂ(GtFNgPȂ)
//		clact_toolł[ crp ]ŕ\Ă
//
// -----------------------------------------
typedef struct _TCATS_RESOURCE * CATS_RES_PTR;


// -----------------------------------------
//
//	CATS g̐pAN^[\
//
// -----------------------------------------
typedef struct _TCATS_ACT {
	
	CLACT_WORK_PTR			act;		///< AN^[̃|C^
	CLACT_HEADER_PTR		act_hd;		///< AN^[wb_[̃|C^
	CLACT_HEADER_TBL_PTR	act_htp;	///< AN^[wb_[e[ũ|C^
	
} TCATS_ACT;

typedef struct _TCATS_ACT * CATS_ACT_PTR;


// -----------------------------------------
//
//	OAMp\
//
// -----------------------------------------
typedef struct {
	
	int mos;		///< C	OAMǗ̈EJn
	int moe;		///< C	OAMǗ̈EI
	int mas;		///< C	AtBǗ̈EJn
	int mae;		///< C	AtBǗ̈EI
	int sos;		///< Tu	OAMǗ̈EJn
	int soe;		///< Tu	OAMǗ̈EJn
	int sas;		///< Tu	AtBǗ̈EJn
	int sae;		///< Tu	AtBǗ̈EI
	
} TCATS_OAM_INIT;


// -----------------------------------------
//
//	L}l[Wp\
//
// -----------------------------------------
typedef struct {
	
	int num;						///< LN^IDǗ
	int m_size;						///< CʃTCY(byteP)
	int s_size;						///< TuʃTCY(byteP)

	GXOBJVRamModeChar	main_mode;	///< LN^}bsO[h C
	GXOBJVRamModeChar	sub_mode;	///< LN^}bsO[h Tu
	
} TCATS_CHAR_MANAGER_MAKE;


// -----------------------------------------
//
//	\[Xƃwb_[܂Ƃ߂p
//
// -----------------------------------------
typedef union {

	const char* res_file[ CLACT_U_RES_MAX + 1];	///< \[Xz + wb_[
	
	struct {
	
		const char* char_path;					///< L
		const char* pltt_path;					///< pbg
		const char* cell_path;					///< Z
		const char* cell_anm_path;				///< ZAj
		const char* mcell_path;					///< }`Z
		const char* mcell_anm_path;				///< }`ZAj
		
		const char* clact_header_path;			///< ZAN^[wb_[

	} resource;
	
} TCATS_RESOURCE_FILE_LIST;

// -----------------------------------------
//
//	\[X݂̂܂Ƃ߂
//
// -----------------------------------------
typedef union {
	
	const char* res_file[ CLACT_U_RES_MAX ];
	
	struct {
		
		const char* char_path;					///< L
		const char* pltt_path;					///< pbg
		const char* cell_path;					///< Z
		const char* cell_anm_path;				///< ZAj
		const char* mcell_path;					///< }`Z
		const char* mcell_anm_path;				///< }`ZAj
		
	} resource;
	
} TCATS_ADD_FILE_LIST;


// -----------------------------------------
//
//	OBJo^p\
//
// -----------------------------------------
typedef struct {
	
	int no;				///< \[Xf[^̓o^ԍ
	
	s16 x;				///< [ X ] W
	s16 y;				///< [ Y ] W
	s16 z;				///< [ Z ] W
	
	u16	anm;			///< Ajԍ
	int pri;			///< D揇
	int	pal;			///< pbgԍ
	int d_area;			///< `GA
	
	int param1;			///< \
	int param2;
	int param3;
	int param4;
	
} TCATS_OBJECT_ADD_PARAM;

// -----------------------------------------
//
//	\[Xo^ő吔`\
//
// -----------------------------------------
typedef union {
	
	int res_num[ CLACT_U_RES_MAX ];
	
	struct {
		
		int char_num;				///< L̐
		int pltt_num;				///< pbg̐
		int cell_num;				///< Z̐
		int cell_anm_num;			///< ZAj̐
		int mcell_num;				///< }`Z̐
		int mcell_anm_num;			///< }`ZAj̐
		
	} resource_num;	
	
} TCATS_RESOURCE_NUM_LIST;

// -----------------------------------------
//
//	o^p\ P̓o^p
//
// -----------------------------------------
typedef struct {
	
	s16 x;							///< [ X ] W
	s16 y;							///< [ Y ] W
	s16 z;							///< [ Z ] W
	
	u16	anm;						///< Ajԍ
	int pri;						///< D揇
	int	pal;						///< pbgԍ
	int d_area;						///< `GA
	
	int id[ CLACT_U_RES_MAX ];		///< gp\[XIDe[u
		
	int bg_pri;						///< BGʂւ̗Dx
	int vram_trans;					///< Vram]tO
	
} TCATS_OBJECT_ADD_PARAM_S;


// -----------------------------------------
//
//	CATS p̒`Q
//
// -----------------------------------------
enum ECATS {
	
	CATS_ENABLE_TRUE	= 1,
	CATS_ENABLE_FALSE	= 0,
	
	CATS_D_AREA_MAIN	= NNS_G2D_VRAM_TYPE_2DMAIN,
	CATS_D_AREA_SUB		= NNS_G2D_VRAM_TYPE_2DSUB,
	
	CATS_ANM_AUTO_ON	= 1,
	CATS_ANM_AUTO_OFF	= 0,
	
	CATS_RENDER_USE_ON	= 1,
	CATS_RENDER_USE_OFF = 0,
		
};


// =============================================================================
//
//
//	ʑ֐ | P̓o^Awb_[o^p
//
//
// =============================================================================
// -----------------------------------------
//
//	CATS_SYSTEM ̃m
//
// -----------------------------------------
extern CATS_SYS_PTR CATS_AllocMemory(int heap_area);


// -----------------------------------------
//
//	CATS_RESOURCE ̃m
//
// -----------------------------------------
extern CATS_RES_PTR CATS_ResourceCreate(CATS_SYS_PTR csp);


// -----------------------------------------
//
//	CATS \[X̐擾
//
// -----------------------------------------
extern int CATS_ResourceNumGet(CATS_SYS_PTR csp);


// -----------------------------------------
//
//	CATS VXȅ
//
// -----------------------------------------
extern BOOL CATS_SystemInit(CATS_SYS_PTR csp, const TCATS_OAM_INIT* coi, const TCATS_CHAR_MANAGER_MAKE* ccmm, int pal_num);


// -----------------------------------------
//
//	CATS RENDER̗ptOݒ
//
// -----------------------------------------
extern void CATS_RenderUseSet(CATS_SYS_PTR csp, int flag);

// -----------------------------------------
//
//	CATS ZAN^[Zbg̍쐬
//
// -----------------------------------------
extern BOOL CATS_ClactSetInit(CATS_SYS_PTR csp, CATS_RES_PTR crp, int num);


// -----------------------------------------
//
//	CATS OBJj
//
// -----------------------------------------
extern void CATS_ObjectDel(CLACT_WORK_PTR act);


// -----------------------------------------
//
//	CATS `
//
// -----------------------------------------
extern void CATS_Draw(CATS_RES_PTR crp);


// -----------------------------------------
//
//	CATS Vram]ݒ
//
// -----------------------------------------
extern void CATS_UpdateTransfer(void);


// -----------------------------------------
//
//	CATS OAM]
//
// -----------------------------------------
extern void CATS_RenderOamTrans(void);
extern void CATS_RenderOamTransEx(CATS_SYS_PTR csp);


// -----------------------------------------
//
//	CATS ZAN^[Zbgj	
//
// -----------------------------------------
extern void CATS_ClactSetDelete(CATS_RES_PTR crp);


// -----------------------------------------
//
//	CATS wb_[e[uj		
//
// -----------------------------------------
extern void CATS_HeaderTblDelete(CATS_RES_PTR crp);


// -----------------------------------------
//
//	CATS \[Xf[^j		
//
// -----------------------------------------
extern void CATS_ResourceDelete(CATS_RES_PTR crp);


// -----------------------------------------
//
//	CATS }l[W[j			
//
// -----------------------------------------
extern void CATS_ManagerDelete(CATS_SYS_PTR csp);


// -----------------------------------------
//
//	CATS \[Xp̃j	
//
// -----------------------------------------
extern void CATS_ResourceFree(CATS_SYS_PTR csp, CATS_RES_PTR crp);


// -----------------------------------------
//
//	CATS \[X֘A̔j [  ]
//
//	 ̕tĂ铮ׂčsȂ̂Ő
//
// -----------------------------------------
extern void CATS_ResourceDestructor(CATS_SYS_PTR csp, CATS_RES_PTR crp);


// -----------------------------------------
//
//	CATS System{̂̃j
//
// -----------------------------------------
extern void CATS_FreeMemory(CATS_SYS_PTR csp);


// =============================================================================
//
//
//	wb_[ǂݍ݊֐
//
//
// =============================================================================
// -----------------------------------------
//
//	CATS \[X[h
//
// -----------------------------------------
extern BOOL CATS_ResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, const TCATS_RESOURCE_FILE_LIST* res_list);
extern BOOL CATS_ResourceLoadBinary(
			CATS_SYS_PTR csp, CATS_RES_PTR crp, const TCATS_RESOURCE_FILE_LIST* res_list );

#ifdef CATS_CBP_RES_LOAD	///< ψ

extern BOOL CATS_ResourceLoad_FileName(CATS_SYS_PTR csp, CATS_RES_PTR crp, ...);

#endif


// -----------------------------------------
//
//	CATS OBJo^
//
// -----------------------------------------
extern CLACT_WORK_PTR CATS_ObjectAdd(CATS_SYS_PTR csp, CATS_RES_PTR crp, const TCATS_OBJECT_ADD_PARAM* coap);
extern CLACT_WORK_PTR CATS_ObjectAdd_EX(CATS_SYS_PTR csp, CATS_RES_PTR crp, int no,
							 				s16 x, s16 y, s16 z, u16 anm, int pri, int pal, int d_area,
							 				int param1, int param2, int param3, int param4); 




// =============================================================================
//
//
//	P̓o^p
//
//
// =============================================================================
// -----------------------------------------
//
//	CATS \[XǗ̐ݒ
//
// -----------------------------------------
extern BOOL CATS_ResourceManagerInit(CATS_SYS_PTR csp, CATS_RES_PTR crp, const TCATS_RESOURCE_NUM_LIST* crnl);


// -----------------------------------------
//
//	CATS \[Xo^
//
// -----------------------------------------
extern BOOL CATS_LoadResourceChar(CATS_SYS_PTR csp, CATS_RES_PTR crp, const char* path, int trans_mode, int id);
extern BOOL CATS_LoadResourceCharArc(CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, int comp, int trans_mode, int id);
extern u8 CATS_LoadResourcePltt(CATS_SYS_PTR csp, CATS_RES_PTR crp, const char* path, 
	int num, int trans_mode, int id);
extern s8 CATS_LoadResourcePlttArc(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	int arc_id, int data_id, int comp, int num, int trans_mode, int id);
extern BOOL CATS_LoadResourceCell(CATS_SYS_PTR csp, CATS_RES_PTR crp, const char* path, int id);
extern BOOL CATS_LoadResourceCellArc(CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, int comp, int id);
extern BOOL CATS_LoadResourceCellAnm(CATS_SYS_PTR csp, CATS_RES_PTR crp, const char* path, int id);
extern BOOL CATS_LoadResourceCellAnmArc(CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, int comp, int id);
extern BOOL CATS_LoadResourceMCell(CATS_SYS_PTR csp, CATS_RES_PTR crp, const char* path, int id);
extern BOOL CATS_LoadResourceMCellArc(CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, int comp, int id);
extern BOOL CATS_LoadResourceMCellAnm(CATS_SYS_PTR csp, CATS_RES_PTR crp, const char* path, int id);
extern BOOL CATS_LoadResourceMCellAnmArc(CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, int comp, int id);
extern u8 CATS_LoadResourcePlttWork(PALETTE_FADE_PTR pfd, FADEREQ req, CATS_SYS_PTR csp, 
	CATS_RES_PTR crp, const char* path, int num, int trans_mode, int id);
extern u8 CATS_LoadResourcePlttWorkArc(PALETTE_FADE_PTR pfd, FADEREQ req, CATS_SYS_PTR csp, 
	CATS_RES_PTR crp, int arc_id, int data_id, int comp, int num, int trans_mode, int id);


// -----------------------------------------
//
//	CATS \[X폜
//
// -----------------------------------------
extern BOOL CATS_FreeResourceChar(CATS_RES_PTR crp, int id);
extern BOOL CATS_FreeResourcePltt(CATS_RES_PTR crp, int id);
extern BOOL CATS_FreeResourceCell(CATS_RES_PTR crp, int id);
extern BOOL CATS_FreeResourceCellAnm(CATS_RES_PTR crp, int id);
extern BOOL CATS_FreeResourceMCell(CATS_RES_PTR crp, int id);
extern BOOL CATS_FreeResourceMCellAnm(CATS_RES_PTR crp, int id);


// -----------------------------------------
//
//	CATS OBJo^
//
// -----------------------------------------
extern CATS_ACT_PTR CATS_ObjectAdd_S(CATS_SYS_PTR csp, CATS_RES_PTR crp, const TCATS_OBJECT_ADD_PARAM_S* coap_s);


// -----------------------------------------
//
//	CATS \[X֘A̔j
//
// -----------------------------------------
extern void CATS_ResourceDestructor_S(CATS_SYS_PTR csp, CATS_RES_PTR crp);
extern void CATS_ActorPointerDelete_S(CATS_ACT_PTR cap);








// =============================================================================
//
//
//	OBJ֘A܂Ƃ
//
//
// =============================================================================
// =============================================================================
//
//	\
//
// =============================================================================
// -----------------------------------------
//
//	CATS OBJ̃AjXV
//
// -----------------------------------------
extern void CATS_ObjectUpdate(CLACT_WORK_PTR act);
extern void CATS_ObjectUpdateCap(CATS_ACT_PTR cap);
extern void CATS_ObjectUpdateNumCap(CATS_ACT_PTR cap, fx32 frame);


// -----------------------------------------
//
//	CATS OBJ̃AjV[PXݒ聕擾
//
// -----------------------------------------
extern void CATS_ObjectAnimeSeqSetCap( CATS_ACT_PTR cap, u32 seq );
extern u32 CATS_ObjectAnimeSeqGetCap( CATS_ACT_PTR cap );


// -----------------------------------------
//
//	CATS OBJ̃I[gAjݒ
//
// -----------------------------------------
extern void CATS_ObjectAutoAnimeSet(CLACT_WORK_PTR act, int flag);
extern void CATS_ObjectAutoAnimeSetCap(CATS_ACT_PTR cap, int flag);


// -----------------------------------------
//
//	CATS OBJ̃I[gAj擾
//
// -----------------------------------------
extern int CATS_ObjectAutoAnimeGet(CLACT_WORK_PTR act);
extern int CATS_ObjectAutoAnimeGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS OBJ̃I[gAjXs[hݒ聕擾
//
// -----------------------------------------
extern void CATS_ObjectAutoAnimeSpeedSet(CLACT_WORK_PTR act, fx32 frame);
extern void CATS_ObjectAutoAnimeSpeedSetCap(CATS_ACT_PTR cap, fx32 frame);
extern fx32 CATS_ObjectAutoAnimeSpeedGet(CLACT_WORK_PTR act);
extern fx32 CATS_ObjectAutoAnimeSpeedGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS OBJ̃Ajt[ݒ聕擾
//
// -----------------------------------------
extern void CATS_ObjectAnimeFrameSet(CLACT_WORK_PTR act, u16 frame);
extern void CATS_ObjectAnimeFrameSetCap(CATS_ACT_PTR cap, u16 frame);
extern u16 CATS_ObjectAnimeFrameGet(CLACT_WORK_PTR act);
extern u16 CATS_ObjectAnimeFrameGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS OBJ̃Aj`FbN
//
// -----------------------------------------
extern BOOL CATS_ObjectAnimeActiveCheck(CLACT_WORK_PTR act);
extern BOOL CATS_ObjectAnimeActiveCheckCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS OBJ̕\\
//
// -----------------------------------------
extern void CATS_ObjectEnable(CLACT_WORK_PTR act, int enable);
extern void CATS_ObjectEnableCap(CATS_ACT_PTR cap, int enable);
extern int	CATS_ObjectEnableGet(CLACT_WORK_PTR act);
extern int	CATS_ObjectEnableGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS pbgύX
//
// -----------------------------------------
extern void CATS_ObjectPaletteSet(CLACT_WORK_PTR act, int pal);
extern void CATS_ObjectPaletteSetCap(CATS_ACT_PTR cap, int pal);
extern void CATS_ObjectPaletteOffsetSet(CLACT_WORK_PTR act, int pal_ofs);
extern void CATS_ObjectPaletteOffsetSetCap(CATS_ACT_PTR cap, int pal_ofs);
extern int CATS_ObjectPaletteOffsetGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS BGƂ̗DxύX
//
// -----------------------------------------
extern void CATS_ObjectBGPriSet(CLACT_WORK_PTR act, int pri);
extern void CATS_ObjectBGPriSetCap(CATS_ACT_PTR cap, int pri);


// -----------------------------------------
//
//	CATS OBJƂ̗DxύX
//
// -----------------------------------------
extern void CATS_ObjectPriSet(CLACT_WORK_PTR act, int pri);
extern void CATS_ObjectPriSetCap(CATS_ACT_PTR cap, int pri);



// =============================================================================
//
//	W
//
// =============================================================================
// -----------------------------------------
//
//	CATS OBJ̍WύX
//
// -----------------------------------------
extern void CATS_ObjectPosSet(CLACT_WORK_PTR act, s16 x, s16 y);
extern void CATS_ObjectPosSetCap(CATS_ACT_PTR cap, s16 x, s16 y);


// -----------------------------------------
//
//	CATS OBJ̍W擾
//
// -----------------------------------------
extern void CATS_ObjectPosGet(CLACT_WORK_PTR act, s16 *x, s16 *y);
extern void CATS_ObjectPosGetCap(CATS_ACT_PTR cap, s16 *x, s16 *y);


// -----------------------------------------
//
//	CATS OBJ̈ړ
//
// -----------------------------------------
extern void CATS_ObjectPosMove(CLACT_WORK_PTR act, s16 x, s16 y);
extern void CATS_ObjectPosMoveCap(CATS_ACT_PTR cap, s16 x, s16 y);



// =============================================================================
//
//	AtB tbv
//
// =============================================================================
// -----------------------------------------
//
//	CATS OBJ̃AtBp[^Zbg
//
// -----------------------------------------
extern void CATS_ObjectAffineSet(CLACT_WORK_PTR act, int affine);
extern void CATS_ObjectAffineSetCap(CATS_ACT_PTR cap, int affine);


// -----------------------------------------
//
//	CATS OBJ̃AtBp[^擾
//
// -----------------------------------------
extern int CATS_ObjectAffineGet(CLACT_WORK_PTR act);
extern int CATS_ObjectAffineGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	CATS OBJ̊gk̕ύX
//
// -----------------------------------------
extern void CATS_ObjectScaleSet(CLACT_WORK_PTR act, f32 sx, f32 sy);
extern void CATS_ObjectScaleSetCap(CATS_ACT_PTR cap, f32 sx, f32 sy);


// -----------------------------------------
//
//	CATS OBJ̊gk̉Z
//
// -----------------------------------------
extern void CATS_ObjectScaleAdd(CLACT_WORK_PTR act, f32 sx, f32 sy);
extern void CATS_ObjectScaleAddCap(CATS_ACT_PTR cap, f32 sx, f32 sy);


// -----------------------------------------
//
//	CATS OBJ̊gk̎擾
//
// -----------------------------------------
extern void CATS_ObjectScaleGet(CLACT_WORK_PTR act, f32* sx, f32* sy);
extern void CATS_ObjectScaleGetCap(CATS_ACT_PTR cap, f32* sx, f32* sy);


// -----------------------------------------
//
//	CATS OBJ̉]̕ύX
//
// -----------------------------------------
extern void CATS_ObjectRotationSet(CLACT_WORK_PTR act, u16 rot);
extern void CATS_ObjectRotationSetCap(CATS_ACT_PTR cap, u16 rot);


// -----------------------------------------
//
//	CATS OBJ̉]̉Z
//
// -----------------------------------------
extern void CATS_ObjectRotationAdd(CLACT_WORK_PTR act, s32 rot);
extern void CATS_ObjectRotationAddCap(CATS_ACT_PTR cap, s32 rot);


// -----------------------------------------
//
//	CATS OBJ̉]擾
//
// -----------------------------------------
extern u16	CATS_ObjectRotationGet(CLACT_WORK_PTR act);
extern u16	CATS_ObjectRotationGetCap(CATS_ACT_PTR cap);


// -----------------------------------------
//
//	tbv
//
// -----------------------------------------
extern void CATS_ObjectFlipSet(CLACT_WORK_PTR act, int flip);
extern void CATS_ObjectFlipSetCap(CATS_ACT_PTR cap, int flip);


// -----------------------------------------
//
//	tbv擾
//
// -----------------------------------------
extern int CATS_ObjectFlipGet(CLACT_WORK_PTR act);
extern int CATS_ObjectFlipGetCap(CATS_ACT_PTR cap);

// -----------------------------------------
//
//	CATS AtBϊW̐ݒ
//		capW + AtBW@ʒuŉ]g傳܂
//
// -----------------------------------------
extern void CATS_ObjectAffinePosSetCap(CATS_ACT_PTR cap, s16 x, s16 y);


// -----------------------------------------
//
//	CATS AtBϊW̎擾
//		capW + AtBW@ʒuŉ]g傳܂
//
// -----------------------------------------
extern void CATS_ObjectAffinePosGetCap(CATS_ACT_PTR cap, s16 *x, s16 *y);


// -----------------------------------------
//
//	CATS AtBϊẄړ
//		capW + AtBW@ʒuŉ]g傳܂
//
// -----------------------------------------
extern void CATS_ObjectAffinePosMoveCap(CATS_ACT_PTR cap, s16 x, s16 y);



// =============================================================================
//
//	OBJ[h
//
// =============================================================================
// -----------------------------------------
//
//	OBJ[h
//
// -----------------------------------------
extern void CATS_ObjectObjModeSet(CLACT_WORK_PTR act, GXOamMode objmode);
extern void CATS_ObjectObjModeSetCap(CATS_ACT_PTR cap, GXOamMode objmode);


// -----------------------------------------
//
//	OBJ[h擾
//
// -----------------------------------------
extern GXOamMode CATS_ObjectObjModeGet(CLACT_WORK_PTR act);
extern GXOamMode CATS_ObjectObjModeGetCap(CATS_ACT_PTR cap);





// =============================================================================
//
//	̑̃c[n
//
// =============================================================================
extern BOOL CATS_LoadResourceCharArcModeAdjust(
				CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, BOOL comp, int trans_mode, int id );
extern void CATS_ChangeResourceCharArc(
				CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, BOOL comp, int id );
extern void CATS_ChangeResourcePlttArc(
				CATS_SYS_PTR csp, CATS_RES_PTR crp, int arc_id, int data_id, BOOL comp, int id );
extern CLACT_SET_PTR CATS_GetClactSetPtr(CATS_RES_PTR crp);
extern const NNSG2dImagePaletteProxy* CATS_PlttProxy( CATS_RES_PTR crp, int pltt_id );

#if 0
typedef struct {
	
	int x;
	int y;
	int w;
	int h;
	
} CHANGES_INTO_DATA_RECT;

#define CHAR_DOT_X		(8/2)						///< 1L̃oCgTCY
#define CHAR_DOT_Y		(8)							///< 1L̃oCgTCY
#define CHAR_BYTE		(CHAR_DOT_X * CHAR_DOT_Y)	///< 1LoCg
#define POKE_TEX_SX		(0)							///< |PϊpeNX`؂ʒu
#define POKE_TEX_SY		(0)
#define POKE_TEX_EX		(10)
#define POKE_TEX_EY		(10)
#define POKE_TEX_SIZE	((POKE_TEX_EX - POKE_TEX_SX) *  (POKE_TEX_EY - POKE_TEX_SY) * CHAR_BYTE)

extern void	 ChangesInto_1D_from_2D(int arc_id, int index_no, int heap_id, int x, int y, int w, int h, void* buff);
extern void	 ChangesInto_1D_from_2D_RC(int arc_id, int index_no, int heap_id, CHANGES_INTO_DATA_RECT* rc, void* buff);

extern void* ChangesInto_1D_from_2D_Alloc(int arc_id, int index_no, int heap_id, int x, int y, int w, int h);
extern void* ChangesInto_1D_from_2D_Alloc_RC(int arc_id, int index_no, int heap_id, CHANGES_INTO_DATA_RECT* rc);

extern void  ChangesInto_OAM_from_1D(int sx, int sy, int x, int y, int w, int h, int* bofs, const void* src, void* dst);
extern void  ChangesInto_OAM_from_1D_RC(int sx, int sy, CHANGES_INTO_DATA_RECT* rc, int* bofs, const void* src, void* dst);

extern void  ChangesInto_OAM_from_PokeTex(int arc_id, int index_no, int heap_id, int x, int y, int w, int h, void* buff);
extern void  ChangesInto_OAM_from_PokeTex_RC(int arc_id, int index_no, int heap_id, CHANGES_INTO_DATA_RECT* rc, void* buff);

extern void* ChangesInto_OAM_from_PokeTex_Alloc(int arc_id, int index_no, int heap_id, int x, int y, int w, int h);
extern void* ChangesInto_OAM_from_PokeTex_Alloc_RC(int arc_id, int index_no, int heap_id, CHANGES_INTO_DATA_RECT* rc);

extern void  ChangesInto_BattlePokeData(int arc_id, int index_no, int heap_id, void* buff);
extern void* ChangesInto_BattlePokeData_Alloc(int arc_id, int index_no, int heap_id);
#endif

#endif
