//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		clact_util.c
 *@brief	ZAN^[̓o^ȒPɍsVXe
 *@author	tomoya takahashi
 *@data		2005.09.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"


#include "include/system/render_oam.h"

#define __CLACT_UTIL_H_GLOBAL
#include "include/system/clact_util.h"


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define	CLACT_U_HEADER_DATA_NONE	(0xffffffff)	// Ƀ}`Z̗Lɂ悤

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	f[^ꎞǂݍݗpe[u
//	
//=====================================
typedef struct {
	int char_id;		// LN^ID
	int pltt_id;		// pbgID
	int cell_id;		// ZID
	int cellanm_id;		// ZAjID
	int multicell_id;	// }`ZID
	int multicellanm_id;// }`ZAjID
	int vram_trans;		// Vram]tO
	int	priority;		// BGD揇
} CLACT_HEADER_DATA_TMP;



//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static int getHeaderTblNum(char* buff);
static void loadHeaderTbl(char* buff, CLACT_HEADER_DATA_TMP* tbl, int num);
static void loadHeaderOne(char* buff, char** char_id, char** pltt_id, char** cell_id, char** cellanm_id, char** multicell_id, char** multicellanm_id, char** vram_trans, char** priority);
static void setHeaderOne(CLACT_HEADER_DATA_TMP* tbl, char* char_id, char* pltt_id, char* cell_id, char* cellanm_id, char* multicell_id, char* multicellanm_id, char* vram_trans, char* priority);

static char* makeStrCopy(const char* tmp, int heap);
static void	delStrCopy(char* data);


//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_[쐬	iṔj
 *
 *@param	tbl					wb_[f[^i[
 *@param	charID				LN^f[^ID
 *@param	plttID				pbgf[^ID
 *@param	cellID				Zf[^ID
 *@param	cellAnmID			ZAj[VID"ƂCLACT_U_HEADER_DATA_NONE"
 *@param	MultiID				}`ZID		"ƂCLACT_U_HEADER_DATA_NONE"
 *@param	MultiAnmID			}`ZAjID	"ƂCLACT_U_HEADER_DATA_NONE"
 *@param	vram_trans			Vram]tO
 *@param	priority			BGƂ̗D揇
 *@param	charResMan			LN^f[^i[Ă郊\[X}l[W
 *@param	plttResMan			pbgf[^i[Ă郊\[X}l[W
 *@param	cellResMan			Zf[^i[Ă郊\[X}l[W
 *@param	cellAnmResMan		ZAjf[^i[Ă郊\[X}l[W
 *@param	multiCellResMan		}`Zf[^i[Ă郊\[X}l[W
 *@param	multiCellAnmResMan	}`ZAjf[^i[Ă郊\[X}l[W
 *
 *@return	none
 *
 *
	 */
//-----------------------------------------------------------------------------
void CLACT_U_MakeHeader(CLACT_HEADER_PTR tbl, int charID, int plttID, int cellID,
		int cellAnmID, int MultiID, int MultiAnmID, int vram_trans, int priority,
		CLACT_U_RES_MANAGER_PTR charResMan,
		CLACT_U_RES_MANAGER_PTR plttResMan,
		CLACT_U_RES_MANAGER_PTR cellResMan,
		CLACT_U_RES_MANAGER_PTR cellAnmResMan,
		CLACT_U_RES_MANAGER_PTR multiCellResMan,
		CLACT_U_RES_MANAGER_PTR multiCellAnmResMan)
{
	CLACT_U_RES_OBJ_PTR char_o;
	CLACT_U_RES_OBJ_PTR pltt_o;
	CLACT_U_RES_OBJ_PTR cell_o;
	CLACT_U_RES_OBJ_PTR cellanm_o = NULL;
	CLACT_U_RES_OBJ_PTR multi_o = NULL;
	CLACT_U_RES_OBJ_PTR multianm_o = NULL;
	NNSG2dImageProxy*	img_prox;

	GF_ASSERT(charResMan);		// K{\[X}l[W[
	GF_ASSERT(plttResMan);
	GF_ASSERT(cellAnmResMan);
	GF_ASSERT(cellResMan);
	GF_ASSERT(tbl);				// e[uIuWF͊mۍς݂
	
	// ef[^ANZXpIuWFNg쐬
	char_o = CLACT_U_ResManagerGetIDResObjPtr( charResMan, charID );
	GF_ASSERT(char_o);
	pltt_o = CLACT_U_ResManagerGetIDResObjPtr( plttResMan, plttID );
	GF_ASSERT(pltt_o);
	cell_o = CLACT_U_ResManagerGetIDResObjPtr( cellResMan, cellID );
	GF_ASSERT(cell_o);
	
	// Ajf[^͂Ƃ̂
	if( cellAnmResMan ){
		if( cellAnmID != CLACT_U_HEADER_DATA_NONE ){
			cellanm_o = CLACT_U_ResManagerGetIDResObjPtr( cellAnmResMan, cellAnmID );
			GF_ASSERT(cellanm_o);
		}
	}

	// }`Z̓\[X}l[W[Ƃ̂ݐݒ
	if(multiCellResMan != NULL){
		if(MultiID != CLACT_U_HEADER_DATA_NONE){
			multi_o = CLACT_U_ResManagerGetIDResObjPtr( multiCellResMan, MultiID );
		}
		if(MultiAnmID != CLACT_U_HEADER_DATA_NONE){
			multianm_o = CLACT_U_ResManagerGetIDResObjPtr( multiCellAnmResMan, MultiAnmID );
		}
	}
	
	// LN^}l[W[vNV擾
	// Vram]`FbN
	if(vram_trans){
		img_prox = CLACT_U_CharManagerGetVramTransferProxy(char_o, cell_o);
		GF_ASSERT(img_prox);
		
		// LN^f[^擾
		tbl->pCharData = CLACT_U_ResManagerGetResObjResChar(char_o);
	}else{
		img_prox = CLACT_U_CharManagerGetProxy(char_o);
		GF_ASSERT(img_prox);

		tbl->pCharData = NULL;	// Vram]ȊOł͂Ȃ
	}
	// pbgvNV擾
	tbl->pPaletteProxy = CLACT_U_PlttManagerGetProxy(pltt_o,img_prox);
	tbl->pImageProxy = img_prox;

	// Zf[^oN
	tbl->pCellBank = CLACT_U_ResManagerGetResObjResCell(cell_o);

	// ZAjf[^oN
	if(cellanm_o){
		tbl->pAnimBank = CLACT_U_ResManagerGetResObjResCellAnm(cellanm_o);	
	}else{
		tbl->pAnimBank = NULL;
	}

	// }`Zf[^擾Kv邩`FbN
	if(multi_o){
		// }`Zf[^oN
		tbl->pMCBank = CLACT_U_ResManagerGetResObjResMultiCell(multi_o);
		// }`ZAjf[^oN
		tbl->pMCABank = CLACT_U_ResManagerGetResObjResMultiCellAnim(multianm_o);
	}else{
		// }`Zf[^oN
		tbl->pMCBank = NULL;
		// }`ZAjf[^oN
		tbl->pMCABank = NULL;
	}

	// ]tO
	tbl->flag = vram_trans;

	// BG\D揇
	tbl->priority = priority;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[̃OɁAwb_[̃f[^Ŋmۂj
 *
 *@param	tbl		g̃f[^jwb_[
 *
 *@return	none
 *
 * Vram]pɊmۂVram̈j
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_DeleteInHeaderVramTransferArea(CLACT_HEADER_PTR tbl)
{
	// Vram][h̎Vram̈J
	CLACT_U_CharManagerDeleteVramTransferProxy(tbl->pImageProxy);

	// e[uclean
	memset(tbl, 0, sizeof(CLACT_HEADER));
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_[e[uǂݍ	ij
 *
 *@param	path				pX
 *@param	heap				q[v
 *@param	charResMan			LN^f[^i[Ă郊\[X}l[W
 *@param	plttResMan			pbgf[^i[Ă郊\[X}l[W
 *@param	cellResMan			Zf[^i[Ă郊\[X}l[W
 *@param	cellAnmResMan		ZAjf[^i[Ă郊\[X}l[W
 *@param	multiCellResMan		}`Zf[^i[Ă郊\[X}l[W
 *@param	multiCellAnmResMan	}`ZAjf[^i[Ă郊\[X}l[W
 *
 *@return	CLACT_HEADER_TBL_PTR	wb_[̃e[ui[\̂̃|C^
 *									ANZX֐ŌX̃wb_[擾邱Ƃo܂B
 *
 *
 */
//-----------------------------------------------------------------------------
CLACT_HEADER_TBL_PTR CLACT_U_LoadHeaderTbl(
		const char* path, int heap,
		CLACT_U_RES_MANAGER_PTR charResMan,
		CLACT_U_RES_MANAGER_PTR plttResMan,
		CLACT_U_RES_MANAGER_PTR cellResMan,
		CLACT_U_RES_MANAGER_PTR cellAnmResMan,
		CLACT_U_RES_MANAGER_PTR multiCellResMan,
		CLACT_U_RES_MANAGER_PTR multiCellAnmResMan)
{
	int i;					// [vp
	char* buff;				// Ɨpobt@
	char* tmp;				// ǂݍݍς݃t@C	
	int tbl_num;			// e[u
	CLACT_HEADER_TBL_PTR	ret_tbl;	// ZAN^[wb_[e[u
	CLACT_HEADER_DATA_TMP*	data_tmp;	// f[^ꎞۑ̈

	// t@Cǂݍ
	tmp = sys_LoadFile(heap, path);
	GF_ASSERT(tmp);

	// e[u擾
	buff = makeStrCopy(tmp, heap);
	tbl_num = getHeaderTblNum(buff);
	delStrCopy(buff);

	// ZAN^[wb_[e[u쐬
	ret_tbl = sys_AllocMemory(heap, sizeof(CLACT_HEADER_TBL));
	GF_ASSERT(ret_tbl);
	
	if(tbl_num > 0){
		ret_tbl->tbl = sys_AllocMemory(heap, sizeof(CLACT_HEADER)*tbl_num);
		GF_ASSERT(ret_tbl->tbl);
	}else{
		ret_tbl->tbl = NULL;
	}
	
	ret_tbl->tbl_num = tbl_num;	// e[u

	// ꎞf[^ǂݍ݂悤e[u쐬
	if(tbl_num > 0){
		data_tmp = sys_AllocMemoryLo(heap, sizeof(CLACT_HEADER_DATA_TMP)* tbl_num);
		GF_ASSERT(data_tmp);
	}else{
		data_tmp = NULL;
	}
	
	// ROMwb_[f[^ǂݍ
	if(data_tmp != NULL){
		buff = makeStrCopy(tmp, heap);
		loadHeaderTbl(buff, data_tmp, tbl_num);
		delStrCopy(buff);
	}

	// ꎞf[^ۑ̈ɓǂ݂񂾃f[^ŃZAN^[wb_[쐬
	for(i=0;i<ret_tbl->tbl_num;i++){
		CLACT_U_MakeHeader(ret_tbl->tbl + i, 
				data_tmp[i].char_id, data_tmp[i].pltt_id,
				data_tmp[i].cell_id, data_tmp[i].cellanm_id,
				data_tmp[i].multicell_id, data_tmp[i].multicellanm_id,
				data_tmp[i].vram_trans, data_tmp[i].priority,
				charResMan, plttResMan, cellResMan, cellAnmResMan, 
				multiCellResMan, multiCellAnmResMan);
	}

	// 	ꎞt@Cj
	if(data_tmp){
		sys_FreeMemoryEz(data_tmp);
	}

	// ǂݍ݃t@Cj
	sys_FreeMemoryEz(tmp);

	return ret_tbl;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_[e[uoCif[^쐬	ij
 *
 *@param	bindata				oCif[^
 *@param	p_header_tbl		wb_[e[u
 *@param	heap				q[v
 *@param	charResMan			LN^f[^i[Ă郊\[X}l[W
 *@param	plttResMan			pbgf[^i[Ă郊\[X}l[W
 *@param	cellResMan			Zf[^i[Ă郊\[X}l[W
 *@param	cellAnmResMan		ZAjf[^i[Ă郊\[X}l[W
 *@param	multiCellResMan		}`Zf[^i[Ă郊\[X}l[W
 *@param	multiCellAnmResMan	}`ZAjf[^i[Ă郊\[X}l[W
 *
 *@return	CLACT_HEADER_TBL_PTR	wb_[̃e[ui[\̂̃|C^
 *									ANZX֐ŌX̃wb_[擾邱Ƃo܂B
 *
 * oCif[^		ef[^2byte̔zuƂȂĂ܂B
 *	LN^ID,		i\[X}l[W[Ɗ֘AtꂽIDj
 *	pbgID,
 *	ZID,
 *	ZAjID,
 *	}`ZID,		i}`ZA}`ZAjƂ'CLACT_U_HEADER_MAKE_NONE_CODE'j
 *	}`ZAjID,
 *	Vram]AjmFtO,
 *	BGʂƂ̗Dx
 *	̃e[u
 *	0x0000,0x0001,0x0000,0x0002,CLACT_U_HEADER_MAKE_NONE_CODE, CLACT_U_HEADER_MAKE_NONE_CODE, 0,0			<-P̃f[^
 *	0x0001,0x0002,0x0003,0x0002,0x0000,0x0000,0x0001,0x0002
 *	IR[h
 *	CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE, CLACT_U_HEADER_MAKE_END_CODE			̃f[^oĂI	
 *
 */
//-----------------------------------------------------------------------------
CLACT_HEADER_TBL_PTR CLACT_U_MakeHeaderBinary(const CLACT_U_HEADER_MAKE_BINDATA* bindata,
		int heap,
		CLACT_U_RES_MANAGER_PTR charResMan,
		CLACT_U_RES_MANAGER_PTR plttResMan,
		CLACT_U_RES_MANAGER_PTR cellResMan,
		CLACT_U_RES_MANAGER_PTR cellAnmResMan,
		CLACT_U_RES_MANAGER_PTR multiCellResMan,
		CLACT_U_RES_MANAGER_PTR multiCellAnmResMan)
{
	int i;					// [vp
	int tbl_num;			// e[u
	CLACT_HEADER_TBL_PTR p_header_tbl;	// wb_[e[u
	int multicell, multicell_anm;

	// oCif[^̃e[u߂
	tbl_num = 0;
	while( bindata[ tbl_num ].char_id != CLACT_U_HEADER_MAKE_END_CODE ){
		tbl_num ++;
	}

	// e[u쐬
	p_header_tbl			= sys_AllocMemory( heap, sizeof(CLACT_HEADER_TBL) );
	p_header_tbl->tbl		= sys_AllocMemory( heap, sizeof(CLACT_HEADER) * tbl_num );
	p_header_tbl->tbl_num	= tbl_num;
	

	for(i=0;i<p_header_tbl->tbl_num;i++){

		CLACT_U_MakeHeader(p_header_tbl->tbl + i, 
				bindata[i].char_id, bindata[i].pltt_id,
				bindata[i].cell_id, bindata[i].cellanime_id,
				bindata[i].multicell_id, bindata[i].multicellanime_id,
				bindata[i].vram_trans, bindata[i].bg_priority,
				charResMan, plttResMan, cellResMan, cellAnmResMan, 
				multiCellResMan, multiCellAnmResMan);
	}

	return p_header_tbl;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[e[uj
 *
 *@param	data	wb_[e[u
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_CLACT_HeaderTblDelete(CLACT_HEADER_TBL_PTR data)
{
	GF_ASSERT(data);
	
	if(data->tbl){
		sys_FreeMemoryEz(data->tbl);
	}
	sys_FreeMemoryEz(data);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[Zbg̊ȒP
 *
 *@param	work_num	ZAN^[ɐݒ肷őAN^[
 *@param	data		ZAN^[ȒPݒɎgp郌_[f[^
 *						(Ԃ̃|C^)
 *@param	heap		mۂɎgpq[v
 *
 *@return	CLACT_SET_PTR	쐬ꂽZAN^[Zbg
 *
 * e
 * _̏AT[tF[X̐ݒȂǂs
 * ZAN^[Zbg쐬
 * ZAN^[Zbgɏ_ݒ
 *
 * j͕ʂ̃ZAN^[̔j֐ővłB
 *
 */
//-----------------------------------------------------------------------------
CLACT_SET_PTR CLACT_U_SetEasyInit( int work_num, CLACT_U_EASYRENDER_DATA* data, int heap )
{
	CLACT_SETDATA	set;
	NNSG2dViewRect rect;
	
	RNDP_InitRenderer(&data->Rend, -FX32_ONE);
	
	// T[tF[Xo^
	// CpT[tF[X
	rect.posTopLeft.x	= MAIN_SURFACE_X;
	rect.posTopLeft.y	= MAIN_SURFACE_Y;
	rect.sizeView.x		= SURFACE_WIDTH;
	rect.sizeView.y		= SURFACE_HEIGHT;
	REND_OAM_SetSurface(&data->surface[0],
			&rect,
			NNS_G2D_SURFACETYPE_MAIN2D,
			&data->Rend);
	
	// TupT[tF[X
	rect.posTopLeft.x	= SUB_SURFACE_X;
	rect.posTopLeft.y	= SUB_SURFACE_Y;
	rect.sizeView.x		= SURFACE_WIDTH;
	rect.sizeView.y		= SURFACE_HEIGHT;
	REND_OAM_SetSurface(&data->surface[1],
			&rect,
			NNS_G2D_SURFACETYPE_SUB2D,
			&data->Rend);
	set.WorkNum = work_num;
	set.pRender	= &data->Rend;
	set.heap	= heap;
	
	return CLACT_InitSet( &set );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_[	Cʂ̃T[tF[Xʒuݒ
 *
 *	@param	data	ȒPZAN^[Zbgp_f[^
 *	@param	x		CʃT[tF[XW
 *	@param	y		CʃT[tF[XW
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_SetMainSurfaceMatrix( CLACT_U_EASYRENDER_DATA* data, fx32 x, fx32 y )
{
	NNSG2dViewRect rect;
	
	rect.posTopLeft.x	= x;
	rect.posTopLeft.y	= y;
	rect.sizeView.x		= SURFACE_WIDTH;
	rect.sizeView.y		= SURFACE_HEIGHT;
	
	RNDP_SetSurfaceRect( &data->surface[ 0 ], &rect );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_[	Tuʂ̃T[tF[Xʒuݒ
 *
 *	@param	data	ȒPZAN^[Zbgp_f[^
 *	@param	x		TuʃT[tF[XW
 *	@param	y		TuʃT[tF[XW
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void CLACT_U_SetSubSurfaceMatrix( CLACT_U_EASYRENDER_DATA* data, fx32 x, fx32 y )
{
	NNSG2dViewRect rect;
	
	rect.posTopLeft.x	= x;
	rect.posTopLeft.y	= y;
	rect.sizeView.x		= SURFACE_WIDTH;
	rect.sizeView.y		= SURFACE_HEIGHT;
	
	RNDP_SetSurfaceRect( &data->surface[ 1 ], &rect );
}




//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[e[u擾
 *
 *@param	buff	obt@
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static int getHeaderTblNum(char* buff)
{
	int count;		// e[uJE^
	char* data[8];
	
	count = 0;
	loadHeaderOne(buff, &data[0], &data[1], &data[2], &data[3], &data[4], &data[5], &data[6], &data[7] );

	// 'e'oĂe[uI
	while(data[0][0] != 'e'){
		count ++;
		loadHeaderOne(NULL, &data[0], &data[1], &data[2], &data[3], &data[4], &data[5], &data[6], &data[7] );
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[e[uǂݍ
 *
 *@param	buff	f[^
 *@param	tbl		i[
 *@param	num		i[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadHeaderTbl(char* buff, CLACT_HEADER_DATA_TMP* tbl, int num)
{
	int	i;			// [vp
	char* data[8];	// i[pf[^
	
	// ǂݍŃe[uɊi[
	loadHeaderOne(buff, &data[0], &data[1], &data[2], &data[3],
			&data[4], &data[5], &data[6], &data[7] );
	
	setHeaderOne(tbl, data[0], data[1], data[2], data[3],
			data[4], data[5], data[6], data[7] );

	for(i=1;i<num;i++){
		loadHeaderOne(NULL, &data[0], &data[1], &data[2], &data[3],
				&data[4], &data[5], &data[6], &data[7] );
		setHeaderOne(tbl + i, data[0], data[1], data[2], data[3],
				data[4], data[5], data[6], data[7] );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[P̃f[^擾
 *
 *@param	buff			obt@
 *@param	char_id			LN^IDi[
 *@param	pltt_id			pbgIDi[
 *@param	cell_id			ZIDi[
 *@param	cellanm_id		ZAjIDi[
 *@param	multicell_id	}`ZIDi[
 *@param	multicellanm_id	}`ZAjIDi[
 *@param	vram_trans		Vram]mFtOi[
 *@param	priority		BGʂƂ̕\D揇ʊi[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadHeaderOne(char* buff, char** char_id, char** pltt_id, char** cell_id, char** cellanm_id, char** multicell_id, char** multicellanm_id, char** vram_trans, char** priority)
{
	*char_id	= strtok(buff, ",");
	*pltt_id	= strtok(NULL, ",");
	*cell_id	= strtok(NULL, ",");
	*cellanm_id	= strtok(NULL, ",");
	*multicell_id	= strtok(NULL, ",");
	*multicellanm_id= strtok(NULL, ",");
	*vram_trans	= strtok(NULL, ",");
	*priority	= strtok(NULL, ",");
	strtok(NULL, "\n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	e[uɃf[^ݒ肷
 *
 *@param	tbl					f[^i[
 *@param	char_id				LN^ID
 *@param	pltt_id				pbgID
 *@param	cell_id				ZID
 *@param	cellanm_id			ZAjID
 *@param	multicell_id		}`ZID
 *@param	multicellanm_id		}`ZAjID
 *@param	vram_trans			Vram]mFtO
 *@param	priority			BGʂƂ̕\D揇
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setHeaderOne(CLACT_HEADER_DATA_TMP* tbl, char* char_id, char* pltt_id, char* cell_id, char* cellanm_id, char* multicell_id, char* multicellanm_id, char* vram_trans, char* priority)
{
	tbl->char_id		= atoi(char_id);
	tbl->pltt_id		= atoi(pltt_id);
	tbl->cell_id		= atoi(cell_id);
	tbl->cellanm_id		= atoi(cellanm_id);
	if(multicell_id[0] != 'n'){
		tbl->multicell_id	= atoi(multicell_id);
		tbl->multicellanm_id = atoi(multicellanm_id);
	}else{
		tbl->multicell_id	 = CLACT_U_HEADER_DATA_NONE; 
		tbl->multicellanm_id = CLACT_U_HEADER_DATA_NONE;
	}
	tbl->vram_trans		= atoi(vram_trans);
	tbl->priority		= atoi(priority);
	
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Rs[쐬
 *
 *@param	tmp		Rs[f[^
 *@param	heap	gpq[v
 *
 *@return	char* 쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static char* makeStrCopy(const char* tmp, int heap)
{
	int len;
	char* copy;
	
	len = strlen(tmp);
	len++;

	copy = sys_AllocMemoryLo(heap, len);
	strcpy(copy, tmp);

	return copy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	makeStrCopyō쐬f[^j
 *
 *@param	data	jf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void	delStrCopy(char* data)
{
	sys_FreeMemoryEz(data);
}

