//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		fontoam.c
 *	@brief		OAMgp`VXe
 *	@author		tomoya takahashi 
 *	@data		2005.10.20
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <string.h>
#include "system.h"
#include "assert.h"
#include "char_manager.h"
#include "system/arc_tool.dat"
#include "system/arc_util.h"
#include "system/fontoam.naix"

#define	__FONTOAM_H_GLOBAL
#include "system/fontoam.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	OAMD揇ʒ萔	
//	
//=====================================
enum{
	FONTOAM_PRI_8x8 = 0,	
	FONTOAM_PRI_8x4,
	FONTOAM_PRI_4x8,
	FONTOAM_PRI_4x4,
	FONTOAM_PRI_4x2,
	FONTOAM_PRI_4x1,
	FONTOAM_PRI_2x4,
	FONTOAM_PRI_2x2,
	FONTOAM_PRI_2x1,
	FONTOAM_PRI_1x4,
	FONTOAM_PRI_1x2,
	FONTOAM_PRI_1x1,
	FONTOAM_PRI_MAX
};
enum{
	FONTOAM_PRI_X = 0,
	FONTOAM_PRI_Y,
	FONTOAM_PRI_XY
};

//-------------------------------------
//	
//	OAMߐsf[^̗L
//	
//=====================================
enum{
	FONTOAM_OAM_AREA_NONE,
	FONTOAM_OAM_AREA_RIGHT,		// EGA
};

#define FONTOAM_CHAR_BYTE	(32)	// 1charTCY
#define FONTOAM_CHAR_SIZE	(8)		// A

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	ZƂ̍Wۑ\
//	
//=====================================
typedef struct _FONTOAM_OBJ_CORE{
	CLACT_WORK_PTR clact;
	int	x;		// hbgP
	int y;		// hbgP
} FONTOAM_OBJ_CORE;

//-------------------------------------
//	
//	1OAMtHgf[^
//	
//=====================================
typedef struct _FONTOAM_OBJ{
	// EBhĚ`킵Ă
	// Z̃f[^
	FONTOAM_OBJ_CORE*	obj_w;
	int obj_num;

	// ZAN^[
	CONST_CLACT_WORK_PTR parent;

	// ̐ݒW
	int x;		// hbgP
	int y;		// hbgP
} FONTOAM_OBJ;

//-------------------------------------
//	
//	VXef[^
//	
//=====================================
typedef struct _FONTOAM_SYSTEM{
	// OAMTCỸZf[^
	void*	pCellBuff[ FONTOAM_PRI_MAX ];
	NNSG2dCellDataBank* pCellBank[ FONTOAM_PRI_MAX ];

	// 1OAMtHgf[^[N
	FONTOAM_OBJ*	fontoam_work;
	int				fontoam_num;		// [N
} FONTOAM_SYSTEM;


//-------------------------------------
//	
//	OAMߐsGA
//	PGAf[^
//	
//=====================================
typedef struct _FONTOAM_OAM_AREA_ONE{
	// SăLN^P
	int top;		// 
	int left;		// 
	int width;		// 
	int height;		// 
} FONTOAM_OAM_AREA_ONE;

//-------------------------------------
//	
//	OAMߐsGA
//
//	܂nowɓĂGAOAM쐬
//	nowSĂOɂȂrightnowɑ
//	now܂SĂOɂȂ܂OAMŖ߂Ă
//	
//=====================================
typedef struct _FONTOAM_OAM_AREA{
	FONTOAM_OAM_AREA_ONE now;
	FONTOAM_OAM_AREA_ONE right;
	u8	tmp_flg;					// l̗L
/*						
	FONTOAM_OAM_AREA_NONE,
	FONTOAM_OAM_AREA_RIGHT,		// EGA
	FONTOAM_OAM_AERA_MAX		// */
} FONTOAM_OAM_AREA;

//-------------------------------------
//	
//	ߐsOAMf[^
//	
//=====================================
typedef struct _FONTOAM_OAM_DATA{
	int x;			// LN^PʍW
	int y;			// LN^PʍW
	int oam_size;	// OAMTCY

	struct _FONTOAM_OAM_DATA* next;
	struct _FONTOAM_OAM_DATA* prev;

} FONTOAM_OAM_DATA;

//-------------------------------------
//	
//	ߐsOAMf[^
//	
//=====================================
typedef struct _FONTOAM_OAM_DATA_SET{
	FONTOAM_OAM_DATA fontoamdata;
	int data_num;
} FONTOAM_OAM_DATA_SET;



//-----------------------------------------------------------------------------
/**
*		O[oϐ
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	OAMD揇ʒ萔	
//	ɑΉLN^PʂOAMTCY
//	
//=====================================
static const u8 FONTOAM_PriTbl[ FONTOAM_PRI_MAX ][ FONTOAM_PRI_XY ] = {
	{8, 8},
	{8, 4},
	{4, 8},
	{4, 4},
	{4, 2},
	{4, 1},
	{2, 4},
	{2, 2},
	{2, 1},
	{1, 4},
	{1, 2},
	{1, 1},
};



//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void cleanFONTOAM_OBJ( FONTOAM_OBJ* fontoam );
static FONTOAM_OBJ* getCleanFONTOAM_OBJ( const FONTOAM_SYSTEM* fontoam_sys );


static int searchOamSize( int x, int y );

static BOOL sumOamArea( FONTOAM_OAM_AREA* oam, FONTOAM_OAM_DATA* list, int heap );
static int getOamData( int x, int y, int heap,  FONTOAM_OAM_DATA* list );

static void charTransOamDataList( const GF_BGL_BMPWIN* bmp, const FONTOAM_OAM_DATA* list, NNSG2dImageProxy* img_proxy, int offs, int draw_area, int heap );
static int charTransOamDataOne( const GF_BGL_BMPWIN* bmp, const FONTOAM_OAM_DATA* oamdata, NNSG2dImageProxy* img_proxy, int char_min_num, int char_mode, int offs, int draw_arae, int heap );

static int charAreaSizeOamDataList( const FONTOAM_OAM_DATA* list, int draw_area );

static void addClActOamDataList( const FONTOAM_INIT* font_init, const FONTOAM_OAM_DATA* list, const NNSG2dImageProxy* img_proxy, FONTOAM_OBJ_PTR font_obj );
static CLACT_WORK_PTR addClActOamDataOne( const FONTOAM_INIT* font_init, const FONTOAM_OAM_DATA* oamdata, const NNSG2dImageProxy* img_proxy );

static void delClActOamDataList( FONTOAM_OBJ_PTR fontoam );

static FONTOAM_OAM_DATA* makeOamList( int heap );
static void destOamList( FONTOAM_OAM_DATA* oamdata );
static void destOamListAll( FONTOAM_OAM_DATA* dummy );
static void setOamList( FONTOAM_OAM_DATA* oamdata, FONTOAM_OAM_DATA* prev );
static void resetOamList( FONTOAM_OAM_DATA* oamdata );


static void charSetOamDataList( const GF_BGL_BMPWIN* bmp, char* pbuff, const FONTOAM_OAM_DATA* list, int draw_area, int heap );
static int charSetOamDataOne( const GF_BGL_BMPWIN* bmp, const FONTOAM_OAM_DATA* oamdata, char* pbuff, int idx, int char_min_num, int char_mode, int heap );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgVXe̍쐬
 *
 *	@param	workNum		Ǘ镶
 *	@param	heap		gpq[v
 *
 *	@return	FONTOAM_SYS_PTR		쐬OAMtHgVXef[^
 *
 *
 */
//-----------------------------------------------------------------------------
FONTOAM_SYS_PTR FONTOAM_SysInit( int workNum, int heap )
{
	FONTOAM_SYS_PTR fntoam_sys;
	int i;			// [vp
	
	fntoam_sys = sys_AllocMemory( heap, sizeof(FONTOAM_SYSTEM) );
	GF_ASSERT( fntoam_sys );
	

	// OAM̃Zf[^ǂݍ
	for( i=0; i<FONTOAM_PRI_MAX; i++ ){
		fntoam_sys->pCellBuff[ i ] = ArcUtil_CellBankDataGet( 
				ARC_FONTOAM,
				i, FALSE,
				&fntoam_sys->pCellBank[ i ],
				heap );

		GF_ASSERT( fntoam_sys->pCellBuff[ i ] );
	}
	
	// workNum1OAMtHgf[^쐬
	fntoam_sys->fontoam_work = sys_AllocMemory( heap, sizeof(FONTOAM_OBJ) * workNum );
	GF_ASSERT( fntoam_sys->fontoam_work );
	fntoam_sys->fontoam_num	= workNum;
	memset( fntoam_sys->fontoam_work, 0, sizeof(FONTOAM_OBJ) * workNum );

	return fntoam_sys;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgVXe̔j
 *
 *	@param	fntoam_sys	OAMtHgVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_SysDelete( FONTOAM_SYS_PTR fntoam_sys )
{
	int i;

	GF_ASSERT( fntoam_sys );
	
	for( i=0; i<FONTOAM_PRI_MAX; i++ ){
		sys_FreeMemoryEz(fntoam_sys->pCellBuff[ i ]);
	}
	sys_FreeMemoryEz( fntoam_sys->fontoam_work );
	sys_FreeMemoryEz( fntoam_sys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHg쐬
 *
 *	@param	fontoam_init	OAMtHg쐬f[^
 *
 *	@return	FONTOAM_OBJ_PTR	OAMtHgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
FONTOAM_OBJ_PTR FONTOAM_Init( const FONTOAM_INIT* fontoam_init )
{
	FONTOAM_OBJ_PTR fontoam;
	FONTOAM_OAM_DATA list_dummy;
	int oam_num;
	NNSG2dImageProxy* img_proxy;

	GF_ASSERT( fontoam_init );

	// ̃e[u擾
	fontoam = getCleanFONTOAM_OBJ( fontoam_init->fontoam_sys );
	GF_ASSERT_MSG( fontoam, "OAMtHge[u܂" );
	fontoam->parent	= fontoam_init->parent;	// ef[^

	fontoam->x	= fontoam_init->x;
	fontoam->y	= fontoam_init->y;

	// OAMf[^쐬
	list_dummy.next = &list_dummy;
	list_dummy.prev = &list_dummy;
	oam_num = getOamData( fontoam_init->bmp->sizx, 
			fontoam_init->bmp->sizy,
			fontoam_init->heap, 
			&list_dummy );

	// oam_num̃C[WvNVƁAZAN^[o^̈쐬
	img_proxy = sys_AllocMemoryLo( fontoam_init->heap,
			sizeof(NNSG2dImageProxy) * oam_num );
	fontoam->obj_w = sys_AllocMemory( fontoam_init->heap,
			sizeof(FONTOAM_OBJ_CORE) * oam_num );
	fontoam->obj_num = oam_num;

	// LN^f[^]
	charTransOamDataList( fontoam_init->bmp, 
			&list_dummy,
			img_proxy,
			fontoam_init->char_ofs,
			fontoam_init->draw_area,
			fontoam_init->heap );

	// ZAN^[o^
	addClActOamDataList( fontoam_init,
			&list_dummy,
			img_proxy,
			fontoam );

	// vNV̔j
	sys_FreeMemoryEz( img_proxy );

	// OAMf[^j
	destOamListAll( &list_dummy );

	return fontoam;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgj
 *
 *	@param	fontoam 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_Delete( FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	GF_ASSERT( fontoam->obj_w );
	
	delClActOamDataList( fontoam );
	
	sys_FreeMemoryEz( fontoam->obj_w );
	cleanFONTOAM_OBJ( fontoam );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	rbg}bvEBhEOAMtHgVXeŕ\邽߂ɕKvȃLN^f[^TCY擾
 *
 *	@param	bmp			rbg}bvf[^
 *	@param	draw_area	`GA
 *	@param	heap		gpq[v
 *
 *	@return	\邽߂ɕKvȃLN^TCY
 *	
 *	char_managergpĂƂ́ÃTCY
 *	Vram̈mۂĂKv邽ߍ쐬
 *
 *
 */
//-----------------------------------------------------------------------------
int FONTOAM_NeedCharSize( const GF_BGL_BMPWIN* bmp, int draw_area,  int heap )
{
	FONTOAM_OAM_DATA list_dummy;
	int offs;

	// OAMf[^쐬
	list_dummy.next = &list_dummy;
	list_dummy.prev = &list_dummy;
	getOamData( bmp->sizx, 
			bmp->sizy,
			heap, 
			&list_dummy );

	offs = charAreaSizeOamDataList( &list_dummy, draw_area );

	// OAMf[^j
	destOamListAll( &list_dummy );

	return offs;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgWݒ
 *
 *	@param	fontoam		OAMtHg
 *	@param	x			W		eAN^[Ƃ̓ItZbgW
 *	@param	y			W		eAN^[Ƃ̓ItZbgW
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_SetMat( FONTOAM_OBJ_PTR fontoam, int x, int y )
{
	int i;		// [vp
	VecFx32	set_mat;	// ݒW
	const VecFx32* parent_mat;

	GF_ASSERT( fontoam );
	
	fontoam->x = x;
	fontoam->y = y;

	x *= FX32_ONE;
	y *= FX32_ONE;

	// eƂ͐ẽItZbgɂȂ
	if( fontoam->parent ){

		parent_mat = CLACT_GetMatrix( fontoam->parent );

		x += parent_mat->x;
		y += parent_mat->y;
	}
	
		
	set_mat.z = 0;
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){
		set_mat.x = x + (fontoam->obj_w[ i ].x << FX32_SHIFT);
		set_mat.y = y + (fontoam->obj_w[ i ].y << FX32_SHIFT);
		CLACT_SetMatrix( fontoam->obj_w[ i ].clact, &set_mat );
	}
}

//----------------------------------------------------------------------------
/**
 * eZAN^[ݒ肵ĂȂꍇ͎gpĂӖ܂B
 *	
 *	@brief	eAN^[̍WʒuɈʒu킹
 *
 *	@param	fontoam 
 *
 *	@return
 *
 * eZAN^[̈ʒuύXƂɌĂłB
 *	@eɍ킹ĕ܂
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_ReflectParentMat( FONTOAM_OBJ_PTR fontoam )
{
	int i;		// [vp
	VecFx32	set_mat;	// ݒW
	const VecFx32* parent_mat;
	fx32 x, y;

	GF_ASSERT( fontoam );

	// eƂ͐ẽItZbgɂȂ
	if( fontoam->parent ){
		
		x = fontoam->x << FX32_SHIFT;
		y = fontoam->y << FX32_SHIFT;

		parent_mat = CLACT_GetMatrix( fontoam->parent );

		x += parent_mat->x;
		y += parent_mat->y;
			
		set_mat.z = 0;
		// SZAN^[ɍWݒ
		for(i=0; i<fontoam->obj_num; i++ ){
			set_mat.x = x + (fontoam->obj_w[ i ].x << FX32_SHIFT);
			set_mat.y = y + (fontoam->obj_w[ i ].y << FX32_SHIFT);
			CLACT_SetMatrix( fontoam->obj_w[ i ].clact, &set_mat );
		}
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMtHgW擾
 *
 *	@param	fontoam		OAMtHg
 *	@param	x			W		eAN^[Ƃ̓ItZbgW
 *	@param	y			W		eAN^[Ƃ̓ItZbgW
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_GetMat( CONST_FONTOAM_OBJ_PTR fontoam, int* x, int* y )
{
	GF_ASSERT( fontoam );
	GF_ASSERT( x );
	GF_ASSERT( y );

	*x = fontoam->x;
	*y = fontoam->y;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\/\ݒ
 *
 *	@param	fontoam		OAMtHgIuWF
 *	@param	flag		\/\tO
 *
 *	@return	none
 *
 * flag
 *	TRUE	\
 *	FALSE	\
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_SetDrawFlag( FONTOAM_OBJ_PTR fontoam, BOOL flag )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_SetDrawFlag( fontoam->obj_w[ i ].clact, flag );
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	\/\擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@retval	TRUE	\
 *	@retval	FALSE	\
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL FONTOAM_GetDrawFlag( CONST_FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	
	return CLACT_GetDrawFlag( fontoam->obj_w[0].clact );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂƂ̗D揇ʂݒ
 *
 *	@param	fontoam	OAMtHgf[^
 *	@param	pri		BGƂ̗D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_SetBGPriority( FONTOAM_OBJ_PTR fontoam, u8 pri )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_BGPriorityChg( fontoam->obj_w[ i ].clact, pri );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂƂ̕`D揇ʂ擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@return	BGʂƂ̗D揇
 *
 *
 */
//-----------------------------------------------------------------------------
int FONTOAM_GetBGPriority( CONST_FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	
	return CLACT_BGPriorityGet( fontoam->obj_w[0].clact );
}

//-----------------------------------------------------------------------------
/**
 *	@brief	`D揇ʂݒ
 *
 *	@param	fontoam		OAMtHgf[^
 *	@param	pri			\D揇
 *				
 * 
 *	@return	none
 */
 //----------------------------------------------------------------------------
void FONTOAM_SetDrawPriority( FONTOAM_OBJ_PTR fontoam, u32 pri )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_DrawPriorityChg( fontoam->obj_w[ i ].clact, pri );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`D揇ʂ擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@return	u32			`D揇
 *
 *
 */
//-----------------------------------------------------------------------------
u32 FONTOAM_GetDrawPriority( CONST_FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	
	return CLACT_DrawPriorityGet( fontoam->obj_w[0].clact );
}

//-----------------------------------------------------------------------------
/**
 * OAM̃pbgio[悤ɂȂ܂B
 *
 *	@brief				pbgio[ύX
 *
 *	@param	fontoam		OAMtHgIuWF
 *	@param	pltt_no		ݒpbgio[
 * 
 *	@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
void FONTOAM_SetPaletteNo( FONTOAM_OBJ_PTR fontoam, u32 pltt_no )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_PaletteNoChg( fontoam->obj_w[ i ].clact, pltt_no );
	}
}
void FONTOAM_SetPaletteNoAddTransPlttNo( FONTOAM_OBJ_PTR fontoam, u32 pltt_no )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_PaletteNoChgAddTransPlttNo( fontoam->obj_w[ i ].clact, pltt_no );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgio[擾
 *
 *	@param	fontoam		OAMtHgIuWF
 *
 *	@return	u32			̃pbgio[
 *
 *
 */
//-----------------------------------------------------------------------------
u32 FONTOAM_GetPaletteNo( CONST_FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	
	return CLACT_PaletteNoGet( fontoam->obj_w[0].clact );
}

//-----------------------------------------------------------------------------
/**
 * OAMAgr[gɐݒ肳Ăpbgio[ɉZ܂B
 *	 AOAMAgr[g̃J[pbgNoQŃItZbgɂQ
 *	 ݒ肷ƁAS̃J[pbgQƂ悤ɂȂ܂
 * 
 *	@brief	pbgItZbgݒ
 *
 *	@param	fontoam		OAMtHgIuWF
 *	@param	pltt_ofs	pbgItZbg
 * 
 *	@return	none
 *
 * pbgio[ݒƃpbgItZbgݒ͓܂B
 *@@pbgio[ݒ肷ƃItZbg̒l͔fȂȂ܂B
 *	@ItZbglݒ肵Ƃ̓pbgio[fȂȂ܂B
 * 
 */
 //----------------------------------------------------------------------------
void FONTOAM_SetPaletteOffset( FONTOAM_OBJ_PTR fontoam, u32 pltt_ofs )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_PaletteOffsetChg( fontoam->obj_w[ i ].clact, pltt_ofs );
	}
}
void FONTOAM_SetPaletteOffsetAddTransPlttNo( FONTOAM_OBJ_PTR fontoam, u32 pltt_ofs )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_PaletteOffsetChgAddTransPlttNo( fontoam->obj_w[ i ].clact, pltt_ofs );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgItZbgl擾
 *
 *	@param	fontoam	OAMtHgIuWF
 *
 *	@return	u32		̃pbgItZbgl
 *
 */
//-----------------------------------------------------------------------------
u32 FONTOAM_GetPaletteOffset( CONST_FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	
	return CLACT_PaletteOffsetGet( fontoam->obj_w[0].clact );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒ
 *
 *	@param	fontoam	OAMtHgIuWF
 *	@param	flag	tO	TRUEUCNON	FALSEUCNOFF
 *
 *	@return	none
 *
 * UCNOFF̎łAjgLN^ŃUCNONɂOAM
 * UCNĕ`悳܂B
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_SetMosaic( FONTOAM_OBJ_PTR fontoam, BOOL flag )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_MosaicSet( fontoam->obj_w[ i ].clact, flag );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	UCNݒԂ擾
 *
 *	@param	fontoam	OAMtHgIuWF
 *
 *	@retval	TRUE	UCNON
 *	@retval	FALSE	UCNOFF	ijgLN^Őݒ肵ĂƂ͔fj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL FONTOAM_GetMosaic( CONST_FONTOAM_OBJ_PTR fontoam )
{
	GF_ASSERT( fontoam );
	
	return CLACT_MosaicGet( fontoam->obj_w[0].clact );
}

//----------------------------------------------------------------------------
/**
 *	@brief	IuWFNg[h̐ݒ
 *
 *	@param	fontoam		tHgOAM
 *	@param	objmode		IuWF[h
 *
 *	@return	none
 *
	GX_OAM_MODE_NORMAL		m[}OBJ 
	GX_OAM_MODE_XLU			OBJ 
	GX_OAM_MODE_OBJWND		OBJEBhE 
	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 */
//-----------------------------------------------------------------------------
void FONTOAM_ObjModeSet( FONTOAM_OBJ_PTR fontoam, GXOamMode objmode )
{
	int i;		// [vp

	GF_ASSERT( fontoam );
	// SZAN^[ɍWݒ
	for(i=0; i<fontoam->obj_num; i++ ){

		CLACT_ObjModeSet( fontoam->obj_w[ i ].clact, objmode );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	IuWF[h̎擾
 *
 *	@param	fontoam		FONTOAM
 *	@param	objmode		IuWF[h
 *
 *	@retval	GX_OAM_MODE_NORMAL		m[}OBJ 
 *	@retval	GX_OAM_MODE_XLU			OBJ 
 *	@retval	GX_OAM_MODE_OBJWND		OBJEBhE 
 *	@retval	GX_OAM_MODE_BITMAPOBJ	rbg}bvOBJ 
 */
//-----------------------------------------------------------------------------
GXOamMode FONTOAM_ObjModeGet( CONST_FONTOAM_OBJ_PTR fontoam, GXOamMode objmode )
{
	GF_ASSERT( fontoam );
	
	return CLACT_ObjModeGet( fontoam->obj_w[0].clact );
}



//-----------------------------------------------------------------------------
/**
 *		FONTOAM	ׂo[W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^쐬
 *
 *	@param	bmp		f[^쐬rbg}bv
 *	@param	heap	q[v
 *
 *	@return	f[^
 */
//-----------------------------------------------------------------------------
FONTOAM_OAM_DATA_PTR FONTOAM_OAMDATA_Make( const GF_BGL_BMPWIN* bmp, int heap )
{
	FONTOAM_OAM_DATA_PTR fontoam_data;

	fontoam_data = sys_AllocMemory( heap, sizeof(FONTOAM_OAM_DATA_SET) );
	fontoam_data->fontoamdata.next = &fontoam_data->fontoamdata;
	fontoam_data->fontoamdata.prev = &fontoam_data->fontoamdata;

	// OAMf[^쐬
	fontoam_data->data_num = getOamData( bmp->sizx, 
			bmp->sizy,
			heap, 
			&fontoam_data->fontoamdata );

	return fontoam_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^̔j
 *
 *	@param	oamdata	tHgOAMf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FONTOAM_OAMDATA_Free( FONTOAM_OAM_DATA_PTR oamdata )
{
	// OAMf[^j
	destOamListAll( &oamdata->fontoamdata );

	sys_FreeMemoryEz( oamdata );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^]ɕKvLN^TCY擾
 *
 *	@param	oamdata		tHgOAMf[^
 *	@param	draw_area	`GA
 *
 *	@return	KvLN^TCY
 */
//-----------------------------------------------------------------------------
int FONTOAM_OAMDATA_NeedCharSize( CONST_FONTOAM_OAM_DATA_PTR oamdata, int draw_area )
{
	return charAreaSizeOamDataList( &oamdata->fontoamdata, draw_area );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMf[^gpătHgOAM̍쐬
 *
 *	@param	fontoam_init		ӂOAM 쐬f[^
 *	@param	oamdata				OAMf[^
 *
 *	@return	쐬ꂽtHgOAM
 */
//-----------------------------------------------------------------------------
FONTOAM_OBJ_PTR FONTOAM_OAMDATA_Init( const FONTOAM_INIT* fontoam_init, CONST_FONTOAM_OAM_DATA_PTR oamdata )
{
	FONTOAM_OBJ_PTR fontoam;
	NNSG2dImageProxy* img_proxy;

	GF_ASSERT( fontoam_init );

	// ̃e[u擾
	fontoam = getCleanFONTOAM_OBJ( fontoam_init->fontoam_sys );
	GF_ASSERT_MSG( fontoam, "OAMtHge[u܂" );
	fontoam->parent	= fontoam_init->parent;	// ef[^

	fontoam->x	= fontoam_init->x;
	fontoam->y	= fontoam_init->y;

	// oam_num̃C[WvNVƁAZAN^[o^̈쐬
	img_proxy = sys_AllocMemoryLo( fontoam_init->heap,
			sizeof(NNSG2dImageProxy) * oamdata->data_num );
	fontoam->obj_w = sys_AllocMemory( fontoam_init->heap,
			sizeof(FONTOAM_OBJ_CORE) * oamdata->data_num );
	fontoam->obj_num = oamdata->data_num;

	// LN^f[^]
	charTransOamDataList( fontoam_init->bmp, 
			&oamdata->fontoamdata,
			img_proxy,
			fontoam_init->char_ofs,
			fontoam_init->draw_area,
			fontoam_init->heap );

	// ZAN^[o^
	addClActOamDataList( fontoam_init,
			&oamdata->fontoamdata,
			img_proxy,
			fontoam );

	// vNV̔j
	sys_FreeMemoryEz( img_proxy );

	return fontoam;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtHgj
 *
 *	@param	fontoam 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FONTOAM_OAMDATA_Delete( FONTOAM_OBJ_PTR fontoam )
{
	FONTOAM_Delete( fontoam );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM̃rbg}bvf[^ύX
 *
 *	@param	fontoam		ύXFONTOAM
 *	@param	oamdata		OAMf[^
 *	@param	bmp			rbg}bv 
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *	ӓ_
 *		rbg}bv̑傫Kv܂B
 */
//-----------------------------------------------------------------------------
void FONTOAM_OAMDATA_ResetBmp( FONTOAM_OBJ_PTR fontoam, CONST_FONTOAM_OAM_DATA_PTR oamdata, const GF_BGL_BMPWIN* bmp, int heap )
{
	int need_char;
	char* pbuff;
	NNSG2dImageProxy* p_prox;
	CLACT_WORK_PTR start_act = fontoam->obj_w[0].clact;
	int draw_area;

	// `GA
	draw_area = CLACT_VramTypeGet( start_act );


	// KvLN^obt@쐬
	need_char = FONTOAM_OAMDATA_NeedCharSize( oamdata, draw_area );

	// LN^obt@쐬
	pbuff = (char*)sys_AllocMemoryLo( heap, need_char );
	memset( pbuff, 0, need_char );

	// ]LN^f[^쐬
	charSetOamDataList( bmp, pbuff, &oamdata->fontoamdata, draw_area, heap );

    DC_FlushRange(pbuff, need_char);

	// Vramɓ]
	p_prox = CLACT_ImageProxyGet( start_act );
	if( draw_area == NNS_G2D_VRAM_TYPE_2DMAIN ){
		GX_LoadOBJ( pbuff, NNS_G2dGetImageLocation(	p_prox, NNS_G2D_VRAM_TYPE_2DMAIN ), need_char );	
	}else{
		GXS_LoadOBJ( pbuff, NNS_G2dGetImageLocation(	p_prox, NNS_G2D_VRAM_TYPE_2DSUB ), need_char );	
	}

	// LN^obt@j
	sys_FreeMemoryEz( pbuff );
}



//-----------------------------------------------------------------------------
/**
 *		FONTOAMƂ͖֌WłAėpIɎgpł֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BMP̃LN^f[^OAM̃TCYŐ؂
 *
 *	@param	bmp				rbg}bvf[^
 *	@param	oam_csx			OAM̉TCY	iLN^Pʁj
 *	@param	oam_csy			OAM̏cTCY	iLN^Pʁj
 *	@param	bmp_cmx			rbg}bv؂荶゘W	iLN^Pʁj
 *	@param	bmp_cmy			rbg}bv؂荶゙W	iLN^Pʁj
 *	@param	char_buff		o͐LN^obt@ (oam_csx * oam_csy)*32byte@TCYȏ̗̈
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void FONTOAM_BmpCutOamSize( const GF_BGL_BMPWIN* cp_bmp, int oam_csx, int oam_csy, int bmp_cmx, int bmp_cmy, char* char_buff )
{
	int i;				// [vp
	int buff_out;		// obt@ݐ
	int buff_in;		// obt@ǂݍݐ
	
	// bmpf[^̃TCY邩`FbN
	GF_ASSERT( cp_bmp->sizx >= (oam_csx + bmp_cmx) );
	GF_ASSERT( cp_bmp->sizy >= (oam_csy + bmp_cmy) );
	
	// [Jobt@Ƀf[^
	for( i=0; i<oam_csy; i++ ){
		
		buff_out = i * oam_csx;
		buff_out *= FONTOAM_CHAR_BYTE;
		buff_in =  ((i + bmp_cmy) * cp_bmp->sizx);
		buff_in += bmp_cmx;
		buff_in *= FONTOAM_CHAR_BYTE;
		memcpy( char_buff + buff_out, (char*)(cp_bmp->chrbuf) + buff_in , FONTOAM_CHAR_BYTE * oam_csx );
	}
}

//-----------------------------------------------------------------------------
/**
*		vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	e[u
 *
 *	@param	fontoam		OAMtHg
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanFONTOAM_OBJ( FONTOAM_OBJ* fontoam )
{
	memset( fontoam, 0, sizeof(FONTOAM_OBJ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃e[u擾
 *
 *	@param	fontoam_sys		OAMtHgVXe
 *
 *	@return	FONTOAM_OBJ*	OAMtHg
 *
 *
 */
//-----------------------------------------------------------------------------
static FONTOAM_OBJ* getCleanFONTOAM_OBJ( const FONTOAM_SYSTEM* fontoam_sys )
{
	int i;		// [vp

	for( i=0; i<fontoam_sys->fontoam_num; i++ ){

		if( fontoam_sys->fontoam_work[ i ].obj_w == NULL ){
			return fontoam_sys->fontoam_work  + i;
		}
	}


	return NULL;
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	ƍœKOAMTCY擾
 *
 *	@param	x				LN^P
 *	@param	y			LN^P
 *
 *		
 *	@retval		FONTOAM_PRI_8x8 = 0,	
 * 	@retval		FONTOAM_PRI_8x4,
 *	@retval		FONTOAM_PRI_4x8,
 *	@retval		FONTOAM_PRI_4x4,
 *	@retval		FONTOAM_PRI_4x2,
 *	@retval		FONTOAM_PRI_4x1,
 *	@retval		FONTOAM_PRI_2x4,
 *	@retval		FONTOAM_PRI_2x2,
 *	@retval		FONTOAM_PRI_2x1,
 *	@retval		FONTOAM_PRI_1x4,
 *	@retval		FONTOAM_PRI_1x2,
 *	@retval		FONTOAM_PRI_1x1,
 *
 */
//-----------------------------------------------------------------------------
static int searchOamSize( int x, int y )
{
	int i;	// [vp

	for( i = 0; i < FONTOAM_PRI_MAX; i++ ){
		
		// 肫l`FbN
		if( (FONTOAM_PriTbl[ i ][ FONTOAM_PRI_X ] <= x) &&
			(FONTOAM_PriTbl[ i ][ FONTOAM_PRI_Y ] <= y) ){
			return i;
		}
	}

	return FONTOAM_PRI_MAX;		//<-ɗ邱Ƃ͂Ȃ
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMߐsf[^쐬
 *
 *	@param	oam		GAf[^
 *	@param	list	Xg擪_~[f[^
 *	@param	heap	gpq[v
 *
 *	@retval	TRUE	ߐsf[^
 *	@retval FALSE	ߐsf[^쐬
 *
 * ɓnĂl̍8L@4L 2L 1L̂ꂩ
 * ɂĂB
 * 
 *
 */
//-----------------------------------------------------------------------------
static BOOL sumOamArea( FONTOAM_OAM_AREA* oam, FONTOAM_OAM_DATA* list, int heap )
{
	FONTOAM_OAM_DATA* oam_data;
	int rest_height;	// ܂荂
	int rest_width;		// ܂蕝

	
	// OAMf[^m
	oam_data = makeOamList( heap );
	setOamList( oam_data, list->prev );		// Ōɓo^
	
	// TCYOAMTCY擾
	oam_data->oam_size = searchOamSize( oam->now.width, oam->now.height );

	// ̈ʒuݒ
	oam_data->x = oam->now.left;
	oam_data->y = oam->now.top;

	// OAMߐsGA疄߂OAMTCY炷
	rest_width	= oam->now.width - FONTOAM_PriTbl[ oam_data->oam_size ][ FONTOAM_PRI_X ];
	rest_height = oam->now.height - FONTOAM_PriTbl[ oam_data->oam_size ][ FONTOAM_PRI_Y ];

	// ɂ܂肪Ƃ
	// cɂ͂܂肪Ȃ͂
	if( rest_width > 0 ){
		oam->right.height	= oam->now.height;
		oam->right.width	= rest_width;
		oam->right.top		= oam->now.top;
		oam->right.left		= oam->now.left + FONTOAM_PriTbl[ oam_data->oam_size ][ FONTOAM_PRI_X ];

		GF_ASSERT( (oam->tmp_flg != FONTOAM_OAM_AREA_RIGHT) );
		oam->tmp_flg = FONTOAM_OAM_AREA_RIGHT;
	}

	// ɂ܂肪Ƃ́Aɂ͂܂͂Ȃ
	// ܂̂Ƃ͍GAĐݒ
	// ɂ܂̖Ƃ͉EGAGAɂ
	if( rest_height > 0 ){
		oam->now.top = oam->now.top + FONTOAM_PriTbl[ oam_data->oam_size ][ FONTOAM_PRI_Y ];
		oam->now.height = rest_height;
	}else{
		

		// E邩`FbN
		if( oam->tmp_flg == FONTOAM_OAM_AREA_RIGHT ){
			oam->now = oam->right;
			oam->tmp_flg = FONTOAM_OAM_AREA_NONE;
		}else{
			// I
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	f[^oOAM̃f[^쐬
 *
 *	@param	x		OAMorbg}bvTCY
 *	@param	y		OAMorbg}bvTCY
 *	@param	heap	gpq[v
 *	@param	list	OAMf[^Xg擪f[^
 *
 *	@return	KvZAN^[
 *
 *
 */
//-----------------------------------------------------------------------------
static int getOamData( int x, int y, int heap,  FONTOAM_OAM_DATA* list )
{
	FONTOAM_OAM_AREA_ONE next_area;		// `FbNGA
	FONTOAM_OAM_AREA	now_area;		// `FbNGA
	int in_oam_size;					// GAɓOAMTCY
	int count;							// KvZAN^[
	
	// TCYO`FbN
	GF_ASSERT( x );
	GF_ASSERT( y );

	count = 0;
	now_area.now.top	= 0;
	now_area.now.left	= 0;
	now_area.now.width	= x;
	now_area.now.height	= y;
	now_area.tmp_flg	= FONTOAM_OAM_AREA_NONE;
	next_area.left		= 0;
	next_area.width		= x;
	
	// GA񂪂
	while( now_area.now.height != 0 ){

		// ̃GA̍`FbNGA̍
		in_oam_size			= searchOamSize( now_area.now.width, now_area.now.height );
		next_area.top		= now_area.now.top + FONTOAM_PriTbl[ in_oam_size ][ FONTOAM_PRI_Y ];
		next_area.height	= now_area.now.height - FONTOAM_PriTbl[ in_oam_size ][ FONTOAM_PRI_Y ];
		now_area.now.height = FONTOAM_PriTbl[ in_oam_size ][ FONTOAM_PRI_Y ];

		// OAM쐬
		do{
			count ++;
		}while( sumOamArea( &now_area, list, heap ) == FALSE );

		// nextnowɑ
		now_area.now = next_area;
	}

	return count;
}


//----------------------------------------------------------------------------
/**
 *	
 *	@brief	OAMf[^Xg̃LN^f[^]AC[WvNV쐬
 *
 *	@param	bmp			rbg}bvEBhEf[^
 *	@param	list		OAMf[^Xg
 *	@param	img_proxy	C[WvNV
 *	@param	offs		ItZbgl
 *	@param	draw_area	`
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void charTransOamDataList( const GF_BGL_BMPWIN* bmp, const FONTOAM_OAM_DATA* list, NNSG2dImageProxy* img_proxy, int offs, int draw_area, int heap )
{
	FONTOAM_OAM_DATA* work;
	int count;		// JE^
	int char_min;	// LN^f[^̍ŏP
	GXOBJVRamModeChar  map_mode;
	
	// LN^f[^̍ŏPʂvZ
	if( draw_area == NNS_G2D_VRAM_TYPE_2DMAIN ){
		map_mode = GX_GetOBJVRamModeChar();
	}else{
		map_mode = GXS_GetOBJVRamModeChar();
	}
	char_min = CharModeMinNum( map_mode );

	count = 0;
	work = list->next;
	while( work != list ){

		NNS_G2dInitImageProxy( img_proxy + count );
		offs = charTransOamDataOne( bmp, work, img_proxy + count, char_min, map_mode, offs, draw_area, heap );
		work = work->next;
		count++;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMf[^P̃LN^f[^쐬A]
 *
 *	@param	bmp			rbg}bvEBhEf[^
 *	@param	oamdata		OAMf[^
 *	@param	img_proxy	ݒC[WvNV
 *	@param	char_min_numLN^[hŐݒ肳ĂŒ̃LN^TCY
 *	@param	char_mode	}bsO[h
 *	@param	offs		ItZbgl
 *	@param	draw_area	`
 *	@param	heap		gpq[v
 *
 *	@return	]炵ItZbg
 *
 *
 */
//-----------------------------------------------------------------------------
static int charTransOamDataOne( const GF_BGL_BMPWIN* bmp, const FONTOAM_OAM_DATA* oamdata, NNSG2dImageProxy* img_proxy, int char_min_num, int char_mode, int offs, int draw_arae, int heap )
{
	char* local_buff;		// OAMP̃LN^f[^
	int buff_size;
	int oam_x, oam_y;	// oamTCY

	oam_x = FONTOAM_PriTbl[ oamdata->oam_size ][ FONTOAM_PRI_X ];
	oam_y = FONTOAM_PriTbl[ oamdata->oam_size ][ FONTOAM_PRI_Y ]; 
	
	// oamTCYLN^f[^obt@쐬
	buff_size =  oam_x;
	buff_size *= oam_y;
	if( buff_size < char_min_num ){
		buff_size = char_min_num;
	}
	buff_size *= FONTOAM_CHAR_BYTE;
	local_buff = sys_AllocMemoryLo( heap, buff_size );
	
	// [Jobt@Ƀf[^
	FONTOAM_BmpCutOamSize( bmp, oam_x, oam_y, oamdata->x, oamdata->y, local_buff );

    DC_FlushRange(local_buff, buff_size);

	
	// ]
	if( draw_arae == NNS_G2D_VRAM_TYPE_2DMAIN ){
		GX_LoadOBJ( local_buff, offs, buff_size );	
		img_proxy->vramLocation.baseAddrOfVram[ NNS_G2D_VRAM_TYPE_2DMAIN ] = offs;
		img_proxy->attr.mappingType = GX_GetOBJVRamModeChar();	  // C
	}else{
		GXS_LoadOBJ( local_buff, offs, buff_size );	
		img_proxy->vramLocation.baseAddrOfVram[ NNS_G2D_VRAM_TYPE_2DSUB ] = offs;
		img_proxy->attr.mappingType = GXS_GetOBJVRamModeChar();   // Tu
	}
	img_proxy->attr.sizeS         = NNS_G2D_1D_MAPPING_CHAR_SIZE;
    img_proxy->attr.sizeT         = NNS_G2D_1D_MAPPING_CHAR_SIZE;
    img_proxy->attr.fmt           = GX_TEXFMT_PLTT16;
    img_proxy->attr.bExtendedPlt  = FALSE;                
    img_proxy->attr.plttUse       = GX_TEXPLTTCOLOR0_TRNS;
    img_proxy->attr.mappingType   = char_mode;

	sys_FreeMemoryEz( local_buff );

	return (offs + buff_size);
}

//----------------------------------------------------------------------------
/**
 *	
 *	@brief	OAMf[^Xg̃LN^f[^쐬
 *
 *	@param	bmp			rbg}bvEBhEf[^
 *	@param	pbuff		LN^f[^obt@
 *	@param	list		OAMf[^Xg
 *	@param	draw_area	`GA
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void charSetOamDataList( const GF_BGL_BMPWIN* bmp, char* pbuff, const FONTOAM_OAM_DATA* list, int draw_area, int heap )
{
	FONTOAM_OAM_DATA* work;
	int count;		// JE^
	int char_min;	// LN^f[^̍ŏP
	int offs;
	GXOBJVRamModeChar  map_mode;
	
	// LN^f[^̍ŏPʂvZ
	if( draw_area == NNS_G2D_VRAM_TYPE_2DMAIN ){
		map_mode = GX_GetOBJVRamModeChar();
	}else{
		map_mode = GXS_GetOBJVRamModeChar();
	}
	char_min = CharModeMinNum( map_mode );

	offs = 0;
	work = list->next;
	while( work != list ){

		offs = charSetOamDataOne( bmp, work, pbuff, offs, char_min, map_mode, heap );
		work = work->next;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMf[^P̃LN^f[^쐬
 *
 *	@param	bmp			rbg}bvEBhEf[^
 *	@param	oamdata		OAMf[^
 *	@param	pbuff		LN^obt@
 *	@param	idx			CfbNX
 *	@param	char_min_numLN^[hŐݒ肳ĂŒ̃LN^TCY
 *	@param	char_mode	}bsO[h
 *	@param	heap		gpq[v
 *
 *	@return	idx	̊i[CfbNX
 *
 *
 */
//-----------------------------------------------------------------------------
static int charSetOamDataOne( const GF_BGL_BMPWIN* bmp, const FONTOAM_OAM_DATA* oamdata, char* pbuff, int idx, int char_min_num, int char_mode, int heap )
{
	int buff_size;
	int oam_x, oam_y;	// oamTCY

	oam_x = FONTOAM_PriTbl[ oamdata->oam_size ][ FONTOAM_PRI_X ];
	oam_y = FONTOAM_PriTbl[ oamdata->oam_size ][ FONTOAM_PRI_Y ]; 
	
	// oamTCYLN^f[^obt@쐬
	buff_size =  oam_x;
	buff_size *= oam_y;
	if( buff_size < char_min_num ){
		buff_size = char_min_num;
	}
	buff_size *= FONTOAM_CHAR_BYTE;
	
	// [Jobt@Ƀf[^
	FONTOAM_BmpCutOamSize( bmp, oam_x, oam_y, oamdata->x, oamdata->y, &pbuff[idx] );

	return (idx + buff_size);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMS\̂ɕKvȃLN^f[^TCY擾
 *
 *	@param	list 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static int charAreaSizeOamDataList( const FONTOAM_OAM_DATA* list, int draw_area )
{
	FONTOAM_OAM_DATA* work;
	int char_min;	// LN^f[^̍ŏP
	GXOBJVRamModeChar  map_mode;
	int offs;
	int char_num;
	int oam_x, oam_y;	// oamTCY
	
	// LN^f[^̍ŏPʂvZ
	if( draw_area == NNS_G2D_VRAM_TYPE_2DMAIN ){
		map_mode = GX_GetOBJVRamModeChar();
	}else{
		map_mode = GXS_GetOBJVRamModeChar();
	}
	char_min = CharModeMinNum( map_mode );

	offs = 0;
	work = list->next;
	while( work != list ){

		// LN^oamTCYLN^vZ
		oam_x = FONTOAM_PriTbl[ work->oam_size ][ FONTOAM_PRI_X ];
		oam_y = FONTOAM_PriTbl[ work->oam_size ][ FONTOAM_PRI_Y ]; 
		
		char_num = oam_x * oam_y;
		if( char_num < char_min ){
			char_num = char_min;
		}
		
		offs += char_num * FONTOAM_CHAR_BYTE;
		
		work = work->next;
	}

	return offs;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMf[^Xg̃ZAN^[쐬
 *
 *	@param	font_init		tHg쐬f[^
 *	@param	list			OAMf[^Xg擪f[^
 *	@param	img_proxy		C[WvNVzf[^
 *	@param	font_obj		tHgIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void addClActOamDataList( const FONTOAM_INIT* font_init, const FONTOAM_OAM_DATA* list, const NNSG2dImageProxy* img_proxy, FONTOAM_OBJ_PTR font_obj )
{
	FONTOAM_OAM_DATA* work;
	int count;

	count = 0;
	work = list->next;
	while( work != list ){
		
		font_obj->obj_w[ count ].clact = addClActOamDataOne( font_init, work, img_proxy + count );
		GF_ASSERT( font_obj->obj_w[ count ].clact );
		font_obj->obj_w[ count ].x = work->x * FONTOAM_CHAR_SIZE;
		font_obj->obj_w[ count ].y = work->y * FONTOAM_CHAR_SIZE;
		
		work = work->next;
		count++;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Xg̃ZAN^[j
 *
 *	@param	fontoam 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void delClActOamDataList( FONTOAM_OBJ_PTR fontoam )
{
	int i;		// [vp

	for( i=0; i<fontoam->obj_num; i++ ){

		CLACT_Delete( fontoam->obj_w[ i ].clact );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	POAM̃AN^[쐬
 *
 *	@param	font_init	tHg쐬f[^
 *	@param	oamdata		OAMf[^
 *	@param	img_proxy	gpC[WvNV
 *
 *	@return	쐬AN^[|C^
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_WORK_PTR addClActOamDataOne( const FONTOAM_INIT* font_init, const FONTOAM_OAM_DATA* oamdata, const NNSG2dImageProxy* img_proxy )
{
	CLACT_ADD_SIMPLE	add;		// o^f[^
	CLACT_HEADER		head;		// wb_[

	// ZAN^[wb_[쐬
	head.pImageProxy	= img_proxy;
	head.pCharData		= NULL;
	head.pPaletteProxy	= font_init->pltt;
	head.pCellBank		= font_init->fontoam_sys->pCellBank[ oamdata->oam_size ];
	head.pAnimBank		= NULL;
	head.pMCBank		= NULL;
	head.pMCABank		= NULL;

	head.flag			= 0;
	head.priority		= font_init->bg_pri;
	
	// o^f[^쐬
	add.ClActSet		= font_init->clact_set;
	add.ClActHeader		= &head;
	add.pri				= font_init->soft_pri;
	add.DrawArea		= font_init->draw_area;
	add.heap			= font_init->heap;

	// o^WvZ
	add.mat.x = 0;
	add.mat.y = 0;
	add.mat.z = 0;
	
	if( font_init->parent ){
		const VecFx32* parent_mat;			// eW
		parent_mat = CLACT_GetMatrix( font_init->parent );

		add.mat = *parent_mat;
	}
	add.mat.x	+= (font_init->x << FX32_SHIFT) + ((oamdata->x * FONTOAM_CHAR_SIZE) << FX32_SHIFT);
	add.mat.y	+= (font_init->y << FX32_SHIFT) + ((oamdata->y * FONTOAM_CHAR_SIZE) << FX32_SHIFT);

	// o^
	return CLACT_AddSimple( &add );
}







//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMf[^쐬
 *
 *	@param	heap	gpq[v
 *
 *	@return	OAMf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static FONTOAM_OAM_DATA* makeOamList( int heap )
{
	FONTOAM_OAM_DATA* oamdata;

	oamdata = sys_AllocMemoryLo( heap, sizeof(FONTOAM_OAM_DATA) );
	GF_ASSERT_MSG( oamdata, "I[o[" );

	oamdata->next = NULL;
	oamdata->prev = NULL;

	return oamdata;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	OAMf[^
 *
 *	@param	oamdata OAMf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void destOamList( FONTOAM_OAM_DATA* oamdata )
{
	GF_ASSERT( oamdata );

	sys_FreeMemoryEz( oamdata );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Xg̑Sf[^j
 *
 *	@param	dummy	_~[f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void destOamListAll( FONTOAM_OAM_DATA* dummy )
{
	FONTOAM_OAM_DATA* work;
	FONTOAM_OAM_DATA* next;

	work = dummy->next;
	while( work != dummy ){
		next = work->next;
		destOamList( work );
		work = next;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Xgɐݒ
 *
 *	@param	oamdata	OAMf[^
 *	@param	prev	Õf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setOamList( FONTOAM_OAM_DATA* oamdata, FONTOAM_OAM_DATA* prev )
{
	oamdata->next		= prev->next;
	oamdata->prev		= prev;
	prev->next->prev	= oamdata;
	prev->next			= oamdata;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	oamf[^Xg͂
 *
 *	@param	oamdata	OAMf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void resetOamList( FONTOAM_OAM_DATA* oamdata )
{
	oamdata->prev->next	= oamdata->next;
	oamdata->next->prev	= oamdata->prev;
}
