//=============================================================================================
/**
 * @file	fontproc.c
 * @brief	tHgf[^
 * @author	tetsu
 * @date	2003.03.25
 *
 *	etHg̉摜f[^Kvɉă[hEA[ho悤ɏC
 *	2005.08.24	taya
 *
 *
 *	tHg^CvƂɏ֐pӂ邱܂ł̕@~߁A
 *	tHgf[^̂ɏɕKvȃp[^āAʂ̊֐Qő삷悤ɂB
 *	2005.09.14	taya
 *
 */
//=============================================================================================
#include "common.h"

#include "gflib\msg_print.h"
#include "gflib\strbuf_family.h"
#include "system\pmfprint.h"
#include "system\fontproc.h"

#include "system\arc_util.h"
#include "system\font_arc.h"
#include "gflib\fontdata_man.h"

//---------------------------------------------------------------------------------------------
/**
 *	tHgf[^[hp[^iFONT_TYPȄɕłj
 */
//---------------------------------------------------------------------------------------------
//
static const struct {
	u16  arcDataIdx;	///< A[JCũtHgf[^CfbNX
	u16  fixedFontFlag;	///< tHgtO
}FontDataTbl[] = {
	{ NARC_font_system_dat,  FALSE,  },
	{ NARC_font_talk_dat,    FALSE,  },
	{ NARC_font_button_dat,  FALSE,  },
};

//---------------------------------------------------------------------------------------------
/**
 *	쐬f[^wb_̐ݒiFONT_TYPȄɕłj
 */
//---------------------------------------------------------------------------------------------
static const MSG_FONT_HEADER font_header_data[] = {
	// bZ[WtHgiv|[Vij
	{
		11, 16,			// tHgTCY X, Y
		 0,  0, 0,		// , s, tHgX^C
 		 1, 15, 2		// FAwiFAeF
	},
	// VXetHgiv|[Vij
	{
		11, 16,			// tHgTCY X, Y
		 0,  0, 0,		// , s, tHgX^C
 		 1, 15, 2		// FAwiFAeF
	},
	// {^tHgiv|[Vij
	{
		11, 16,			// tHgTCY X, Y
		 0,  0, 0,		// , s, tHgX^C
 		 1, 15, 2		// FAwiFAeF
	},
	{	0,0,0,0,0,0,0,0},
};


//---------------------------------------------------------------------------------------------
/**
 *	[N`
 */
//---------------------------------------------------------------------------------------------
typedef struct {
	MSG_FONT_DATA     letterBitData;		///< rbgf[^P`惏[N
	void*             fontData[ NELEMS(FontDataTbl) ];
	GF_FONTDATA_MAN*  fontMan[ NELEMS(FontDataTbl) ];

}FONT_PROC_WORK;

static FONT_PROC_WORK  WorkBody = {0};
static FONT_PROC_WORK* WorkPtr = NULL;

//------------------------------------------------------------------
/**
 * tHgW[̏
 */
//------------------------------------------------------------------
void FontProcInit( void )
{
	u32 i;

	WorkPtr = &WorkBody;

	for(i = 0; i < NELEMS(FontDataTbl); i++)
	{
		WorkPtr->fontData[i] = NULL;
		WorkPtr->fontMan[i] = NULL;
	}

	MSG_PrintSysInit(font_header_data);
}

//------------------------------------------------------------------
/**
 * tHgf[^RAMɃ[h
 *
 * @param   font		tHg^Cv
 */
//------------------------------------------------------------------
void FontProc_LoadFont( FONT_TYPE font, u32 heapID )
{
#if 0
	u32 i;
	void *fontData = NULL;

	// łɓtHgf[^[hĂꍇ͂g
	for(i = 0; i < NELEMS(FontDataTbl); i++)
	{
		if( i == font ){
			continue;
		}
		if( (FontDataTbl[i].arcDataIdx == FontDataTbl[font].arcDataIdx )
		&&	(WorkPtr->fontData[font] != NULL)
		){
			fontData = WorkPtr->fontData[font];
			break;
		}
	}

	// ܂[hĂȂΐVKɃ[h
	if( fontData == NULL )
	{
		fontData = ArcUtil_Load( ARC_FONT, FontDataTbl[font].arcDataIdx, FALSE, heapID, ALLOC_TOP );
		if(fontData != NULL)
		{
			WorkPtr->fontData[font] = fontData;
		}
		else
		{
			GF_ASSERT(0 && "tHgf[^̃[hɎs\n");
			return;
		}
	}

	WorkPtr->fontMan[font] = FontDataMan_Create( fontData, FontDataTbl[font].fixedFontFlag, heapID );
#else
	WorkPtr->fontMan[font] = FontDataMan_Create( ARC_FONT, FontDataTbl[font].arcDataIdx,
								FONTDATA_LOADTYPE_READ_FILE,
//								FONTDATA_LOADTYPE_ON_MEMORY,
								FontDataTbl[font].fixedFontFlag, heapID );
#endif
}


//------------------------------------------------------------------
/**
 * tHg̃rbgf[^ɏ풓Aǂݍݏ
 *
 * @param   font			tHgID
 * @param   heapID			rbgf[^풓pq[vID
 *
 */
//------------------------------------------------------------------
void FontProc_LoadBitData( FONT_TYPE font, u32 heapID )
{
	GF_ASSERT( font < FONT_MAX );
	GF_ASSERT( WorkPtr->fontMan[font] );

	FontDataMan_ChangeLoadType( WorkPtr->fontMan[font], FONTDATA_LOADTYPE_ON_MEMORY, heapID );
}

//------------------------------------------------------------------
/**
 * FontProc_LoadBitData ŏ풓rbgf[^jA
 * t@Cǂݍݕɖ߂
 *
 * @param   font			tHgID
 *
 */
//------------------------------------------------------------------
void FontProc_UnloadBitData( FONT_TYPE font )
{
	GF_ASSERT( font < FONT_MAX );
	GF_ASSERT( WorkPtr->fontMan[font] );

	FontDataMan_ChangeLoadType( WorkPtr->fontMan[font], FONTDATA_LOADTYPE_READ_FILE, 0 );
}



//------------------------------------------------------------------
/**
 * RAMɃ[hĂtHgBMPA[h
 *
 * @param   font		tHg^Cv
 */
//------------------------------------------------------------------
void FontProc_UnloadFont( FONT_TYPE font )
{
	GF_ASSERT( font < FONT_MAX );

	if( WorkPtr->fontData[font] != NULL )
	{
		int i;

		// tHgf[^QƂĂ}l[W
		// ̊ǗɔCāAɃf[^̉͂Ȃ
		for(i = 0; i < NELEMS(FontDataTbl); i++)
		{
			if( i == font ){ continue; }
			if(	(FontDataTbl[i].arcDataIdx == FontDataTbl[font].arcDataIdx )
			&&	(WorkPtr->fontMan[i] != NULL)
			){
				WorkPtr->fontData[i] = WorkPtr->fontData[font];
				break;
			}
		}
		if( i == NELEMS(FontDataTbl) )
		{
			sys_FreeMemoryEz( WorkPtr->fontData[font] );
			WorkPtr->fontData[font] = NULL;
		}
	}

	if( WorkPtr->fontMan[font] != NULL )
	{
		FontDataMan_Delete( WorkPtr->fontMan[font] );
		WorkPtr->fontMan[font] = NULL;
	}
}
//------------------------------------------------------------------
/**
 * tHgBMPf[^P[Nɓǂݍ݁ÃAhXn
 *
 * @param   font		tHg^Cv
 * @param   code		R[h
 *
 * @retval  const MSG_FONT_DATA*		ǂݍݐAhX
 */
//------------------------------------------------------------------
const MSG_FONT_DATA* FontDataGet( FONT_TYPE font, STRCODE code )
{
	FontDataMan_GetBitmap( WorkPtr->fontMan[font], code, &WorkPtr->letterBitData );
	return &(WorkPtr->letterBitData);
}
//------------------------------------------------------------------
/**
 * tHgf[^EBhEL[N̈ɕ`
 *
 * @param   font		tHg^Cv
 * @param   ini			BGLVXe[N
 * @param   mdh		
 *
 */
//------------------------------------------------------------------
PRINT_RESULT FontDataPrint( FONT_TYPE font, MSG_DATA_HEADER * mdh_p )
{
	MSG_PRINT_USER * mpu_p;

	mpu_p = (MSG_PRINT_USER *)&(mdh_p->userwork[0]);
	if(!mpu_p->modechg_f)
	{
		mpu_p->fmode = font;
		mpu_p->modechg_f = 1;
	}
	return PokeFontPrint( mdh_p );
}

//------------------------------------------------------------------
/**
 * rbg}bv̉擾
 *
 * @param   font		tHg^Cv
 * @param   str			
 * @param   margin		ԁihbgj
 *
 * @retval  u32			ihbgj
 */
//------------------------------------------------------------------
u32 FontProc_GetStrWidth( FONT_TYPE font, const STRCODE* str, u32 margin )
{
	GF_ASSERT(WorkPtr->fontMan[font] != NULL);
	return FontDataMan_GetStrWidth( WorkPtr->fontMan[font], str, margin );
}

//------------------------------------------------------------------
/**
 * rbg}bv̉擾(STRBUFŁj
 *
 * @param   font		tHg^Cv
 * @param   str			
 * @param   margin		ԁihbgj
 *
 * @retval  u32			ihbgj
 */
//------------------------------------------------------------------
u32 FontProc_GetPrintStrWidth( FONT_TYPE font, const STRBUF* str, u32 margin )
{
	GF_ASSERT(WorkPtr->fontMan[font] != NULL);
	return FontDataMan_GetStrWidth( WorkPtr->fontMan[font], STRBUF_GetStringCodePointer(str), margin );
}


//--------------------------------------------------------------------------------------------
/**
 * tHgf[^擾
 *
 * @param	fnt_index	tHgCfbNX
 * @param	param		擾p[^
 *
 * @return	w肳ꂽp[^
 */
//--------------------------------------------------------------------------------------------
u8 FontHeaderGet( u8 fnt_index, u8 param )
{
	u8	ret = 0;

	switch( param ){
	case FONT_HEADER_SIZE_X:	// tHgXTCYw
		ret = font_header_data[ fnt_index ].size_x;
		break;
	case FONT_HEADER_SIZE_Y:	// tHgYTCYw
		ret = font_header_data[ fnt_index ].size_y;
		break;
	case FONT_HEADER_SPACE_X:	// ԊuX(ݒ)
		ret = font_header_data[ fnt_index ].space_x;
		break;
	case FONT_HEADER_SPACE_Y: 	// ԊuY(ݒ)
		ret = font_header_data[ fnt_index ].space_y;
		break;
	case FONT_HEADER_STYLE:		// tHgX^C(ݒ)
		ret = font_header_data[ fnt_index ].style;
		break;
	case FONT_HEADER_F_COLOR:	// Fio[
		ret = font_header_data[ fnt_index ].f_col;
		break;
	case FONT_HEADER_B_COLOR:	// wiFio[
		ret = font_header_data[ fnt_index ].b_col;
		break;
	case FONT_HEADER_S_COLOR:	// eF@io[
		ret = font_header_data[ fnt_index ].s_col;
		break;
	}

	return	ret;
}


//--------------------------------------------------------------------------------------------
/**
 * VXetHgpbgǂݍ
 *
 * @param	type	pbg]^Cv
 * @param	offs	ǂݍ݃ItZbgioCgPʁj
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SystemFontPaletteLoad( u32 type, u32 offs, u32 heap )
{
	ArcUtil_PalSet( ARC_FONT, NARC_font_system_ncrl, (PALTYPE)type, offs, 0x20, heap );
}

//--------------------------------------------------------------------------------------------
/**
 * btHgpbgǂݍ
 *
 * @param	type	pbg]^Cv
 * @param	offs	ǂݍ݃ItZbgioCgPʁj
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TalkFontPaletteLoad( u32 type, u32 offs, u32 heap )
{
	ArcUtil_PalSet( ARC_FONT, NARC_font_talk_ncrl, (PALTYPE)type, offs, 0x20, heap );
}
