//=============================================================================
/**
 * @file	main.c
 * @brief	|PcoC
 * @author	GAME FREAK Inc.
 */
//=============================================================================

#include "common.h"
#include "snd_system.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "debug/stress_meter.h"

#include "system/main.h"

#include "field/field.h"		//FieldSystem_Init
#include "gflib\apptimer.h"
#include "system\fontproc.h"
#include "system/brightness.h"
#include "system/pm_rtc.h"
#include "gflib/gf_gx.h"

#include "system/savedata.h"
#include "system/pm_overlay.h"

#include "demo/title.h"


static void InitRandom(void);
static void Main_CallProc(void);
static void ResetFunc(void);

//=============================================================================
//=============================================================================
//---------------------------------------------------------------------------
/**
 * @brief	Cp[N
 */
//---------------------------------------------------------------------------
typedef struct {
	FSOverlayID ov_id;				///<݂̃CvZX̃I[o[CID
	PROC * proc;					///<݂̃CvZX̃|C^
	FSOverlayID next_ov_id;			///<̃CvZX̃I[o[CID
	const PROC_DATA * next_data;	///<̃CvZXf[^ւ̃|C^
	MAINWORK work;					///<CvZXp[Nimain.hŒ`j
}SYSWORK;

static SYSWORK main;

//=============================================================================
//
//				C
//
//=============================================================================
extern const PROC_DATA Title_Logo_Demo_proc_data;

FS_EXTERN_OVERLAY( title );

//---------------------------------------------------------------------------
/**
 * @brief	C֐
 */
//---------------------------------------------------------------------------
void NitroMain(void)
{
	//===========================
	//		
	//===========================
	
    sys_InitSystem();
    sys_InitVRAM();
    sys_InitKeyRead();
	GF_GX_Init();
	GF_RTC_Init();

	Main_Init();

	main.work.savedata = SaveData_System_Init();

	Snd_AllInit();

	APTM_Init();

	// tHgf[^̃[h
	FontProcInit();
	FontProc_LoadFont( FONT_SYSTEM, HEAPID_BASE_APP );
	FontProc_LoadFont( FONT_TALK, HEAPID_BASE_APP );

//	OS_TPrintf("remain of heap_app = 0x%08x\n", sys_GetHeapFreeSize(HEAPID_BASE_APP));

	//Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	Main_SetNextProc( FS_OVERLAY_ID(title), &Title_Logo_Demo_proc_data);

	sys.vsync_flame_counter = 0;
	InitRandom();

	//PxύX\̏
	BrightnessChgInit();
	
	//===========================
	//	C[v
	//===========================
	while (1) {
		sys_MainKeyRead();	//L[ǂݎ
		
		if ((sys.cont & (PAD_BUTTON_A|PAD_BUTTON_B|PAD_BUTTON_X|PAD_BUTTON_Y))
			==(PAD_BUTTON_A|PAD_BUTTON_B|PAD_BUTTON_X|PAD_BUTTON_Y)) {
            ResetFunc();
		}

        if(CommUpdateData()){  // f[^LʐM̒ʐM

			Main_CallProc();	//CvZXĂяo

			TCBSYS_Main( sys.mainTCBSys );
			TCBSYS_Main( sys.printTCBSys );

			if(!sys.vsync_flame_counter){
                SVC_WaitVBlankIntr();	// uuN҂
                sys.vsync_counter++;	// uuNpJE^
            }
        }
		GF_RTC_Main();

		GF_G3_SwapBuffers();	// G3_SwapBuffersĂяo
		TCBSYS_Main( sys.printTCBSys );
        SVC_WaitVBlankIntr();	// uuN҂
		sys.vsync_counter++;	// uuNpJE^
		sys.vsync_flame_counter = 0;


		//===========================
		BrightnessChgMain();	//PxύXC
		Snd_Main();
		if (sys.pVBlank != NULL) {
			sys.pVBlank(sys.pVBlankWork);
		}

		TCBSYS_Main( sys.vwaitTCBSys );
    }
}


//=============================================================================
//
//
//		CvZX
//
//
//=============================================================================

//---------------------------------------------------------------------------
/**
 * @brief	CvZX
 */
//---------------------------------------------------------------------------
void Main_Init(void)
{
	main.ov_id = NO_OVERLAY_ID;
	main.proc = NULL;
	main.next_ov_id = NO_OVERLAY_ID;
	main.next_data = NULL;
}

//---------------------------------------------------------------------------
/**
 * @brief	CvZXs
 */
//---------------------------------------------------------------------------
static void Main_CallProc(void)
{
	BOOL result;

	if (main.proc == NULL) {
		if (main.next_data == NULL) {
			return;
		}
		if (main.next_ov_id != NO_OVERLAY_ID) {
			//Kvł΃I[o[C̃[hs
			Overlay_Load(main.next_ov_id, OVERLAY_LOAD_SYNCHRONIZE);
		}
		main.ov_id = main.next_ov_id;
		main.proc = PROC_Create(main.next_data, &main.work, HEAPID_BASE_SYSTEM);
		main.next_ov_id = NO_OVERLAY_ID;
		main.next_data = NULL;
	}

	result = ProcMain(main.proc);
	if (result) {
		main.proc = NULL;
		if (main.ov_id != NO_OVERLAY_ID) {
			//Kvł΃I[o[C̃A[hs
			Overlay_UnloadID(main.ov_id);
		}
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	̃vZX̓o^
 * @param	ov_id		I[o[CID
 * @param	proc_data	PROC_DATAւ̃|C^
 */
//---------------------------------------------------------------------------
void Main_SetNextProc(FSOverlayID ov_id, const PROC_DATA * proc_data)
{
	GF_ASSERT(main.next_data == NULL);
	main.next_ov_id = ov_id;
	main.next_data = proc_data;
}


//---------------------------------------------------------------------------
/**
 * @brief	\tgEGAZbgNꍇ̏
 * @param	none
 */
//---------------------------------------------------------------------------
static void ResetFunc(void)
{
    if(CommStateExitReset()){
        OS_ResetSystem(0);  // ɏI
    }
	while (1) {
        if(CommMPIsConnectStalth()){
            OS_ResetSystem(0);  // ؒfmFI
        }
        if(CommUpdateData()){  // f[^LʐM̒ʐM
			TCBSYS_Main( sys.mainTCBSys );
        }
        SVC_WaitVBlankIntr();	// uuN҂
		sys.vsync_counter++;	// uuNpJE^
		sys.vsync_flame_counter = 0;
		if (sys.pVBlank != NULL) {
			sys.pVBlank(sys.pVBlankWork);
		}
    }
}

//=============================================================================
//=============================================================================
//---------------------------------------------------------------------------
/**
 * @brief	ibj
 *
 * ۂɂ͗͂ꂼꂪgReLXgƂɃV[h⃏[N
 * ێKv̂ŁAύX\BƂ肠A͎b
 * 
 */
//---------------------------------------------------------------------------
static void InitRandom(void)
{
	RTCDate date;
	RTCTime time;
	u32 seed;
	GF_RTC_GetDateTime(&date, &time);
	seed = date.year + date.month * 0x100 * date.day * 0x10000
		+ time.hour * 0x10000 + (time.minute + time.second) * 0x1000000;
	gf_mtSrand(seed);
	gf_srand(seed);
}

