//============================================================================================
/**
 * @file	msgdata.c
 * @brief	e탁bZ[Wf[^舵
 * @author	taya
 * @date	2005.09.26
 */
//============================================================================================
#include "common.h"
#include "gflib\strbuf_family.h"
#include "system\arc_tool.h"
#include "system\pm_str.h"
#include "system\get_text.h"
#include "system\msgdata.h"

#include "msgdata\msg.naix"
#include "msgdata\msg_monsname.h"
#include "msgdata\msg_wazaname.h"
#include "msgdata\msg_typename.h"
#include "msgdata\msg_tokusei.h"
#include "msgdata\msg_status.h"
#include "msgdata\msg_condition.h"
#include "msgdata\msg_taste.h"
#include "msgdata\msg_itemname.h"
#include "msgdata\msg_iteminfo.h"



/*------------------------------------------------------------*/
/** p[^                                          */
/*------------------------------------------------------------*/
typedef struct {
	u32  offset;	///< t@C擪̃oCgItZbg
	u32  len;		///< iEOM܂ށj
}MSG_PARAM_BLOCK;

/*------------------------------------------------------------*/
/** f[^wb_                                        */
/*------------------------------------------------------------*/
struct _MSGDATA_HEADER{
	u32					numMsgs;
	MSG_PARAM_BLOCK		params[];
};


//==============================================================
// Prototype
//==============================================================
static void StrSet( STRCODE* dst,  const STRCODE* src,  const MSG_PARAM_BLOCK* param );


//------------------------------------------------------------------
/**
 * bZ[Wf[^A[JCu烍[h
 *
 * @param   arcID		A[JCut@Chc
 * @param   datID		A[JCut@C̃bZ[Wf[^hc
 * @param   heapID		q[vhc
 *
 * @retval  MSGDATA_HEADER*		bZ[Wf[^|C^
 */
//------------------------------------------------------------------
MSGDATA_HEADER* MSGDAT_Load( u32 arcID, u32 datID, u32 heapID )
{
	return ArchiveDataLoadMalloc( arcID, datID, heapID );
}
//------------------------------------------------------------------
/**
 * [hbZ[Wf[^A[h
 *
 * @param   msgdat		bZ[Wf[^|C^
 *
 */
//------------------------------------------------------------------
void MSGDAT_Unload( MSGDATA_HEADER* msgdat )
{
	sys_FreeMemoryEz( msgdat );
}


//------------------------------------------------------------------
/**
 * [hbZ[Wf[^當Rs[
 *
 * @param   msgdat		bZ[Wf[^|C^
 * @param   strID		hc
 * @param   dst			Rs[obt@
 *
 */
//------------------------------------------------------------------
void MSGDAT_Get( const MSGDATA_HEADER* msgdat, u32 strID, STRCODE* dst )
{
	if( strID < msgdat->numMsgs )
	{
		const MSG_PARAM_BLOCK* param;
		const STRCODE* str;

		param = &(msgdat->params[strID]);
		str = (STRCODE*)(((u8*)msgdat) + param->offset);
		StrSet( dst, str, param );
	}
	else
	{
		GF_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * [hbZ[Wf[^w蕶TCỸmہRs[
 *
 * @param   msgdat		bZ[Wf[^|C^
 * @param   strID		ID
 * @param   heapID		mۗp̃q[vID
 *
 * @retval  񂪃Rs[ꂽubNisNULLj
 *
 */
//------------------------------------------------------------------
STRCODE* MSGDAT_GetAlloc( const MSGDATA_HEADER* msgdat, u32 strID, u32 heapID )
{
	if( strID < msgdat->numMsgs )
	{
		const MSG_PARAM_BLOCK* param;
		const STRCODE* src;
		STRCODE *dst;

		param = &(msgdat->params[strID]);
		src = (STRCODE*)(((u8*)msgdat) + param->offset);
		dst = sys_AllocMemory( heapID, param->len*sizeof(STRCODE) );
		if( dst )
		{
			StrSet( dst, src, param );
		}
		return dst;
	}
	else
	{
		GF_ASSERT(0);
	}
	return NULL;
}
//------------------------------------------------------------------
/**
 * w蕶݂̂[hwobt@ɃRs[
 *
 * @param   arcID		A[JCut@Chc
 * @param   datID		A[JCut@C̃bZ[Wf[^hc
 * @param   msgID		bZ[Wf[^̕hc
 * @param   heapID		ꎞmۗp̃q[vhc
 * @param   dst			Rs[obt@
 *
 */
//------------------------------------------------------------------
void MSGDAT_GetDirect( u32 arcID, u32 datID, u32 strID, u32 heapID, STRCODE* dst )
{
	MSG_PARAM_BLOCK  param;
	STRCODE*  str;
	u32 offs, size;

	offs = sizeof(u32) + sizeof(MSG_PARAM_BLOCK) * strID;
	ArchiveDataLoadOfs( &param, arcID, datID, offs, sizeof(MSG_PARAM_BLOCK) );

	size = param.len * sizeof(STRCODE);
	str = sys_AllocMemory( heapID, size );
	if( str )
	{
		ArchiveDataLoadOfs( str, arcID, datID, param.offset, size );
		StrSet( dst, str, &param );
		sys_FreeMemoryEz( str );
	}
}
//------------------------------------------------------------------
/**
 * w蕶݂̂[hAŃAP[gɃRs[ĕԂ
 *
 * @param   arcID		A[JCut@Chc
 * @param   datID		A[JCut@C̃bZ[Wf[^hc
 * @param   msgID		bZ[Wf[^̕hc
 * @param   heapID		ꎞmۗp̃q[vhc
 *
 * @retval  STRCODE*	񂪃Rs[ꂽubNisNULLj
 */
//------------------------------------------------------------------
STRCODE* MSGDAT_GetDirectAlloc( u32 arcID, u32 datID, u32 strID, u32 heapID )
{
	MSG_PARAM_BLOCK  param;
	STRCODE*  src;
	STRCODE*  dst;
	u32 offs, size;

	offs = sizeof(u32) + sizeof(MSG_PARAM_BLOCK) * strID;
	ArchiveDataLoadOfs( &param, arcID, datID, offs, sizeof(MSG_PARAM_BLOCK) );

	size = param.len * sizeof(STRCODE);
	src = sys_AllocMemoryLo( heapID, size );
	dst = sys_AllocMemory( heapID, size );
	if( src != NULL && dst != NULL )
	{
		ArchiveDataLoadOfs( src, arcID, datID, param.offset, size );
		StrSet( dst, src, &param );
		sys_FreeMemoryEz( src );
	}
	return dst;
}
//------------------------------------------------------------------
/**
 * Ro[gĂ镶w̃[Jobt@ɃRs[
 *
 * @param   dst			Rs[obt@
 * @param   src			Rs[
 * @param   param		Rs[̃p[^
 *
 */
//------------------------------------------------------------------
static void StrSet( STRCODE* dst,  const STRCODE* src,  const MSG_PARAM_BLOCK* param )
{
	MI_CpuCopy16( src, dst, param->len*sizeof(STRCODE) );
}



void MSGDAT_GetStr( const MSGDATA_HEADER* msgdat, u32 strID, STRBUF* dst )
{
	if( strID < msgdat->numMsgs )
	{
		const MSG_PARAM_BLOCK* param;
		const STRCODE* str;

		param = &(msgdat->params[strID]);
		str = (STRCODE*)(((u8*)msgdat) + param->offset);
		STRBUF_SetStringCodeOrderLength( dst, str, param->len );
	}
	else
	{
		GF_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * [hbZ[Wf[^w蕶TCỸmہRs[
 *
 * @param   msgdat		bZ[Wf[^|C^
 * @param   strID		ID
 * @param   heapID		mۗp̃q[vID
 *
 * @retval  񂪃Rs[ꂽobt@^IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
STRBUF* MSGDAT_GetStrAlloc( const MSGDATA_HEADER* msgdat, u32 strID, u32 heapID )
{
	if( strID < msgdat->numMsgs )
	{
		const MSG_PARAM_BLOCK* param;
		const STRCODE* str;
		STRBUF *dst;

		param = &(msgdat->params[strID]);
		str = (STRCODE*)(((u8*)msgdat) + param->offset);
		dst = STRBUF_Create( param->len, heapID );
		if( dst )
		{
			STRBUF_SetStringCodeOrderLength( dst, str, param->len );
		}
		return dst;
	}
	else
	{
		GF_ASSERT(0);
	}
	return NULL;
}
//------------------------------------------------------------------
/**
 * w蕶݂̂[hwobt@ɃRs[
 *
 * @param   arcID		A[JCut@Chc
 * @param   datID		A[JCut@C̃bZ[Wf[^hc
 * @param   msgID		bZ[Wf[^̕hc
 * @param   heapID		ꎞmۗp̃q[vhc
 * @param   dst			Rs[obt@
 *
 */
//------------------------------------------------------------------
void MSGDAT_GetStrDirect( u32 arcID, u32 datID, u32 strID, u32 heapID, STRBUF* dst )
{
	MSG_PARAM_BLOCK  param;
	STRCODE*  str;
	u32 offs, size;

	offs = sizeof(u32) + sizeof(MSG_PARAM_BLOCK) * strID;
	ArchiveDataLoadOfs( &param, arcID, datID, offs, sizeof(MSG_PARAM_BLOCK) );

	size = param.len * sizeof(STRCODE);
	str = sys_AllocMemory( heapID, size );
	if( str )
	{
		ArchiveDataLoadOfs( str, arcID, datID, param.offset, size );
		STRBUF_SetStringCodeOrderLength( dst, str, param.len );
		sys_FreeMemoryEz( str );
	}
}
//------------------------------------------------------------------
/**
 * w蕶݂̂[hAŃAP[gɃRs[ĕԂ
 *
 * @param   arcID		A[JCut@Chc
 * @param   datID		A[JCut@C̃bZ[Wf[^hc
 * @param   msgID		bZ[Wf[^̕hc
 * @param   heapID		ꎞmۗp̃q[vhc
 *
 * @retval  񂪃Rs[ꂽobt@^IuWFNgւ̃|C^
 */
//------------------------------------------------------------------
STRBUF* MSGDAT_GetStrDirectAlloc( u32 arcID, u32 datID, u32 strID, u32 heapID )
{
	MSG_PARAM_BLOCK  param;
	STRCODE*  str;
	STRBUF*   dst;
	u32 offs, size;

	offs = sizeof(u32) + sizeof(MSG_PARAM_BLOCK) * strID;
	ArchiveDataLoadOfs( &param, arcID, datID, offs, sizeof(MSG_PARAM_BLOCK) );

	size = param.len * sizeof(STRCODE);
	str = sys_AllocMemoryLo( heapID, size );
	dst = STRBUF_Create( param.len, heapID );
	if( str != NULL && dst != NULL )
	{
		ArchiveDataLoadOfs( str, arcID, datID, param.offset, size );
		STRBUF_SetStringCodeOrderLength( dst, str, param.len );
		sys_FreeMemoryEz( str );
	}
	return dst;
}


/*============================================================================================*/
/*                                                                                            */
/*  bZ[Wf[^}l[W                                                                */
/*                                                                                            */
/*============================================================================================*/


//----------------------------------------------------
/**
 *  }l[W[N\
 */
//----------------------------------------------------
struct _MSGDATA_MANAGER {

	u16		type;
	u16		heapID;
	u16		arcID;
	u16		datID;

	MSGDATA_HEADER*  msgData;
};



//------------------------------------------------------------------
/**
 * bZ[Wf[^}l[W쐬
 *
 * @param   type		}l[W^Cvw
 * @param   arcID		bZ[Wf[^̊܂܂A[JCuhc
 * @param   datID		bZ[Wf[^{̂̃A[JCuhc
 * @param   heapID		mۗpq[vhc
 *
 * @retval  MSGDATA_MANAGER*		쐬}l[W[N|C^
 */
//------------------------------------------------------------------
MSGDATA_MANAGER*  MSGMAN_Create( MSGMAN_TYPE type, u32 arcID, u32 datID, u32 heapID )
{
	// }l[W쐬擾}l[Wpc̗ꂪv葽Ȃ̂
	// }l[W[N̓ubŇ擾
	MSGDATA_MANAGER* man = sys_AllocMemoryLo( heapID, sizeof(MSGDATA_MANAGER) );
	if( man )
	{
		if( type == MSGMAN_TYPE_NORMAL )
		{
			man->msgData = MSGDAT_Load( arcID, datID, heapID );
			if( man->msgData == NULL )
			{
				sys_FreeMemoryEz( man );
				return NULL;
			}
		}
		else
		{
			man->msgData = NULL;
		}
		man->type = type;
		man->arcID = arcID;
		man->datID = datID;
		man->heapID = heapID;
	}
	return man;
}
//------------------------------------------------------------------
/**
 * bZ[Wf[^}l[W̔j
 *
 * @param   man		}l[W[N|C^
 *
 */
//------------------------------------------------------------------
void MSGMAN_Delete( MSGDATA_MANAGER* man )
{
	if( man )
	{
		if( man->msgData )
		{
			MSGDAT_Unload( man->msgData );
		}
		sys_FreeMemoryEz( man );
	}
}
//------------------------------------------------------------------
/**
 * bZ[Wf[^}l[Wgĕwobt@ɃRs[
 * i̕zpBBj
 *
 * @param   man		}l[W[N|C^
 * @param   strID	hc
 * @param   dst		Rs[obt@
 *
 */
//------------------------------------------------------------------
void MSGMAN_GetStr( const MSGDATA_MANAGER* man, u32 strID, STRCODE* dst )
{
	switch( man->type ){
	case MSGMAN_TYPE_NORMAL:
		MSGDAT_Get( man->msgData, strID, dst );
		break;

	case MSGMAN_TYPE_DIRECT:
		MSGDAT_GetDirect( man->arcID, man->datID, strID, man->heapID, dst );
		break;
	}
}
//------------------------------------------------------------------
/**
 * bZ[Wf[^}l[Wgĕ擾
 *iŃAP[gɃRs[ĕԂB͊eŁBj
 *
 * @param   man		}l[W[N|C^
 * @param   strID	hc
 * @param   dst		Rs[obt@
 *
 * @retval  STRCODE*  񂪃Rs[Ă郁ubN
 *
 */
//------------------------------------------------------------------
STRCODE* MSGMAN_GetStrAlloc( const MSGDATA_MANAGER* man, u32 strID )
{
	switch( man->type ){
	case MSGMAN_TYPE_NORMAL:
		return MSGDAT_GetAlloc( man->msgData, strID, man->heapID );

	case MSGMAN_TYPE_DIRECT:
		return MSGDAT_GetDirectAlloc( man->arcID, man->datID, strID, man->heapID );
	}
	return NULL;
}

//------------------------------------------------------------------
/**
 * bZ[Wf[^}l[Wgĕwobt@ɃRs[
 *
 * @param   man			}l[W[N|C^
 * @param   strID		hc
 * @param   dst			Rs[obt@|C^
 *
 */
//------------------------------------------------------------------
void MSGMAN_GetString( const MSGDATA_MANAGER* man, u32 strID, STRBUF* dst )
{
	switch( man->type ){
	case MSGMAN_TYPE_NORMAL:
		MSGDAT_GetStr( man->msgData, strID, dst );
		break;

	case MSGMAN_TYPE_DIRECT:
		MSGDAT_GetStrDirect( man->arcID, man->datID, strID, man->heapID, dst );
		break;
	}
}

//------------------------------------------------------------------
/**
 * bZ[Wf[^}l[Wgĕ擾
 *iSTRBUF쐬ĕԂB쐬ꂽSTRBUF̔j͊eōsj
 *
 * @param   man			}l[W[N|C^
 * @param   strID		ID
 *
 * @retval  STRBUF*		Rs[obt@|C^
 */
//------------------------------------------------------------------
STRBUF* MSGMAN_AllocString( const MSGDATA_MANAGER* man, u32 strID )
{
	switch( man->type ){
	case MSGMAN_TYPE_NORMAL:
		return MSGDAT_GetStrAlloc( man->msgData, strID, man->heapID );

	case MSGMAN_TYPE_DIRECT:
		return MSGDAT_GetStrDirectAlloc( man->arcID, man->datID, strID, man->heapID );
	}
	return NULL;
}






/*-------------------------------------------------------------------*/
/** IIɂ̎̊֐ȏǉȂ悤ɂ肢܂II */
/*-------------------------------------------------------------------*/

//------------------------------------------------------------------
/**
 * |P擾
 *
 * @param   monsno		|Pio[
 * @param   heapID		ꎞmۗp̃q[vhc
 * @param   dst			Rs[obt@
 *
 */
//------------------------------------------------------------------
void MSGDAT_MonsNameGet( u32 monsno, u32 heapID, STRCODE* dst )
{
	MSGDATA_MANAGER* man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, heapID );
	MSGMAN_GetStr( man, MONSNAME_000+monsno, dst );
	MSGMAN_Delete( man );
}

/*-------------------------------------------------------------------*/
/** IIɂ̎̊֐ȏǉȂ悤ɂ肢܂II */
/*-------------------------------------------------------------------*/
