//============================================================================================
/**
 * @file	palanm.c
 * @brief	pbgtF[h
 * @author	Hiroyuki Nakamura
 * @date	2004.11.24
 */
//============================================================================================
#define	PALANM_H_GLOBAL

#include "common.h"
#include "tcb.h"

#include "system/palanm.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"


//============================================================================================
//	V{`
//============================================================================================
#define	DEF_FADE_VAL	( 2 )			// {x
// vZ
#define FADE_CHANGE( before, after, evy )					\
			( before + ( ( after - before ) * evy >> 4 ) )

///tF[hvZs[J^XNTCBvCIeB
///	KTCB̍ŌɎs悤ɃvCIeBɂĂ
#define TCBPRI_CALC_FADETASK		(0xffffffff - 1)


//==============================================================================
//	\̒`
//==============================================================================
/// pbgtF[hf[^
typedef struct _PALETTE_FADE_DATA{
	FADE_REQ_EX2	dat[ ALL_PALETTE_SIZE ];

	u16	req_flg:2;		// 0=o^, 1=쒆, 2=ꎞ~
	u16	req_bit:14;		// NGXgrbgiJ[vZpj
	u16	trans_bit:14;	// gXrbgiJ[]pj
	u16	tcb_flg:1;		// TCBo^tO@0=o^, 1=o^
	u16	auto_trans:1;			// gXrbgɊ֌WȂAt[Spbg]
}PALETTE_FADE_DATA;

/// J[pbg\
typedef struct {
    u16 Red:5;              // 
    u16 Green:5;            // 
    u16 Blue:5;             // 
    u16 Dummy_15:1;
} PLTT_DATA;

//============================================================================================
//	vg^Cv錾
//============================================================================================
static u8 ReqBitCheck( u16 flg, u16 req );
static void FadeBitCheck( FADEREQ req, FADE_REQ_EX2 * wk, u16 * fade_bit );
static void FadeReqSet(
				FADE_REQ_PARAM * wk, u16 fade_bit,
				s8 wait, u8 start_evy, u8 end_evy, u16 next_rgb );
static void PaletteFadeTask( TCB_PTR tcb, void * work );
static void NormalPaletteFade(PALETTE_FADE_PTR pfd);
static void ExtraPaletteFade(PALETTE_FADE_PTR pfd);
static void FadeWorkSet( u16 * def, u16 * trans, FADE_REQ_PARAM * wk, u32 siz );
static void FadeParamCheck(PALETTE_FADE_PTR pfd, u8 id, FADE_REQ_PARAM * wk );



//--------------------------------------------------------------
/**
 * @brief   pbgtF[hVXe[N쐬
 *
 * @param   heap_id		q[vID
 *
 * @retval  쐬pbgtF[hVXe[Ñ|C^
 *
 * VXegȂȂPaletteFadeFreeŉsĂ
 */
//--------------------------------------------------------------
PALETTE_FADE_PTR PaletteFadeInit(int heap_id)
{
	PALETTE_FADE_PTR pfd;
	
	pfd = sys_AllocMemory(heap_id, sizeof(PALETTE_FADE_DATA));
	MI_CpuClear8(pfd, sizeof(PALETTE_FADE_DATA));
	return pfd;
}

//--------------------------------------------------------------
/**
 * @brief   pbgtF[hVXe
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void PaletteFadeFree(PALETTE_FADE_PTR pfd)
{
	sys_FreeMemoryEz(pfd);
}

//--------------------------------------------------------------------------------------------
/**
 * NGXgf[^Zbg
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	req			NGXgf[^ԍ
 * @param	def_wk		f[^
 * @param	trans_wk	]pf[^
 * @param	siz			TCYioCgPʁj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaletteFadeWorkAdrSet(PALETTE_FADE_PTR pfd, FADEREQ req, void * def_wk, void * trans_wk, u32 siz )
{
	pfd->dat[req].def_wk   = (u16 *)def_wk;
	pfd->dat[req].trans_wk = (u16 *)trans_wk;
	pfd->dat[req].siz      = siz;
}

//--------------------------------------------------------------------------------------------
/**
 * NGXgf[^mallocăZbg
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	req		NGXgf[^ԍ
 * @param	siz		f[^TCYioCgPʁj
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaletteFadeWorkAllocSet(PALETTE_FADE_PTR pfd, FADEREQ req, u32 siz, u32 heap )
{
	void * def_wk;
	void * trans_wk;

	def_wk   = sys_AllocMemory( heap, siz );
	trans_wk = sys_AllocMemory( heap, siz );

#ifdef	OSP_ERR_PALANMWK_GET	// pbgtF[h̃[N擾s
	if( def_wk == NULL ){
		OS_Printf( "ERROR : PaletteFadeWorkAlloc ( %d ) - def_wk\n", req );
	}
	if( trans_wk == NULL ){
		OS_Printf( "ERROR : PaletteFadeWorkAlloc ( %d ) - trans_wk\n", req );
	}
#endif	// OSP_ERR_PALANMWK_GET

	PaletteFadeWorkAdrSet(pfd, req, def_wk, trans_wk, siz );
}

//--------------------------------------------------------------------------------------------
/**
 * NGXgf[^J
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	req		NGXgf[^ԍ
 *
 * @return	none
 *
 * @li	PaletteFadeWorkAllocSet()Ŏ擾ꍇɎgp
 */
//--------------------------------------------------------------------------------------------
void PaletteFadeWorkAllocFree(PALETTE_FADE_PTR pfd, FADEREQ req)
{
	sys_FreeMemoryEz(pfd->dat[req].def_wk );
	sys_FreeMemoryEz(pfd->dat[req].trans_wk );
}

//--------------------------------------------------------------------------------------------
/**
 * pbg̏f[^Zbg
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	dat		pbgf[^
 * @param	req		NGXgf[^ԍ
 * @param	pos		Jnʒu
 * @param	siz		f[^TCY
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaletteWorkSet(PALETTE_FADE_PTR pfd, const void * dat, FADEREQ req, u16 pos, u16 siz )
{
#ifdef	OSP_ERR_PALANM_SIZ_OVER		// TCYI[o[
	if( (pos*2+siz) > pfd->dat[req].siz ){
		OS_Printf( "ERROR : PaletteWorkSet - SizeOver ( %d )\n", req );
	}
#endif	// OSP_ERR_PALANM_SIZ_OVER
	MI_CpuCopy16( dat, (void *)&pfd->dat[req].def_wk[pos], (u32)siz );
	MI_CpuCopy16( dat, (void *)&pfd->dat[req].trans_wk[pos], (u32)siz );
}

//--------------------------------------------------------------
/**
 * @brief   A[JCuĂpbgf[^[hă[NɓWJ܂
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param   fileIdx			A[JCut@CCfbNX
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   heap			f[^ǂݍ݃e|ƂĎgq[vID
 * @param   req				NGXgf[^ԍ
 * @param   trans_size		]TCY(oCgPʁ@2oCgACgĂ邱)
 * @param   pos				pbg]Jnʒu(J[P)
 */
//--------------------------------------------------------------
void PaletteWorkSet_Arc(PALETTE_FADE_PTR pfd, u32 fileIdx, u32 dataIdx, u32 heap, 
	FADEREQ req, u32 trans_size, u16 pos)
{
	NNSG2dPaletteData *pal_data;
	void *arc_data;
	
	arc_data = ArcUtil_PalDataGet(fileIdx, dataIdx, &pal_data, heap);
	GF_ASSERT(arc_data != NULL);
	
	if(trans_size == 0){
		trans_size = pal_data->szByte;
	}
	
	GF_ASSERT(pos * sizeof(pos) + trans_size <= pfd->dat[req].siz);
	PaletteWorkSet(pfd, pal_data->pRawData, req, pos, trans_size);
	
	sys_FreeMemoryEz(arc_data);
}

//--------------------------------------------------------------
/**
 * @brief   pbgVRAM烏[Nփf[^Rs[܂
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param   req				NGXgf[^ԍ
 * @param   pos				pbg]Jnʒu(J[P)
 * @param   trans_size		]TCY(oCgPʁ@2oCgACgĂ邱)
 *
 * gpbgɂ͖Ήł
 */
//--------------------------------------------------------------
void PaletteWorkSet_VramCopy(PALETTE_FADE_PTR pfd, FADEREQ req, u16 pos, u32 trans_size)
{
	u16 *pltt_vram;
	
	GF_ASSERT(pos * sizeof(pos) + trans_size <= pfd->dat[req].siz);

	switch(req){
	case FADE_MAIN_BG:
		pltt_vram = (u16 *)GF_MMAP_MainBgPlttAddr();
		break;
	case FADE_SUB_BG:
		pltt_vram = (u16 *)GF_MMAP_SubBgPlttAddr();
		break;
	case FADE_MAIN_OBJ:
		pltt_vram = (u16 *)GF_MMAP_MainObjPlttAddr();
		break;
	case FADE_SUB_OBJ:
		pltt_vram = (u16 *)GF_MMAP_SubObjPlttAddr();
		break;
	default:
		GF_ASSERT(0 && "Ή̃NGXgł");
		return;
	}
	
	PaletteWorkSet(pfd, &pltt_vram[pos], req, pos, trans_size);
}

//--------------------------------------------------------------
/**
 * @brief   gpbgVRAM烏[Nփf[^Rs[܂
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param   req				NGXgf[^ԍ
 * @param   trans_size		]TCY(oCgPʁ@2oCgACgĂ邱)
 * @param   pos				pbg]Jnʒu(J[P)
 *
 * CpbgPaletteWorkSet_VramCopygpĂ
 */
//--------------------------------------------------------------
void PaletteWorkSet_VramCopyEx(PALETTE_FADE_PTR pfd, FADEREQ req, u32 trans_size, u16 pos)
{
	GF_ASSERT(0 && "ݖ쐬ł");
}

//--------------------------------------------------------------------------------------------
/**
 * pbg[NԃRs[
 *
 * @param   pfd				pbgtF[hVXe[Nւ̃|C^
 * @param	src_req			Rs[NGXgf[^ԍ
 * @param	src_pos			Rs[Jnʒu(J[P)
 * @param	dest_req		Rs[惊NGXgf[^ԍ
 * @param	dest_pos		Rs[Jnʒu(J[P)
 * @param	siz				Rs[f[^TCY(oCgP)
 *
 * Rs[͌f[^ǂݎARs[͌f[^A]A̗ɃRs[s܂
 */
//--------------------------------------------------------------------------------------------
void PaletteWorkCopy(PALETTE_FADE_PTR pfd, FADEREQ src_req, u16 src_pos, 
	FADEREQ dest_req, u16 dest_pos, u16 siz )
{
	MI_CpuCopy16((void *)&pfd->dat[src_req].def_wk[src_pos], 
		(void *)&pfd->dat[dest_req].def_wk[dest_pos], siz);
	MI_CpuCopy16((void *)&pfd->dat[src_req].def_wk[src_pos], 
		(void *)&pfd->dat[dest_req].trans_wk[dest_pos], siz);
}

//--------------------------------------------------------------------------------------------
/**
 * pbg[NɃZbgĂpbgf[^擾
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	tpye	擾pbg̎
 *
 * @return	ZbgĂpbgf[^
 */
//--------------------------------------------------------------------------------------------
u16 * PaletteWorkDefaultWorkGet( PALETTE_FADE_PTR pfd, u32 type )
{
	return pfd->dat[type].def_wk;
}

//--------------------------------------------------------------------------------------------
/**
 * pbgtF[hNGXgi㏑sj
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	req_bit		pbg̎ށirbgwj
 * @param	fade_bit	pbgwirbgwjbit0 = pal0
 * @param	wait		vZ҂ԁi}CiXj
 * @param	start_evy	Zx
 * @param	end_evy		ŏIZx
 * @param	next_rgb	ύX̐F
 *
 * @retval	"0 = "
 * @retval	"1 = G["
 *
 * @li	ZxF0 ` 16 ( 0(̐F) ` 2,3..(ԐF) ` 16(w肵F) )
 */
//--------------------------------------------------------------------------------------------
u8 PaletteFadeReq(PALETTE_FADE_PTR pfd, u16 req_bit, u16 fade_bit, s8 wait, 
	u8 start_evy, u8 end_evy, u16 next_rgb )
{
	u16	cpy_bit;
	u8	tmp;
	u8	i;

	cpy_bit = fade_bit;
	tmp = 0;
	for( i=0; i<ALL_PALETTE_SIZE; i++ ){
		if( ReqBitCheck( req_bit, i ) == TRUE &&
			ReqBitCheck( pfd->req_bit, i ) == FALSE ){

			FadeBitCheck( i, &pfd->dat[i], &fade_bit );
			FadeReqSet( &pfd->dat[i].prm, fade_bit, wait, start_evy, end_evy, next_rgb );
			fade_bit = cpy_bit;
			tmp = 1;
		}
	}

	if( tmp == 1 ){
		pfd->req_bit |= req_bit;
		if( pfd->tcb_flg == 0 ){
			pfd->tcb_flg = 1;
			pfd->req_flg = 1;
			TCB_Add( PaletteFadeTask, pfd, TCBPRI_CALC_FADETASK );
		}
	}

	return tmp;
}

//--------------------------------------------------------------------------------------------
/**
 * pbgtF[hNGXgi㏑j
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	req_bit		pbg̎ށirbgwj
 * @param	fade_bit	pbgwirbgwjbit0 = pal0
 * @param	wait		vZ҂ԁi}CiXj
 * @param	start_evy	Zx
 * @param	end_evy		ŏIZx
 * @param	next_rgb	ύX̐F
 *
 * @retval	"0 = "
 * @retval	"1 = G["
 *
 * @li	ZxF0 ` 16 ( 0(̐F) ` 2,3..(ԐF) ` 16(w肵F) )
 */
//--------------------------------------------------------------------------------------------
u8 PaletteFadeReqWrite(PALETTE_FADE_PTR pfd, u16 req_bit, u16 fade_bit, s8 wait, 
	u8 start_evy, u8 end_evy, u16 next_rgb )
{
	u16	cpy_bit;
	u8	tmp;
	u8	i;

	cpy_bit = fade_bit;
	tmp = 0;
	for( i=0; i<ALL_PALETTE_SIZE; i++ ){
		if( ReqBitCheck( req_bit, i ) == TRUE ){
			FadeBitCheck( i, &pfd->dat[i], &fade_bit );
			FadeReqSet( &pfd->dat[i].prm, fade_bit, wait, start_evy, end_evy, next_rgb );
			fade_bit = cpy_bit;
			tmp = 1;
		}
	}

	if( tmp == 1 ){
//		pfd->req_bit |= req_bit;
		pfd->req_bit = req_bit;
		if( pfd->tcb_flg == 0 ){
			pfd->tcb_flg = 1;
			pfd->req_flg = 1;
			TCB_Add( PaletteFadeTask, pfd, TCBPRI_CALC_FADETASK );
		}
	}

	return tmp;
}

//--------------------------------------------------------------------------------------------
/**
 * NGXg̏Ԃ𒲂ׂ
 *
 * @param	flg		
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static u8 ReqBitCheck( u16 flg, u16 req )
{
	if( ( flg & ( 1 << req ) ) != 0 ){
		return TRUE;
	}
	return FALSE;
}


//--------------------------------------------------------------------------------------------
/**
 * tF[hrbg`FbN
 *
 * @param	req			NGXgf[^ԍ
 * @param	wk			NGXgf[^
 * @param	fade_bit	pbgwirbgwjbit0 = pal0
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FadeBitCheck( FADEREQ req, FADE_REQ_EX2 * wk, u16 * fade_bit )
{
	u16	siz_bit;
	u8	i, j;

	if( req < NORMAL_PALETTE_SIZE ){
		j = wk->siz / 32;
	}else{
		j = wk->siz / 512;
	}

	siz_bit = 0;
	for( i=0; i<j; i++ ){
		siz_bit += ( 1 << i );
	}

	*fade_bit &= siz_bit;
}

//--------------------------------------------------------------------------------------------
/**
 * p[^Zbg
 *
 * @param	wk			f[^
 * @param	fade_bit	pbgwirbgwjbit0 = pal0
 * @param	wait		vZ҂ԁi}CiXj
 * @param	start_evy	Zx
 * @param	end_evy		ŏIZx
 * @param	next_rgb	ύX̐F
 *
 * @return	none
 *
 * @li	ZxF0 ` 16 ( 0(̐F) ` 2,3..(ԐF) ` 16(w肵F) )
 */
//--------------------------------------------------------------------------------------------
static void FadeReqSet(
				FADE_REQ_PARAM * wk, u16 fade_bit,
				s8 wait, u8 start_evy, u8 end_evy, u16 next_rgb )
{
	// waitϲŽ̎value傫̪ނ𑁂
	if( wait < 0 ){
		wk->fade_value = DEF_FADE_VAL + abs( wait );
		wk->wait = 0;
	}else{
		wk->fade_value = DEF_FADE_VAL;
		wk->wait = wait;
	}

	wk->fade_bit = fade_bit;
	wk->now_evy  = start_evy;
	wk->end_evy  = end_evy;
	wk->next_rgb = next_rgb;
	wk->wait_cnt = wk->wait;

	if( start_evy < end_evy ){
		wk->direction = 0;
	}else{
		wk->direction = 1;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * pbgtF[hC^XN
 *
 * @param	tcb		TCB̃|C^
 * @param	work	TCB[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void PaletteFadeTask( TCB_PTR tcb, void * work )
{
	PALETTE_FADE_PTR pfd = work;
	
	if( pfd->req_flg != 1 ){ return; }

	pfd->trans_bit = pfd->req_bit;

	NormalPaletteFade(pfd);
	ExtraPaletteFade(pfd);

	if( pfd->req_bit == 0 ){
		pfd->tcb_flg = 0;
		TCB_Delete( tcb );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ʏpbg̃tF[hvZ
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void NormalPaletteFade(PALETTE_FADE_PTR pfd)
{
	u8	i, j;

	for( i=0; i<NORMAL_PALETTE_SIZE; i++ ){
		if( ReqBitCheck( pfd->req_bit, i ) == FALSE ){
			continue;
		}

		if( pfd->dat[i].prm.wait_cnt < pfd->dat[i].prm.wait ){
			pfd->dat[i].prm.wait_cnt++;
			continue;
		}else{
			pfd->dat[i].prm.wait_cnt = 0;
		}

		for( j=0; j<16; j++ ){
			if( ReqBitCheck( pfd->dat[i].prm.fade_bit, j ) == FALSE ){
				continue;
			}
			FadeWorkSet(
				&pfd->dat[i].def_wk[j<<4],
				&pfd->dat[i].trans_wk[j<<4],
				&pfd->dat[i].prm, 16 );
		}

		FadeParamCheck(pfd, i, &pfd->dat[i].prm );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * gpbg̃tF[hvZ
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ExtraPaletteFade(PALETTE_FADE_PTR pfd)
{
	u8	i, j;

	for( i=NORMAL_PALETTE_SIZE; i<ALL_PALETTE_SIZE; i++ ){
		if( ReqBitCheck( pfd->req_bit, i ) == FALSE ){
			continue;
		}

		if( pfd->dat[i].prm.wait_cnt < pfd->dat[i].prm.wait ){
			pfd->dat[i].prm.wait_cnt++;
			continue;
		}else{
			pfd->dat[i].prm.wait_cnt = 0;
		}

		for( j=0; j<16; j++ ){
			if( ReqBitCheck( pfd->dat[i].prm.fade_bit, j ) == FALSE ){
				continue;
			}
			FadeWorkSet(
				&pfd->dat[i].def_wk[j<<8],
				&pfd->dat[i].trans_wk[j<<8],
				&pfd->dat[i].prm, 256 );
		}

		FadeParamCheck(pfd, i, &pfd->dat[i].prm );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * J[vZ
 *
 * @param	def		pbgf[^
 * @param	trans	vZ̃pbgf[^
 * @param	wk		tF[hp[^
 * @param	siz		vZTCY
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FadeWorkSet( u16 * def, u16 * trans, FADE_REQ_PARAM * wk, u32 siz )
{
	u32	i;
	u8	red, green, blue;

	for( i=0; i<siz; i++ ){
		red   =
			FADE_CHANGE( (def[i]&0x1f), (wk->next_rgb&0x1f), wk->now_evy );
		green =
			FADE_CHANGE( ((def[i]>>5)&0x1f), ((wk->next_rgb>>5)&0x1f), wk->now_evy );
		blue  =
			FADE_CHANGE( ((def[i]>>10)&0x1f), ((wk->next_rgb>>10)&0x1f), wk->now_evy );

		trans[i] = ( blue << 10 ) | ( green << 5 ) | red;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * tF[h̐is󋵂Ď
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 * @param	id		tF[hf[^ԍ
 * @param	wk		tF[hp[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FadeParamCheck(PALETTE_FADE_PTR pfd, u8 id, FADE_REQ_PARAM * wk )
{
	s16	tmp;

	if( wk->now_evy == wk->end_evy ){
		pfd->req_bit ^= ( 1 << id );
	}else if( wk->direction == 0 ){
		tmp = wk->now_evy;
		tmp += wk->fade_value;
		if( tmp > wk->end_evy ){
			tmp = wk->end_evy;
		}
		wk->now_evy = tmp;
	}else{
		tmp = wk->now_evy;
		tmp -= wk->fade_value;
		if( tmp < wk->end_evy ){
			tmp = wk->end_evy;
		}
		wk->now_evy = tmp;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * pbg]
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 *
 * @return	none
 *
 * @li	VBlankŌĂԂ
 */
//--------------------------------------------------------------------------------------------
void PaletteFadeTrans(PALETTE_FADE_PTR pfd)
{
	if( pfd->auto_trans == FALSE && pfd->req_flg != 1 ){ return; }

	{
		int	i;

		for( i=0; i<ALL_PALETTE_SIZE; i++ ){
			if(pfd->auto_trans == FALSE){
				if(pfd->dat[i].trans_wk == NULL || ReqBitCheck( pfd->trans_bit, i ) == FALSE){
					continue;
				}
			}

			DC_FlushRange( (void*)pfd->dat[i].trans_wk, pfd->dat[i].siz );
			switch( i ){
			case FADE_MAIN_BG:
				GX_LoadBGPltt(
					(const void *)pfd->dat[i].trans_wk, 0, pfd->dat[i].siz );
				break;
			case FADE_SUB_BG:
				GXS_LoadBGPltt(
					(const void *)pfd->dat[i].trans_wk, 0, pfd->dat[i].siz );
				break;
			case FADE_MAIN_OBJ:
				GX_LoadOBJPltt(
					(const void *)pfd->dat[i].trans_wk, 0, pfd->dat[i].siz );
				break;
			case FADE_SUB_OBJ:
				GXS_LoadOBJPltt(
					(const void *)pfd->dat[i].trans_wk, 0, pfd->dat[i].siz );
				break;
			case FADE_MAIN_BG_EX0:
				GX_BeginLoadBGExtPltt();
				GX_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT0_ADRS, pfd->dat[i].siz );
				GX_EndLoadBGExtPltt();
				break;
			case FADE_MAIN_BG_EX1:
				GX_BeginLoadBGExtPltt();
				GX_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT1_ADRS, pfd->dat[i].siz );
				GX_EndLoadBGExtPltt();
				break;
			case FADE_MAIN_BG_EX2:
				GX_BeginLoadBGExtPltt();
				GX_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT2_ADRS, pfd->dat[i].siz );
				GX_EndLoadBGExtPltt();
				break;
			case FADE_MAIN_BG_EX3:
				GX_BeginLoadBGExtPltt();
				GX_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT3_ADRS, pfd->dat[i].siz );
				GX_EndLoadBGExtPltt();
				break;
			case FADE_SUB_BG_EX0:
				GXS_BeginLoadBGExtPltt();
				GXS_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT0_ADRS, pfd->dat[i].siz );
				GXS_EndLoadBGExtPltt();
				break;
			case FADE_SUB_BG_EX1:
				GXS_BeginLoadBGExtPltt();
				GXS_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT1_ADRS, pfd->dat[i].siz );
				GXS_EndLoadBGExtPltt();
				break;
			case FADE_SUB_BG_EX2:
				GXS_BeginLoadBGExtPltt();
				GXS_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT2_ADRS, pfd->dat[i].siz );
				GXS_EndLoadBGExtPltt();
				break;
			case FADE_SUB_BG_EX3:
				GXS_BeginLoadBGExtPltt();
				GXS_LoadBGExtPltt(
					(const void *)pfd->dat[i].trans_wk,
					EX_PAL_SLOT3_ADRS, pfd->dat[i].siz );
				GXS_EndLoadBGExtPltt();
				break;
			case FADE_MAIN_OBJ_EX:
				GX_BeginLoadOBJExtPltt();
				GX_LoadOBJExtPltt(
					(const void *)pfd->dat[i].trans_wk, 0, pfd->dat[i].siz );
				GX_EndLoadOBJExtPltt();
				break;
			case FADE_SUB_OBJ_EX:
				GXS_BeginLoadOBJExtPltt();
				GXS_LoadOBJExtPltt(
					(const void *)pfd->dat[i].trans_wk, 0, pfd->dat[i].siz );
				GXS_EndLoadOBJExtPltt();
			}
		}
	}

	pfd->trans_bit = pfd->req_bit;
	if( pfd->trans_bit == 0 ){
		pfd->req_flg = 0;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * I`FbN
 *
 * @param   pfd		pbgtF[hVXe[Nւ̃|C^
 *
 * @retval	"0 = I"
 * @retval	"0 != "
 */
//--------------------------------------------------------------------------------------------
u16 PaletteFadeCheck(PALETTE_FADE_PTR pfd)
{
	return pfd->req_bit;
}

//--------------------------------------------------------------
/**
 * @brief   ]tOZbg
 *
 * @param   pfd			pbgtF[hVXe[Nւ̃|C^
 * @param   on_off		TRUE:]ONB@FALSE:]OFF
 */
//--------------------------------------------------------------
void PaletteTrans_AutoSet(PALETTE_FADE_PTR pfd, int on_off)
{
	pfd->auto_trans = on_off;
}


void PaletteTransSwitch(PALETTE_FADE_PTR pfd, u8 flag)
{
	pfd->req_flg = flag & 0x01;
	pfd->req_bit = 0xFFFFFFFF;
}



//--------------------------------------------------------------------------------------------
/**
 * wpbgŜNA
 *
 * @param	bit		NApbg
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PaletteAreaClear( u16 bit, u32 heap )
{
	void * buf;

	buf = (u8 *)sys_AllocMemory( heap, FADE_PAL_ALL_SIZE );
	memset( buf, 0, FADE_PAL_ALL_SIZE );
	DC_FlushRange( (void*)buf, FADE_PAL_ALL_SIZE );

	if( bit & PF_BIT_MAIN_BG ){
		GX_LoadBGPltt( (const void *)buf, 0, FADE_PAL_ALL_SIZE );
	}
	if( bit & PF_BIT_SUB_BG ){
		GXS_LoadBGPltt( (const void *)buf, 0, FADE_PAL_ALL_SIZE );
	}
	if( bit & PF_BIT_MAIN_OBJ ){
		GX_LoadOBJPltt( (const void *)buf, 0, FADE_PAL_ALL_SIZE );
	}
	if( bit & PF_BIT_SUB_OBJ ){
		GXS_LoadOBJPltt( (const void *)buf, 0, FADE_PAL_ALL_SIZE );
	}

	sys_FreeMemory( heap, buf );

	buf = (u8 *)sys_AllocMemory( heap, FADE_EXPAL_ALL_SIZE );
	memset( buf, 0, FADE_EXPAL_ALL_SIZE );
	DC_FlushRange( (void*)buf, FADE_EXPAL_ALL_SIZE );

	if( bit & PF_BIT_MAIN_BG_EX0 ){
		GX_BeginLoadBGExtPltt();
		GX_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT0_ADRS, FADE_EXPAL_ALL_SIZE );
		GX_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_MAIN_BG_EX1 ){
		GX_BeginLoadBGExtPltt();
		GX_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT1_ADRS, FADE_EXPAL_ALL_SIZE );
		GX_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_MAIN_BG_EX2 ){
		GX_BeginLoadBGExtPltt();
		GX_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT2_ADRS, FADE_EXPAL_ALL_SIZE );
		GX_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_MAIN_BG_EX3 ){
		GX_BeginLoadBGExtPltt();
		GX_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT3_ADRS, FADE_EXPAL_ALL_SIZE );
		GX_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_SUB_BG_EX0 ){
		GXS_BeginLoadBGExtPltt();
		GXS_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT0_ADRS, FADE_EXPAL_ALL_SIZE );
		GXS_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_SUB_BG_EX1 ){
		GXS_BeginLoadBGExtPltt();
		GXS_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT1_ADRS, FADE_EXPAL_ALL_SIZE );
		GXS_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_SUB_BG_EX2 ){
		GXS_BeginLoadBGExtPltt();
		GXS_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT2_ADRS, FADE_EXPAL_ALL_SIZE );
		GXS_EndLoadBGExtPltt();
	}
	if( bit & PF_BIT_SUB_BG_EX3 ){
		GXS_BeginLoadBGExtPltt();
		GXS_LoadBGExtPltt( (const void *)buf, EX_PAL_SLOT3_ADRS, FADE_EXPAL_ALL_SIZE );
		GXS_EndLoadBGExtPltt();
	}

	if( bit & PF_BIT_MAIN_OBJ_EX ){
		GX_BeginLoadOBJExtPltt();
		GX_LoadOBJExtPltt( (const void *)buf, 0, FADE_EXPAL_ALL_SIZE );
		GX_EndLoadOBJExtPltt();
	}

	if( bit & PF_BIT_SUB_OBJ_EX ){
		GXS_BeginLoadOBJExtPltt();
		GXS_LoadOBJExtPltt( (const void *)buf, 0, FADE_EXPAL_ALL_SIZE );
		GXS_EndLoadOBJExtPltt();
	}

	sys_FreeMemory( heap, buf );
}

//--------------------------------------------------------------
/**
 * @brief   pbg[NwR[hŃNA
 *
 * @param   pfd				pbgtF[hVXeւ̃|C^
 * @param   req				NGXgf[^ԍ
 * @param   select			obt@w
 * @param   clear_code		NAR[h
 * @param   start			Jnʒu(J[ʒu)
 * @param   end				Iʒu(J[ʒu)
 */
//--------------------------------------------------------------
void PaletteWork_Clear(PALETTE_FADE_PTR pfd, FADEREQ req, FADEBUF select, 
	u16 clear_code, u16 start, u16 end)
{
	if(select == FADEBUF_SRC || select == FADEBUF_ALL){
		MI_CpuFill16(&pfd->dat[req].def_wk[start], clear_code, (end - start) * 2);
	}
	if(select == FADEBUF_TRANS || select == FADEBUF_ALL){
		MI_CpuFill16(&pfd->dat[req].trans_wk[start], clear_code, (end - start) * 2);
	}
}

//--------------------------------------------------------------
/**
 * @brief   wʒũJ[f[^pbg[N擾
 *
 * @param   pfd				pbgtF[hVXeւ̃|C^
 * @param   req				NGXgf[^ԍ
 * @param   select			obt@w
 * @param   color_pos		擾J[̈ʒu
 *
 * @retval  J[f[^
 */
//--------------------------------------------------------------
u16 PaletteWork_ColorGet(PALETTE_FADE_PTR pfd, FADEREQ req, FADEBUF select, u16 color_pos)
{
	if(select == FADEBUF_SRC){
		return pfd->dat[req].def_wk[color_pos];
	}
	if(select == FADEBUF_TRANS){
		return pfd->dat[req].trans_wk[color_pos];
	}

	GF_ASSERT(0 && "obt@w肪ԈĂ܂\n");
}




//==============================================================================
//	ʃc[
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   \tgtF[hCAAEg
 *
 * @param   src			pbgf[^ւ̃|C^
 * @param   dest		ύXf[^
 * @param   col_num		ύXJ[
 * @param   evy			W(0`16) (ύX̓xA0(̐F)`2,3..(ԐF)`16(w肵F)
 * @param   next_rgb	ύX̐Fw
 */
//--------------------------------------------------------------
void SoftFade(const u16 *src, u16 *dest, u16 col_num, u8 evy, u16 next_rgb)
{
	u16 i;
	int red, green, blue;
	int next_red, next_green, next_blue;
	
	next_red = ((PLTT_DATA*)&next_rgb)->Red;
	next_green = ((PLTT_DATA*)&next_rgb)->Green;
	next_blue = ((PLTT_DATA*)&next_rgb)->Blue;
	
	for(i = 0; i < col_num; i++){
		red = ((PLTT_DATA*)&src[i])->Red;
		green = ((PLTT_DATA*)&src[i])->Green;
		blue = ((PLTT_DATA*)&src[i])->Blue;
	
		dest[i] = 
			FADE_CHANGE(red, next_red, evy) |
			(FADE_CHANGE(green, next_green, evy) << 5) |
			(FADE_CHANGE(blue, next_blue, evy) << 10);
	}
}

//--------------------------------------------------------------
/**
 * @brief   PFDƂJ[Z
 *
 * @param   pfd				pbgtF[hVXeւ̃|C^
 * @param   req				NGXgf[^ԍ
 * @param   start_pos		\tgtF[hJnʒu(J[P)
 * @param   col_num			start_pos牽̃J[ZΏۂƂ邩(J[P)
 * @param   evy				EVYl
 * @param   next_rgb		ύX̐F
 */
//--------------------------------------------------------------
void SoftFadePfd(PALETTE_FADE_PTR pfd, FADEREQ req, u16 start_pos, u16 col_num, 
	u8 evy, u16 next_rgb)
{
	GF_ASSERT(pfd->dat[req].def_wk != NULL && pfd->dat[req].trans_wk != NULL);
	
	SoftFade(&pfd->dat[req].def_wk[start_pos], &pfd->dat[req].trans_wk[start_pos], 
		col_num, evy, next_rgb);
}

//--------------------------------------------------------------
/**
 * @brief   PFDƂJ[Z(rbgwFpbgP)
 *
 * @param   pfd				pbgtF[hVXeւ̃|C^
 * @param   req				NGXgf[^ԍ
 * @param   fade_bit		ZΏۂ̃rbg
 * @param   evy				EVYl
 * @param   next_rgb		ύX̐F
 */
//--------------------------------------------------------------
void ColorConceChangePfd(PALETTE_FADE_PTR pfd, FADEREQ req, u16 fade_bit, u8 evy, u16 next_rgb)
{
	int i;
	int offset = 0;
	
	GF_ASSERT(pfd->dat[req].def_wk != NULL && pfd->dat[req].trans_wk != NULL);
	
	while(fade_bit){
		if(fade_bit & 1){
			SoftFadePfd(pfd, req, offset, 16, evy, next_rgb);
		}
		fade_bit >>= 1;
		offset += 16;
	}
}

// =============================================================================
//
//
//	J[֐S  add goto
//
//
// =============================================================================
#define RGBtoY(r,g,b)	(((r)*76 + (g)*151 + (b)*29) >> 8)
#define COL_FIL(c, p)	((u16)((p)*(c))>>8)

//--------------------------------------------------------------
/**
 * @brief	O[XP[
 *
 * @param	pal				ύXΏۃpbgf[^
 * @param	pal_size		ύXTCY(FύX邩)
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void PaletteGrayScale(u16* pal, int pal_size)
{
	int i, r, g, b;
	u32 c;

	for(i = 0; i < pal_size; i++){
		r = ((*pal) & 0x1f);
		g = (((*pal) >> 5) & 0x1f);
		b = (((*pal) >> 10) & 0x1f);

		c = RGBtoY(r,g,b);

		*pal = (u16)((c<<10)|(c<<5)|c);
		pal++;
	}
}


//--------------------------------------------------------------
/**
 * @brief	O[XP[ARGB̔䗦
 *
 * @param	pal	
 * @param	pal_size	
 * @param	rp	
 * @param	gp	
 * @param	bp	
 *
 * @retval	none
 *
 *		 r = g = b = 256 ŃO[XP[֐Ɠ
 *
 */
//--------------------------------------------------------------
void PaletteColorChange(u16* pal, int pal_size, int rp, int gp, int bp)
{
	int i, r, g, b;
	u32 c;

	for(i = 0; i < pal_size; i++){
		r = ((*pal) & 0x1f);
		g = (((*pal) >> 5) & 0x1f);
		b = (((*pal) >> 10) & 0x1f);

		c = RGBtoY(r,g,b);
		
		r = COL_FIL(c, rp);
		g = COL_FIL(c, gp);
		b = COL_FIL(c, bp);

		if (r > 31){ r = 31; }
		if (g > 31){ g = 31; }
		if (b > 31){ b = 31; }

		*pal = (u16)((b<<10)|(g<<5)|r);
		pal++;
	}	
}


//--------------------------------------------------------------
/**
 * @brief	|P̃pbgϊē]
 *
 * @param	pfd			
 * @param	fileIdx	
 * @param	dataIdx	
 * @param	heap	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void PokeColorChange(PALETTE_FADE_PTR pfd, u32 fileIdx, u32 dataIdx, u32 heap, 
					 FADEREQ req, u32 trans_size, u16 pos, int r, int g, int b)
{
	NNSG2dPaletteData *pal_data;
	void *arc_data;
	
	arc_data = ArcUtil_PalDataGet(fileIdx, dataIdx, &pal_data, heap);
	GF_ASSERT(arc_data != NULL);
	
	if(trans_size == 0){
		trans_size = pal_data->szByte;
	}
	
	//PaletteGrayScale(pal_data->pRawData, 16);
	PaletteColorChange(pal_data->pRawData, 16, r,g,b);

	PaletteWorkSet(pfd, pal_data->pRawData, req, pos, trans_size);
	
	sys_FreeMemoryEz(arc_data);
}




































//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
#if 0

//=========================================================================
/**
 *	@file	palanm.c
 *	@brief	pbgAjEtF[hAEgAC
 *	@author	2004 Game Freak Inc.
 *	@date	04.03.08
 */
//=========================================================================

#include "common.h"
#include "palanm.h"
#include "softfade.h"
#include "ef_tool.h"
#include "decord.h"
#include "task.h"

//----------------------------------------------------------
//	vg^Cv錾	֐ް
//----------------------------------------------------------
u8 AddPalAnm(const PalAnmData *pAnmDat, u16 pal_no);
u8 PaletteAnime(void);
static void PaletteAnimeEndCheck(PalAnmWorkData *paw);
void DelPalAnm(u16 id_no);
void PalAnmInitWork(u8 pal_anm_no);
void PaletteAnimeInit(void);
void PalAnmPause(u16 id_no);
void PalAnmMove(u16 id_no);
u8 PalAnmGetWorkNumber(u16 id_no);
void PaletteFadeTrans( void );
void PlttCopy(void);
void PaletteAnimeBeforeAfter(u8 trans_type, u32 *PalAnmBit);
static void PaletteAnimeSub(PalAnmWorkData *paw, u32*);
u8 ColorAddSub(void);
static void FadeCheck(PalAnmWorkData *paw, u32 *PalAnmBit);
void FadeWorkInit(void);
u8 LightColorAddSub(void);
static u8 HardColorCalc(void);
static void HardColorRegisterSet(void);
static u8 FadeEndWaitCheck(void);
void LightFadeReqAdj(u8 fade_type, u8 fade_value);
static void LightFadeCommon(u8 fade_type);

//----------------------------------------------------------
//	O[oϐ
//----------------------------------------------------------
u16 PaletteWork[0x200] = {};			//ؼف@@BG&OBJگޯ
u16 PaletteWorkTrans[0x200] = {};		//]p
PalAnmWorkData PalAnmWork[PAL_ANM_MAX] = {};	//pbgAjpܰ
PlttFadeData FadeData = {};				//̪ޱāAݗp\
u32 PalAnmFadeBit = 0;	//گıҁA̪޲݁AĂگ eޯĂگNoɑΉ

//fobO 2002.09.12 TETSU
u16 PaletteWorkTmp[0x200] = {};			//WJe|[N
//fobO
//
//----------------------------------------------------------
//	f[^
//----------------------------------------------------------
const PalAnmData DmmyPalAnmDat = 
{
	65535,			//id_no
	0, //*PalData		]װگıڽ
	PA_BEFORE,      //type			BEFORE:װZΏہ@@AFTER:װZΏ
	PA_BG0+PA_COL0, //pal_no		0`511
	0,              //TransValue	col_no ܂łگĂΏۂƂ邩
	0,              //TransWaitDef	گı҂Ɉڂ܂ł̳
	0,              //TransValueLoopDef	]JԂ
	PA_END,         //PalAnmSeq		ҏȈ
	0,             //LoopWaitDef
};




//=========================================================================
//	pbg[NɈkꂽpbgf[^Zbg
// :*SrcAdrs = kĂްڽ
// 		pal_no = WJꏊ  PA_BG0+PA_COL5  PA_OBJ3+PA_COL0 ...
//		size = ޲Ļ
//=========================================================================
void DecordPaletteWork(void *SrcAdrs, u16 pal_no, u16 size)
{
#if 0
	DecordWram(SrcAdrs, &PaletteWork[pal_no]);
	CpuCopy(&PaletteWork[pal_no], &PaletteWorkTrans[pal_no], size, 16);
#else
	DecordWram(SrcAdrs, &PaletteWorkTmp[0x0000]);
	CpuCopy(&PaletteWorkTmp[0x0000], &PaletteWork[pal_no], size, 16);
	CpuCopy(&PaletteWorkTmp[0x0000], &PaletteWorkTrans[pal_no], size, 16);
#endif
}
//=========================================================================
//	pbg[Nɔ񈳏k̃pbgf[^Zbg
// :*SrcAdrs = kĂްڽ
// 		pal_no = WJꏊ  PA_BG0+PA_COL5  PA_OBJ3+PA_COL0 ...
//		size = ޲Ļ
//=========================================================================
void PaletteWorkSet(const u16 *pal_data, u16 pal_no, u16 size)
{
	CpuCopy(pal_data, &PaletteWork[pal_no], size, 16);
	CpuCopy(pal_data, &PaletteWorkTrans[pal_no],size, 16);
}

//=========================================================================
//	pbg[Nwf[^ŃNA
// : clear_data = ̃f[^ŗ̈𖄂߂܂B
//		pal_no = رꏊ  PA_BG0+PA_COL5  PA_OBJ3+PA_COL0 ...
//		size = ޲Ļ
//=========================================================================
void PaletteWorkClear(u16 clear_data, u16 pal_no, u16 size)
{
	CpuClear(clear_data, &PaletteWork[pal_no], size, 16);
	CpuClear(clear_data, &PaletteWorkTrans[pal_no], size, 16);
}

/*----------------------------------------------------------*/
/*	VuN̏										*/
/*	(VuNɏɃR[Ăj					*/
/*----------------------------------------------------------*/
void PaletteFadeTrans( void )
{
	if(FadeData.trans_stop == 1)
		return;
	
	DIV_DMACOPY(3, PaletteWorkTrans, PLTT, PLTT_SIZE, 16);
	PalAnmFadeBit = 0;
	if(FadeData.type == 2 && FadeData.fade_sw)
		HardColorRegisterSet();
}
=======
>>>>>>> 1.6

<<<<<<< palanm.c
//=========================================================================
//	pbgAj		  ҲٰߓŌĂł
// ߂l: 0=̪ظĂĂȂAظĂI
//         1=̪ގs
//         2=̪ظĂ͂Ă邪ĒȂ̂(̪ނ)͂Ȃ
//      0xff=Oظް܂]ĂȂ
//=========================================================================
u8 PaletteAnime(void)
{
	u8 temp;
	u32 PalAnmBit = 0;
	
	if(PalAnmFadeBit != 0)
		return 0xff;
	
	if(FadeData.type == 0)
	{
//		PaletteAnimeBeforeAfter(PA_BEFORE, &PalAnmBit);
		temp = ColorAddSub();
//		PaletteAnimeBeforeAfter(PA_AFTER, &PalAnmBit);
	}
	else if(FadeData.type == 1)
	{
//		PaletteAnimeBeforeAfter(PA_BEFORE, &PalAnmBit);
		temp = LightColorAddSub();
//		PaletteAnimeBeforeAfter(PA_AFTER, &PalAnmBit);
	}
	else
	{
//		PaletteAnimeBeforeAfter(PA_BEFORE, &PalAnmBit);
		temp = HardColorCalc();
//		PaletteAnimeBeforeAfter(PA_AFTER, &PalAnmBit);
	}
	
	PalAnmFadeBit = PalAnmBit | FadeData.fade_bit;
	return temp;
}
//----------------------------------------------------------
//	گıܰ&̪ظėpܰS
//----------------------------------------------------------
void PaletteAnimeInit(void)
=======
void PaletteTransSwitch(u8 flag)
>>>>>>> 1.6
{
<<<<<<< palanm.c
	u8 i;
	
	for(i = 0; i < PAL_ANM_MAX; i++)
	{
		PalAnmInitWork(i);
	}
	FadeWorkInit();
}
//----------------------------------------------------------
//	PLTT_VRAMްSPaletteWorkɺ߰
//----------------------------------------------------------
void PlttCopy(void)
{
	u16 i;
	u16 *dest;
	
	dest = (u16 *)PLTT;
	
	for(i = 0; i < 0x200; i++)
	{
		PaletteWork[i] = dest[i];
		PaletteWorkTrans[i] = dest[i];
	}
=======
	FadeData.req_flg = flag & 0x01;
	FadeData.req_bit = 0xFFFFFFFF;
>>>>>>> 1.6
}

<<<<<<< palanm.c
//----------------------------------------------------------
//	pbgZNGXg  ظĂdȂꍇ͐揟ł
//
// fade_bit : pbgwierbgpbgԍɑΉ
//			  rbg0 = BG0pbgA Bit16 = OBJ0pbg)
// wait : l傫Ƃ̪ޱāA݂܂B
//		  lƑ̪ޱāA݂܂B
// start_evy : ŏ̐F̔Zxw肵܂(0`16)
// 			   0(̐F)`2,3..(ԐF)`16(w肵F)
// end_evy : ̪ތvZ̍ŏIIȐF̔Zxw肵܂B̒ĺƓł
// next_rgb : ύX̐Fw
//
// ߂l: 1=I  0=װ
//----------------------------------------------------------
u8 PaletteFadeReq(u32 fade_bit, s8 wait, u8 start_evy, u8 end_evy, u16 next_rgb)
{
	u8 temp;
	
	if(FadeData.fade_sw == 1)
		return 0;
	
	FadeData.fade_value = 2;
	if(wait < 0){	//waitϲŽ̎value傫̪ނ𑁂
		FadeData.fade_value += abs(wait);
		wait = 0;
	}
	
	FadeData.fade_bit = fade_bit;
	FadeData.wait = wait;			//ظĂuԂɎs
	FadeData.wait_def = wait;
	FadeData.now_evy = start_evy;
	FadeData.end_evy = end_evy;
	FadeData.next_rgb = next_rgb;
	FadeData.fade_sw = 1;
	FadeData.type = 0;
	if(start_evy < end_evy)
		FadeData.direction = 0;
	else
		FadeData.direction = 1;
	
	PaletteAnime();		//add 2001.06.26() ظĂĂɔf悤ύX
	
	temp = FadeData.trans_stop;
	FadeData.trans_stop = 0;

	//PaletteFadeTrans();	//add 2001.06.26()
	CpuCopy(PaletteWorkTrans, PLTT, PLTT_SIZE, 32);
	PalAnmFadeBit = 0;
	if(FadeData.type == 2 && FadeData.fade_sw)
		HardColorRegisterSet();
	
	FadeData.trans_stop = temp;
	
	return 1;
}

u8 PaletteFadeReq2(u32 fade_bit, s8 wait, u8 start_evy, u8 end_evy, u16 next_rgb)
{
	u8 temp;
	
	PlttCopy();
	temp = PaletteFadeReq(fade_bit, wait, start_evy, end_evy, next_rgb);
	return temp;
}

//=========================================================================
//	pbgAj C
//=========================================================================
void PaletteAnimeBeforeAfter(u8 trans_type, u32 *PalAnmBit)
{
	u8 i;
	PalAnmWorkData *paw;
	
	for(i = 0; i < PAL_ANM_MAX; i++)
	{
		paw = &PalAnmWork[i];

		if(paw->pal_sw == 0 || paw->PalAnmDat->type != trans_type)
			continue;
		
		if(paw->TransValueLoop == paw->PalAnmDat->TransValueLoopDef)
		{
			PaletteAnimeEndCheck(paw);
			if(paw->pal_sw == 0)	//EndCheckDelꂽ̂
				continue;
		}

		if(paw->TransWait == 0)
		{
			PaletteAnimeSub(paw, PalAnmBit);
		}
		else
		{
			paw->TransWait--;
		}
		
		FadeCheck(paw, PalAnmBit);
	}
}

//----------------------------------------------------------
//	pbgAj Ăܰ֓]
//----------------------------------------------------------
static void PaletteAnimeSub(PalAnmWorkData *paw, u32 *PalAnmBit)
{
	u8 trans_value = 0;
	u16 now_pal;
	
	now_pal = paw->TransValueLoop * paw->PalAnmDat->TransValue;
	
	if(paw->PalAnmDat->type == PA_BEFORE)
	{
		while(trans_value < paw->PalAnmDat->TransValue)
		{
			PaletteWork[paw->pal_no]
						= paw->PalAnmDat->PalData[now_pal];
			PaletteWorkTrans[paw->pal_no]
						= paw->PalAnmDat->PalData[now_pal];
			trans_value++;
			paw->pal_no++;
			now_pal++;
		}
	}
	else	//PA_AFTER
	{
		while(trans_value < paw->PalAnmDat->TransValue)
		{
			PaletteWorkTrans[paw->pal_no]
						= paw->PalAnmDat->PalData[now_pal];
			trans_value++;
			paw->pal_no++;
			now_pal++;
		}
	}
	
	paw->pal_no = paw->pal_no_def;
	paw->TransWait = paw->PalAnmDat->TransWaitDef;
	
	//if(paw->TransValueLoop < paw->PalAnmDat->TransValueLoopDef)
		paw->TransValueLoop++;
	//else
	if(paw->TransValueLoop >= paw->PalAnmDat->TransValueLoopDef)
	{
		if(paw->LoopWait)
			paw->LoopWait--;
		paw->TransValueLoop = 0;
	}
	
	*PalAnmBit |= GET_PALNO_BIT(paw->pal_no_def);
//	BIT_SET(*PalAnmBit, paw->pal_no_def >> 4);	//ύXگĂޯĂ
}

//----------------------------------------------------------
//	̪ނگı҂ɓƂ̉Z␳
//----------------------------------------------------------
static void FadeCheck(PalAnmWorkData *paw, u32 *PalAnmBit)
{
	u8 i;
	u16 now_pal;
	
	if(FadeData.fade_sw == 0 
		|| ((GET_PALNO_BIT(paw->pal_no_def) & FadeData.fade_bit) == 0))
	{
		return;
	}
	
	if(paw->PalAnmDat->type == PA_BEFORE)
	{
		if(FadeData.wait == FadeData.wait_def)
			return;		//̪ނŏɌF̂OK
		
		//̪ނĂŎsȂ̂łł
		SoftFade(paw->pal_no_def, paw->PalAnmDat->TransValue,
				FadeData.now_evy, FadeData.next_rgb);
	}
	else	//PA_AFTER
	{
		if(FadeData.wait > 0)
			return;		//̪ނsȂ̂ŌFȂ
		
		if(paw->TransWait == paw->PalAnmDat->TransWaitDef)
			return;		//ް]ꂽ̂OK
		
		//̪ނŌFĂ܂Ă̂œ]Ȃ
		now_pal = paw->TransValueLoop * paw->PalAnmDat->TransValue;
		for(i = 0; i < paw->PalAnmDat->TransValue; i++)
		{
			PaletteWorkTrans[paw->pal_no_def+i] = paw->PalAnmDat->PalData[now_pal+i];
			//now_pal++;
		}
	}
}

//----------------------------------------------------------
//	SĂٰߏȈ
//----------------------------------------------------------
static void PaletteAnimeEndCheck(PalAnmWorkData *paw)
{
	if(paw->LoopWait == 0)
	{
		switch(paw->PalAnmDat->PalAnmSeq)
		{
			case PA_LOOP:
				paw->TransValueLoop = 0;
				paw->TransWait = paw->PalAnmDat->TransWaitDef;
				paw->LoopWait = paw->PalAnmDat->LoopWaitDef;
				paw->pal_no = paw->pal_no_def;
				break;
			case PA_OUFUKU:
			case PA_END:
				DelPalAnm(paw->PalAnmDat->id_no);
				break;
			default:
		}
	}
	else
	{
		paw->LoopWait--;
	}
}
//----------------------------------------------------------
//	w肵ID̃pbgAj폜
//----------------------------------------------------------
void DelPalAnm(u16 id_no)
{
	u8 i;
	
	if((i = PalAnmGetWorkNumber(id_no)) == PAL_ANM_MAX)
		return;		//error
	PalAnmInitWork(i);
}
//----------------------------------------------------------
//	pbgAjP
//----------------------------------------------------------
void PalAnmInitWork(u8 pal_anm_no)
{
	PalAnmWork[pal_anm_no].PalAnmDat = (PalAnmData *)&DmmyPalAnmDat;
	PalAnmWork[pal_anm_no].pal_sw = 0;
	PalAnmWork[pal_anm_no].pal_no_def = 0;
	PalAnmWork[pal_anm_no].pal_no = 0;
	PalAnmWork[pal_anm_no].TransValueLoop = 0;
	PalAnmWork[pal_anm_no].pause = 0;
	PalAnmWork[pal_anm_no].TransWait = 0;
	PalAnmWork[pal_anm_no].LoopWait = 0;
}
//----------------------------------------------------------
//	̪ظܰ
//----------------------------------------------------------
void FadeWorkInit(void)
{
	FadeData.fade_bit = 0;
	FadeData.wait_def = 0;
	FadeData.wait = 0;
	FadeData.now_evy = 0;
	FadeData.end_evy = 0;
	FadeData.next_rgb = 0;
	FadeData.fade_sw = 0;
	FadeData.direction = 0;
	FadeData.trans_stop = 0;
	FadeData.reset_flg = 0;
	FadeData.hard_end = 0;
	FadeData.fade_end = 0;
	FadeData.end_wait = 0;
	FadeData.bg_obj = 0;
	FadeData.fade_value = 2;
}
//----------------------------------------------------------
//	w肵ID̃pbgAj~߂
// o^ĂPalAnmWork̔zԍĂȂ璼ڂ
//----------------------------------------------------------
void PalAnmPause(u16 id_no)
{
	u8 i;
	
	if((i = PalAnmGetWorkNumber(id_no)) == PAL_ANM_MAX)
		return;		//error
	PalAnmWork[i].pause = 1;
}
//----------------------------------------------------------
//	w肵IDPauseŎ~߂Ăگı҂𓮂
// o^ĂPalAnmWork̔zԍĂȂ璼ڂ
//----------------------------------------------------------
void PalAnmMove(u16 id_no)
{
	u8 i;
	
	if((i = PalAnmGetWorkNumber(id_no)) == PAL_ANM_MAX)
		return;		//error
	
	PalAnmWork[i].pause = 0;
}
//----------------------------------------------------------
//	IDPalAnmWork̔zԍo
//----------------------------------------------------------
u8 PalAnmGetWorkNumber(u16 id_no)
{
	u8 i;
	
	for(i = 0; i < PAL_ANM_MAX; i++)
	{
		if(PalAnmWork[i].PalAnmDat->id_no == id_no)
			return i;
	}
	return PAL_ANM_MAX;	//error
}


//----------------------------------------------------------
//	\tgtF[hCAAEg(گıٰݗp)
// ߂l: 0=̪ظĂĂȂAظĂI
//         1=̪ގs
//         2=̪ظĂ͂Ă邪ĒȂ̂ŏ͂Ȃ
//----------------------------------------------------------
#include "softfade.h"
u8 ColorAddSub(void)
{
	u16 offset2;
	u16 next_rgb;
	u32 fade_bit;
	s8  evy;
	
	if(FadeData.fade_sw == 0)
		return 0;
	if(FadeEndWaitCheck())
		return FadeData.fade_sw;
	
	if(FadeData.bg_obj == 0){
		if(FadeData.wait < FadeData.wait_def)
		{
			FadeData.wait++;
			return 2;
		}
		else
			FadeData.wait = 0;
	}

	offset2 = 0;
	next_rgb = FadeData.next_rgb;

	if(FadeData.bg_obj == 0)
		fade_bit = FadeData.fade_bit & 0xffff;
	else{
		fade_bit = FadeData.fade_bit >> 16;
		offset2 = 16*16;
	}
	while(fade_bit)
	{
		if(fade_bit & 1)
			SoftFade(offset2, 16, FadeData.now_evy, FadeData.next_rgb);
		fade_bit >>= 1;
		offset2 += 16;
	}
	FadeData.bg_obj ^= 1;
	if(FadeData.bg_obj)
		return FadeData.fade_sw;

	if(FadeData.now_evy == FadeData.end_evy)
	{
		FadeData.fade_bit = 0;
		//FadeData.fade_sw = 0;
		FadeData.fade_end = 1;
	}
	else if(FadeData.direction == 0)
	{
		evy = FadeData.now_evy;	//31𒴂Ƶް۰N̂
		evy += FadeData.fade_value;
		if(evy > FadeData.end_evy)
			evy = FadeData.end_evy;
		FadeData.now_evy = evy;
	}
	else
	{
		evy = FadeData.now_evy;	//ϲŽ邽
		evy -= FadeData.fade_value;
		if(evy < FadeData.end_evy)
			evy = FadeData.end_evy;
		FadeData.now_evy = evy;
	}
	return FadeData.fade_sw;
}







//=========================================================================
//	J[]						2001.06.26()
// :@bit = J[]Ώگ   0bit:BGPalette0   16bit:ObjPalette0
//=========================================================================
void ColorReversal(u32 bit)
{
	u16 i = 0;
	u8 j;
	
	while(bit)
	{
		if(bit & 1)
		{
			for(j = 0; j < 16; j++)
				PaletteWorkTrans[i + j] ^= 0xffff;
		}
		bit >>= 1;
		i += 16;
	}
}

//=========================================================================
//	J[Z						2001.06.29
// :@bit = J[ZΏگ   0bit:BGPalette0   16bit:ObjPalette0
//=========================================================================
void ColorRandomPlus(u32 bit,s8 red,s8 green, s8 blue)
{
	u16 i = 0;
	u8 j;
	PlttData *p;
	
	while(bit)
	{
		if(bit & 1)
		{
			for(j = 0; j < 16; j++){
				p = (PlttData*)&(PaletteWorkTrans[i + j]);
				p->Red+=red;
				p->Green+=green;
				p->Blue+=blue;
			}
		}
		bit >>= 1;
		i += 16;
	}
}

//=========================================================================
//	J[Žn					2001.06.29
// :@bit = ߂Ώگ   0bit:BGPalette0   16bit:ObjPalette0
//=========================================================================
void ColorRandomPlusEnd(u32 bit)
{
	u16 i = 0;
	u8 j;
	
	while(bit)
	{
		if(bit & 1)
		{
			for(j = 0; j < 16; j++)
				PaletteWorkTrans[i + j] = PaletteWork[i+j];
		}
		bit >>= 1;
		i += 16;
	}
}


//=========================================================================
//	Ɣ݂̂ɗprڂtF[h֐
// fade_type = ǂ̪ނs
//			   W_to_N:ɰ  N_to_W:ɰف  B_to_N:ɰ  N_to_B:ɰف
//=========================================================================
void LightFadeReq(u8 fade_type)
{
	FadeData.fade_value = 2;
	LightFadeCommon(fade_type);
}

//----------------------------------------------------------
//	LightFadeReq, LightFadeReqSyncʏ
//----------------------------------------------------------
static void LightFadeCommon(u8 fade_type)
{
	FadeData.now_evy = 31;
	FadeData.wait_def = fade_type;
	FadeData.fade_sw = 1;
	FadeData.type = 1;
	
	if(fade_type == B_to_N)
		CpuArrayClear(0, PaletteWorkTrans, 16)
	if(fade_type == W_to_N)
		CpuArrayClear(0x7fff, PaletteWorkTrans, 16);
	PaletteAnime();		//ظĂĂɔf悤ύX
}

//----------------------------------------------------------
//	\tgtF[hCAAEg(گıٰݗp)
// ߂l: 0=̪ظĂĂȂAظĂI
//         1=̪ގs
//----------------------------------------------------------

u8 LightColorAddSub(void)
{
	u16 i;
	u16 start_pal, end_pal;
	s8 red,green,blue,t_red,t_green,t_blue;
	
	if(FadeData.fade_sw == 0)
		return 0;
	if(FadeEndWaitCheck())
		return FadeData.fade_sw;

	if(FadeData.bg_obj){
		start_pal = 0x100;
		end_pal = 0x200;
	}else{
		start_pal = 0;
		end_pal = 0x100;
	}

	switch(FadeData.wait_def)
	{
		case W_to_N:
			for(i = start_pal; i < end_pal; i++)
			{
				red = ((PlttData*)&PaletteWork[i])->Red;
				green = ((PlttData*)&PaletteWork[i])->Green;
				blue = ((PlttData*)&PaletteWork[i])->Blue;
				t_red = ((PlttData*)&PaletteWorkTrans[i])->Red-2;
				t_green = ((PlttData*)&PaletteWorkTrans[i])->Green-2;
				t_blue = ((PlttData*)&PaletteWorkTrans[i])->Blue-2;
				if(t_red < red)
					t_red = red;
				if(t_green < green)
					t_green = green;
				if(t_blue < blue)
					t_blue = blue;
				PaletteWorkTrans[i] = t_red | (t_green<<5) | (t_blue<<10);
			}
			break;
		case N_to_W:
			for(i = start_pal; i < end_pal; i++)
			{
				t_red = ((PlttData*)&PaletteWorkTrans[i])->Red+2;
				t_green = ((PlttData*)&PaletteWorkTrans[i])->Green+2;
				t_blue = ((PlttData*)&PaletteWorkTrans[i])->Blue+2;
				if(t_red > 31)
					t_red = 31;
				if(t_green > 31)
					t_green = 31;
				if(t_blue > 31)
					t_blue = 31;
				PaletteWorkTrans[i] = t_red | (t_green<<5) | (t_blue<<10);
			}
			break;
		case B_to_N:
			for(i = start_pal; i < end_pal; i++)
			{
				red = ((PlttData*)&PaletteWork[i])->Red;
				green = ((PlttData*)&PaletteWork[i])->Green;
				blue = ((PlttData*)&PaletteWork[i])->Blue;
				t_red = ((PlttData*)&PaletteWorkTrans[i])->Red+2;
				t_green = ((PlttData*)&PaletteWorkTrans[i])->Green+2;
				t_blue = ((PlttData*)&PaletteWorkTrans[i])->Blue+2;
				if(t_red > red)
					t_red = red;
				if(t_green > green)
					t_green = green;
				if(t_blue > blue)
					t_blue = blue;
				PaletteWorkTrans[i] = t_red | (t_green<<5) | (t_blue<<10);
			}
			break;
		case N_to_B:
			for(i = start_pal; i < end_pal; i++)
			{
				t_red = ((PlttData*)&PaletteWorkTrans[i])->Red-2;
				t_green = ((PlttData*)&PaletteWorkTrans[i])->Green-2;
				t_blue = ((PlttData*)&PaletteWorkTrans[i])->Blue-2;
				if(t_red < 0)
					t_red = 0;
				if(t_green < 0)
					t_green = 0;
				if(t_blue < 0)
					t_blue = 0;
				PaletteWorkTrans[i] = t_red | (t_green<<5) | (t_blue<<10);
			}
			break;
	}
	
	FadeData.bg_obj ^= 1;
	if(FadeData.bg_obj)
		return FadeData.fade_sw;

	if(FadeData.now_evy - FadeData.fade_value < 0)
		FadeData.now_evy = 0;
	else
		FadeData.now_evy -= FadeData.fade_value;
	if(FadeData.now_evy == 0)
	{
		switch(FadeData.wait_def)
		{	//؂̂ẲeŊSɂ̐Fɂ͂ȂȂ̂
			case W_to_N:
			case B_to_N:
				CpuArrayCopy(PaletteWork, PaletteWorkTrans, 32);
				break;
			case N_to_W:
				CpuArrayClear(0xffffffff, PaletteWorkTrans, 32);
				break;
			case N_to_B:
				CpuArrayClear(0, PaletteWorkTrans, 32);
				break;
		}
		FadeData.type = 0;
		//FadeData.fade_sw = 0;
		FadeData.fade_end = 1;
	}

	return FadeData.fade_sw;
}








//----------------------------------------------------------
//	n[hɂpbgZNGXg
//
// fade_bit : Z̑ΏۂɂBG,OBJw(BLDCNTڼ޽̑1Ώ߸قɐݒ肷ޯ)
//				6,7bit:xύX߁A޳ޯ(10:UP	 11:DOWN)
//				5bit:BD(ޯ׳), 4bit:OBJ, 3:BG3, 2:BG2, 1:BG1, 0:BG0
//
// wait : l傫Ƃ̪ޱāA݂܂ (MAX:63)
// start_evy : ŏ̐F̔Zxw肵܂(0`16)
// 			   0(̐F)`2,3..(ԐF)`16(A͔)
// end_evy : ŏIIȐF̔Zxw肵܂B̒ĺƓł
// reset_flg : ̪ޏIڼ޽̏邩(0:Ȃ  1:)
//----------------------------------------------------------
void HardFadeReq(u8 fade_bit, u8 wait, u8 start_evy, u8 end_evy, u8 reset_flg)
{
	FadeData.fade_bit = fade_bit;
	FadeData.wait = wait;			//ظĂuԂɎs
	FadeData.wait_def = wait;
	FadeData.now_evy = start_evy;
	FadeData.end_evy = end_evy;
	FadeData.fade_sw = 1;
	FadeData.type = 2;				//RegisterFade
	FadeData.reset_flg = reset_flg;
	FadeData.hard_end = 0;
	if(start_evy < end_evy)
		FadeData.direction = 0;
	else
		FadeData.direction = 1;
}

//----------------------------------------------------------
//	WX^[tF[hCAAEg(گıٰݗp)
// ߂l: 0=̪ظĂĂȂAظĂI
//         1=̪ގs
//         2=̪ظĂ͂Ă邪ĒȂ̂ŏ͂Ȃ
//----------------------------------------------------------
static u8 HardColorCalc(void)
{
	s8  evy;
	
	if(FadeData.fade_sw == 0)
		return 0;

	if(FadeData.wait < FadeData.wait_def)
	{
		FadeData.wait++;
		return 2;
	}
	else
		FadeData.wait = 0;

	if(FadeData.direction == 0){
		FadeData.now_evy++;
		if(FadeData.now_evy > FadeData.end_evy){
			FadeData.hard_end++;
			FadeData.now_evy--;
		}
	}
	else
	{
		evy = FadeData.now_evy;	//ϲŽ邽
		FadeData.now_evy--;
		evy--;
		if(evy < FadeData.end_evy){
			FadeData.hard_end++;
			FadeData.now_evy++;
		}
	}
	
	if(FadeData.hard_end){
		//FadeData.fade_sw = 0;		HardColorRegisterSet֐̒ŗƂ̂
		//FadeData.fade_bit = 0;
		if(FadeData.reset_flg){
			FadeData.fade_bit = 0;
			FadeData.now_evy = 0;
		}
		FadeData.reset_flg = 0;
	}
	return FadeData.fade_sw;
}

static void HardColorRegisterSet(void)
{
	RegisterSet(OFFSET_REG_BLDCNT , FadeData.fade_bit);
	RegisterSet(OFFSET_REG_BLDY , FadeData.now_evy);
	if(FadeData.hard_end){
		FadeData.hard_end = 0;
		FadeData.type = 0;
		FadeData.fade_bit = 0;
		FadeData.now_evy = 0;
		FadeData.fade_sw = 0;
	}
}





//=========================================================================
//	̪ޏIASyncĂ
//	߂l: 0=܂̪ޏIĂȂ		1=Ē
//=========================================================================
static u8 FadeEndWaitCheck(void)
{
	if(FadeData.fade_end){
		if(FadeData.end_wait == FADE_END_WAIT){
			FadeData.fade_sw = 0;
			FadeData.fade_end = 0;
			FadeData.end_wait = 0;
		}else
			FadeData.end_wait++;
		return 1;
	}
	return 0;
}




//=========================================================================
//	wrbg̃J[pbgĂ΂ꂽuԂɎwFAwZxɕύX
//
// fade_bit : pbgwierbgpbgԍɑΉ
//			  rbg0 = BG0pbgA Bit16 = OBJ0pbg)
// start_evy : ύX̐F̔Zxw肵܂(0`16)
// 			   0(̐F)`2,3..(ԐF)`16(w肵F)
// next_rgb : ύX̐Fw
//=========================================================================
void ColorConceChange(u32 fade_bit, u8 evy, u16 next_rgb)
{
	u16 offset = 0;
	
	while(fade_bit){
		if(fade_bit & 1)
			SoftFade(offset, 16, evy, next_rgb);
		fade_bit >>= 1;
		offset += 16;
	}
}



//=========================================================================
//	wrbg̃J[pbgĂ΂ꂽuԂɎwFAwZxɕύX
// w肳ĂȂޯĂگĂ͌̐Fɖ߂܂B
// fade_bit : pbgwierbgpbgԍɑΉ
//			  rbg0 = BG0pbgA Bit16 = OBJ0pbg)
// start_evy : ύX̐F̔Zxw肵܂(0`16)
// 			   0(̐F)`2,3..(ԐF)`16(w肵F)
// next_rgb : ύX̐Fw
//=========================================================================
void ColorConceChange2(u32 fade_bit, u8 evy, u16 next_rgb)
{
	DIV_DMACOPY(3, PaletteWork, PaletteWorkTrans, 0x400, 32);
	ColorConceChange(fade_bit, evy, next_rgb);
}

//===============================================
// PxvZ}N
//===============================================
#define RGBtoY(r,g,b)	(((r)*76 + (g)*151 + (b)*29) >> 8)

//--------------------------------------------------------------------------
/**
 * O[XP[
 *
 * @param   pal		
 * @param   pal_size		
 *
 * @retval  none		
 */
//--------------------------------------------------------------------------
void PalGrayScale(u16 *pal, u16 pal_size)
{
	int i, r, g, b;
	u32 c;

	for(i = 0; i < pal_size; i++){
		r = ((*pal) & 0x1f);
		g = (((*pal) >> 5) & 0x1f);
		b = (((*pal) >> 10) & 0x1f);

		c = RGBtoY(r,g,b);

		*pal = (u16)((c<<10)|(c<<5)|c);
		pal++;
	}
}
//--------------------------------------------------------------------------
/**
 * 2bitJ[
 *
 * @param   pal		
 * @param   pal_size		
 *
 * @retval  none		
 */
//--------------------------------------------------------------------------
void Pal2BitFilter(u16 *pal, u16 pal_size)
{
	static const u8  col_tbl[32] = {
		 0, 0, 0, 0, 0, 5, 5, 5, 5, 5,
		11,11,11,11,11,16,16,16,16,16,
		21,21,21,21,21,27,27,27,27,27,
		31,31,
	};

	int i, r, g, b;
	u32 c;

	for(i = 0; i < pal_size; i++){
		r = ((*pal) & 0x1f);
		g = (((*pal) >> 5) & 0x1f);
		b = (((*pal) >> 10) & 0x1f);

		c = RGBtoY(r,g,b);

		if(c > 31){
			c = 31;
		}
		c = col_tbl[c];
		*pal = (u16)((c<<10)|(c<<5)|c);
		pal++;
	}
}
//--------------------------------------------------------------------------
/**
 * ZsAJ[
 *
 * @param   pal		
 * @param   pal_size		
 *
 * @retval  none		
 */
//--------------------------------------------------------------------------
void PalSepiaFilter(u16 *pal, u16 pal_size)
{
	int i, r, g, b, y;

#define R_FIL(x)	( ((u16)((x)*307)>>8) )
#define G_FIL(x)	( ((u16)((x)*256)>>8) )
#define B_FIL(x)	( ((u16)((x)*240)>>8) )

	for(i = 0; i < pal_size; i++){
		r = ((*pal) & 0x1f);
		g = (((*pal) >> 5) & 0x1f);
		b = (((*pal) >> 10) & 0x1f);

		y = RGBtoY(r,g,b);

		r = R_FIL(y);
		g = G_FIL(y);
		b = B_FIL(y);

		if(r > 31){ r = 31; }

		*pal = (u16)((b<<10)|(g<<5)|r);
		pal++;
	}


#undef R_FIL
#undef G_FIL
#undef B_FIL
}

// -------------------------------------------------------------------------
/**
 * J[ύX
 *
 * @param	pal			ύXpbg̃AhX
 * @param	pal_size	FύX邩H
 * @paran	rp			
 * @paran	gp			
 * @paran	bp			
 *
 * @return	none
 */
// -------------------------------------------------------------------------
void PalColorFilter(u16 *pal, u16 pal_size, u16 rp, u16 gp, u16 bp)
{
	int i, r, g, b, y;

#define C_FIL(y,c)	((u16)((y)*(c))>>8)

	for(i = 0; i < pal_size; i++){
		r =  ((*pal) & 0x1f);
		g = (((*pal) >> 5) & 0x1f);
		b = (((*pal) >> 10) & 0x1f);

		y = RGBtoY(r,g,b);

		r = C_FIL(y,rp);
		g = C_FIL(y,gp);
		b = C_FIL(y,bp);

		if (r > 31){ r = 31; }
		if (g > 31){ g = 31; }
		if (b > 31){ b = 31; }

		*pal = (u16)((b<<10)|(g<<5)|r);
		pal++;
	}

#undef C_FIL

}

/*====================================================================================*/
/*                                                                                    */
/*  pbgtF[hs                                                          */
/*                                                                                    */
/*====================================================================================*/

static void ParallelFadeTask(u8 id);

enum {
	PFWORK_EVY,
	PFWORK_EVY_END,
	PFWORK_EVY_ADD,
	PFWORK_WAIT,
	PFWORK_COUNT,
	PFWORK_FADEBIT,
	PFWORK_FADEBIT_2ND,
	PFWORK_RGB,
	PFWORK_ID,
};

//------------------------------------------------------------------------------
/**
 * قȂpbgɕsĕʁX̃tF[hi^XNZbgj
 *
 * @param   fade_bit		Ώۃpbgrbg
 * @param   wait			EFCg
 * @param   start_evy		Jnevy
 * @param   end_evy			Ievy
 * @param   rgb				tF[hJ[
 * @param   pri				^XNvCIeB
 * @param   id				ʂhciĂяoǗB^XNƂɈႤIDnj
 *
 * @retval  u8			o^^XN̂hc
 *
 * fade_bit ` rgb ܂ł̃p[^́APaletteFadeReq ƓlB
 *
 */
//------------------------------------------------------------------------------
void ParallelFadeSet(u32 fade_bit, s8 wait, u8 start_evy, u8 end_evy, u16 rgb, u8 pri, u8 id)
{
	u8 no = AddTask(ParallelFadeTask, pri);

	TaskTable[no].work[PFWORK_EVY] = start_evy;
	TaskTable[no].work[PFWORK_EVY_END] = end_evy;

	if(wait >= 0){
		TaskTable[no].work[PFWORK_WAIT] = wait;
		TaskTable[no].work[PFWORK_EVY_ADD] = 1;
	}else{
		TaskTable[no].work[PFWORK_WAIT] = 0;
		TaskTable[no].work[PFWORK_EVY_ADD] =  -(wait) + 1;
	}

	if(end_evy < start_evy){
		TaskTable[no].work[PFWORK_EVY_ADD] *= -1;
	}

	TaskStoreAdrs(no, PFWORK_FADEBIT, (void*)fade_bit);
	TaskTable[no].work[PFWORK_RGB] = (s16)rgb;
	TaskTable[no].work[PFWORK_ID] = id;

	TaskTable[no].TaskAdrs(no);
}

//------------------------------------------------------------------------------
/**
 * stF[hI҂
 *
 * @param   id			ʂhciParallelFadeSet ̈Ɠ́j
 *
 * @retval  BOOL		TRUE:p^FALSE:I
 */
//------------------------------------------------------------------------------
BOOL ParallelFadeWait(u8 id)
{
	int i;
	for(i = 0; i < TASK_MAX; i++){
		if(	(TaskTable[i].occ == 1)
		&&	(TaskTable[i].TaskAdrs == ParallelFadeTask)
		&&	(TaskTable[i].work[PFWORK_ID] == id)
		){
			return TRUE;
		}
	}
	return FALSE;
}
//------------------------------------------------------------------------------
/**
 * s^XNtF[hSI
 *
 * @param   none		
 *
 * @retval  none		
 */
//------------------------------------------------------------------------------
void ParallelFadeStopAll(void)
{
	u8 no = CheckTaskNo(ParallelFadeTask);
	while(no != NOT_EXIST_TASK_ID){
		DelTask(no);
		no = CheckTaskNo(ParallelFadeTask);
	}
}
/**=====================================================================
 *
 * stF[hs^XN
 *
 * @param   id		
 *
 * @retval  none		
 *
 *====================================================================*/
static void ParallelFadeTask(u8 id)
{
	s16 *wk;
	u32 fade_bit;

	wk = TaskTable[id].work;
	fade_bit = (u32)TaskTakeAdrs(id, PFWORK_FADEBIT);

	wk[PFWORK_COUNT]++;
	if( wk[PFWORK_COUNT] > wk[PFWORK_WAIT] ){
		wk[PFWORK_COUNT] = 0;

		ColorConceChange(fade_bit, wk[PFWORK_EVY], (u16)(wk[PFWORK_RGB]));
		if(wk[PFWORK_EVY] == wk[PFWORK_EVY_END]){
			DelTask(id);
			return;
		}

		wk[PFWORK_EVY] += wk[PFWORK_EVY_ADD];

		if(wk[PFWORK_EVY_ADD] >= 0){
			if(wk[PFWORK_EVY] >= wk[PFWORK_EVY_END]){
				wk[PFWORK_EVY] = wk[PFWORK_EVY_END];
			}
		}else{
			if(wk[PFWORK_EVY] <= wk[PFWORK_EVY_END]){
				wk[PFWORK_EVY] = wk[PFWORK_EVY_END];
			}
		}

	}

}



#endif
