//==============================================================================
/**
 * @file	particle.c
 * @brief	p[eBNc[
 * @author	matsuda
 * @date	2005.07.04()
 */
//==============================================================================
#include "common.h"
#include "system/particle.h"
#include "spl.h"
#include "wazaeffect/we_err.h"
#include "system/arc_tool.h"

#ifdef PM_DEBUG

	PTC_PTR gDebugPTC = NULL;
	
#endif

//==============================================================================
//	萔`
//==============================================================================
//SPL_Init
enum{
	EMIT_MAX = 20,			///<1̃\[XœɏoőG~b^
	PARTICLE_MAX = 200,		///<őp[eBN
	FIX_POLYGON_ID = 5,		///<Œ|SID
	MIN_POLYGON_ID = 6,		///<ŏ|SID
	MAX_POLYGON_ID = 63,	///<ő|SID
};

///G~b^ĂȂtO
#define NON_EMIT		(0xffff)

///NheNX`VRAM}l[WōőǗo鐔
#define LNK_TEX_KEY_MAX		(10)

///NhpbgVRAM}l[WōőǗo鐔
//p̂̑NNSGfdFrmPlttVramStateƓTCYɂȂ2Ȃ񂾂ǁA
//ꂾƂ܂ɂȂ̂łƂ肠8
#define LNK_PLTT_KEY_MAX	(8)

//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   G~b^p[^\
 */
//--------------------------------------------------------------
typedef struct{
	SPLEmitter *emit_ptr;			///<G~b^ւ̃|C^
	u16 res_no;						///<\[Xԍ
}EMIT_PARAM;

//--------------------------------------------------------------
/**
 * @brief	p[eBNVXe\
 */
//--------------------------------------------------------------
typedef struct _PARTICLE_SYSTEM{
	SPLManager *spl_manager;		///<SPL}l[Wւ̃|C^
//	EMIT_PARAM emitter[EMIT_MAX];	///<G~b^p[^
	void *res_ptcl;					///<p[eBN\[Xւ̃|C^
	SPLEmitter *temp_emit;			///<ŌɐG~b^̃|C^ێ
	
	void *heap_start;				///<SPLCuŎgp郏[N̐擪AhX
	void *heap;						///<q[v݂̌̋󂫗̈̐擪AhXw
	void *heap_end;					///<q[vŎgpoIn_̃AhX
	
	pTexCallback user_tex_func;		///<eNX`VRAMAhXԂ߂̃R[obN֐
	pTexCallback user_pltt_func;	///<eNX`pbgAhXԂ߂̃R[obN֐
	
	GF_CAMERA_PTR camera;			///<J
	VecFx32 vec;
	u16 persp_way;					///<ˉe̊px
	
	VecFx32 eye;		//J̈ʒuxNg
	VecFx32 v_up;		//J̏̃xNgւ̃|C^
	VecFx32 at;			//J̏œ_ւ̃xNg
	
	union{
		NNSGfdFrmTexVramState tex_frm_state;	///<t[eNX`݂̌̃mۏ
		NNSGfdTexKey tex_key[LNK_TEX_KEY_MAX];	///<NheNX`̃eNX`L[
	};
	union{
		NNSGfdFrmPlttVramState pltt_frm_state;		///<t[pbǧ݂̃mۏ
		NNSGfdPlttKey pltt_key[LNK_PLTT_KEY_MAX];	///<Nhpbg̃pbgL[
	};
	
	u8 vram_free;					///<Vram̎[h(PTC_AUTO???_???)
	u8 seq;							///<V[PXԍ
	u8 global_no;					///<gpO[oϐԍ
	u8 camera_type;					///<J̎ˉe(GF_CAMERA_PERSPECTIV)
}PARTICLE_SYSTEM;


//==============================================================================
//	O[oϐ
//==============================================================================
//--------------------------------------------------------------
/**
 * ݐĂp[eBNVXẽ|C^B
 * SPLCuŎgpLocalAlloc֐ŁAp[eBNVXeŊmۂĂq[v̈
 * 擾KvBLocalAllocSPLCuŊ֐̌^߂Ă邽߁A
 * q[v̈̃|C^nƂoȂ̂ŁÃO[oϐoRœnB
 */
//--------------------------------------------------------------
static void *ParticleSystemPtr[PARTICLE_GLOBAL_MAX];

//--------------------------------------------------------------
/**
 * G~b^쐬̃R[obN֐ŁACӂ̃f[^QƏo悤A
 * ꎞIɂɓnf[^̃|C^B
 * (ŃG~b^̏ꍇAEmitCreateNULL|C^ԂĂ̂ŁAG~b^ςꍇA
 *  R[obN֐ŕύXĂKv邽)
 */
//--------------------------------------------------------------
static void *ParticleTempPtr;

//==============================================================================
//	f[^`
//==============================================================================
///ftHg̃J̈ʒuxNg
static const VecFx32 DefaultEye = {
//	0, -0x2500, 0x3500
//	0x2500, 0, 0x2200
//	-0x2000, -0x2000, -0x2000
//	-0x300, -0x100, 0x2100
//	0, 0, 0x2100
	0, 0, 0x4000
//	0, 15*0x1000, 0
//	128*0x1000, 128*0x1000, 0x4000
};
///ftHg̃J̏̃xNg
static const VecFx32 DefaultUp = {
	0, FX32_ONE, 0
};
///ftHg̃J̏œ_ւ̃xNg
static const VecFx32 DefaultAt = {
	0, 0, 0
};

//==============================================================================
//	vg^Cv錾
//==============================================================================
static void *Particle_LocalAlloc_0(u32 size);
static void *Particle_LocalAlloc_1(u32 size);
static void *Particle_LocalAlloc_2(u32 size);
static inline void *Particle_LocalAlloc(PARTICLE_SYSTEM *psys, u32 size);

void Particle_SystemExit(PTC_PTR psys);
void Particle_ResourceSet(PTC_PTR psys, void *resource, int vram_free);
void Particle_EmitterDeleteAll(PTC_PTR psys);

//==============================================================================
//	
//==============================================================================
///p[eBNVXeŎgp̈mۊ֐̃|C^e[u
static const SPLAlloc LocalAllocFunc[] = {
	Particle_LocalAlloc_0,
	Particle_LocalAlloc_1,
	Particle_LocalAlloc_2,
};



#if 0	//------- p[eBNgp ---- 2005.07.15()

void BattleParticle_TestInit(void)
{
	PARTICLE_SYSTEM *psys;
	
	psys = Particle_SystemCreate(sAllocTex, sAllocTexPalette);
//	psys = Particle_SystemCreate(NULL, sAllocTexPalette);
	TCB_Add(BattleParticle_Main, psys, 20);
}

static void BattleParticle_Main(TCB_PTR tcb, void *work)
{
	PARTICLE_SYSTEM *psys = work;
	void *resource;
	
	switch(psys->seq){
	case 0:
		resource = Particle_ResourceLoad("wazaeffect/effectdata/output5.spa");
		Particle_ResourceSet(psys, resource);
		psys->seq++;
		break;
	case 1:
		Particle_Draw(psys);	//p[eBN`
		Particle_Calc(psys);	//p[eBNvZ
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   eNX`VRAMAhXԂ߂̃R[obN֐
 *
 * @param   size		eNX`TCY
 * @param   is4x4comp	4x4keNX`ł邩ǂ̃tO(TRUE=keNX`)
 *
 * @retval  ǂݍ݂JnVRAM̃AhX
 */
//--------------------------------------------------------------
static u32 sAllocTex(u32 size, BOOL is4x4comp)
{
#if 0
	NNSGfdTexKey key = NNS_GfdAllocTexVram(size, is4x4comp, 0);
	SDK_ASSERT(key != NNS_GFD_ALLOC_ERROR_TEXKEY);
	return NNS_GfdGetTexKeyAddr(key);
#else
	u32 address;
	
	NNSGfdTexKey key = NNS_GfdAllocTexVram(size, is4x4comp, 0);
	key = NNS_GfdAllocTexVram(size, is4x4comp, 0);
	SDK_ASSERT(key != NNS_GFD_ALLOC_ERROR_TEXKEY);
	address = NNS_GfdGetTexKeyAddr(key);
	OS_Printf("VramAhX%#x\n", address);
	return address;
#endif
}

//--------------------------------------------------------------
/**
 * @brief	eNX`pbgVRAMAhXԂ߂̃R[obN֐
 *
 * @param	size		eNX`TCY
 * @param	is4pltt		4Fpbgł邩ǂ̃tO
 *
 * @retval	ǂݍ݂JnVRAM̃AhX
 *
 * direct`̃eNX`̏ꍇASPL_LoadTexPlttByCallbackFunction
 * R[obN֐Ăяo܂B
 */
//--------------------------------------------------------------
static u32 sAllocTexPalette(u32 size, BOOL is4pltt)
{
#if 0
	NNSGfdPlttKey key = NNS_GfdAllocPlttVram(size, is4pltt, 0);
	if(key == NNS_GFD_ALLOC_ERROR_PLTTKEY){
		OS_Panic("pbgG[");
	}
	return NNS_GfdGetPlttKeyAddr(key);
#else
	return 0x20*4;
#endif
}

#endif	//------------- p[eBNgp ---------------------------




//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeŎgp郏[N̏
 *
 * Particle_SystemCreateɂsKv܂B
 */
//--------------------------------------------------------------
void Particle_SystemWorkInit(void)
{
	int i;
	
	for(i = 0; i < PARTICLE_GLOBAL_MAX; i++){
		ParticleSystemPtr[i] = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXe쐬
 *
 * @param   tex_func		eNX`[hAgpVramAhXԂ֐ւ̃|C^
 * @param   pltt_func		eNX`[hAgppbgVramAhXԂ֐ւ̃|C^
 * @param   work			SPLCuŎgp邽߂Ɋ蓖Ă郏[Ñ|C^
 * @param   work_size		n[ÑTCY(PARTICLE_LIB_HEAP_SIZEƓORȏ̃TCYKv)
 * @param   personal_camera		p[eBNƎ̃JݒꍇTRUEB
 * @param   heap_id			p[eBNVXe쐬Ɏgpq[vID
 *
 * @retval  p[eBNVXe[Nւ̃|C^(oȂꍇNULL)
 *
 * tex_func, pltt_func NULLw肵ꍇNitroSystemVramAPltt}l[WɈˑ܂B
 *
 * workœn[NSPLCuŎgp܂B
 * AllocĎɓꂽ[N̈̃|C^nꍇAParticle_SystemExitAO
 * sĂB(p[eBNVXeŃ[N̉͂܂)
 *
 * global_noFp[eBNVXeSPLCuƂ̂ŃO[oϐgp܂B
 * ׂ̈̃O[oϐzŊɗpӂĂ܂B̉Ԗڂ̃O[oϐgpāA
 * p[eBNVXe𓮂AƂwłB
 * pӂĂO[oϐɂ͌肪܂B(2005.07.26()݂3(0`2))
 */
//--------------------------------------------------------------
PTC_PTR Particle_SystemCreate(pTexCallback tex_func, pTexCallback pltt_func, void *work, int work_size, int personal_camera, int heap_id)
{
	PARTICLE_SYSTEM *psys;
	int global_no;
	
	//O[oϐ̋󂫂T[`
	for(global_no = 0; global_no < PARTICLE_GLOBAL_MAX; global_no++){
		if(ParticleSystemPtr[global_no] == NULL){
			break;
		}
	}
	if(global_no >= PARTICLE_GLOBAL_MAX){
		return NULL;
	}
	
	//p[eBNVXẽm
	psys = sys_AllocMemory(heap_id, sizeof(PARTICLE_SYSTEM));
	if(psys == NULL){
		OS_Panic("mێs\n");
	}
	memset(psys, 0, sizeof(PARTICLE_SYSTEM));

	//p[^ݒ
	psys->user_tex_func = tex_func;
	psys->user_pltt_func = pltt_func;

	psys->eye = DefaultEye;
	psys->v_up = DefaultUp;
	psys->at = DefaultAt;

	//ݒ
	SDK_ASSERT(global_no < PARTICLE_GLOBAL_MAX);
	memset(work, 0, work_size);
	psys->heap_start = work;
	psys->heap = work;
	psys->heap_end = (void*)((u32)work + work_size);
	psys->global_no = global_no;
	ParticleSystemPtr[global_no] = psys;
	
	//Jݒ
	if(personal_camera == TRUE){
		psys->camera = GFC_AllocCamera(heap_id);
		{
			VEC_Set(&psys->vec, 0, 0, 0);
			psys->persp_way = 8192;//0x06c1;
		#if 0
			GFC_InitCameraTDA(&psys->vec,
						0x1000,					//
						&psys->angle,
						psys->persp_way,		//ˉe̊px
						GF_CAMERA_PERSPECTIV,
						psys->camera
						);
		#elif 0
			GFC_InitCameraCDA(&psys->vec,
						0x1000,					//
						&psys->angle,
						psys->persp_way,		//ˉe̊px
						GF_CAMERA_PERSPECTIV,
						psys->camera
						);
		#else
			GFC_InitCameraTC(&DefaultAt, &DefaultEye,
						psys->persp_way,		//ˉe̊px
						GF_CAMERA_PERSPECTIV,
						TRUE,
						psys->camera
						);
		#endif
			psys->camera_type = GF_CAMERA_PERSPECTIV;
			GFC_AttachCamera(psys->camera);
		}
	}

	// p[eBN}l[W
	psys->spl_manager = SPL_Init(LocalAllocFunc[global_no], EMIT_MAX, PARTICLE_MAX, 
		FIX_POLYGON_ID, MIN_POLYGON_ID, MAX_POLYGON_ID);
	
	Particle_SetVup(psys, &DefaultUp);
	
	return psys;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeI
 *
 * @param   p[eBNVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void Particle_SystemExit(PTC_PTR psys)
{
	int i;
	
	SDK_ASSERT(psys != NULL);
	SDK_ASSERT(psys->spl_manager != NULL);

	//G~b^S폜
	Particle_EmitterDeleteAll(psys);
	
	//eNX`Vram
	if(psys->vram_free & PTC_AUTOTEX_FRM){
		NNS_GfdSetFrmTexVramState(&psys->tex_frm_state);
	}
	else if(psys->vram_free & PTC_AUTOTEX_LNK){
		//2005.07.25()@ݖ Ǎ폜͍̂̏̂ŁA폜͍쐬
		int i;
		for(i = 0; i < LNK_TEX_KEY_MAX; i++){
			if(psys->tex_key[i] != 0){
				NNS_GfdFreeLnkTexVram(psys->tex_key[i]);
				psys->tex_key[i] = 0;
			}
		}
	}
	//pbgVramp[^
	if(psys->vram_free & PTC_AUTOPLTT_FRM){
		NNS_GfdSetFrmPlttVramState(&psys->pltt_frm_state);
	}
	else if(psys->vram_free & PTC_AUTOPLTT_LNK){
		//2005.07.25()@ݖ Ǎ폜͍̂̏̂ŁA폜͍쐬
		int i;
		for(i = 0; i < LNK_PLTT_KEY_MAX; i++){
			if(psys->pltt_key[i] != 0){
				NNS_GfdFreeLnkPlttVram(psys->pltt_key[i]);
				psys->pltt_key[i] = 0;
			}
		}
	}
	psys->vram_free = PTC_AUTOTEX_NULL | PTC_AUTOPLTT_NULL;
	psys->temp_emit = NULL;

	//\[Xt@Cǂݍł郁
	if(psys->res_ptcl != NULL){
		sys_FreeMemoryEz(psys->res_ptcl);
		psys->res_ptcl = NULL;
	}
	
	//p[eBNVXẽ[N
	for(i = 0; i < PARTICLE_GLOBAL_MAX; i++){
		if(ParticleSystemPtr[i] == psys){
			ParticleSystemPtr[i] = NULL;
			break;
		}
	}
	SDK_ASSERT(i < PARTICLE_GLOBAL_MAX); //ParticleSystemPtrɈȂƂƂ͕sȒl
	
	//J
	if(psys->camera != NULL){
		GFC_FreeCamera(psys->camera);
	}

	sys_FreeMemoryEz(psys);
}

//--------------------------------------------------------------
/**
 * @brief   Ăp[eBNVXeSĂI
 */
//--------------------------------------------------------------
void Particle_SystemExitAll(void)
{
	int i;
	
	for(i = 0; i < PARTICLE_GLOBAL_MAX; i++){
		if(ParticleSystemPtr[i] != NULL){
			Particle_SystemExit(ParticleSystemPtr[i]);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeŎgpAlloc֐
 *
 * @param   size		mۂ郁TCY
 *
 * SPL_InitŊ֐|C^ƂēnĂ̂ŁÅ֐̌`ςĂ͂ȂB
 */
//--------------------------------------------------------------
static inline void *Particle_LocalAlloc(PARTICLE_SYSTEM *psys, u32 size)
{
	void *work;
	u32 heap_adrs, rem;
	
	work = psys->heap;
	
	heap_adrs = (u32)psys->heap + size;
	rem = heap_adrs % 4;
	if(rem > 0){
		heap_adrs += 4 - rem;	//4oCg␳
	}
	psys->heap = (void*)heap_adrs;
	
	if(psys->heap >= psys->heap_end){
		OS_Panic("p[eBNVXeŃI[o[܂I\n");
	}
	return work;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeŎgpAlloc֐
 * @param   size		mۂ郁TCY
 *
 * SPL_InitŊ֐|C^ƂēnĂ̂ŁÅ֐̌`ςĂ͂ȂB
 */
//--------------------------------------------------------------
static void *Particle_LocalAlloc_0(u32 size)
{
	PARTICLE_SYSTEM *psys;
	
	psys = ParticleSystemPtr[PARTICLE_GLOBAL_0];
	return Particle_LocalAlloc(psys, size);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeŎgpAlloc֐
 * @param   size		mۂ郁TCY
 *
 * SPL_InitŊ֐|C^ƂēnĂ̂ŁÅ֐̌`ςĂ͂ȂB
 */
//--------------------------------------------------------------
static void *Particle_LocalAlloc_1(u32 size)
{
	PARTICLE_SYSTEM *psys;
	
	psys = ParticleSystemPtr[PARTICLE_GLOBAL_1];
	return Particle_LocalAlloc(psys, size);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeŎgpAlloc֐
 * @param   size		mۂ郁TCY
 *
 * SPL_InitŊ֐|C^ƂēnĂ̂ŁÅ֐̌`ςĂ͂ȂB
 */
//--------------------------------------------------------------
static void *Particle_LocalAlloc_2(u32 size)
{
	PARTICLE_SYSTEM *psys;
	
	psys = ParticleSystemPtr[PARTICLE_GLOBAL_2];
	return Particle_LocalAlloc(psys, size);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBÑ\[Xt@Cǂݍ
 *
 * @param   heap_id		q[vID
 * @param   path		ǂݍރ\[Xt@C(*.spa)ւ̃|C^
 *
 * @retval  ǂݍ񂾃\[Xt@C̃|C^
 *
 * Particle_ResourceSet֐ƃZbgŎgp鎖OłB
 * ǂݍ񂾃\[Xt@CParticle_SystemExitFreeMemory܂B
 */
//--------------------------------------------------------------
void * Particle_ResourceLoad(int heap_id, const char *path)
{
	return sys_LoadFile(heap_id, path);
}

//--------------------------------------------------------------
/**
 * @brief   ArcĂp[eBÑ\[Xt@Cǂݍ
 *
 * @param   file_kind	ǂݍރA[JCut@C̎ރCfbNXio[iarc_tool.hɋLq)
 * @param   index		ǂݍރf[^̃A[JCut@C̃CfbNXio[
 * @param   heap_id		q[vID
 *
 * @retval  ǂݍ񂾃\[Xt@C̃|C^
 *
 * Particle_ResourceSet֐ƃZbgŎgp鎖OłB
 * ǂݍ񂾃\[Xt@CParticle_SystemExitFreeMemory܂B
 */
//--------------------------------------------------------------
void * Particle_ArcResourceLoad(int file_kind, int index, int heap_id)
{
	return ArchiveDataLoadMalloc(file_kind, index, heap_id);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBÑ\[Xt@Cp[eBNVXeɃZbgs
 *
 * @param   psys			p[eBNVXe[Nւ̃|C^
 * @param   resource		Particle_(Arc)ResourceLoadœǂݍ񂾃\[Xt@C̃|C^
 * @param   vram_free		Vram̎(rbgwFPTC_AUTOTEX_??? | PTC_AUTOPLTT_???)
 *
 * vram_free⑫:[hLɂ邱ƂŁAParticle_SystemExitɃeNX`ŐLVramԂ
 * LoadFilesȌԂɖ߂܂B
 * AParticle_SystemCreateɁAeNX`̃R[obN֐ݒ肵ȂꍇSPLCu
 * Ɉˑ邱ƂɂȂ܂B(ŉĂ񂶂Ȃł傤c)
 *
 * NhXg̓R[obN֐̒łȂkey񂪎Ȃ߁AݖłB
 * ꍇPTC|C^O[oϐoRœnăeNX`̃R[obN֐
 * key擾Â悤ɂKv܂B
 */
//--------------------------------------------------------------
void Particle_ResourceSet(PTC_PTR psys, void *resource, int vram_free)
{
	GF_ASSERT(psys->spl_manager != NULL);
	GF_ASSERT(psys->res_ptcl == NULL);
	
	psys->vram_free = vram_free;
	//eNX`Vramp[^
	if(vram_free & PTC_AUTOTEX_FRM){
		NNS_GfdGetFrmTexVramState(&psys->tex_frm_state);
	}
	else if(vram_free & PTC_AUTOTEX_LNK){
		//2005.07.25()@ݖ(֐RgɂԂĂ܂)
		//Ƃ肠Ă
		int i;
		for(i = 0; i < LNK_TEX_KEY_MAX; i++){
			psys->tex_key[i] = 0;
		}
	}
	//pbgVramp[^
	if(vram_free & PTC_AUTOPLTT_FRM){
		NNS_GfdGetFrmPlttVramState(&psys->pltt_frm_state);
	}
	else if(vram_free & PTC_AUTOPLTT_LNK){
		//2005.07.25()@ݖ(֐RgɂԂĂ܂)
		//Ƃ肠Ă
		int i;
		for(i = 0; i < LNK_PLTT_KEY_MAX; i++){
			psys->pltt_key[i] = 0;
		}
	}
	
	//p[eBN\[X֘At
	psys->res_ptcl = resource;
	//}l[Wɑ΂ăp[eBN\[Xǂݍ
	SPL_Load(psys->spl_manager, psys->res_ptcl);

	// eNX`ǂݍ
	if(psys->user_tex_func == NULL){
		//NitroSystemVRAM}l[WɈˑ
		(void)SPL_LoadTexByVRAMManager(psys->spl_manager);
	}
	else{
		// R[obN֐păeNX`ǂݍ݂OłȂꍇ
		SPL_LoadTexByCallbackFunction(psys->spl_manager, psys->user_tex_func);
	}
	if(psys->user_pltt_func == NULL){
		(void)SPL_LoadTexPlttByVRAMManager(psys->spl_manager);
	}
	else{
		SPL_LoadTexPlttByCallbackFunction(psys->spl_manager, psys->user_pltt_func);
	}

	{
		u32 tex_size;
		tex_size = SPL_GetTexSizeOnResource(psys->res_ptcl);
	#ifdef OSP_PARTICLE_ON
		OS_Printf("eNX`TCY%#x\n", tex_size);
	#endif
	}
}

#ifdef PM_DEBUG		//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//--------------------------------------------------------------
/**
 * @brief   L[͂ɂăJ̈ʒuړ(fobO@\)
 * @param   psys		p[eBNVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DebugCameraMove(PTC_PTR psys)
{
	const fx32 a = FX32_ONE / 0x10;
	int flag = 0;
	
	if((sys.trg & PAD_BUTTON_START) && (sys.cont & PAD_BUTTON_R) && (sys.cont & PAD_BUTTON_L)){
		WeDebugWork.eye = DefaultEye;
		WeDebugWork.up = DefaultUp;
		WeDebugWork.at = DefaultAt;
		OS_Printf("DebugCamera:Wݒɖ߂܂\n");
		return;
	}
	
	if(sys.cont & PAD_BUTTON_R){
		if(sys.cont & PAD_KEY_LEFT){
			WeDebugWork.up.x -= a;
		}
		else if(sys.cont & PAD_KEY_RIGHT){
			WeDebugWork.up.x += a;
		}
		else if(sys.cont & PAD_KEY_UP){
			WeDebugWork.up.y -= a;
		}
		else if(sys.cont & PAD_KEY_DOWN){
			WeDebugWork.up.y += a;
		}
		else if(sys.cont & PAD_BUTTON_X){
			WeDebugWork.up.z -= a;
		}
		else if(sys.cont & PAD_BUTTON_B){
			WeDebugWork.up.z += a;
		}
		else{
			flag++;
		}
		if(flag == 0){
			OS_Printf("v_up: x = %#xd, y = %#xd, z = %#xd\n", WeDebugWork.up.x, WeDebugWork.up.y, WeDebugWork.up.z);
		}
	}
	else if(sys.cont & PAD_BUTTON_L){
		if(sys.cont & PAD_KEY_LEFT){
			WeDebugWork.at.x -= a;
		}
		else if(sys.cont & PAD_KEY_RIGHT){
			WeDebugWork.at.x += a;
		}
		else if(sys.cont & PAD_KEY_UP){
			WeDebugWork.at.y -= a;
		}
		else if(sys.cont & PAD_KEY_DOWN){
			WeDebugWork.at.y += a;
		}
		else if(sys.cont & PAD_BUTTON_X){
			WeDebugWork.at.z -= a;
		}
		else if(sys.cont & PAD_BUTTON_B){
			WeDebugWork.at.z += a;
		}
		else{
			flag++;
		}
		if(flag == 0){
			OS_Printf("at: x = %#xd, y = %#xd, z = %#xd\n", WeDebugWork.at.x, WeDebugWork.at.y, WeDebugWork.at.z);
		}
	}
	else{
		if(sys.cont & PAD_KEY_LEFT){
			WeDebugWork.eye.x -= a;
		}
		else if(sys.cont & PAD_KEY_RIGHT){
			WeDebugWork.eye.x += a;
		}
		else if(sys.cont & PAD_KEY_UP){
			WeDebugWork.eye.y -= a;
		}
		else if(sys.cont & PAD_KEY_DOWN){
			WeDebugWork.eye.y += a;
		}
		else if(sys.cont & PAD_BUTTON_X){
			WeDebugWork.eye.z -= a;
		}
		else if(sys.cont & PAD_BUTTON_B){
			WeDebugWork.eye.z += a;
		}
		else{
			flag++;
		}
		if(flag == 0){
			OS_Printf("eye: x = %#xd, y = %#xd, z = %#xd\n", WeDebugWork.eye.x, WeDebugWork.eye.y, WeDebugWork.eye.z);
		}
	}
}
#endif		//+++++++++++++++++++++++++ PM_DEBUG ++++++++++++++++++++++++++++++++++++++

//--------------------------------------------------------------
/**
 * @brief	`
 */
//--------------------------------------------------------------
void Particle_Draw(PTC_PTR psys)
{
	const MtxFx43 *camera_ptr;

#ifdef PM_DEBUG
	if((sys.cont & PAD_BUTTON_SELECT) && (sys.trg & PAD_BUTTON_START)){
		WeDebugWork.debug_flag ^= WE_DEBUG_BIT_CAMERA;
		if(WeDebugWork.debug_flag & WE_DEBUG_BIT_CAMERA){
			WeDebugWork.eye = DefaultEye;
			WeDebugWork.up = DefaultUp;
			WeDebugWork.at = DefaultAt;
		}
		OS_Printf("fobOJړ = %d\n", WeDebugWork.debug_flag & WE_DEBUG_BIT_CAMERA);
	}
	if(WeDebugWork.debug_flag & WE_DEBUG_BIT_CAMERA){
		DebugCameraMove(psys);
		psys->eye = WeDebugWork.eye;
		psys->v_up = WeDebugWork.up;
		psys->at = WeDebugWork.at;
	}
#endif

	if(psys->camera != NULL){
		GFC_SetCameraView(psys->camera_type, psys->camera);
		GFC_AttachCamera(psys->camera);
		GFC_CameraLookAt();
	}
	
	//O[oXe[gKp
	NNS_G3dGlbFlush();

	// p[eBN`
	camera_ptr = NNS_G3dGlbGetCameraMtx();
	SPL_Draw(psys->spl_manager, camera_ptr);

	if(psys->camera != NULL){
		GFC_PurgeCamera();
	}

	//ĂуO[oXe[gKpBTvSimpleĂŐ^B
	NNS_G3dGlbFlush();
}

//--------------------------------------------------------------
/**
 * @brief	vZ
 */
//--------------------------------------------------------------
void Particle_Calc(PTC_PTR psys)
{
	SPL_Calc(psys->spl_manager);
}

//--------------------------------------------------------------
/**
 * @brief   ۂɓ삵Ăp[eBN}l[W̐擾
 * @retval  sĂ}l[W
 */
//--------------------------------------------------------------
int Particle_GetActionNum(void)
{
	int i, count;
	
	count = 0;
	for(i = 0; i < PARTICLE_GLOBAL_MAX; i++){
		if(ParticleSystemPtr[i] != NULL){
			count++;
		}
	}
	return count;
}

//--------------------------------------------------------------
/**
 * @brief   Ăp[eBNVXeSĂ̕`s
 * @retval  `悪sꂽ
 */
//--------------------------------------------------------------
int Particle_DrawAll(void)
{
	int i, count;
	
	count = 0;
	for(i = 0; i < PARTICLE_GLOBAL_MAX; i++){
		if(ParticleSystemPtr[i] != NULL){
			Particle_Draw(ParticleSystemPtr[i]);
			count++;
		}
	}
	return count;
}

//--------------------------------------------------------------
/**
 * @brief   Ăp[eBNVXeSĂ̌vZs
 * @retval  vZsꂽ
 */
//--------------------------------------------------------------
int Particle_CalcAll(void)
{
	int i, count;
	
	count = 0;
	for(i = 0; i < PARTICLE_GLOBAL_MAX; i++){
		if(ParticleSystemPtr[i] != NULL){
			Particle_Calc(ParticleSystemPtr[i]);
			count++;
		}
	}
	return count;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^𐶐
 *
 * @param   psys			p[eBNVXe[Nւ̃|C^
 * @param   res_no			\[Xԍ
 * @param   init_pos		ʒu(\[Xɐݒ肳ꂽG~b^ItZbgʒuɉZ܂)
 *
 * @retval  ꂽG~b^ւ̃|C^BŃG~b^̏ꍇNULLԂ܂
 */
//--------------------------------------------------------------
EMIT_PTR Particle_CreateEmitter(PTC_PTR psys, int res_no, const VecFx32 *init_pos)
{
	EMIT_PTR emit;
	
	emit = SPL_Create(psys->spl_manager, res_no, init_pos);
	psys->temp_emit = emit;
#if 0
	if(emit != NULL){
		SPL_Terminate(emit);
	}
#endif
	return emit;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^𐶐(callbackɓo^֐s܂)
 *
 * @param   psys			p[eBNVXe[Nւ̃|C^
 * @param   res_no			\[Xԍ
 * @param   callback		G~b^ɌĂяoR[obN֐ւ̃|C^
 * @param   temp_ptr		R[obN֐̒Particle_GetTempPtr֐gŁA
 *                          œn|C^擾鎖o܂B
 *                          Particle_GetTempPtr֐ĝ̓R[obN֐݂̂łB
 *
 * @retval  ꂽG~b^ւ̃|C^BŃG~b^̏ꍇNULLԂ܂
 *
 * ŃG~b^SPL_Createō쐬ꍇANULLĂ̂ŃG~b^̐ݒvO
 * ύX邱Ƃ͂ł܂B̊֐SPLEmitter*ƂR[obNo^
 * ƂŁAőO̎ŃG~b^ւ̃|C^ƂăR[obN֐Ăяo܂B
 * ̃R[obN֐ŃG~b^̐ݒύX邱Ƃ\łB 
 */
//--------------------------------------------------------------
EMIT_PTR Particle_CreateEmitterCallback(PTC_PTR psys, int res_no, pEmitFunc callback, void *temp_ptr)
{
	EMIT_PTR emit;
	
	ParticleTempPtr = temp_ptr;
	emit = SPL_CreateWithInitialize(psys->spl_manager, res_no, callback);
	ParticleTempPtr = NULL;
	psys->temp_emit = emit;

	return emit;
}

//--------------------------------------------------------------
/**
 * @brief   ANeBuȃG~b^̐擾܂
 *
 * @param   psys		p[eBNVXe[Nւ̃|C^
 *
 * @retval  ANeBuȃG~b^
 */
//--------------------------------------------------------------
s32 Particle_GetEmitterNum(PTC_PTR psys)
{
	return SPL_GetEmitterNum(psys->spl_manager);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXe[NǗĂp[eBNSč폜
 * @param   psys		p[eBNVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void Particle_EmitterDeleteAll(PTC_PTR psys)
{
	SPL_DeleteAll(psys->spl_manager);	//p[eBNS폜
}

//--------------------------------------------------------------
/**
 * @brief   ŌɐG~b^̃|C^擾
 *
 * @param   psys		p[eBNVXe[Nւ̃|C^
 *
 * @retval  ŌɐG~b^̃|C^
 */
//--------------------------------------------------------------
EMIT_PTR Particle_TempEmitterPtrGet(PTC_PTR psys)
{
	return psys->temp_emit;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXe[Nɐݒ肳Ăq[v̈̐擪AhX擾
 *
 * @param   psys		p[eBNVXe[Nւ̃|C^
 *
 * @retval  q[v̐擪AhX(Particle_SystemCreateœnAhXԂ܂)
 */
//--------------------------------------------------------------
void * Particle_HeapPtrGet(PTC_PTR psys)
{
	return psys->heap_start;
}

//--------------------------------------------------------------
/**
 * @brief   J̈ʒuxNg擾
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 * @param   eye		l
 */
//--------------------------------------------------------------
void Particle_GetEye(PTC_PTR psys, VecFx32 *eye)
{
	*eye = psys->eye;
}

//--------------------------------------------------------------
/**
 * @brief   J̈ʒuxNgZbg
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 * @param   eye		l
 *
 * GFLib̃JgpĂꍇ͂͋@\܂
 */
//--------------------------------------------------------------
void Particle_SetEye(PTC_PTR psys, const VecFx32 *eye)
{
	psys->eye = *eye;
}

//--------------------------------------------------------------
/**
 * @brief   J̏xNg擾
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 * @param   v_up		l
 */
//--------------------------------------------------------------
void Particle_GetVup(PTC_PTR psys, VecFx32 *v_up)
{
	*v_up = psys->v_up;
}

//--------------------------------------------------------------
/**
 * @brief   J̏xNgZbg
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 * @param   v_up		l
 */
//--------------------------------------------------------------
void Particle_SetVup(PTC_PTR psys, const VecFx32 *v_up)
{
	psys->v_up = *v_up;
	GFC_SetCamUp(v_up, psys->camera);
}

//--------------------------------------------------------------
/**
 * @brief   e|[NɃZbgĂ|C^擾
 * @retval  e|[NɃZbgĂ|C^
 *
 * G~b^쐬̃R[obN֐ł̂ݎgp\łB
 */
//--------------------------------------------------------------
void * Particle_GetTempPtr(void)
{
	SDK_ASSERT(ParticleTempPtr != NULL);
	return ParticleTempPtr;
}

//--------------------------------------------------------------
/**
 * @brief   ftHgJʒuxNg擾
 * @param   eye		l
 */
//--------------------------------------------------------------
void Particle_GetDefaultEye(VecFx32 *eye)
{
	*eye = DefaultEye;
}

//--------------------------------------------------------------
/**
 * @brief   ftHgJ̏xNg擾
 * @param   eye		l
 */
//--------------------------------------------------------------
void Particle_GetDefaultUp(VecFx32 *v_up)
{
	*v_up = DefaultUp;
}

//--------------------------------------------------------------
/**
 * @brief   ftHgJ̏œ_ւ̃xNg擾
 * @param   eye		l
 */
//--------------------------------------------------------------
void Particle_GetDefaultAt(VecFx32 *at)
{
	*at = DefaultAt;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXeĂJ̃|C^擾܂
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 * @retval  GFJւ̃|C^(Ǝ̃JgpĂȂꍇNULL)
 */
//--------------------------------------------------------------
GF_CAMERA_PTR Particle_GetCameraPtr(PTC_PTR ptc)
{
	return ptc->camera;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXẽJˉeZbg
 * @param   ptc				p[eBNVXe[Nւ̃|C^
 * @param   camera_type		GF_CAMERA_PERSPECTIV or GF_CAMERA_ORTHO
 */
//--------------------------------------------------------------
void Particle_CameraTypeSet(PTC_PTR ptc, int camera_type)
{
	ptc->camera_type = camera_type;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNVXẽJˉe擾
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 * @retval  GF_CAMERA_PERSPECTIV or GF_CAMERA_ORTHO
 */
//--------------------------------------------------------------
u8 Particle_CameraTypeGet(PTC_PTR ptc)
{
	return ptc->camera_type;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̑x擾܂
 *
 * @param   emit	G~b^ւ̃|C^
 * @param   vel		l
 */
//--------------------------------------------------------------
void SplSub_GetEmitterVelocity(EMIT_PTR emit, VecFx32 *vel)
{
	*vel = emit->emtr_vel;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̑xZbg܂
 *
 * @param   emit	G~b^ւ̃|C^
 * @param   vel		Zbgl
 */
//--------------------------------------------------------------
void SplSub_SetEmitterVelocity(EMIT_PTR emit, const VecFx32 *vel)
{
	SPL_SetEmitterVelocity(emit, vel);
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̌擾
 * @param   emit		G~b^ւ̃|C^
 * @param   vec			l
 */
//--------------------------------------------------------------
void SplSub_GetEmitterAxis(EMIT_PTR emit, VecFx16 *vec)
{
	*vec = emit->axis;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̑傫擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  傫
 */
//--------------------------------------------------------------
fx32 SplSub_GetEmitterRadius(EMIT_PTR emit)
{
	return emit->radius;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̑S擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  S
 */
//--------------------------------------------------------------
fx16 SplSub_GetEmitterInitVelocityPos(EMIT_PTR emit)
{
	return emit->init_vel_mag_pos;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̎擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  
 */
//--------------------------------------------------------------
fx16 SplSub_GetEmitterInitVelocityAxis(EMIT_PTR emit)
{
	return emit->init_vel_mag_axis;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̊{XP[擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  {XP[
 */
//--------------------------------------------------------------
fx16 SplSub_GetEmitterBaseScale(EMIT_PTR emit)
{
	return emit->base_scl;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̐Ԋu擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  Ԋu
 */
//--------------------------------------------------------------
u16 SplSub_GetEmitterEmissionInterval(EMIT_PTR emit)
{
	return emit->etc.gen_intvl;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̊{擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  {
 */
//--------------------------------------------------------------
u16 SplSub_GetEmitterBaseAlpha(EMIT_PTR emit)
{
	return emit->etc.base_alp;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̃O[oF擾
 * @param   emit		G~b^ւ̃|C^
 * @retval  O[oF
 */
//--------------------------------------------------------------
GXRgb SplSub_GetEmitterGlobalColor(EMIT_PTR emit)
{
	return emit->clr;
}

//--------------------------------------------------------------
/**
 * @brief   w肵G~b^̕o[gݒ肵܂
 *
 * @param   emit		G~b^ւ̃|C^
 * @param   gen_num		ݒo[g
 *
 * SPL_SetEmitterGenerationRatio֐Ȃ悤Ȃ̂ő
 */
//--------------------------------------------------------------
void SplSub_SetEmitterGenerationRatio(EMIT_PTR emit, fx32 gen_num)
{
	emit->p_res->p_base->gen_num = gen_num;
}

//--------------------------------------------------------------
/**
 * @brief   o[g擾܂
 * @param   emit		G~b^ւ̃|C^
 * @retval  o[g
 */
//--------------------------------------------------------------
fx32 SplSub_GetEmitterGenerationRatio(EMIT_PTR emit)
{
	return emit->p_res->p_base->gen_num;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^݈̌ʒu擾
 *
 * @param   p_emtr		G~b^ւ̃|C^
 * @param   p_pos		擾W
 */
//--------------------------------------------------------------
void SplSub_GetEmitterPosition(EMIT_PTR emit, VecFx32 * p_pos)
{
	*p_pos = emit->emtr_pos;
}

//--------------------------------------------------------------
/**
 * @brief   G~b^̃ftHgʒu擾
 *
 * @param   emit		G~b^ւ̃|C^
 * @param   p_pos		擾W
 */
//--------------------------------------------------------------
void SplSub_GetEmitterBasePosition(EMIT_PTR emit, VecFx32 * p_pos)
{
	*p_pos = emit->p_res->p_base->pos;
}


// ----------------------------------------------------------------------------
//
//
//
//
//
//	 Field n̓Ǝ֐S
//		p[eBNCuprivateňϐ
//		O爵Ă̂ŕs邩Ȃ
//
//
//
//
// ----------------------------------------------------------------------------
#if 0

typedef struct SPLGravity{				// d̓tB[h
    VecFx16 mag;
    u16 reserved0;
} SPLGravity;

typedef struct SPLRandom{				// _tB[h
    VecFx16 mag;
    u16 intvl;
} SPLRandom;

typedef struct SPLMagnet{				// }OlbgtB[h
    VecFx32 pos;
    fx16    mag;
    u16     reserved0;
} SPLMagnet;

typedef struct SPLSpin{					// XstB[h
    u16 radian;
    u16 axis_type;
} SPLSpin;

typedef struct SPLSimpleCollisionField{	// VvRWtB[h
    fx32 y ; // CxgNyʂ̒l
    fx16 coeff_bounce ;
    
    struct {
        u16 eventtype:2 ;
        u16 global:1 ;
        u16 reserved:13 ;
    } etc ;
} SPLSimpleCollisionField ;

typedef struct SPLConvergence{			// ʒuɉZtB[hi}Olbg̈j
    VecFx32 pos  ; // z񂹂ꏊ
    fx16    ratio; // z񂹂鋭
    u16     reserved0;
} SPLConvergence ;

void spl_calc_gravity(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
void spl_calc_random(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
void spl_calc_magnet(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
void spl_calc_spin(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
void spl_calc_scfield(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
void spl_calc_convergence(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );

#endif

enum {
	SPL_FLD_TYPE_GRAVITY = 0,		///< d
	SPL_FLD_TYPE_RANDOM,			///< _
	SPL_FLD_TYPE_MAGNET,			///< }Olbg
	SPL_FLD_TYPE_SPIN,				///< Xs
	SPL_FLD_TYPE_SIMPLE_COLL,		///< VvRW
	SPL_FLD_TYPE_CONVERGENCE,		///< Ro[WFX
};


//--------------------------------------------------------------
/**
 * @brief	SPL_FieldObject ̃|C^擾
 *
 * @param	emit					G~b^[
 * @param	field_type				擾tB[h̃^Cv
 *
 * @retval	static const void*		|C^
 *
 */
//--------------------------------------------------------------
static const void* SPLFieldObj_PointerSearch(EMIT_PTR emit, int field_type)
{
	int i;
	int num;
	SPLField* p_field;
	
	num = emit->p_res->fld_num;
	
	if (num == 0){
		return NULL;
	}
	
	for (i = 0; i < num; i++){
		
		p_field = &emit->p_res->fld_ary[i];
		
		if (p_field == NULL){ continue; }
		
		switch(field_type){
		case SPL_FLD_TYPE_GRAVITY:
			if (p_field->p_exec == spl_calc_gravity){
				return p_field->p_obj;
			}
			continue;
		case SPL_FLD_TYPE_RANDOM:
			if (p_field->p_exec == spl_calc_random){
				return p_field->p_obj;
			}
			continue;
		case SPL_FLD_TYPE_MAGNET:
			if (p_field->p_exec == spl_calc_magnet){
				return p_field->p_obj;
			}
			continue;
		case SPL_FLD_TYPE_SPIN:
			if (p_field->p_exec == spl_calc_spin){
				return p_field->p_obj;
			}
			continue;
		case SPL_FLD_TYPE_SIMPLE_COLL:
			if (p_field->p_exec == spl_calc_scfield){
				return p_field->p_obj;
			}
			break;
		case SPL_FLD_TYPE_CONVERGENCE:
			if (p_field->p_exec == spl_calc_convergence){
				return p_field->p_obj;
			}
			continue;
		default:
			return NULL;
		}		
	}
	
	return NULL;
}

// -----------------------------------------
//
//	d
//
//--------------------------------------------------------------
///< d͂̍W
void SplSub_SetSPLField_GravityPos(EMIT_PTR emit, VecFx16 *mag)
{
	SPLGravity* p_obj;
	
	p_obj = (SPLGravity*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_GRAVITY);
	
	if (p_obj == NULL){ return; }
	
	p_obj->mag = *mag;
}

void SplSub_GetSPLField_GravityPos(EMIT_PTR emit, VecFx16 *mag)
{
	SPLGravity* p_obj;
	
	p_obj = (SPLGravity*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_GRAVITY);
	
	if (p_obj == NULL){
		VecFx16 err_p = { 0,0,0 };
		*mag = err_p;
		return;
	}
			
	*mag = p_obj->mag;
}


// -----------------------------------------
//
//	_
//
// -----------------------------------------
///< gKv邩sȂ̂łƂ肠
void SplSub_SetSPLField_RandomMag(EMIT_PTR emit, VecFx16* mag)
{
}
void SplSub_GetSPLField_RandomMag(EMIT_PTR emit, VecFx16* mag)
{
}
void SplSub_SetSPLField_RandomIntvl(EMIT_PTR emit, u16* mag)
{
}
void SplSub_GetSPLField_RandomIntvl(EMIT_PTR emit, u16* mag)
{
}

// -----------------------------------------
//
// }Olbg
//
// -----------------------------------------
///< }Olbg̍W
void SplSub_SetSPLField_MagnetPos(EMIT_PTR emit, VecFx32* p_pos)
{
	SPLMagnet* p_obj;
	
	p_obj = (SPLMagnet*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_MAGNET);
	
	if (p_obj == NULL){ return; }
			
	p_obj->pos = *p_pos;
}

void SplSub_GetSPLField_MagnetPos(EMIT_PTR emit, VecFx32* p_pos)
{
	SPLMagnet* p_obj;
	
	p_obj = (SPLMagnet*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_MAGNET);
	
	if (p_obj == NULL){
		VecFx32 err_p = { 0,0,0 };
		*p_pos = err_p;
		return;
	}
	
	*p_pos = p_obj->pos;
}

///< }Olbg̃}O
void SplSub_SetSPLField_MagnetMag(EMIT_PTR emit, fx16* mag)
{
	SPLMagnet* p_obj;
	
	p_obj = (SPLMagnet*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_MAGNET);
	
	if (p_obj == NULL){ return; }
			
	p_obj->mag = *mag;
}

void SplSub_GetSPLField_MagnetMag(EMIT_PTR emit, fx16* mag)
{
	SPLMagnet* p_obj;
	
	p_obj = (SPLMagnet*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_MAGNET);
	
	if (p_obj == NULL){
		*mag = 0;
		return;
	}

	*mag = p_obj->mag;
}


// -----------------------------------------
//
//	Xs
//
// -----------------------------------------
///< Xs̊px
void SplSub_SetSPLField_SpinRad(EMIT_PTR emit, u16* rad)
{
	SPLSpin* p_obj;
	
	p_obj = (SPLSpin*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_SPIN);
	
	if (p_obj == NULL){ return; }
	
	p_obj->radian = *rad;
}

void SplSub_GetSPLField_SpinRad(EMIT_PTR emit, u16* rad)
{
	SPLSpin* p_obj;
	
	p_obj = (SPLSpin*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_SPIN);
	
	if (p_obj == NULL){
		*rad = 0;
		return;
	}
	
	*rad = p_obj->radian;
}

///< Xs̕^Cv
void SplSub_SetSPLField_SpinAxisType(EMIT_PTR emit, u16* axis_type)
{
	SPLSpin* p_obj;
	
	p_obj = (SPLSpin*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_SPIN);
	
	if (p_obj == NULL){ return; }
	
	p_obj->axis_type = *axis_type;
}

void SplSub_GetSPLField_SpinAxisType(EMIT_PTR emit, u16* axis_type)
{
	SPLSpin* p_obj;
	
	p_obj = (SPLSpin*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_SPIN);
	
	if (p_obj == NULL){
		*axis_type = 0;
		return;
	}
	
	*axis_type = p_obj->axis_type;
}

// -----------------------------------------
//
//	VvRW
//
// -----------------------------------------
///< 삷Kv邩sȂ̂ŁAƂ肠
void SplSub_SetSPLField_SimpleCollisionYPos(EMIT_PTR emit, fx32* y)
{
}
void SplSub_GetSPLField_SimpleCollisionYPos(EMIT_PTR emit, fx32* y)
{
}
void SplSub_SetSPLField_SimpleCollisionCoeffBounce(EMIT_PTR emit, fx16* coeff_bounce)
{
}
void SplSub_GetSPLField_SimpleCollisionCoeffBounce(EMIT_PTR emit, fx16* coeff_bounce)
{
}
void SplSub_SetSPLField_SimpleCollisionEventType(EMIT_PTR emit, u16* ev_type)
{
}
void SplSub_GetSPLField_SimpleCollisionEventType(EMIT_PTR emit, u16* ev_type)
{
}
void SplSub_SetSPLField_SimpleCollisionGlobal(EMIT_PTR emit, u16* global)
{
}
void SplSub_GetSPLField_SimpleCollisionGlobal(EMIT_PTR emit, u16* global)
{
}

// -----------------------------------------
//
//	Ro[WFX
//
// -----------------------------------------
///< Ro[WFX̍W
void SplSub_SetSPLField_ConvergencePos(EMIT_PTR emit, VecFx32* p_pos)
{
	SPLConvergence* p_obj;
	
	p_obj = (SPLConvergence*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_CONVERGENCE);
	
	if (p_obj == NULL){ return; }
	
	p_obj->pos = *p_pos;
}

void SplSub_GetSPLField_ConvergencePos(EMIT_PTR emit, VecFx32* p_pos)
{
	SPLConvergence* p_obj;
	
	p_obj = (SPLConvergence*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_CONVERGENCE);
	
	if (p_obj == NULL){
		VecFx32 err_p = { 0,0,0 };
		*p_pos = err_p;
		return;
	}
	
	*p_pos = p_obj->pos;
}

///< Ro[WFX̋
void SplSub_SetSPLField_ConvergenceRatio(EMIT_PTR emit, fx16* ratio)
{
	SPLConvergence* p_obj;
	
	p_obj = (SPLConvergence*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_CONVERGENCE);
	
	if (p_obj == NULL){ return; }
	
	p_obj->ratio = *ratio;
}

void SplSub_GetSPLField_ConvergenceRatio(EMIT_PTR emit, fx16* ratio)
{
	SPLConvergence* p_obj;
	
	p_obj = (SPLConvergence*)SPLFieldObj_PointerSearch(emit, SPL_FLD_TYPE_CONVERGENCE);
	
	if (p_obj == NULL){
		*ratio = 0;
		return;
	}
	
	*ratio = p_obj->ratio;
}
