//============================================================================================
/**
 * @file	pm_str.c
 * @brief	֘A
 * @author	Hiroyuki Nakamura
 * @date	2004.11.02
 *
 *	|P`faڐA
 *
 */
//============================================================================================
#define PM_STR_H_GLOBAL

#include "common.h"
//#include "fntsys.h"

#include "system/pm_str.h"


//============================================================================================
//	V{`
//============================================================================================
#define	TEMP_BUF_MAX	( 16 )
#define	MSG_EXP_BUF_MAX	( 64 )


//============================================================================================
//	vg^Cv錾
//============================================================================================


//============================================================================================
//	O[oϐ
//============================================================================================
static const STRCODE* TmpBufAdrs[TEMP_BUF_MAX] = {};
STRCODE	MsgExpandBuffer[MSG_EXP_BUF_MAX] = {};

static const STRCODE n_ch[] = {n0_,n1_,n2_,n3_,n4_,n5_,n6_,n7_,n8_,n9_,A__,B__,C__,D__,E__,F__};

static const int n_max[] = 
{
	1,
	10,
	100,
	1000,
	10000,
	100000,
	1000000,
	10000000,
	100000000,
	1000000000,
};


//============================================================================================
//	񑀍
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Rs[
 *
 * @param	to_str		Rs[obt@
 * @param	from_str	f[^
 *
 * @return	obt@ɃRs[f[^ŌEOM_ւ̃|C^
 *
 *	f[^Ȃ(f[^擪EOM_)ꍇA
 *	EOM_obt@擪ɏ݁Aւ̃|C^Ԃ
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_strcpy( STRCODE* to_str, const STRCODE* from_str )
{
	while( *from_str != EOM_ ){
		*to_str = *from_str;
		to_str++;
		from_str++;
	}
	*to_str = EOM_;
	return to_str;
}

//--------------------------------------------------------------------------------------------
/**
 * Rs[iwj
 *
 * @param	to_str		Rs[obt@
 * @param	from_str	f[^
 * @param	len			Rs[镶
 *
 * @return	uRs[obt@ + Rs[镶vւ̃|C^
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_strncpy( STRCODE* to_str, const STRCODE* from_str, u32 len )
{
	u32	i;

	for( i=0; i<len; i++ ){
		to_str[i] = from_str[i];
	}
	return &to_str[len];
}

//--------------------------------------------------------------------------------------------
/**
 * A
 *
 * @param	to_str		Af[^iramɂ邱ƁIIj
 * @param	from_str	Af[^
 *
 * @return	Ãobt@̃f[^EOM_ւ̃|C^
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_strcat( STRCODE* to_str, const STRCODE* from_str )
{
	while( *to_str != EOM_ ){
		to_str++;
	}
	return PM_strcpy( to_str, from_str );
}

//--------------------------------------------------------------------------------------------
/**
 * Aiwj
 *
 * @param	to_str		Af[^iramɂ邱ƁIIj
 * @param	from_str	Af[^
 * @param	len			A镶
 *
 * @return	Ãobt@̃f[^ւ̃|C^Ԃ
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_strncat( STRCODE* to_str, const STRCODE* from_str, u32 len )
{
	while( *to_str != EOM_ ){
		to_str++;
	}
	return PM_strncpy( to_str, from_str, len );
}

//--------------------------------------------------------------------------------------------
/**
 * 񒷎擾
 *
 * @param	str		Ώەւ̃|C^
 *
 * @return	Ώە̒iEOM_܂ł̕jԂ
 */
//--------------------------------------------------------------------------------------------
u32 PM_strlen( const STRCODE* str )
{
	u32 len = 0;

	while( str[len] != EOM_ ){
		len++;
	}
	return len;
}

//--------------------------------------------------------------------------------------------
/**
 * r
 *
 * @param	s		Ώەւ̃|C^
 * @param	t		Ώەւ̃|C^
 *
 * @retval	"0 = v"
 * @retval	"1 = sv"
 *
 * @li	bW֐ƈႢ̔r͂ĂȂ
 */
//--------------------------------------------------------------------------------------------
BOOL PM_strcmp( const STRCODE* s, const STRCODE* t )
{
	while( *s == *t ){
		if( *s == EOM_ ){ return 0; }
		s++;
		t++;
	}
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * riwj
 *
 * @param	s		Ώەւ̃|C^
 * @param	t		Ώەւ̃|C^
 * @param	n		r镶
 *
 * @retval	"0 = v"
 * @retval	"1 = sv"
 *
 * @li	bW֐ƈႢ̔r͂ĂȂ
 */
//--------------------------------------------------------------------------------------------
BOOL PM_strncmp( const STRCODE* s, const STRCODE* t, u32 n )
{
	while( *s == *t ){
		if( n == 0 ){ return 0; }
		if( *s == EOM_ && *t == EOM_ ){ return 0; }
		n--;
		s++;
		t++;
	}
	return 1;
}

//--------------------------------------------------------------------------------------------
/**	
 * ̓`FbN
 *
 * @param	str		Ώەւ̃|C^
 * @param	n		`FbN镶
 *
 * 
 * @retval	"1 = ͂"
 * @retval	"0 = ͂Ȃ"
 *
 * @li	w肳ꂽobt@ɋ󔒂EOMȊÕR[h܂܂Ă邩`FbN
 */
//--------------------------------------------------------------------------------------------
BOOL PM_strnchk( STRCODE* str, u32 n )
{
	u32	i;

	for( i=0; i<n; i++ ){
		if( (str[i] != spc_) && (str[i] != EOM_) ){
			return 1;
		}
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * obt@w蕶R[hŃNA
 *
 * @param	str		obt@
 * @param	code	R[h
 * @param	len		NA镶
 *
 * @return	EOM_ AhX
*/
//--------------------------------------------------------------------------------------------
STRCODE* PM_strclear( STRCODE* str, STRCODE code, u32 len )
{
	u32 i;

	for( i=0; i<len; i++ ){
		str[i] = code;
	}
//	str[i] = EOM_;	//+1̏ꏊɏ݂ɍŝŃRgAEg
					//05.11.18 by iwasawa

	return &str[i];
}

//--------------------------------------------------------------------------------------------
/**
 * obt@EOM_R[hŃNA
 *
 * @param	str		obt@
 * @param	len		NA镶
 *
 * @return	NAI[EOM_ AhX
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_strclearEOM_( STRCODE* str, u32 len )
{
	return PM_strclear( str, EOM_, len );
}

//--------------------------------------------------------------------------------------------
/**
 * Rs[Aw蕶ɖȂAw蕶R[hŃNA
 *
 * @param	to		Rs[敶obt@
 * @param	from	Rs[
 * @param	code	NAR[h
 * @param	len		Ŝ̕
 *
 * @return	EOM_ AhX
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_strcpy_clear( STRCODE* to, const STRCODE* from, STRCODE code, u32 len )
{
	while( *from != EOM_ ){
		if( len == 0 ){ break; }
		*to = *from;
		to++;
		from++;
		len--;
	}
	if( len != 0 ){
		while( len-- ){
			*to = code;
			to++;
		}
	}
	*to = EOM_;

	return to;
}


//============================================================================================
//	l
//============================================================================================
#define NUM_STR(n)	( n>=10 ? hate_ : n_ch[n] )		///<10i\擾
#define HEX_STR(n)	( n>=16 ? hate_ : n_ch[n] )		///<16i\擾

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPOij
 *
 * @param	buf		WJꏊ
 * @param	num		l
 * @param	type	ϊ
 * @param	keta	
 *
 * @return	ľɏEOM_ւ̃|C^
 *
 * @li	type = NUM_MODE_LEFT	l
 * @li	type = NUM_MODE_SPACE	ElAȂ͋
 * @li	type = NUM_MODE_ZERO	ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_NumMsgSet( STRCODE* buf, s32 num, u32 type, u32 keta )
{
	u32	i;
	u32 num_f;
	u32	num_i;

	for( i=n_max[keta-1]; i>0; i/=10 ){
		num_i = (u16)( num / i );
		num_f = (u32)( num - ( i * num_i ) );
		if( type == NUM_MODE_ZERO ){
			*buf = (u16)NUM_STR( num_i );
			buf++;
		}else if( num_i != 0 || i==1 ){
			type = NUM_MODE_ZERO;
			*buf = (u16)NUM_STR( num_i );
			buf++;
		}else if( type == NUM_MODE_SPACE ){
			*buf = spc_;
			buf++;
		}
		num = num_f;
	}
	*buf = EOM_;

	return buf;
}

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPOiA}CiX͂Ȃj
 *
 * @param	buf		WJꏊ
 * @param	num		l
 * @param	type	ϊ
 * @param	keta	
 *
 * @return	ľɏEOM_ւ̃|C^
 *
 * @li	type = NUM_MODE_LEFT	l
 * @li	type = NUM_MODE_SPACE	ElAȂ͋
 * @li	type = NUM_MODE_ZERO	ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_NumMsgSetUnsigned( STRCODE* buf, u32 num, u32 type, u32 keta )
{
	u32	i;
	u32 num_f;
	u16	num_i;

	for( i=n_max[keta-1]; i>0; i/=10 ){
		num_i = (u16)( num / i );
		num_f = (u32)( num - ( i * num_i ) );
		if( type == NUM_MODE_ZERO ){
			*buf = (u16)NUM_STR( num_i );
			buf++;
		}else if( num_i != 0 || i==1 ){
			type = NUM_MODE_ZERO;
			*buf = (u16)NUM_STR( num_i );
			buf++;
		}else if( type == NUM_MODE_SPACE ){
			*buf = spc_;
			buf++;
		}
		num = num_f;
	}
	*buf = EOM_;

	return buf;
}

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPUij
 *
 * @param	buf		WJꏊ
 * @param	num		l
 * @param	type	ϊ
 * @param	keta	
 *
 * @return	ľɏEOM_ւ̃|C^
 *
 * @li	type = NUM_MODE_LEFT	l
 * @li	type = NUM_MODE_SPACE	ElAȂ͋
 * @li	type = NUM_MODE_ZERO	ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_HexNumMsgSet( STRCODE* buf, s32 num, u32 type, u32 keta )
{
	u32	i,max;
	u32	num_i,num_f;

	max = 1;
	for( i=1; i<keta; i++ ){
		max *= 16;
	}

	for( i=max; i>0; i/=16 ){
		num_i = num / i;
		num_f = num % i;
		if( type == NUM_MODE_ZERO ){
			*buf = (STRCODE)HEX_STR( num_i );
			buf++;
		}else if( num_i != 0 || i==1 ){
			type = NUM_MODE_ZERO;
			*buf = (STRCODE)HEX_STR( num_i );
			buf++;
		}else if( type == NUM_MODE_SPACE ){
			*buf = spc_;
			buf++;
		}
		num = num_f;
	}
	*buf = EOM_;

	return buf;
}


//============================================================================================
//	bZ[WWJ[`
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * bZ[WWJiS_MSG_݁j
 *
 * @param	buf		WJ
 * @param	data	bZ[W
 *
 * @return	EOM_̃AhX
 */
//--------------------------------------------------------------------------------------------
STRCODE* PM_MsgExpand( STRCODE* buf, const STRCODE* data )
{
	STRCODE	c;

	while(1){
		c = *data;
		data++;
		switch( c ){
		case EOM_:
			*buf = EOM_;
			return buf;
/*
		case I_MSG_:
			buf = PM_MsgExpand( buf, GetIndirectString( *data ) );
			data++;
			break;
*/
		case S_MSG_:
			buf = PM_MsgExpand( buf, TmpBufAdrs[*data] );
			data++;
			break;
/*
		case CTRL_:
			*(buf++) = c;
			c = *data; data++;
			*(buf++) = c;
			switch ( c ) {
			// p[^Ȃ
			case C_FNML_:
			case C_TRGWAIT_:
			case C_CLR_:
			case C_LANG_JP:
			case C_LANG_DEF:
			case C_MUSPAUSE_:
			case C_MUSCONTINUE_:
				break;
			// p[^3
			case C_ACOL_:
				*(buf++) = *(data++);
				*(buf++) = *(data++);
				*(buf++) = *(data++);
				break;
			// p[^2
			case C_MUSPLAY_:
				*(buf++) = *(data++);
				*(buf++) = *(data++);
				break;
			// ʏ̓p[^1
			default:
				*(buf++) = *(data++);
				break;
			}
			break;
*/
		default:
			*buf = c;
			buf++;
		}
	}
	return NULL;
}


//============================================================================================
//	S_MSG_
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * S_MSG_
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MsgExp_Init(void)
{
	MI_CpuFill32( (void *)TmpBufAdrs, NULL, TEMP_BUF_MAX * 4 );
}

//--------------------------------------------------------------------------------------------
/**
 * S_MSG_ݒ菈
 *
 * @param	id		ID
 * @param	str		Zbg镶
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MsgExp_AdrsSet( u32 id, const STRCODE* str )
{
	if( id >= TEMP_BUF_MAX ){
#ifdef	OSP_ERR_MSGEXP_ADRS_SET		// S_MSG_̐ݒ莸s
		OS_Printf( "Error : MsgExp_AdrsSet(...) / id >= TEMP_BUF_MAX\n" );
#endif	// OSP_ERR_MSGEXP_ADRS_SET
		return;
	}
	TmpBufAdrs[id] = str;
}











//============================================================================================
//	str֘Ȁ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊ ( str )
 *
 * @param	str		i[ꏊ
 * @param	num		ϊ鐔l
 * @param	keta	
 *
 * @return	none
 *
 * @li	t@C̍쐬ȂǂɎgp֐B
 * @li	keta = 0  : l
 * @li	keta != 0 : 0Ŗ߂
 */
//--------------------------------------------------------------------------------------------
void StrNumSet( char * str, u32 num, u32 keta )
{
	char zero[10];
	u32	num_i;
	u32	i;

	if( keta == 0 ){
		sprintf( str, "%d", num );
	}else{
		memset( zero, '\0', 10 );
		for( i=n_max[keta-1]; i>0; i/=10 ){
			num_i = num / i;
			sprintf( zero, "%d", num_i );
			strcat( str, zero );
			num = num - ( i * num_i );
		}
	}
}











