//============================================================================================
/**
 * @file	pms_data.c
 * @bfief	ȈՕ́iȈՉbf[^ƒ^gݍ킹́j
 * @author	taya
 * @date	05.02.03
 */
//============================================================================================
#include "common.h"
#include "gflib\strbuf_family.h"
#include "system\buflen.h"
#include "system\wordset.h"
#include "system\pms_word.h"
#include "system\msgdata_util.h"
#include "msgdata\msg.naix"

#include "system\pms_data.h"


//--------------------------------------------------------------
/**
 *	萔
 */
//--------------------------------------------------------------
#define SENTENCE_ID_DEFAULT		(0)


//--------------------------------------------------------------
/**
 *
 */
//--------------------------------------------------------------
static const u16 SentenceDatID[] = {
	NARC_msg_pmss_ready_dat,
	NARC_msg_pmss_won_dat,
	NARC_msg_pmss_lost_dat,
	NARC_msg_pmss_mail_dat,
	NARC_msg_pmss_union_dat,

};

//==============================================================
// Prototype
//==============================================================
static u32 get_include_word_max( u32 sentence_type, u32 sentence_id );





//------------------------------------------------------------------
/**
 * 
 *
 * @param   pms		ȈՕ͍\̂ւ̃|C^
 *
 */
//------------------------------------------------------------------
void PMSDAT_Init( PMS_DATA* pms, u32 sentence_type )
{
	int i;

	pms->sentence_type = sentence_type;
	pms->sentence_id = SENTENCE_ID_DEFAULT;

	for(i=0; i<PMS_WORD_MAX; i++)
	{
		pms->word[i] = PMS_WORD_NULL;
	}

}
//------------------------------------------------------------------
/**
 * ȈՕ̓f[^Â܂ܕ\ł镶𐶐
 *
 * @param   pms		
 * @param   heapID		
 *
 * @retval  STRBUF*		
 */
//------------------------------------------------------------------
STRBUF* PMSDAT_ToString( const PMS_DATA* pms, u32 heapID )
{
	STRBUF*  wordbuf;
	STRBUF*  sentence;
	WORDSET*  wordset;
	MSGDATA_MANAGER*   msgman;
	int i;

	wordbuf = STRBUF_Create(BUFLEN_PMS_WORD, heapID);
	wordset = WORDSET_Create(heapID);

	for(i=0; i<PMS_WORD_MAX; i++)
	{
		if( pms->word[i] != PMS_WORD_NULL )
		{
			PMSW_GetStr( pms->word[i], wordbuf );
			WORDSET_RegisterWord( wordset, i, wordbuf, PM_NEUTRAL, TRUE, PM_LANG );
		}
		else
		{
			break;
		}
	}

	msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, SentenceDatID[pms->sentence_type], heapID );
	sentence = MSGDAT_UTIL_AllocExpandString( wordset, msgman, pms->sentence_id, heapID );

	MSGMAN_Delete(msgman);
	WORDSET_Delete(wordset);
	STRBUF_Delete(wordbuf);

	return sentence;
}

//------------------------------------------------------------------
/**
 * ȈՉb̓f[^A^OWJO̕擾
 * i炭ĝ͓͉ʂ̂݁j
 *
 * @param   pms		
 * @param   heapID		
 *
 * @retval  STRBUF*		
 */
//------------------------------------------------------------------
STRBUF*  PMSDAT_GetSourceString( const PMS_DATA* pms, u32 heapID )
{
	return MSGDAT_GetStrDirectAlloc( ARC_MSG, SentenceDatID[pms->sentence_type], pms->sentence_id, heapID );
}


//------------------------------------------------------------------
/**
 * LȓeɂȂĂ邩`FbN
 *
 * @param   pms		
 *
 * @retval  BOOL	
 */
//------------------------------------------------------------------
BOOL PMSDAT_IsEnabled( const PMS_DATA* pms )
{
	u32 word_max, i;

	word_max = get_include_word_max( pms->sentence_type, pms->sentence_id );
	for(i=0; i<word_max; i++)
	{
		if( pms->word[i] == PMS_WORD_NULL )
		{
			return FALSE;
		}
	}
	return TRUE;
}

//------------------------------------------------------------------
/**
 * ͂Ɋ܂܂PꐔԂ
 *
 * @param   sentence_type		
 * @param   sentence_id		
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
static u32 get_include_word_max( u32 sentence_type, u32 sentence_id )
{
	STRBUF  *buf;
	const STRCODE* cp;
	u32 cnt;

	GF_ASSERT( sentence_type < PMS_TYPE_MAX );
	GF_ASSERT( sentence_id < PMSDAT_GetSentenceIdMax( sentence_type ) );

	buf = MSGDAT_GetStrDirectAlloc( ARC_MSG, SentenceDatID[sentence_type], sentence_id, HEAPID_BASE_SYSTEM );
	cp = STRBUF_GetStringCodePointer( buf );
	cnt = 0;
	while( *cp != EOM_ )
	{
		if( *cp == _CTRL_TAG )
		{
			if( STRCODE_CheckWordSetTagType( cp ) )
			{
				cnt++;
			}
			cp = STRCODE_SkipTag( cp );
		}
		else
		{
			cp++;
		}
	}
	STRBUF_Delete(buf);
	return cnt;
}

//------------------------------------------------------------------
/**
 * Pio[Ԃ
 *
 * @param   pms		
 * @param   pos		
 *
 * @retval  PMS_WORD		
 */
//------------------------------------------------------------------
PMS_WORD  PMSDAT_GetWordNumber( const PMS_DATA* pms, int pos )
{
	return pms->word[ pos ];
}
//------------------------------------------------------------------
/**
 * ݒ肳Ă镶̓^Cv擾
 *
 * @param   pms		
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32  PMSDAT_GetSentenceType( const PMS_DATA* pms )
{
	return pms->sentence_type;
}
//------------------------------------------------------------------
/**
 * ݒ肳Ă镶IDԂ
 *
 * @param   pms		
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
u32 PMSDAT_GetSentenceID( const PMS_DATA* pms )
{
	return pms->sentence_id;
}

//------------------------------------------------------------------
/**
 * er
 *
 * @param   pms1		͌^ւ̃|C^P
 * @param   pms2		͌^ւ̃|C^Q
 *
 * @retval  BOOL		vĂTRUE
 */
//------------------------------------------------------------------
BOOL PMSDAT_Compare( const PMS_DATA* pms1, const PMS_DATA* pms2 )
{
	int i;

	if(	(pms1->sentence_type != pms2->sentence_type)
	||	(pms1->sentence_id != pms2->sentence_id)
	){
		return FALSE;
	}

	for(i=0; i<PMS_WORD_MAX; i++)
	{
		if( pms1->word[i] != pms2->word[i] )
		{
			return FALSE;
		}
	}

	return TRUE;
}


//------------------------------------------------------------------
/**
 * ̓f[^̃Rs[
 *
 * @param   dst		Rs[|C^
 * @param   src		Rs[|C^
 */
//------------------------------------------------------------------
void PMSDAT_Copy( PMS_DATA* dst, const PMS_DATA* src )
{
	*dst = *src;
}

//==============================================================================================
//==============================================================================================
u32 PMSDAT_GetSentenceIdMax( u32 sentence_type )
{
	if( sentence_type < NELEMS(SentenceDatID) )
	{
		// Ƃ肠͑S^Cv10ɂȂĂ̂...
		return 10;
	}
	return 0;
}

void PMSDAT_SetSentence( PMS_DATA* pms, u32 sentence_type, u32 sentence_id )
{
	GF_ASSERT( sentence_type < PMS_TYPE_MAX );

	pms->sentence_type = sentence_type;
	pms->sentence_id = sentence_id;
}

void PMSDAT_SetWord( PMS_DATA* pms, u32 pos, PMS_WORD word )
{
	GF_ASSERT( pos < PMS_WORD_MAX );
	pms->word[pos] = word;
}






//==============================================================================================
//==============================================================================================


#ifdef PM_DEBUG
void PMSDAT_SetDebug( PMS_DATA* pms )
{
	// ͉ʂ܂ŁAKɎ̂^Ă

	pms->sentence_type = PMS_TYPE_MAIL;
	pms->sentence_id = 5;
	pms->word[0] = 933;
	pms->word[1] = 1041;
}


void PMSDAT_SetDebugRandom( PMS_DATA* pms )
{
	// _ɊȈՉbf[^

	pms->sentence_type = gf_rand()%4;
	pms->sentence_id = gf_rand()%5;
	pms->word[0] = gf_rand()%500;
	pms->word[1] = gf_rand()%500;

}

#endif
