//============================================================================================
/**
 * @file	poke_anime.c
 * @brief	|PAj[V
 * @author	saito
 * @date	2006.02.28
 *
 */
//============================================================================================
#include "system/poke_anime.h"
#include "system/softsprite.h"
#include "tcb.h"

#define ANM_ENTRY_MAX	(4)

typedef BOOL (*ANIME_FUNC)( POKE_ANM_PTR );

//\
typedef struct POKE_ANIME_tag
{
	SOFT_SPRITE *SoftSprite;	//\tgEFAXvCgւ̃|C^
	int MonsNo;	//X^[io[	iȂj
	int AnimeNo;	//Ajio[(Ȃ)
	int Seq;	//AjV[PX
	int Wait;	//EFCg
	BOOL EndFlg;	//AjItO
	ANIME_FUNC	Func;
	u8 Work[16];	//ėp[N
}POKE_ANIME;

typedef struct POKE_ANIME_S_tag
{
	POKE_ANIME PokeAnime[ANM_ENTRY_MAX];
}POKE_ANIME_S;

static POKE_ANIME_S	DebugPokeAnimeS;	//

//O錾
static void	PokemonAnimeTask(TCB_PTR tcb, void *work);

BOOL PokeAnimeType1(POKE_ANM_PTR);	//eXgAj

//Aje[u
static const ANIME_FUNC AnimeFuncTbl[] = {
	PokeAnimeType1,
};


//--------------------------------------------------------------
/**
 * |PAj[VpǗ̊m
 *
 * @param	inHeapID	q[vID
 *
 * @retval	POKE_ANM_S_PTR	mۂ|PAjǗ̈ւ̃|C^
 */
//--------------------------------------------------------------
POKE_ANM_S_PTR	PokeAnm_AllocPokeAnime(const int inHeapID)
{
	POKE_ANM_S_PTR ptr;
	ptr = sys_AllocMemory(inHeapID, sizeof(POKE_ANIME_S));
	return  ptr;
}

//--------------------------------------------------------------
/**
 * |PAj[VpǗ
 *
 * @param	ptr				|PAj̈ւ̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void PokeAnm_FreePokeAnime(POKE_ANM_S_PTR ptr)
{
	sys_FreeMemoryEz(ptr);
}

//--------------------------------------------------------------
/**
 * \tgEFAXvCgƃ|Pio[Zbg
 *
 * @param	ptr				|PAj̈ւ̃|C^
 * @param	ss				\tgEFAXvCgւ̃|C^
 * @param	inMonsNo		X^[io[
 * @param	inEntryIndex	O`R܂ł̓o^CfbNX
 *
 * @retval	none
 */
//--------------------------------------------------------------
void PokeAnm_SetPokemonAnime(	POKE_ANM_S_PTR	_ptr, SOFT_SPRITE *ss,
								const int inMonsNo, const u8 inEntryIndex)
{
	POKE_ANM_S_PTR	ptr;
	u8 idx = inEntryIndex;
	GF_ASSERT((idx<ANM_ENTRY_MAX)&&"CfbNXI[o[");
	
	ptr = &DebugPokeAnimeS;
	
	ptr->PokeAnime[idx].SoftSprite = ss;
	ptr->PokeAnime[idx].MonsNo = inMonsNo;
	//X^[io[Aj[V
	ptr->PokeAnime[idx].AnimeNo = 0;
	ptr->PokeAnime[idx].Func = AnimeFuncTbl[0];
	//X^[io[JnEFCgԂ擾
	ptr->PokeAnime[idx].Wait = 0;
	//AjItOIt
	ptr->PokeAnime[idx].EndFlg = FALSE;
	//V[PX
	ptr->PokeAnime[idx].Seq = 0;
	//Ajo^i^XNo^j
	TCB_Add(PokemonAnimeTask, &ptr->PokeAnime[idx], 0);
}

//--------------------------------------------------------------
/**
 * Aj[VIo
 *
 * @param	ptr				|PAj̈ւ̃|C^
 * @param	inEntryIndex	O`R܂ł̓o^CfbNX
 *
 * @retval	BOOL	TRUE:I		FALSE:p
 */
//--------------------------------------------------------------
BOOL PokeAnm_IsFinishedAnime(POKE_ANM_S_PTR	ptr, const u8 inEntryIndex)
{
	GF_ASSERT((inEntryIndex<ANM_ENTRY_MAX)&&"CfbNXI[o[");
	return ptr->PokeAnime[inEntryIndex].EndFlg;
}

//--------------------------------------------------------------
/**
 * |PAj[V^XN
 *
 * @param	tcb		^XÑ|C^
 * @param	work	^XN[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void	PokemonAnimeTask(TCB_PTR tcb, void *work)
{
	BOOL rc;
	POKE_ANIME *anime = (POKE_ANIME*)(work);
	rc = anime->Func(anime);
	if (rc){
		anime->EndFlg = TRUE;
		//^XNj
		TCB_Delete(tcb);
	}
}

//--------------------------------------------------------------
/**
 * |PAj[V
 *
 * @param	anime		|PAj|C^
 *
 * @retval	BOOL	TRUE:I		FALSEFp
 */
//--------------------------------------------------------------
BOOL PokeAnimeType1(POKE_ANM_PTR anime)
{
	switch(anime->Seq){
	case 0:
		anime->Work[0] = 0;
		(anime->Seq)++;
		break;
	case 1:
		SoftSpriteParaCalc(anime->SoftSprite,SS_PARA_POS_X,-2);
		anime->Work[0]++;
		if (anime->Work[0]==5){
			anime->Work[0] = 0;
			(anime->Seq)++;
		}
		break;
	case 2:
		SoftSpriteParaCalc(anime->SoftSprite,SS_PARA_POS_X,2);
		anime->Work[0]++;
		if (anime->Work[0]==10){
			anime->Work[0] = 0;
			(anime->Seq)++;
		}
		break;
	case 3:
		SoftSpriteParaCalc(anime->SoftSprite,SS_PARA_POS_X,-2);
		anime->Work[0]++;
		if (anime->Work[0]==5){
			anime->Work[0] = 0;
			(anime->Seq)++;
		}
		break;
	case 4:
		return TRUE;
	}
	
	return FALSE;
}
