/**
 *	@file	poruto_name.c
 *	@brief	|g̎ޖ擾
 *	@author	Miyuki Iwasawa
 *	@date	06.02.28
 */

#include "common.h"
#include "gflib/strbuf.h"
#include "system/buflen.h"
#include "system/pm_str.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_porutoname.h"

#include "system/poruto_name.h"

/**
 *	@brief	|g擾}l[W쐬
 *
 *	pIK PorutoName_ReleaseManager()Ăяo
 *	@̈JĂ
 */
PORUTO_NAME_MAN* PorutoName_CreateManager(int heapID)
{
	PORUTO_NAME_MAN *man;
	int i;
	
	man = sys_AllocMemory(heapID,sizeof(PORUTO_NAME_MAN));
	MI_CpuClear8(man,sizeof(PORUTO_NAME_MAN));

	man->pMsgMan = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
			NARC_msg_porutoname_dat,heapID);

	//|g擾Ă
	for(i = 0;i < PORUTO_FLAVOR_MAX;i++){
		man->name[i] = STRBUF_Create(BUFLEN_PORUTO_NAME,heapID);
		MSGMAN_GetString(man->pMsgMan,i,man->name[i]);
	}
	return man;
}

/**
 *	@brief	|g擾}l[W
 */
void PorutoName_ReleaseManager(PORUTO_NAME_MAN* man)
{
	int i;

	for(i = (PORUTO_FLAVOR_MAX-1);i >= 0;i--){
		STRBUF_Delete(man->name[i]);
	}
	MSGMAN_Delete(man->pMsgMan);

	sys_FreeMemoryEz(man);
}

/**
 *	@brief	|gto[ID疼O擾(}l[Ww)
 *
 *	\PORUTO_NAME_STRLEN (20)+EOM_TCỸobt@mۂ
 *	  STRBUFf[^ւ̃|C^nKv
 *	@wɂBUFLEN_PORUTO_NAMEgpĂǂ
 */
void PorutoName_GetNameStrByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id,STRBUF* buf)
{
	STRBUF_Clear(buf);
	MSGMAN_GetString(man->pMsgMan,id,buf);
}

/**
 *	@brief	|gto[ID疼O擾(}l[WSTRBUF*擾)
 *
 *	}l[W[NɊmۂĂSTRBUF̈ւ̃|C^Ԃ
 *	@QƂ͉ҏW͕sI
 */
const STRBUF* PorutoName_GetNameAdrByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id)
{
	return (const STRBUF*)man->name[id];
}

/**
 *	@brief	|gto[ID疼O擾(}l[Ww/擾)
 *
 *	STRBUFɃmۂĕԂ̂ŁA͎ł邱ƁI
 */
STRBUF* PorutoName_AllocNameStrByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id,int heapID)
{
	return STRBUF_CreateBufferCopy(man->name[id],heapID);
}

/**
 *	@brief@|gto[ID疼O擾(ĝ)
 *	
 *	\PORUTO_NAME_STRLEN (20)+EOM_TCỸobt@mۂ
 *	  STRBUFf[^ւ̃|C^nKv
 */
void PorutoName_GetNameStrInst(PORUTO_FLAVORID id,STRBUF* buf,int heapID)
{
	MSGDATA_MANAGER *man;

	man = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
			NARC_msg_porutoname_dat,heapID);
	
	STRBUF_Clear(buf);
	MSGMAN_GetString(man,id,buf);

	MSGMAN_Delete(man);
}

/**
 *	@brief@|gto[ID疼O擾(ĝ/擾)
 *	
 *	STRBUFɃ擾ĕԂ̂ŁA͎ōsƁI
 */
STRBUF* PorutoName_AllocNameStrInst(PORUTO_FLAVORID id,int heapID)
{
	MSGDATA_MANAGER *man;
	STRBUF* buf;
	
	man = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
			NARC_msg_porutoname_dat,heapID);
	
	buf = STRBUF_Create(BUFLEN_PORUTO_NAME,heapID);
	MSGMAN_GetString(man,id,buf);

	STRBUF_Delete(buf);
	MSGMAN_Delete(man);

	return buf;
}

/**
 *	@brief	|gto[IDw肵ĖO`(}l[Ww)
 *
 * @param	win			BMPEBhEf[^
 * @param	fnt_index	gpwb_INDEX(msg_print.h Q)
 * @param	x			EChE\JnXItZbg
 * @param	y			EChE\JnYItZbg
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back ݒɊւāÅ֐̈ 
 *   MSG_PRINT_HEADER \(msg_print.h Q)|C^
 * ƂȂ
 *
 * wait ݒ
 *   MSG_NOTRANS	fBXvC]Ȃ
 *@ MSG_ALL		fBXvCꊇ]
 *   1 `			PƂ̓]EFCgl
 * Ŏw(msg_print.h `)
 */
void PorutoName_WriteByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id,
	GF_BGL_BMPWIN *win,u8 font,u8 ofsx,u8 ofsy,u8 wait,GF_PRINTCOLOR col,void* call_back )
{
	GF_STR_PrintColor(	win,font,man->name[id],
						ofsx,ofsy,
						wait,col,call_back);
}

/**
 *	@brief	|gto[IDw肵ĖO`(ĝ)
 *
 * @param	win			BMPEBhEf[^
 * @param	fnt_index	gpwb_INDEX(msg_print.h Q)
 * @param	x			EChE\JnXItZbg
 * @param	y			EChE\JnYItZbg
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back ݒɊւāÅ֐̈ 
 *   MSG_PRINT_HEADER \(msg_print.h Q)|C^
 * ƂȂ
 *
 * wait ݒ
 *   MSG_NOTRANS	fBXvC]Ȃ
 *@ MSG_ALL		fBXvCꊇ]
 *   1 `			PƂ̓]EFCgl
 * Ŏw(msg_print.h `)
 */
void PorutoName_WriteInst(PORUTO_FLAVORID id,int heapID,GF_BGL_BMPWIN *win,
		u8 font,u8 ofsx,u8 ofsy,u8 wait,GF_PRINTCOLOR col,void* call_back )
{
	STRBUF *buf;
	MSGDATA_MANAGER *man;

	man = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
			NARC_msg_porutoname_dat,heapID);
	

	buf = STRBUF_Create(BUFLEN_PORUTO_NAME,heapID);
	MSGMAN_GetString(man,id,buf);
	
	GF_STR_PrintColor(	win,font,buf,
						ofsx,ofsy,
						wait,col,call_back);

	STRBUF_Delete(buf);
	MSGMAN_Delete(man);
}
