//=============================================================================
/**
 * @file	vZXǗVXe
 * @brief
 * @date	2005.07.25
 */
//=============================================================================

#include "common.h"
#include "system\pm_overlay.h"

#include "system/procsys.h"


//------------------------------------------------------------------
/**
 * @brief	vZX̓V[PX
 */
//------------------------------------------------------------------
enum {
	SEQ_OVERLAY_LOAD = 0,
	SEQ_INIT,
	SEQ_MAIN,
	SEQ_END,
	SEQ_OVERLAY_UNLOAD,
};


//------------------------------------------------------------------
/**
 * @brief	vZX\̒`
 */
//------------------------------------------------------------------
struct _PROC{
	PROC_DATA data;				///<vZX`f[^ւ̃|C^
	int proc_seq;				///<vZXV[PX
	int subseq;					///<vZX֐̓V[PX
	void * parent_work;			///<ʃ[Nւ̃|C^
	void * work;				///<vZX[Nւ̃|C^
	PROC * parent;				///<ʃvZXւ̃|C^
	PROC * child;				///<ʃvZXւ̃|C^
};


//===========================================================================
//
//		֐
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	vZX
 * @param	func		vZX֐
 * @param	parent_work	ʂn[Nւ̃|C^
 * @param	heap_id	gpq[v
 * @return	PROC		vZXւ̃|C^
 */
//------------------------------------------------------------------
PROC * PROC_Create(const PROC_DATA * data, void * parent_work, const int heap_id)
{
	PROC * proc;
	proc = sys_AllocMemory(heap_id, sizeof(PROC));
	proc->data = *data;
	proc->proc_seq = 0;
	proc->subseq = 0;
	proc->parent_work = parent_work;
	proc->work = NULL;
	proc->parent = NULL;
	proc->child = NULL;
	return proc;
}

//------------------------------------------------------------------
/**
 * @brief	qvZX𐶐
 * @param	proc		݂̓vZXւ̃|C^
 * @param	func		vZX֐
 * @param	parent_work	ʂn[Nւ̃|C^
 * @param	heap_id	gpq[v
 * @return	PROC		vZXւ̃|C^
 */
//------------------------------------------------------------------
PROC * PROC_CreateChild(PROC * proc, const PROC_DATA * data, void * parent_work, const int heap_id)
{
	PROC * child;
	child = PROC_Create(data, parent_work, heap_id);
	proc->child = child;
	child->parent = proc;
	return child;
}
//------------------------------------------------------------------
/**
 * @brief	vZX폜
 * @param	proc	vZXւ̃|C^
 */
//------------------------------------------------------------------
void PROC_Delete(PROC * proc)
{
	SDK_ASSERT(proc->work == NULL);
	sys_FreeMemoryEz(proc);
}

//------------------------------------------------------------------
/**
 * @brief	vZX[N̊m
 * @param	proc	vZXւ̃|C^
 * @param	size	mۂ郏[NTCY
 * @param	heap_id	gpq[v
 * @return	void *	mۂvZX[Nւ̃|C^
 */
//------------------------------------------------------------------
void * PROC_AllocWork(PROC * proc, int size, int heap_id)
{
	proc->work = sys_AllocMemory(heap_id, size);
	return proc->work;
}

//------------------------------------------------------------------
/**
 * @brief	vZX[Ñ|C^擾
 * @param	proc	vZXւ̃|C^
 * @return	void *	vZX[Nւ̃|C^
 */
//------------------------------------------------------------------
void * PROC_GetWork(PROC * proc)
{
	SDK_ASSERT(proc->work != NULL);
	return proc->work;
}

//------------------------------------------------------------------
/**
 * @brief	vZX[N̉
 * @param	proc	vZXւ̃|C^
 */
//------------------------------------------------------------------
void PROC_FreeWork(PROC * proc)
{
	SDK_ASSERT(proc->work != NULL);
	sys_FreeMemoryEz(proc->work);
	proc->work = NULL;
}

//------------------------------------------------------------------
/**
 * @brief	ʃ[Nւ̃|C^擾
 * @param	proc	vZXւ̃|C^
 * @return	void *	ʃ[Nւ̃|C^
 */
//------------------------------------------------------------------
void * PROC_GetParentWork(PROC * proc)
{
	SDK_ASSERT(proc->parent_work != NULL);
	return proc->parent_work;
}

//------------------------------------------------------------------
/**
 * @brief	vZX쏈C
 * @param	proc	vZXւ̃|C^
 * @retval	TRUE	vZXI
 * @retval	FALSE	vZXp
 */
//------------------------------------------------------------------
BOOL ProcMain(PROC * proc)
{
	PROC_RESULT result;

	switch (proc->proc_seq) {
	case SEQ_OVERLAY_LOAD:
		if(proc->data.overlay_id != NO_OVERLAY_ID){
			TPRINTF("OVERLAY ID = %d\n", proc->data.overlay_id);
			Overlay_Load( proc->data.overlay_id, OVERLAY_LOAD_NOT_SYNCHRONIZE);
		}
		proc->proc_seq = SEQ_INIT;

		/* fallthru */
			
	case SEQ_INIT:
		result = proc->data.init_func(proc, &proc->subseq);
		if (result == PROC_RES_FINISH) {
			proc->proc_seq = SEQ_MAIN;
			proc->subseq = 0;
		}
		break;
	case SEQ_MAIN:
		result = proc->data.main_func(proc, &proc->subseq);
		if (result == PROC_RES_FINISH) {
			proc->proc_seq = SEQ_END;
			proc->subseq = 0;
		}
		break;
	case SEQ_END:
		result = proc->data.end_func(proc, &proc->subseq);
		if (result == PROC_RES_FINISH) {
			if(proc->data.overlay_id != NO_OVERLAY_ID){
				Overlay_UnloadID( proc->data.overlay_id );
			}
			return TRUE;
		}
		break;
	}
	return FALSE;
}


