#include <string.h>
#include "res_tex.h"
#include "system.h"
#include "str_tool.h"
#include "vram_transfer_manager.h"

//==============================================================================
/**
 * pbg\[Xr
 *
 * @param   const NNSG3dResName* inName
 * @oaram	const char * inTargetName
 *
 * @retval  BOOL		TRUE:v@FALSE:sv
 */
//==============================================================================
BOOL CmpPaletteName(const NNSG3dResName* inName,const char * inTargetName)
{
	NNSG3dResName	target_name;

	SetResName(&target_name,inTargetName);
	if (inName->val[0] == target_name.val[0] &&
		inName->val[1] == target_name.val[1] &&
		inName->val[2] == target_name.val[2] &&
		inName->val[3] == target_name.val[3]){
		return TRUE;
	}
	
	return FALSE;
}

//==============================================================================
/**
 * weNX`pbgTCY̎擾
 *
 * @param   const NNSG3dResTex* inResTex
 * @oaram	const NNSG3dResName *inResName
 *
 * @retval  u32		
 */
//==============================================================================
u32 GetTexPaletteSize(const NNSG3dResTex* inResTex, const NNSG3dResName *inResName)
{
	u8 idx;
	u32 size;
	NNSG3dResDict* dict;
	const NNSG3dResDictPlttData* plttData = NNS_G3dGetPlttDataByName(inResTex, inResName);
	
	size = 0;
	
	if (plttData){
		//eNX`\[X̃pbgGg擾
		dict = (NNSG3dResDict*)((u8*)inResTex + inResTex->plttInfo.ofsDict);

		//pbgpbgCfbNX擾
		idx = NNS_G3dGetPlttIdxByName(inResTex, inResName);
		
		//]TCYvZ(ifłsizéAۂ̃TCY3rbgEVtgl)
		//4colorsȂ]TCY4Fi8oCgjł
		if (plttData->flag & 1){
			size = 1;
		}
		//݃GgŌ̏ꍇ̓eNX`\[X񂪎
		//pbgTCYƌ݂̊JnAhXƂ̍ŎZo
		else if (idx == dict->numEntry-1){
			size = inResTex->plttInfo.sizePltt - plttData->offset;
		}
		else{
			//̃pbgGg̊JnAhX擾
			const NNSG3dResDictPlttData* next_plttData = NNS_G3dGetPlttDataByIdx(inResTex, idx+1);
			// eNX`ubNpbgɑΉf[^tB[h𓾂
			//TCYvZ
			size = next_plttData->offset - plttData->offset;
		}
		//3rbgVtglۂ̃TCYɂȂ
		size = (size<<3);
	}
	return size;
}

//==============================================================================
/**
 * weNX`pbg̕ύX
 *
 * @param	const NNSG3dResTex* inResTex
 * @param   const char * inStr
 *
 * @retval  none		
 */
//==============================================================================
void ChangeTexPalette(const NNSG3dResTex* inResTex, const char * inStr, u16* inPalette)
{
	NNSG3dResName res_name;
	NNSG3dResDict* dict;
	u32 adr;
	u32 size;
    u32 i;
    BOOL result = TRUE;
	
	//OZbg
	SetResName(&res_name,inStr);
    
	//eNX`\[X̃pbgGg擾
    dict = (NNSG3dResDict*)((u8*)inResTex + inResTex->plttInfo.ofsDict);
	
    for (i = 0; i < dict->numEntry; ++i)
    {
	    // eNX`ubNpbgɑΉf[^tB[h𓾂
	    const NNSG3dResDictPlttData* plttData = NNS_G3dGetPlttDataByName(inResTex, &res_name);
		if (plttData){
			//pbg
			if (inResTex->plttInfo.flag & NNS_G3D_RESPLTT_LOADED){//VRAMɃ[hĂ]s
	        
				u16 plttBase = plttData->offset;
				u16 vramOffset = (u16)(inResTex->plttInfo.vramKey & 0xffff);
			
				adr = (u16)(plttBase + vramOffset);
			
				//]TCYvZ
				size = GetTexPaletteSize(inResTex, &res_name);
			
				//VRAM]NGXg
				AddVramTransferManager(
						NNS_GFD_DST_3D_TEX_PLTT,									// pbg]
						NNS_GfdGetPlttKeyAddr( adr ),	// ]
						(void*)inPalette,														// ]f[^
						size	// ]TCY
						);
				return;
			}
		}//endif (plttData)
	}//end for
    return;
}

//==============================================================================
/**
 * weNX`pbg̎擾@ŃmۂĂ
 *
 * @param   const NNSG3dResTex* inResTex
 *
 * @param   const char *inName
 *
 * @retval  u16*		
 */
//==============================================================================
u16* GetTexPalette(const NNSG3dResTex* inResTex, const char *inName, const int inHeapID)
{
	u8 idx;
	u8 entry;
	void *data;
	u16 *palette;
	u32 size;
	const NNSG3dResDictPlttData* plttData;
	NNSG3dResName res_name;
	NNSG3dResDict* dict;
    NNS_G3D_NULL_ASSERT(inResTex);

	//OZbg
	SetResName(&res_name,inName);
	//eNX`\[X̃pbgGg擾
    dict = (NNSG3dResDict*)((u8*)inResTex + inResTex->plttInfo.ofsDict);
	entry = dict->numEntry;

	// eNX`ubNpbgɑΉf[^tB[h𓾂
	plttData = NNS_G3dGetPlttDataByName(inResTex, &res_name);
	if (plttData){
		//pbgCfbNX擾
		idx = NNS_G3dGetPlttIdxByName(inResTex,&res_name);
		if (idx < entry){
			//TCY擾
			size = GetTexPaletteSize(inResTex,&res_name);
			//sizem
			palette = sys_AllocMemory( inHeapID, size );
			//eNX`pbgf[^
			data = (u8*)inResTex + inResTex->plttInfo.ofsPlttData;
			//f[^Rs[
			MI_CpuCopy16(data,palette,size);
			return palette;
		}
	}//end if (plttData)
	return NULL;
}

//==============================================================================
/**
 * weNX`pbgVRAMAhXƃTCY擾
 *
 * @param   const NNSG3dResTex* inResTex
 *
 * @param   const char *inName
 *
 * @param	void *outAdr				擾uq`lAhX
 *
 * @retval  u32							pbgTCY
 */
//==============================================================================
u32 GetTexPaletteAdr(const NNSG3dResTex* inResTex, const char *inName, void *outAdr)
{
	NNSG3dResName res_name;
	NNSG3dResDict* dict;
	u32 adr;
	u32 size;
    u32 i;
    BOOL result = TRUE;
	
	size = 0;
	//OZbg
	SetResName(&res_name,inName);
    
	//eNX`\[X̃pbgGg擾
    dict = (NNSG3dResDict*)((u8*)inResTex + inResTex->plttInfo.ofsDict);
	
    for (i = 0; i < dict->numEntry; ++i)
    {
	    // eNX`ubNpbgɑΉf[^tB[h𓾂
	    const NNSG3dResDictPlttData* plttData = NNS_G3dGetPlttDataByName(inResTex, &res_name);
		if (plttData){
			//pbg
			if (inResTex->plttInfo.flag & NNS_G3D_RESPLTT_LOADED){//VRAMɃ[hĂ擾
	        
				u16 plttBase = plttData->offset;
				u16 vramOffset = (u16)(inResTex->plttInfo.vramKey & 0xffff);
			
				adr = (u16)(plttBase + vramOffset);
			
				//TCYvZ
				size = GetTexPaletteSize(inResTex, &res_name);
			
				outAdr = (void*)adr;
				return size;
			}
		}//endif (plttData)
	}//end for
	outAdr = NULL;
    return size;
}

//==============================================================================
/**
 * weNX`TCY̎擾
 *
 * @param   const NNSG3dResTex* inResTex
 * @oaram	const NNSG3dResName *inResName
 *
 * @retval  u32		
 */
//==============================================================================
u32 GetTexSize(const NNSG3dResTex* inResTex, const NNSG3dResName *inResName)
{
	u8 idx;
	u32 size;
	NNSG3dResDict* dict;
	const NNSG3dResDictTexData* texData = NNS_G3dGetTexDataByName(inResTex, inResName);
	
	size = 0;
	
	if (texData){
		//eNX`\[X̃eNX`Gg擾
		dict = (NNSG3dResDict*)((u8*)inResTex + inResTex->texInfo.ofsDict);

		//pbgpbgCfbNX擾
		idx = NNS_G3dGetTexIdxByName(inResTex, inResName);
		
		//]TCYvZ(ifłsizéAۂ̃TCY3rbgEVtgl)
		//݃GgŌ̏ꍇ̓eNX`\[X񂪎
		//pbgTCYƌ݂̊JnAhXƂ̍ŎZo
		if (idx == dict->numEntry-1){
			size = inResTex->texInfo.sizeTex - (texData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK);
		}
		else{
			//̃pbgGg̊JnAhX擾
			const NNSG3dResDictTexData* next_texData = NNS_G3dGetTexDataByIdx(inResTex, idx+1);
			// eNX`ubNpbgɑΉf[^tB[h𓾂
			//TCYvZ
			size = (next_texData->texImageParam&NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK) - (texData->texImageParam&NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK);
		}
		//3rbgVtglۂ̃TCYɂȂ
		size = (size<<3);
	}
	return size;
}


//eNX`\[XweNX`̃eNX`̂uq`lAhXƃTCY擾
u32 GetResTexAdr(const NNSG3dResTex* inResTex, const char *inName, void *outAdr)
{
	NNSG3dResName res_name;
	NNSG3dResDict* dict;
	u32 adr;
	u32 size;
    u32 i;
    BOOL result = TRUE;
	
	size = 0;
	//OZbg
	SetResName(&res_name,inName);
    
	//eNX`\[X̃pbgGg擾
    dict = (NNSG3dResDict*)((u8*)inResTex + inResTex->texInfo.ofsDict);
	
    for (i = 0; i < dict->numEntry; ++i)
    {
	    // eNX`ubNpbgɑΉf[^tB[h𓾂
	    const NNSG3dResDictTexData* texData = NNS_G3dGetTexDataByName(inResTex, &res_name);
		if (texData){
			//eNX`
			if (inResTex->texInfo.flag & NNS_G3D_RESTEX_LOADED){//VRAMɃ[hĂ擾
	        
				u16 texBase = (texData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK);
				u16 vramOffset = (u16)(inResTex->texInfo.vramKey & 0xffff);
			
				adr = (u16)(texBase + vramOffset);
			
				//TCYvZ
				size = GetTexSize(inResTex, &res_name);
			
				outAdr = (void*)adr;
				return size;
			}
		}//endif (plttData)
	}//end for
	outAdr = NULL;
    return size;
}
