//==============================================================================================
/**
 * @file	snd_play.c
 * @brief	TEhĐ֐
 * @author	Satoshi Nohara
 * @date	2005.06.09
 *
 *	
 * |Pio[ƁAV[PXf[^̕тmFI
 * (S}Ӄio[ɑΉĂ炵B050722V)
 *
 *	g`Đ(tĐ)gpĂZ̍ŌɁAFreeChannelI
 */
//==============================================================================================
#include "common.h"
#include "snd_system.h"
#include "system/snd_tool.h"
#include "poketool/monsno.h"

#include "system/gamedata.h"					//POKE_NUM_MAX


//==============================================================================================
//
//	`
//
//==============================================================================================
#define	SND_ME_COMMON_WAIT		(30)			//MEʃEFCgl

//p^[̃p[^`
#define VOICE_SMALL_VOL			(90)			//ʏ
#define DEFAULT_RELEASE			(0)				//L[It̃[X
//#define W_HYPER_VOICE_PITCH	(32768+16384)	//ZunCp[{CXṽsb`
#define W_HYPER_VOICE_PITCH		(32768+8192)	//ZunCp[{CXṽsb`
#define W_NAKIGOE_PITCH			(32768+16384)	//Zuṽsb`


//==============================================================================================
//
//	\̐錾
//
//==============================================================================================
//|PĐԃ[N
typedef struct{
	int length;
	TCB_PTR	tcb;
}SND_PMVOICE_LENGTH_WORK;


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
BOOL Snd_BgmPlay( u16 no );
void Snd_BgmStop( u16 no, int frame );
static void Snd_BgmStopSub(void);
void Snd_BgmFadeIn( int vol, int frame, int flag );
void Snd_BgmFadeOut( int vol, int frame );
int Snd_FadeCheck();
int Snd_BgmPlayCheck( u16 no );
void Snd_Stop(void);
void Snd_StopEx(void);

BOOL Snd_SePlay( u16 no );
void Snd_SeStopBySeqNo( u16 no, int frame );
void Snd_SeStop( int type, int frame );
int Snd_SePlayCheck( u16 no );
int Snd_SePlayCheckAll(void);
void Snd_SePanSet( u16 no, u16 bitmask, int pan );
void Snd_SePanSetAll( int pan );

BOOL Snd_PMVoicePlay( u16 no );
void Snd_PMVoiceStop( int frame );
int Snd_PMVoicePlayCheck(void);
BOOL Snd_PMVoicePlayEx( int ptn, u16 no, int pan, int vol, int heap_id );
static u8 Snd_PMVoiceLengthChk();
void Snd_PMVoiceLengthSet(int length, int heap_id );
static void Snd_PMVoiceLengthMainTCB( TCB_PTR tcb, void* wk );
void Snd_PMVoiceLengthTcbDel();
static BOOL Snd_ChorusPlay( u16 no, s8 chorus );
static BOOL Snd_ChorusPlayReverse( u16 no, s8 chorus, int vol, int pan, int heap_id );

BOOL Snd_MePlay( u16 no );
int Snd_MePlayCheck(void);
static void Snd_MeStop( int frame );
int Snd_MePlayCheckBgmPlay(void);
static void Snd_MeWaitSet( u16 no );


//==============================================================================================
//
//	BGM֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BGMĐ(SȄɐς񂾃f[^JāABGMf[^̃[hs)
 *
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_BgmPlay( u16 no )
{
	u16 old_bank_no,new_bank_no;
	int type,ret,field_seq_no;
	u8 player_no = Snd_GetPlayerNo(no);		//V[PXio[AvC[io[擾

	if( player_no == PLAYER_BGM ){										//"TEhq[v"

		//V[PXAoNAg`A[JCu[h
		Snd_HeapLoadState( Snd_GetHeapSaveLv(SND_HEAP_SAVE_SE) );		//BGMJ
		Snd_ArcLoadSeq( no );
		Snd_HeapSaveState( Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM) );	//Kwۑ(BGM̌)

	}else if( player_no == PLAYER_FIELD ){								//"vC[q[v"

		/*
		//	
		//PLAYER_FIELDŖ炷BGM̃oNw͒ӂI
		//Snd_DataSetBySceneɁABGMf[^̃[hȂƂN̂ŁI
		//
		//BANK_BASICw肵Ă΁A[hȂĂCB
		//Q[JńAold_bank_no0Ȃ̂ŁAKKwۑ܂ŌĂ΂B
		//
		*/

		//PLAYER_FIELDBGMio[擾
		field_seq_no = Snd_GetSeqNo( Snd_HandleGet(SND_HANDLE_FIELD) );
		//(nh̎"-1"Ԃ)
		//OS_Printf( "player_field_seq_no = %d\n", Snd_GetSeqNo(Snd_HandleGet(SND_HANDLE_FIELD)) );
		
		//ύXÕoNio[擾
		old_bank_no = Snd_GetBankNo( field_seq_no );
		new_bank_no = Snd_GetBankNo( no );

		//oN؂ւ邩`FbN
		if( (old_bank_no != new_bank_no) || (old_bank_no == 0) ){

			//V[PXAoN̓vC[q[vŃ[hĂI
			Snd_HeapLoadState( Snd_GetHeapSaveLv(SND_HEAP_SAVE_SE) );	//BGMJ
			Snd_ArcLoadSeqEx( no, NNS_SND_ARC_LOAD_WAVE );				//g`A[JCu[h
			Snd_HeapSaveState( Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM) );//Kwۑ(BGM̌)
		}

	}else{
		GF_ASSERT( (0) && "Đ悤ƂĂBGMio[słI" );
		return FALSE;
	}

	//vC[io[Anhio[擾
	type = Snd_GetHandleNoByPlayerNo( player_no );

	//nh̃AhX擾āAĐ
	ret = NNS_SndArcPlayerStartSeq( Snd_HandleGet(type), no );

	//Đs`FbN
	if( ret == 0 ){
		OS_Printf( "BGM Đs\tno = %d\n", no );
	}

	Snd_NowBgmNoSet( no );													//BGMio[XV
	Snd_PlayerMoveVolume( type, BGM_VOL_MAX, 0 );							//{[ő
	Snd_StatusSet( SND_STATUS_PLAY );										//Xe[^X(Đ)
	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	BGM~
 *
 * @param	no		BGMio[
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_BgmStop( u16 no, int frame )
{
	int type;

	NNS_SndPlayerStopSeqBySeqNo( no, frame );

	//----------------------------------------------------------
	//TEhnhɌтĂV[PX܂B
	//V[PXтĂȂꍇ́A܂B
	//
	//V[PXio[AvC[io[擾A
	//vC[io[Anhio[擾
	type = Snd_GetHandleNoByPlayerNo( Snd_GetPlayerNo(no) );
	NNS_SndHandleReleaseSeq( Snd_HandleGet(type) );
	//
	//BGM~݂̂ɏĂ܂B(BGMȊÕnhɂĂ͖Ώ)
	//
	//----------------------------------------------------------

	//ǉ́̊֐ɒǉI
	Snd_BgmStopSub();
	return;
}

//BGM~Tu(ʏSnd_BgmStopgpĉ)
static void Snd_BgmStopSub(void)
{
	Snd_NowBgmNoSet( 0 );					//BGMio[NA
	Snd_NextBgmNoSet( 0 );					//BGMio[NA
	Snd_StatusSet( SND_STATUS_STOP );		//Xe[^X(~)
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMtF[hC
 *
 * @param	vol		tF[hC̃{[(0-127)
 * @param	frame	t[
 * @param	flag	"BGM_FADEIN_START_VOL_NOW = ݂̉ʂFADEIN"
 * @param	(flag)	"BGM_FADEIN_START_VOL_MIN = 0FADEIN"
 *
 * @retval	none
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
void Snd_BgmFadeIn( int vol, int frame, int flag )
{
	u8 player_no;
	int type;
	u16 now_bgm_no = Snd_NowBgmNoGet();		//BGMio[擾

	//V[PXio[AvC[io[擾
	player_no = Snd_GetPlayerNo( now_bgm_no );
	if( player_no == 0xff ){
		return;		//݂̃V[PXio[0Ȃ̂ŉȂI
	}

	//vC[io[Anhio[擾
	type = Snd_GetHandleNoByPlayerNo( player_no );

	//tF[hC̊Jnʂ0ɂ鎞
	if( flag == BGM_FADEIN_START_VOL_MIN ){
		//nh̃AhX擾
		Snd_PlayerMoveVolume( type, 0, 0 );
	}

	Snd_PlayerMoveVolume( type, vol, frame );
	Snd_FadeCountSet( frame );				//tF[hJE^[Zbg
	Snd_StatusSet( SND_STATUS_FADEIN );		//Xe[^X(tF[hC)
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMtF[hAEg
 *
 * @param	vol		tF[hAEg̃{[(0-127)
 * @param	frame	t[
 *
 * @retval	none
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
void Snd_BgmFadeOut( int vol, int frame )
{
	u8 player_no;
	int type;
	u16 now_bgm_no = Snd_NowBgmNoGet();		//BGMio[擾

	//V[PXio[AvC[io[擾
	player_no = Snd_GetPlayerNo( now_bgm_no );
	if( player_no == 0xff ){
		return;		//݂̃V[PXio[0Ȃ̂ŉȂI
	}

	//łɃtF[hAEg̎́A][s藈肵ĂA
	//tF[hAEgBGM͂̂܂܂ɂI
	
	//tF[hłȂ
	if( Snd_FadeCheck() == 0 ){

		//vC[io[Anhio[擾
		type = Snd_GetHandleNoByPlayerNo( player_no );

		//nh̃AhX擾
		Snd_PlayerMoveVolume( type, vol, frame );
		Snd_FadeCountSet( frame );			//tF[hJE^[Zbg
	}

	Snd_StatusSet( SND_STATUS_FADEOUT );	//Xe[^X(tF[hAEg)
	return;
}

//--------------------------------------------------------------
/**
 * @brief	tF[hI҂
 *
 * @param	none
 *
 * @retval	"0=IA0ȊO̓tF[hJE^[̒l"
 */
//--------------------------------------------------------------
int Snd_FadeCheck()
{
	u16* fade_count = Snd_GetParamAdrs(SND_W_ID_FADE_COUNT);
	return (*fade_count);
}

//--------------------------------------------------------------
/**
 * @brief	BGMI҂
 *
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 */
//--------------------------------------------------------------
int Snd_BgmPlayCheck( u16 no )
{
	u8 player_no;;

	//V[PXio[AvC[io[擾
	player_no = Snd_GetPlayerNo( no );

	return Snd_PlayerCountPlayingSeq( player_no );
}

//--------------------------------------------------------------
/**
 * @brief	SĂ̍Đ̃V[PX~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_Stop(void)
{
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);

	NNS_SndPlayerStopSeqAll(0);										//S

	//Snd_WaveOutStop  Snd_WaveOutHandleGetŁA
	//mۂĂȂ`lɃANZX悤ƂƁA
	//AT[gŎ~܂̂ŁAŃ`FbNČĂ΂Ȃ悤ɂĂ
	if( *ch_normal_flag == 1 ){										//mۃtOON
		Snd_WaveOutStop( WAVEOUT_CH_NORMAL );						//g`~
	}

	if( *ch_chorus_flag == 1 ){										//mۃtOON
		Snd_WaveOutStop( WAVEOUT_CH_CHORUS );						//g`~
	}

	Snd_StatusSet( SND_STATUS_STOP );								//Xe[^X(~)
	return;
}

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMȊȎSĂ̍Đ̃V[PX~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_StopEx(void)
{
	int i;
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);

	NNS_SndPlayerStopSeq( Snd_HandleGet(SND_HANDLE_BGM), 0 );		//tB[hBGMȊO
	Snd_BgmStopSub();

	for( i=0; i < SE_HANDLE_MAX ;i++ ){			//SE
		Snd_SeStop( (SND_HANDLE_SE_1 + i), 0 ); 
	}

	Snd_PMVoiceStop(0);							//PV

	//Snd_WaveOutStop  Snd_WaveOutHandleGetŁA
	//mۂĂȂ`lɃANZX悤ƂƁA
	//AT[gŎ~܂̂ŁAŃ`FbNČĂ΂Ȃ悤ɂĂ
	if( *ch_normal_flag == 1 ){										//mۃtOON
		Snd_WaveOutStop( WAVEOUT_CH_NORMAL );						//g`~
	}

	if( *ch_chorus_flag == 1 ){										//mۃtOON
		Snd_WaveOutStop( WAVEOUT_CH_CHORUS );						//g`~
	}

	//tB[hBGM̓|[YAÂŁA~Ăł͂ȂI
	//|[YԂ̂܂܂ɂĂI
	
	return;
}


//==============================================================================================
//
//	SE֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	SEĐ
 *
 * @param	no		SEio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
BOOL Snd_SePlay( u16 no )
{
	int type,ret;

	//V[PXio[ASẼvC[io[擾A
	//SẼvC[io[ASẼnhio[擾
	type = Snd_GetHandleNoByPlayerNo( Snd_GetPlayerNo(no) );

	//V[PXĐ
	ret = NNS_SndArcPlayerStartSeq( Snd_HandleGet(type), no );

	//Đs`FbN
	if( ret == 0 ){
//#ifdef SOUND_OS_PRINT_ON
		OS_Printf( "SE Đs\tno = %d\n", no );
//#endif
	}

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	SE~(V[PXio[w)
 *
 * @param	no		SEԍ
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_SeStopBySeqNo( u16 no, int frame )
{
	NNS_SndPlayerStopSeqBySeqNo( no, frame );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	SE~(TEhnhw)
 *
 * @param	type	TEhnh^Cv
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 */
//--------------------------------------------------------------
void Snd_SeStop( int type, int frame )
{
	NNS_SndPlayerStopSeq( Snd_HandleGet(type), frame );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	SEI҂
 *
 * @param	no		SEio[
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 *
 * w肵SEIĂ邩`FbNł͂ȂA
 * w肵SE̎gpvC[ɁA
 * Đ̃V[PX邩̃`FbNłB
 */
//--------------------------------------------------------------
int Snd_SePlayCheck( u16 no )
{
	return Snd_PlayerCountPlayingSeq( Snd_GetPlayerNo(no) );

	//ȉۗ
	//(vC[io[ł͂ȂAV[PXio[ł`FbNł)
	//NNS_SndPlayerCountPlayingSeqBySeqNo֐́A
	//V[PXԍseqNow肵āAĐ̃V[PX̐𐔂܂B
	//́ANNS_SndPlayerSetSeqNo֐ŃZbgV[PXԍA
	//seqNoƓłV[PX̐𐔂܂B 
}

//--------------------------------------------------------------
/**
 * @brief	SĂSEI҂
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 */
//--------------------------------------------------------------
int Snd_SePlayCheckAll()
{
	int i;

	for( i=0; i < SE_HANDLE_MAX ;i++ ){
		if( Snd_PlayerCountPlayingSeq(PLAYER_SE_1+i) == TRUE ){
			return TRUE;
		}
	}

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	SEPAN()ύX
 *
 * @param	no		SEio[
 * @param	bitmask	gbNrbg}XN
 * @param	pan		-128 ` 127
 *
 * @retval	none
 *
 * trackBitMaskŁAݒ肷gbNw肵܂B
 * ʃrbg珇ɁAgbN0AgbN1AgbN2AAA\A
 * rbgĂgbNSĂɑ΂āApύX܂B
 *
 * Ⴆ΁AgbN2ƃgbN5̃pύXꍇ́A 
 * (1 << 2) | (1 << 5) Ȃ킿A0x0024 Ƃ܂B 
 */
//--------------------------------------------------------------
void Snd_SePanSet( u16 no, u16 bitmask, int pan )
{
	int type;

	//V[PXio[ASẼvC[io[擾A
	//SẼvC[io[ASẼnhio[擾
	type = Snd_GetHandleNoByPlayerNo( Snd_GetPlayerNo(no) );

	NNS_SndPlayerSetTrackPan( Snd_HandleGet(type), bitmask, pan );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	SĂSEPAN()ύX
 *
 * @param	pan		-128 ` 127
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_SePanSetAll( int pan )
{
	int type, i;

	//SẼvC[io[ASẼnhio[擾
	type = Snd_GetHandleNoByPlayerNo( PLAYER_SE_1 );

	for( i=0; i < SE_HANDLE_MAX ;i++ ){
		NNS_SndPlayerSetTrackPan( Snd_HandleGet(type+i), 0xffff, pan );
	}

	return;
}


//==============================================================================================
//
//	|P֘A
//
//	Ή
//	g`Đ(tĐ)gpĂZ̍ŌɁAFreeChannelI
//
//==============================================================================================
 
//--------------------------------------------------------------
/**
 * @brief	|PĐ(ōĐOɒ~Ă΂܂)
 *
 * @param	no		|Pio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * OƂāAR[Xgp鎞́A~͌Ă΂܂B
 *
 * |Pio[ƁAV[PXf[^̕тmFI
 * (S}Ӄio[ɑΉĂ炵B050722V)
 *
 * <>
 * V[PXA[JCuƁAvC[q[vgȂI
 * V[PXƁAvC[q[vgI
 */
//--------------------------------------------------------------
BOOL Snd_PMVoicePlay( u16 no )
{
	int ret;
	u8* chorus_flag = Snd_GetParamAdrs( SND_W_ID_CHORUS_FLAG );

	//sȒl`FbN
	if( (no > POKE_NUM_MAX) || (no == 0) ){
		//GF_ASSERT( (0) && "|Pio[słI" );
		//return FALSE;	//G[
		OS_Printf( "|Pio[słI" );
		no = MONSNO_HUSIGIDANE;
	}

	//R[XgptO`FbN
	if( *chorus_flag == 0 ){
		//V[PX2ĐȂ悤ɒ~Ă
		Snd_PMVoiceStop(0);
		ret = NNS_SndArcPlayerStartSeq( Snd_HandleGet(SND_HANDLE_PMVOICE), no );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, PV_VOL_DEFAULT );
	}else{
		//V[PX2Đ
		ret = NNS_SndArcPlayerStartSeq( Snd_HandleGet(SND_HANDLE_CHORUS), no );
		Snd_PlayerSetInitialVolume( SND_HANDLE_CHORUS, PV_VOL_DEFAULT );
	}

	//Đs`FbN
	if( ret == 0 ){
		OS_Printf( "PMVOICE Đs\tno = %d\n", no );
	}

	return ret;
}
 
//--------------------------------------------------------------
/**
 * @brief	|P~(TEhnhw)
 *
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 *
 * R[X(p)TEhnh~Ă܂B
 *
 * tĐgptOĂAg`~ĂԂ悤ɂĂ
 * |P̖~鏈͂̊֐Ăׂ΂悢B
 */
//--------------------------------------------------------------
void Snd_PMVoiceStop( int frame )
{
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);
	u8* reverse_flag   = Snd_GetParamAdrs(SND_W_ID_REVERSE_FLAG);

	NNS_SndPlayerStopSeq( Snd_HandleGet(SND_HANDLE_PMVOICE), frame );	//
	NNS_SndPlayerStopSeq( Snd_HandleGet(SND_HANDLE_CHORUS), frame );	//R[X

	//Snd_WaveOutStopReverse̒ł`FbNĂ̂ō폜(06.03.09)
	//if( *reverse_flag == 1 ){								//tĐgptOĂ

		if( *ch_normal_flag == 1 ){										//CHmۂĂ
			Snd_WaveOutStopReverse( WAVEOUT_CH_NORMAL );				//bufJ
		}
		if( *ch_chorus_flag == 1 ){										//CHmۂĂ
			Snd_WaveOutStopReverse( WAVEOUT_CH_CHORUS );				//bufJ
		}
	//}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	|PI҂
 *
 * @param	none
 *
 * @retval	"Đ=1ȏAĐI=0"
 */
//--------------------------------------------------------------
int Snd_PMVoicePlayCheck(void)
{
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);
	u8* reverse_flag   = Snd_GetParamAdrs(SND_W_ID_REVERSE_FLAG);

	//tĐgpĂ鎞́Ag`Đ`FbN悤ɂI
	if( *reverse_flag == 1 ){									//tĐgptOĂ
		if( *ch_normal_flag == 1 ){								//CHmۂĂ
			return Snd_WaveOutIsPlaying( WAVEOUT_CH_NORMAL );
		}
		if( *ch_chorus_flag == 1 ){								//CHmۂĂ
			return Snd_WaveOutIsPlaying( WAVEOUT_CH_CHORUS );
		}
	}

	//OS_Printf( "play check %d\n", Snd_PlayerCountPlayingSeq( PLAYER_PV ) );
	return Snd_PlayerCountPlayingSeq( PLAYER_PV );
}


//==============================================================================================
//
//	|Pp^[֘A
//
//	<Ή>
//	Z̏Ĩ^C~OŁAg`ĐpɊmۂ`l̊JI
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	|PĐ(p^[w)
 *
 * @param	no		|Pio[
 * @param	pan		-128 ` 127
 * @param	vol		{[(0-127)
 * @param	ptn		p^[(snd_tool.hQ)
 * @param	heap_id	q[vID
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * <>
 * PITCH	ABG=256,DS=64
 * CHORUS	sb`̍(-64`64)
 *
 * gpŹAuȂAقAƂڂAnCp[{CXv炢B
 *
 * PLAYER_PV́AV[PXő吔2ɐݒ肵ĂB
 * Snd_PMVoicePlay֐ŁAĐOɒ~ĂŁA
 * 2̃V[PXĐȂ悤ɂĂB
 * R[Xgp鎞́Awk->chorus_flag̂ŁA
 * Snd_PMVoicePlay֐ŁAtO݂āA~Ă΂Ȃ悤ɂĂ
 *
 * gpĂȂɂ́A"PV_PTN_PARAM_NONE"nĂĉ
 */
//--------------------------------------------------------------
BOOL Snd_PMVoicePlayEx( int ptn, u16 no, int pan, int vol, int heap_id )
{
	u16 monsno;
	u16	pitch;						//(64)
	//u8	release;				//L[It̃[Xwp
	int ret1,ret2,ret3,ret4;
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);
	u8* chorus_flag	   = Snd_GetParamAdrs(SND_W_ID_CHORUS_FLAG);

	ret1 = 0;
	ret2 = 0;
	ret3 = 0;
	ret4 = 0;

	//l
	//release	= DEFAULT_RELEASE;
	pitch = 0;

	*chorus_flag = 0;			//R[XgptOOFF

	//`lmۂĂJ
	if( *ch_normal_flag == 1 ){
		Snd_WaveOutStopReverse( WAVEOUT_CH_NORMAL );		//bufJ
		Snd_WaveOutFreeChannel( WAVEOUT_CH_NORMAL );		//ch J
	}
	if( *ch_chorus_flag == 1 ){
		Snd_WaveOutStopReverse( WAVEOUT_CH_CHORUS );		//bufJ
		Snd_WaveOutFreeChannel( WAVEOUT_CH_CHORUS );		//ch J
	}

#if 1
	//sȒl`FbN
	
	monsno = no;

	if( (no > POKE_NUM_MAX) || (no == 0) ){
		OS_Printf( "|Pio[słI" );
		monsno = MONSNO_HUSIGIDANE;
	}
#endif

	switch( ptn ){

	// = 0 ʏĐ
	case PV_NORMAL:
		//----------------
		//play
		//pan,vol
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		break;

	// = 1 ĐԒZkiQQogŃ|Poꎞj
	case PV_HALF:
		//----------------
		//play
		//pan,vol,length
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		Snd_PMVoiceLengthSet(20,heap_id);
		//release		= 225;
		break;

	// = 2 {|PitB[hCxgj
	case PV_FLDEVENT:		
		//----------------
		//play
		//pan,vol,pitch
		//chorus
		//pan
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		//release		= 225;
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, VOICE_SMALL_VOL );	//
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3840/6 );		//sb`
		ret3 = Snd_ChorusPlay( monsno, 20 );	//R[X(ӁI)
		Snd_PlayerSetTrackPan( SND_HANDLE_CHORUS, 0xffff, pan );
		break;

	// = 3 ZʉEƂڂp
	case PV_W_TOOBOE:	
		//----------------
		//play
		//pan,vol,length,pitch
		//
		//chorus
		//pan
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		Snd_PMVoiceLengthSet(15,heap_id);//(50);
		//release		= 200;
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3904/6 );		//sb`
		ret3 = Snd_ChorusPlay( monsno, 20 );	//R[X(ӁI)
		Snd_PlayerSetTrackPan( SND_HANDLE_CHORUS, 0xffff, pan );
		break;

	// = 4 ZʉEnCp[{CXpP
	case PV_W_HYPER1:		
		//----------------
		//reverse
		//----------------
		ret2 = Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );
		ret2 = Snd_WaveOutStartReverse( monsno, 60, 64, WAVEOUT_CH_NORMAL, heap_id );
		Snd_WaveOutSetPan( WAVEOUT_CH_NORMAL, pan );					//p
		Snd_PMVoiceLengthSet(25,heap_id);
		//release		= 100;
		//pitch		= 15600;
		pitch		= 3904;

		Snd_WaveOutSetSpeed( WAVEOUT_CH_NORMAL, W_HYPER_VOICE_PITCH );

		ret4 = Snd_ChorusPlayReverse(monsno, -64, VOICE_SMALL_VOL, pan, heap_id);//R[X(ӁI)

		Snd_WaveOutSetSpeed( WAVEOUT_CH_CHORUS, W_HYPER_VOICE_PITCH );

		break;

	// = 5 |Pꂽ
	case PV_POKEDOWN:			
		//----------------
		//play
		//pan,vol,pitch
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		//release		= 200;
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3584/6 );			//sb`
		break;

	// = 6 ZʉEnCp[{CXpQ
	case PV_W_HYPER2:			
		//----------------
		//play
		//pan,vol,pitch
		//
		//chorus
		//pan
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		//release		= 220;
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, (VOICE_SMALL_VOL-20) );	//
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3904/6 );			//sb`
		ret3 = Snd_ChorusPlay( monsno, -64 );	//R[X(ӁI)
		Snd_PlayerSetTrackPan( SND_HANDLE_CHORUS, 0xffff, pan );
		break;								//by matsuda 2004.05.15(y)

	// = 7 ZʉEقP
	case PV_W_HOERU1:		
		//----------------
		//play
		//pan,vol,length,pitch
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		Snd_PMVoiceLengthSet(10,heap_id);
		//release		= 100;
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3584/6 );			//sb`
		break;

	// = 8 ZʉEقQ
	case PV_W_HOERU2:			
		//----------------
		//play
		//pan,vol,length,pitch
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		Snd_PMVoiceLengthSet(60,heap_id);
		//release		= 225;
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3904/6 );			//sb`
		break;

	// = 9 ZʉEȂP
	case PV_W_NAKIGOE1:		
		//----------------
		//reverse
		//----------------
		ret2 = Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );
		ret2 = Snd_WaveOutStartReverse( monsno, 60, 64, WAVEOUT_CH_NORMAL, heap_id );
		Snd_WaveOutSetPan( WAVEOUT_CH_NORMAL, pan );							//p
		Snd_PMVoiceLengthSet(15,heap_id);
		//release		= 125;
		//pitch		= 15200;
		pitch		= 3904;
		Snd_WaveOutSetSpeed( WAVEOUT_CH_NORMAL, W_NAKIGOE_PITCH );
		break;

	// =10 ZʉEȂQ
	case PV_W_NAKIGOE2:			
		//----------------
		//play
		//pan,vol,length,pitch
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		Snd_PMVoiceLengthSet(100,heap_id);
		//release		= 225;
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3904/6 );			//sb`
		break;

	// =11 ʏĐ(CȂ)
	case PV_PINCHNORMAL:		
		//----------------
		//play
		//pan,vol,pitch
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		//Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3904/6 );		//sb`
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, -128 );			//sb`
		break;

	// =12 ĐԒZkiQQogŃ|Poꎞj(CȂ)
	case PV_PINCHHALF:		
		//----------------
		//play
		//pan,vol,length,pitch
		//----------------
		ret1 = Snd_PMVoicePlay( monsno );
		Snd_PlayerSetTrackPan( SND_HANDLE_PMVOICE, 0xffff, pan );
		Snd_PlayerSetInitialVolume( SND_HANDLE_PMVOICE, vol );
		//Snd_PMVoiceLengthSet(20,heap_id);
		Snd_PMVoiceLengthSet(15,heap_id);
		//release		= 225;
		//Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 3904/6 );		//sb`
		Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, -128 );			//sb`
		break;	

	// =13 }ӃR[XĐ
	case PV_ZUKAN_CHORUS:		
		//----------------
		//play
		//
		//chorus
		//pan,vol
		//----------------
		Snd_PMVoicePlay( monsno );
		Snd_ChorusPlay( monsno, SND_ZUKAN_PITCH_CHORUS );				//R[X(ӁI)
		Snd_PlayerSetTrackPan( SND_HANDLE_CHORUS, 0xffff, pan );
		Snd_PlayerMoveVolume( SND_HANDLE_CHORUS, vol, 0 );			//R[X{[
		break;
	}

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "1)pv play ptn normal = %d\n", ret1 );
	OS_Printf( "2)pv play ptn reverse = %d\n", ret2 );
	OS_Printf( "3)pv play ptn chorus = %d\n", ret3 );
	OS_Printf( "4)pv play ptn reverse chorus = %d\n\n", ret4 );
#endif

	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief	|PĐԃZbg(TCBǉ)
 *
 * @param	no		V[PXio[
 * @param	heap_id	q[vID
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PMVoiceLengthSet( int length, int heap_id )
{
	SND_PMVOICE_LENGTH_WORK* wk = NULL;
	TCB_PTR* length_tcb			= Snd_GetParamAdrs(SND_W_ID_LENGTH_TCB);

	//łɓo^ĂTCB폜
	if( *length_tcb != NULL ){
		OS_Printf( "\nx@|P\n" );
		OS_Printf( "ĐԑTCBIĂȂ̂ɁAēxĂ΂Ă܂I\n" );
	}
	Snd_PMVoiceLengthTcbDel();

	wk = sys_AllocMemory( heap_id, sizeof(SND_PMVOICE_LENGTH_WORK) );
	if( wk == NULL ){
		GF_ASSERT( (0) && "mێsI" );
		return;
	}
	memset( wk, 0, sizeof(SND_PMVOICE_LENGTH_WORK) );

	wk->length	= length;
	wk->tcb		= TCB_Add( Snd_PMVoiceLengthMainTCB, wk, 0 );
	*length_tcb = wk->tcb;
	return;
}

//̒l"length"ȂƉʂ킹"0"ɂĂ
//#define SND_PMVOICE_LENGTH_VOL		(20)
//̒l"length"Ȃɉʂ"0"ɂȂ悤ɃZbg
#define SND_PMVOICE_LENGTH_VOL_SET		(10)
//--------------------------------------------------------------
/**
 * @brief	TCBC
 *
 * @param	tcb		TCB_PTR
 * @param	wk		[ÑAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_PMVoiceLengthMainTCB( TCB_PTR tcb, void* wk )
{
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);
	SND_PMVOICE_LENGTH_WORK* swk = (SND_PMVOICE_LENGTH_WORK *)wk;

#if 1
	//ʂRɏĂ
	//if( swk->length < SND_PMVOICE_LENGTH_VOL ){
	
	//ʂ"0"ɂȂĂ悤ɃZbg
	if( swk->length == SND_PMVOICE_LENGTH_VOL_SET ){
		Snd_PlayerMoveVolume( SND_HANDLE_PMVOICE, 0, swk->length );
		Snd_PlayerMoveVolume( SND_HANDLE_CHORUS, 0, swk->length );
	}
#endif

	swk->length--;

	if( swk->length <= 0 ){

		//~
		Snd_PMVoiceStop(0);

		//Snd_WaveOutStopReverse̒ŁA
		//tĐgptO`FbNĂ̂ŁA
		//ł́Ao[X`FbN͂ĂȂI(06.03.09)

		//g`Đ@`lmۂĂJ
		if( *ch_normal_flag == 1 ){
			Snd_WaveOutStopReverse( WAVEOUT_CH_NORMAL );	//bufJ
			Snd_WaveOutFreeChannel( WAVEOUT_CH_NORMAL );	//ch J
		}
		if( *ch_chorus_flag == 1 ){
			Snd_WaveOutStopReverse( WAVEOUT_CH_CHORUS );	//bufJ
			Snd_WaveOutFreeChannel( WAVEOUT_CH_CHORUS );	//ch J
		}

		//TCB폜
		Snd_PMVoiceLengthTcbDel();
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	|PĐTCB폜
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PMVoiceLengthTcbDel()
{
	void* wk;
	TCB_PTR* length_tcb = Snd_GetParamAdrs(SND_W_ID_LENGTH_TCB);

	//o^ĂTCB폜
	if( *length_tcb != NULL ){
		wk = TCB_GetWork( *length_tcb );
		TCB_Delete( *length_tcb );
		sys_FreeMemoryEz( wk );
	}

	*length_tcb = NULL;
	return;
}

#if 0
//--------------------------------------------------------------
/**
 * @brief	|PZbg(TCBǉ)
 *
 * @param	no		V[PXio[
 * @param	heap_id q[vID
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PMVoiceReleaseSet(int reverse, u32 ch, int frame, int heap_id)
{
	int ret;
	SND_PMVOICE_RELEASE_WORK* wk = NULL;

	//łɓo^ĂTCB폜
	ret = Snd_TCBDelSub( SND_TCB_PMVOICE_RELEASE );
	if( ret == TRUE ){
		OS_Printf( "\nx@|P\n" );
		OS_Printf( "TCBIĂȂ̂ɁAēxĂ΂Ă܂I\n" );
	}

	wk = sys_AllocMemory( heap_id, sizeof(SND_PMVOICE_RELEASE_WORK) );
	if( wk == NULL ){
		GF_ASSERT( (0) && "mێsI" );
		return;
	}
	memset( wk, 0, sizeof(SND_PMVOICE_RELEASE_WORK) );

	if( reverse == 0 ){
		Snd_PlayerMoveVolume( SND_HANDLE_PMVOICE, 0, frame );
	}else{
		//ӁI127ɌŒɂĂ
		//݂̃{[/frame̒lt[ƂɈĂ
		//Snd_WaveOutSetVolume( ch, int vol );
	}

	wk->reverse	= reverse;
	wk->frame	= frame;
	wk->count	= 0;

	wk->sub		= 127/frame;
	if( wk->sub == 0 ){
		wk->sub = 1;
	}

	wk->tcb		= TCB_Add( Snd_PMVoiceReleaseMainTCB, wk, 0 );
	*release_tcb= wk->tcb;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	TCBC
 *
 * @param	tcb		TCB_PTR
 * @param	wk		[ÑAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_PMVoiceReleaseMainTCB( TCB_PTR tcb, void* wk )
{
	u8* ch_normal_flag;
	u8* ch_chorus_flag;
	SND_PMVOICE_RELEASE_WORK *swk;

	swk = (SND_PMVOICE_RELEASE_WORK *)wk;
	ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);

	if( swk->reverse == 1 ){
		if( swk->count < 255 ){
			swk->count++;
		}

		if( (swk->sub*swk->count) >= 127 )
			Snd_WaveOutSetVolume( ch, 0 );
		}else{
			//ӁI127ɌŒɂĂ
			//݂̃{[/frame̒lt[ƂɈĂ
			Snd_WaveOutSetVolume( ch, 127-(swk->sub*swk->count) );
		}
	}
		
	swk->frame--;
	if( swk->frame <= 0 ){

		//V[PX
		Snd_PMVoiceStop(0);

		//g`Đ@`lmۂĂJ
		if( *ch_normal_flag == 1 ){
			Snd_WaveOutStopReverse( WAVEOUT_CH_NORMAL );
			Snd_WaveOutFreeChannel( WAVEOUT_CH_NORMAL );
		}
		if( *ch_chorus_flag == 1 ){
			Snd_WaveOutStopReverse( WAVEOUT_CH_CHORUS );
			Snd_WaveOutFreeChannel( WAVEOUT_CH_CHORUS );
		}

#if 0
		TCB_Delete( swk->tcb );
		sys_FreeMemoryEz( wk );
#else
		Snd_PMVoiceReleaseTcbDel();
#endif
	}

	return;
}
#endif



#if 0
	//----------------
	//ƂŎI
	//----------------
	
	//W[VfvXeXg
	NNS_SndPlayerSetTrackModDepth( Snd_HandleGet(SND_HANDLE_PMVOICE), 0xffff, 30 );
	//NNS_SndPlayerSetTrackModDepth( Snd_HandleGet(SND_HANDLE_PMVOICE), 0xffff, 60 );
	//NNS_SndPlayerSetTrackModDepth( Snd_HandleGet(SND_HANDLE_PMVOICE), 0xffff, 80 );
	
	//W[VXs[heXg(0-255)
	//speed̃ftHg16ŁA6.4Hzɑ܂BlQ{ɂȂƁAgQ{ɂȂ܂B
	//NNS_SndPlayerSetTrackModSpeed( Snd_HandleGet(SND_HANDLE_PMVOICE), 0xffff, 80 );
#endif


//==============================================================================================
//
//	R[X֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	R[X(V[PXĐ)
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
static BOOL Snd_ChorusPlay( u16 no, s8 chorus )
{
	int ret;
	u8* chorus_flag = Snd_GetParamAdrs( SND_W_ID_CHORUS_FLAG );

	*chorus_flag = 1;	//R[XgptOON

	ret = Snd_PMVoicePlay( no );
	Snd_PlayerSetTrackPitch( SND_HANDLE_CHORUS, 0xffff, chorus );	//sb`

	return ret; 
}

//--------------------------------------------------------------
/**
 * @brief	R[X(g`tĐ)
 *
 * @param	no
 * @param	chorus
 * @param	vol
 * @param	pan
 * @param	heap_id	q[vID
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
static BOOL Snd_ChorusPlayReverse( u16 no, s8 chorus, int vol, int pan, int heap_id )
{
	int ret;
	u8* chorus_flag = Snd_GetParamAdrs( SND_W_ID_CHORUS_FLAG );

	*chorus_flag = 1;	//R[XgptOON

	ret = Snd_WaveOutAllocChannel( WAVEOUT_CH_CHORUS );
	ret = Snd_WaveOutStartReverse( no, vol, pan, WAVEOUT_CH_CHORUS, heap_id );	//ӁI(R[X)

	return ret; 
}


//==============================================================================================
//
//	ME֘A
//	BGM̔g`̂݊Jđv(ȂƗeʑȂmF)
//
//	gp1(MEIABGMĊJ)
//	Snd_MePlay(bgm)
//	if( Snd_MePlayCheckBgmPlay(&wk) == FALSE ){
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BGM|[Y  MEĐ
 *
 * @param	no			MEio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * EFCg[NMEʃEFCglZbg܂
 */
//--------------------------------------------------------------
BOOL Snd_MePlay( u16 no )
{
	u16 now_bgm_no;
	u8 player_no;
	int ret,i;
	const NNSSndArcBankInfo* info;									//oN\
	info = Snd_GetBankInfo( no );									//oN\̎擾

	Snd_MeWaitSet( no );											//MEʃEFCglZbg

	//|[YvC[́ABGMio[炵ĂvC[I
	now_bgm_no = Snd_NowBgmNoGet();									//BGMio[擾
	player_no = Snd_GetPlayerNo( now_bgm_no );

	//݂̃V[PXio[0łȂ
	if( player_no != 0xff ){
		Snd_PlayerPause( player_no, TRUE );							//BGM|[Y
	}

	//|[ÝAg`f[^̂݊JĂ悢I
	
	//MÉAǉg`Ȃ

	//Tuʃf[^[hĂ鎞̂ŁAMEf[^݂̂̒ǉ폜I
	Snd_HeapSaveState( Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_ME) );	//MEǉA폜p

	//V[PXAoNf[^[h
	ret = Snd_ArcLoadSeqEx( no, (NNS_SND_ARC_LOAD_SEQ | NNS_SND_ARC_LOAD_BANK) );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "MEV[PXf[^[h = %d\n", ret );
#endif

	return NNS_SndArcPlayerStartSeq( Snd_HandleGet(SND_HANDLE_ME), no );
}

//--------------------------------------------------------------
/**
 * @brief	MEI҂
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 *
 * Snd_MePlay
 * Snd_MePlayCheck
 * ܂łƉĂȂI
 * Snd_MeStopKvI
 *
 * ́A
 * Snd_MePlay
 * Snd_MePlayCheckBgmPlay
 * ŎgI
 */
//--------------------------------------------------------------
int Snd_MePlayCheck(void)
{
	u16* me_wait = Snd_GetParamAdrs(SND_W_ID_ME_WAIT);

	if( Snd_PlayerCountPlayingSeq(PLAYER_ME) != 0 ){
		return TRUE;
	}

	if( *me_wait > 0 ){													//EFCg`FbN
		(*me_wait)--;
		return TRUE;													//EFCg
	}

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	ME~
 *
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 */
//--------------------------------------------------------------
static void Snd_MeStop( int frame )
{
	int no,type;
	u16 i;

	NNS_SndPlayerStopSeq( Snd_HandleGet(SND_HANDLE_ME), frame );	//ME~

	//Tuʃf[^[hĂ鎞̂ŁAMEf[^݂̂̒ǉ폜I
	Snd_HeapLoadState( Snd_GetHeapSaveLv(SND_HEAP_SAVE_ME) );		//MEǉA폜p
	
	return;
}

//--------------------------------------------------------------
/**
 * @brief	MEI҂  IAEFCgĂBGM𕜋A
 *
 * @param	none
 *
 * @retval	"MEĐ=TRUEAEFCg=TRUEABGMĊJ=FALSE"
 */
//--------------------------------------------------------------
int Snd_MePlayCheckBgmPlay(void)
{
	u8 player_no;
	u16 now_bgm_no;
	u16* me_wait = Snd_GetParamAdrs(SND_W_ID_ME_WAIT);

	//MEI҂
	if( Snd_MePlayCheck() == TRUE ){
		return TRUE;
	}

	Snd_MeStop( 0 );												//ME~

	now_bgm_no = Snd_NowBgmNoGet();									//BGMio[擾
	player_no = Snd_GetPlayerNo( now_bgm_no );

	//݂̃V[PXio[0łȂ
	if( player_no != 0xff ){
		Snd_PlayerPause( player_no, FALSE );						//BGMĊJ
	}

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	MEʃEFCglZbg
 *
 * @param	no			MEio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_MeWaitSet( u16 no )
{
	u16* me_wait = Snd_GetParamAdrs(SND_W_ID_ME_WAIT);

#if 0
	//MEƂ̋ʃEFCg
	switch( no ){
	case SEQ_FANFA1:
		break;
	case SEQ_FANFA4:
		break;
	}
#endif

	(*me_wait) = SND_ME_COMMON_WAIT;
	return;						
}


//==============================================================================================
//
//	gȂBBB
//
//==============================================================================================
#if 0
//--------------------------------------------------------------
/**
 * @brief	BGMf[^[h
 *
 * @param	no		BGMio[
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * gp(1)	}bvf[^擾BGMf[^[h
 * Snd_HeapLoadState( Snd_GetHeapSaveLv(SND_HEAP_SAVE_SE) );	//BGMJ
 * Snd_LoadBgm( map->bgm );										//BGM[h
 *
 * gp(2)	w肵BGMf[^[h
 * Snd_HeapLoadState( Snd_GetHeapSaveLv(SND_HEAP_SAVE_SE) );	//BGMJ
 * Snd_LoadBgm( SEQ_DOORO_X3 );									//BGM[h
 *
 * HA̋ڂł́ABGMf[^̂݃[h邱ƂɂȂ̂ŁA
 * SEABGM̏Ƀf[^[h悤ɂāABGMJA[hƂɂ
 */
//--------------------------------------------------------------
int Snd_LoadBgm( u16 no );
int Snd_LoadBgm( u16 no )
{
	return Snd_ArcLoadSeq( no, Snd_HeapHandleGet() );	//V[PXAoNAg`[h
}

//--------------------------------------------------------------
/**
 * @brief	莝|P[h
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * Kwۑ͂ĂȂI
 */
//--------------------------------------------------------------
int Snd_LoadTemotiPMVoice(void);
int Snd_LoadTemotiPMVoice()
{
	int i,ret;
	u16 no;

	/*****************/
	//Ƃ肠BBB
	/*****************/
	for( i = 0; i < 6 ;i++ ){
		no = (MONSNO_HUSIGIDANE + i);

#ifdef PM_VOICE_SEQ_ARC
		//V[PXA[JCu
		ret = Snd_ArcLoadSeqArc( no, Snd_HeapHandleGet() );		//V[PXA[JCu[h
		ret = Snd_ArcLoadBank( no, Snd_HeapHandleGet() );		//oN[h
#else
		//V[PX
		ret = Snd_ArcLoadSeq( no, Snd_HeapHandleGet() );		//V[PXAoNAg`[h
#endif
	}

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	w肵|P[h
 *
 * @param	no		|Pio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * Kwۑ͂ĂȂI
 */
//--------------------------------------------------------------
int Snd_LoadPMVoice( u16 no );
int Snd_LoadPMVoice( u16 no )
{
	int ret;

#ifdef PM_VOICE_SEQ_ARC
	//V[PXA[JCu
	ret = Snd_ArcLoadSeqArc( no, Snd_HeapHandleGet() );		//V[PXA[JCu[h
	ret = Snd_ArcLoadBank( no, Snd_HeapHandleGet() );		//oN[h
#else
	//V[PX
	ret = Snd_ArcLoadSeq( no, Snd_HeapHandleGet() );		//V[PXAoNAg`[h
#endif

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	|P~
 *
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * 2ɖ炷Ƃ͑ΉĂȂ
 */
//--------------------------------------------------------------
void Snd_PMVoiceStopByPlayerNo( int frame );
void Snd_PMVoiceStopByPlayerNo( int frame )
{
	NNS_SndPlayerStopSeqByPlayerNo( PLAYER_PV, frame );
	return;
}

#endif







