//==============================================================================================
/**
 * @file	snd_system.h
 * @brief	TEhVXe
 * @author	Satoshi Nohara
 * @date	2005.11.08
 *
 * snd_tool,snd_play,(main)̂݃ANZX
 * snd_system
 *     |
 *     |
 * f[^ZbgȂǂ̏܂Ƃ߂	ĐA~Ȃǂ̏܂Ƃ߂
 * snd_tool								snd_play
 *     |
 *     |
 * efĂ΂(ɃtB[hCxg)
 * fld_bgm
 */
//==============================================================================================
#ifndef __SND_SYSTEM_H__
#define __SND_SYSTEM_H__


//#define STREAM_ON	//Xg[Lɂ


//==============================================================================================
//
//	TEhVXe[Nւ̕sS^|C^
//
//==============================================================================================
typedef	struct _SND_WORK SND_WORK;


//==============================================================================================
//
//	(snd_system,snd_tool,snd_play)݂̂Ŏgp`
//
//==============================================================================================
#define WAVE_ARC_GROUP_MAX		(4)							//g`A[JCuO[vő吔
#define SE_HANDLE_MAX			(4)							//SẼTEhnhő吔

#define CAPTURE_THREAD_PRIO		(3)							//Lv`Xbh̗Dx
#define CAPTURE_BUFSIZE			(0x1000)					//Lv`obt@TCY
#define CAPTURE_FORMAT		(NNS_SND_CAPTURE_FORMAT_PCM16)	//Lv`̃tH[}bg

#define STREAM_THREAD_PRIO		(10)						//

//Kwx擾`
enum{
	SND_HEAP_SAVE_START = 0,								//Sď
	SND_HEAP_SAVE_GLOBAL,									//풓ȊO
	SND_HEAP_SAVE_SE,										//풓ASEȊO(BGM)
	SND_HEAP_SAVE_BGM,										//BGM̏ɐς񂾂̂
	SND_HEAP_SAVE_ME,										//MEǉA폜p

	SND_HEAP_SAVE_MAX,										//ő吔
};

//SND_WORK̃o[ɃANZX`
enum{
	SND_W_ID_WAVEOUT_HANDLE_NORMAL = 0,		//g`nh
	SND_W_ID_WAVEOUT_HANDLE_CHORUS,			//g`nh
	SND_W_ID_BANK_INFO,						//oN\
	SND_W_ID_CAPTURE_BUF,					//Lv`obt@
	SND_W_ID_CALLBACK_INFO,					//GtFNg̃R[obNϐ

	SND_W_ID_FADE_COUNT,					//tF[hJE^[
	SND_W_ID_NEXT_WAIT,						//BGM炷܂ł̃EFCg
	SND_W_ID_NEXT_FRAME,					//BGM̃tF[hCt[

	SND_W_ID_NOW_BGM_NO,					//BGMio[(Z[uKvIƂňړ)
	SND_W_ID_NEXT_BGM_NO,					//BGMio[(Z[uKvIƂňړ)

	SND_W_ID_FIELD_PAUSE_FLAG,				//PLAYER_FIELD|[YĂ邩tO
	SND_W_ID_BGM_PAUSE_FLAG,				//PLAYER_BGM|[YĂ邩tO
	SND_W_ID_ME_WAIT,						//MEEFCg

	SND_W_ID_REVERSE_FLAG,					//tĐgptO
	SND_W_ID_WAVEOUT_CH_NORMAL_FLAG,		//g`ŎgpCHmۂtO
	SND_W_ID_WAVEOUT_CH_CHORUS_FLAG,		//g`ŎgpCHmۂtO(CHORUS)
	SND_W_ID_CHORUS_FLAG,					//R[XgptO

	SND_W_ID_LIGHT_NIGHT_FLAG,				//邩tO
	SND_W_ID_FILTER_SIZE,					//tB^[TCY
	SND_W_ID_SCENE_MAIN,					//݂̃CV[
	SND_W_ID_SCENE_SUB,						//݂̃TuV[

	SND_W_ID_HEAP_SAVE_START,				//TEhq[vKwx
	SND_W_ID_HEAP_SAVE_GLOBAL,				//TEhq[vKwx
	SND_W_ID_HEAP_SAVE_SE,					//TEhq[vKwx
	SND_W_ID_HEAP_SAVE_BGM,					//TEhq[vKwx
	SND_W_ID_HEAP_SAVE_ME,					//TEhq[vKwx

	SND_W_ID_TRACK_FADE_DATA,				//gbNtF[hf[^
	SND_W_ID_NOON_BITMASK,					//rbg
	SND_W_ID_NIGHT_BITMASK,					//rbg

	SND_W_ID_WAVE_DATA,						//g`f[^̃|C^

	SND_W_ID_REVERSE_BUF,					//tĐp̃obt@̃|C^

	SND_W_ID_LENGTH_TCB,					//ĐTCB

	SND_W_ID_MAX,							//ő吔
};


//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEh
 *
 * @param	none
 *
 * @retval	none
 *
 * ̑SẴTEh֐ɌĂтĂB
 * A炩߁AOSĂKv܂B 
 *
 * IRQ荞݂͗LɂĂB܂Å֐̌ŁA
 * OS_SetIrqMask֐ ȂǂŊ荞݂̐ݒ㏑Ȃ悤ɂĂB 
 * 
 */
//--------------------------------------------------------------
extern void Snd_AllInit(void);

//--------------------------------------------------------------
/**
 * @brief	TEht[[N
 *
 * @param	none
 *
 * @retval	none
 *
 * 1t[1xĂяo΁AǂŃR[Ă\Ȃ
 */
//--------------------------------------------------------------
extern void Snd_Main(void);

//--------------------------------------------------------------
/**
 * @brief	TEhXe[^XZbg
 *
 * @param	status		Xe[^X(snd_system.hQ)
 *
 * @retval	none
 * 
 */
//--------------------------------------------------------------
extern void Snd_StatusSet( int status );

//--------------------------------------------------------------
/**
 * @brief	TEhXe[^X`FbN
 *
 * @param	chg_status	Xe[^X(snd_system.hQ)
 *
 * @retval	"TRUE=AFALSE=s"
 */
//--------------------------------------------------------------
extern BOOL Snd_StatusCheck( int chg_status );


//==============================================================================================
//
//	TEhVXe[NANZX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEhVXe[ÑAhX擾
 *
 * @param	none
 *
 * @retval	"TEhVXe[ÑAhX"
 */
//--------------------------------------------------------------
extern SND_WORK* Snd_GetSystemAdrs();

//--------------------------------------------------------------
/**
 * @brief	TEhVXe[ÑõAhX擾
 *
 * @param	type	o̎
 *
 * @retval	"õAhX"
 */
//--------------------------------------------------------------
extern void* Snd_GetParamAdrs( int type );


//==============================================================================================
//
//	q[v֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	̏Ԃۑ
 *
 * @param	heap_lv		ۑ̏Ԃ̊KwxƂĂ[Nւ̃|C^
 *						(NULLƉȂ)
 *
 * @retval	"ۑ̊KwxAs-1"
 *
 * q[v쐬̊Kwx0ŁÅ֐ĂԖɁAKwxP܂B 
 * NNS_SndHeapLoadState֐ĂтƂŁA
 * w肵Kwx̕ۑ̏Ԃɕ邱Ƃł܂B 
 *
 * Ԃ̕ۑɂ́Aq[v܂Bq[v̋󂫗eʂȂꍇ́A֐Ɏs܂B 
 */
//--------------------------------------------------------------
extern int Snd_HeapSaveState(int* heap_lv);

//--------------------------------------------------------------
/**
 * @brief	̏Ԃ𕜌
 *
 * @param	level	Kwx
 *
 * @retval	none
 *
 * NNS_SndHeapSaveState֐Ă񂾒̏Ԃɖ߂Ƃo
 * Ȃ킿ANNS_SndHeapSaveState֐Ă񂾌Ƀ[hf[^폜
 * ̎A[hς݃TEhf[^gčĐĂ鉹͎~܂܂
 */
//--------------------------------------------------------------
extern void Snd_HeapLoadState( int level );

//--------------------------------------------------------------
/**
 * @brief	ǉTEhq[v̗eʂƁA󂫗eʂo͂
 *
 * @param	none
 *
 * @retval	none
 *
 * vC[q[vmۂƁA̕eʂĂ̂ŒӁI
 */
//--------------------------------------------------------------
extern void Snd_UseHeapSizeOsPrint(void);

//--------------------------------------------------------------
/**
 * @brief	TEhq[ṽAhX擾
 *
 * @param	none
 *
 * @retval	"TEhq[ṽAhX"
 */
//--------------------------------------------------------------
extern NNSSndHeapHandle* Snd_HeapHandleGet(void);


//==============================================================================================
//
//	f[^[h֘A
//
//	snd_tool.c
//	FILED,BATTLEȂǂ̃f[^Zbg֐ɌĂ΂
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	O[v[h
 *
 * @param	no		O[vio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcLoadGroup( u16 no );

//--------------------------------------------------------------
/**
 * @brief	V[PXf[^AoNf[^Ag`f[^𓯎Ƀ[h
 *
 * @param	no		V[PXio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcLoadSeq( u16 no );

//--------------------------------------------------------------
/**
 * @brief	V[PXf[^AoNf[^Ag`f[^(I)[h
 *
 * @param	no		V[PXio[
 * @param	flag	ǂ̃f[^[h邩
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * [h`
 * V[PXf[^	NNS_SND_ARC_LOAD_SEQ 
 * oNf[^		NNS_SND_ARC_LOAD_BANK
 * g`A[JCu	NNS_SND_ARC_LOAD_WAVE
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcLoadSeqEx( u16 no, u32 flag );

//--------------------------------------------------------------
/**
 * @brief	V[PXA[JCu[h
 *
 * @param	no		V[PXA[JCuio[
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * V[PXA[JCúÃoNƊ֘A邽߁A
 * IɃoNf[^g`f[^̓[hȂ
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcLoadSeqArc( u16 no );

//--------------------------------------------------------------
/**
 * @brief	g`A[JCu[h
 *
 * @param	no		g`A[JCuio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcLoadWaveArc( u16 no );

//--------------------------------------------------------------
/**
 * @brief	oNf[^[h(KvȔg`f[^[h)
 *
 * @param	no		oNio[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcLoadBank( u16 no );


//==============================================================================================
//
//	TEhnhAg`nh֘A
//
//	snd_play.c
//	BGM,ME,SE,PMVOICE̍Đ֐ɌĂ΂
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	TEhnh̃AhX擾
 *
 * @param	type	TEhnh^Cv
 *
 * @retval	"TEhnh̃AhX"
 */
//--------------------------------------------------------------
extern NNSSndHandle * Snd_HandleGet(int type);

//--------------------------------------------------------------
/**
 * @brief	BGM̃TEhnh̃AhX擾
 *
 * @param	scene	V[()io[
 *
 * @retval	"BGM̃TEhnh̃AhX"
 */
//--------------------------------------------------------------
//extern NNSSndHandle * Snd_BgmHandleGetByScene( u8 scene );

//--------------------------------------------------------------
/**
 * @brief	vC[io[Anhio[擾(nh̃AhXł͂Ȃ̂ŒӁI)
 *
 * @param	player_no	vC[io[
 *
 * @retval	"nhio["
 */
//--------------------------------------------------------------
extern int Snd_GetHandleNoByPlayerNo( int player_no );


//==============================================================================================
//
//	V[PX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	SĂ̍Đ̃V[PXꎞ~܂͍ĊJ
 *
 * @param	flag	TRUE=ꎞ~AFALSE=ĊJ
 *
 * @retval	none
 *
 * SĂ̍Đ̃V[PXł͂ȂATEhnhwAvC[ԍwo邪ۗ
 */
//--------------------------------------------------------------
extern void Snd_PlayerPauseAll( BOOL flag );


//==============================================================================================
//
//	gbNtF[hVXe
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BGMĐ(Xe[^XĐ)  gbN~[g
 *
 * @param	no			BGMio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_BgmPlayTrackMute( u16 no );


#endif


