//==============================================================================================
/**
 * @file	snd_tool.c
 * @brief	TEhc[֐
 * @author	Satoshi Nohara
 * @date	2005.06.09
 *
 * 
 * 퓬ŃQ[I[o[ɂȂāA|PZɖ߂鎞Ȃǂ́A
 * Snd_PauseClearAllĂŁA|[YtONAȂƂȂI
 */
//==============================================================================================
#include "common.h"
#include "snd_system.h"
#include "system/snd_tool.h"
#include "src_os_print.h"
#include "poketool/monsno.h"

#include "system/gamedata.h"					//POKE_NUM_MAX


//ʎqrbg^Cv8bit,TvO[g8k
//#define MIC_TYPE_8BIT_RATE_8K


//==============================================================================================
//
//	
//
//==============================================================================================
#if 0
	//X[v[h畜A̍Đ
	//X[vO̍ĐԂƊSɈv킯ł͂Ȃ
	//ꎞIɉȂA񂾂肷邱Ƃ
	//ꂪɂȂ鎞́AX[vOɍĐ~A
	//X[vɍĐĊJƂΏKvɂȂ
#endif


//==============================================================================================
//
//	`
//
//==============================================================================================


//==============================================================================================
//
//	ϐ
//
//==============================================================================================
//Z[uKv胏[N(ǂ̊ŕKv)
#ifdef MIC_TYPE_8BIT	
static s8 sWaveBuffer[ WAVE_SAMPLE ] ATTRIBUTE_ALIGN(32);	//g`i[obt@
#else
static s16 sWaveBuffer[ WAVE_SAMPLE ] ATTRIBUTE_ALIGN(32);	//g`i[obt@
#endif
static int mono_flag;										//mtO

#if 0
//Z[uTEh[N
typedef struct{
	s16 sWaveBuffer[ WAVE_SAMPLE ] ATTRIBUTE_ALIGN(32);		//g`i[obt@(̊H)
	NNSSndCaptureOutputEffectType stereo_mono;				//XeIm(TEhgpH)
	int mono_flag;											//mtO(0=stereo,1=mono)
}SND_SAVE_WORK;
#endif

//fobNp
int debug_snd_eff;


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void Snd_PlayerSetSeqArcNo( NNSSndHandle *p, int arc_no, int index );

void Snd_NowBgmNoSet( u16 no );
u16 Snd_NowBgmNoGet();
void Snd_NextBgmNoSet( u16 no );
u16 Snd_NextBgmNoGet();

int Snd_GetHeapSaveLv( int type );
void Snd_SceneSet( u8 scene );

int Snd_LoadSeByScene( u8 scene );
BOOL Snd_DataSetByScene( u8 scene, u16 no, int flag );
static void Snd_DataSetSub( u8 scene );
static void Snd_FieldDataSet( u16 no, int flag );
static void Snd_BattleDataSet( u16 no, int flag );
static void Snd_ContestDataSet( u16 no, int flag );
static void Snd_AddSceneSeDataSet( u8 scene );
static void Snd_DemoDataSet( u8 scene, u16 no, int flag );
void Snd_EyeBgmSet( u16 no );
void Snd_HeapStateClear(void);

void Snd_PlayerPause( u8 player, BOOL flag );
void Snd_PauseClearAll();
void Snd_PlayerMoveVolume( int handle_no, int vol, int frame );
void Snd_PlayerSetInitialVolume( int handle_no, int vol );
BOOL Snd_ArcPlayerStartSeqEx( int handle_no, int player_no, u16 no );

int Snd_PlayerCountPlayingSeq( int player_no );
u8 Snd_GetPlayerNo( u16 no );
int Snd_GetSeqNo( NNSSndHandle *p );

const NNSSndArcBankInfo* Snd_GetBankInfo( int no );
u16 Snd_GetBankNo( int no );

static void MicCallback( MICResult /*result*/, void* /*arg*/ );
//static void Snd_MicParamInitSample();
MICResult Snd_MicStartAutoSampling( MICAutoParam* p);
MICResult Snd_MicStopAutoSampling(void);

NNSSndWaveOutHandle * Snd_WaveOutHandleGet( u32 no );
BOOL Snd_WaveOutAllocChannel( u32 no );
void Snd_WaveOutFreeChannel( u32 no );
void Snd_WaveOutSetPan( u32 no, u8 pan );
void Snd_WaveOutSetSpeed( u32 no, u32 spd );
void Snd_WaveOutSetVolume( u32 no, int vol );
BOOL Snd_WaveOutStart( WAVEOUT_WORK* p );
void Snd_WaveOutStop( u32 no );
BOOL Snd_WaveOutIsPlaying( u32 no );

//tĐ
BOOL Snd_WaveOutStartReverse( u16 no, int vol, int pan, u32 ch, int heap_id );
BOOL Snd_WaveOutStartReverseChorus( int vol, int pan );
void Snd_WaveOutStopReverse( u32 );
static void Snd_BufReverse( u8* p, u32 size );

void Snd_CaptureCreateThread(void);
BOOL Snd_CaptureIsActive(void);
NNSSndCaptureType Snd_CaptureGetCaptureType(void);
void Snd_CaptureChangeOutputEffect( NNSSndCaptureOutputEffectType type );

void Snd_CaptureStartOutputEffect( NNSSndCaptureOutputEffectType type );
BOOL Snd_CaptureStartReverb( int vol );
void Snd_CaptureStopReverb( int frame );
void Snd_CaptureReverbVol( int vol, int frame );

BOOL Snd_CaptureStartEffect(void);
void Snd_CaptureStopEffect(void);
void Snd_CaptureEffectLevel( int level );
void EffectCallback( void* lp, void* rp, u32 len, NNSSndCaptureFormat format, void* arg );
void EffectCallback2( void* lp, void* rp, u32 len, NNSSndCaptureFormat format, void* arg );
static inline smp_t GetSample( smp_t* p, int x, int n, const EffectCallbackInfo* info );
static inline int abs( int x );
void SamplingCallback( void* bufferL_p, void* bufferR_p, u32 len, NNSSndCaptureFormat format, void* arg );

void Snd_PlayerSetTrackMute( int handle_no, u16 bitmask, BOOL flag );
void Snd_PlayerSetTrackVolume( NNSSndHandle *p, u16 bitmask, int vol );
void Snd_PlayerSetTrackPitch( int handle_no, u16 bitmask, int pitch );
void Snd_PlayerSetTrackPan( int handle_no, u16 bitmask, int pan );
void Snd_PlayerSetTempoRatio( int handle_no, int tempo );

void Snd_SetMonoFlag( BOOL flag );
void Snd_FadeCountSet( int frame );
int Snd_FadeCountCheck();
void Snd_NextWaitSet( int frame );
int Snd_NextWaitCheck();
//void Snd_SetMasterVolume( int vol );

//fobNp
void* Snd_GetDebugWaveBufAdrs();
BOOL Snd_PlayerHeapCreate( int player_no, u32 size );

void Snd_LightNightFlagSet( int no );
u8 Snd_LightNightFlagGet();
BOOL Snd_FadeOutNextPlaySet( u8 scene, u16 no, int frame, int next_wait, u8 flag, const TRACK_FADE_DATA* adrs );
BOOL Snd_FadeOutNextFadeInSet( u8 scene, u16 no, int frame, int next_wait, int next_frame, u8 flag, const TRACK_FADE_DATA* adrs );
BOOL Snd_TrackFadeSet( u16 no, u8 flag, const TRACK_FADE_DATA* adrs );
void Snd_TrackFadeDataSet( const TRACK_FADE_DATA* adrs );
static void Snd_FadeCommonSet( u8 scene, u16 no, int frame, int next_wait, u8 flag, const TRACK_FADE_DATA* adrs );


//==============================================================================================
//
//	vO
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[PXA[JCuԍݒ
 *
 * @param	p		TEhnh̃AhX
 * @param	arc_no	V[PXA[JCuԍ
 * @param	index	CfbNX
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PlayerSetSeqArcNo( NNSSndHandle *p, int arc_no, int index )
{
	NNS_SndPlayerSetSeqArcNo( p, arc_no, index );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMio[XV
 *
 * @param	no		XVBGMio[
 *
 * @retval	none
 *
 * BGMio[(next_bgm_no)NAĂI
 */
//--------------------------------------------------------------
void Snd_NowBgmNoSet( u16 no )
{
	u16* now_bgm_no = Snd_GetParamAdrs(SND_W_ID_NOW_BGM_NO);
	*now_bgm_no = no;
	Snd_NextBgmNoSet( 0 );			//ӁI BGMio[NAI
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMio[擾
 *
 * @param	none
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
u16 Snd_NowBgmNoGet()
{
	u16* now_bgm_no = Snd_GetParamAdrs(SND_W_ID_NOW_BGM_NO);
	return *now_bgm_no;
}

//--------------------------------------------------------------
/**
 * @brief	BGMio[XV
 *
 * @param	no		XVBGMio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_NextBgmNoSet( u16 no )
{
	u16* next_bgm_no = Snd_GetParamAdrs(SND_W_ID_NEXT_BGM_NO);
	*next_bgm_no = no;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMio[擾
 *
 * @param	none
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
u16 Snd_NextBgmNoGet()
{
	u16* next_bgm_no = Snd_GetParamAdrs(SND_W_ID_NEXT_BGM_NO);
	return *next_bgm_no;
}


//==============================================================================================
//
//	TEhf[^̃[h֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[Zbg
 *
 * @param	scene	V[
 *
 * @retval	none
 *
 * CV[ZbgƁA
 * TuV["SND_SCENE_DUMMY"ɃNA
 */
//--------------------------------------------------------------
void Snd_SceneSet( u8 scene )
{
	u8* scene_main	= Snd_GetParamAdrs(SND_W_ID_SCENE_MAIN);
	u8* scene_sub	= Snd_GetParamAdrs(SND_W_ID_SCENE_SUB);

	if( scene < SND_SCENE_SUB ){
		*scene_main	= scene;			//CV[
		*scene_sub  = SND_SCENE_DUMMY;	//NA
	}else{
		*scene_sub	= scene;			//TuV[
	}

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\n--------TEh@V[--------\n" );
	OS_Printf( "C = %d\n", *scene_main );
	OS_Printf( "Tu = %d\n", *scene_sub );
	OS_Printf( "\n--------------------------------\n\n" );
#endif

	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[L[ɂāASEf[^[h
 *
 * @param	scene		V[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
int Snd_LoadSeByScene( u8 scene )
{
	int ret;

	//SEV[PXO[v
	switch( scene ){

	//^Cg
	//I[vjO
	case SND_SCENE_TITLE:
	case SND_SCENE_OPENING:
		//p̉Ȃ́AtB[h[hĂI
		ret = Snd_ArcLoadGroup( GROUP_SE_FIELD );
		break;

	//tB[h
	case SND_SCENE_FIELD:
		ret = Snd_ArcLoadGroup( GROUP_SE_FIELD );
		break;

	//og
	case SND_SCENE_BATTLE:
		ret = Snd_ArcLoadGroup( GROUP_SE_BATTLE );
		break;

	//ReXg
	case SND_SCENE_CONTEST:
		ret = Snd_ArcLoadGroup( GROUP_SE_BATTLE );						//CFogSE
		GF_ASSERT( (ret == TRUE) && "TEhf[^[hsI" );
		ret = Snd_ArcLoadGroup( GROUP_SE_CONTEST );						//C2FReXgSE
		break;

	//obO
	case SND_SCENE_SUB_BAG:
		ret = Snd_ArcLoadGroup( GROUP_SE_BAG );
		break;

	//O
	case SND_SCENE_SUB_NAMEIN:
		ret = Snd_ArcLoadGroup( GROUP_SE_NAMEIN );
		break;

	//C[WNbv
	case SND_SCENE_SUB_IMAGE:
		ret = Snd_ArcLoadGroup( GROUP_SE_IMAGE );
		break;

	//}
	case SND_SCENE_SUB_ZUKAN:
		ret = Snd_ArcLoadGroup( GROUP_SE_ZUKAN );
		break;

	//G[
	defalut:
		GF_ASSERT( (0) && "V[io[słI" );
		ret = FALSE;
		break;
	}

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	V[L[ɂāATEhf[^Zbg
 *
 * @param	scene	V[
 * @param	no		V[PXio[
 * @param	flag	"gp"
 *
 * @retval	"0=ȂA1=f[^[h"
 *
 * ݂̃V[ƁAnꂽV[́A
 * TEhf[^[hKvȂ̂ŉȂI
 */
//--------------------------------------------------------------
BOOL Snd_DataSetByScene( u8 scene, u16 no, int flag )
{
	u8* scene_main	= Snd_GetParamAdrs(SND_W_ID_SCENE_MAIN);
	u8* scene_sub	= Snd_GetParamAdrs(SND_W_ID_SCENE_SUB);

	//V[͉Ȃ
	if( scene < SND_SCENE_SUB ){
		if( *scene_main == scene ){	
			return 0;
		}
	}else{
		if( *scene_sub == scene ){	
			return 0;
		}
	}

	//V[Zbg
	Snd_SceneSet( scene );

	switch( scene ){

	//tB[h
	case SND_SCENE_FIELD:
		Snd_FieldDataSet( no, flag );
		break;

	//og
	case SND_SCENE_BATTLE:
		Snd_BattleDataSet( no, flag );
		break;

	//ReXg
	case SND_SCENE_CONTEST:
		Snd_ContestDataSet( no, flag );
		break;

	//Tu(BGMpASEǉ[h)
	case SND_SCENE_SUB_BAG:
	case SND_SCENE_SUB_NAMEIN:
	case SND_SCENE_SUB_IMAGE:
	case SND_SCENE_SUB_ZUKAN:
		/************/
		//ǉĂ
		/************/
		Snd_AddSceneSeDataSet( scene );
		break;

	//SĒ~āA풓ȊO[h
	case SND_SCENE_TITLE:
	case SND_SCENE_OPENING:
		/************/
		//ǉĂ
		/************/
		Snd_DemoDataSet( scene, no, flag );
		break;

	//|[YKvȃf͕ʂ̃ZbgR}h
	//case SND_SCENE_DEMO:
		//break;

	//Ȃ
	defalut:
		return 0;
	};

	return 1;		//f[^[h
}

//--------------------------------------------------------------
/**
 * @brief	TEhf[^Zbgʏ
 *
 * @param	scene	V[
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_DataSetSub( u8 scene )
{
	int* heap_save_global	= Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_GLOBAL);

	Snd_HeapLoadState( *heap_save_global );						//풓ȊO
	//풓͏Ȃ̂ŁAēxKwۑKv͂ȂI
	//Snd_HeapSaveState(&wk->heap_save[SND_HEAP_SAVE_GLOBAL]);	//Kwۑ(풓ȊOɎgp)
	
	Snd_LoadSeByScene( scene );									//SEV[PXO[v
	Snd_HeapSaveState(Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_SE));	//Kwۑ(풓ASEȊOgp)

	return;
}

//--------------------------------------------------------------
/**
 * @brief	tB[hʂɐ؂ւ鎞̃TEhf[^Zbg
 *
 * @param	no		V[PXio[
 * @param	flag	"gp"
 *
 * @retval	none
 *
 * f[^[h
 * 풓
 * SE
 * BGM(WAVEARC)
 *
 * V[PXAoN̓vC[q[vŃ[hĂI
 *
 * 퓬ŃQ[I[o[ɂȂāA|PZɖ߂ƂȂǂ́A
 * Snd_PauseClearAllĂŁA|[YtONAȂƂȂI
 */
//--------------------------------------------------------------
static void Snd_FieldDataSet( u16 no, int flag )
{
	int ret,player_seq_no;
	u16 bgm;
	u8* field_pause_flag	= Snd_GetParamAdrs(SND_W_ID_FIELD_PAUSE_FLAG);
	int* heap_save_global	= Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_GLOBAL);

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\nTEhf[^[h@tB[hV[؂ւ聄\n" );
#endif

	//|[YĂȂāAȂ炻ƂABGMpɂĂI

	//PLAYER_FIELD|[YĂȂ
	if( *field_pause_flag == 0 ){
	
		//PLAYER_FIELDBGMio[擾
		player_seq_no = Snd_GetSeqNo( Snd_HandleGet(SND_HANDLE_FIELD) );

		//Ȃ炻Ƃ
		if( player_seq_no == no ){

			//Snd_AddSceneSeDataSet( SND_SCENE_FIELD );			//SEǉ[h

			//PLAYER_FIELD~ĂAʉʂɍs΁A
			//߂ĂƂɁABGMio[擾̒lς̂ŁA
			//FieldData[hI
			
			return;		//ӁI
		}
	}

	//菇(1)
	Snd_StopEx();												//tB[hBGM𔲂đS~

	//ʏ
	Snd_DataSetSub( SND_SCENE_FIELD );

	//tB[hBGM|[YĂI
	if( *field_pause_flag == 1 ){

#ifdef SOUND_OS_PRINT_ON
		OS_Printf( "tB[hBGM|[YI\n" );
#endif

		//V[PXAoN̓vC[q[vŃ[hĂI
		ret = Snd_ArcLoadSeqEx(no, NNS_SND_ARC_LOAD_WAVE );		//g`A[JCu[h
		Snd_HeapSaveState( Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM) );//Kwۑ(BGM̌p)

		//|[YԂ畜Aɂ́AoNă[hKv邪A
		//vC[q[vŃoN[hĂ̂ővI
	
		//Snd_NowBgmNoSet( Snd_GetSeqNo(Snd_HandleGet(SND_HANDLE_FIELD)) );	//BGMio[Zbg

		Snd_PlayerPause( PLAYER_FIELD, FALSE );						//tB[hBGMĊJ
		Snd_BgmFadeIn( BGM_VOL_MAX, 40, BGM_FADEIN_START_VOL_MIN );	//tF[hC
		return;
	}

	//BGMĐ(Xe[^XĐ)  gbN~[g
	Snd_BgmPlayTrackMute( no );										//tB[hBGMĐ

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ogʂɐ؂ւ鎞̃TEhf[^Zbg
 *
 * @param	no		V[PXio[
 * @param	flag	"gp"
 *
 * @retval	none
 *
 * f[^[h
 * 풓
 * SE
 * BGM
 */
//--------------------------------------------------------------
void Snd_BattleDataSet( u16 no, int flag )
{
	int* heap_save_global	= Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_GLOBAL);

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\nTEhf[^[h@ogV[؂ւ聄\n" );
#endif

	//菇(1)
	Snd_StopEx();												//tB[hBGM𔲂đS~
	Snd_PlayerPause( PLAYER_FIELD, TRUE );						//tB[hBGM|[Y

	//ʏ
	Snd_DataSetSub( SND_SCENE_BATTLE );

	//tB[hBGM̃V[PXAoŃAvC[q[vŏĂ̂ŁA
	//~Ă΂ȂƊJȂ(|[YԂɂĂ)

	Snd_BgmPlay( no );											//BGMĐ

	return;
}

//--------------------------------------------------------------
/**
 * @brief	ReXgʂɐ؂ւ鎞̃TEhf[^Zbg
 *
 * @param	no		V[PXio[
 * @param	flag	"gp"
 *
 * @retval	none
 *
 * f[^[h
 * 풓
 * SE
 * BGM
 *
 * bŁAobÕTuV[[hĂ
 */
//--------------------------------------------------------------
void Snd_ContestDataSet( u16 no, int flag )
{
	int* heap_save_global	= Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_GLOBAL);

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\nTEhf[^[h@ReXgV[؂ւ聄\n" );
#endif

	//菇(1)
	Snd_Stop();													//S~

	//ʏ
	Snd_DataSetSub( SND_SCENE_CONTEST );

	Snd_BgmPlay( no );											//BGMĐ

	/***********************************************************/
	//b菈
	//ReXgŃobỎgpĂ̂Œǉ[hĂ
	/***********************************************************/
	//Snd_DataSetByScene( SND_SCENE_SUB_BAG, 0, 0 );	// TEhf[^[h(obO)(BGMp)

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMpASEǉ[hA؂ւ̃TEhf[^Zbg
 *
 * @param	scene		V[
 *
 * @retval	none
 *
 * f[^[h
 * 풓
 * SE
 * BGM(WAVEARC)
 * ADD_SCENE_SE
 */
//--------------------------------------------------------------
static void Snd_AddSceneSeDataSet( u8 scene )
{
	int* heap_save_bgm = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM);

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\nTEhf[^[h %d ؂ւ聄\n", scene );
#endif

	//ʏ
	//Snd_DataSetSub( scene );

	Snd_HeapLoadState( *heap_save_bgm );						//BGM̌

	Snd_LoadSeByScene( scene );									//SEV[PXO[v

	return;
}

//--------------------------------------------------------------
/**
 * @brief	fʂɐ؂ւ鎞̃TEhf[^Zbg
 *
 * @param	scene	V[
 * @param	no		V[PXio[
 * @param	flag	"gp"
 *
 * @retval	none
 *
 * f[^[h
 * 풓
 * SE
 * BGM(SEQ,BANK,WAVEARC)
 */
//--------------------------------------------------------------
static void Snd_DemoDataSet( u8 scene, u16 no, int flag )
{
	int* heap_save_global	= Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_GLOBAL);

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "TEhf[^[h@fV[؂ւ聄\n" );
#endif

	//菇(1)
	Snd_Stop();														//S~

	//ʏ
	Snd_DataSetSub( scene );

	Snd_BgmPlay( no );												//BGMĐ

	return;
}

//--------------------------------------------------------------
/**
 * @brief	Ȃɐ؂ւ鎞̃TEhf[^Zbg
 *
 * @param	no		V[PXio[
 *
 * @retval	none
 *
 * FIELDĂ΂邱ƂOƂĂI
 */
//--------------------------------------------------------------
void Snd_EyeBgmSet( u16 no )
{
	int ret;
	SND_WORK* wk	= Snd_GetSystemAdrs();

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\nTEhf[^[h@Ȑ؂ւ聄\n" );
#endif

	//BattleDataSetŃV[̃ZbĝŁA
	//̃^C~OŃV[ZbgKv͂ȂI

	//菇(1)
	Snd_StopEx();												//tB[hBGM𔲂đS~
	Snd_PlayerPause( PLAYER_FIELD, TRUE );						//tB[hBGM|[Y

	ret = Snd_BgmPlay( no );									//BGMĐ

	return;
}

//--------------------------------------------------------------
/**
 * @brief	[hĂȂԂɂ(TEheXĝ݂Ŏg)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_HeapStateClear(void)
{
	int* heap_save_start = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_START);
	Snd_HeapLoadState( *heap_save_start );
	//Snd_HeapSaveState( heap_save_start );		//Kwۑ(SďɎgp)
	return;
}


//==============================================================================================
//
//	q[v֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Kwx擾
 *
 * @param	wk		SND_WORK^̃AhX
 * @param	type	Kwx`(snd_tool.hQ)
 *
 * @retval	"Kwx"
 */
//--------------------------------------------------------------
int Snd_GetHeapSaveLv( int type )
{
	int* heap_save;
	SND_WORK* wk = Snd_GetSystemAdrs();

	if( type >= SND_HEAP_SAVE_MAX ){
		GF_ASSERT( (0) && "KwxsłI" );
		heap_save = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM);
		return *heap_save;
	}

	switch( type ){
	case SND_HEAP_SAVE_START:
		heap_save = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_START);
		break;
	case SND_HEAP_SAVE_GLOBAL:
		heap_save = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_GLOBAL);
		break;
	case SND_HEAP_SAVE_SE:
		heap_save = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_SE);
		break;
	case SND_HEAP_SAVE_BGM:
		heap_save = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM);
		break;
	case SND_HEAP_SAVE_ME:
		heap_save = Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_ME);
		break;
	};

	return *heap_save;
}


//==============================================================================================
//
//	V[PX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[PXꎞ~܂͍ĊJ܂B 
 *
 * @param	player	vC[io[(sound_data.sadlQ)
 * @param	flag	TRUE=ꎞ~AFALSE=ĊJ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 * ԂςȂꍇAႦ΁AłɈꎞ~Ԃ̎Ɉꎞ~sĂA܂B 
 *
 * 
 * ꎞ~sƁẢ͋Iɒ~܂B
 * ĊJsĂẢĐ邱Ƃ͂܂̂ŒӂĂB
 * ĊJ́Ãm[gI特n߂܂B 
 */
//--------------------------------------------------------------
void Snd_PlayerPause( u8 player, BOOL flag )
{
	u8 handle_no;
	u8* pause_flag;

	if( player == PLAYER_FIELD ){
		pause_flag	= Snd_GetParamAdrs( SND_W_ID_FIELD_PAUSE_FLAG );
		handle_no	= SND_HANDLE_FIELD;

	}else if( player == PLAYER_BGM ){
		pause_flag	= Snd_GetParamAdrs( SND_W_ID_BGM_PAUSE_FLAG );
		handle_no	= SND_HANDLE_BGM;

	}else{
		return;			//Ȃ
	}

	//ĊĴŁABGMio[ɃZbgȂ
	if( flag == FALSE ){
		Snd_NowBgmNoSet( Snd_GetSeqNo(Snd_HandleGet(handle_no)) );
	}

	NNS_SndPlayerPause( Snd_HandleGet(handle_no), flag );
	*pause_flag = flag;	//|[YĂ邩tO
	return;
}

//--------------------------------------------------------------
/**
 * @brief	SẴ|[YĂ邩tÕNA
 *
 * @param	none
 *
 * @retval	none
 *
 * 퓬ŃQ[I[o[ɂȂāA|PZɖ߂ƂȂǂɁA
 * FieldDataSetĂԑOɁA|[YtONAȂƂȂI
 */
//--------------------------------------------------------------
void Snd_PauseClearAll()
{
	u8* field_pause_flag	= Snd_GetParamAdrs( SND_W_ID_FIELD_PAUSE_FLAG );
	u8* bgm_pause_flag		= Snd_GetParamAdrs( SND_W_ID_BGM_PAUSE_FLAG );

	//ǉꂽ̑ΉYlƔzŎĂق悳
	//ȏ͑Ȃ͂BBB
	
	*field_pause_flag = 0;
	*bgm_pause_flag = 0;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX̃{[XɕύX
 *
 * @param	p		TEhnh̃AhX
 *
 * @retval	none
 *
 * frames0̎AɌ݂̃{[lXV܂B
 * Ƃ΁Ã݂{[lƂ͖֌WɁA
 * {[lAʂ̒lɎԕωꍇ́A
 * ܂Aframes0ƂĂ̊֐ĂтāÃ݂{[lXVA
 * Ăѓ֐ŁAڕWƂ{[lw肵܂B 
 *
 * V[PXX^[g̃{[l0ŁA NNS_SndMain֐ŁA127 ɕω܂B
 * ̂߁AV[PXX^[gɂ̊֐ĂтƁA
 * {[0珙XɎw̃{[֕ω悤ȁAtF[hCʂ܂B 
 *
 * ̃{[ĺA NNS_SndPlayerSetVolume֐̒lƂ́AƗČʂ𔭊A
 * ݂ɏdˍ킳܂BAtF[hAEǵAŐݒ肵l͖܂B 
 */
//--------------------------------------------------------------
void Snd_PlayerMoveVolume( int handle_no, int vol, int frame )
{
	NNS_SndPlayerMoveVolume( Snd_HandleGet(handle_no), vol, frame );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PX̏{[ݒ
 *
 * @param	p		TEhnh̃AhX
 * @param	vol		{[(0-127)
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 *
 * {[̃ftHgĺAő127łB
 * ̒l̉e̓V[PXŜɂ܂B
 *
 * ̊֐́ANNS_SndArcPlayerStartSeq*֐ NNS_SndArcPlayerStartSeqArc*֐
 * ĂтĂ܂BēxÅ֐ĂтƁAݒ肵l㏑܂B
 * ㏑Ȃꍇ́A NNS_SndPlayerSetVolume֐ȂǂgĂB
 *
 * 
 * Snd_PMVoicePlay( no );
 * Snd_PlayerSetInitialVolume( handle_no. 30 );
 * {[30ōĐ
 *
 * ̂ƁA
 * Snd_PMVoicePlay( no );
 * ftHg̒l127ōĐ(ɖ߂Ă)
 *
 * tɂƁAɃ{[30ɂA
 * Snd_PlayerSetInitialVolume( handle_no. 30 );
 * 𖈉Zbg
 */
//--------------------------------------------------------------
void Snd_PlayerSetInitialVolume( int handle_no, int vol )
{
	//G[
	if( vol < 0 ){
		vol = 0;
	}

	if( vol > 127 ){
		vol = 127;
	}

	NNS_SndPlayerSetInitialVolume( Snd_HandleGet(handle_no), vol );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXĐ(vC[ԍw)
 *
 * @param	handle_no	TEhnhio[
 * @param	player_no	vC[io[
 * @param	no			BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * ĐɐƁATEhnhɃV[PXт܂B 
 *
 * V[PXf[^vC[q[vŃ[h鎞́A
 * eʂȂƍĐsI
 */
//--------------------------------------------------------------
BOOL Snd_ArcPlayerStartSeqEx( int handle_no, int player_no, u16 no )
{
	return NNS_SndArcPlayerStartSeqEx( Snd_HandleGet(handle_no), player_no, -1, -1, no );
}


//==============================================================================================
//
//	vC[֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Đ̃V[PX̐Ԃ
 *
 * @param	player_no	vC[ԍ
 *
 * @retval	"Đ̃V[PX̐"
 *
 * PLAYER_FIELD	: tB[hBGM
 * PLAYER_ME 	: ME
 * PLAYER_SE_1 	: ʉ
 * PLAYER_SE_2 	: ʉ
 * PLAYER_SE_3 	: ʉ
 * PLAYER_SE_4 	: ʉ
 * PLAYER_PV	: |P
 * PLAYER_VOICE	: 
 * PLAYER_BGM	: tB[hȊOBGM
 */
//--------------------------------------------------------------
int Snd_PlayerCountPlayingSeq( int player_no )
{
	//̓`FbNĂȂ̂ŒӁI
	if( player_no < 0 ){
		GF_ASSERT( (0) && "słI" );
	}

	return NNS_SndPlayerCountPlayingSeqByPlayerNo( player_no );
}

//--------------------------------------------------------------
/**
 * @brief	V[PXio[vC[io[擾
 *
 * @param	no		V[PXio[
 *
 * @retval	"vC[io[A0xff=擾s"
 */
//--------------------------------------------------------------
u8 Snd_GetPlayerNo( u16 no )
{
	const NNSSndSeqParam* param;
	
	if( no == 0 ){
		//GF_ASSERT( (0) && "V[PXio[sȂ̂ŃvC[io[擾sI" );
		return 0xff;	//G[
	}

	//TEhA[JCůeV[PXɑ΂AV[PXp[^\̂擾
	param = NNS_SndArcGetSeqParam( no );
	//OS_Printf( "vC[io[ = %d\n", param->playerNo );

	if( param == NULL ){
		GF_ASSERT( (0) && "V[PXio[sȂ̂ŃvC[io[擾sI" );
		return 0xff;	//G[
	}

	return param->playerNo;
}

//--------------------------------------------------------------
/**
 * @brief	TEhnhV[PXio[擾
 *
 * @param	p			TEhnh̃AhX
 *
 * @retval	"V[PXio["
 */
//--------------------------------------------------------------
int Snd_GetSeqNo( NNSSndHandle *p )
{
	return NNS_SndPlayerGetSeqNo( p );
}


//==============================================================================================
//
//	oN֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	oN\̂̃AhX擾
 *
 * @param	no		V[PXio[
 *
 * @retval	"oN\̂̃AhX"
 */
//--------------------------------------------------------------
const NNSSndArcBankInfo* Snd_GetBankInfo( int no )
{
	const NNSSndArcBankInfo* info;

	info = NNS_SndArcGetBankInfo( Snd_GetBankNo(no) );

	//`FbN
	if( info == NULL ){
		OS_Printf( "oN\̂̃AhX擾o܂łB\n" );
	}

	return info;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXio[oNio[擾
 *
 * @param	no		V[PXio[
 *
 * @retval	"0=G[A0ȊO=oNio["
 */
//--------------------------------------------------------------
u16 Snd_GetBankNo( int no )
{
	const NNSSndSeqParam* param;
	
	//TEhA[JCůeV[PXɑ΂AV[PXp[^\̂擾
	param = NNS_SndArcGetSeqParam( no );
	if( param == NULL ){
		OS_Printf( "oNio[擾o܂łB\n" );
		OS_Printf( "nꂽV[PXio[ %d łB\n", no );
		return 0;
	}

	return param->bankNo;
}


//==============================================================================================
//
//	}CN֘A
//
//==============================================================================================
      
//--------------------------------------------------------------
/**
 * @brief	}CNp[^̐ݒTv(gpĂ܂)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
#if 0
static void Snd_MicParamInitSample()
{
	MICAutoParam mic;							//}CNp[^

	//Lrbg 12 rbgitj̃TvOB
	//o̓f[^͈̔͂ -32768 ` 32752 ɂȂ܂B 
#ifdef MIC_TYPE_8BIT_RATE_8K
	mic.type			= MIC_SAMPLING_TYPE_SIGNED_8BIT;
#else
	mic.type			= MIC_SAMPLING_TYPE_SIGNED_12BIT;
#endif

	mic.buffer			= sWaveBuffer;
	mic.size			= sizeof( sWaveBuffer );

		//\IȃTvO[gARM7̃^C}[ɊZl̒`
#ifdef MIC_TYPE_8BIT_RATE_8K
	mic.rate			= MIC_SAMPLING_RATE_8K;
#else
	mic.rate			= MIC_SAMPLING_RATE_16K;
#endif

	//ATvOɃobt@[vtO
	mic.loop_enable		= FALSE;

	//obt@OaۂɌĂяoR[obN֐ւ̃|C^
	mic.full_callback	= MicCallback;

	//obt@OaۂɌĂяoR[obN֐֓n
	mic.full_arg		= NULL;

	return;
}
#endif
 
//--------------------------------------------------------------
/**
 * @brief	}CNR[obN֐
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void MicCallback( MICResult /*result*/, void* /*arg*/ )
{
    OS_Printf( "Mic Callback Done\n" );
}

//--------------------------------------------------------------
/**
 * @brief	^Jn
 *
 * @param	p		MICAutoParam^̃AhX
 *
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
MICResult Snd_MicStartAutoSampling( MICAutoParam* p )
{
	MICResult ret;

	ret = MIC_StartAutoSampling( p );

	if( ret != MIC_RESULT_SUCCESS ){
		OS_Printf( "}CNTvOJns܂I\n" );
	}

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	^~
 *
 * @param	none
 *
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
MICResult Snd_MicStopAutoSampling(void)
{
	MICResult ret;
	SND_WORK* wk = Snd_GetSystemAdrs();

	ret = MIC_StopAutoSampling();

	if( ret != MIC_RESULT_SUCCESS ){
		OS_Printf( "}CNTvO~s܂I\n" );
	}

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	蓮^
 * @param	type      TvO[g̃^Cv
 * @param	heap      L^̈
 * @param	callback  L^ۂ̃R[obN
 * @param	arg       R[obNɓn|C^
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
MICResult Snd_MicManualSampling(MICSamplingType type ,void* heap,MICCallback callback,void* arg)
{
	MICResult ret;

    ret = MIC_DoSamplingAsync( type, heap, callback, arg);
	if( ret != MIC_RESULT_SUCCESS ){
        OS_Printf( "}CN蓮TvOs\n" );
	}
	return ret;
}

//==============================================================================================
//
//	g`Đ֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	g`nh̃AhX擾
 *
 * @param	no		gpĂ`lio[
 *
 * @retval	"g`nh̃AhX"
 *
 * BGM		NNSSndHandle
 * g`		NNSSndWaveOutHandle
 * nh̃^CvႤ̂ŒӁI
 */
//--------------------------------------------------------------
NNSSndWaveOutHandle * Snd_WaveOutHandleGet( u32 no )
{
	SND_WORK* wk = Snd_GetSystemAdrs();
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);

	if( (no != WAVEOUT_CH_NORMAL) && (no != WAVEOUT_CH_CHORUS) ){
		GF_ASSERT( (0) && "`lio[słI" );
	}

	if( (no == WAVEOUT_CH_NORMAL) && (*ch_normal_flag == 0) ){	//mۃtOOFF
		GF_ASSERT( (0) && "mۂĂȂNORMALnhɃANZXĂ܂I" );
	}

	if( (no == WAVEOUT_CH_CHORUS) && (*ch_chorus_flag == 0) ){	//mۃtOOFF
		GF_ASSERT( (0) && "mۂĂȂCHORUSnhɃANZXĂ܂I" );
	}

	if( no == WAVEOUT_CH_NORMAL ){
		return Snd_GetParamAdrs(SND_W_ID_WAVEOUT_HANDLE_NORMAL);
	}else{
		return Snd_GetParamAdrs(SND_W_ID_WAVEOUT_HANDLE_CHORUS);
	}
}
 
//--------------------------------------------------------------
/**
 * @brief	g`ĐpɃ`lmۂ
 *
 * @param	no		gp`lio[
 *
 * @retval	BOOL	TRUE=AFALSE=s
 */
//--------------------------------------------------------------
BOOL Snd_WaveOutAllocChannel( u32 no )
{
	u8* ch_normal_flag;
	u8* ch_chorus_flag;
	NNSSndWaveOutHandle* wave_handle;
	SND_WORK* wk = Snd_GetSystemAdrs();

	ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	ch_chorus_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);

	if( (no != WAVEOUT_CH_NORMAL) && (no != WAVEOUT_CH_CHORUS) ){
		GF_ASSERT( (0) && "`lio[słI" );
	}

	if( no == WAVEOUT_CH_NORMAL ){

		if( *ch_normal_flag == 0 ){		//mۃtOOFF

			//g`nh̃AhX擾
			wave_handle = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_HANDLE_NORMAL);
			*wave_handle = NNS_SndWaveOutAllocChannel( no );			//CHm

			if ( *wave_handle == NNS_SND_WAVEOUT_INVALID_HANDLE ) {
				OS_Printf("NNS_SndWaveOutAllocChannel is Failed\n");
				return FALSE;			//s
			}
			*ch_normal_flag = 1;		//mۃtOON
		}else{
			GF_ASSERT( (0) && "`lJĂȂ̂ɁAmۂ悤ƂĂ܂I" );
		}

	}else{

		if( *ch_chorus_flag == 0 ){		//mۃtOOFF

			wave_handle = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_HANDLE_CHORUS);
			*wave_handle = NNS_SndWaveOutAllocChannel( no );			//CHm

			if ( *wave_handle == NNS_SND_WAVEOUT_INVALID_HANDLE ) {
				OS_Printf("NNS_SndWaveOutAllocChannel is Failed\n");
				return FALSE;			//s
			}
			*ch_chorus_flag = 1;		//mۃtOON
		}else{
			GF_ASSERT( (0) && "`lJĂȂ̂ɁAmۂ悤ƂĂ܂I" );
		}
	}

	return TRUE;		//
}
 
//--------------------------------------------------------------
/**
 * @brief	g`Đp̃`l
 *
 * @param	no		gp`lio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_WaveOutFreeChannel( u32 no )
{
	NNSSndWaveOutHandle* wave_handle;
	SND_WORK* wk		= Snd_GetSystemAdrs();
	u8* ch_normal_flag	= Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);
	u8* ch_chorus_flag	= Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_CHORUS_FLAG);

	if( (no != WAVEOUT_CH_NORMAL) && (no != WAVEOUT_CH_CHORUS) ){
		GF_ASSERT( (0) && "`lio[słI" );
		return;
	}

	if( no == WAVEOUT_CH_NORMAL ){
		if( *ch_normal_flag == 1 ){	//mۃtOON

			wave_handle = Snd_WaveOutHandleGet(no);
			NNS_SndWaveOutFreeChannel( *wave_handle );
			*ch_normal_flag = 0;	//mۃtOOFF

		}else{
			GF_ASSERT( (0) && "mۂĂȂ`lJ悤ƂĂ܂I" );
		}
	}else{
		if( *ch_chorus_flag == 1 ){	//mۃtOON

			wave_handle = Snd_WaveOutHandleGet(no);
			NNS_SndWaveOutFreeChannel( *wave_handle );
			*ch_chorus_flag = 0;	//mۃtOOFF

		}else{
			GF_ASSERT( (0) && "mۂĂȂ`lJ悤ƂĂ܂I" );
		}
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	g`Đ
 *
 * @param	p		WAVEOUT_WORK^̃|C^
 *
 * @retval	BOOL	TRUE=AFALSE=s
 */
//--------------------------------------------------------------
BOOL Snd_WaveOutStart( WAVEOUT_WORK* p )
{
	return NNS_SndWaveOutStart( *p->handle, p->format, p->dataaddr, p->loopFlag, p->loopStartSample,
								p->samples, p->sampleRate, p->volume, p->speed, p->pan );
}

//--------------------------------------------------------------
/**
 * @brief	g`~
 *
 * @param	no		gp`lio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_WaveOutStop( u32 no )
{
	NNS_SndWaveOutStop( *Snd_WaveOutHandleGet(no) );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	g`Đ`FbN
 *
 * @param	no		gp`lio[
 *
 * @retval	BOOL	TRUE=ĐAFALSE=ĐłȂ
 */
//--------------------------------------------------------------
BOOL Snd_WaveOutIsPlaying( u32 no )
{
	return NNS_SndWaveOutIsPlaying( *Snd_WaveOutHandleGet(no) );
}

//--------------------------------------------------------------
/**
 * @brief	g`ĐPANݒ
 *
 * @param	no		gp`lio[
 * @param	pan		p̒l(0-127A64center)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_WaveOutSetPan( u32 no, u8 pan )
{
	u8 set_pan;

	if( pan > 127 ){
		set_pan = 127;
	}else{
		set_pan = pan;
	}

	NNS_SndWaveOutSetPan( *Snd_WaveOutHandleGet(no), set_pan );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	g`Đ̍ĐXs[hݒ
 *
 * @param	no		gp`lio[
 * @param	spd		ĐXs[h
 *
 * @retval	none
 *
 * 21{	(32768 / 2)
 * 1{		(32768)
 * 2{		(32768 * 2)
 * 3{		(32768 * 3)
 *
 * ĐXs[h𑬂ƁAĐԂZȂAĐ鉹̍Ȃ܂B 
 */
//--------------------------------------------------------------
void Snd_WaveOutSetSpeed( u32 no, u32 spd )
{
	NNS_SndWaveOutSetSpeed( *Snd_WaveOutHandleGet(no), spd );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	g`Đ̃{[ύX
 *
 * @param	no		gp`lio[
 * @param	vol		{[l(0-127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_WaveOutSetVolume( u32 no, int vol )
{
	NNS_SndWaveOutSetVolume( *Snd_WaveOutHandleGet(no), vol );
	return;
}
 

//==============================================================================================
//
//	g`tĐ֘A(|P̖p)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	tĐ̃|PĐ
 *
 * @param	no		|Pio[
 * @param	vol		{[(0-127)
 * @param	pan		p(0-127)
 * @param	ch		gp`lio[(ʏ́AWAVEOUT_CH_NORMAL)
 * @param	heap_id	q[vID
 *
 * @retval	BOOL	TRUE=AFALSE=s
 *
 * ŋtĐp̃obt@mۂĂ܂B
 *
 * Snd_WaveOutStopReverse(...)ĂŁAobt@JĂB
 *
 * |Pio[Ɩ̔g`A[JCuio[ɂȂ悤ɂI
 */
//--------------------------------------------------------------
BOOL Snd_WaveOutStartReverse( u16 no, int vol, int pan, u32 ch, int heap_id )
{
	u8* reverse_flag;
	const NNSSndArcWaveArcInfo* info;
	u32 size;
	int size2,ret;
	SND_WORK* wk = Snd_GetSystemAdrs();
	void** reverse_buf = Snd_GetParamAdrs(SND_W_ID_REVERSE_BUF);

	if( (ch != WAVEOUT_CH_NORMAL) && (ch != WAVEOUT_CH_CHORUS) ){
		GF_ASSERT( (0) && "`lio[słI" );
	}

	//g`A[JCu\NNSSndArcWaveArcInfõ|C^Ԃ܂B
	//info =  NNS_SndArcGetWaveArcInfo( WAVE_ARC_PV001 );
	info = NNS_SndArcGetWaveArcInfo( no );
	if( info == NULL ){
		GF_ASSERT( (0) && "Ȕg`A[JCuԍw肳܂I" );
		return FALSE;
	}

	//t@CTCY擾
	size = NNS_SndArcGetFileSize( info->fileId );
	if( size == 0 ){
		GF_ASSERT( (0) && "t@CIDłI" );
		return FALSE;
	}
	OS_Printf( "t@CTCY = %d\n", size );	//.smapƔrĂ݂

	//ʏ̋tĐ
	if( ch == WAVEOUT_CH_NORMAL ){
		//obt@m
		*reverse_buf = sys_AllocMemory( heap_id, size );
		if( *reverse_buf == NULL ){
			GF_ASSERT( (0) && "mۂɎs܂I" );
			return FALSE;
		}
		memset( *reverse_buf, 0, size );

		//TEhA[JCũt@Cǂݍ
		size2 = NNS_SndArcReadFile( info->fileId, *reverse_buf, size, 0 );
		if( size2 == -1 ){
			GF_ASSERT( (0) && "ǂݍ݂Ɏs܂I" );
			return FALSE;
		}

		//f[^ւ
		Snd_BufReverse( *reverse_buf, size );
	}

	//WAVEOUT_WORK^Ƀp[^Zbg
	{
		WAVEOUT_WORK waveout_wk;
		waveout_wk.handle			= Snd_WaveOutHandleGet(ch);	//g`Đnh
		waveout_wk.format			= NNS_SND_WAVE_FORMAT_PCM8;	//g`f[^tH[}bg
		waveout_wk.dataaddr			= *reverse_buf;				//g`f[^̐擪AhX
		waveout_wk.loopFlag			= FALSE;					//[vtO
		waveout_wk.loopStartSample	= 0;						//[vJnTvʒu
		waveout_wk.samples			= size;						//g`f[^̃Tv
		waveout_wk.sampleRate		= 13379;					//g`f[^̃TvO[g
		waveout_wk.volume			= vol;						//
		waveout_wk.speed			= 24576;					//ĐXs[h
		waveout_wk.pan				= pan;						//p(0-127)

		//g`Đ
		ret = Snd_WaveOutStart( &waveout_wk );

		//BANK̐ݒ"PCM8"ɂƂ܂
	}

	reverse_flag = Snd_GetParamAdrs( SND_W_ID_REVERSE_FLAG );
	*reverse_flag = 1;	//tĐgptOON

	return ret;
}

//--------------------------------------------------------------
/**
 * @brief	f[^ւ
 *
 * @param	p		g`f[^i[obt@̃|C^
 * @param	size	g`f[^TCY
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_BufReverse( u8* p, u32 size )
{
	int i;
	u8 temp;

	//f[^ւ( [0]-[MAX]A[1]-[MAX-1]... )
	for( i=0; i < (size / 2) ;i++ ){
		temp		= p[i];			//ޔ
		p[i]		= p[size-1-i];
		p[size-1-i]	= temp;
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	tĐ̃|P~ăobt@J
 *
 * @param	no		gp`lio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_WaveOutStopReverse( u32 no )
{
	SND_WORK* wk		= Snd_GetSystemAdrs();
	u8* reverse_flag	= Snd_GetParamAdrs(SND_W_ID_REVERSE_FLAG);
	void** reverse_buf	= Snd_GetParamAdrs(SND_W_ID_REVERSE_BUF);

	if( (no != WAVEOUT_CH_NORMAL) && (no != WAVEOUT_CH_CHORUS) ){
		GF_ASSERT( (0) && "`lio[słI" );
	}

	Snd_WaveOutStop( no );										//~

	//tĐgptO
	if( *reverse_flag == 1 ){									//tĐgptOĂ
		*reverse_flag = 0;										//tĐgptOOFF
		sys_FreeMemoryEz( *reverse_buf );						//obt@J
	}

	return;
}


//==============================================================================================
//
//	Lv`֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Lv`[XbhN(Ƃ肠Dx͌Œ)
 *
 * @param	none
 *
 * @retval	none
 *
 * Lv`[XbhNĂƁALv`[IRQnhł͂ȂA
 * Lv`[Xbhŏ悤ɂȂ܂B 
 *
 * Xbh̗DxthreadPrióAʏAXg[Xbhݒ肵܂B
 * xƁAȍĐsȂȂ܂̂ŁAӂĂB 
 */
//--------------------------------------------------------------
void Snd_CaptureCreateThread(void)
{
    NNS_SndCaptureCreateThread( CAPTURE_THREAD_PRIO );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	Lv`s擾
 *
 * @param	none
 *
 * @retval	"TRUE=sAFALSE=sĂȂ"
 */
//--------------------------------------------------------------
BOOL Snd_CaptureIsActive(void)
{
	return NNS_SndCaptureIsActive();
}

//--------------------------------------------------------------
/**
 * @brief	s̃Lv`^Cv擾
 *
 * @param	none
 *
 * @retval	"NNS_SND_CAPTURE_TYPE_REVERB = o[u"
 * @retval	"NNS_SND_CAPTURE_TYPE_EFFECT = GtFNg"
 * @retval	"NNS_SND_CAPTURE_TYPE_SAMPLING = TvO"
 *
 * Lv`[s̎̂݌ĂтƂł܂B
 * Lv`[sǂ𒲂ׂ邽߂ɂ́A NNS_SndCaptureIsActive֐Ăт܂B 
 */
//--------------------------------------------------------------
NNSSndCaptureType Snd_CaptureGetCaptureType(void)
{
	return NNS_SndCaptureGetCaptureType();
}

//--------------------------------------------------------------
/**
 * @brief	o̓GtFNgύX
 *
 * @param	none
 *
 * @retval	none
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL		܂(ʏ̃XeI[h)
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO		m[h 
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND	TEh[h 
 * DSXs[J[o͂ƂɁA
 * Xs[J[ʒuLĉ悤ɂGtFNg܂B
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE	wbhtH[h 
 * wbhtHgpɁA̕SyGtFNg܂B
 */
//--------------------------------------------------------------
void Snd_CaptureChangeOutputEffect( NNSSndCaptureOutputEffectType type )
{
	switch( type ){
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL:
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO:
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND:
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE:
		break;
	default:
		return;	//Ȃ
	}

    NNS_SndCaptureChangeOutputEffect( type );
	return;
}
 

//==============================================================================================
//
//	Lv`@o[u
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	o̓GtFNgJn
 *
 * @param	none
 *
 * @retval	none
 *
 * Lv`[@\gă~LT[o͂Lv`A
 * R[obN֐ŃGtFNgsAŏIƂďo͂܂B
 * GtFNg쒆́A16`l2`li`l1yу`l3j܂B
 * `l1܂̓`l3AV[PXɂĎgp̏ꍇA
 * ̉͋Iɒ~܂B 
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL		܂(ʏ̃XeI[h)
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO		m[h 
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND	TEh[h 
 * DSXs[J[o͂ƂɁA
 * Xs[J[ʒuLĉ悤ɂGtFNg܂B
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE	wbhtH[h 
 * wbhtHgpɁA̕SyGtFNg܂B
 */
//--------------------------------------------------------------
void Snd_CaptureStartOutputEffect( NNSSndCaptureOutputEffectType type )
{
	SND_WORK* wk	= Snd_GetSystemAdrs();
	s8* capture_buf = Snd_GetParamAdrs(SND_W_ID_CAPTURE_BUF);

	switch( type ){
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL:
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO:
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND:
	case NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE:
		//NNS_SndCaptureStartOutputEffect( wk->sCaptureBuffer, sizeof( wk->sCaptureBuffer ), type );
		NNS_SndCaptureStartOutputEffect( capture_buf, CAPTURE_BUFSIZE, type );
		break;
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	o[u@Jn
 *
 * @param	vol		o[ũ{[(0-63)
 *
 * @retval	BOOL	TRUE=AFALSE=s
 *
 * ĐȂ炱̊֐ĂтƁAĐ鉹r؂܂B 
 *
 * `l1,3gp̂ŒӁI
 */
//--------------------------------------------------------------
BOOL Snd_CaptureStartReverb( int vol )
{
	SND_WORK* wk	= Snd_GetSystemAdrs();
	s8* capture_buf = Snd_GetParamAdrs(SND_W_ID_CAPTURE_BUF);

	//return NNS_SndCaptureStartReverb( wk->sCaptureBuffer, sizeof( wk->sCaptureBuffer ),
	return NNS_SndCaptureStartReverb( capture_buf, CAPTURE_BUFSIZE,
										CAPTURE_FORMAT, SAMPLING_RATE, vol );
}

//--------------------------------------------------------------
/**
 * @brief	o[u@I
 *
 * @param	frame	t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_CaptureStopReverb( int frame )
{
	NNS_SndCaptureStopReverb( frame );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	o[u@{[ύX
 *
 * @param	vol		o[ũ{[(0-63)
 * @param	frame	t[
 *
 * @retval	none
 *
 * frameŎw肵t[ŁAXɌ݂̃{[lA
 * volŎw肵{[l֕ω܂B  
 *
 * o[u삵ĂȂꍇ́A܂B 
 */
//--------------------------------------------------------------
void Snd_CaptureReverbVol( int vol, int frame )
{
	NNS_SndCaptureSetReverbVolume( vol, frame );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	GtFNgJn
 *
 * @param	none
 *
 * @retval	BOOL	TRUE=AFALSE=s
 *
 * `l1,3gp̂ŒӁI
 */
//--------------------------------------------------------------
BOOL Snd_CaptureStartEffect(void)
{
	SND_WORK* wk				= Snd_GetSystemAdrs();

	//MI_CpuClear8( &wk->callbackInfo, sizeof(wk->callbackInfo) );
	MI_CpuClear8( Snd_GetParamAdrs(SND_W_ID_CALLBACK_INFO), sizeof(EffectCallbackInfo) );

/*
	//return NNS_SndCaptureStartEffect( wk->sCaptureBuffer, sizeof( wk->sCaptureBuffer ),
	return NNS_SndCaptureStartEffect( wk->sCaptureBuffer, CAPTURE_BUFSIZE,
				CAPTURE_FORMAT, SAMPLING_RATE, 2, EffectCallback, &wk->callbackInfo );
*/

	//-----------------------------------------------------
	//TvO[gႢƁALv`@\gɁA
	//HĂȂĂAȂ̂ŒӁI
	//-----------------------------------------------------

#if 1
	//return NNS_SndCaptureStartEffect( Snd_GetParamAdrs(SND_W_ID_CAPTURE_BUF),CAPTURE_BUFSIZE,
	//									CAPTURE_FORMAT, SAMPLING_RATE,2, 
	//								EffectCallback, Snd_GetParamAdrs(SND_W_ID_CALLBACK_INFO) );

	//eXg(06.02.24)
	return NNS_SndCaptureStartEffect( Snd_GetParamAdrs(SND_W_ID_CAPTURE_BUF),CAPTURE_BUFSIZE,
										//NNS_SND_CAPTURE_FORMAT_PCM16, 16000,2, 
										NNS_SND_CAPTURE_FORMAT_PCM16, 22000,2, 
									EffectCallback2, Snd_GetParamAdrs(SND_W_ID_CALLBACK_INFO) );
#else
	 //start sampling
    (void)NNS_SndCaptureStartSampling( Snd_GetParamAdrs(SND_W_ID_CAPTURE_BUF),CAPTURE_BUFSIZE,
										CAPTURE_FORMAT,SAMPLING_RATE,2,
										SamplingCallback,NULL );
	return 0;
#endif
}

//--------------------------------------------------------------
/**
 * @brief	GtFNg~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_CaptureStopEffect(void)
{
	NNS_SndCaptureStopEffect();
	return;
}

//--------------------------------------------------------------
/**
 * @brief	GtFNgx̑
 *
 * @param	level	x(0-8)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_CaptureEffectLevel( int level )
{
	u8* filter_size = Snd_GetParamAdrs(SND_W_ID_FILTER_SIZE);
	//Ή
	
	if( level > 8 ){
		level = 8;
	}else if( level < 0 ){
		level = 0;
	}

	*filter_size = level;
	return;
}
 
//--------------------------------------------------------------
/**
 * @brief	GtFNg̃R[obN֐
 *
 * @param	bufferL_p	L~LT[
 * @param	bufferR_p	R~LT[
 * @param	len			obt@̃TCY
 * @param	format		NNS_SndCaptureStartEffect֐̈(CAPTURE_FORMAT)Ɠ̂n
 * @param	arg			NNS_SndCaptureStartEffect֐̈(callbackInfo)Ɠ̂n
 *
 * @retval	none
 *
 * ȒPȃ[pXtB^iړρjďo͂Ă
 *
 * Ԃ̊Ԋu߁ÅԊu̕ϒlAČvZ邱Ƃɂ
 * ()Iȓm낤Ƃ́B
 * (ւƓ )
 */
//--------------------------------------------------------------
static void EffectCallback( void* bufferL_p, void* bufferR_p, u32 len, NNSSndCaptureFormat format, void* arg )
{
    smp_t* lp = (smp_t*)bufferL_p;
    smp_t* rp = (smp_t*)bufferR_p;
    EffectCallbackInfo* info = (EffectCallbackInfo*)arg;
    smp_t org[ FILTER_SIZE-1 ][2];

    int samples;
    int x;
    int i, j;
    
	//Tv8rbgPCM͂̂܂
	//Tv16rbgPCMobt@̃TCY𔼕ɂ
    samples = ( format == NNS_SND_CAPTURE_FORMAT_PCM8 ) ? len : ( len >> 1 );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\nSND_EFF=================================\n" );
	OS_Printf( "format = %d\n", format );			//0
	OS_Printf( "len = %d\n", len );					//1024
	OS_Printf( "samples = %d\n", samples );			//512
#endif
    
#if 0
	//fobN
    for( i = 0 ; i < samples ; i++ ) {
		lp[i] += debug_snd_eff;
		rp[i] += debug_snd_eff;
	}

   	//CɊmɏ
    DC_FlushRange( bufferL_p, len );
    DC_FlushRange( bufferR_p, len );
	return;
#endif

	//--------------------------------------------
	// obt@TCY = 24 tB^[TCY = 8
	//lp[0+24-8+1]=17
	//17,18,19,20,21,22,23ۑ
	//--------------------------------------------
    //obt@̈Ԍ납AtB^[TCYۑ
    for( i = 0; i < FILTER_SIZE-1; i++ ) {
        org[i][0] = lp[ i + samples - FILTER_SIZE + 1 ];
        org[i][1] = rp[ i + samples - FILTER_SIZE + 1 ];
		OS_Printf( "org[i][] = %d\n", org[i][0] );
    }
    
	//--------------------------------------------
	// obt@TCY = 24 tB^[TCY = 8
    //for( i = 24 - 1; i >= 8 - 1 ; i-- ){
	//23...8܂ŏ
	//--------------------------------------------
	//obt@̈Ԍ납AtB^[TCY̒l菬Ȃ܂ŏ
    for( i = samples - 1; i >= FILTER_SIZE - 1 ; i-- ){

		//--------------------------------------------
		// obt@TCY = 24 tB^[TCY = 8
		//x += lp[ 23 - 0 ];
		//(-0-7܂)
		//x += lp[ 23 - 7 ];
		//tB^[TCYĂ
		//--------------------------------------------
		//L~LT[
        x = 0;
        for( j = 0 ; j < FILTER_SIZE ; j++ ) {	//tB^[TCYĂ
            x += lp[ i - j ];
        }
        lp[ i ] = (smp_t)(x /= FILTER_SIZE);	//tB^[TCYŊ蕽ςŏ㏑
        
		//R~LT[
        x = 0;
        for( j = 0 ; j < FILTER_SIZE ; j++ ) {	//tB^[TCYĂ
            x += rp[ i - j ];
        }
        rp[ i ] = (smp_t)(x /= FILTER_SIZE);	//tB^[TCYŊ蕽ςŏ㏑
    }
    
#if FILTER_SIZE >= 2    
	//--------------------------------------------
	// obt@TCY = 24 tB^[TCY = 8
    //for( i = 8 - 2; i >= 0 ; i-- ){
	//6...0܂ŏ
	//--------------------------------------------
    for( i = FILTER_SIZE - 2 ; i >= 0 ; i-- ){

		//L~LT[
        x = lp[ i ];
        for( j = 1 ; j < FILTER_SIZE ; j++ ) {	//tB^[TCY
            x += GetSample( lp, i-j, 0, info );
        }
        lp[ i ] = (smp_t)(x /= FILTER_SIZE);	//tB^[TCYŊ蕽ςŏ㏑
        
		//R~LT[
        x = rp[ i ];
        for( j = 1 ; j < FILTER_SIZE ; j++ ) {
            x += GetSample( rp, i-j, 1, info );
        }
        rp[ i ] = (smp_t)(x /= FILTER_SIZE);	//tB^[TCYŊ蕽ςŏ㏑
    }
#endif
    
	//Lv`̈̃tB^TCY
	//ۑĂf[^ŏ㏑
	//(obt@̈Ԍ납AtB^[TCYۑĂf[^)
    for( i = 0; i < FILTER_SIZE-1; i++ ) {
        info->sample[i][0] = org[i][0];
        info->sample[i][1] = org[i][1];
    }

	//CɊmɏ
    DC_FlushRange( bufferL_p, len );
    DC_FlushRange( bufferR_p, len );

	//ɓnobt@́A(̊֐łinfo)
	//Lv`̈wĂ܂B
	//̗̈C邱ƂŁAۂɏo͂鉹ύX邱Ƃł܂B 
}
 
//--------------------------------------------------------------
/**
 * @brief	Tv̒l擾
 *
 * @param	p			~LT[
 * @param	x			i-j
 * @param	n
 * @param	info		NNS_SndCaptureStartEffect֐̈(callbackInfo)Ɠ̂n
 *
 * @retval	none
 */
//--------------------------------------------------------------
static inline smp_t GetSample( smp_t* p, int x, int n, const EffectCallbackInfo* info )
{
	//i-j0ȏ̎́A~LT[̒l̂܂ܕԂ
    if ( x >= 0 ){
		return p[x];
	}

	//i-j0̎Ax(i-j)̒l𒲐l擾
    x += FILTER_SIZE-1;
    return info->sample[x][n];
}

static inline int abs( int x )
{
    return x >= 0 ? x : -x;
}

void SamplingCallback( void* bufferL_p, void* bufferR_p, u32 len, NNSSndCaptureFormat format, void* arg )
{
#pragma unused( arg )    
    smp_t* lp = (smp_t*)bufferL_p;
    smp_t* rp = (smp_t*)bufferR_p;
    u32 samples;
    long sum = 0;
    int i;
    
    samples = ( format == NNS_SND_CAPTURE_FORMAT_PCM8 ) ? len : ( len >> 1 );
    
    for( i = 0 ; i < samples ; i++ ) {
        sum += abs( lp[ i ] ) + abs( rp[ i ] );
    }

    sum /= samples * 2;

#if 1
    //for( i = 0 ; i < samples ; i++ ) {
	//	if( sum < ( abs(lp[i]) + abs(rp[i]) ) ){
			//lp[i] = lp[i] - (sum/10);
			//rp[i] = rp[i] - (sum/10);
	//		lp[i] = sum;
	//		rp[i] = sum;
	//	}
    //}
    for( i = 0 ; i < samples ; i++ ) {
		lp[i] += 1000;
		rp[i] += 1000;
	}

   	//CɊmɏ
    DC_FlushRange( bufferL_p, len );
    DC_FlushRange( bufferR_p, len );
#endif
 
    OS_Printf("output level : %5d\n", sum );
}


//==============================================================================================
//
//	gbN
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	gbN~[g
 *
 * @param	handle_no	TEhnhio[
 * @param	bitmask		gbNrbg}XN
 * @param	flag		TRUE=~[gAFALSE=
 *
 * @retval	none
 *
 * trackBitMaskŁAݒ肷gbNw肵܂B
 * ʃrbg珇ɁAgbN0AgbN1AgbN2AAA\A
 * rbgĂgbNSĂɑ΂āA~[g̐ݒύX܂B
 * Ⴆ΁AgbN2ƃgbN5̃~[gݒύXꍇ́A 
 * (1 << 2) | (1 << 5) Ȃ킿A0x0024 Ƃ܂B 
 */
//--------------------------------------------------------------
void Snd_PlayerSetTrackMute( int handle_no, u16 bitmask, BOOL flag )
{
	NNS_SndPlayerSetTrackMute( Snd_HandleGet(handle_no), bitmask, flag );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	gbN{[ύX
 *
 * @param	p			TEhnh̃AhX
 * @param	bitmask		gbNrbg}XN
 * @param	vol			{[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PlayerSetTrackVolume( NNSSndHandle *p, u16 bitmask, int vol )
{
	NNS_SndPlayerSetTrackVolume( p, bitmask, vol );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	gbNύX
 *
 * @param	handle_no	TEhnhio[
 * @param	bitmask		gbNrbg}XN
 * @param	pitch		ω̒l(-32768`32767)
 *
 * @retval	none
 *
 * pitch͐̒lōցA̒lŒႢ֕ω܂B 
 * }64ł傤ǔω܂BiĂԂтɌʂݐς킯ł͂܂)
 */
//--------------------------------------------------------------
void Snd_PlayerSetTrackPitch( int handle_no, u16 bitmask, int pitch )
{
	NNS_SndPlayerSetTrackPitch( Snd_HandleGet(handle_no), bitmask, pitch );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	gbNpύX
 *
 * @param	handle_no	TEhnhio[
 * @param	bitmask		gbNrbg}XN
 * @param	pan			pω̒l(-128`127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PlayerSetTrackPan( int handle_no, u16 bitmask, int pan )
{
	NNS_SndPlayerSetTrackPan( Snd_HandleGet(handle_no), bitmask, pan );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	e|ύX
 *
 * @param	handle_no	TEhnhio[
 * @param	tempo		{(256=1{)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_PlayerSetTempoRatio( int handle_no, int tempo )
{
	NNS_SndPlayerSetTempoRatio( Snd_HandleGet(handle_no), tempo );
	return;
}


//==============================================================================================
//
//	̑֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	mtOύX
 *
 * @param	flag	TRUE=mAFALSE=XeI
 *
 * @retval	none
 *
 * ftHǵAFALSEłB 
 *
 * mtOLɂƁAp̐ݒl𖳎āA
 * SĂ̔̒ʂōs܂B 
 */
//--------------------------------------------------------------
void Snd_SetMonoFlag( BOOL flag )
{
	NNS_SndSetMonoFlag( flag );
	mono_flag = flag;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	tF[hJE^[Zbg
 *
 * @param	frame		t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_FadeCountSet( int frame )
{
	int* fade_count = Snd_GetParamAdrs(SND_W_ID_FADE_COUNT);
	*fade_count = frame;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGM炷܂ł̃EFCgZbg
 *
 * @param	frame		t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_NextWaitSet( int frame )
{
	int* next_wait = Snd_GetParamAdrs(SND_W_ID_NEXT_WAIT);
	*next_wait = frame;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGM炷܂ł̃EFCg`FbN(JE^[炵Ă܂)
 *
 * @param	none
 *
 * @retval	"0=IA0ȊO=JE^[l"
 */
//--------------------------------------------------------------
int Snd_NextWaitCheck()
{
	u16* next_wait = Snd_GetParamAdrs(SND_W_ID_NEXT_WAIT);

	if( *next_wait <= 0 ){
		*next_wait = 0;
		return 0;
	}

	(*next_wait)--;
	return *next_wait;
}

//--------------------------------------------------------------
/**
 * @brief	}X^[{[ݒ(ftHg127)
 *
 * @param	vol		{[(0-127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
#if 0
void Snd_SetMasterVolume( int vol )
{
	NNS_SndSetMasterVolume( vol );
	return;
}
#endif

//--------------------------------------------------------------
/**
 * @brief	g`i[obt@̃AhX擾()
 *
 * @param	vol		{[(0-127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
void* Snd_GetDebugWaveBufAdrs(void)
{
	return &sWaveBuffer[0];
}

//--------------------------------------------------------------
/**
 * @brief	vC[q[v쐬(snd_test.cł̂ݎgp)
 *
 * @param	player_no	vC[io[
 * @param	size		vC[q[vTCY
 *
 * @retval	"TRUE=AFALSE=s"
 */
//--------------------------------------------------------------
BOOL Snd_PlayerHeapCreate( int player_no, u32 size )
{
	return NNS_SndPlayerCreateHeap( player_no, *( Snd_HeapHandleGet() ), size );
}


//==============================================================================================
//
//	[J֐
//
//==============================================================================================


//==============================================================================================
//
//	tB[h؂ւ
//
//	Pj퓬ɓ
//	Qjɓ
//	RjŃQ[I[o[
//	Sj]Ԃɏ
//	Tjg肵
//	ɂ͉邩HH
//
//	iKIɕω֐łɌĂłꍇ̑ΏmFI(TCBȊOł)
//	~Ă΂ȂƂȂȂǁB
//
//	CtB[hłȂȂ폜Ȃ
//
//==============================================================================================


//==============================================================================================
//
//	gpEfobN֘A
//
//==============================================================================================
#if 0
//--------------------------------------------------------------
/**
 * @brief	TEh[J[Nm
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_LocalWorkCreate(void);
static void Snd_LocalWorkCreate(void)
{
	wk = sys_AllocMemory( HEAPID_WORLD, sizeof(SND_LOCAL_WORK) );
	if( wk == NULL ){
		GF_ASSERT( (0) && "TEh[J[NmێsI" );
	}
	memset( wk, 0, sizeof(SND_LOCAL_WORK) );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	SẴTEhq[vNA(ʏgpȂ)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_HeapClear(void);
static void Snd_HeapClear(void)
{
	SND_WORK* wk = Snd_GetSystemAdrs();
	NNS_SndHeapClear(wk->heap);
	return;
}

//--------------------------------------------------------------
/**
 * @brief	V[PXĐ
 *
 * @param	p		TEhnh̃AhX
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * ĐɐƁATEhnhɃV[PXт܂B 
 *
 * V[PXf[^vC[q[vŃ[h鎞́A
 * eʂȂƍĐsI
 */
//--------------------------------------------------------------
static BOOL Snd_ArcPlayerStartSeq( NNSSndHandle *p, u16 no )
{
	return NNS_SndArcPlayerStartSeq( p, no );
}

//--------------------------------------------------------------
/**
 * @brief	V[PXA[JCuĐ
 *
 * @param	p		TEhnh̃AhX
 * @param	arc_no	V[PXA[JCuio[(V[PXA[JCu̕я)
 * @param	index	CfbNX
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * ĐɐƁATEhnhɃV[PXт܂B 
 *
 * Đš́A
 * V[PXA[JCuԍ
 * CfbNXԍ 
 * ɍĐ̃V[PXDxႢ 
 * f[^ɖ 
 * q[v̈悪Ȃ(O[v[hsĂ)
 */
//--------------------------------------------------------------
BOOL Snd_ArcPlayerStartSeqArc( NNSSndHandle *p, int arc_no, int index )
{
	return NNS_SndArcPlayerStartSeqArc( p, arc_no, index );
}

//--------------------------------------------------------------
/**
 * @brief	wvC[̃V[PXő哯Đݒ(dĐɎgpI)
 *
 * @param	player_no	vC[ԍ
 * @param	no			V[PXő哯Đ
 *
 * @retval	"ύXÕV[PXő哯Đ"
 *
 * PLAYER_FIELD	: tB[hBGM
 * PLAYER_ME 	: ME
 * PLAYER_SE_1 	: ʉ
 * PLAYER_SE_2 	: ʉ
 * PLAYER_SE_3 	: ʉ
 * PLAYER_SE_4 	: ʉ
 * PLAYER_PV	: |P
 * PLAYER_VOICE	: 
 * PLAYER_BGM	: tB[hȊOBGM
 *
 * gṕAK̐ݒɖ߂悤ɂĉI
 */
//--------------------------------------------------------------
static u8 Snd_PlayerSetPlayableSeqCount( int player_no, int no );
static u8 Snd_PlayerSetPlayableSeqCount( int player_no, int no )
{
	const NNSSndArcPlayerInfo* info;
	u8 ret;

	//ӁI TEhA[JCu̎擾
	info = NNS_SndArcGetPlayerInfo( player_no );		//vC[\̎擾
	ret = info->seqMax;									//ޔ

	NNS_SndPlayerSetPlayableSeqCount( player_no, no );

	return ret;											//ύXÕV[PXő哯Đ
}
#endif


//==============================================================================================
//
//	Xg[֐
//
//==============================================================================================
#ifdef STREAM_ON
//--------------------------------------------------------------
/**
 * @brief	Xg[Đ
 *
 * @param	no		Xg[io[
 *
 * @retval	none
 *
 * pA{[̂ݑo
 * (AR[Xʂ͏oȂƂɂȂI)
 */
//--------------------------------------------------------------
BOOL Snd_ArcStrmStart( u16 no );
BOOL Snd_ArcStrmStart( u16 no )
{
	SND_WORK* wk = Snd_GetSystemAdrs();
	(void)NNS_SndArcStrmStart( &wk->strmHandle, no, 0 );
	return;
}
#endif


//==============================================================================================
//
//	fld_bgmŎgp֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	邩tOZbg
 *
 * @param	no		0=A1=
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_LightNightFlagSet( int no )
{
	u8* light_night_flag = Snd_GetParamAdrs(SND_W_ID_LIGHT_NIGHT_FLAG);
	*light_night_flag = no;
	//OS_Printf( "no = %d\n", no );
	//OS_Printf( "light_night = %d\n", *light_night_flag );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	邩tO擾
 *
 * @param	none
 *
 * @retval	"A1="
 */
//--------------------------------------------------------------
u8 Snd_LightNightFlagGet()
{
	u8* light_night_flag = Snd_GetParamAdrs(SND_W_ID_LIGHT_NIGHT_FLAG);
	return (*light_night_flag);
}

//--------------------------------------------------------------
/**
 * @brief	tF[hAEg  BGMĐ
 *
 * @param	scene		V[()io[
 * @param	no			V[PXio[
 * @param	frame		t[
 * @param	next_wait	BGM炷܂ł̃EFCg
 * @param	flag		0=A1=A0xff=(Ȃ)
 * @param	adrs		tF[hf[^̃AhX
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
BOOL Snd_FadeOutNextPlaySet( u8 scene, u16 no, int frame, int next_wait, u8 flag, const TRACK_FADE_DATA* adrs )
{
	//tF[hʏ
	Snd_FadeCommonSet( scene, no, frame, next_wait, flag, adrs );
	
	//Xe[^XăZbg
	Snd_StatusSet( SND_STATUS_FADEOUT_NEXT_PLAY );	//Xe[^X(tF[hAEgĐ)
	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	tF[hAEg  BGMtF[hC
 *
 * @param	scene		V[()io[
 * @param	no			V[PXio[
 * @param	frame		t[
 * @param	next_wait	BGM炷܂ł̃EFCg
 * @param	next_frame	BGM̃tF[hCt[
 * @param	flag		0=A1=A0xff=(Ȃ)
 * @param	adrs		tF[hf[^̃AhX
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
BOOL Snd_FadeOutNextFadeInSet( u8 scene, u16 no, int frame, int next_wait, int next_frame, u8 flag, const TRACK_FADE_DATA* adrs )
{
	int* next_frame_wk = Snd_GetParamAdrs(SND_W_ID_NEXT_FRAME);

	//tF[hʏ
	Snd_FadeCommonSet( scene, no, frame, next_wait, flag, adrs );
	
	*next_frame_wk = next_frame;						//BGM̃tF[hCt[Zbg

	//Xe[^XăZbg
	Snd_StatusSet( SND_STATUS_FADEOUT_NEXT_FADEIN );	//Xe[^X(tF[hAEgtF[hC)
	return 1;
}

//ʏ
static void Snd_FadeCommonSet( u8 scene, u16 no, int frame, int next_wait, u8 flag, const TRACK_FADE_DATA* adrs )
{
	const NNSSndArcBankInfo** info		= Snd_GetParamAdrs(SND_W_ID_BANK_INFO);
	const TRACK_FADE_DATA** fade_data	= Snd_GetParamAdrs(SND_W_ID_TRACK_FADE_DATA);

	//tF[hAEgJn(Xe[^XtF[hAEg)
	Snd_BgmFadeOut( BGM_VOL_MIN, frame );

	//tF[hAEg"BGMio["́AK0Ă悤ɂI
	
	//ēx][؂ւĂ΂悤ɁABGMio[NAI
	Snd_NowBgmNoSet( 0 );							//BGMio[Zbg

	//(][)BGMio[ZbgĂ
	Snd_NextBgmNoSet( no );							//BGMio[Zbg
	Snd_NextWaitSet( next_wait );					//BGM炷܂ł̃EFCgZbg

	//06.01.25폜
	//Snd_SceneSet( scene );						//ύXV[Zbg
	
	*info		= Snd_GetBankInfo( no );			//oN\̃Zbg
	*fade_data	= adrs;								//tF[hf[^̃AhXZbg

	if( flag != 0xff ){
		Snd_LightNightFlagSet( flag );				//邩tOZbg
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	gbNtF[hZbg
 *
 * @param	no		V[PXio[
 * @param	flag	0=A1=A0xff=(Ȃ)
 * @param	adrs	tF[hf[^̃AhX
 *
 * @retval	"0=ȂA1=Jn"
 */
//--------------------------------------------------------------
BOOL Snd_TrackFadeSet( u16 no, u8 flag, const TRACK_FADE_DATA* adrs )
{
	const TRACK_FADE_DATA** fade_data	= Snd_GetParamAdrs(SND_W_ID_TRACK_FADE_DATA);

	//Xe[^XύX\`FbN
	if( Snd_StatusCheck(SND_STATUS_TRACKFADE) == FALSE ){
		return 0;
	}

	//"BGMio["͂łɃZbgĂI
	//Snd_NowBgmNoSet( no );						//BGMio[Zbg

	Snd_TrackFadeDataSet( adrs );					//gbNtF[hf[^Zbg

	if( flag != 0xff ){
		Snd_LightNightFlagSet( flag );				//邩tOZbg
	}

	//Xe[^XZbg
	Snd_StatusSet( SND_STATUS_TRACKFADE );			//Xe[^X(gbNtF[h)
	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	gbNtF[h"f[^"Zbg
 *
 * @param	adrs	tF[hf[^̃AhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_TrackFadeDataSet( const TRACK_FADE_DATA* adrs )
{
	const TRACK_FADE_DATA** fade_data	= Snd_GetParamAdrs(SND_W_ID_TRACK_FADE_DATA);
	*fade_data = adrs;				//tF[hf[^̃AhXZbg
	return;
}


//==============================================================================================
//
//	d_noharaŎgp֐(fobNp)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	g`Đp̃`l(fobN)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_DebugNormalChannelFree()
{
	u8* ch_normal_flag = Snd_GetParamAdrs(SND_W_ID_WAVEOUT_CH_NORMAL_FLAG);

	if( *ch_normal_flag == 1 ){	//mۃtOON
		Snd_WaveOutFreeChannel( WAVEOUT_CH_NORMAL );
	}

	return;
}


//==============================================================================================
//
//	snd_testŎgp֐(fobNp)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	oN[h
 *
 * @param	no		oNio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_DebugLoadBank( u16 no )
{
	Snd_ArcLoadBank( no );
	return;
}


//==============================================================================================
//
//	g`֘A(|P}ӂ̖ʂŎgp)
//
//	<nitro/snd.h>
//	typedef struct SNDWaveData
//
//==============================================================================================
const u8* Snd_WaveDataSampleAdrsGet( const SNDWaveData* p_data );
const u32 Snd_WaveDataSampleSizeGet( const SNDWaveData* p_data );
const SNDWaveData* Snd_ZukanWaveDataSet( int wave_arc_no );
static const SNDWaveData* Snd_WaveDataAdrsGet( int wave_arc_no );
u32 Snd_PlayerGetSampleTick( int handle_no, const SNDWaveData* p_data );
u32 Snd_ZukanPlayerGetSampleTick( int handle_no, const SNDWaveData* p_data, int pitch );
u32 Snd_PlayerGetTick( int handle_no );

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhXTvf[^̃AhX擾
 *
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"Tvf[^̃AhXANULL=s"
 */
//--------------------------------------------------------------
const u8* Snd_WaveDataSampleAdrsGet( const SNDWaveData* p_data )
{
	if( p_data == NULL ){
		return NULL;
	}

	return &p_data->samples[0];
}

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhXTvf[^̔z̑傫擾
 *
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"Tvf[^̔z̑傫A0=s"
 */
//--------------------------------------------------------------
const u32 Snd_WaveDataSampleSizeGet( const SNDWaveData* p_data )
{
	if( p_data == NULL ){
		return 0;
	}

	return (p_data->param.loopstart + p_data->param.looplen);
}

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhX擾(}Ӑp)
 *
 * @param	wave_arc_no	g`A[JCuԍ(|Pio[)
 *
 * @retval	"g`f[^\̂̃AhXANULL=s"
 *
 * 1)BGM̌J
 * 2)g`A[JCu[h
 * ̏Ă̂ŒӁI
 */
//--------------------------------------------------------------
const SNDWaveData* Snd_ZukanWaveDataSet( int wave_arc_no )
{
	u16 monsno;
	int* heap_save_bgm		= Snd_GetParamAdrs(SND_W_ID_HEAP_SAVE_BGM);

	Snd_HeapLoadState( *heap_save_bgm );			//BGM̌

	monsno = wave_arc_no;

	//sȒl`FbN
	if( (wave_arc_no > POKE_NUM_MAX) || (wave_arc_no == 0) ){
		//GF_ASSERT( (0) && "|Pio[słI" );
		//return FALSE;	//G[
		OS_Printf( "|Pio[słI" );
		monsno = MONSNO_HUSIGIDANE;
	}

	//g`A[JCu[h([hȂƁAƂ̏ŎsI)
	Snd_ArcLoadWaveArc( monsno );

	//g`f[^̃AhX擾
	return Snd_WaveDataAdrsGet( monsno );
}

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhX擾
 *
 * @param	wave_arc_no	g`A[JCuԍ(|Pio[)
 *
 * @retval	"g`f[^\̂̃AhXANULL=s"
 */
//--------------------------------------------------------------
static const SNDWaveData* Snd_WaveDataAdrsGet( int wave_arc_no )
{
	u16 monsno;
	const NNSSndArcWaveArcInfo* wave_arc_info;
	SNDWaveArc* wave_arc		= NULL;
	const SNDWaveData** p_data	= Snd_GetParamAdrs(SND_W_ID_WAVE_DATA);

	monsno = wave_arc_no;

	//sȒl`FbN
	if( (wave_arc_no > POKE_NUM_MAX) || (wave_arc_no == 0) ){
		//GF_ASSERT( (0) && "|Pio[słI" );
		//return FALSE;	//G[
		OS_Printf( "|Pio[słI" );
		monsno = MONSNO_HUSIGIDANE;
	}

	//g`A[JCu\̎擾
    wave_arc_info = NNS_SndArcGetWaveArcInfo( monsno );
    if( wave_arc_info == NULL ){
		GF_ASSERT( (0) && "g`A[JCuio[słI" );
		return NULL;
	}

	//t@CIDAg`A[JCu\̎擾
	wave_arc = (SNDWaveArc*)NNS_SndArcGetFileAddress( wave_arc_info->fileId );
    if( wave_arc == NULL ){
		GF_ASSERT( (0) && "g`A[JCuio[słI" );
		return NULL;
	}

	//SNDWaveData^̔g`f[^̃AhX擾
	*p_data = SND_GetWaveDataAddress( wave_arc, 0 );

	OS_Printf( "g`f[^\n" );
	OS_Printf( "wave_data formt    = %d\n", (*p_data)->param.format );
	OS_Printf( "wave_data loopflag = %d\n", (*p_data)->param.loopflag );
	OS_Printf( "wave_data rate     = %d\n", (*p_data)->param.rate );
	OS_Printf( "wave_data timer    = %d\n", (*p_data)->param.timer );
	OS_Printf( "wave_data loopstart= %d\n", (*p_data)->param.loopstart );
	OS_Printf( "wave_data looplen  = %d\n", (*p_data)->param.looplen );

	return (*p_data);
}

//--------------------------------------------------------------
/**
 * @brief	g`f[^̍ĐĂTvf[^vfԂ
 *
 * @param	handle_no	nhio[
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"vf"
 */
//--------------------------------------------------------------
u32 Snd_PlayerGetSampleTick( int handle_no, const SNDWaveData* p_data )
{
	u32 num;
	u32 tick = Snd_PlayerGetTick( handle_no );
	u32 max  = p_data->param.loopstart + p_data->param.looplen;

	//num = (max / 32);		//ĐItick̒l
	num = (tick * 32);		//ĐĂvf
	if( num >= max ){
		num = 0;
	}

	return num;
}

//--------------------------------------------------------------
/**
 * @brief	g`f[^̍ĐĂTvf[^vfԂ(}ӗp)
 *
 * @param	handle_no	nhio[
 * @param	p_data		g`f[^̃AhX
 * @param	pitch		ݒ肵Ăsb`
 *
 * @retval	"vf"
 */
//--------------------------------------------------------------
u32 Snd_ZukanPlayerGetSampleTick( int handle_no, const SNDWaveData* p_data, int pitch )
{
	int no;
	u32 num;
	u32 tick = Snd_PlayerGetTick( SND_HANDLE_PMVOICE );
	u32 max  = p_data->param.loopstart + p_data->param.looplen;

#if 1
	//ׂvZ͂ĂȂAIN^[ûݑΉ
	
	no = pitch / (64*12);
	no = no * 2;

	if( no < 0 ){
		no = 32 / no * -1;	//̒lɂ
	}else if( no == 0 ){
		no = 32;
	}else{
		no = 32 * no;
	}

	//OS_Printf( "no = %d\n", no );
#else
	no = 32;
#endif

	//num = (max / no);		//ĐItick̒l
	num = (tick * no);		//ĐĂvf
	if( num >= max ){
		num = 0;
	}

	//OS_Printf( "pitch = %d\n", pitch );
	//OS_Printf( "no = %d\n", no );
	//OS_Printf( "tick = %d\n", tick );
	//OS_Printf( "num = %d\n", num );

	return num;
}

//--------------------------------------------------------------
/**
 * @brief	eBbN擾
 *
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"eBbN"
 */
//--------------------------------------------------------------
u32 Snd_PlayerGetTick( int handle_no )
{
	u32 tick = NNS_SndPlayerGetTick( Snd_HandleGet(handle_no) );
	//OS_Printf( "tick = %d\n", tick );
	return tick;
}


















#define WAVE_8_BIT_CENTER		(128)			//8bit ؂ւ(u8)
#define WAVE_16_BIT_CENTER		(0)				//16bit ؂ւ(s16)

//{[Otp̒`
enum{
	//"3"tickƂɌĂ΂̂ŁA32*3=96100ɂĂ
	//WAVE_LEVEL_BEFORE_POS	=	(50),			//r鍷̕
	WAVE_LEVEL_BEFORE_POS	=	(100),			//r鍷̕
	//WAVE_LEVEL_BEFORE_POS	=	(150),			//r鍷̕
	//WAVE_LEVEL_BEFORE_POS	=	(200),			//r鍷̕

	//vf߂Ԋu
	//ԊuقǗvf[0]̐ȂȂ
	//WAVE_LEVEL_HABA			=	(1),		//x𕪂Ԋu("0","1",...ƕ)
	WAVE_LEVEL_HABA			=	(2),		//x𕪂Ԋu("0,1","2,3",...ƕ)
	//WAVE_LEVEL_HABA			=	(3),		//x𕪂Ԋu("0,1,2","3,4,5",...ƕ)
	//WAVE_LEVEL_HABA		=	(4),				//x𕪂Ԋu(("0,1,2,3",...ƕ)
	//WAVE_LEVEL_HABA		=	(8),				//x𕪂Ԋu(("0,1,2,3",...ƕ)
};

u32 Snd_ZukanPlayerGetTick();
void Snd_DebugWaveDataPut( const SNDWaveData* p_data, u32 start, u32 end );


//const SNDWaveData* snd_wave_data;				//g`f[^̃|C^

//ĐIA
//ŌɎ擾xA
//Ãx𗎂ƂĂ
//--------------------------------------------------------------
/**
 * @brief	"fobN"@g`f[^\
 *
 * @param	start		\f[^̊Jnʒu
 * @param	end			\f[^̏Iʒu
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_DebugWaveDataPut( const SNDWaveData* p_data, u32 start, u32 end )
{
	u32 i,data_size;
	u8 pos;
	//const SNDWaveData** p_data = Snd_GetParamAdrs(SND_W_ID_WAVE_DATA);

	//OS_Printf( "wave_data formt    = %d\n", (p_data)->param.format );
	//OS_Printf( "wave_data loopflag = %d\n", (p_data)->param.loopflag );
	//OS_Printf( "wave_data rate     = %d\n", (p_data)->param.rate );
	//OS_Printf( "wave_data timer    = %d\n", (p_data)->param.timer );
	//OS_Printf( "wave_data loopstart= %d\n", (p_data)->param.loopstart );
	//OS_Printf( "wave_data looplen  = %d\n", (p_data)->param.looplen );

	data_size = ( (p_data)->param.loopstart + (p_data)->param.looplen );

	for( i=start;  i < end ;i++ ){

		//G[
		if( i >= data_size ){
			return;
		}

		//--------------------------------
		//			f[^		\ʒu
		//			127			0
		//
		//			0			128
		//CENTER----0-----------128-------
		//			255			129
		//
		//			128			255
		//--------------------------------
		if( (p_data)->samples[i] == 255 ){								//255
			pos = 129;													//\129

		}else if( (p_data)->samples[i] < WAVE_8_BIT_CENTER ){				//0-127
			pos = (128 - (p_data)->samples[i]);							//\0-128

		}else{
			pos = (255 - ((p_data)->samples[i] - WAVE_8_BIT_CENTER));		//\129-255
		}

		//OS_Printf( "(p_data)->samples[%d] = %d\n", i, pos );
		OS_Printf( "buf[%d] = %d;\n", i, pos );
	}

	return;
}

//--------------------------------------------------------------
/**
 * @brief	g`xZbg(}ӗp)
 *
 * @param	p_data		g`f[^̃AhX
 * @param	buf			i[obt@̃|C^
 * @param	max			i[obt@̍ő吔
 * @param	pitch		ݒ肵Ăsb`
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_ZukanWaveLevelSet_New( const SNDWaveData* p_data, u8* buf, int max, int pitch );
void Snd_ZukanWaveLevelSet_New( const SNDWaveData* p_data, u8* buf, int max, int pitch )
{
	int start;									//f[^`FbNJnʒu
	s8	status;									//݂̏(+1=A-1=)
	int i,pos,count;							//vZp
	u32 tick = Snd_ZukanPlayerGetSampleTick( SND_HANDLE_PMVOICE, p_data, pitch );

	//[100]A[50]`[100]`FbN
	start = tick - WAVE_LEVEL_BEFORE_POS;
	if( start < 0 ){
		start = 0;								//␳
	}

	//
	count = 0;
	pos	= 0;

	//݂̏ԃZbg(128ȉ͏AȊO͉)
	status = ((p_data)->samples[start] < 128 ) ? 1 : -1;

	for( i=start; i < tick ;i++ ){
	
		if( status > 0 ){									//ɂ
			if( (p_data)->samples[i] > 128 ){				//H
			
				pos = (count / WAVE_LEVEL_HABA);
				//pos = (pos >= max) ? (max-1) : pos;		//␳(KH)

				//Jbg(̂Ă)܂ĂH
				if( pos >= max ){
					pos = ( max - 1 );						//␳(KH)
				}
				//------------------------------

				//vf̎O
				//vf̌낪
				buf[max - 1 - pos]++;						//xCNg
				count = 0;
				status = ((p_data)->samples[i] < 128 ) ? 1 : -1;
			}else{
				count++;									//̂܂܂Ȃ̂ŃJE^CNg
			}

		}else if( status < 0 ){								//ɂ
			if( (p_data)->samples[i] < 128 ){				//ォH
			
				pos = (count / WAVE_LEVEL_HABA);
				//pos = (pos >= max) ? (max-1) : pos;		//␳(KH)

				//Jbg(̂Ă)܂ĂH
				if( pos >= max ){
					pos = ( max - 1 );						//␳(KH)
				}
				//------------------------------

				//vf̎O
				//vf̌낪
				buf[max - 1 - pos]++;						//xCNg
				count = 0;
				status = ((p_data)->samples[i] < 128 ) ? 1 : -1;
			}else{
				count++;									//̂܂܂Ȃ̂ŃJE^CNg
			}
		}
	}

#if 1
	//͓Kɂ߂`B
	//Kł܂B
	
	//c10iKɕ␳
	for( i=0; i < max ;i++ ){
		if( buf[i] >= 100 ){
			buf[i] = 9;
		}else if( buf[i] >= 10){
			buf[i] /= 10;
		}
	}
#endif

	//fobN\
	for( i=0; i < max ;i++ ){
		OS_Printf( "buf[%d] = %d\n", i, buf[i] );
	}
	OS_Printf( "\n------------\n" );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	g`xZbg
 *
 * @param	p_data		g`f[^̃AhX
 * @param	buf			i[obt@̃|C^
 * @param	max			i[obt@̍ő吔
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_ZukanWaveLevelSet( const SNDWaveData* p_data, u8* buf, int max );
void Snd_ZukanWaveLevelSet( const SNDWaveData* p_data, u8* buf, int max )
{
	int start;									//f[^`FbNJnʒu
	s8	status;									//݂̏(+1=A-1=)
	int i,pos,count;							//vZp
	u32 tick = Snd_PlayerGetSampleTick(SND_HANDLE_PMVOICE, p_data );

	//[100]A[50]`[100]`FbN
	start = tick - WAVE_LEVEL_BEFORE_POS;
	if( start < 0 ){
		start = 0;								//␳
	}

	//
	count = 0;
	pos	= 0;

	//݂̏ԃZbg(128ȉ͏AȊO͉)
	status = ((p_data)->samples[start] < 128 ) ? 1 : -1;

	for( i=start; i < tick ;i++ ){
	
		if( status > 0 ){									//ɂ
			if( (p_data)->samples[i] > 128 ){				//H
			
				pos = (count / WAVE_LEVEL_HABA);
				//pos = (pos >= max) ? (max-1) : pos;		//␳(KH)

				//Jbg(̂Ă)܂ĂH
				if( pos >= max ){
					pos = ( max - 1 );						//␳(KH)
				}
				//------------------------------

				//vf̎O
				//vf̌낪
				buf[max - 1 - pos]++;						//xCNg
				count = 0;
				status = ((p_data)->samples[i] < 128 ) ? 1 : -1;
			}else{
				count++;									//̂܂܂Ȃ̂ŃJE^CNg
			}

		}else if( status < 0 ){								//ɂ
			if( (p_data)->samples[i] < 128 ){				//ォH
			
				pos = (count / WAVE_LEVEL_HABA);
				//pos = (pos >= max) ? (max-1) : pos;		//␳(KH)

				//Jbg(̂Ă)܂ĂH
				if( pos >= max ){
					pos = ( max - 1 );						//␳(KH)
				}
				//------------------------------

				//vf̎O
				//vf̌낪
				buf[max - 1 - pos]++;						//xCNg
				count = 0;
				status = ((p_data)->samples[i] < 128 ) ? 1 : -1;
			}else{
				count++;									//̂܂܂Ȃ̂ŃJE^CNg
			}
		}
	}

#if 1
	//͓Kɂ߂`B
	//Kł܂B
	
	//c10iKɕ␳
	for( i=0; i < max ;i++ ){
		if( buf[i] >= 100 ){
			buf[i] = 9;
		}else if( buf[i] >= 10){
			buf[i] /= 10;
		}
	}
#endif

	//fobN\
	for( i=0; i < max ;i++ ){
		OS_Printf( "buf[%d] = %d\n", i, buf[i] );
	}
	OS_Printf( "\n------------\n" );

	return;
}
 
//--------------------------------------------------------------
/**
 * @brief	GtFNg̃R[obN֐(}Ӗp)
 *
 * @param	bufferL_p	L~LT[
 * @param	bufferR_p	R~LT[
 * @param	len			obt@̃TCY
 * @param	format		NNS_SndCaptureStartEffect֐̈(CAPTURE_FORMAT)Ɠ̂n
 * @param	arg			NNS_SndCaptureStartEffect֐̈(callbackInfo)Ɠ̂n
 *
 * @retval	none
 *
 * ȒPȃ[pXtB^iړρjďo͂Ă
 *
 * Ԃ̊Ԋu߁ÅԊu̕ϒlAČvZ邱Ƃɂ
 * ()Iȓm낤Ƃ́B
 * (ւƓ )
 */
//--------------------------------------------------------------
static void EffectCallback2( void* bufferL_p, void* bufferR_p, u32 len, NNSSndCaptureFormat format, void* arg )
{
    smp_t org[ FILTER_SIZE ][2];
    smp_t* lp = (smp_t*)bufferL_p;
    smp_t* rp = (smp_t*)bufferR_p;
    EffectCallbackInfo* info = (EffectCallbackInfo*)arg;
	u8* filter_size = Snd_GetParamAdrs(SND_W_ID_FILTER_SIZE);

    int samples;
    int x;
    int i, j;
    
	//Tv8rbgPCM͂̂܂
	//Tv16rbgPCMobt@̃TCY𔼕ɂ
    samples = ( format == NNS_SND_CAPTURE_FORMAT_PCM8 ) ? len : ( len >> 1 );

#ifdef SOUND_OS_PRINT_ON
	OS_Printf( "\n\nTEh@Lv`@GtFNg\n" );
	OS_Printf( "format = %d\n", format );			//0
	OS_Printf( "len = %d\n", len );					//1024
	OS_Printf( "samples = %d\n", samples );			//
	OS_Printf( "\n" );
#endif
    
	if( (*filter_size) == 0 ){
		return;		//Ȃ
	}

	//--------------------------------------------
	//
	//	LR~LT[̃TCY(samples)	= 256 
	//	tB^[TCY				= 8
	//
	//	lp[ 256 - 8 + i ]				= 248 + i
	//
	//	248,249,250,251,252,253,254,255ۑ
	//--------------------------------------------
    //LR~LT[̂AtB^[TCYۑ
    for( i = 0; i < (*filter_size) ; i++ ) {
        org[i][0] = lp[ samples - (*filter_size) + i ];
        org[i][1] = rp[ samples - (*filter_size) + i ];
		OS_Printf( "org[%d][] = %d\n", i, org[i][0] );
		OS_Printf( "org[%d][E] = %d\n", i, org[i][1] );
    }
    
	//--------------------------------------------
	// 
	//	LR~LT[̃TCY		= 256
	//	tB^[TCY			= 8
	//
    //	for( i = 256 - 1; i >= 8 - 1 ; i-- ){
	//	255...7܂ŏ
	//--------------------------------------------
	//LR~LT[̂AtB^[TCY̒l菬Ȃ܂ŏ
    for( i = samples - 1; i >= (*filter_size) - 1 ; i-- ){

		//--------------------------------------------
		// 
		//	LR~LT[̃TCY		= 256
		//	tB^[TCY			= 8
		//
		//	j = 0 ` 7
		//	x += lp[ 255 - j ];
		//	lp[255],[254],...[248]܂ł̒l𑫂āA
		//	tB^[TCYŊAς̒l߂
		//--------------------------------------------
		//L~LT[
        x = 0;
        for( j = 0 ; j < (*filter_size) ; j++ ) {	//tB^[TCYĂ
            x += lp[ i - j ];
        }
        lp[ i ] = (smp_t)(x /= (*filter_size));		//tB^[TCYŊ蕽ς̒l߂ď㏑
        
		//R~LT[
        x = 0;
        for( j = 0 ; j < (*filter_size) ; j++ ) {	//tB^[TCYĂ
            x += rp[ i - j ];
        }
        rp[ i ] = (smp_t)(x /= (*filter_size));		//tB^[TCYŊ蕽ς̒l߂ď㏑
    }
    


#if 0
#if FILTER_SIZE >= 2    
	//--------------------------------------------
	// obt@TCY = 24 tB^[TCY = 8
    //for( i = 8 - 2; i >= 0 ; i-- ){
	//6...0܂ŏ
	//--------------------------------------------
    for( i = (*filter_size) - 2 ; i >= 0 ; i-- ){

		//L~LT[
        x = lp[ i ];
        for( j = 1 ; j < (*filter_size) ; j++ ) {	//tB^[TCY
            x += GetSample( lp, i-j, 0, info );
        }
        lp[ i ] = (smp_t)(x /= (*filter_size));	//tB^[TCYŊ蕽ςŏ㏑
        
		//R~LT[
        x = rp[ i ];
        for( j = 1 ; j < (*filter_size) ; j++ ) {
            x += GetSample( rp, i-j, 1, info );
        }
        rp[ i ] = (smp_t)(x /= (*filter_size));	//tB^[TCYŊ蕽ςŏ㏑
    }
#endif
#endif
    



	//Lv`̈̃tB^TCY
	//ۑĂf[^ŏ㏑
	//(obt@̈Ԍ납AtB^[TCYۑĂf[^)
    for( i = 0; i < (*filter_size) ; i++ ) {
    	info->sample[i][0] = org[i][0];
		info->sample[i][1] = org[i][1];
    }

	//CɊmɏ
    DC_FlushRange( bufferL_p, samples );
    DC_FlushRange( bufferR_p, samples );

	//ɓnobt@́A(̊֐łinfo)
	//Lv`̈wĂ܂B
	//̗̈C邱ƂŁAۂɏo͂鉹ύX邱Ƃł܂B 
}


