//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		touchpanel_draw.c
 *@brief	^b`pl̕`
 *@author	tomoya takahashi
 *@data		2005.03.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#define __TOUCHPANEL_DRAW_H_GLOBAL
#include "touchpanel_draw.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
// ^b`pl`p
static void drawPoint(GF_BGL_INI* bgl, u16 x, u16 y, TP_BRUSH_DATA brush_data );					// _̕`
static void drawLine(GF_BGL_INI* bgl, u16 x1, u16 y1, u16 x2, u16 y2, TP_BRUSH_DATA brush_data );	// C
static void drawLineInOut(GF_BGL_INI* bgl, u16 x1, u16 y1, u16 x2, u16 y2,
		TP_BRUSH_DATA in_brush_data, TP_BRUSH_DATA out_brush_data,
		TP_PICTURE_DATA* pData );	// C̓OsC
static u32 getOffset( u16 x, u16 y, u16* p_shift, u32 char_width );				// LN^f[^ItZbg߂	

// fobNpxNgf[^`
static void drawVect(GF_BGL_INI* bgl, Vec2DS32* p_point1, Vec2DS32* p_point2 );

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
static GF_BGL_BMPWIN*	TouchPanelDrawDataIdx;	// ovf[^̃CfbNX
static TPData	TouchPanelOld;			// O̕`
static u8		TouchPanelDrawInit=0;	// `VXẽtO


//
/// ^b`y̕`p֐
//
//----------------------------------------------------------------------------
/**
 *
 * @brief	^b`y̕`ƃrbg}bv̍쐬
 *
 * @param	gf_bgl_frameFbg_system̕`BG̃io[
 * @param	width F`敝
 * @param	heightF`捂
 * @param	x	  F`Jn_
 * @param	y	  F`Jn_
 * @param	p_plttFgppbgf[^
 * @param	heap	gpq[v
 *
 * @return	none
 */
 //----------------------------------------------------------------------------
void DrawTPInit(GF_BGL_INI* bgl, int gf_bgl_frame, u32 width, u32 height, u32 x, u32 y, const u16* p_pltt, int heap)
{
	//
	// ^b`y`p̃rbg}bv쐬ăpbg[h
	//
	// Control쐬
	GF_BGL_BGCNT_HEADER		bg =		// BG̐ݒ
	{
		0,0,
//		GF_BGL_SCRSIZ_256_256,			// `͈͕(32*32)
		0x800,			// `͈͕(32*32)
		0,
		GX_BG_SCRSIZE_TEXT_256x256,
		GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x0000,
		GX_BG_CHARBASE_0x04000,
		GX_BG_EXTPLTT_01,
		0,
		0,
		0,
		FALSE
	};

	
	// 
	TouchPanelDrawInit = 1;
	
	//
	// R[ZbgZbgLN^쐬
	//
	GF_BGL_BGControlSet(bgl, gf_bgl_frame, &bg, GF_BGL_MODE_TEXT );
	
	TouchPanelDrawDataIdx = GF_BGL_BmpWinAllocGet(heap, 1);
	GF_BGL_BmpWinAdd(bgl, TouchPanelDrawDataIdx,
			gf_bgl_frame, x, y,
			width, height, 0, TP_WIN_CGX - (width * height) );
	
	// pbg[h
	DrawTPChgPltt( gf_bgl_frame, p_pltt );

	// ef[^Zbg
	TouchPanelOld.touch = 0;


	
	// ʂNA
	DrawTPClean(bgl, 0 );
	GF_BGL_BmpWinOn(TouchPanelDrawDataIdx );					// `
}

//----------------------------------------------------------------------------
/**
 *
 * @brief	pbgς
 * 
 * @param	gf_bgl_frameFbg_system̕`BG̃io[
 * @param	p_plttFgppbgf[^
 *
 * @return	none
 */
 //----------------------------------------------------------------------------
void DrawTPChgPltt( int gf_bgl_frame, const u16* p_pltt )
{
	// pbg[h
	if( gf_bgl_frame < GF_BGL_FRAME0_S ){
		GX_LoadBGPltt( (const void *)p_pltt, 0, sizeof(u16)*16 );
	}
	else{
		GXS_LoadBGPltt( (const void *)p_pltt, 0, sizeof(u16)*16 );
	}
}

//----------------------------------------------------------------------------
/**
 *
 * @brief	^b`pl`VXe̔j
 * 
 * @param	plttFpbgio[
 *
 * @return	none
 */
 //----------------------------------------------------------------------------
void DrawTPDelete(GF_BGL_INI* bgl, u16 pltt )
{
	// Ă邩`FbN
	SDK_ASSERTMSG( TouchPanelDrawInit != 0,
			"warning:TouchPanelDrawSystemĂ܂\n" );

	DrawTPClean(bgl, pltt );
	DrawTPPaste(bgl);
	GF_BGL_BmpWinDel( TouchPanelDrawDataIdx );
	sys_FreeMemoryEz(TouchPanelDrawDataIdx);
	
	// 
	TouchPanelDrawInit = 0;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ۂɉʂɕ`
 *
 *@param	none
 * 
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPPaste( GF_BGL_INI* bgl )
{
	// Ă邩`FbN
	SDK_ASSERTMSG( TouchPanelDrawInit != 0,
			"warning:TouchPanelDrawSystemĂ܂\n" );
	
	//
	// ۂɉʂɕ`悷
	//
	GF_BGL_BmpWinCgxOn(TouchPanelDrawDataIdx );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`pl`
 *
 *@param	pBuffF^b`plobt@
 *@param	sizeFobt@TCY
 *@param	brush_dataFgpuVf[^
 *@param	check_numF^b`pl񂪂ȏ㗣ĂV`l
 * 
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTP(GF_BGL_INI* bgl, TPData* pBuff, u32 size, TP_BRUSH_DATA brush_data, u16 check_num )
{
	int i;			// [vp
	
	for( i = 0; i < size; i++ )
	{
		DrawTPLine(bgl, pBuff[ i ], brush_data, check_num );		// 
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Oă^b`pl`
 *
 *@param	pBuffF^b`plobt@
 *@param	sizeFobt@TCY
 *@param	in_brush_dataF̈̂ƂgpuVf[^
 *@param	out_brush_dataF̈ÔƂgpuVf[^
 *@param	check_numF^b`pl񂪂ȏ㗣ĂV`l
 *@param	pDataFG̃f[^
 * 
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPInOut(GF_BGL_INI* bgl, TPData* pBuff, u32 size, TP_BRUSH_DATA in_brush_data, TP_BRUSH_DATA out_brush_data,
						 u16 check_num, TP_PICTURE_DATA* pData )
{
	int i;			// [vp

	
	for( i = 0; i < size; i++ )
	{
		DrawTPLineInOut(bgl, pBuff[ i ], in_brush_data, out_brush_data, check_num, pData );		// 
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`pl`
 *@brief	sync̒l`悵čs܂
 *
 *@param	pBuffF^b`plobt@
 *@param	sizeFobt@TCY
 *@param	brush_dataFgpuVf[^
 *@param	check_numF^b`pl񂪂ȏ㗣ĂV`l
 *@param	syncFI[gTvÔPt[ɃTvOl
 *@param	p_countFgpJE^(O[o)
 * 
 *@retval	OFs@
 *@retval	PFI
 *
 */
//-----------------------------------------------------------------------------
u32 DrawTPSync(GF_BGL_INI* bgl, TPData* pBuff, u32 size, TP_BRUSH_DATA brush_data, u16 check_num, u16 sync, u32* p_count )
{
	int i;			// [vp
	int num;		// I̐
	u32 ret = 0;	// ߂l

	// [v̏I̐Zbg
	num = *p_count + sync;
	if( num > size ){
		num = size;
		ret = 1;
	}
	
	for( i = *p_count; i < num; i++ )
	{
		DrawTPLine(bgl, pBuff[ i ], brush_data, check_num );		// 
	}

	*p_count = i;

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`pl`i_`j
 *
 *@param	BuffF^b`plobt@
 *@param	brush_dataFgpuVf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPPoint(GF_BGL_INI* bgl, TPData Buff, TP_BRUSH_DATA brush_data )
{	
	// Ă邩`FbN
	SDK_ASSERTMSG( TouchPanelDrawInit != 0,
			"warning:TouchPanelDrawSystemĂ܂\n" );
	
	//
	// initŎ擾ovf[^̃LN^f[^ɓ_
	//
	if( (Buff.touch == TP_TOUCH_ON) &&
		(Buff.validity == TP_VALIDITY_VALID) ){
		drawPoint(bgl, Buff.x, Buff.y, brush_data );		// _
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`pl`iɂj
 *
 *@param	BuffF^b`plobt@
 *@param	brush_dataFgpuVf[^
 *@param	check_numFVn߂Ƃ̂POƂ̍ő卷
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPLine(GF_BGL_INI* bgl, TPData Buff, TP_BRUSH_DATA brush_data, u16 check_num )
{	
	// Ă邩`FbN
	SDK_ASSERTMSG( TouchPanelDrawInit != 0,
			"warning:TouchPanelDrawSystemĂ܂\n" );
	
	// O^b`ȂΐVn߂
	if( TouchPanelOld.touch == TP_TOUCH_OFF ){
		TouchPanelOld = Buff;
	}else{
		// ܂ɂPO̒lƂ̍Ƃ͐Vn߂
		if( (((TouchPanelOld.x - Buff.x) > check_num) ||
			((TouchPanelOld.y - Buff.y) > check_num)) ||
			(((TouchPanelOld.x - Buff.x) < -check_num) ||
			((TouchPanelOld.y - Buff.y) < -check_num)))
		{
			TouchPanelOld = Buff;
		}
	}
	
	// ^b`Ă`
	if( (Buff.touch == TP_TOUCH_ON) &&
		(Buff.validity == TP_VALIDITY_VALID) ){
		//
		// initŎ擾ovf[^̃LN^f[^ɓ_
		//
		drawLine(bgl, TouchPanelOld.x, TouchPanelOld.y, Buff.x, Buff.y, brush_data );		// _

		// f[^Zbg
		TouchPanelOld = Buff;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	^b`pl`iɂjOsĕ`
 *
 *@param	BuffF^b`plobt@
 *@param	in_brush_dataF̈̂ƂgpuVf[^
 *@param	out_brush_dataF̈ÔƂgpuVf[^
 *@param	check_numF^b`pl񂪂ȏ㗣ĂV`l
 *@param	pDataFG̃f[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPLineInOut(GF_BGL_INI* bgl, TPData Buff, TP_BRUSH_DATA in_brush_data, TP_BRUSH_DATA out_brush_data,
					  u16 check_num, TP_PICTURE_DATA* pData )
{	
	// Ă邩`FbN
	SDK_ASSERTMSG( TouchPanelDrawInit != 0,
			"warning:TouchPanelDrawSystemĂ܂\n" );
	
	// O^b`ȂΐVn߂
	if( TouchPanelOld.touch == TP_TOUCH_OFF ){
		TouchPanelOld = Buff;
	}else{
		// ܂ɂPO̒lƂ̍Ƃ͐Vn߂
		if( (((TouchPanelOld.x - Buff.x) > check_num) ||
			((TouchPanelOld.y - Buff.y) > check_num)) ||
			(((TouchPanelOld.x - Buff.x) < -check_num) ||
			((TouchPanelOld.y - Buff.y) < -check_num)))
		{
			TouchPanelOld = Buff;
		}
	}
	
	// ^b`Ă`
	if( (Buff.touch == TP_TOUCH_ON) &&
		(Buff.validity == TP_VALIDITY_VALID) ){
		//
		// initŎ擾ovf[^̃LN^f[^ɓ_
		//
		drawLineInOut(bgl, TouchPanelOld.x, TouchPanelOld.y, Buff.x, Buff.y, in_brush_data, out_brush_data, pData );		// _

		// f[^Zbg
		TouchPanelOld = Buff;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ovN[
 *
 *@param	pltt_numFhԂpbgio[
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPClean(GF_BGL_INI* bgl, u16 pltt_num )
{
	// Ă邩`FbN
	SDK_ASSERTMSG( TouchPanelDrawInit != 0,
			"warning:TouchPanelDrawSystemĂ܂\n" );

	//
	// pbgio[̐FŃN[
	//
	GF_BGL_BmpWinDataFill(TouchPanelDrawDataIdx, pltt_num );			// hԂ
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ۑĂPO̍W
 *
 *@param	none
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DrawTPOldMatDest( void )
{
	// 
	TouchPanelOld.touch = TP_TOUCH_OFF;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	uVf[^쐬
 *
 *@param	p_brushFuVf[^
 *@param	plttFpbgio[
 *@param	size_xFTCY
 *@param	size_yFăTCY
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void MakeTPBrush( TP_BRUSH_DATA* p_brush, u16 pltt, u16 size_x, u16 size_y, int heap )
{
	int i, j;
	int make_size;		// LN^f[^̃TCY
	u16 shift;			// Vtgl
	u32 offset;			// ItZbgl

	
	//
	// uVf[^쐬
	// LN^͐΂ɂW̔{ɂ
	// ȂƂ͂O
	//
	// LN^f[^TCY߂
	p_brush->SizeX = size_x;
	p_brush->SizeY = size_y;
	if( (p_brush->SizeX % 8) != 0 ){
		p_brush->SizeX += (8 - (size_x % 8));
	}
	if( (p_brush->SizeY % 8) != 0 ){
		p_brush->SizeY += (8 - (size_y % 8));
	}

	
	p_brush->pCharData = (u16*)sys_AllocMemory( heap, sizeof(u16) * ((p_brush->SizeX / 4) * p_brush->SizeY) );

	// 0ŏ
	for( i = 0; i < (p_brush->SizeX / 4) * p_brush->SizeY; i++ ){
		p_brush->pCharData[ i ] = 0;
	}


	// LN^pbg̐FœhԂ
	for( i = 0; i < size_y; i++ ){
		for( j = 0; j < size_x; j++ ){
			// WʒũItZbg߂
			offset = getOffset( j, i, &shift, p_brush->SizeX / 8 );

			// ItZbg̈ʒuɊi[
			*(p_brush->pCharData + offset) |= pltt << shift;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	G̃uVf[^쐬
 *@brief	TCY͕KLN^PʁiWjł肢܂
 *
 *@param	p_brushFuVf[^
 *@param	p_charFG̃LN^f[^
 *@param	size_xFTCY
 *@param	size_yFăTCY
 *@param	heap	gpq[v
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void MakeTPGraphicBrush( TP_BRUSH_DATA* p_brush, const u16* p_char, u16 size_x, u16 size_y, int heap )
{
	int i, j;
	int make_size;		// LN^f[^̃TCY
	u16 shift;			// Vtgl
	u32 offset;			// ItZbgl

	
	//
	// uVf[^쐬
	// LN^͐΂ɂW̔{ɂ
	// ȂƂ͂O
	//
	// LN^f[^TCY߂
	p_brush->SizeX = size_x;
	p_brush->SizeY = size_y;

	
	p_brush->pCharData = (u16*)sys_AllocMemory( heap, sizeof(u16) * ((p_brush->SizeX / 4) * p_brush->SizeY) );

	// Rs[
	MI_CpuCopy16( p_char, p_brush->pCharData, sizeof(u16) * ((p_brush->SizeX / 4) * p_brush->SizeY) );

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	uVf[^j
 *
 *@param	p_brushFuVf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DestTPBrush( TP_BRUSH_DATA* p_brush )
{
	//
	// uVf[^j
	//
	sys_FreeMemoryEz( p_brush->pCharData );
	p_brush->pCharData = NULL;
}
	
//----------------------------------------------------------------------------
/**
 *
 *@brief	`悷
 *
 *@param	x1F`JnW
 *@param	y1F`JnW
 *@param	x2F`IW
 *@param	y2F`IW
 *@param	brush_dataFuVf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void drawLine(GF_BGL_INI* bgl, u16 x1, u16 y1, u16 x2, u16 y2, TP_BRUSH_DATA brush_data )
{
	u16 width, height;			// C̕ƍ
	int i;						// [vp
	u16 min;					// W̍Œ̒liPÂقj
	u16 max;					// W̍ő̒liPÂقj
	u16 base;					// x[X̒limin̍W̎̒lj
	u16 px, py;					// sNZʒu
	s32 vec_heigt;				// ̌X
	
	
	// ƕ擾
	width = (u16) ((x1 >= x2) ? (x1 - x2) : (x2 - x1));  // 擾
    height = (u16) ((y1 >= y2) ? (y1 - y2) : (y2 - y1)); // 擾

	
	// 傫قPhbgÂWɂ
	if( width > height ){
		if( x1 >= x2 ){
			min = x2;
			max = x1;
			base = y2;
	
			// X߂
			vec_heigt = ((y2 - y1) * 10000) / (x2 - x1);
		}else{
			min = x1;
			max = x2;
			base = y1;

			// X߂
			vec_heigt = ((y1 - y2) * 10000) / (x1 - x2);
		} 

		// ɉē_`
		for( i = min; i < max; i++ ){
			px = i;
			py = (u16) (base + ((vec_heigt * (i - min)) / 10000));
			drawPoint(bgl, px, py, brush_data );
		}
	}else{
		if( y1 >= y2 ){
			min = y2;
			max = y1;
			base = x2;
	
			// X߂
			vec_heigt = ((x2 - x1) * 10000) / (y2 - y1);
		}else{
			min = y1;
			max = y2;
			base = x1;

			// X߂
			vec_heigt = ((x1 - x2) * 10000) / (y1 - y2);
		} 

		// ɉē_`
		for( i = min; i < max; i++ ){
			px = (u16) (base + ((vec_heigt * (i - min)) / 10000));
			py = i;
			drawPoint( bgl, px, py, brush_data );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	O肵Ȃ`悷
 *
 *@param	u16 x1F`JnW
 *@param	u16 y1F`JnW
 *@param	u16 x2F`IW
 *@param	u16 y2F`IW
 *@param	TP_BRUSH_DATA in_brush_dataF̈uVf[^
 *@param	TP_BRUSH_DATA out_brush_dataF̈OuVf[^
 *@param	TP_PICTURE_DATA* pDataFG̃f[^
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
static void drawLineInOut(GF_BGL_INI* bgl, u16 x1, u16 y1, u16 x2, u16 y2,
		TP_BRUSH_DATA in_brush_data, TP_BRUSH_DATA out_brush_data,
		TP_PICTURE_DATA* pData )
{
	u16 width, height;			// C̕ƍ
	int i;						// [vp
	u16 min;					// W̍Œ̒liPÂقj
	u16 max;					// W̍ő̒liPÂقj
	u16 base;					// x[X̒limin̍W̎̒lj
	u16 px, py;					// sNZʒu
	s32 vec_heigt;				// ̌X
	
	
	// ƕ擾
	width = (u16) ((x1 >= x2) ? (x1 - x2) : (x2 - x1));  // 擾
    height = (u16) ((y1 >= y2) ? (y1 - y2) : (y2 - y1)); // 擾

	
	// 傫قPhbgÂWɂ
	if( width > height ){
		if( x1 >= x2 ){
			min = x2;
			max = x1;
			base = y2;
	
			// X߂
			vec_heigt = ((y2 - y1) * 10000) / (x2 - x1);
		}else{
			min = x1;
			max = x2;
			base = y1;

			// X߂
			vec_heigt = ((y1 - y2) * 10000) / (x1 - x2);
		} 

		// ɉē_`
		for( i = min; i < max; i++ ){
			px = i;
			py = (u16) (base + ((vec_heigt * (i - min)) / 10000));

			// O
			if( CheckTPPictureInOut( pData, px, py ) == 1 ){
				drawPoint(bgl, px, py, in_brush_data );
			}else{	
				drawPoint(bgl, px, py, out_brush_data );
			}
		}
	}else{
		if( y1 >= y2 ){
			min = y2;
			max = y1;
			base = x2;
	
			// X߂
			vec_heigt = ((x2 - x1) * 10000) / (y2 - y1);
		}else{
			min = y1;
			max = y2;
			base = x1;

			// X߂
			vec_heigt = ((x1 - x2) * 10000) / (y1 - y2);
		} 

		// ɉē_`
		for( i = min; i < max; i++ ){
			px = (u16) (base + ((vec_heigt * (i - min)) / 10000));
			py = i;
			
			// O
			if( CheckTPPictureInOut( pData, px, py ) == 1 ){
				drawPoint(bgl, px, py, in_brush_data );
			}else{	
				drawPoint(bgl, px, py, out_brush_data );
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_`悷
 *
 *@param	u16 xF`悘W
 *@param	u16 yF`悙W
 *@param	TP_BRUSH_DATA brush_dataFuVf[^
 *
 *@return
 *
 */
//-----------------------------------------------------------------------------
static void drawPoint(GF_BGL_INI* bgl, u16 x, u16 y, TP_BRUSH_DATA brush_data )
{
	s32		draw_start_x = 0;		// ʊOɊGяoƂɂǂ`邩
	s32		draw_start_y = 0;		// ʊOɊGяoƂɂǂ`邩
	int		i;						// [vp
	u32		offset;					// ItZbg
	u16		shift;					// Vtg

	
	// I[o[lvZ
	// 0ȉ`FbN
	if( x - (brush_data.SizeX / 2) < 0 ){
		draw_start_x = -(x - (brush_data.SizeX / 2));

	}
	if( y - (brush_data.SizeY / 2) < 0 ){
		draw_start_y = -(y - (brush_data.SizeY / 2));
	}

	

	// `
	// ɂĂƂ͂Pi
	if( draw_start_x == 0 ){
		GF_BGL_BmpWinPrint( 
				TouchPanelDrawDataIdx,
				brush_data.pCharData,
				draw_start_x,
				draw_start_y,
				brush_data.SizeX - draw_start_x,
				brush_data.SizeY - draw_start_y,
				x - (brush_data.SizeX / 2) + draw_start_x,
				y - (brush_data.SizeY / 2) + draw_start_y,
				brush_data.SizeX - draw_start_x,
				brush_data.SizeY - draw_start_y );
	}else{
		// Pi`
		for( i = draw_start_y; i < brush_data.SizeY; i++ ){
			// ̃ItZbg߂
			offset = getOffset( 0, i, &shift, brush_data.SizeX / 8 );
			
			GF_BGL_BmpWinPrint( 
					TouchPanelDrawDataIdx,
					(brush_data.pCharData + offset),
					draw_start_x,
					0,
					brush_data.SizeX - draw_start_x,
					1,
					x - (brush_data.SizeX / 2) + draw_start_x,
					y - (brush_data.SizeY / 2) + i,
					brush_data.SizeX - draw_start_x,
					1 );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	LN^f[^ItZbg߂
 *
 *@param	u16 x,yFWl
 *@param	u16* p_shiftFVtgli[p
 *@param	u32 char_widthFWW̐
 *
 *@return	u32	^FItZbgl(u16*^p)
 *
 */
//-----------------------------------------------------------------------------
static u32 getOffset( u16 x, u16 y, u16* p_shift, u32 char_width )
{
	u32	offset;			// ItZbgl
	u16 char_off_y;		// PLN^f[^̃ItZbg
	u16 char_off_x;		// PLN^f[^̃ItZbg

	
	//
	// Wlu16^(QoCg)p̃ItZbg߂
	//
	// LN^Pʂ̔z̑傫߂	
	// ̈ʒũLN^ItZbg߂
	offset = ((y / 8) * char_width) + (x / 8);

	// W\̂ɕKvU16̐
	offset *= 16;

	// LN^̃ItZbg߂
	char_off_y = y % 8;
	char_off_x = x % 8;
	char_off_y *= 2;				// 2LN^f[^̉͂W@Wi[ɂu162Kv
	char_off_y += char_off_x / 4;	// 4u16ɂ͂SsNZ̐F邩Sȏ̂Ƃ͂P炵ʒuItZbgɂ
	char_off_x %= 4;				// char_off_yłSȏ̂Ƃ̃ItZbg炵̂łŜ܂̒lɂ(Vtgl)
	char_off_x *= 4;				// ŃVtgl

	// Vtgli[
	*p_shift = char_off_x;	

	return offset + char_off_y;
}

#if 0
//----------------------------------------------------------------------------
/**
 *
 *@brief	xNgf[^`悷
 *				(fobNp@@Opf[^`悷邽߂ɍ쐬܂)
 *
 *@param	Vec2DS32* p_point1F_ƃxNgf[^
 *@param	Vec2DS32* p_point2F_ƃxNgf[^
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
static void drawVect(GF_BGL_INI* bgl, Vec2DS32* p_point1, Vec2DS32* p_point2 )
{	
	TP_BRUSH_DATA brush;
	
	MakeTPBrush( &brush, 3, 4, 4 );
	
	//
	// xNgf[^`悷
	//
	drawLine( bgl, p_point1->x, p_point1->y, p_point2->x, p_point2->y, brush );

	DestTPBrush( &brush );
}
#endif
