//============================================================================================
/**
 * @file	window.c
 * @brief	EBhE\
 * @author	Hiroyuki Nakamura
 * @date	2005.10.13
 */
//============================================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/lib_pack.h"
#include "system/winframe.naix"
#include "system/menu_gra.naix"
#include "field/field_board.naix"

#define WINDOW_H_GLOBAL
#include "system/window.h"



//============================================================================================
//	萔`
//============================================================================================
/*
#define	CHR_HFLIP	( 0x0400 )		///<LE]rbg
#define	CHR_VFLIP	( 0x0800 )		///<L㉺]rbg
#define	CHR_HVFLIP	( 0x0c00 )		///<L㉺E]rbg
*/

//============================================================================================
//	vg^Cv錾
//============================================================================================
extern void PokeFontTrgCursorCgxSet( u16 cgx );

static void CursorCgxMake( GF_BGL_BMPWIN * win, u16 cgxnum, u16 type );


//============================================================================================
//	O[oϐ
//============================================================================================


//============================================================================================
//============================================================================================
//	j[EBhE
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * j[EBhẼOtBbNZbg
 *
 * @param	ini			BGLf[^
 * @param	frmnum		BGt[
 * @param	cgx			L]ʒu
 * @param	pal			pbgԍ
 * @param	win_num		EBhEԍ
 * @param	heap		q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuWinGraphicSet( GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 pal, u8 win_num, u32 heap )
{
//	void * buf;
//	u32	size;

//	GF_BGL_LoadCharacterFile( ini, frmnum, "/data/menu_win_sch.dat", cgx );

//	buf = sys_LoadFile( heap, "/data/menu_win_scl.dat" );
//	GF_BGL_PaletteSet( frmnum, buf, 32, pal*32 );
//	sys_FreeMemory( heap, buf );

	ArcUtil_BgCharSet(
		ARC_WINFRAME, NARC_winframe_system_ncgr+win_num, ini, frmnum, cgx, 0, 0, heap );
	if( frmnum < GF_BGL_FRAME0_S ){
		ArcUtil_PalSet(
			ARC_WINFRAME, NARC_winframe_system_nclr , PALTYPE_MAIN_BG, pal*0x20, 0x20, heap );
	}else{
		ArcUtil_PalSet(
			ARC_WINFRAME, NARC_winframe_system_nclr , PALTYPE_SUB_BG, pal*0x20, 0x20, heap );
	}
}

//--------------------------------------------------------------------------------------------
/**
 *	j[EChE`惁C
 *
 * @param	frm			BGt[io[(bg_sys)
 * @param	px			wW
 * @param	py			xW
 * @param	sx			wTCY
 * @param	sy			TCY
 * @param	pal			gppbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BmpMenuWinWriteMain(
				GF_BGL_INI * ini, u8 frm, u8 px, u8 py, u8 sx, u8 sy, u8 pal, u16 cgx )
{
	GF_BGL_ScrFill( ini, frm, cgx,   px-1,  py-1, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+1, px,    py-1, sx, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+2, px+sx, py-1, 1,  1, pal );

	GF_BGL_ScrFill( ini, frm, cgx+3, px-1,  py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+5, px+sx, py, 1, sy, pal );

	GF_BGL_ScrFill( ini, frm, cgx+6, px-1,  py+sy, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+7, px,    py+sy, sx, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+8, px+sx, py+sy, 1,  1, pal );
}

//--------------------------------------------------------------------------------------------
/**
 * j[EBhE`
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 * @param	win_cgx		EBhELʒu
 * @param	pal			pbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpMenuWinWrite( GF_BGL_BMPWIN * win, u8 trans_sw, u16 win_cgx, u8 pal )
{
	u8	frm = GF_BGL_BmpWinGet_Frame( win );

	BmpMenuWinWriteMain(
		win->ini, frm,
		GF_BGL_BmpWinGet_PosX( win ),
		GF_BGL_BmpWinGet_PosY( win ),
		GF_BGL_BmpWinGet_SizeX( win ),
		GF_BGL_BmpWinGet_SizeY( win ),
		pal, win_cgx );

	if( trans_sw == WINDOW_TRANS_ON ){
//		GF_BGL_LoadScreenReq( win->ini, frm );
		GF_BGL_BmpWinOn( win );
	}
}

//--------------------------------------------------------------------------------------------
/**
 *	j[EBhENA
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpMenuWinClear( GF_BGL_BMPWIN * win, u8 trans_sw )
{
	u8	frm = GF_BGL_BmpWinGet_Frame( win );

	GF_BGL_ScrFill(
		win->ini, frm, 0,
		GF_BGL_BmpWinGet_PosX( win ) - 1,
		GF_BGL_BmpWinGet_PosY( win ) - 1,
		GF_BGL_BmpWinGet_SizeX( win ) + 2,
		GF_BGL_BmpWinGet_SizeY( win ) + 2,
		0 );

	if( trans_sw == WINDOW_TRANS_ON ){
//		GF_BGL_LoadScreenReq( win->ini, frm );
		GF_BGL_BmpWinOff( win );
	}
}


//============================================================================================
//============================================================================================
//	bEBhE
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 *	bEChEL̃A[JCuCfbNX擾
 *
 * @param	id		EBhEID
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 TalkWinCgxArcGet( u32 id )
{
	return ( NARC_winframe_talk_win00_ncgr + id );
}

//--------------------------------------------------------------------------------------------
/**
 *	bEChEpbg̃A[JCuCfbNX擾
 *
 * @param	id		EBhEID
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 TalkWinPalArcGet( u32 id )
{
	return ( NARC_winframe_talk_win00_nclr + id );
}

//--------------------------------------------------------------------------------------------
/**
 *	bEChEZbg
 *
 * @param	ini			BGLf[^
 * @param	frm			BGt[io[(bg_sys)
 * @param	cgx			LZbgʒu
 * @param	pal			gppbg
 * @param	win_num		EBhEԍ
 * @param	heap		q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TalkWinGraphicSet( GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 pal, u8 win_num, u32 heap )
{
	ArcUtil_BgCharSet( ARC_WINFRAME, TalkWinCgxArcGet(win_num), ini, frmnum, cgx, 0, 0, heap );
	if( frmnum < GF_BGL_FRAME0_S ){
		ArcUtil_PalSet(
			ARC_WINFRAME, TalkWinPalArcGet(win_num), PALTYPE_MAIN_BG, pal*0x20, 0x20, heap );
	}else{
		ArcUtil_PalSet(
			ARC_WINFRAME, TalkWinPalArcGet(win_num), PALTYPE_SUB_BG, pal*0x20, 0x20, heap );
	}
}

//--------------------------------------------------------------------------------------------
/**
 *	bEChE`惁C
 *
 * @param	ini			BGLf[^
 * @param	frm			BGt[io[(bg_sys)
 * @param	px			wW
 * @param	py			xW
 * @param	sx			wTCY
 * @param	sy			TCY
 * @param	pal			gppbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BmpTalkWinWriteMain(
				GF_BGL_INI * ini, u8 frm, u8 px, u8 py, u8 sx, u8 sy, u8 pal, u16 cgx )
{
	GF_BGL_ScrFill( ini, frm, cgx, px-2, py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+1, px-1, py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+2, px, py-1, sx, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+3, px+sx,	py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+4, px+sx+1, py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+5, px+sx+2, py-1, 1, 1, pal );

	GF_BGL_ScrFill( ini, frm, cgx+6, px-2, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+7, px-1, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+9, px+sx, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+10, px+sx+1, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+11, px+sx+2, py, 1, sy, pal );

	GF_BGL_ScrFill( ini, frm, cgx+12, px-2, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+13, px-1, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+14, px, py+sy, sx, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+15, px+sx, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+16, px+sx+1, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+17, px+sx+2, py+sy, 1, 1, pal );
}

//--------------------------------------------------------------------------------------------
/**
 * bEBhEXN[f[^ABitmapWindowɊ֘Atꂽ
 * BGt[̃XN[obt@ɃZbg
 *
 * @param   win		
 * @param   charno		
 * @param   palno		
 *
 */
//--------------------------------------------------------------------------------------------
void BmpTalkWinScreenSet( GF_BGL_BMPWIN * win, u32 charno, u32 palno )
{
	BmpTalkWinWriteMain(
		win->ini,
		GF_BGL_BmpWinGet_Frame( win ),
		GF_BGL_BmpWinGet_PosX( win ),
		GF_BGL_BmpWinGet_PosY( win ),
		GF_BGL_BmpWinGet_SizeX( win ),
		GF_BGL_BmpWinGet_SizeY( win ),
		palno, charno );
}

//--------------------------------------------------------------------------------------------
/**
 * bEBhE`
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 * @param	win_cgx		EBhELʒu
 * @param	pal			pbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpTalkWinWrite( GF_BGL_BMPWIN * win, u8 trans_sw, u16 win_cgx, u8 pal )
{
	BmpTalkWinScreenSet( win, win_cgx, pal );

	if( trans_sw == WINDOW_TRANS_ON ){
//		GF_BGL_LoadScreenReq( win->ini, frm );
		GF_BGL_BmpWinOn( win );
	}

	CursorCgxMake( win, win_cgx, 0 );
//	PokeFontTrgCursorCgxSet( win_cgx );
}

//--------------------------------------------------------------------------------------------
/**
 *	bEBhENA
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpTalkWinClear( GF_BGL_BMPWIN * win, u8 trans_sw )
{
	u8	frm = GF_BGL_BmpWinGet_Frame( win );

	GF_BGL_ScrFill(
		win->ini, frm, 0,
		GF_BGL_BmpWinGet_PosX( win ) - 2,
		GF_BGL_BmpWinGet_PosY( win ) - 1,
		GF_BGL_BmpWinGet_SizeX( win ) + 5,
		GF_BGL_BmpWinGet_SizeY( win ) + 2,
		0 );

	if( trans_sw == WINDOW_TRANS_ON ){
//		GF_BGL_LoadScreenReq( win->ini, frm );
		GF_BGL_BmpWinOff( win );
	}
}




#define	MAKE_CURSOR_CGX_SIZ		( 0x20*4*3 )

static void GF_BmpPrintObj(
			void * src, u16 src_x, u16 src_y, u16 src_dx, u16 src_dy,
			void * buf, u16 buf_sx, u16 buf_sy, u16 win_x, u16 win_y, u16 win_dx, u16 win_dy )
{
	BMPPRT_HEADER	src_data;
	BMPPRT_HEADER	dst_data;

	src_data.adrs	= (u8 *)src;
	src_data.size_x = src_dx;
	src_data.size_y = src_dy;

	dst_data.adrs	= (u8 *)buf;
	dst_data.size_x = buf_sx;
	dst_data.size_y = buf_sy;

	GF_BMP_PrintMain( &src_data, &dst_data, src_x, src_y, win_x, win_y, win_dx, win_dy, 0 );
}

static void CursorCgxMake( GF_BGL_BMPWIN * win, u16 cgxnum, u16 type )
{
	u32	heap;
	u8 * wincgx;
	u8 * scrcgx;
	u8 * curcgx;
	void * arc;
	u8	frm;
	u8	i;

	heap   = GF_BGL_HeapIDGet( win->ini );
	frm    = GF_BGL_BmpWinGet_Frame( win );
	wincgx = sys_AllocMemory( heap, MAKE_CURSOR_CGX_SIZ );
	scrcgx = GF_BGL_CgxGet( frm );

	{
		NNSG2dCharacterData * dat;
		arc = ArcUtil_CharDataGet( ARC_WINFRAME, NARC_winframe_win_cursol1_ncgr, 0, &dat, heap );
		curcgx = (u8 *)dat->pRawData;
	}

	for( i=0; i<3; i++ ){
		memcpy( &wincgx[i*0x20*4+0x20*0], &scrcgx[(cgxnum+10)*0x20], 0x20 );
		memcpy( &wincgx[i*0x20*4+0x20*1], &scrcgx[(cgxnum+11)*0x20], 0x20 );
		memcpy( &wincgx[i*0x20*4+0x20*2], &scrcgx[(cgxnum+10)*0x20], 0x20 );
		memcpy( &wincgx[i*0x20*4+0x20*3], &scrcgx[(cgxnum+11)*0x20], 0x20 );
	}

	GF_BmpPrintObj( curcgx, 4, 0, 12, 16*3, wincgx, 12, 16*3, 1, 0, 12, 16*3 );

	GF_BGL_LoadCharacter( win->ini, frm, wincgx, MAKE_CURSOR_CGX_SIZ, cgxnum+18 );
	PokeFontTrgCursorCgxSet( cgxnum );

	sys_FreeMemoryEz( arc );
	sys_FreeMemoryEz( wincgx );
}


void TalkWinGraphicNullSet( GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 col, u8 win_num, u32 heap )
{
	void * arc;
	NNSG2dCharacterData * dat;
	u8 * curcgx;
	u32	i;
	u8	dott, dotu;

	arc = ArcUtil_CharDataGet(
			ARC_WINFRAME, TalkWinCgxArcGet(win_num), 0, &dat, heap );
	curcgx = sys_AllocMemory( heap, 0x20*18 );
	memcpy( curcgx, dat->pRawData, 0x20*18 );

	for( i=0; i<0x20*18; i++ ){
		dott = curcgx[i] >> 4;
		dotu = curcgx[i] & 0x0f;
		if( dott == 0 ){ dott = col; }
		if( dotu == 0 ){ dotu = col; }
		curcgx[i] = (dott<<4)|dotu;
	}

	GF_BGL_LoadCharacter( ini, frmnum, curcgx, 0x20*18, cgx );
	sys_FreeMemoryEz( arc );
	sys_FreeMemoryEz( curcgx );
}





//============================================================================================
//============================================================================================
//	ŔEBhE
//============================================================================================
//============================================================================================
#define	BOARD_TOWNMAP_START		( NARC_field_board_board_town000_NCGR )
#define	BOARD_ROADMAP_START		( NARC_field_board_board_road000_NCGR )


static void BoardMapCgxSet(
				GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 type, u16 map, u32 heap );


//--------------------------------------------------------------------------------------------
/**
 * ŔEChEZbg
 *
 * @param	ini			BGLf[^
 * @param	frm			BGt[io[(bg_sys)
 * @param	cgx			LZbgʒu
 * @param	pal			gppbg
 * @param	type		Ŕ^Cv
 * @param	map			}bvԍi^E}bvAWj
 * @param	heap		q[vID
 *
 * @return	none
 *
 *	type = *_POST, *_INFO ̏ꍇ́Amap = 0 ŗǂ
 */
//--------------------------------------------------------------------------------------------
void BoardWinGraphicSet(
		GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 pal, u8 type, u16 map, u32 heap )
{
	// EBhEL]
	ArcUtil_BgCharSet(
		ARC_FIELD_BOARD, NARC_field_board_kanb_win00_NCGR,
		ini, frmnum, cgx, BOARD_WIN_CGX_SIZ*0x20, 0, heap );

	// EBhEpbg]
	{
		NNSG2dPaletteData * nns;
		void * buf;
		u16 * dat;
		
		buf = ArchiveDataLoadMalloc( ARC_FIELD_BOARD, NARC_field_board_kanb_win00_NCLR, heap );
		NNS_G2dGetUnpackedPaletteData( buf, &nns );
		dat = (u16 *)nns->pRawData;
		GF_BGL_PaletteSet( frmnum, (void *)&dat[type*16], 0x20, pal*0x20 );
		sys_FreeMemory( heap, buf );
	}

	// n}Zbg
	if( type == BOARD_TYPE_TOWN || type == BOARD_TYPE_ROAD ){
//		BoardMapSet( ini, frmnum, cgx+BOARD_WIN_CGX_SIZ, pal, type, map, heap );
		BoardMapCgxSet( ini, frmnum, cgx+BOARD_WIN_CGX_SIZ, type, map, heap );
	}
}

static void BoardMapCgxSet(
				GF_BGL_INI * ini, u8 frmnum, u16 cgx, u8 type, u16 map, u32 heap )
{
	if( type == BOARD_TYPE_TOWN ){
		map += BOARD_TOWNMAP_START;
	}else{
		map += BOARD_ROADMAP_START;
	}
	ArcUtil_BgCharSet(
		ARC_FIELD_BOARD, map, ini, frmnum, cgx, BOARD_MAP_CGX_SIZ*0x20, 0, heap );
}


//--------------------------------------------------------------------------------------------
/**
 *	ŔEChE`惁CiAŔj
 *
 * @param	ini			BGLf[^
 * @param	frm			BGt[io[(bg_sys)
 * @param	px			wW
 * @param	py			xW
 * @param	sx			wTCY
 * @param	sy			TCY
 * @param	pal			gppbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BmpBoardWinWriteMain(
				GF_BGL_INI * ini, u8 frm, u8 px, u8 py, u8 sx, u8 sy, u8 pal, u16 cgx )
{
/*
	GF_BGL_ScrFill( ini, frm, cgx,   px-9,	 py-1, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+1, px-8,	 py-1, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+2, px-7,	 py-1, sx+7, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+3, px+sx,	 py-1, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+4, px+sx+1, py-1, 1,  1, pal );

	GF_BGL_ScrFill( ini, frm, cgx+5, px-9,	 py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+6, px-8,	 py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+7, px-1,	 py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+8, px+sx,	 py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+9, px+sx+1, py, 1, sy, pal );

	GF_BGL_ScrFill( ini, frm, cgx+10, px-9,	  py+sy, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+11, px-8,	  py+sy, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+12, px-7,	  py+sy, sx+7, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+13, px+sx,  py+sy, 1,  1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+14, px+sx+1, py+sy, 1,  1, pal );
*/
	GF_BGL_ScrFill( ini, frm, cgx, px-9, py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+1, px-8, py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+2, px-7, py-1, sx+7, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+3, px+sx,	py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+4, px+sx+1, py-1, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+5, px+sx+2, py-1, 1, 1, pal );

	GF_BGL_ScrFill( ini, frm, cgx+6, px-9, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+7, px-8, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+8, px-1, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+9, px+sx, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+10, px+sx+1, py, 1, sy, pal );
	GF_BGL_ScrFill( ini, frm, cgx+11, px+sx+2, py, 1, sy, pal );

	GF_BGL_ScrFill( ini, frm, cgx+12, px-9, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+13, px-8, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+14, px-7, py+sy, sx+7, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+15, px+sx, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+16, px+sx+1, py+sy, 1, 1, pal );
	GF_BGL_ScrFill( ini, frm, cgx+17, px+sx+2, py+sy, 1, 1, pal );
}

void BmpBoardMapWrite( GF_BGL_BMPWIN * win, u16 cgx, u8 pal )
{
	u16	i, j;
	u16	px, py;
	u8	frm;
	
	frm = GF_BGL_BmpWinGet_Frame( win );
	px  = GF_BGL_BmpWinGet_PosX( win ) - 7;
	py  = GF_BGL_BmpWinGet_PosY( win );

	for( i=0; i<4; i++ ){
		for( j=0; j<6; j++ ){
			GF_BGL_ScrFill( win->ini, frm, cgx+i*6+j, px+j, py+i, 1, 1, pal );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ŔEBhE`
 *
 * @param	win			BMPEBhEf[^
 * @param	trans_sw	]XCb`
 * @param	win_cgx		EBhELʒu
 * @param	type		Ŕ^Cv
 * @param	pal			pbg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpBoardWinWrite( GF_BGL_BMPWIN * win, u8 trans_sw, u16 win_cgx, u8 pal, u8 type )
{
	u8	frm = GF_BGL_BmpWinGet_Frame( win );

	// A
	if( type == BOARD_TYPE_TOWN || type == BOARD_TYPE_ROAD ){
		BmpBoardWinWriteMain(
			win->ini, frm,
			GF_BGL_BmpWinGet_PosX( win ),
			GF_BGL_BmpWinGet_PosY( win ),
			GF_BGL_BmpWinGet_SizeX( win ),
			GF_BGL_BmpWinGet_SizeY( win ),
			pal, win_cgx );

		BmpBoardMapWrite( win, win_cgx+BOARD_WIN_CGX_SIZ, pal );
	// AȊO
	}else{
		// f[^\bEBhEƓȂ̂ŁAƂ肠AbEBhE`ŁB
		BmpTalkWinWriteMain(
			win->ini, frm,
			GF_BGL_BmpWinGet_PosX( win ),
			GF_BGL_BmpWinGet_PosY( win ),
			GF_BGL_BmpWinGet_SizeX( win ),
			GF_BGL_BmpWinGet_SizeY( win ),
			pal, win_cgx );
	}

	if( trans_sw == WINDOW_TRANS_ON ){
		GF_BGL_BmpWinOn( win );
	}

	CursorCgxMake( win, win_cgx, 1 );
}

//--------------------------------------------------------------------------------------------
/**
 *	ŔEBhENA
 *
 * @param	win			BMPEBhEf[^
 * @param	type		Ŕ^Cv
 * @param	trans_sw	]XCb`
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BmpBoardWinClear( GF_BGL_BMPWIN * win, u8 type, u8 trans_sw )
{
	u8	frm = GF_BGL_BmpWinGet_Frame( win );

	// A
	if( type == BOARD_TYPE_TOWN || type == BOARD_TYPE_ROAD ){
		GF_BGL_ScrFill(
			win->ini, frm, 0,
			GF_BGL_BmpWinGet_PosX( win ) - 9,
			GF_BGL_BmpWinGet_PosY( win ) - 1,
			GF_BGL_BmpWinGet_SizeX( win ) + 11,
			GF_BGL_BmpWinGet_SizeY( win ) + 2,
			0 );
	}else{
		GF_BGL_ScrFill(
			win->ini, frm, 0,
			GF_BGL_BmpWinGet_PosX( win ) - 2,
			GF_BGL_BmpWinGet_PosY( win ) - 1,
			GF_BGL_BmpWinGet_SizeX( win ) + 4,
			GF_BGL_BmpWinGet_SizeY( win ) + 2,
			0 );
	}

	if( trans_sw == WINDOW_TRANS_ON ){
		GF_BGL_BmpWinOff( win );
	}
}



//============================================================================================
//	ҋ@ACR
//============================================================================================
#define	TIMEWAIT_ICON_SIZE	( 0x20 * 4 * 8 )	// ҋ@ACR̃TCY
#define	TIMEWAIT_WAIT		( 16 )				// ҋ@ACR̃AjEFCg

typedef struct {
	GF_BGL_BMPWIN * win;			// \BMP
	u8	cgx[TIMEWAIT_ICON_SIZE];	// J[\L쐬̈
	u8	backup[0x20*4];				// LobNAbv̈
	u16	cgxpos;						// bEBhE̓]ʒu
	u8	cnt;						// JE^
	u8	pat:7;						// Ajԍ
	u8	seq:1;						// V[PX
}TIMEWAIT_ICON;

static void TimeWaitIconPut( TIMEWAIT_ICON * wk, u32 flg );
static void TimeWaitIconMain( TCB_PTR tcb, void * work );


//--------------------------------------------------------------------------------------------
/**
 * ҋ@ACR\^XNǉ
 *
 * @param	win		bEBhEBMP
 * @param	cgxpos	bEBhE̓]ʒu
 *
 * @return	ҋ@ACR̃[N
 */
//--------------------------------------------------------------------------------------------
void * TimeWaitIconAdd( GF_BGL_BMPWIN * win, u32 cgxpos )
{
	TIMEWAIT_ICON * wk;
	u32	heap;
	u8 * scrcgx;
	u8 * curcgx;
	u8 * back_win;
	void * arc;
	u8	frm;
	u8	i;

	heap   = GF_BGL_HeapIDGet( win->ini );
	frm    = GF_BGL_BmpWinGet_Frame( win );
	scrcgx = GF_BGL_CgxGet( frm );

//	wk = TCB_GetWork( PMDS_taskAdd(TimeWaitIconMain,sizeof(TIMEWAIT_ICON),0,heap) );
	wk = sys_AllocMemory( heap, sizeof(TIMEWAIT_ICON) );
	VIntrTCB_Add( TimeWaitIconMain, wk, 0 );

	// ]̈obNAbv
	memcpy( wk->backup, &scrcgx[(cgxpos+18)*0x20], 0x20*4 );
	// 쐬̈揉
	back_win = (u8 *)sys_AllocMemory( heap, 0x20*4 );
	memcpy( &back_win[0x20*0], &scrcgx[(cgxpos+10)*0x20], 0x20 );
	memcpy( &back_win[0x20*1], &scrcgx[(cgxpos+11)*0x20], 0x20 );
	memcpy( &back_win[0x20*2], &scrcgx[(cgxpos+10)*0x20], 0x20 );
	memcpy( &back_win[0x20*3], &scrcgx[(cgxpos+11)*0x20], 0x20 );
	for( i=0; i<8; i++ ){
		memcpy( &wk->cgx[0x20*4*i], back_win, 0x20*4 );
	}
	sys_FreeMemoryEz( back_win );

	{
		NNSG2dCharacterData * dat;
		arc = ArcUtil_CharDataGet( ARC_WINFRAME, NARC_winframe_win_cursol2_ncgr, 0, &dat, heap );
		curcgx = (u8 *)dat->pRawData;
	}

	GF_BmpPrintObj( curcgx, 0, 0, 16, 16*8, wk->cgx, 16, 16*8, 0, 0, 16, 16*8 );

	sys_FreeMemoryEz( arc );

	wk->win = win;
	wk->cgxpos = (u16)cgxpos;
	wk->cnt = 0;
	wk->pat = 0;
	wk->seq = 0;

	TimeWaitIconPut( wk, 1 );

	return wk;
}

//--------------------------------------------------------------------------------------------
/**
 * ҋ@ACR\
 *
 * @param	wk		ҋ@ACR̃[N
 * @param	cgxpos	bEBhE̓]ʒu
 *
 * @return	none
 *
 * @li	flg = 0 : ʏ
 * @li	flg = 1 : XN[]
 * @li	flg = 2 : I
 */
//--------------------------------------------------------------------------------------------
static void TimeWaitIconPut( TIMEWAIT_ICON * wk, u32 flg )
{
	u8	frm, px, py, sx;

	frm = GF_BGL_BmpWinGet_Frame( wk->win );
	px  = GF_BGL_BmpWinGet_PosX( wk->win );
	py  = GF_BGL_BmpWinGet_PosY( wk->win );
	sx  = GF_BGL_BmpWinGet_SizeX( wk->win );

	if( flg == 2 ){
		GF_BGL_LoadCharacter( wk->win->ini, frm, wk->backup, 0x20*4, wk->cgxpos+18 );
		GF_BGL_ScrFill(
			wk->win->ini, frm, wk->cgxpos+10, px+sx+1, py+2, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_ScrFill(
			wk->win->ini, frm, wk->cgxpos+11, px+sx+2, py+2, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_ScrFill(
			wk->win->ini, frm, wk->cgxpos+10, px+sx+1, py+3, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_ScrFill(
			wk->win->ini, frm, wk->cgxpos+11, px+sx+2, py+3, 1, 1, GF_BGL_SCRWRT_PALNL );
		GF_BGL_LoadScreenReq( wk->win->ini, frm );
		return;
	}

	GF_BGL_LoadCharacter(
		wk->win->ini, frm, &wk->cgx[0x20*4*wk->pat], 0x20*4, wk->cgxpos+18 );

	if( flg == 0 ){ return; }

	GF_BGL_ScrFill(
		wk->win->ini, frm, wk->cgxpos+18, px+sx+1, py+2, 1, 1, GF_BGL_SCRWRT_PALNL );
	GF_BGL_ScrFill(
		wk->win->ini, frm, wk->cgxpos+19, px+sx+2, py+2, 1, 1, GF_BGL_SCRWRT_PALNL );
	GF_BGL_ScrFill(
		wk->win->ini, frm, wk->cgxpos+20, px+sx+1, py+3, 1, 1, GF_BGL_SCRWRT_PALNL );
	GF_BGL_ScrFill(
		wk->win->ini, frm, wk->cgxpos+21, px+sx+2, py+3, 1, 1, GF_BGL_SCRWRT_PALNL );

	GF_BGL_LoadScreenReq( wk->win->ini, frm );
}

//--------------------------------------------------------------------------------------------
/**
 * ҋ@ACRC^XN
 *
 * @param	tcb
 * @param	work
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TimeWaitIconMain( TCB_PTR tcb, void * work )
{
	TIMEWAIT_ICON * wk = work;

	if( wk->seq == 1 ){
		TimeWaitIconPut( wk, 2 );
		sys_FreeMemoryEz( work );
		TCB_Delete( tcb );
		return;
	}

	wk->cnt++;
	if( wk->cnt == TIMEWAIT_WAIT ){
		wk->cnt = 0;
		wk->pat = ( wk->pat + 1 ) & 7;
		TimeWaitIconPut( wk, 0 );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ҋ@ACR\^XN폜NGXg
 *
 * @param	work	ҋ@ACR̃[N
 *
 * @return	none
 *
 *	work폜܂
 */
//--------------------------------------------------------------------------------------------
void TimeWaitIconDel( void * work )
{
	TIMEWAIT_ICON * wk = work;

	wk->seq = 1;
}
