//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		wipe.c
 *@brief	DPʐ؂ւVXe
 *@author	tomoya takahashi
 *@data		2005.08.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <string.h>
#include "system.h"
#include "tcb.h"
#include "assert.h"
#include "system/lib_pack.h"
#include "system/wipe_wnd.h"
#include "system/brightness.h"

#define	__WIPE_H_GLOBAL
#include "system/wipe.h"
#define __WIPE_DEF_H_GLOBAL
#define __WIPE_DEF_H_GLOBAL_VAL
#include "system/wipe_def.h"
#include "system/wipe_sub.h"

//-------------------------------------
//	
//	Vblankɓo^f[^
//	
//=====================================
typedef struct {
	WIPE_HBLANK* p_wipehb;
	void*	work;
	pHBFunc	func;
	int		disp;
} WIPE_V_HBLANK;

//-------------------------------------
//	
//	vblankɔjf[^
//	
//=====================================
typedef struct {
	WIPE_HBLANK* p_wipehb;
	int disp;
} WIPE_V_DELHBLANK;


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
// ʐ؂ւp^[萔
enum{
	WIPE_THE_SAME_TIME = 0,		// 
	WIPE_START_MAIN,			// CJn
	WIPE_START_SUB,				// TuJn
};



//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	ʐ؂ւp^[e[u
//	
//=====================================
typedef struct {
	// ʐ؂ւp^[tO
	int wipe_pattern;
	
	// CTũCv̑݁A񑶍݃tO
	BOOL wipe_exist_m;
	BOOL wipe_exist_s;
} WIPE_SYS_PATTERN_DATA;


//-------------------------------------
//	
//	tF[hVXef[^
//	
//=====================================
typedef struct _WIPE_SYS_DATA{
	// tF[hp^[f[^
	WIPE_SYS_PATTERN_DATA	wipe_pattern_data;

	// Cvf[^
	WIPE_SYS_WIPE_WORK	wipe_m;
	WIPE_SYS_WIPE_WORK	wipe_s;

	// HBlank[N
	WIPE_HBLANK			wipehb;

	// tcb
	TCB_PTR	tcb;

	// wndsys[N
	WNDP_SYS_PTR	wnd_sys;

	// ImtO
	BOOL* end_flg;
	
} WIPE_SYS_DATA;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

static void endWipe(WIPE_SYS_DATA* scchg);

static void scchg_HBlankWorkSet( WIPE_HBLANK* p_wipehb );
static void scchg_HBlankFunc(void * work);
static void scchg_v_HBlankInit(TCB_PTR tcb, void* work);
static void scchg_v_HBlankDelete(TCB_PTR tcb, void* work);
static void screenChangeTask(TCB_PTR tcb, void* work);
static BOOL screenChangeSub(WIPE_SYS_PATTERN_DATA* pattern, WIPE_SYS_WIPE_WORK* wipe_m, WIPE_SYS_WIPE_WORK* wipe_s);

static void wipeFuncPack(BOOL* exist, WIPE_SYS_WIPE_WORK* wipe);
static BOOL wipeFunc(WIPE_SYS_WIPE_WORK* wipe);

static void setScreenChangePattern(int no, WIPE_SYS_PATTERN_DATA* pattern);
static void setWipeWork(WIPE_SYS_WIPE_WORK* wipe_w, int wipe_no, int division, int piece_sync, int sequence, void* work, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb,  int heap, int color);
static void patternDataSet(WIPE_SYS_PATTERN_DATA* pattern_data, int pattern, BOOL exist_m, BOOL exist_s);

//-----------------------------------------------------------------------------
/**
 *					O[o錾錾
*/
//-----------------------------------------------------------------------------
const static pWIPEFunc WipeFunc[] = {
	WipeFunc00,
	WipeFunc01,
	WipeFunc02,
	WipeFunc03,
	WipeFunc04,
	WipeFunc05,
	WipeFunc06,
	WipeFunc07,
	WipeFunc08,
	WipeFunc09,
	WipeFunc10,
	WipeFunc11,
	WipeFunc12,
	WipeFunc13,
	WipeFunc14,
	WipeFunc15,
	WipeFunc16,
	WipeFunc17,
	WipeFunc18,
	WipeFunc19,
	WipeFunc20,
	WipeFunc21,
	WipeFunc22,
	WipeFunc23,
	WipeFunc24,
	WipeFunc25,
	WipeFunc26,
	WipeFunc27,

	WipeFunc30,
	WipeFunc31,
	
	WipeFunc38,
	WipeFunc39,
};


//----------------------------------------------------------------------------
/**
 *
 *@brief	ʐ؂ւCvJn
 *
 *@param	pattern		؂ւp^[ԍ
 *@param	wipe_m		Cv@@CʃCvԍ
 *@param	wipe_s		Cv@@TuʃCvԍ
 *@param	color		Cv̐F
 *@param	division	eCv̕
 *@param	piece_sync	eCv̏𕪊PЂ̃VN
 *@param	heap		gpq[v
 *@param	end_flg		ImtO
 *
 *@return	none
 *
 * end_flg	
 *	end_flg	TRUEɂȂ烏CvĂ܂B
 *
 */
//-----------------------------------------------------------------------------
void WIPE_Start(int pattern, int wipe_m, int wipe_s, short color, int division, int piece_sync, int heap, BOOL* end_flg)
{
	TCB_PTR	tcb;
	WIPE_SYS_DATA* scw;

	//"division Oł"
	GF_ASSERT(division);
	//"piece_sync Oł"
	GF_ASSERT(piece_sync);

	// ^XNo^
	tcb = PMDS_taskAdd(screenChangeTask, sizeof(WIPE_SYS_DATA), 5, heap);
	scw = TCB_GetWork(tcb);	// [N擾
	memset( scw, 0, sizeof(WIPE_SYS_DATA) );

	// ؂ւp^[f[^쐬
	setScreenChangePattern(pattern, &scw->wipe_pattern_data);
	
	scw->wnd_sys	= WNDP_V_Init( heap );	// EBhE[N쐬

	// HBlank[N̏ݒ
	scchg_HBlankWorkSet( &scw->wipehb );
	
	// Cv[N̍쐬
	setWipeWork(&scw->wipe_m, wipe_m, division, piece_sync, 0, NULL, WIPE_DISP_MAIN, scw->wnd_sys, &scw->wipehb, heap, color);
	setWipeWork(&scw->wipe_s, wipe_s, division, piece_sync, 0, NULL, WIPE_DISP_SUB, scw->wnd_sys, &scw->wipehb, heap, color);

	scw->tcb		= tcb;			// tcb_ptr
	scw->end_flg	= end_flg;		// ImtOݒ
	*end_flg = FALSE;				// FALSE

	// obNhbvcolor̎w
	GX_LoadBGPltt((void*)&color, 0, sizeof(short));
	GXS_LoadBGPltt((void*)&color, 0, sizeof(short));

	// tF[hC̎͏֐s
	// Pڂ̓͏ɂȂĂ
	// ŁAʂ̐ݒiEBhE}XNōAuCglX̏ݒȂj
	// ̂łŌĂ
	wipeFuncPack(&scw->wipe_pattern_data.wipe_exist_m, &scw->wipe_m);
	wipeFuncPack(&scw->wipe_pattern_data.wipe_exist_s, &scw->wipe_s);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	CvԂ
 *
 *	@param	disp	
 *	@param	heap	gpq[v
 *
 *	@return	none
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu
 *
 */
//-----------------------------------------------------------------------------
void WIPE_Reset( int disp )
{
	WIPE_ResetWndMask( disp );
	WIPE_ResetBrightness( disp );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhE}XNԂ
 *
 *	@param	disp	
 *
 *	@return
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu
 *
 * ̊֐
 *	 n[hEFAEBhEgpCv
 * @uCglXgpCvɈڍs鎞ɁA
 * @n[hEFAEBhE̐ݒׂɎgp܂B
 * 
 */
//-----------------------------------------------------------------------------
void WIPE_ResetWndMask( int disp )
{
	// EBhE}XN
	WNDP_SetVisibleWnd(GX_WNDMASK_NONE, disp);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	uCglXԂ
 *
 *	@param	disp	
 *
 *	@return	none
 *
 * disp
	WIPE_DISP_MAIN,		// C
	WIPE_DISP_SUB		// Tu
 *
 * ̊֐
 *	 uCglXgpCv
 * @n[hEFAEBhEgpCvɈڍs鎞ɁA
 * @uCglX̐ݒׂɎgp܂B
 */
//-----------------------------------------------------------------------------
void WIPE_ResetBrightness( int disp )
{
	// uCglX
	if( disp == WIPE_DISP_MAIN ){
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_MAIN_DISPLAY );
	}else{
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_SUB_DISPLAY );
	}
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	ʐ؂ւtF[hI
 *
 *@param	scchg	ʐ؂ւf[^
 *
 *@return	none
 *
 *
 * IɕKĂԕKv܂B
 *
 */
//-----------------------------------------------------------------------------
static void endWipe(WIPE_SYS_DATA* scchg)
{
	GF_ASSERT(scchg);
	GF_ASSERT(scchg->tcb);

	*scchg->end_flg = TRUE;		// ImtOݒ
	
	WNDP_V_Delete(scchg->wnd_sys);	// EBhE[Nj
	PMDS_taskDel(scchg->tcb);	//^XNI
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ʐ؂ւtF[hC^XN
 *
 *@param	tcb		^XN|C^
 *@param	work	[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void screenChangeTask(TCB_PTR tcb, void* work)
{
	WIPE_SYS_DATA* scw = (WIPE_SYS_DATA*)work;
	BOOL	ret;
	
	ret = screenChangeSub(&scw->wipe_pattern_data, &scw->wipe_m, &scw->wipe_s);
	if(ret == TRUE){
		// CvI
		endWipe( scw );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ʐ؂ւTu֐
 *
 *@param	pattern		؂ւp^[
 *@param	wipe_m		CvC
 *@param	wipe_s		CvTu
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL screenChangeSub(WIPE_SYS_PATTERN_DATA* pattern, WIPE_SYS_WIPE_WORK* wipe_m, WIPE_SYS_WIPE_WORK* wipe_s)
{	
	switch(pattern->wipe_pattern){
	case WIPE_THE_SAME_TIME:	// 
		wipeFuncPack(&pattern->wipe_exist_m, wipe_m);
		wipeFuncPack(&pattern->wipe_exist_s, wipe_s);
		break;	
		
	case WIPE_START_MAIN:		// C
		if(pattern->wipe_exist_m){
			wipeFuncPack(&pattern->wipe_exist_m, wipe_m);
		}else{
			wipeFuncPack(&pattern->wipe_exist_s, wipe_s);
		}
		break;	
	case WIPE_START_SUB:		// Tu
		if(pattern->wipe_exist_s){
			wipeFuncPack(&pattern->wipe_exist_s, wipe_s);
		}else{
			wipeFuncPack(&pattern->wipe_exist_m, wipe_m);
		}	
		break;	
	}
	
	// ̃Cv̑݃tOFALSEɂȂI
	if((pattern->wipe_exist_m == FALSE) &&
		(pattern->wipe_exist_s == FALSE)){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cv֐pbN֐
 *	
 *@param	exist	݃tOiWIPE_SYS_PATTERN_DATAj
 *@param	wipe	Cv[N
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void wipeFuncPack(BOOL* exist, WIPE_SYS_WIPE_WORK* wipe)
{
	int ret;
	
	if(*exist){
		ret = wipeFunc(wipe);	
		if(ret == TRUE){
			*exist = FALSE;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cv֐s
 *
 *@param	wipe	Cvf[^
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL wipeFunc(WIPE_SYS_WIPE_WORK* wipe)
{
	return WipeFunc[wipe->wipe_no](wipe);	
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ʕύXp^[f[^쐬
 *
 *@param	no			p^[io[
 *@param	pattern_m	C̃p^[f[^i[̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setScreenChangePattern(int no, WIPE_SYS_PATTERN_DATA* pattern)
{
	switch(no){
	case WIPE_PATTERN_WMS:
		patternDataSet(pattern, WIPE_THE_SAME_TIME, TRUE, TRUE);
		break;
		
	case WIPE_PATTERN_FMAS:
		patternDataSet(pattern, WIPE_START_MAIN, TRUE, TRUE);
		break;
		
	case WIPE_PATTERN_FSAM:
		patternDataSet(pattern, WIPE_START_SUB, TRUE, TRUE);
		break;
		
	case WIPE_PATTERN_M:
		patternDataSet(pattern, WIPE_START_MAIN, TRUE, FALSE);
		break;
		
	case WIPE_PATTERN_S:
		patternDataSet(pattern, WIPE_START_SUB, FALSE, TRUE);
		break;
	};
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	p^[f[^ݒ
 *
 *@param	pattern_data	p^[f[^ݒ
 *@param	pattern			p^[
 *@param	exist_m			CCv݃tO
 *@param	exist_s			TuCv݃tO
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void patternDataSet(WIPE_SYS_PATTERN_DATA* pattern_data, int pattern, BOOL exist_m, BOOL exist_s)
{
	pattern_data->wipe_pattern = pattern;
	pattern_data->wipe_exist_m = exist_m;
	pattern_data->wipe_exist_s = exist_s;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cv[Nf[^ݒ
 *
 *@param	wipe_w		ݒ
 *@param	wipe_no		Cvio[
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	sequence	V[PX
 *@param	work		[N̈
 *@param	disp		
 *@param	wnd_sys		EBhEVXe|C^
 *@param	heap		gpq[v
 *@param	color		F
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void setWipeWork(WIPE_SYS_WIPE_WORK* wipe_w, int wipe_no, int division, int piece_sync, int sequence, void* work, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb,  int heap, int color)
{
	wipe_w->wipe_no		= wipe_no;
	wipe_w->division	= division;
	wipe_w->piece_sync	= piece_sync;
	wipe_w->sequence	= sequence;
	wipe_w->wipe_work	= work;
	wipe_w->disp		= disp;
	wipe_w->wnd_sys		= wnd_sys;
	wipe_w->p_wipehb	= p_wipehb;
	wipe_w->heap		= heap;
	wipe_w->color		= color;
}




//----------------------------------------------------------------------------
//
//
//	GtFNgpHuN֐S
//
//
//============================================================================

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuN[N̏lݒ
 *
 *	@param	p_wipehb	CvHuN[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_HBlankWorkSet( WIPE_HBLANK* p_wipehb )
{
	int i;
	for( i=0; i<2; i++ ){
		p_wipehb->work[ i ] = NULL;
		p_wipehb->func[ i ] = defaultHFunc;
		p_wipehb->flg[ i ]	= 0;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HBlank֐
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_HBlankFunc(void * work)
{
	int i;		// [vp
	WIPE_HBLANK* p_wipehb = work;

	for(i=0;i<2;i++){
		p_wipehb->func[i](p_wipehb->work[i]);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuN֐ݒ
 *
 *@param	p_wipehb	CvVXeHuN[N\
 *@param	work		[N
 *@param	func		HuN֐
 *@param	disp		\ʁiCTuj
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_HBlankInit(WIPE_HBLANK* p_wipehb, void* work, pHBFunc func, int disp)
{
	u8	result=TRUE;
	GF_ASSERT((p_wipehb->flg[disp] == 0));
	
	if((p_wipehb->flg[0] == 0) &&
		(p_wipehb->flg[1] == 0)){
		result = sys_HBlankIntrSet(scchg_HBlankFunc, p_wipehb);		// ֐ݒ
	}
	GF_ASSERT(result == TRUE);

	p_wipehb->work[disp] = work;
	if(func){
		p_wipehb->func[disp] = func;
	}else{
		p_wipehb->func[disp] = defaultHFunc;
	}
	p_wipehb->flg[disp] = WIPE_HBLANK_DO;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNj
 *
 *@param	p_wipehb	CvHuN[N
 *@param	disp		\	CETu
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_HBlankDelete(WIPE_HBLANK* p_wipehb, int disp)
{
	p_wipehb->flg[disp] = WIPE_HBLANK_NONE;
	p_wipehb->work[disp] = NULL;
	p_wipehb->func[disp] = defaultHFunc;
	if((p_wipehb->flg[0] == 0) &&
		(p_wipehb->flg[1] == 0)){
		sys_HBlankIntrStop();		//HBlank荞ݒ~
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VuNԒHuN֐ݒ
 *
 *@param	work		[N
 *@param	func		HuN֐
 *@param	disp		\
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_V_HBlankInit(WIPE_HBLANK* p_wipehb, void* work, pHBFunc func, int disp, int heap)
{
	WIPE_V_HBLANK* data = sys_AllocMemoryLo(heap, sizeof(WIPE_V_HBLANK));
	
	data->p_wipehb = p_wipehb;
	data->work = work;
	data->func = func;
	data->disp = disp;
	VWaitTCB_Add( scchg_v_HBlankInit, data, 1);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNj
 *
 *@param	disp		\	CETu
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WIPE_V_HBlankDelete(WIPE_HBLANK* p_wipehb, int disp, int heap)
{
	WIPE_V_DELHBLANK* p_delhb = sys_AllocMemoryLo(heap, sizeof(WIPE_V_DELHBLANK));
	p_delhb->p_wipehb	= p_wipehb;
	p_delhb->disp		= disp;
	VWaitTCB_Add( scchg_v_HBlankDelete, p_delhb, 1);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VblankԒHblank^XN
 *
 *@param	tcb		^XN|C^
 *@param	work	f[^	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_v_HBlankInit(TCB_PTR tcb, void* work)
{
	WIPE_V_HBLANK*	data = (WIPE_V_HBLANK*)work;
	
	WIPE_HBlankInit(data->p_wipehb, data->work, data->func, data->disp);

	TCB_Delete( tcb );
	sys_FreeMemoryEz( work );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VblankԒHblankj֐
 *
 *@param	tcb		^XN|C^
 *@param	work	jf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_v_HBlankDelete(TCB_PTR tcb, void* work)
{
	WIPE_V_DELHBLANK* p_delhb = (WIPE_V_DELHBLANK*)work;
	
	WIPE_HBlankDelete(p_delhb->p_wipehb, p_delhb->disp);
	
	TCB_Delete( tcb );
	sys_FreeMemoryEz( work );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HuN֐	NULLnꂽݒ肳֐
 *
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void defaultHFunc( void* work )
{
}

