//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		wipe_sub.c
 *@brief	ʂ肩Cv
 *@author	tomoya takahashi
 *@data		2005.08.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "string.h"
#include "system/brightness.h"
#include "system/wipe_def.h"
#include "system/wipe.h"
#include "include/gflib/sdkdef.h"

#define __WIPE_SUB_H_GLOBAL
#include "system/wipe_sub.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	V[PX
//	
//=====================================
enum{
	WIPE_INIT,			// 쏉
	WIPE_MAIN,			// 
	WIPE_END,			// I
	WIPE_END_WAIT,		// I҂	IO1VuNʂ߁@}XN̐ݒύXvuNōsĂ
};

//-------------------------------------
//	
//	tF[hޗ	
//	
//=====================================
enum{
	WIPE_FADE_IN,
	WIPE_FADE_OUT
};

#define SUM_NUM_MINI	(128)
#define ROTA_NUM(x)		((0xffff*(x))/360)

// hAp
// ̒l,̊JĂlƊpxoĂ
#define	WIPE_DOOR_ROTA_NUM	(21)
//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	uCglXtF[h[N
//	
//=====================================
typedef struct {
	BOOL init_flag;
} WIPE_BRIGHTNESS_FADE;


//-------------------------------------
//	
//	EBhEWpbN
//	
//=====================================
typedef struct {
	int x1;
	int y1;
	int x2;
	int y2;
} WIPE_WND_POSITION;


//-------------------------------------
//	
//	EBhEό`\
//
//	Vb^[EC/AEg
//	XChEC/AEg
//	Vb^[EC/AEg
//	{bNXEC/AEg
//	p\̂łB
//	
//=====================================
typedef struct {
	WIPE_WND_POSITION st;	// JnW
	WIPE_WND_POSITION add;	// ZW
	WIPE_WND_POSITION ed;	// IW

	int disp;		// 
	int wnd_no;		// EBhEio[
	
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;
} WIPE_TYPE_WND_MOVE;

//-------------------------------------
//	
//	EBhEό`p
//	
//=====================================
typedef struct {
	WIPE_WND_POSITION st;	// JnW
	WIPE_WND_POSITION ed;	// IW

	int wnd_no;		// EBhEio[

	int in_wnd;		// EBhE̒
	int out_wnd;	// EBhE̊O

	int fade_flg;	// tF[htO

} WIPE_TYPE_WND_MOVE_FP;


//-------------------------------------
//	
//	EBhEό`\
//	EBhEQgƂ悤
//
//	XvbgEC/AEg
//	
//=====================================
typedef struct {
	WIPE_TYPE_WND_MOVE wnd0;
	WIPE_TYPE_WND_MOVE wnd1;
} WIPE_TYPE_WND_DMOVE;

//-------------------------------------
//	
//	HBlankwndf[^
//	\
//	
//=====================================
typedef struct {
	short	wnd_data[2][192];	// wndf[^
	short	wnd_tmp[2][192];		// C[vvZp
	
	int wnd_no;		// EBhEio[
	
} WIPE_TYPE_HB_WND_ONE;

//-------------------------------------
//	
//	Hblankwndf[^
//	˂\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND_ONE* data;
	int wnd_data_num;
	int disp;		// 
} WIPE_TYPE_HB_WND;


//-------------------------------------
//	
//	HBlankgp~wndŕ`VXe
//	\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND hb_circle;	// HblankCIRCLEf[^
	int	r;		// a
	int x;		// SW
	int y;
	int add_r;		// aωl
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int heap;		// gpq[v
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;	// EBhEݒf[^ۑ̈
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
} WIPE_TYPE_WND_CIRCLE;

//-------------------------------------
//	
//	HBlankgp~wndŕ`VXe
//	pbN֐̈
//	
//=====================================
typedef struct {
	int r;
	int e_r;
	int x;
	int y;
	int wnd_no;
	int in_wnd;
	int out_wnd;
	int fade_flg;
} WIPE_TYPE_WND_CIRCLE_FP;

//-------------------------------------
//	
//	HBlankgpJ[ewndŕ`VXe
//	\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND hb_c;	// Hblankf[^
	int rota;		// Jpx
	int rota_add;	// PŊJpx
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N

	int heap;		// gpq[v
} WIPE_TYPE_WND_CURTAIN;

//-------------------------------------
//	
//	HBlankgpJ[e\VXe
//	pbN֐̈
//	
//=====================================
typedef struct {
	int rota;
	int e_rota;
	int wnd_no;
	int in_wnd;
	int out_wnd;
	int fade_flg;
} WIPE_TYPE_WND_CURTAIN_FP;


//-------------------------------------
//	
//	HBlankgphAwndŕ`VXe
//	\
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND hb_d;	// Hblankf[^
	int open_max;	// ő̊J
	int open_r;		// J]l
	int open_r_a;	// l
	int a_count;	// ωiiKj
	int piece_sync;	// PЂ̃VN
	int sync_c;		// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
	int heap;		// gpq[v
} WIPE_TYPE_WND_DOOR;

//-------------------------------------
//	
//	HBlankgphA\VXe
//	pbN֐̈
//	
//=====================================
typedef struct {
	int s_d;
	int e_d;
	int wnd_no;
	int in_wnd;
	int out_wnd;
	int fade_flg;
} WIPE_TYPE_WND_DOOR_FP;

//-------------------------------------
//	
//	ꂽEBhE̊eX̐ݒ
//	
//=====================================
typedef struct {
	WIPE_WND_POSITION st;	// JnW
	WIPE_WND_POSITION add;	// ZW
	WIPE_WND_POSITION ed;	// IW
} WIPE_TYPE_WND_D_PIECE;

//-------------------------------------
//	
//	P̃EBhE𕡐̃EBhE
//	gpĂ邩̂悤Ɏgp
//	
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND		hb_divi;		// Hblankݒf[^
	
	WIPE_TYPE_WND_D_PIECE* piece_tbl;		// f[^
	int						piece_num;		// EBhE

	int a_count;		// ωiiKj
	int piece_sync;		// PЂ̃VN
	int sync_c;			// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;	// EBhEVblankύXVXẽ[N
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
	int heap;			// gpq[v
} WIPE_TYPE_WND_DIVI;

//-------------------------------------
//	
//	P̃EBhE𕡐̃EBhE
//	gpĂ邩̂悤Ɏgp	
//	p
//=====================================
typedef struct {
	const WIPE_WND_POSITION* p_st;	// eX̊JnW	D揇ʁiOj
	const WIPE_WND_POSITION* p_ed;	// eX̏IW
	int divi_num;				// 
	int wnd_no;
	int in_wnd;
	int out_wnd;
	int fade_flg;
} WIPE_TYPE_WND_DIVI_FP;


//-------------------------------------
//	
//	XN[P̃f[^
//	
//=====================================
typedef struct {
	int	rota;		// ݂̉]p
	int add_rota;	// ]x
	int in_out;		// px̓EBhẼCOEBhẼC
} WIPE_TYPE_WND_SCREW_ONE;


//-------------------------------------
//	
//	XN[f[^\
//
//=====================================
typedef struct {
	WIPE_TYPE_HB_WND		hb;		// Hblankݒf[^
	
	WIPE_TYPE_WND_SCREW_ONE* screw;	// XN[f[^
	int screw_num;						// XN[

	int a_count;		// ωiiKj
	int piece_sync;		// PЂ̃VN
	int sync_c;			// VNJEg
	int fade_flg;	// tF[htO

	WNDP_SYS_PTR wnd_sys;	// EBhEVblankύXVXẽ[N
	WIPE_HBLANK* p_wipehb;	// CvHBlank[N
} WIPE_TYPE_WND_SCREW;

//-------------------------------------
//	
//	XN[֐
//	
//=====================================
typedef struct {
	int*	s_rota;		// Jn]p
	int*	e_rota;		// I]p
	int*	in_out;		// px̓EBhẼCOEBhẼC
	int		tbl_num;	// e[u
	
	int in_wnd;
	int out_wnd;
	int fade_flg;
} WIPE_TYPE_WND_SCREW_FP;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
// evZp
static fx32 sum_tan(int rota);
static void sum_rota_height_width(int rota, int* depth, int work_num, int s_h);
static int sum_triangle_height(int rota, int undefground);
static int sum_add_num(int st, int ed, int divi);
static int sum_add_wnd_width(int num1, int num2);
static void sum_add_wnd(WIPE_WND_POSITION* num, WIPE_WND_POSITION* add);
static void sum_set_wnd_position(WIPE_WND_POSITION* st, WIPE_WND_POSITION* ed, WIPE_WND_POSITION* add, const WIPE_WND_POSITION* set_st, const WIPE_WND_POSITION* set_ed, int division );

// EBhEp
static void scchg_WndEnd(int flag, WNDP_SYS_PTR wnd_sys, int disp);
static void scchg_h_Wnd(void* work);
static void scchg_h_WndMake(WIPE_TYPE_HB_WND* data, int flag, int disp, int heap);
static void scchg_h_WndDel(WIPE_TYPE_HB_WND* data);
static void scchg_v_h_WndDel( TCB_PTR tcb, void* work );
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndNoDataGet(WIPE_TYPE_HB_WND* data, int wnd_no);
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndIdxDataGet(WIPE_TYPE_HB_WND* data, int idx);
static void scchg_WndSwap(TCB_PTR tcb, void* work);
static void scchg_WndSetUp(WNDP_SYS_PTR wnd_sys, int in_wnd, int out_wnd, int wnd_no, int disp, int x1, int y1, int x2, int y2, int fade_flg);
static void scchg_WndVisible(WNDP_SYS_PTR wnd_sys, int plane, int disp, int fade_flg);

// uCglXtF[hp
static BOOL scchg_FadePack(WIPE_SYS_WIPE_WORK* wipe, int fade_flag);

// lp\EBhEp
static void scchg_WndMovePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram );
static BOOL scchg_WndMovePack(WIPE_SYS_WIPE_WORK* wipe);

static void scchg_WndMoveDoublePackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram1, const WIPE_TYPE_WND_MOVE_FP* pram2);
static BOOL scchg_WndMoveDoublePack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndMoveInit(WIPE_TYPE_WND_MOVE* data, const WIPE_TYPE_WND_MOVE_FP* pram, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys);
static BOOL scchg_WndMoveMain(WIPE_TYPE_WND_MOVE* data);

// ~\EBhEp
static void scchg_WndCirclePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CIRCLE_FP* param );
static BOOL scchg_WndCirclePack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndCircleInit(WIPE_TYPE_WND_CIRCLE* data, const WIPE_TYPE_WND_CIRCLE_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap);
static BOOL scchg_WndCircleMain(WIPE_TYPE_WND_CIRCLE* data);
static void scchg_WndCircleSum(WIPE_TYPE_WND_CIRCLE* work);

// J[e^EBhE\p
static void scchg_WndCurtainPackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CURTAIN_FP* param);
static BOOL scchg_WndCurtainPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndCurtainInit(WIPE_TYPE_WND_CURTAIN* data, const WIPE_TYPE_WND_CURTAIN_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndCurtainMain(WIPE_TYPE_WND_CURTAIN* data);
static void scchg_WndCurtainSum(WIPE_TYPE_WND_CURTAIN* work);

// hA^EBhE\p

static void scchg_WndDoorPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DOOR_FP* param);
static BOOL scchg_WndDoorPack(WIPE_SYS_WIPE_WORK* wipe);
static void scchg_WndDoorInit(WIPE_TYPE_WND_DOOR* data, const WIPE_TYPE_WND_DOOR_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static BOOL scchg_WndDoorMain(WIPE_TYPE_WND_DOOR* data);
static void scchg_WndDoorSum(WIPE_TYPE_WND_DOOR* work);

// 1EBhEVXe
static void scchg_WndDivisionPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DIVI_FP* param);
static BOOL scchg_WndDivisionPack(WIPE_SYS_WIPE_WORK* wipe);
static BOOL scchg_WndDivisionMain(WIPE_TYPE_WND_DIVI* data);
static void scchg_WndDivisionInit(WIPE_TYPE_WND_DIVI* data, const WIPE_TYPE_WND_DIVI_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap );
static void scchg_WndDivisionEnd(WIPE_TYPE_WND_DIVI* data);
static void scchg_WndDivisionSum(WIPE_TYPE_WND_DIVI* work);
static void scchg_WndDivisionMainSub(WIPE_TYPE_WND_DIVI* data);
static void scchg_WndDivisionSumSub(WIPE_TYPE_HB_WND* hb_divi, WIPE_WND_POSITION* set);

// XN[
/*
static BOOL scchg_WndScrewPack(WIPE_SYS_WIPE_WORK* wipe, WIPE_TYPE_WND_SCREW_FP* param, int flag);
static void scchg_WndScrewInit(WIPE_TYPE_WND_DIVI* data, WIPE_TYPE_WND_SCREW_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys );
static BOOL scchg_WndScrewMain(WIPE_TYPE_WND_SCREW* data);
static void scchg_WndScrewEnd(WIPE_TYPE_WND_SCREW* data);
static void scchg_WndScrewSum(WIPE_TYPE_WND_SCREW* work);
//*/

//----------------------------------------------------------------------------
/**
 *
 *@brief	tF[hAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	BOOL	TRUEFI@FALSEFs
 *
 * tF[hAEg
 *	ʂXɈÂȂĂ
 *
 *	obNhbvʂƂ̃At@ufBO
 *	̏sB
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc00(WIPE_SYS_WIPE_WORK* wipe)
{
	return scchg_FadePack(wipe, WIPE_FADE_OUT);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tF[hC
 *
 *@param	wipe	Cvf[^
 *
 *@return	BOOL	TRUEFI@FALSEFs
 *
 *  tF[hC
 *		ʂXɖ邭ȂAʂ\
 *
 *	obNOEhƂ̃At@ufBO
 *	̏sB
 * 
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc01(WIPE_SYS_WIPE_WORK* wipe)
{
	return scchg_FadePack(wipe, WIPE_FADE_IN);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[AEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 *
 * ォ牺ւ̃Vb^[AEg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc02(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{0,191,255,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[C
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * ォ牺ւ̃Vb^[C
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc03(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,0},
			{0,0,255,192},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[AEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 *
 * ւ̃Vb^[AEg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc04(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{0,0,255,0},
			WNDP_WND_0,
			GX_BLEND_ALL, GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vb^[C
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * ւ̃Vb^[C
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc05(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,191,255,191},
			{0,0,255,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XChAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	noen
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc06(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{0,0,0,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}

	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XChC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc07(WIPE_SYS_WIPE_WORK* wipe)
{

	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,0,191},
			{0,0,255,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN	
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʏ㉺
 * 
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc08(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{0,96,255,96},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʒ
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc09(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,96,255,96},
			{0,0,255,191},
			WNDP_WND_1,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʒ
 * 
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc10(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param1 = {
			{0,0,255,96},
			{0,0,255,0},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		static const WIPE_TYPE_WND_MOVE_FP param2 = {
			{0,96,255,191},
			{0,191,255,191},
			WNDP_WND_1,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
	
		scchg_WndMoveDoublePackInit(wipe, &param1, &param2);
		return FALSE;
	}
	
	return scchg_WndMoveDoublePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * c@ʏ㉺
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc11(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param1 = {
			{0,0,255,0},
			{0,0,255,96},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		static const WIPE_TYPE_WND_MOVE_FP param2 = {
			{0,191,255,191},
			{0,96,255,191},
			WNDP_WND_1,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
	
		scchg_WndMoveDoublePackInit(wipe, &param1, &param2);
		return FALSE;
	}
	return scchg_WndMoveDoublePack(wipe);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʍE
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc12(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{128,0,128,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʒ
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc13(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{128,0,128,191},
			{0,0,255,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʒ
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc14(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param1 = {
			{0,0,128,191},
			{0,0,0,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		static const WIPE_TYPE_WND_MOVE_FP param2 = {
			{128,0,255,191},
			{255,0,255,191},
			WNDP_WND_1,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
	
		scchg_WndMoveDoublePackInit(wipe, &param1, &param2);
		return FALSE;
	}
	return scchg_WndMoveDoublePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XvbgEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 * @ʍE
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc15(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param1 = {
			{0,0,0,191},
			{0,0,128,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		static const WIPE_TYPE_WND_MOVE_FP param2 = {
			{255,0,255,191},
			{128,0,255,191},
			WNDP_WND_1,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
	
		scchg_WndMoveDoublePackInit(wipe, &param1, &param2);
		return FALSE;
	}
	return scchg_WndMoveDoublePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	z[EAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hAEg
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc16(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			256,0,
			128,96,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		scchg_WndCirclePackInit( wipe, &param );
		return FALSE;
	}
	
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	z[EC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hC
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc17(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			0,256,
			128,96,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		scchg_WndCirclePackInit( wipe, &param );
		return FALSE;
	}

	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hAEg
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc18(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			256,0,
			128,182,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		scchg_WndCirclePackInit( wipe, &param );
		return FALSE;
	}
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	glEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *	~`tF[hC
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc19(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CIRCLE_FP param = {
			0,256,
			128,182,
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		scchg_WndCirclePackInit( wipe, &param );
		return FALSE;
	}
	return scchg_WndCirclePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	J[eEAEg
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc20(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CURTAIN_FP param = {
			ROTA_NUM(90),
			0,
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};
		
		scchg_WndCurtainPackInit(wipe, &param);
		return FALSE;
	}

	return scchg_WndCurtainPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	J[eEC
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc21(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_TYPE_WND_CURTAIN_FP param = {
			0,
			ROTA_NUM(90),// tan90͒lsɂȂ̂ŁA90ɂĂ܂B
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};
		
		scchg_WndCurtainPackInit(wipe, &param );

		return FALSE;
	}
	return scchg_WndCurtainPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 * O璆
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc22(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{128,96,128,96},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 * O
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc23(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{128,96,128,96},
			{0,0,255,191},
			WNDP_WND_0,
			GX_BLEND_ALL,GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *	O
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc24(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{128,96,128,96},
			{0,0,255,191},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_OUT
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	{bNXC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 * O璆
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc25(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		
		static const WIPE_TYPE_WND_MOVE_FP param = {
			{0,0,255,191},
			{128,96,128,96},
			WNDP_WND_0,
			GX_BLEND_PLANEMASK_BD,GX_BLEND_ALL,
			WIPE_FADE_IN
		};

		scchg_WndMovePackInit(wipe, &param);
		return FALSE;
	}
	return scchg_WndMovePack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc26(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_DOOR_FP param = {
			ROTA_NUM(90),
			ROTA_NUM(0),
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_OUT
		};

		scchg_WndDoorPackInit(wipe, &param);
		return FALSE;
	}
		
	return scchg_WndDoorPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc27(WIPE_SYS_WIPE_WORK* wipe)
{
	if( wipe->sequence == WIPE_INIT ){
		static const WIPE_TYPE_WND_DOOR_FP param = {
			ROTA_NUM(0),
			ROTA_NUM(90),
			WNDP_WND_0,
			GX_BLEND_ALL,
			GX_BLEND_PLANEMASK_BD,
			WIPE_FADE_IN
		};

		scchg_WndDoorPackInit(wipe, &param);
		return FALSE;
	}

	return scchg_WndDoorPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I^l[gAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc30(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_WND_POSITION st[] = {
			{0,0,255,48},
			{0,47,255,96},
			{0,96,255,144},
			{0,144,255,191}
		};
		static const WIPE_WND_POSITION ed[] = {
			{0,0,0,48},
			{255,47,255,96},
			{0,96,0,144},
			{255,144,255,191}
		};
		WIPE_TYPE_WND_DIVI_FP param;
		
		param.p_st			= st;
		param.p_ed			= ed;
		param.divi_num		= 4;
		param.wnd_no		= WNDP_WND_0;
		param.in_wnd		= GX_BLEND_ALL;
		param.out_wnd		= GX_BLEND_PLANEMASK_BD;
		param.fade_flg		= WIPE_FADE_OUT;

		scchg_WndDivisionPackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndDivisionPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I^l[gEC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc31(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_WND_POSITION st[] = {
			{255,0,255,48},
			{0,47,0,96},
			{255,96,255,144},
			{0,144,0,191}
		};
		static const WIPE_WND_POSITION ed[] = {
			{0,0,255,48},
			{0,47,255,96},
			{0,96,255,144},
			{0,144,255,191}
		};
		WIPE_TYPE_WND_DIVI_FP param;
		
		param.p_st			= st;
		param.p_ed			= ed;
		param.divi_num		= 4;
		param.wnd_no		= WNDP_WND_0;
		param.in_wnd		= GX_BLEND_ALL;
		param.out_wnd		= GX_BLEND_PLANEMASK_BD;
		param.fade_flg		= WIPE_FADE_IN;

		scchg_WndDivisionPackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndDivisionPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	uChAEg
 *
 *@param	wipe	Cv[N
 *
 *@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc38(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_WND_POSITION st[] = {
			{0,0,255,64},
			{0,64,255,128},
			{0,128,255,191}
		};
		static const WIPE_WND_POSITION ed[] = {
			{0,64,255,64},
			{0,128,255,128},
			{0,191,255,191}
		};
		WIPE_TYPE_WND_DIVI_FP param;
		
		param.p_st			= st;
		param.p_ed			= ed;
		param.divi_num		= 3;
		param.wnd_no		= WNDP_WND_0;
		param.in_wnd		= GX_BLEND_ALL;
		param.out_wnd		= GX_BLEND_PLANEMASK_BD;
		param.fade_flg		= WIPE_FADE_OUT;

		scchg_WndDivisionPackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndDivisionPack(wipe);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	uChEC
 *
 *@param	wipe	Cv[N
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WipeFunc39(WIPE_SYS_WIPE_WORK* wipe)
{
	if(wipe->sequence == WIPE_INIT){
		static const WIPE_WND_POSITION st[] = {
			{0,64,255,64},
			{0,128,255,128},
			{0,191,255,191}
		};
		static const WIPE_WND_POSITION ed[] = {
			{0,0,255,64},
			{0,64,255,128},
			{0,128,255,191}
		};
		WIPE_TYPE_WND_DIVI_FP param;
		
		param.p_st			= st;
		param.p_ed			= ed;
		param.divi_num		= 3;
		param.wnd_no		= WNDP_WND_0;
		param.in_wnd		= GX_BLEND_ALL;
		param.out_wnd		= GX_BLEND_PLANEMASK_BD;
		param.fade_flg		= WIPE_FADE_IN;

		scchg_WndDivisionPackInit(wipe, &param);
		return FALSE;
	}
	
	return scchg_WndDivisionPack(wipe);
}
//-----------------------------------------------------------------------------
//
//	eCvŎgp֐S
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	^WFgvZ
 *
 *@param	rota		]p
 *
 *@return	fx32		tan(rota)̒l
 *
 *	^WFg͊pxXÔƂ́AslɂȂ̂ŒӂĂ
 *
 *
 */
//-----------------------------------------------------------------------------
static fx32 sum_tan(int rota)
{
	return FX_Div(FX_SinIdx(rota), FX_CosIdx(rota));
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	]pobt@ɂ̊pxŁÂƂ̕߂
 *
 *@param	rota		]p
 *@param	depth		i[[N
 *@param	work_num	[N̔zvf
 *@param	s_h			Jnn_ivf[vł܂킷j
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void sum_rota_height_width(int rota, int* depth, int work_num, int s_h)
{
	int i;
	fx32	tan;			// ^WFgvZp
	fx32	width, height;	// vZp
	int st,ed;

	// ^WFgvZ
	tan = sum_tan(rota);
	
	// eYWł̕
	for(i=s_h;i<work_num;i++){
		// ^WFggpÅpxŁA̎̕߂
		height = i<<FX32_SHIFT;
		width = FX_Mul(tan, height);
		width >>= FX32_SHIFT;
		*(depth+i) = width;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Op`̊pxƒӂ獂߂
 *
 *@param	rota			px
 *@param	underground		ӂ̒
 *
 *@return	int		
 *
 *
 */
//-----------------------------------------------------------------------------
static int sum_triangle_height(int rota, int underground)
{
	fx32 tan;
	fx32 ug;
	int h;

	tan = sum_tan(rota);
	ug = (underground/2) << FX32_SHIFT;
	h = FX_Div(ug ,tan);
	return h;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Pɑl߂
 *
 *@param	st		Jn_
 *@param	ed		I_
 *@param	divi	
 *
 *@return	int		"SUM_NUM_MINI{ɂꂽ1ɑl"
 *
 *
 */
//-----------------------------------------------------------------------------
static int sum_add_num(int st, int ed, int divi)
{
	int add;

	add = ed - st;
	add *= SUM_NUM_MINI;
	add /= divi;
	return add;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEW𕝂O`QTT𒴂Ȃ悤ɑ
 *
 *@param	num1		lP
 *@param	num2		lQ
 *
 *@return	int		l
 *
 *
 */
//-----------------------------------------------------------------------------
static int sum_add_wnd_width(int num1, int num2)
{
	int num;

	num = num1+num2;
	if(num < 0){
		num = 0;
	}
	if(num > 255){
		num = 255;
	}

	return num;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	|WVf[^𑫂
 *
 *@param	num		ޒlւ̃|C^	
 *@param	add		lւ̃|C^
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void sum_add_wnd(WIPE_WND_POSITION* num, WIPE_WND_POSITION* add)
{
	num->x1 += add->x1;
	num->y1 += add->y1;
	num->x2 += add->x2;
	num->y2 += add->y2;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	f[^ݒ肷
 *
 *@param	st			Jn
 *@param	ed			I
 *@param	add			l
 *@param	set_st		JnWݒf[^
 *@param	set_ed		IWݒf[^
 *@param	division	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void sum_set_wnd_position(WIPE_WND_POSITION* st, WIPE_WND_POSITION* ed, WIPE_WND_POSITION* add, const WIPE_WND_POSITION* set_st, const WIPE_WND_POSITION* set_ed, int division )
{
	// Wݒ
	st->x1 = set_st->x1*SUM_NUM_MINI;
	st->y1 = set_st->y1*SUM_NUM_MINI;
	st->x2 = set_st->x2*SUM_NUM_MINI;
	st->y2 = set_st->y2*SUM_NUM_MINI;

	*ed = *set_ed;

	// ړlvZ
	add->x1 = sum_add_num(set_st->x1, set_ed->x1, division);
	add->y1 = sum_add_num(set_st->y1, set_ed->y1, division);
	add->x2 = sum_add_num(set_st->x2, set_ed->x2, division);
	add->y2 = sum_add_num(set_st->y2, set_ed->y2, division);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tF[hpbN֐
 *
 *@param	wipe		Cv[N
 *@param	fade_flag	tF[hEC
						tF[hEAEg	tO
 *
 *@return	BOOL	IFTRUE	sFFALSE
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_FadePack(WIPE_SYS_WIPE_WORK* wipe, int fade_flag)
{
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	int sync;						// VN
	int lcd;						// \
	int start, end;					// JnAIuCglXl
	WIPE_BRIGHTNESS_FADE* ww = wipe->wipe_work;

	// uCglX
	if( wipe->disp == WIPE_DISP_MAIN ){
		lcd  = MASK_MAIN_DISPLAY;
	}else{
		lcd  = MASK_SUB_DISPLAY;
	}

	switch(wipe->sequence){
	case WIPE_INIT:
		wipe->wipe_work = sys_AllocMemory( wipe->heap, sizeof( WIPE_BRIGHTNESS_FADE ) );
		memset( wipe->wipe_work, 0, sizeof( WIPE_BRIGHTNESS_FADE ) );

		// uCglXݒ
		// JnuCglXl
		if( fade_flag == WIPE_FADE_IN ){
			if(wipe->color == WIPE_FADE_WHITE){
				start	= BRIGHTNESS_WHITE;
			}else{
				start	= BRIGHTNESS_BLACK;
			}
		}else{
			start	= BRIGHTNESS_NORMAL;
		}
		SetBrightness( start, PLANEMASK_ALL, lcd );
		wipe->sequence++;
		break;
		
	case WIPE_MAIN:
		// ς݃`FbN
		if( ww->init_flag == FALSE ){
			// VN
			sync = wipe->division * wipe->piece_sync;
			// JnuCglXl@IuCglXl
			if( fade_flag == WIPE_FADE_IN ){
				if(wipe->color == WIPE_FADE_WHITE){
					start	= BRIGHTNESS_WHITE;
				}else{
					start	= BRIGHTNESS_BLACK;
				}
				end		= BRIGHTNESS_NORMAL;
			}else{
				start	= BRIGHTNESS_NORMAL;
				if(wipe->color == WIPE_FADE_WHITE){
					end	= BRIGHTNESS_WHITE;
				}else{
					end	= BRIGHTNESS_BLACK;
				}
			}
			// tF[hJn
			ChangeBrightnessRequest( sync, end, start, PLANEMASK_ALL, lcd);

			// 
			ww->init_flag = TRUE;
		}else{

			// Im
			if( IsFinishedBrightnessChg( lcd ) ){
				wipe->sequence++;
			}
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz( wipe->wipe_work );
		wipe->wipe_work = NULL;
		ret_num = TRUE;
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhE`Hblank֐
 *
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_h_Wnd(void* work)
{
	WIPE_TYPE_HB_WND* shb = (WIPE_TYPE_HB_WND*)work;
	WIPE_TYPE_HB_WND_ONE* one;
	int v_c;
	int i;

	v_c = GX_GetVCount();

	if(v_c < 192){
		v_c = (v_c + 1)%192;	// ̍̃f[^ݒ
		
		// EBhE|WVݒ
		for(i=0; i< shb->wnd_data_num; i++){
			one = scchg_h_WndIdxDataGet(shb, i);	// CfbNX̃f[^擾
			WNDP_SetWndPosition(one->wnd_data[0][v_c], 0, one->wnd_data[1][v_c], 191, one->wnd_no, shb->disp);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNEBhEf[^쐬
 *
 *@param	data	f[^i[
 *@param	flag	EBhEf[^tO
 *@param	disp	\
 *@param	heap	gpq[v
 *
 *@return	noen
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_h_WndMake(WIPE_TYPE_HB_WND* data, int flag, int disp, int heap)
{
	switch(flag){
	case WNDP_WND_0:	// ǂ炩Е̂Ƃ
	case WNDP_WND_1:
		data->data = sys_AllocMemory(heap, sizeof(WIPE_TYPE_HB_WND_ONE));
		data->wnd_data_num	= 1;
		data->disp			= disp;
		data->data->wnd_no	= flag;		// flag = WNDio[
		break;
	case 2:
		{
			int i;
			data->data = sys_AllocMemory(heap, sizeof(WIPE_TYPE_HB_WND_ONE)*2);
			data->wnd_data_num	= 2;
			data->disp			= disp;
			for(i=0;i<2;i++){			// EBhEf[^ݒ
				data->data[i].wnd_no	= i;
			}
		}
		break;
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEf[^j
 *
 *@param	data	jEBhEf[^
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_h_WndDel(WIPE_TYPE_HB_WND* data)
{
	VWaitTCB_Add( scchg_v_h_WndDel, data, 1 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ۂVuNɃ[Nj֐
 *
 *	@param	tcb		^XN[N
 *	@param	work	f[^
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_v_h_WndDel( TCB_PTR tcb, void* work )
{
	WIPE_TYPE_HB_WND* data = work;

	sys_FreeMemoryEz(data->data);	
	data->data = NULL;

	TCB_Delete(tcb);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEio[̃EBhEf[^擾
 *
 *@param	wnd_no	擾EBhEio[	
 *
 *@return	EBhEf[^	ƂNULL
 *
 *
 */
//-----------------------------------------------------------------------------
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndNoDataGet(WIPE_TYPE_HB_WND* data, int wnd_no)
{
	int i;

	for(i=0;i<data->wnd_data_num;i++){
		if(data->data[i].wnd_no == wnd_no){
			return (data->data + i);
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CfbNX̃EBhEf[^擾
 *
 *@param	data	擾
 *@param	idx		CfbNX
 *
 *@return	EBhEf[^	ƂNULL
 *
 *
 */
//-----------------------------------------------------------------------------
static WIPE_TYPE_HB_WND_ONE* scchg_h_WndIdxDataGet(WIPE_TYPE_HB_WND* data, int idx)
{
	GF_ASSERT(data->wnd_data_num > idx);

	return (data->data + idx);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C[vŌvZEBhĚ`̃obt@
 *			fe[uɑ
 *
 *@param	tcb		^XN|C^
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndSwap(TCB_PTR tcb, void* work)
{
	WIPE_TYPE_HB_WND*	swc = (WIPE_TYPE_HB_WND*)work;
	WIPE_TYPE_HB_WND_ONE* one;
	int i;

	for(i=0;i<swc->wnd_data_num;i++){
		one = scchg_h_WndIdxDataGet(swc, i);		// CfbNX̃f[^擾
		memcpy(one->wnd_data, one->wnd_tmp, 768);	// sizeof(short)*2*192
	}
	TCB_Delete( tcb );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhĚ㏈
 *
 *@param	flag		WIPE_FADE_IN:tF[hC	WIPE_FADE_OUT:tF[hAEg
 *@param	wnd_sys		EBhEVblank[N
 *@param	disp		\
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndEnd(int flag, WNDP_SYS_PTR wnd_sys, int disp)
{
	if(flag == WIPE_FADE_IN){
		// tF[hECIgpEBhE̕\It
		WNDP_V_SetVisibleWnd(wnd_sys, GX_WNDMASK_NONE, disp);

	}else{

		// EBhE0ʂςɍL
		WNDP_V_SetVisibleWnd(wnd_sys, GX_WNDMASK_W0, disp);
		WNDP_V_SetWndInsidePlane(wnd_sys, GX_BLEND_ALL, FALSE, 0, disp);
		WNDP_V_SetWndPosition(wnd_sys, 0,0,0,0,0, disp);	
		WNDP_V_SetWndOutsidePlane(wnd_sys, GX_BLEND_PLANEMASK_BD, FALSE, disp);	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEgpłԂɂ
 *
 *@param	wnd_sys		EBhEVblankݒVXep[N
 *@param	in_wnd		EBhEݒ
 *@param	out_wnd		EBhEOݒ
 *@param	wnd_no		EBhEio[
 *@param	disp		EBhE\
 *@param	x1			EBhEW
 *@param	y1
 *@param	x2
 *@param	y2
 *@param	fade_flg	tF[htO
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndSetUp(WNDP_SYS_PTR wnd_sys, int in_wnd, int out_wnd, int wnd_no, int disp, int x1, int y1, int x2, int y2, int fade_flg)
{
	// EBhE̓Oݒ
	if( fade_flg == WIPE_FADE_IN ){
		// tF[hC
		WNDP_SetWndInsidePlane(in_wnd, FALSE, wnd_no, disp);
		WNDP_SetWndOutsidePlane(out_wnd, FALSE, disp);
		WNDP_SetWndPosition(x1,y1,x2,y2, wnd_no, disp);
	}else{
		// tF[hAEg
		WNDP_V_SetWndInsidePlane(wnd_sys, in_wnd, FALSE, wnd_no, disp);
		WNDP_V_SetWndOutsidePlane(wnd_sys, out_wnd, FALSE, disp);
		WNDP_V_SetWndPosition(wnd_sys, x1,y1,x2,y2, wnd_no, disp);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		EBhE\\ݒ
 *
 *	@param	wnd_sys		EBhEVXe
 *	@param	plane		\EBhE
 *	@param	disp		\
 *	@param	fade_flg	tF[hCEAEgtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndVisible(WNDP_SYS_PTR wnd_sys, int plane, int disp, int fade_flg)
{
	if(fade_flg == WIPE_FADE_IN){

		WNDP_SetVisibleWnd( plane, disp );
	}else{

		WNDP_V_SetVisibleWnd(wnd_sys, plane, disp);
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhEpbN֐
 *
 *	@param	wipe	Cvf[^
 *	@param	param	EBhEf[^
 *
 * @return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndMovePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram )
{
	WIPE_TYPE_WND_MOVE* wwm;

	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_MOVE));
	
	wwm = (WIPE_TYPE_WND_MOVE*)wipe->wipe_work;
	
	scchg_WndMoveInit(wwm, pram, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys);
	
	// EBhEI
	if(pram->wnd_no == 0){
		scchg_WndVisible(wipe->wnd_sys, GX_WNDMASK_W0, wwm->disp, wwm->fade_flg);
	}else{
		scchg_WndVisible(wipe->wnd_sys,GX_WNDMASK_W1, wwm->disp, wwm->fade_flg);
	}
	
	wipe->sequence++;		// C
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEpbN
 *
 *@param	wipe	Cvf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndMovePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_MOVE* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_MOVE*)wipe->wipe_work;
	
	switch(wipe->sequence){
	case WIPE_MAIN:
		ret = scchg_WndMoveMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wipe->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		break;

	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Q̃EBhE𓯎ɓ֐̏
 *
 *@param	wipe		Cv\
 *@param	pram1		EBhEÖf[^
 *@param	pram2		EBhEP̈f[^
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndMoveDoublePackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_MOVE_FP* pram1, const WIPE_TYPE_WND_MOVE_FP* pram2)
{
	WIPE_TYPE_WND_DMOVE* wwm;

	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_DMOVE));
	wwm = (WIPE_TYPE_WND_DMOVE*)wipe->wipe_work;
	scchg_WndMoveInit(&wwm->wnd0, pram1, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys);
	scchg_WndMoveInit(&wwm->wnd1, pram2, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys);
	scchg_WndVisible(wipe->wnd_sys,GX_WNDMASK_W0|GX_WNDMASK_W1, wipe->disp, wwm->wnd0.fade_flg);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Q̃EBhE𓯎ɓ֐̏
 *
 *@param	wipe		Cv\
 *	
 *@retval	TRUE		I
 *@retval	FALSE		s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndMoveDoublePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_DMOVE* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_DMOVE*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndMoveMain(&wwm->wnd0);
		ret += scchg_WndMoveMain(&wwm->wnd1);
		if(ret == 2){
			scchg_WndEnd(wwm->wnd0.fade_flg, wipe->wnd_sys, wipe->disp);
//			scchg_WndEnd(wwm->wnd1.fade_flg, wipe->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEό`̏
 *
 *@param	data		f[^i[
 *@param	param		EBhEό`f[^
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	disp		\
 *@param	wnd_sys		EBhEVXe|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndMoveInit(WIPE_TYPE_WND_MOVE* data, const WIPE_TYPE_WND_MOVE_FP* pram, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys)
{
	// Wݒ
	sum_set_wnd_position(&data->st, &data->ed, &data->add, &pram->st, &pram->ed, division);

	// f[^ݒ
	data->disp			= disp;
	data->wnd_no		= pram->wnd_no;
	data->a_count		= division;
	data->piece_sync	= piece_sync;
	data->sync_c		= 0;
	data->wnd_sys		= wnd_sys;
	data->fade_flg		= pram->fade_flg;

	// EBhE̓Oݒ
	scchg_WndSetUp(wnd_sys, pram->in_wnd, pram->out_wnd, pram->wnd_no, disp,
			data->st.x1/SUM_NUM_MINI,data->st.y1/SUM_NUM_MINI,
			data->st.x2/SUM_NUM_MINI,data->st.y2/SUM_NUM_MINI,
			data->fade_flg);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhĚ`ό`
 *
 *@param	data	EBhEό`f[^
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndMoveMain(WIPE_TYPE_WND_MOVE* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
	
			// Z
			sum_add_wnd(&data->st, &data->add);
		}else{
			WNDP_V_SetWndPosition(data->wnd_sys, data->ed.x1,data->ed.y1,data->ed.x2,data->ed.y2, data->wnd_no, data->disp);

			return TRUE;
		}

		WNDP_V_SetWndPosition(data->wnd_sys, data->st.x1/SUM_NUM_MINI,data->st.y1/SUM_NUM_MINI,data->st.x2/SUM_NUM_MINI,data->st.y2/SUM_NUM_MINI, data->wnd_no, data->disp);//*/
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhEŉ~`VXe
 *
 *	@param	wipe	Cv[N
 *	@param	param	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCirclePackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CIRCLE_FP* param )
{
	WIPE_TYPE_WND_CIRCLE* wwm;
	
	// CvJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_CIRCLE));
	wwm = (WIPE_TYPE_WND_CIRCLE*)wipe->wipe_work;
	scchg_WndCircleInit(wwm, param, wipe->division, wipe->piece_sync, wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap);

	// C
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEŉ~`VXe
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL		TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCirclePack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_CIRCLE* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_CIRCLE*)wipe->wipe_work;
	
	switch(wipe->sequence){
	case WIPE_MAIN:
		ret = scchg_WndCircleMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
		
	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	~`VXe
 *
 *@param	data			f[^i[
 *@param	param			Cvf[^
 *@param	division		
 *@param	piece_sync		PЂ̃VN
 *@param	disp			\
 *@param	wnd_sys			EBhEVXe|C^
 *@param	heap			gpq[vID
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCircleInit(WIPE_TYPE_WND_CIRCLE* data, const WIPE_TYPE_WND_CIRCLE_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap)
{
	int add_r;
	WIPE_TYPE_HB_WND_ONE* one;

	// ωl߂
	add_r = sum_add_num(param->r, param->e_r, division);

	// f[^ݒ
	scchg_h_WndMake(&data->hb_circle, param->wnd_no, disp, heap);
	data->r					= param->r*SUM_NUM_MINI;
	data->x					= param->x;
	data->y					= param->y;
	data->add_r				= add_r;
	data->a_count			= division;
	data->piece_sync		= piece_sync;
	data->sync_c			= 0;
	data->wnd_sys			= wnd_sys;
	data->p_wipehb			= p_wipehb;
	data->heap				= heap;
	data->fade_flg			= param->fade_flg;
	
	scchg_WndCircleSum(data);	// 1vZ
	VWaitTCB_Add(scchg_WndSwap,&data->hb_circle, 1 );

	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_circle, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, param->wnd_no, disp,
			one->wnd_tmp[0][0], 0, one->wnd_tmp[1][0], 191,
			data->fade_flg);

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible( wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg );
	}else{
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W1, disp, data->fade_flg);
	}
	
	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_circle, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	~`惁C
 *
 *@param	data	EBhEό`f[^
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCircleMain(WIPE_TYPE_WND_CIRCLE* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
			data->r += data->add_r;	
			scchg_WndCircleSum(data);
			VWaitTCB_Add(scchg_WndSwap,&data->hb_circle, 1 );
		}else{

			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_circle.disp, data->heap);
			scchg_h_WndDel(&data->hb_circle);	// EBhEݒf[^j
			return TRUE;
		}
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	~f[^vZTu֐
 *
 *@param	c_r		aiSUM_NUM_MINIłlj
 *@param	c_x		SW
 *@param	c_y		SW
 *@param	n_h		̍
 *@param	st		EBhE̊Jn_
 *@param	ed		EBhȄI_
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCircleSumSub(int c_r, int c_x, int c_y, int n_h, int* st, int* ed)
{
	fx32 r;			// a
	fx32 height;	// 
	fx32 width;		// 

	// R̒藝ō̍~̕߂
	
	r = c_r / SUM_NUM_MINI;

	height = n_h - c_y;
	if(height < 0){
		height = -height;
	}
	
	if(height >= r){
		*st = 0;
		*ed = 0;
	}else{
		// a畝߂
		height <<= FX32_SHIFT;
		r <<= FX32_SHIFT;
		width = FX_Sqrt(FX_Mul(r,r) - FX_Mul(height,height));
		width >>= FX32_SHIFT;

		// EBhE̊Jn_ݒ
		*st = c_x - width;
		if(*st < 0){
			*st = 0;
		}
		*ed = *st + (width*2);
		if(*ed > 255){
			*ed = 255;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	~f[^̌vZs
 *
 *@param	work		~`VXẽf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCircleSum(WIPE_TYPE_WND_CIRCLE* work)
{
	WIPE_TYPE_HB_WND* shb = &work->hb_circle;
	int i;			// [vp
	int st;			// EBhEJn_
	int ed;			// EBhEI_
	int roop_end;
	WIPE_TYPE_HB_WND_ONE* one;

	// CfbNXÕEBhEf[^擾
	one = scchg_h_WndIdxDataGet(shb, 0);

	// aʓɂƂ
	// S܂ŕ߂牺̓Rs[悤ɂ
	for(i=0;i < 192;i++){
		if(i <= work->y){		// a܂ł͕ʂ̋߂
			scchg_WndCircleSumSub(work->r, work->x, work->y, i, &st, &ed);
		}else{
			if(i <= (work->y*2)){		// a甼âQ{܂ł,Rs[
				st = one->wnd_tmp[0][(work->y*2)-i];
				ed = one->wnd_tmp[1][(work->y*2)-i];
			}else{				// ͕̑ʂɋ߂
				scchg_WndCircleSumSub(work->r, work->x, work->y, i, &st, &ed);
			}
		}
		
		one->wnd_tmp[0][i] = st;
		one->wnd_tmp[1][i] = ed;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[ê悤ɕ\鏉֐
 *
 *@param	wipe		Cv[N
 *@param	param		֐
 *
 *	rota		Jnpx		px͂O`WXł肢܂
 *	e_rota		Ipx		܂WAlłKv܂B
 *	wnd_no		EBhEio[
 *	in_wnd		EBhE̖
 *	out_wnd		EBhEO̖
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCurtainPackInit( WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_CURTAIN_FP* param)
{
	WIPE_TYPE_WND_CURTAIN* wwm;

	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_CURTAIN));
	wwm = (WIPE_TYPE_WND_CURTAIN*)wipe->wipe_work;
	scchg_WndCurtainInit(wwm, param,wipe->division, wipe->piece_sync,  wipe->disp,  wipe->wnd_sys, wipe->p_wipehb, wipe->heap);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[ê悤ɕ\
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL	TRUEFI	FALSEFs
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCurtainPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_CURTAIN* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_CURTAIN*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndCurtainMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEł̃J[e`Jn
 *
 *@param	data		J[e`f[^
 *@param	param		J[ef[^
 *@param	division	̕
 *@param	piece_sync	PЂ̃VN
 *@param	disp		EBhE\
 *@param	wnd_sys		EBhEVblankVXẽ[N
 *@param	p_wipehb	CvHuN[N
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCurtainInit(WIPE_TYPE_WND_CURTAIN* data, const WIPE_TYPE_WND_CURTAIN_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	WIPE_TYPE_HB_WND_ONE* one;
	
	data->rota_add = sum_add_num(param->rota, param->e_rota, division);

	// f[^ݒ
	scchg_h_WndMake(&data->hb_c, param->wnd_no, disp, heap);
	data->rota		= param->rota*SUM_NUM_MINI;
	data->a_count	= division;
	data->piece_sync = piece_sync;
	data->sync_c	= 0;
	data->wnd_sys	= wnd_sys;	
	data->p_wipehb	= p_wipehb;
	data->heap		= heap;
	data->fade_flg	= param->fade_flg;
	
	scchg_WndCurtainSum(data);	// 1vZ
	VWaitTCB_Add(scchg_WndSwap,&data->hb_c, 1 );

	// EBhE\ݒ
	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_c, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd,
			param->wnd_no, disp, one->wnd_tmp[0][0], 0, one->wnd_tmp[1][0], 191,
			data->fade_flg);

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg);
	}else{
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W1, disp, data->fade_flg);
	}
	

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_c, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[e\̃C
 *
 *@param	data	EBhEf[^
 *	
 *@return	BOOL	TRUEFI	FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndCurtainMain(WIPE_TYPE_WND_CURTAIN* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
			data->rota += data->rota_add;
			scchg_WndCurtainSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap,&data->hb_c, 1 );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_c.disp, data->heap);
			scchg_h_WndDel(&data->hb_c);
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEJ[ê悤ɕ\f[^vZ
 *
 *@param	work		EBhEf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndCurtainSum(WIPE_TYPE_WND_CURTAIN* work)
{
	int i;
	int st, ed;
	int width[192];
	WIPE_TYPE_HB_WND_ONE* one;

	// CfbNXÕEBhEf[^擾
	one = scchg_h_WndIdxDataGet(&work->hb_c, 0);

	// pxeł̕߂
	sum_rota_height_width(work->rota/SUM_NUM_MINI, width, 192, 0);

	// eYWł̕
	for(i=0;i<192;i++){
		one->wnd_tmp[0][i] = sum_add_wnd_width(128, -width[i]);
		one->wnd_tmp[1][i] = sum_add_wnd_width(128, width[i]);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAtF[hpbN֐	֐
 *
 *@param	wipe		Cv[N
 *@param	param		hAf[^
 *	s_d			JnJpx	iROTA_NUM(0)`ROTA_NUM(90)j
 *	e_d			IJpx	iROTA_NUM(0)`ROTA_NUM(90)j
 *	wnd_no		gpEBhEio[
 *	in_wnd		EBhEʐݒ
 *	out_wnd		EBhEOʐݒ
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDoorPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DOOR_FP* param)
{
	WIPE_TYPE_WND_DOOR* wwm;
	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_DOOR));
	wwm = (WIPE_TYPE_WND_DOOR*)wipe->wipe_work;
	scchg_WndDoorInit(wwm, param, wipe->division, wipe->piece_sync,  wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAtF[hpbN֐
 *
 *@param	wipe		Cv[N
 *
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDoorPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_DOOR* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_DOOR*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndDoorMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEŃhAtF[h
 *
 *@param	data		f[^i[
 *@param	param		hAf[^
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	disp		EBhE\
 *@param	wnd_no		gpEBhEio[
 *@param	wnd_sys		EBhEVblankݒ胏[N
 *@param	wipe_hb		CvHuN[N
 *@param	heap		gpq[v
 *	
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDoorInit(WIPE_TYPE_WND_DOOR* data, const WIPE_TYPE_WND_DOOR_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	int add_num;
	WIPE_TYPE_HB_WND_ONE* one;

	// PŊJhA̋vZ
	add_num	= (param->e_d - param->s_d);
	add_num	/= division;

	// f[^ݒ
	scchg_h_WndMake(&data->hb_d, param->wnd_no, disp, heap);
	data->open_max		= 128*FX32_ONE;	// ̔̒lōl
	data->open_r		= param->s_d;
	data->open_r_a		= add_num;
	data->a_count	= division;
	data->piece_sync= piece_sync;
	data->sync_c	= 0;
	data->wnd_sys	= wnd_sys;
	data->p_wipehb	= p_wipehb;
	data->heap		= heap;
	data->fade_flg	= param->fade_flg;

	// hAvZ
	scchg_WndDoorSum(data);
	VWaitTCB_Add(scchg_WndSwap,&data->hb_d, 1 );
	
	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_d, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, 
			param->wnd_no, disp,
			one->wnd_tmp[0][96], 0, one->wnd_tmp[1][96], 191,
			data->fade_flg);	// XUɂׂ

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg);
	}else{
		scchg_WndVisible(wnd_sys, GX_WNDMASK_W1, disp, data->fade_flg);
	}

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_d, scchg_h_Wnd, disp, heap);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hAtF[hC
 *
 *@param	data		hAf[^
 *
 *@return	BOOL		TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDoorMain(WIPE_TYPE_WND_DOOR* data)
{
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;
			data->open_r += data->open_r_a;
			scchg_WndDoorSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap, &data->hb_d, 1 );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_d.disp, data->heap);
			scchg_h_WndDel(&data->hb_d);
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	hA^̃EBhEvZ
 *
 *@param	work		hAf[^
 *
 *@return	noen
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDoorSum(WIPE_TYPE_WND_DOOR* work)
{
	int i;
	int tri_h;		// s\̂QӎOp`̍
	int rota;		// s\̂QӎOp`̒_̊px
	int tri_data[192];	// s\̂QӎOp`̌`f[^
	int tri_n;		// tri_datae[u̗vf
	int h_open;		// ̊JĂl̔
	int set_w;		// EBhEɐݒ肷镝
	int st, ed;		// Jn_AI_
	WIPE_TYPE_HB_WND_ONE* one;	// EBhEݒf[^

	// CfbNXÕEBhE擾
	one = scchg_h_WndIdxDataGet(&work->hb_d, 0);

	// ̊Jl߂
	h_open = FX_Mul(FX_SinIdx(work->open_r), work->open_max);
	h_open >>= FX32_SHIFT;
	
	rota = h_open*2;						// ̊Jl߂
	rota = rota / WIPE_DOOR_ROTA_NUM;		// QӎOp`̍ēx̊px߂
	rota += 1;								// 90x
	rota = 180 - (rota*2);					// Op`̒_̊px߂
	rota = ROTA_NUM(rota);					// FX̌vZŎgppx̒Pʂɂ
	rota /= 2;								// ߂邽ߔ̊pxɂ
	tri_h = sum_triangle_height(rota, 256);	// Op`̍擾
	tri_h >>= FX32_SHIFT;					// fx32int
	GF_ASSERT(tri_h < 192);

	sum_rota_height_width(rota, tri_data, tri_h, 0);	// Op`̌`f[^߂
	
	// hA^̃EBhEf[^쐬
	for(i=0;i<96;i++){

		// EBhEɐݒ肷镝߂
		tri_n = tri_h - (i+1);
		set_w = h_open;
		if(tri_n > 0){
			if(tri_data[tri_n] > set_w){
				set_w = tri_data[tri_n];
			}
		}

		// Jn_I_߂
		st = sum_add_wnd_width(128, -set_w);
		ed = sum_add_wnd_width(128, set_w);

		// EBhEɐݒ肷
		one->wnd_tmp[0][i] = st;
		one->wnd_tmp[1][i] = ed;
		one->wnd_tmp[0][191 - i] = st;
		one->wnd_tmp[1][191 - i] = ed;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	PEBhEtF[hpbN
 *
 *	@param	wipe		Cv[N
 *	@param	param		tF[hf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionPackInit(WIPE_SYS_WIPE_WORK* wipe, const WIPE_TYPE_WND_DIVI_FP* param)
{
	WIPE_TYPE_WND_DIVI* wwm;
	// tF[hJn
	wipe->wipe_work = sys_AllocMemory(wipe->heap, sizeof(WIPE_TYPE_WND_DIVI));
	wwm = (WIPE_TYPE_WND_DIVI*)wipe->wipe_work;
	scchg_WndDivisionInit(wwm, param, wipe->division, wipe->piece_sync,  wipe->disp, wipe->wnd_sys, wipe->p_wipehb, wipe->heap);
	wipe->sequence++;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	PEBhEtF[hpbN
 *
 *@param	wipe		Cv[N
 *	
 *@return	BOOL	TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDivisionPack(WIPE_SYS_WIPE_WORK* wipe)
{
	WIPE_TYPE_WND_DIVI* wwm;
	BOOL	ret;
	BOOL	ret_num = FALSE;		// ̊֐̖߂l
	
	wwm = (WIPE_TYPE_WND_DIVI*)wipe->wipe_work;
	
	switch(wipe->sequence){
		
	case WIPE_MAIN:
		ret = scchg_WndDivisionMain(wwm);
		if(ret == TRUE){
			scchg_WndEnd(wwm->fade_flg, wwm->wnd_sys, wipe->disp);
			wipe->sequence++;
		}
		break;

	case WIPE_END:
		scchg_WndDivisionEnd(wwm);	// EBhEf[^j
		
		sys_FreeMemoryEz(wipe->wipe_work);
		wipe->wipe_work = NULL;
		wipe->sequence++;
		break;
	case WIPE_END_WAIT:
		ret_num = TRUE;
		break;

	default:
		GF_ASSERT(0);
		break;
	}
	
	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	PEBhEtF[h
 *
 *@param	data		f[^i[
 *@param	param		PEBhEf[^
 *@param	division	
 *@param	piece_sync	PЂ̃VN
 *@param	disp		EBhE\
 *@param	wnd_sys		EBhEVblankݒVXe[N
 *@param	p_wipehb	CvpHuN[N
 *@param	heap		gpq[v
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionInit(WIPE_TYPE_WND_DIVI* data, const WIPE_TYPE_WND_DIVI_FP* param, int division, int piece_sync, int disp, WNDP_SYS_PTR wnd_sys, WIPE_HBLANK* p_wipehb, int heap )
{
	int i;
	WIPE_TYPE_HB_WND_ONE* one;
	
	// f[^쐬
	// AbN
	data->piece_tbl = sys_AllocMemory(heap, sizeof(WIPE_TYPE_WND_D_PIECE)*param->divi_num);
	GF_ASSERT(data->piece_tbl != NULL);
	data->piece_num = param->divi_num;

	// f[^i[
	for(i=0;i<param->divi_num;i++){

		sum_set_wnd_position(&data->piece_tbl[i].st, &data->piece_tbl[i].ed, &data->piece_tbl[i].add, (param->p_st+i), (param->p_ed+i), division);
	}

	// f[^ݒ
	scchg_h_WndMake(&data->hb_divi, param->wnd_no, disp, heap);
	data->a_count		= division;
	data->piece_sync	= piece_sync;
	data->sync_c		= 0;
	data->wnd_sys		= wnd_sys;
	data->p_wipehb		= p_wipehb;
	data->heap			= heap;
	data->fade_flg		= param->fade_flg;

	// vZ
	scchg_WndDivisionSum(data);
	VWaitTCB_Add(scchg_WndSwap,&data->hb_divi, 1 );
	
	// EBhEݒ
	one = scchg_h_WndIdxDataGet(&data->hb_divi, 0);
	scchg_WndSetUp(wnd_sys, param->in_wnd, param->out_wnd, param->wnd_no, disp,
			one->wnd_tmp[0][0], 0, one->wnd_tmp[1][0], 191,
			data->fade_flg);	// XUɂׂ

	// EBhEI
	if(param->wnd_no == 0){
		scchg_WndVisible(data->wnd_sys, GX_WNDMASK_W0, disp, data->fade_flg);
	}else{
		scchg_WndVisible(data->wnd_sys,GX_WNDMASK_W1, disp, data->fade_flg);
	}

	// Hblank֐ݒ
	WIPE_V_HBlankInit(data->p_wipehb, &data->hb_divi, scchg_h_Wnd, disp, heap);
}
	

//----------------------------------------------------------------------------
/**
 *
 *@brief	1EBhE𕪊Ăꂼœ
 *
 *@param	data		EBhEf[^
 *
 *@return	BOOL		TRUEFI		FALSEFs
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL scchg_WndDivisionMain(WIPE_TYPE_WND_DIVI* data)
{
	
	data->sync_c++;
	if(data->sync_c >= data->piece_sync){
		data->sync_c = 0;
		
		// 
		if((data->a_count - 1) > 0){
			data->a_count--;

			// 
			scchg_WndDivisionMainSub(data);			
			
			scchg_WndDivisionSum(data);		// vZ
			VWaitTCB_Add(scchg_WndSwap,&data->hb_divi, 1 );
		}else{
			// I
			WIPE_V_HBlankDelete(data->p_wipehb, data->hb_divi.disp, data->heap);
			scchg_h_WndDel(&data->hb_divi);
			return TRUE;
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eX̕f[^j
 *
 *@param	data	EBhEf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionEnd(WIPE_TYPE_WND_DIVI* data)
{
	// mۂ
	sys_FreeMemoryEz( data->piece_tbl);
	data->piece_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eX̃f[^EBhE̐ݒf[^ɕϊ
 *
 *@param	work		PEBhEf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionSum(WIPE_TYPE_WND_DIVI* work)
{
	int i;		// [vp
	WIPE_TYPE_HB_WND_ONE* one;
	
	one = scchg_h_WndIdxDataGet(&work->hb_divi, 0);
	memset(one->wnd_tmp, 0, 768);	// NA

	// vfOԗD揇ʂȂ悤ɍŌ̗vff[^ݒ肵Ă
	for(i = (work->piece_num-1); i >= 0; i--){
		scchg_WndDivisionSumSub(&work->hb_divi, &work->piece_tbl[i].st);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	EBhEf[^vZTu֐
 *
 *@param	hb_divi		HuNݒf[^
 *@param	set			ݒf[^
 *
 *@return	none
 *
 * ݒ肷
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionSumSub(WIPE_TYPE_HB_WND* hb_divi, WIPE_WND_POSITION* set)
{
	int i;		// [vp
	WIPE_TYPE_HB_WND_ONE* one;
	WIPE_WND_POSITION set_data;
	
	one = scchg_h_WndIdxDataGet(hb_divi, 0);

	set_data.x1 = set->x1 / SUM_NUM_MINI;
	set_data.y1 = set->y1 / SUM_NUM_MINI;
	set_data.x2 = set->x2 / SUM_NUM_MINI;
	set_data.y2 = set->y2 / SUM_NUM_MINI;

	for( i = set_data.y1; i < set_data.y2; i++ ){
		one->wnd_tmp[0][i] = set_data.x1;
		one->wnd_tmp[1][i] = set_data.x2;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C֐̓֐
 *
 *@param	data		f[^
 *
 *@return	none
 *
 * ۂɕꂽꂼ̃EBhE𓮂
 *
 */
//-----------------------------------------------------------------------------
static void scchg_WndDivisionMainSub(WIPE_TYPE_WND_DIVI* data)
{
	int i;		// [vp

	// ꂼꓮ
	for(i=0;i<data->piece_num;i++){
		sum_add_wnd(&data->piece_tbl[i].st, &data->piece_tbl[i].add);
	}
}
