//============================================================================================
/**
 * @file	wordset.c
 * @brief	PꃂW[
 * @author	taya
 * @date	2005.09.28
 */
//============================================================================================
#include "common.h"

#include "gflib\msg_print.h"
#include "gflib\fntsys.h"
#include "gflib\strbuf_family.h"
#include "system\gamedata.h"
#include "system\msgdata.h"
#include "system\pm_str.h"



#include "system\mystatus.h"

#include "msgdata\msg.naix"
#include "system\wordset.h"

#include "msgdata\msg_sodateya.h"



/*----------------------------------*/
/** @                          */
/*----------------------------------*/
enum {
	WORDSET_GRAMMER_NONE,		///< gpȂ
	WORDSET_GRAMMER_MALE,		///< j
	WORDSET_GRAMMER_FEMALE,		///< 
	WORDSET_GRAMMER_NEUTRAL,	///< 
};


/*----------------------------------*/
/** Pp[^                  */
/*----------------------------------*/
typedef struct {
	u8  def_article;		///< 芥hc
	u8  indef_article;		///< s芥hc
	u8  preposition;		///< Ouhc
	u8  grammer : 7;		///< @
	u8  form : 1;			///< PEi0 = Pj
}WORDSET_PARAM;


typedef struct {
	WORDSET_PARAM	param;
	STRBUF*			str;
}WORD;



struct _WORDSET{

	u32			max;
	u32			heapID;
	WORD*		word;
	STRBUF*		tmpBuf;

};




//==============================================================
// Prototype
//==============================================================
static void RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* str, const WORDSET_PARAM* param );
static void InitParam(WORDSET_PARAM* param);
static void RegistWord(u32 idx, const STRBUF* str, const WORDSET_PARAM* param);

//======================================================================================================
// VXeEI
//======================================================================================================

//------------------------------------------------------------------
/**
 * PZbgW[쐬
 *
 * @param   heapID			쐬q[vhc
 *
 * @retval  WORDSET*		PZbg
 */
//------------------------------------------------------------------
WORDSET*  WORDSET_Create( u32 heapID )
{
	return WORDSET_CreateEx( WORDSET_DEFAULT_SETNUM, WORDSET_DEFAULT_BUFLEN, heapID );
}

//------------------------------------------------------------------
/**
 * PZbgW[쐬io^PꐔE񒷂̎wŁj
 *
 * @param   word_max		
 * @param   buflen			
 * @param   heapID			
 *
 * @retval  WORDSET*		
 */
//------------------------------------------------------------------
WORDSET* WORDSET_CreateEx( u32 word_max, u32 buflen, u32 heapID )
{
	WORDSET* wordset = NULL;
	u32 i;

	GF_ASSERT_RETURN(word_max, NULL);
	GF_ASSERT_RETURN(buflen, NULL);

	do {
		WORDSET* wordset = sys_AllocMemoryLo( heapID, sizeof(WORDSET) );
		if( wordset == NULL ){ break; }

		wordset->max = word_max;
		wordset->heapID = heapID;

		wordset->tmpBuf = STRBUF_Create(buflen, heapID );
		if( wordset->tmpBuf == NULL ){ break; }

		wordset->word = sys_AllocMemoryLo( heapID, sizeof(WORD)*word_max );
		if( wordset->word == NULL ){ break; }

		for(i=0; i<word_max; i++)
		{
			InitParam(&(wordset->word[i].param));
			wordset->word[i].str = STRBUF_Create( buflen, heapID );
			if( wordset->word[i].str == NULL ){
				break;
			}
		}

		if( i == word_max )
		{
			return wordset;
		}

	}while(0);

	if( wordset )
	{
		WORDSET_Delete(wordset);
	}
	return NULL;
}

//------------------------------------------------------------------
/**
 * PZbgj
 *
 * @param   wordset		
 *
 */
//------------------------------------------------------------------
void WORDSET_Delete( WORDSET* wordset )
{
	u32 i;

	GF_ASSERT(wordset->max);

	if( wordset->word )
	{
		for(i=0; i<wordset->max; i++)
		{
			if( wordset->word[i].str )
			{
				STRBUF_Delete( wordset->word[i].str );
			}
			else
			{
				break;
			}
		}
		sys_FreeMemoryEz(wordset->word);
	}

	if( wordset->tmpBuf )
	{
		STRBUF_Delete(wordset->tmpBuf);
	}

	wordset->max = 0;
	sys_FreeMemoryEz(wordset);
}


//------------------------------------------------------------------
/**
 * Pp[^
 *
 * @param   param		p[^\̂ւ̃|C^
 *
 */
//------------------------------------------------------------------
static void InitParam(WORDSET_PARAM* param)
{
	// ȂɂĂȂ
}

//======================================================================================================
// PZbgW[ɊePo^
//======================================================================================================

//------------------------------------------------------------------
/**
 * Pꕶ񁕃p[^wobt@ɓo^
 *
 * @param   wordset		PZbgW[
 * @param   bufID		obt@hc
 * @param   str			
 * @param   param		ɕtp[^
 *
 */
//------------------------------------------------------------------
static void RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* str, const WORDSET_PARAM* param )
{
	GF_ASSERT_MSG( bufID < wordset->max, "bufID=%d, wordmax=%d", bufID, wordset->max );

	if( bufID < wordset->max )
	{
		if( param != NULL )
		{
			wordset->word[bufID].param = *param;
		}
		STRBUF_Copy( wordset->word[bufID].str, str );
	}
}



//------------------------------------------------------------------
/**
 * Cӕp[^tœo^
 *
 * @param   wordset			PZbg
 * @param   bufID			obt@ID
 * @param   word			
 * @param   sex				ʃR[h
 * @param	singular_flag	P^iTRUEŒPj
 * @param   lang			R[h
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterWord( WORDSET* wordset, u32 bufID, const STRBUF* word, u32 sex, BOOL singular_flag, u32 lang )
{
	RegisterWord( wordset, bufID, word, NULL );
}


//------------------------------------------------------------------
/**
 * vC[o^
 *
 * @param   wordset		PZbgIuWFNg
 * @param   bufID		obt@ID
 * @param   status		
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPlayerName( WORDSET* wordset, u32 bufID, const MYSTATUS* status )
{
	const STRCODE * name;
	name = MyStatus_GetMyName( status );

	STRBUF_SetStringCode( wordset->tmpBuf, name );

	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * Coo^
 *
 * @param   wordset		PZbgW[
 * @param   bufID			obt@ID
 * @param   savedata		Z[uf[^ւ̃|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterRivalName( WORDSET* wordset,  u32 bufID, const SAVEDATA * savedata )
{
	static const STRCODE name[] = {
		PA_, bou_, RU_, EOM_,
	};

	// [[[ ͌Œ薼Rs[Ă邾Bg[i[QƂĂ낢B
	STRBUF_SetStringCode( wordset->tmpBuf, name );

	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * T|[gLwobt@ɓo^
 *
 * @param   bufID			obt@ID
 * @param   savedata		Z[uf[^ւ̃|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSupportName( WORDSET* wordset, u32 bufID, const SAVEDATA * savedata )
{
	static const STRCODE name_male[] = {
		KO_, U_, KI_, EOM_,
	};
	static const STRCODE name_female[] = {
		HI_, KA_, RI_, EOM_,
	};
	const MYSTATUS*  myStatus = SaveData_GetMyStatus( (SAVEDATA*)savedata );

	if( MyStatus_GetMySex( myStatus ) == PM_MALE )
	{
		STRBUF_SetStringCode( wordset->tmpBuf, name_female );
	}
	else
	{
		STRBUF_SetStringCode( wordset->tmpBuf, name_male );
	}

	// [[[ ͌Œ薼Rs[Ă邾Bg[i[QƂĂ낢B
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|Po^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeMonsName( WORDSET* wordset, u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	MSGDATA_MANAGER* man;
	u32 monsno;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, wordset->heapID );

	// [[[Ń|P̐ʓ`FbNł]]]
	monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
	MSGMAN_GetString( man, monsno, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);

	MSGMAN_Delete(man);
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̃jbNl[o^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeNickName( WORDSET* wordset, u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	// [[[Ń|P̐ʓ`FbNł]]]
	PokePasoParaGet( ppp, ID_PARA_nickname_buf, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̐eo^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeOyaName( WORDSET* wordset,  u32 bufID, POKEMON_PASO_PARAM* ppp )
{
	// [[[Őe̐ʂ`FbNł]]]
	PokePasoParaGet( ppp, ID_PARA_oyaname_buf, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);

}

//------------------------------------------------------------------
/**
 * wobt@ɐo^
 *
 * @param   bufID		obt@ID
 * @param   number		l
 * @param   keta		
 * @param   dispType	`^Cv
 * @param   codeType	R[h^Cv
 *
 * dispType :  WORDSET_NUMPRINT_LEFT    l
 *             WORDSET_NUMPRINT_SPACE   El߁iXy[X߁j
 *             WORDSET_NUMPRINT_ZERO    El߁i[߁j
 *
 *
 * codeType :  NUMBER_CODETYPE_DEFAULT  [JCỸftHgi{Sp^COpjɂȂ
 *             NUMBER_CODETYPE_ZENKAKU  Spw
 *             NUMBER_CODETYPE_HANKAKU  pw
 */
//------------------------------------------------------------------
void WORDSET_RegisterNumber( WORDSET* wordset, u32 bufID, s32 number, u32 keta, NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType )
{
	STRBUF_SetNumber( wordset->tmpBuf, number, keta, dispType, codeType );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
}

//------------------------------------------------------------------
/**
 * wobt@ɃUo^
 *
 * @param   bufID			obt@ID
 * @param   wazaID			UID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterWazaName( WORDSET* wordset, u32 bufID, u32 wazaID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_wazaname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString(man, wazaID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̂Ƃo^
 *
 * @param   bufID			obt@ID
 * @param   tokuseiID		ƂID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTokuseiName( WORDSET* wordset, u32 bufID, u32 tokuseiID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_tokusei_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString(man, tokuseiID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|P̂o^
 *
 * @param   bufID			obt@ID
 * @param   seikakuID		ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSeikaku( WORDSET * wordset, u32 bufID, u32 seikakuID )
{
	MSGDATA_MANAGER * man;
	
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_chr_dat, wordset->heapID );
	
	MSGMAN_GetString( man, seikakuID, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );

	MSGMAN_Delete(man);
}

//------------------------------------------------------------------
/**
 * wobt@ɃACeo^
 *
 * @param   bufID			obt@ID
 * @param   itemID			ACeID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterItemName( WORDSET* wordset, u32 bufID, u32 itemID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itemname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, itemID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃACe|Pbgo^
 *
 * @param   bufID			obt@ID
 * @param   wazaID			|PbgID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterItemPocketName( WORDSET* wordset, u32 bufID, u32 pocketID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itempocket_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, pocketID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃACe|PbgiACRtjo^
 *
 * @param   bufID			obt@ID
 * @param   wazaID			|PbgID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterItemPocketWithIcon( WORDSET* wordset, u32 bufID, u32 pocketID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_itempocket_icon_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, pocketID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}


//------------------------------------------------------------------
/**
 * wobt@Ƀ|PiUj^Cvo^
 *
 * @param   bufID			obt@ID
 * @param   typeID			^CvID
 * @param   msgManager		^CvGMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeTypeName( WORDSET* wordset, u32 bufID, u32 typeID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_typename_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, typeID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
//------------------------------------------------------------------
/**
 * wobt@Ƀ|PXe[^Xo^
 *
 * @param   bufID			obt@ID
 * @param   statusID		Xe[^XID
 * @param   msgManager		Xe[^XGMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPokeStatusName( WORDSET* wordset, u32 bufID, u32 statusID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_status_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, statusID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}
//------------------------------------------------------------------
/**
 * wobt@ɏԈُ햼o^
 *
 * @param   bufID			obt@ID
 * @param   conditionID		ԈُID
 * @param   msgManager		Ԉُ햼GMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterBadConditionName( WORDSET* wordset, u32 bufID, u32 conditionID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_condition_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, conditionID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɖ؂̖̎o^
 *
 * @param   bufID			obt@ID
 * @param   tasteID			؂̖̎ID
 * @param   msgManager		؂̖̎GMM𑀍삷}l[W|C^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSeedTasteName( WORDSET* wordset, u32 bufID, u32 tasteID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_taste_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, tasteID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɒno^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		nID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPlaceName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_place_name_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀ|Pb`Avo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		AvID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterPoketchAppName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_poketch_app_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀg[i[ʂo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		g[i[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTrTypeName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trtype_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@Ƀg[i[o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		g[i[ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterTrainerName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_trname_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɒnACei΁jo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		nACei΁jID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterUGItemName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergrounditem_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɒn㩖o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		nID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterUGTrapName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundtrap_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɐRo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		RID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterJudgeName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_judge_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃReXgNo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		NID(CAMSG_CONRANK_NORMAL, CAMSG_CONRANK_SUPER, )
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterContestRank( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_acting_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * ReXg^Cv(ReXg)Ƀ^Cvo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		^CvID(CAMSG_CONTYPE_STYLE, )
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterContestType( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_cmsg_acting_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɔ閧̎o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		閧̎ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSecretQuestion( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undersecretquestion_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɔ閧̎̓o^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		閧̎̓ID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSecretAnswer( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undersecretanswer_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɃObYo^
 *
 * @param   wordset		[hZbgIuWFNg
 * @param   bufID		Ԃ̃obt@ɓo^邩
 * @param   strID		ObYID
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterUGGoodsName( WORDSET* wordset, u32 bufID, u32 strID )
{
	MSGDATA_MANAGER *man = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_undergroundgoods_dat, wordset->heapID);
	if( man )
	{
		MSGMAN_GetString( man, strID, wordset->tmpBuf );
		RegisterWord( wordset, bufID, wordset->tmpBuf, NULL );
		MSGMAN_Delete(man);
	}
}

//------------------------------------------------------------------
/**
 * wobt@ɈĂĂ|Po^
 *
 * @param   bufID		obt@ID
 * @param   ppp		|Pp[^
 *
 */
//------------------------------------------------------------------
void WORDSET_RegisterSodateyaPokeMonsName( WORDSET* wordset, u32 bufID, POKEMON_PASO_PARAM* ppp )
{
//xxxxxx
	MSGDATA_MANAGER* man;
	u32 monsno;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, wordset->heapID );

	// [[[Ń|P̐ʓ`FbNł]]]
	monsno = PokePasoParaGet( ppp, ID_PARA_monsno, NULL );
	MSGMAN_GetString( man, monsno, wordset->tmpBuf );
	RegisterWord( wordset, bufID, wordset->tmpBuf, NULL);

	MSGMAN_Delete(man);

//060317 쐬r by tomo

#if 0
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_sodateya_dat, wordset->heapID );
	MSGMAN_GetString( man, msg_sodateya_10, wordset->tmpBuf );		//
	MSGMAN_GetString( man, msg_sodateya_11, wordset->tmpBuf );		//
	MSGMAN_GetString( man, msg_sodateya_12, wordset->tmpBuf );		//Lv


	MSGMAN_Delete(man);




#endif
//xxxxxx
}

//======================================================================================================
// WJ
//======================================================================================================

//------------------------------------------------------------------
/**
 * o^ꂽPgĕWJ
 *
 * @param   dst		WJobt@
 * @param   src		WJ
 *
 */
//------------------------------------------------------------------
void WORDSET_ExpandStr( const WORDSET* wordset, STRBUF* dstbuf, const STRBUF* srcbuf )
{
	const STRCODE* src;
	STRCODE *dst;

	src = STRBUF_GetStringCodePointer(srcbuf);
	STRBUF_Clear( dstbuf );

	while( *src != EOM_ )
	{
		if( *src == _CTRL_TAG )
		{
			if( STRCODE_CheckWordSetTagType(src) )
			{
				u32 word_id;

				word_id = STRCODE_GetTagParam(src, 0);

				GF_ASSERT( word_id < wordset->max );

				// [[[COłł̓p[^̉߂Kv]]]
				STRBUF_AddStr( dstbuf, wordset->word[ word_id ].str );
				src = STRCODE_SkipTag(src);
			}
			else
			{
				const STRCODE* p = src;

				src = STRCODE_SkipTag(src);
				while(p < src)
				{
					STRBUF_AddChar( dstbuf, *p++ );
				}
				
			}
		}
		else
		{
			STRBUF_AddChar( dstbuf, *src++ );
		}
	}
}










