//==============================================================================
/**
 * @file	ball_effect.c
 * @brief	{[GtFNg
 * @author	goto
 * @date	2005.10.24()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#include "common.h"
#include "system/lib_pack.h"
#include "system/fontproc.h"
#include "system/pm_str.h"

#include "str_tool.h"
#include "wazaeffect/we_mana.h"
#include "system/snd_tool.h"
#include "system/msgdata.h"

#include "spl.h"
#include "include/battle/battle_tcb_pri.h"
#include "effectdata/we_list.h"

#include "we_tool.h"
#include "we_def.h"
#include "we_sys.h"

#include "ball_effect.h"
#include "battle_particle.h"

#include "d_tool.h"

#include "wazatool.h"

#include "contest/visual_ex.h"


///< 10/28ROMp
#ifdef BE_1028_ROM_MODE

#define BE_START_NO (0)						///< hڂ̴̪

static int ball_eff_loop_cnt = BE_START_NO;

#endif

//#define BE_FREE_MOVE

#define BMT_START_POS_OFS_X	(+10)
#define BMT_START_POS_OFS_Y	(32)

// -----------------------------------------
//
//	{[GtFNgp\
//
// -----------------------------------------
typedef struct _TBALL_EFFECT_SYS {
	
	int			heap_area;			///< q[vGA
	
	TBALL_CUSTOM_PARAM	bcp;		///< {[JX^}CYp[^
	
	PTC_PTR		ptc;				///< p[eBÑ|C^
	EMIT_PTR	emit;				///< G~b^[̃|C^
	
	TCB_PTR		tcb;				///< TCB ̃|C^
	
	BOOL		active;				///< `FbN
	
} TBALL_EFFECT_SYS;

static PTC_PTR	d_ptc = NULL;
// =============================================================================
//
//
//	vg^Cv
//
//
// =============================================================================
static void BallEffect_MainTCB(TCB_PTR tcb, void* work);
static void BallEffect_ParticleSet(BES_PTR bes, pEmitFunc callback);
static void BallEffect_CallBack(EMIT_PTR emit);

static void CBTool_InitVelocityGet(fx16* i_velo, fx16 n_velo, int n_per, f32 m_per);
static void CBTool_InitPosRandGet(f32* p, u16 rnd, f32 param);
static s8 CBTool_SignGet(void);


// =============================================================================
//
//
//	OQƊ֐S
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	p[^[
 *
 * @param	heap_area			q[vID
 *
 * @retval	BES_PTR	
 *
 */
//--------------------------------------------------------------
BES_PTR BallEffect_InitEz(int heap_area)
{
	TBALL_EFFECT_SYS* bes = NULL;
	
	bes = sys_AllocMemory(heap_area, sizeof(TBALL_EFFECT_SYS));
	
	if (bes == NULL){
		GF_ASSERT(0);
		return NULL;
	}
	
	bes->heap_area = heap_area;
	bes->active	   = FALSE;
	
	bes->ptc	   = Wp_Init(heap_area, BALL_EFFECT_USE_SPA);
	
	d_ptc = bes->ptc;
	
	return bes;
}


//--------------------------------------------------------------
/**
 * @brief	p[^[GtFNg̏
 *
 * @param	heap_area	
 * @param	bip	
 *
 * @retval	BES_PTR	
 *
 */
//--------------------------------------------------------------
BES_PTR BallEffect_Init(int heap_area, const TBALL_CUSTOM_PARAM* bcp)
{
	TBALL_EFFECT_SYS* bes = NULL;
	
	DefaultBlendSet();
	
	bes = BallEffect_InitEz(heap_area);

#ifdef BE_1028_ROM_MODE
	///< 10.28ROMp JX^{[Œf[^
	{
		int i;
		
		BallEffect_ParamSet(bes, bcp);
		{
			int gen_tbl[BALL_EFFECT_BIT_MAX] = { 2,4,3,2,3,3,3,2,2,3,4,1,2,3,3,9,2,2,5,5,5,5,5 };
			int num_tbl[BALL_EFFECT_BIT_MAX] = { 3,3,2,3,1,1,2,1,2,1,1,3,1,1,1,1,2,1,2,1,1,1,1 };
			
			//OS_Printf("-----ްٴ̪ďxω-----\n");
			for (i = 0; i < BALL_EFFECT_BIT_MAX; i++){
				bes->bcp.bip[i].eff_num		= num_tbl[i];
				bes->bcp.bip[i].velocity	= (3 + (gf_rand() % 16))*10;
				//OS_Printf("̪No = %2d : x = %3d%%\n", i, bes->bcp.bip[i].velocity);
				bes->bcp.bip[i].gen_num		= gen_tbl[i] << FX32_SHIFT;
				BallEffect_TypeBitControl(&bes->bcp, i, BEBIT_OFF);
			}
		}
		
		{
			int eff_tbl[][BALL_EFFECT_BIT_MAX] = {
				{ 15, 			0xFF	},	///< EP
				{ 3,4, 			0xFF	},	///< EP
				{ 3,8,18,		0xFF	},	///< EEP
				{ 18,18,		0xFF	},	///< 
				{ 7,8,			0xFF	},	///< EP
				{ 19,20,		0xFF	},	///< EP
				{ 0,1, 17,		0xFF	},	///< EP
				{ 5, 15, 		0xFF	},	///< 
				{ 4, 11,		0xFF	},	///< EEP
				{ 3,4, 5,		0xFF	},	///< EP
				{ 6,9,			0xFF	},	///< EQ
				{ 6,9,11,		0xFF	},	///< EQ
				{ 12,13,		0xFF	},	///< EP
				{ 6,10,11,12,	0xFF	},	///< hEP
				{ 1,14,16,		0xFF	},	///< EEP
				{ 12,13,14,		0xFF	},	///< EP
				{ 3,6,9,		0xFF	},	///< ER
				{ 3,9,14,		0xFF	},	///< E~EP
				{ 16,17,0,		0xFF	},	///< EEP
				{ 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17},	///< ALL
				{ 2, 13, 15,	0xFF	},	///< 
			};
			for (i = 0; i < BALL_EFFECT_BIT_MAX; i++){
				int dat = eff_tbl[ball_eff_loop_cnt][i];
				if (dat == 0xFF){
					break;
				}
				BallEffect_TypeBitControl(&bes->bcp, dat, BEBIT_ON);
			}
			ball_eff_loop_cnt++;
			ball_eff_loop_cnt %= BALL_EFFECT_BIT_MAX;
			
			//̃[vGtFNgoȂ悤ɎbΏ 2006.01.24() matsuda
			ball_eff_loop_cnt = 0;
		}
	}
	return bes;
	
#else

	BallEffect_ParamSet(bes, bcp);

#endif
	
	return bes;
}


//--------------------------------------------------------------
/**
 * @brief	GtFNg̃p[^[ݒ
 *
 * @param	bes	
 * @param	bip	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void BallEffect_ParamSet(BES_PTR bes, const TBALL_CUSTOM_PARAM* bcp)
{
#if 1	///< ꂿƒl

//	memcpy(&(bes->bip), bip, sizeof(TBALL_INIT_PARAM));

	bes->bcp = *bcp;

#else

	bes->bip.velocity = bip.velocity;
	bes->bip.gen_num  = bes->bip.gen_num;
	bes->bip.eff_type = bes->eff_type;

#endif
}


//--------------------------------------------------------------
/**
 * @brief	{[o^
 *
 * @param	bes	
 * @param	callback	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void BallEffect_Executed(BES_PTR bes, pEmitFunc callback)
{
	bes->active = TRUE;
	
	BallEffect_ParticleSet(bes, callback);
	
	bes->tcb	= TCB_Add(BallEffect_MainTCB, bes, TCBPRI_BALL_EFFECT);
}


//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	bes	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void BallEffect_ExecutedEz(BES_PTR bes)
{
	BallEffect_Executed(bes, BallEffect_CallBack);
}


//--------------------------------------------------------------
/**
 * @brief	I`FbN
 *
 * @param	bes	
 *
 * @retval	BOOL	
 *
 */
//--------------------------------------------------------------
BOOL BallEffect_EndCheck(BES_PTR bes)
{
	return bes->active;
}


//--------------------------------------------------------------
/**
 * @brief	C^XN
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void BallEffect_MainTCB(TCB_PTR tcb, void* work)
{
	BES_PTR wk = (BES_PTR)work;
	
	if (Particle_GetEmitterNum(wk->ptc) == 0){
		wk->active = FALSE;
		Wp_Exit(wk->ptc);
		TCB_Delete(tcb);
	}
}


//--------------------------------------------------------------
/**
 * @brief	GtFNg̃^Cv擾
 *
 * @param	bip	
 * @param	no	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
int	BallEffect_TypeGet(TBALL_CUSTOM_PARAM* bcp, int no)
{
	int bit;
	
	bit = (bcp->eff_type & (1 << no)) >> no;
	
	return bit;
}


//--------------------------------------------------------------
/**
 * @brief	GtFNg̃^Cvݒ
 *
 * @param	bip	
 * @param	no	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
int	BallEffect_TypeSet(TBALL_CUSTOM_PARAM* bcp, int no)
{
	int bit;
	
	bit = bcp->eff_type |= 1 << no;
	
	return bit;
}


//--------------------------------------------------------------
/**
 * @brief	GtFNg̃^CvZbg
 *
 * @param	bip	
 * @param	no	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
int	BallEffect_TypeReset(TBALL_CUSTOM_PARAM* bcp, int no)
{
	int bit;
	
	bit = bcp->eff_type &= 0xffffffff ^ (1 << no);
	
	return bit;
}


//--------------------------------------------------------------
/**
 * @brief	GtFNg̃rbg
 *
 * @param	bip	
 * @param	no	
 * @param	mode	EBE_BIT Q
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
int	BallEffect_TypeBitControl(TBALL_CUSTOM_PARAM* bcp, int no, int mode)
{
	switch(mode){
	case BEBIT_ON:
		///< BitOn
		return BallEffect_TypeSet(bcp, no);
		
	case BEBIT_OFF:
		///< BitOff
		return BallEffect_TypeReset(bcp, no);
		
	case BEBIT_CHECK:
		///< BitCheck
		return BallEffect_TypeGet(bcp, no);
		
	default:
		///< Ƃ肠肦Ȃ
		GF_ASSERT(0);
		return 0;
	}
}


//--------------------------------------------------------------
/**
 * @brief	{[p
 *
 * @param	bes	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void BallEffect_FreeMemory(BES_PTR bes)
{
	sys_FreeMemoryEz(bes); ///< BES_PTR
}



// =============================================================================
//
//
//	QƊ֐S
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	GtFNg̓o^
 *
 * @param	bes	
 * @param	callback	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void BallEffect_ParticleSet(BES_PTR bes, pEmitFunc callback)
{
	int i,j;
	
	for (i = 0; i < BALL_EFFECT_BIT_MAX; i++){
		if (BallEffect_TypeBitControl(&bes->bcp, i, BEBIT_CHECK) == 0){ continue; }
		
		for (j = 0; j < bes->bcp.bip[i].eff_num; j++){
			bes->bcp.bip[i].client_type = bes->bcp.client_type;
			Particle_CreateEmitterCallback(bes->ptc, i, callback, &bes->bcp.bip[i]);
		}
	}

	Particle_CameraTypeSet(bes->ptc, GF_CAMERA_ORTHO);
}

extern void DebugParticle_EmitMove(PTC_PTR ptc, EMIT_PTR emit, const VecFx32 *vec);

//--------------------------------------------------------------
/**
 * @brief	R[obN֐p[^̔fȂ
 *
 * @param	emit	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void BallEffect_CallBack(EMIT_PTR emit)
{
	TBALL_INIT_PARAM* bip;
	
	bip = Particle_GetTempPtr();
	
	///< Ww
	#if BECB_INIT_DEF_POS
	{
		VecFx32 pos;
		
		//WET_PokeParticlePosGet(bip->we_sys, bip->client_type, &pos);
		WET_PokeParticlePosGet_CT(bip->client_type, &pos, FALSE, GF_CAMERA_ORTHO);
		///< W␳
		{
			int x;
			int y;
			s16 ox;
			s16 oy;
			VecFx32 ofs;
			
			switch(bip->client_type){
			case CLIENT_TYPE_AA:
				ox = 0;
				oy = 0;
				break;
			case CLIENT_TYPE_BB:
				ox = -15;
				oy = -17;
				break;
			case CLIENT_TYPE_A:
				ox = 4;
				oy = 0;
				break;
			case CLIENT_TYPE_B:
				ox = -12;
				oy = 0;
				break;
			case CLIENT_TYPE_C:
				ox = 0;
				oy = 0;
				break;
			case CLIENT_TYPE_D:
			default:
				ox = -10;
				oy = -7;
				break;
			}
		
			x = PT_LCD_DOT * (BMT_START_POS_OFS_X + ox);
			y = PT_LCD_DOT * (BMT_START_POS_OFS_Y + oy);
			VEC_Set(&ofs, x, y, 0);
			pos.x -= ofs.x;
			pos.y -= ofs.y;
		}
		
		SPL_SetEmitterPosition(emit, &pos);
	}
	#endif
	
	///< xϊ	
	#if BECB_INIT_VELO
	{
		fx16 initvelo;
		fx16 nowvelo;
		
		nowvelo = SplSub_GetEmitterInitVelocityPos(emit);
	
		CBTool_InitVelocityGet(&initvelo, 
							   nowvelo,							   
							   bip->velocity,
							   100.0f);

		SPL_SetEmitterInitVelocityPos(emit, initvelo);
	}
	#endif
	
	///< o[g
	#if BECB_GENE_RAITO
	{		
		SplSub_SetEmitterGenerationRatio(emit, bip->gen_num);
	}		
	#endif
	
	///< oԊu
	#if BECB_INTERVAL
	{		
		u16 intval;
		
		intval = (gf_rand() % 10);
		
		SPL_SetEmitterEmissionInterval(emit, intval);
	}	
	#endif

	///< l
	#if BECB_INIT_POS
	{		
		VecFx32 vec;
		s8	sinx;
		s8	siny;
		f32 parax;
		f32 paray;
		fx32 x;
		fx32 y;
		fx32 z;
		
		
		CBTool_InitPosRandGet(&parax, 16, 10.0f);
		CBTool_InitPosRandGet(&paray, 12, 10.0f);
		
		sinx = CBTool_SignGet();
		siny = CBTool_SignGet();
		
		SplSub_GetEmitterPosition(emit, &vec);
		SPL_SetEmitterPositionX(emit, vec.x+(FX32_CONST(parax)*sinx));
		SPL_SetEmitterPositionY(emit, vec.y+(FX32_CONST(paray)*siny));
		SPL_SetEmitterPositionZ(emit, vec.z);
	}
	#endif

	#ifdef BE_FREE_MOVE
	{
		///< A
		VecFx32 tv = { 0,0,0 };
		DebugParticle_EmitMove(d_ptc, emit, &tv);
	}
	#endif
}


// -----------------------------------------
//
//	R[obN̕⏕֐
//
// -----------------------------------------
static void CBTool_InitVelocityGet(fx16* i_velo, fx16 n_velo, int n_per, f32 m_per)
{
	f32 per;
	f32 temp;
	
	per = (f32)(n_per / m_per);
	
	temp = FX_FX16_TO_F32(n_velo);
	temp *= per;
	
	*i_velo = FX_F32_TO_FX16(temp);
}


//--------------------------------------------------------------
/**
 * @brief	Wݒ֐
 *
 * @param	p	
 * @param	rnd	
 * @param	param	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void CBTool_InitPosRandGet(f32* p, u16 rnd, f32 param)
{
	u16 rand;
	f32 pos;
	
	rand = gf_rand();
	rand %= rnd;
	rand++;
	
	pos = rand;
	pos /= param;
	
	*p = pos;	
}


//--------------------------------------------------------------
/**
 * @brief	ݒ֐
 *
 * @param	none	
 *
 * @retval	s8	
 *
 */
//--------------------------------------------------------------
static s8 CBTool_SignGet(void)
{
	u16 rand;
	
	rand = gf_rand();
	
	if (rand % 2){
		return +1;
	}
	else {
		return -1;
	}
}




// =============================================================================
//
//
//	inline֐
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	int^̉Z
 *
 * @param	param	
 * @param	data	
 * @param	min	
 * @param	max	
 *
 * @retval	none
 *
 */
//--------------------------------------------------------------
static inline void BE_IntParamSet_inline(int* param, s16 data, int min, int max)
{
	if (data > 0){
		*param += data;
		*param %= max;
	}
	else if (data < 0){
		if (*param + data < min){
			*param = max + data;
		}
		else {
			*param += data;
		}
	}
}


//--------------------------------------------------------------
/**
 * @brief	fx32^̉Z
 *
 * @param	param	
 * @param	data	
 * @param	min	
 * @param	max	
 *
 * @retval	none
 *
 */
//--------------------------------------------------------------
static inline void BE_Fx32ParamSet_inline(fx32* param, fx32 data, fx32 min, fx32 max)
{
	if (data > 0){
		if (*param + data < max){
			*param += data;
		}
		else {
			*param = (*param + data) - max;
		}
	}
	else if (data < 0){
		if (*param + data < min){
			*param = max + data;
		}
		else {
			*param += data;
		}
	}
}



// =============================================================================
//
//
//	fobOp
//
//
// =============================================================================
static const u16 str_label_FF[] = { E_,HU_,EE_,KU_,TO_,spc_,ba_,n_,go_,u_,EOM_};
static const u16 str_label_00[] = { si_,yyo_,so_,ku_,do_,spc_,PA_,bou_,SE_,N_,TO_,EOM_};
static const u16 str_label_01[] = { E_,HU_,EE_,KU_,TO_,spc_,RE_,bou_,TO_,EOM_};
static const u16 str_label_02[] = { E_,HU_,EE_,KU_,TO_,spc_,O__,N__,sura_,O__,F__,F__,EOM_};
static const u16 str_label_03[] = { E_,HU_,EE_,KU_,TO_,spc_,ko_,su_,u_,EOM_};
static const u16 str_label_04[] = { KU_,RA_,I_,A_,N_,TO_,spc_,N__,o__,EOM_};
static const u16* str_label_tbl[] = {
	str_label_FF,
	str_label_00,
	str_label_01,
	str_label_03,
	str_label_04,
	str_label_02,
};

enum {
	DBE_NO   = 0,			///< GtFNgԍ
	DBE_VELO = 1,			///< x
	DBE_RATO,				///< [g
	DBE_NUM,				///< 
	DBE_CN,					///< NCAgԍ
	DBE_BIT,				///< BIT
	DBE_MAX = DBE_BIT,		///< BIT͎w肵Ȃ̂ŁAMAXƂȂ
};

// ---------- fobO\ʒu ----------
#define BED_PRINT_X		(120)

// ---------- x֘A ----------
#define BED_VELO_P1		(10)								///< ωʍŏ
#define BED_VELO_P2		(10)								///< ωʍő
#define BED_VELO_MAX	(200+BED_VELO_P1)					///< x%ő
#define BED_VELO_MIN	(0)									///< x%ŏ

// ---------- [g֘A ----------
#define BED_RATE_P1		(FX_F32_TO_FX32(0.5f))				///< ωʍŏ
#define BED_RATE_P2		(FX_F32_TO_FX32(1.0f))				///< ωʍő
#define BED_RATE_MAX	(FX_F32_TO_FX32(10.0f)+BED_RATE_P1)	///< [gő
#define BED_RATE_MIN	(FX_F32_TO_FX32(0.0f))				///< [gŏ

// ---------- GtFNǧ ----------
#define BED_EFFNUM_P1	(1)									///< GtFNg̕ωʍŏ
#define BED_EFFNUM_P2	(1)									///< GtFNg̕ωʍő
#define BED_EFFNUM_MAX	(10+BED_EFFNUM_P1)					///< GtFNǧő
#define BED_EFFNUM_MIN	(1)									///< GtFNǧŏ

// ---------- NCAgԍ ----------
#define BED_CN_MAX	(4)										///< NCAgԍő
#define BED_CN_MIN	(0)										///< NCAgԍő
#define BED_CN_P1	(1)										///< NCAgԍʍŏ
#define BED_CN_P2	(1)										///< NCAgԍʍő

// -----------------------------------------
//
//	fobOp\
//
// -----------------------------------------
typedef struct {
	
	int		seq;
	int		gene_seq;
	int		gene_cnt;
	
	int		heap;
	int		sel;
	int		esel;		///< GtFNgIꏊ
	
	BES_PTR bes;		///< {[GtFNg
	
	GF_BGL_INI*		bgl;
	GF_BGL_BMPWIN	win;

	TBALL_CUSTOM_PARAM	bcp;
	
	WAZA_EFFECT_PARAM	wep;
	
	BATTLE_WORK* d_wk;
	
	int time;
	int s_time;
	
	TCB_PTR		btcb;
	TCB_FUNC	bfunc;	
	
} TBE_DEBUG;

static void BallEffect_DebugTCB(TCB_PTR tcb, void* work);

//--------------------------------------------------------------
/**
 * @brief	fobOGtFNg̏
 *
 * @param	heap	
 * @param	bw	
 * @param	tcb	
 * @param	func	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void DebugBallEffectInit(int heap, BATTLE_WORK* bw, TCB_PTR tcb, TCB_FUNC func)
{
	TBE_DEBUG* wk = sys_AllocMemory(heap, sizeof(TBE_DEBUG));
	
	memset(wk, 0, sizeof(TBE_DEBUG));
	
	wk->heap = heap;
	
	TCB_ChangeFunc(tcb, NULL);

	wk->d_wk = bw;	
	wk->bgl	= BattleWorkGF_BGL_INIGet(bw);
	wk->bfunc = func;
	wk->btcb  = tcb;

	wk->gene_seq = 0;
	wk->gene_cnt = 0;
	
	wk->sel  = 0;
	wk->esel = 0;
	
	wk->time = 0;
	wk->s_time = 0;
	
	{
		int i;
		
		for (i = 0; i < BALL_EFFECT_BIT_MAX; i++){
			wk->bcp.bip[i].velocity = 100;
			wk->bcp.bip[i].gen_num  = 1 << FX32_SHIFT;
			wk->bcp.bip[i].eff_num  = 1;
		}
	}

	wk->bes = NULL;
	
	DT_WinAdd(wk->bgl, &wk->win, GF_BGL_FRAME1_M, 0, 0, 32, 15, 0x0a,0x0d);

	G2_SetBG1Priority(0);
	
	TCB_Add(BallEffect_DebugTCB, wk, 1000);
}


// -----------------------------------------
//
//	fobO֐S
//
// -----------------------------------------
static BOOL DBE_DisplayInit(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys);
static BOOL DBE_DisplayDraw(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys);
static BOOL DBE_KeyRead(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys);
static BOOL DBE_Executed(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys);

static BOOL (* const DBE_TcbTable[])(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys) = {
	DBE_DisplayInit,
	DBE_DisplayDraw,
	DBE_KeyRead,
	DBE_Executed,
};

enum {
	DBES_DispInit = 0,
	DBES_DispDraw,
	DBES_KeyRead,
	DBES_Executed,
};

//--------------------------------------------------------------
/**
 * @brief	fobOpTCB
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void BallEffect_DebugTCB(TCB_PTR tcb, void* work)
{
	TBE_DEBUG* wk = (TBE_DEBUG*) work;
	BOOL active;
	
	active = DBE_TcbTable[wk->seq](tcb, wk, &sys);
	
	if (active == FALSE){
		G2_SetBG1Priority(1);						///< Dx߂
		GF_BGL_BmpWinOff(&wk->win);					///< EBhE
		GF_BGL_BmpWinDel(&wk->win);					///< bmp-winj
		TCB_ChangeFunc(wk->btcb, wk->bfunc);		///< battle-tcb̕A
		
		if (wk->bes != NULL){						///< mۂȂ
			BallEffect_FreeMemory(wk->bes);			///< 
		}
		
		sys_FreeMemoryEz(wk);						///< 
		TCB_Delete(tcb);							///< tcbj
	}
}


//--------------------------------------------------------------
/**
 * @brief	ʏ
 *
 * @param	tcb	
 * @param	wk	
 * @param	sys	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL DBE_DisplayInit(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys)
{
	DT_MsgClear(wk->bgl, &wk->win);
	GF_BGL_BmpWinOn(&wk->win);
	
	wk->seq = DBES_DispDraw;
	
	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	ʕ`
 *
 * @param	tcb	
 * @param	wk	
 * @param	sys	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL DBE_DisplayDraw(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys)
{
	DT_MsgClear(wk->bgl, &wk->win);

	{
		int no = 0;
		int i;
		u16 str_buff[NELEMS(str_label_tbl)+3][50];
		
		///< GtFNgԍ
		{
			//DT_MsgPrint(wk->bgl, &wk->win, str_label_tbl[no],	0*8, no*2*8, (no == wk->sel ? 1 : 0));
			PM_NumMsgSet(str_buff[no], wk->esel, NUM_MODE_ZERO, 2);
			//DT_MsgPrint(wk->bgl, &wk->win, str_buff[no], BED_PRINT_X, no*2*8, 1);
		}
		no++;

		///< p[Zg
		{
			//DT_MsgPrint(wk->bgl, &wk->win, str_label_tbl[no],	0*8, no*2*8, (no == wk->sel ? 1 : 0));
			PM_NumMsgSet(str_buff[no], wk->bcp.bip[wk->esel].velocity, NUM_MODE_ZERO, 3);
			//DT_MsgPrint(wk->bgl, &wk->win, str_buff[no], BED_PRINT_X, no*2*8, 1);
		}
		no++;
		
		///< 
		{
			int num = 0;
			f32 dec = 0;
			int tmp = 0;
			u16 strNum[20] = { EOM_, };
			static u16 strPri[2] = { period_, EOM_, };
			//DT_MsgPrint(wk->bgl, &wk->win, str_label_tbl[no],	0*8, no*2*8, (no == wk->sel ? 1 : 0));
			num = (wk->bcp.bip[wk->esel].gen_num & FX32_INT_MASK) >> FX32_SHIFT;
			dec = FX_FX32_TO_F32((wk->bcp.bip[wk->esel].gen_num & FX32_DEC_MASK));
			tmp = dec * 10;

			PM_NumMsgSet(str_buff[no], num, NUM_MODE_ZERO, 2);
			PM_strcpy(strNum, str_buff[no]);
			PM_strcat(strNum, strPri);
			PM_NumMsgSet(str_buff[no], tmp, NUM_MODE_ZERO, 1);
			PM_strcat(strNum, str_buff[no]);
			//DT_MsgPrint(wk->bgl, &wk->win, strNum, BED_PRINT_X, no*2*8, 1);
			no++;
		}
		
		///< GtFNg
		{
			//DT_MsgPrint(wk->bgl, &wk->win, str_label_tbl[no],	0*8, no*2*8, (no == wk->sel ? 1 : 0));
			PM_NumMsgSet(str_buff[no], wk->bcp.bip[wk->esel].eff_num, NUM_MODE_ZERO, 3);
			//DT_MsgPrint(wk->bgl, &wk->win, str_buff[no], BED_PRINT_X, no*2*8, 1);
			no++;
		}
		
		///< NCAgԍ
		{
			//DT_MsgPrint(wk->bgl, &wk->win, str_label_tbl[no],	0*8, no*2*8, (no == wk->sel ? 1 : 0));
			PM_NumMsgSet(str_buff[no], wk->bcp.client_type, NUM_MODE_ZERO, 1);
			//DT_MsgPrint(wk->bgl, &wk->win, str_buff[no], BED_PRINT_X, no*2*8, 1);
			no++;
		}
		
		///< GtFNg^Cv
		{
			int i;
			int bit[BALL_EFFECT_BIT_MAX];
			
			//DT_MsgPrint(wk->bgl, &wk->win, str_label_tbl[no],	0*8, no*2*8, 2);
			no++;
			for (i = 0; i < BALL_EFFECT_BIT_MAX; i++){
				int col = 0;
				bit[i] = BallEffect_TypeGet(&wk->bcp, i);
				PM_NumMsgSet(str_buff[no], bit[i], NUM_MODE_ZERO, 1);
				if (i == wk->esel){
					col = 1;
				}
				else {
					if (BallEffect_TypeGet(&wk->bcp, i) == 1){
						col = 2;
					}
				}
				//DT_MsgPrint(wk->bgl, &wk->win, str_buff[no], (i*7), no*2*8, col);
			}
		}
	}	
	wk->seq = DBES_KeyRead;
	
	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	L[ǂݍ
 *
 * @param	tcb	
 * @param	wk	
 * @param	sys	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL DBE_KeyRead(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys)
{	
	if (sys->trg & PAD_BUTTON_B){ return FALSE; }
	
	///< [ L R ] GtFNgI
	{
		if (sys->repeat & PAD_BUTTON_R){
			BE_IntParamSet_inline(&wk->esel, +1, 0, BALL_EFFECT_BIT_MAX);
		}
		else if (sys->repeat & PAD_BUTTON_L){
			BE_IntParamSet_inline(&wk->esel, -1, 0, BALL_EFFECT_BIT_MAX);
		}
	}
	
	///< [   ] ڑI
	{
		if (sys->repeat & PAD_KEY_UP){
			BE_IntParamSet_inline(&wk->sel, -1, 0, DBE_MAX);
		}
		else if (sys->repeat & PAD_KEY_DOWN){
			BE_IntParamSet_inline(&wk->sel, +1, 0, DBE_MAX);
		}
	}
	
	///< [   ] p[^
	{
		s8 sign = 0;
		TBALL_INIT_PARAM* pBip = &wk->bcp.bip[wk->esel];

		if (sys->repeat & PAD_KEY_RIGHT){
			sign = +1;
		}
		else if (sys->repeat & PAD_KEY_LEFT){
			sign = -1;
		}
		
		if (sign != 0){
			
			switch(wk->sel){
			case DBE_NO:
				BE_IntParamSet_inline(&wk->esel, +1 * sign, 0, BALL_EFFECT_BIT_MAX);
				break;
			case DBE_VELO:
				BE_IntParamSet_inline(&pBip->velocity, +BED_VELO_P1 * sign, BED_VELO_MIN, BED_VELO_MAX);
				break;
			case DBE_RATO:
				BE_Fx32ParamSet_inline(&pBip->gen_num, +BED_RATE_P1 * sign, BED_RATE_MIN, BED_RATE_MAX);
				break;
			case DBE_NUM:
				BE_IntParamSet_inline(&pBip->eff_num,  +BED_EFFNUM_P1 * sign, BED_EFFNUM_MIN, BED_EFFNUM_MAX);
				break;
			case DBE_CN:
				BE_IntParamSet_inline(&wk->bcp.client_type, +BED_CN_P1 * sign, BED_CN_MIN, BED_CN_MAX);
				break;
			}
			
		}
	}
	
	///< [ Y ] Bit
	{
		if (sys->trg & PAD_BUTTON_Y){
			int bit = BallEffect_TypeBitControl(&wk->bcp, wk->esel, BEBIT_CHECK);
			if (bit == 0){
				BallEffect_TypeBitControl(&wk->bcp, wk->esel, BEBIT_ON);
			}
			else {
				BallEffect_TypeBitControl(&wk->bcp, wk->esel, BEBIT_OFF);
			}
		}
	}
	
	///< [ A ] s
	{
		if (sys->trg & PAD_BUTTON_A){
			wk->seq = DBES_Executed;
			return TRUE;
		}
	}
	
	///< [ Select ] 
	{
		if (sys->trg & PAD_BUTTON_SELECT){
			wk->bcp.bip[wk->esel].velocity = 100;
			wk->bcp.bip[wk->esel].gen_num  = 1 << FX32_SHIFT;
			wk->bcp.bip[wk->esel].eff_num  = 1;
			BallEffect_TypeBitControl(&wk->bcp, wk->esel, BEBIT_OFF);
		}
	}
	
	///< [ Y ] L[
	if (sys->cont & PAD_BUTTON_Y){
		return TRUE;
	}
	
	///< ȂɂĂĕ`
	if (sys->trg != 0
	||	sys->repeat != 0){
		DBE_DisplayDraw(tcb, wk, sys);
	}		
	
	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	GtFNgs
 *
 * @param	tcb	
 * @param	wk	
 * @param	sys	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL DBE_Executed(TCB_PTR tcb, TBE_DEBUG* wk, SystemArea* sys)
{
	switch(wk->gene_seq){
	case 0:
		///< EBhE
		GF_BGL_BmpWinOff(&wk->win);
		Snd_SePlay(SEQ_SE_DP_WIN_OPEN);
		wk->gene_seq++;

	case 1:
		///< 莞ԑ҂
		if ((++wk->gene_cnt) > 15){
			wk->gene_cnt = 0;
		
			wk->bes = BallEffect_Init(HEAPID_BATTLE, &wk->bcp);
			
			if (!(sys->cont & PAD_BUTTON_Y)){
				BallEffect_ParamSet(wk->bes, &wk->bcp);
			}

			BallEffect_ParticleSet(wk->bes, BallEffect_CallBack);
			wk->gene_seq++;
		}
		break;

	case 2:
		///< s
		BattleParticle_Main();
		if (Particle_GetEmitterNum(wk->bes->ptc) == 0){
			Wp_Exit(wk->bes->ptc);
			wk->gene_seq++;
		}
		break;

	default:
		///< I
		wk->gene_seq = 0;
		wk->gene_cnt = 0;
		if (wk->bes != NULL){
			BallEffect_FreeMemory(wk->bes);				///< 
			wk->bes = NULL;
		}
		wk->seq = DBES_DispInit;
		break;
	};

	return TRUE;
}

#include "wazatool.h"
// =============================================================================
//
//
//	
//
//
// =============================================================================
typedef struct {
	
	s16 sx;
	s16 sy;
	s16 ex;
	s16 ey;
	
	int time;
	int height;
	
} TBALL_THROW_PARAM;

typedef struct _TBALL_MOVE_SYS {
	
	int seq;
	int	cnt;
	int flg;
	
	BOOL active;
	
	CATS_RES_PTR	crp;
	CATS_ACT_PTR	cap;
	
	WAZATOOL_CALCMOVE_ONE	cmo;
	WAZATOOL_CALCMOVE		cm[2];
	TBALL_MOVE_DATA			bmd;
	
	TBALL_THROW_PARAM	tp;
	
	TCB_PTR	tcb;
	
} TBALL_MOVE_SYS;

#define BT_OBJ_NUM	(10)
#define BT_RES_NUM	(10)

// -----------------------------------------
//
//	c[֘A
//
// -----------------------------------------
static void BMT_ClactInit(BMS_PTR bms);
static void BMT_ClactAdd(BMS_PTR bms);
static void BMT_BallParaSet(BMS_PTR bms);
static void BMT_StartPosSet(BMS_PTR bms, s16* x, s16* y);

// -----------------------------------------
//
//	TCB֘A
//
// -----------------------------------------
static BOOL BM_Throw(BMS_PTR bms);
static BOOL BM_Shake(BMS_PTR bms);

static BOOL (* const BM_TcbTable[])(BMS_PTR wk) = {
	BM_Throw,
	BM_Shake,
};

static BOOL BM_Throw(BMS_PTR bms)
{
	switch(bms->seq){
	case 0:
		WazaTool_InitCurveYFx(&bms->cm[0],
							  &bms->cm[1], 
							  bms->tp.sx, bms->tp.ex,
							  bms->tp.sy, bms->tp.ey,
							  bms->tp.time, bms->tp.height * FX32_ONE);
		bms->seq++;
		break;

	case 1:
		if (bms->bmd.type > EBMT_STAY_D){
			CATS_ObjectRotationAddCap(bms->cap, 0x2000);
		}
		if (WazaTool_CalcAndReflectCurveFxCap(&bms->cm[0], &bms->cm[1], bms->cap) == FALSE){
			bms->seq++;
		}
		break;

	default:
		return FALSE;
		break;
	}
	return TRUE;
}

//
//	0xA360x]
//	npxAE20x܂œ]
//	̂JԂɂ\
//
//
//
static BOOL BM_Shake(BMS_PTR bms)
{
	switch(bms->seq){
	case 0:
		{
			if (bms->flg == 0){
				WazaTool_InitMoveOneSync(&bms->cmo, -FX_GET_ROTA_NUM(20), +FX_GET_ROTA_NUM(20), 5);
			}
			else {
				WazaTool_InitMoveOneSync(&bms->cmo, +FX_GET_ROTA_NUM(20), -FX_GET_ROTA_NUM(20), 5);
			}
			bms->flg ^= 1;
		}
		bms->seq++;
		break;

	case 1:
		CATS_ObjectRotationSetCap(bms->cap, bms->cmo.num);
		if (WazaTool_CalcMoveOne(&bms->cmo) == FALSE){
			if (bms->cnt >= 3){
				bms->seq++;
			}
			else {
				bms->cnt++;
				bms->seq--;
			}
		}
		break;

	default:
		return FALSE;
		break;
	}
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief	{[ړCTCB
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void BM_TcbMain(TCB_PTR tcb, void* work)
{
	BOOL state;
	
	BMS_PTR wk = (BMS_PTR)work;
	
	state = BM_TcbTable[ wk->bmd.mode ]( wk );
	
	if (state == FALSE){
		wk->active = FALSE;
	}
	
	CATS_ObjectUpdateCap(wk->cap);
	CATS_Draw(wk->crp);
}


//--------------------------------------------------------------
/**
 * @brief	{[ړ
 *
 * @param	bmd	
 *
 * @retval	BMS_PTR	
 *
 */
//--------------------------------------------------------------
BMS_PTR BM_Init(TBALL_MOVE_DATA* bmd)
{
	BMS_PTR wk = NULL;
	
	wk = sys_AllocMemory(bmd->heap_id, sizeof(TBALL_MOVE_SYS));
	
	GF_ASSERT(wk != NULL);
	
	wk->bmd = (*bmd);
	wk->seq = 0;
	wk->crp	= CATS_ResourceCreate(wk->bmd.csp);

	BMT_ClactInit(wk);
	
	BMT_ClactAdd(wk);
	
	BMT_BallParaSet(wk);
	
	wk->active = TRUE;
	
	wk->tcb = TCB_Add(BM_TcbMain, wk, TCBPRI_BALL_EFFECT);

	return wk;
}


//--------------------------------------------------------------
/**
 * @brief	{[ړI`FbN
 *
 * @param	bms	
 *
 * @retval	BOOL	
 *
 */
//--------------------------------------------------------------
BOOL BM_EndCheck(BMS_PTR bms)
{
	GF_ASSERT(bms != NULL);
	
	return bms->active ? TRUE : FALSE;
}


//--------------------------------------------------------------
/**
 * @brief	{[ړI
 *
 * @param	bms	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void BM_Delete(BMS_PTR bms)
{
	GF_ASSERT(bms != NULL);
	
	CATS_ResourceDestructor_S(bms->bmd.csp, bms->crp);
	CATS_ActorPointerDelete_S(bms->cap); 
	
	TCB_Delete(bms->tcb);
	
	sys_FreeMemoryEz(bms);
}


//--------------------------------------------------------------
/**
 * @brief	[hؑ
 *
 * @param	bms	
 * @param	mode	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void BM_ModeChange(BMS_PTR bms, int mode)
{
	bms->bmd.mode	= mode;
	bms->seq		= 0;
	bms->cnt		= 0;	
	bms->active		= TRUE;

	CATS_ObjectPosGetCap(bms->cap, &bms->tp.sx, &bms->tp.sy);
}


// -----------------------------------------
//
//	c[
//
// -----------------------------------------
static void BMT_BallParaSet(BMS_PTR bms)
{
	CATS_ObjectPosGetCap(bms->cap, &bms->tp.sx, &bms->tp.sy);

	switch(bms->bmd.type){
	case EBMT_STAY_AA:
	case EBMT_STAY_BB:
	case EBMT_STAY_A:
	case EBMT_STAY_B:
	case EBMT_STAY_C:
	case EBMT_STAY_D:
		CATS_ObjectPosGetCap(bms->cap, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 0;
		break;

	case EBMT_THROW_C:
		WazaEffPosGet_Type(0, 0, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;
		
	case EBMT_THROW_R:
		CATS_ObjectPosGetCap(bms->cap, &bms->tp.sx, &bms->tp.sy);
		WazaEffPosGet_Type(1, 0, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;
		
	case EBMT_THROW_L:
		WazaEffPosGet_Type(1, 2, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;

	case EBMT_THROW_E0:
		WazaEffPosGet_Type(0, 1, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;
		
	case EBMT_THROW_E1:
		WazaEffPosGet_Type(1, 1, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;
		
	case EBMT_THROW_E2:
		WazaEffPosGet_Type(1, 3, &bms->tp.ex, &bms->tp.ey);
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;

	case EBMT_VISUAL:
		bms->tp.ex = VISUAL_ARRIVAL_X;
		bms->tp.ey = VISUAL_ARRIVAL_Y;
		bms->tp.height	= 48;
		bms->tp.ey		+= 32;
		break;
		
	default:
		break;
	}
	bms->tp.time	= 20;
}


static void BMT_StartPosSet(BMS_PTR bms, s16* x, s16* y)
{
	switch(bms->bmd.type){
	case EBMT_STAY_AA:
		WazaEffPosGet_Type(0, 0, x, y);
		(*y) += BMT_START_POS_OFS_Y;
		break;
	case EBMT_STAY_BB:
		WazaEffPosGet_Type(0, 1, x, y);
		(*y) += BMT_START_POS_OFS_Y;
		break;
	case EBMT_STAY_A:
		WazaEffPosGet_Type(1, 0, x, y);
		(*y) += BMT_START_POS_OFS_Y;
		break;
	case EBMT_STAY_B:
		WazaEffPosGet_Type(1, 1, x, y);
		(*y) += BMT_START_POS_OFS_Y;
		break;
	case EBMT_STAY_C:
		WazaEffPosGet_Type(1, 2, x, y);
		(*y) += BMT_START_POS_OFS_Y;
		break;
	case EBMT_STAY_D:
		WazaEffPosGet_Type(1, 3, x, y);
		(*y) += BMT_START_POS_OFS_Y;
		break;

	case EBMT_THROW_C:
		*x = 10;
		*y = 100;
		break;
		
	case EBMT_THROW_R:
		*x = 10;
		*y = 100;
		break;
		
	case EBMT_THROW_L:
		*x = 10;
		*y = 100;
		break;

	case EBMT_THROW_E0:
		WazaEffPosGet_Type(0, 0, x, y);
		break;
		
	case EBMT_THROW_E1:
		WazaEffPosGet_Type(0, 0, x, y);
		break;
		
	case EBMT_THROW_E2:
		WazaEffPosGet_Type(0, 0, x, y);
		break;

	case EBMT_VISUAL:
		*x = VISUAL_TRAINER_ARRIVAL_X;
		*y = VISUAL_TRAINER_ARRIVAL_Y;
		break;
	
	default:
		break;
	}
}

static void BMT_ClactInit(BMS_PTR bms)
{
	CATS_ClactSetInit(bms->bmd.csp, bms->crp, BT_OBJ_NUM);
	
	{
		int i;
		TCATS_RESOURCE_NUM_LIST crnl;
		
		for (i = 0; i < CLACT_U_RES_MAX; i++){
			crnl.res_num[i] = BT_RES_NUM;
		}
		crnl.res_num[4] = 0;
		crnl.res_num[5] = 0;
		
		CATS_ResourceManagerInit(bms->bmd.csp, bms->crp, &crnl);
	}
	
	///< ǂݍ
	CATS_LoadResourceCharArc(bms->bmd.csp, bms->crp,
							 ARC_BATT_OBJ, BATT_M_BALL_NCGR_BIN, 1, NNS_G2D_VRAM_TYPE_2DMAIN, bms->bmd.id + BALL_ARC_ID_BASE);

	CATS_LoadResourcePlttWorkArc(bms->bmd.pfd, FADE_MAIN_OBJ,
								 bms->bmd.csp, bms->crp,
							 	 ARC_BATT_OBJ, BATT_M_BALL_NCLR, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 1, bms->bmd.id + BALL_ARC_ID_BASE);

	CATS_LoadResourceCellArc(bms->bmd.csp, bms->crp, ARC_BATT_OBJ, BATT_M_BALL_NCER_BIN, 1, bms->bmd.id + BALL_ARC_ID_BASE);

	CATS_LoadResourceCellAnmArc(bms->bmd.csp, bms->crp, ARC_BATT_OBJ, BATT_M_BALL_NANR_BIN, 1, bms->bmd.id + BALL_ARC_ID_BASE);
}

static void BMT_ClactAdd(BMS_PTR bms)
{
	int i;
	TCATS_OBJECT_ADD_PARAM_S coap;
	int defence_client;

	BMT_StartPosSet(bms, &coap.x, &coap.y);
	
	coap.z		= 0;		
	coap.anm	= 0;
	coap.pri	= 0;
	coap.pal	= 0;
	coap.d_area = CATS_D_AREA_MAIN;
	coap.bg_pri = 1;
	coap.vram_trans = 0;
	
	for (i = 0; i < CLACT_U_RES_MAX; i++){
		coap.id[i] = bms->bmd.id + BALL_ARC_ID_BASE;
	}

	bms->cap = CATS_ObjectAdd_S(bms->bmd.csp, bms->crp, &coap);
	
	CATS_ObjectAffineSetCap(bms->cap, CLACT_AFFINE_DOUBLE);
}

///// fobO
#if 0
typedef struct {
	
	int	s_cno;
	int e_cno;

	int heap_id;
	int mode;
	
	CATS_SYS_PTR		csp;
	PALETTE_FADE_PTR	pfd;
	
} TBALL_MOVE_DATA;
#endif
typedef struct {
	int seq;
	BATTLE_WORK* bw;
	BMS_PTR bms[20];
} TDBM;
static void DBM_Tcb(TCB_PTR tcb, void* work)
{
	TDBM* wk = (TDBM*)work;
	
	switch(wk->seq){
	case 0:
		{
			int i;
			TBALL_MOVE_DATA d;
			
			d.pfd = BattleWorkPfdGet(wk->bw);
			d.csp = CATS_AllocMemory(HEAPID_BATTLE);
			d.heap_id = HEAPID_BATTLE;
			d.mode = 0;
			
			for (i = EBMT_STAY_AA; i < EBMT_MAX; i++){
				d.id   = i;
				d.type = i;
				wk->bms[i] = BM_Init(&d);
			}
		}
		wk->seq++;
		break;
	case 1:
		{
			int i;
			
			for (i = EBMT_STAY_AA; i < EBMT_MAX; i++){
				if (BM_EndCheck(wk->bms[i]) == TRUE){
					return;
				}
			}
			wk->seq++;
		}
		break;
	case 2:;
		{
			int i;
			for (i = EBMT_STAY_AA; i < EBMT_MAX; i++){
				BM_ModeChange(wk->bms[i], EBMM_SHAKE);
			}
		}
		wk->seq++;
		break;
	case 3:
		if (sys.trg & PAD_BUTTON_X){
			wk->seq++;
		}
		break;
	default:
		TCB_Delete(tcb);
		sys_FreeMemoryEz(wk->bms[0]->bmd.csp);
		{
			int i;
			for (i = EBMT_STAY_AA; i < EBMT_MAX; i++){
				BM_Delete(wk->bms[i]);
			}
		}
		sys_FreeMemoryEz(wk);
		break;
	}
}
void DebugBallMoveInit(int heap, BATTLE_WORK* bw, TCB_PTR tcb, TCB_FUNC func)
{
	TDBM* wk = sys_AllocMemory(HEAPID_BATTLE, sizeof(TDBM));
	
	wk->seq	 = 0;
	wk->bw   = bw;
	
	TCB_Add(DBM_Tcb, wk, 1000);	
}
