//==============================================================================
/**
 * @file	d_tool.h
 * @brief	퓬pfobO
 * @author	goto
 * @date	2005.10.25()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#include "common.h"
#include "system/lib_pack.h"
#include "system/fontproc.h"
#include "system/pm_str.h"

#include "str_tool.h"
#include "wazaeffect/we_mana.h"
#include "system/snd_tool.h"
#include "system/msgdata.h"


#include "system/bmp_list.h"
#include "ball_effect.h"
#include "battle_particle.h"

#include "d_tool.h"
#include "d_we.h"
#include "ball_effect.h"

typedef struct {
	
	int seq;
	int heap;
	
	GF_BGL_INI*		bgl;
	BMPLIST_WORK*	lw;
	GF_BGL_BMPWIN	win;
	BATTLE_WORK*	bw;

	TCB_PTR		tcb;
	TCB_FUNC	func;
	
} DT_SYS;

typedef void (*DT_FUNC)(int, BATTLE_WORK*, TCB_PTR, TCB_FUNC);

static void DT_Tcb(TCB_PTR tcb, void* work);


static const u16 menu_lbl01[] = { B__,a__,t__,t__,l__,e__,EOM_ };
static const u16 menu_msg01[] = { wa_,za_,spc_,TE_,SU_,TO_,EOM_};
static const u16 menu_msg02[] = { BO_,bou_,RU_,spc_,TE_,SU_,TO_,EOM_};
static const u16 menu_msg03[] = { BO_,bou_,RU_,spc_,TE_,SU_,TO_,n2_,EOM_};


///fobOj[̍
static const BMPLIST_DATA DebugMenuList[] = {
	{ menu_lbl01,	BMPLIST_RABEL	},
	{ menu_msg01,	(u32)DebugWazaEffectInit	},
	{ menu_msg02,	(u32)DebugBallEffectInit	},
	{ menu_msg03,	(u32)DebugBallMoveInit		},
};

///fobOj[̃Xg
///	XgVXẽR[obNs\
static void	InfoCallBack(BMPLIST_WORK* lw,u32 param,u8 y)
{
	if(param == BMPLIST_RABEL){
		BmpListTmpColorChange(lw, 2, 1, 1);
	}else{
		BmpListTmpColorChange(lw, 4, 1, 2);
	}
}
static const BMPLIST_HEADER DebugMenuListHeader = {
	DebugMenuList,			// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	InfoCallBack,			// \Ƃ̃R[obN֐
	NULL,
	NELEMS(DebugMenuList),	// Xgڐ
	7,						// \ő區ڐ
	4,						// x\wW
	12,						// ڕ\wW
	4,						// J[\\wW
	0,						// \xW
	4,						// F
	1,						// wiF
	2,						// eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	POKE_8x16,				// w
	0,						// afJ[\(allow)\tO(0:ON,1:OFF)
};




//--------------------------------------------------------------
/**
 * @brief	j[
 *
 * @param	heap	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void DT_MenuInit(int heap, BATTLE_WORK* bw, TCB_PTR tcb, TCB_FUNC func)
{
	DT_SYS* wk = NULL;
	BMPLIST_HEADER list_h;

	GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_ON);

	wk = sys_AllocMemory(heap, sizeof(DT_SYS));

	GF_ASSERT(wk != NULL);
	
	wk->bgl	= BattleWorkGF_BGL_INIGet(bw);
	wk->func = func;
	wk->tcb  = tcb;
	wk->bw	 = bw;
	wk->heap = heap;
	
	DT_WinAdd(wk->bgl, &wk->win, BATTLE_FRAME_EFFECT, 1, 1, 15, 12, 10, 128);
	
	list_h = DebugMenuListHeader;
	list_h.win = &wk->win;
	wk->lw = BmpListSet(&list_h, 0, 1, heap);
	
	BattleGaugePriSet(bw,1);
	
	GF_BGL_BmpWinOn(&wk->win);	
	G2_SetBG2Priority(0);

	TCB_Add(DT_Tcb, wk, 0x1000);
}

//--------------------------------------------------------------
/**
 * @brief	EBhE̍쐬
 *
 * @param	bgl	
 * @param	win	
 * @param	frm	
 * @param	x	
 * @param	y	
 * @param	sx	
 * @param	sy	
 * @param	pal	
 * @param	ofs	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void DT_WinAdd(GF_BGL_INI* bgl, GF_BGL_BMPWIN* win, u8 frm, u8 x, u8 y, u8 sx, u8 sy, u8 pal, u16 ofs)
{
	GF_BGL_BmpWinAdd(bgl, win, frm, x, y, sx, sy, pal, ofs);
}


//--------------------------------------------------------------
/**
 * @brief	bZ[Ẅ揉
 *
 * @param	bgl	
 * @param	index
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void DT_MsgClear(GF_BGL_INI* bgl, GF_BGL_BMPWIN* win)
{
	GF_BGL_BmpWinDataFill(win, 0x11);
	GF_BGL_ScrClear(bgl, BATTLE_FRAME_EFFECT);
}


//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @param	bgl
 * @param	index	
 * @param	str	
 * @param	x
 * @param	y
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void DT_MsgPrint(GF_BGL_INI* bgl, GF_BGL_BMPWIN* win, STRBUF* str, u16 x, u16 y, int flag)
{	
	MSG_PRINT_HEADER	mph;
	STRBUF* strbuf = (STRBUF*)str;
	
	mph.msg			= (const u16*)strbuf;	///< 
	mph.bmpwin		= win;					///< `EBhE
	mph.msg_index	= 0;					///< bZ[WCfbNX(C}C`
	mph.fnt_index	= FONT_SYSTEM;			///< tHg

	mph.start_x		= x;					///< EChE\JnwItZbg
	mph.start_y		= y;					///< EChE\JnxItZbg
	mph.write_x		= x;					///< EChE`wItZbg(lstart_xƓ)
	mph.write_y		= y;					///< EChE`xItZbg(lstart_yƓ)
	mph.space_x		= 0;					///< Ԋuw
	mph.space_y		= 0;					///< Ԋux
	mph.style		= 0;					///< tHgX^C
	if (flag == 1){
		mph.f_col	= 4;					///< Fio[
		mph.b_col	= 1;					///< wiFio[
		mph.s_col	= 2;					///< eF@io[
	}
	else if (flag == 2){
		mph.f_col	= 2;					///< Fio[
		mph.b_col	= 1;					///< wiFio[
		mph.s_col	= 1;					///< eF@io[
	}
	else {
		mph.f_col	= 3;					///< Fio[
		mph.b_col	= 1;					///< wiFio[
		mph.s_col	= 1;					///< eF@io[
	}
	mph.dot_tbl		= 0;					///< gphbge[u
	mph.dot_wy		= 0;					///< g厞YW̕`␳l	

	GF_STR_Print( &mph, 0, NULL );
}





//--------------------------------------------------------------
/**
 * @brief	TCB
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void DT_Tcb(TCB_PTR tcb, void* work)
{
	DT_SYS* wk = (DT_SYS*)work;
	u32 ret;
	
	ret = BmpListMain(wk->lw);

	switch(ret){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		{
			TCB_PTR		c_tcb	= wk->tcb;
			TCB_FUNC	c_func	= wk->func;
			
			// --- 폜 ---
			BmpListExit(wk->lw, NULL, NULL);
			GF_BGL_BmpWinOff(&wk->win);
			GF_BGL_BmpWinDel(&wk->win);
			
			sys_FreeMemoryEz(wk);	
			G2_SetBG2Priority(1);
			TCB_Delete(tcb);
			GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_OFF);

			TCB_ChangeFunc(c_tcb, c_func);
		}
		break;
	default:
		{
			int			heap	= wk->heap;
			TCB_PTR		c_tcb	= wk->tcb;
			TCB_FUNC	c_func	= wk->func;
			BATTLE_WORK* bw		= wk->bw;
			DT_FUNC func = (DT_FUNC)ret;
			
			// --- 폜 ---
			BmpListExit(wk->lw, NULL, NULL);
			GF_BGL_BmpWinOff(&wk->win);
			GF_BGL_BmpWinDel(&wk->win);
			
			sys_FreeMemoryEz(wk);	
			G2_SetBG2Priority(1);
			TCB_Delete(tcb);
			GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_OFF);

			func(heap, bw, c_tcb, c_func);
		}
		break;
	}
}

