//==============================================================================
/**
 * @file	d_we.c
 * @brief	fobOpZGtFNg
 * @author	goto
 * @date	2005.08.08()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#include "common.h"
#include "system/lib_pack.h"
#include "system/fontproc.h"
#include "system/pm_str.h"

#include "str_tool.h"
#include "wazaeffect/we_mana.h"
#include "system/snd_tool.h"
#include "system/msgdata.h"

#include "d_we.h"

#include "d_tool.h"
#include "we_tool.h"

#include "system/fontproc.h"
#include "system/msgdata.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_goto.h"
#include "battle/wazano_def.h"

#include "system/particle.h"
#include "spl.h"
#include "system/arc_tool.h"

// -----------------------------------------
//
//	fobOp\
//
// -----------------------------------------
typedef struct _TDWE_SYS {
	int		seq;
	
	int		menu_sel;
	int		target_no;
	int		eff_no;
	int		turn_num;
	
	int 	camera;
	
//	void*	d_wk;
	WES_CALL_BTL_EX_PARAM wcbep;
	GF_BGL_BMPWIN	win;
	
	WE_SYS_PTR			wsys;
	WAZA_EFFECT_PARAM	wep;
	
	BATTLE_WORK* d_wk;
	TCB_PTR		btcb;
	TCB_FUNC	bfunc;
	
	CATS_SYS_PTR csp;	
} TDWE_SYS;

#define DWE_BUF_MAX	(4)


// =============================================================================
//
//
//	vg^Cv
//
//
// =============================================================================
static void DWE_MainTCB(TCB_PTR tcb, void* work);
static void DWE_ParamSet(int* num, int max, int flg);

static void DWE_WepSet(TDWE_SYS* wk);

// =============================================================================
//
//
//	Q
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	wk	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void DWE_WepSet(TDWE_SYS* wk)
{
	wk->wep.command_code = 0;
	wk->wep.mode		  = 0;
	wk->wep.waza_no	  = 0;
	
	wk->wep.waza_eff_damage = 0;
	wk->wep.waza_eff_power  = 0;
	wk->wep.waza_eff_cnt	 = wk->turn_num;
	
	wk->wep.waza_eff_natuki = 0;
	wk->wep.waza_eff_weather= 0;
	
	if (wk->target_no == 0){
		wk->wep.at_client_no = 0;
		wk->wep.df_client_no = 1;
	}
	else {
		wk->wep.at_client_no = 1;
		wk->wep.df_client_no = 0;
	}

	wk->wep.csp = CATS_AllocMemory(HEAPID_BATTLE);

#if 0
typedef struct{
	u8	command_code;		//߃R[hCfbNX
	u8	mode;				///< 퓬EReXgERN[H
	u16	waza_no;			///<GtFNgoZio[

	s32 waza_eff_damage;	///< ZŎ󂯂_[W(񕜂̎[ - ])

	u16	waza_eff_power;		///< oĂZ̈З
	u16 waza_eff_cnt;		///< ZGtFNg̃JE^(ԂƂ)

	u16	waza_eff_natuki;	///< Ȃx
	u16	waza_eff_weather;	///< V
	
	u16	at_client_no;		///< ŨNCAgԍ
	u16	df_client_no;		///< h䑤̃NCAgԍ
}WAZA_EFFECT_PARAM;
#endif
}


//--------------------------------------------------------------
/**
 * @brief	TCB-main
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void DWE_Draw(DWE_SYS_PTR wk)
{
	int i;
	int no = 0;
	STRBUF* str_buff[DWE_BUF_MAX];
	STRBUF* str_dest[DWE_BUF_MAX];
	STRBUF* str_camera;
	WORDSET* wset;
	DT_MsgClear(wk->wcbep.bgl, &wk->win);
	GF_BGL_BmpWinOn(&wk->win);
	
	{
		MSGDATA_MANAGER *man;
		
		man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, 
			 			    NARC_msg_debug_goto_dat, HEAPID_BATTLE);
		
		for (i = 0; i < DWE_BUF_MAX; i++){
			str_dest[i] = STRBUF_Create(255, HEAPID_BATTLE);
			str_buff[i] = MSGMAN_AllocString(man, i);
		}
		
		switch(wk->camera){
		case 0:
		case 1:
			str_camera = MSGMAN_AllocString(man, DWE_BUF_MAX + wk->camera);
			break;
		default:
			str_camera = MSGMAN_AllocString(man, DWE_BUF_MAX + 2);
			break;
		}
		
		MSGMAN_Delete(man);
	}
	
	no = 0;
	
	
	wset = WORDSET_Create(HEAPID_BATTLE);
	
	///< Ώ
	WORDSET_RegisterNumber(wset, 3, wk->target_no, 1, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
	WORDSET_ExpandStr(wset, str_dest[no], str_buff[no]);
	DT_MsgPrint(wk->wcbep.bgl, &wk->win, str_dest[no],	0*8, no*2*8, (0 == wk->menu_sel ? 1 : 0));
	no++;

	///< GtFNgԍ
	WORDSET_RegisterNumber(wset, 0, wk->eff_no, 3, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
	WORDSET_ExpandStr(wset, str_dest[no], str_buff[no]);
	DT_MsgPrint(wk->wcbep.bgl, &wk->win, str_dest[no],	0*8, no*2*8, (1 == wk->menu_sel ? 1 : 0));
	no++;

	///< GtFNg
	WORDSET_RegisterWazaName( wset, 1, wk->eff_no );
	WORDSET_ExpandStr(wset, str_dest[no], str_buff[no]);
	DT_MsgPrint(wk->wcbep.bgl, &wk->win, str_dest[no],	0*8, no*2*8, (1 == wk->menu_sel ? 1 : 0));
	no++;

	///< ^[
	WORDSET_RegisterNumber(wset, 2, wk->turn_num, 2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
	WORDSET_ExpandStr(wset, str_dest[no], str_buff[no]);
	DT_MsgPrint(wk->wcbep.bgl, &wk->win, str_dest[no],	0*8, no*2*8, (2 == wk->menu_sel ? 1 : 0));
	no++;

	///< J
	DT_MsgPrint(wk->wcbep.bgl, &wk->win, str_camera,	0*8, no*2*8, 1);
	no++;

	G2_SetBG2Priority(0);
	GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_ON);
	
	for (i = 0; i < DWE_BUF_MAX; i++){
		STRBUF_Delete(str_buff[i]);
		STRBUF_Delete(str_dest[i]);
	}
	STRBUF_Delete(str_camera);
	WORDSET_Delete(wset);
}

static void DWE_MainTCB(TCB_PTR tcb, void* work)
{
	int* param;
	int sel_max;
	int sw = 0;
	int no = 0;
	DWE_SYS_PTR wk = (DWE_SYS_PTR)work;
	
	switch(wk->seq){
	case 0:
		///< ʏ
		DT_MsgClear(wk->wcbep.bgl, &wk->win);
		BattleGaugePriSet(wk->d_wk,1);
		G2_SetBG2Priority(0);
		wk->seq++;
		
	case 1:
		///< j[\
		DWE_Draw(wk);
		wk->seq++;
	
	case 2:
		///< p[^[ݒ
		sw = 1;
		if (sys.trg & PAD_KEY_UP){
			DWE_ParamSet(&wk->menu_sel, 3, -1);
		}
		else if (sys.trg & PAD_KEY_DOWN){
			DWE_ParamSet(&wk->menu_sel, 3, +1);
		}
		else {
			sw = 0;
		}
		if (sw){
			DWE_Draw(wk);
			break;
		}
		
		///< ^[Qbg
		sw = 1;
		switch(wk->menu_sel){
		case 0:
			param	= &wk->target_no;
			sel_max = DWE_BUF_MAX;
			break;
		case 1:
			param = &wk->eff_no;
			sel_max = WAZANO_MAX + 1;//500;
			break;
		case 2:
			param = &wk->turn_num;
			sel_max = 10;
			break;
		}
		if (sys.repeat & PAD_KEY_LEFT){
			DWE_ParamSet(param, sel_max, -1);
		}
		else if (sys.repeat & PAD_KEY_RIGHT){
			DWE_ParamSet(param, sel_max, +1);
		}
		else if (sys.repeat & PAD_BUTTON_L){
			DWE_ParamSet(param, sel_max, -10);
		}
		else if (sys.repeat & PAD_BUTTON_R){
			DWE_ParamSet(param, sel_max, +10);
		}
		else if (sys.trg & PAD_BUTTON_START){
			DWE_ParamSet(param, 0, 0);
		}
		else if (sys.trg & PAD_BUTTON_X){
			wk->camera++;
			wk->camera %= 3;
			WE_SYS_CameraModeSet(wk->wsys, wk->camera);
		}
		else {
			sw = 0;
		}
		if (sw){
			DWE_Draw(wk);
			break;
		}
		
		///< R}h
		if (sys.trg & PAD_BUTTON_A){
			///< 
			GF_BGL_BmpWinOff(&wk->win);
			wk->seq++;
		}
		else if (sys.trg & PAD_BUTTON_B){
			wk->seq = 0xff;
		}
		break;
		
	case 3:
		///< GtFNg-
		BattleGaugePriSet(wk->d_wk,0);
		DWE_WepSet(wk);
		WES_Call_Ex(wk->wsys, &wk->wep, wk->eff_no, &(wk->wcbep));
		wk->seq++;
		break;
		
	case 4:
		///< GtFNg-C
		WES_Executed(wk->wsys);
		if (IsWES_Executed(wk->wsys) == FALSE){
			BattleGaugePriSet(wk->d_wk,1);
			WES_Reset(wk->wsys);
			WET_SAFE_RELEASE(wk->wep.csp);
			wk->seq++;
		}
		break;

	case 5:
		///< GtFNgI
		BattleDefaultBlendSet();
		wk->seq = 0;
		break;

	default:
		///< I
		BattleGaugePriSet(wk->d_wk,0);
		G2_SetBG2Priority(1);
		GF_BGL_BmpWinOff(&wk->win);
		GF_BGL_BmpWinDel(&wk->win);					///< bmp-winj
		WES_Delete(wk->wsys);
		TCB_ChangeFunc(wk->btcb, wk->bfunc);		///< battle-tcb̕A
		if (wk->wep.csp != NULL){
			sys_FreeMemoryEz(wk->wep.csp);			///< CSP
		}
		sys_FreeMemoryEz(wk);						///< 
		TCB_Delete(tcb);							///< tcbj
		GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_OFF);
		break;
	}
	
}


//--------------------------------------------------------------
/**
 * @brief	p[^[Zbg
 *
 * @param	num		l
 * @param	max		ől
 * @param	flg		
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void DWE_ParamSet(int* num, int max, int flg)
{
	if (flg == 0){
		*num = 0;
	}
	else if (flg < 0){
		if (*num + flg < 0){
			*num = max - 1;
		}
		else {
			*num = *num + flg;
		}
	}
	else {
		*num = *num + flg;
		*num = *num % max;
	}		
}

// =============================================================================
//
//
//	OQ
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	fobOĂяo
 *
 * @param	work	[N	
 *
 * @retval	BOOL	FALSE=s
 *
 */
//--------------------------------------------------------------
BOOL DebugWazaEffectInit(int heap, BATTLE_WORK* bw, TCB_PTR tcb, TCB_FUNC func)
{
	DWE_SYS_PTR wk = NULL;
	int i;

	GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_ON);
	
	wk = sys_AllocMemory(heap, sizeof(TDWE_SYS));
	
	if (wk == NULL){
		return FALSE;
	}

	memset(wk, 0, sizeof(TDWE_SYS));
	
	wk->wsys = WES_Create(heap);
	
	wk->csp  = BattleWorkCATS_SYS_PTRGet(bw);
	
	if (wk->wsys == NULL){
		return NULL;
	}

	TCB_ChangeFunc(tcb, NULL);

	wk->seq			= 0;
	wk->menu_sel	= 0;
	wk->target_no	= 0;
	wk->eff_no		= 0;
	wk->turn_num	= 0;
	wk->camera		= 2;
	WE_SYS_CameraModeSet(wk->wsys, wk->camera);

	wk->d_wk		= bw;
	wk->btcb		= tcb;
	wk->bfunc		= func;
	
	///< g
	wk->wcbep.bgl	= BattleWorkGF_BGL_INIGet(bw);
	wk->wcbep.fight_type = BattleWorkFightTypeGet(bw);
	wk->wcbep.mons_no[0] = 1;
	wk->wcbep.mons_no[1] = 1;
	wk->wcbep.mons_no[2] = 1;
	wk->wcbep.mons_no[3] = 1;

//	wk->wcbep.excp	= BattleWorkExChrParamGet(bw);
	for(i = 0; i < CLIENT_MAX; i++){
		wk->wcbep.excp[i] = BattleWorkExChrClientParamGet(bw, i);
	}
	wk->wcbep.pfd	= BattleWorkPfdGet(bw);
	BattleClientTypeBufMake(bw, &(wk->wcbep.client_type[0]));
	BattleSoftSpriteBufMake(bw, &(wk->wcbep.ss[0]));

	wk->wcbep.eff_arc_id = ARC_WAZA_EFF;
	wk->wcbep.haikei_data.arc_index = ARC_BATT_BG;
	wk->wcbep.haikei_data.chr_id	= BATTLE_BG00_NCGR_BIN;
	wk->wcbep.haikei_data.pal_id	= BATT_BG00_D_NCLR;
	wk->wcbep.haikei_data.scr_id	= BATTLE_BG00_NSCR_BIN;
	wk->wcbep.haikei_data.pal_start	= 0;
	wk->wcbep.haikei_data.pal_num	= 8;

	DT_WinAdd(wk->wcbep.bgl, &wk->win, BATTLE_FRAME_EFFECT, 0, 0, 28, 10, 0x0a,0x0d);
	
	G2_SetBG2Priority(0);
	
	TCB_Add(DWE_MainTCB, wk, 0x1000);
	
	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	fobOI
 *
 * @param	none	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void DebugWazaEffectDelete(void)
{
	///< Cl
}



