//==============================================================================
/**
 * @file	wazatool.c
 * @brief	ZGtFNg֘A̔ėpc[̃wb_
 * @author	matsuda
 * @date	2005.09.02()
 */
//==============================================================================
#include "common.h"
#include "system/particle.h"
#include "spl.h"
#include "battle_particle.h"
#include "we_err.h"
#include "we_tool.h"
#include "wazatool.h"

#include "contest/contest.h"



//==============================================================================
//	\̒`
//==============================================================================
typedef struct{
	s16 x;
	s16 y;
}POINT;



//--------------------------------------------------------------
/**
 * @brief   ZGtFNg^XNŎg̊m
 *
 * @param   heap_area		gpq[vGA
 * @param   size			mۂTCY
 *
 * @retval  mۂ̐擪AhX
 *
 * mۂ0NAĂ܂
 */
//--------------------------------------------------------------
void * WazaTool_AllocClearMemory(int heap_area, u32 size)
{
	void *work;
	
	work = sys_AllocMemory(heap_area, size);
	MI_CpuClear8(work, size);
	return work;
}

///ZGtFNgp n_EI_Wf[^
static const POINT WazaEffPos[][4] = 
{
	{	//FightType	1vs1
		//ClientNo
		{ APPEAR_X_TYPE_AA, APPEAR_Y_TYPE_AA },				//1
		{ APPEAR_X_TYPE_BB, APPEAR_Y_TYPE_BB },				//G1
		{ CONTEST_DEFENCE_POKE_X, CONTEST_DEFENCE_POKE_Y },	//ReXghp
		{ CONTEST_ATTACK_POKE_X,  CONTEST_ATTACK_POKE_Y },	//ReXgUp
	},
	{	//FightType 2vs2
		{ APPEAR_X_TYPE_A, APPEAR_Y_TYPE_A },		//1
		{ APPEAR_X_TYPE_B, APPEAR_Y_TYPE_B },		//G1
		{ APPEAR_X_TYPE_C, APPEAR_Y_TYPE_C },		//2
		{ APPEAR_X_TYPE_D, APPEAR_Y_TYPE_D },		//G2
	},
};

void WazaEffPosGet_Type(int fight_type, int type, s16* x, s16* y)
{
	if (x != NULL){
		*x = WazaEffPos[ fight_type ][ type ].x;
	}
	if (y != NULL){
		*y = WazaEffPos[ fight_type ][ type ].y;
	}
}

void WazaEffPosGet_ClientType(WE_SYS_PTR wsp, int client_no, s16*x, s16* y)
{
	if (WES_ContestFlag_Get(wsp) == TRUE){
		WazaEffPosGet_Type(0, client_no + 2, x, y);	
	}
	else {
		if (IsWeSysBattleMode2vs2(wsp) == TRUE){
			WazaEffPosGet_Type(1, client_no - 2, x, y);	
		}
		else {
			WazaEffPosGet_Type(0, client_no, x, y);	
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ZGtFNgn_AI_W擾
 *
 * @param   we_sys		
 * @param   client_no	NCAgNo
 * @param   get_pos		PM_??? or EFF_???
 *
 * @retval  
 *
 * POKE_* = X̃|P̑傫ɂčWςAG̑傫Ă
 *          ̊Gɂ|P̒S̍WB
 *
 * EFF_* =  |P̃ItZbg͊֌WȂŏɋʂ̒SW擾
 */
//--------------------------------------------------------------
s16 GetWazaEffPos(WE_SYS_PTR we_sys, int client_no, int get_pos)
{
	int client_type, fight_type;
	
	client_type = client_no;	//2005.09.02() ܂NCAg^Cv݂̂Ȃ̂Ŏb
	fight_type = 0;
	
	switch(get_pos){
	case PM_X:
	case EFF_X:
		return WazaEffPos[fight_type][client_type].x;
	case PM_Y:
	case EFF_Y:
		return WazaEffPos[fight_type][client_type].y;
	}
	
	GF_ASSERT(0);
	return 0;
}

//--------------------------------------------------------------
/**
 * @brief   wNCAgNõ|PAN^[̃ftHg\tgvCIeB擾
 * @param   client_no		NCAgNO
 * @retval  \tgvCIeB
 * 
 * DPł̓|P̓\tgEFAXvCgȂ̂ňӖ͂ȂǋGtFNg\[XĂׂ
 * ݊pƂėpӂ
 */
//--------------------------------------------------------------
u32 GetPokeSoftPri(u8 client_no)
{
	return WAZAEFF_ACT_SOFTPRI;
}


//--------------------------------------------------------------
/**
 * @brief   AN^[ɗ͍Č悤ɂ[N쐬
 *
 * @param   we_sys		
 * @param   csp		
 * @param   act		
 *
 * @retval  
 */
//--------------------------------------------------------------
OLDACT_WORK* OldAct_Init(WE_SYS_PTR we_sys, CATS_SYS_PTR csp, CLACT_WORK_PTR act, TCB_FUNC func)
{
	OLDACT_WORK *oldact;
	
	oldact = WazaTool_AllocClearMemory(WAZAEFF_HEAP_AREA, sizeof(OLDACT_WORK));
	oldact->we_sys = we_sys;
	oldact->csp = csp;
	oldact->act = act;
	oldact->move = func;
	
	CATS_ObjectPosGet(act, &oldact->x, &oldact->y);
	
	oldact->tcb = TCB_Add(func, oldact, 100);
	return oldact;
}

//--------------------------------------------------------------
/**
 * @brief   OLDACT_WORK̒lCLACTXV
 *
 * @param   oldact		
 *
 * eAN^[̓֐̍Ōɖt[ĂёĂ炤z肵Ă܂
 */
//--------------------------------------------------------------
void OldAct_ParamUpdate(OLDACT_WORK *oldact)
{
	CATS_ObjectPosSet(oldact->act, oldact->x + oldact->dx, oldact->y + oldact->dy);
	TCB_ChangeFunc(oldact->tcb, oldact->move);
}

//--------------------------------------------------------------
/**
 * @brief   OLDACT폜
 *
 * @param   oldact		
 */
//--------------------------------------------------------------
void OldAct_Delete(OLDACT_WORK *oldact)
{
	CATS_ObjectDel(oldact->act);
	TCB_Delete(oldact->tcb);
	sys_FreeMemoryEz(oldact);
}

//--------------------------------------------------------------
/**
 * @brief   OLDACTpSetWorkSeqڐA
 *
 * @param   oldact		
 * @param   func		
 */
//--------------------------------------------------------------
void OldAct_SetWorkSeq(OLDACT_WORK *oldact, TCB_FUNC func)
{
	oldact->next_move = func;
}

//--------------------------------------------------------------
/**
 * @brief   OLDACTpSetMoveSeqڐA
 * @param   oldact		
 */
//--------------------------------------------------------------
void OldAct_SetMoveSeq(OLDACT_WORK *oldact)
{
	oldact->move = oldact->next_move;
}

//--------------------------------------------------------------
/**
 * @brief   OLDACTœĂAN^[폜
 *
 * @param   tcb		
 * @param   work		
 *
 * @retval  
 *
 * OldAct_DeleteƂĂ鎖͓BTCB̓֐ɐݒo邩oȂÄႢ
 */
//--------------------------------------------------------------
void OldAct_DelWazaEffect(TCB_PTR tcb, void *work)
{
	OLDACT_WORK *oldact = work;
	
#if 0
	AffineDelActor(Xreg);	//add by matsuda 2002.01.18()
	DelActor(Xreg);
	WazaEffectCount--;
#else
	OldAct_Delete(oldact);
#endif
}
//-------------------------------------
//	
//	CATS_ACT_PTR̃pbgNO擾֐
//	
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *	@brief	cap̎QƂĂpbgio[擾
 *
 *	@param	cap	AN^[f[^
 *
 *	@return	pbgNO	0`15
 *
 *
 */
//-----------------------------------------------------------------------------
u8 WazaTool_CapPlttNoGet( CATS_ACT_PTR cap )
{
	return GetPlttProxyOffset( CLACT_PaletteProxyGet(cap->act), NNS_G2D_VRAM_TYPE_2DMAIN );
}


//-------------------------------------
//	
//	HuN֐pbN֐
//
//	XgƂ邩mȂߍ쐬
//	
//=====================================
//----------------------------------------------------------------------------
/**
 *	@brief	HuN֐ݒpbN֐
 *
 *	@param	func		ݒ肷HuN֐
 *	@param	work		[N
 *
 *	@retval	WAZATOOL_HBLANK_FALSE	s
 *	@retval	WAZATOOL_HBLANK_TRUE	
 */
//-----------------------------------------------------------------------------
int WazaTool_HBlankSet( INTR_FUNC func, void * work )
{
	GF_ASSERT( work );
	
	if( sys_HBlankIntrSet( func, work ) ){
		return WAZATOOL_HBLANK_TRUE;
	}

	return WAZATOOL_HBLANK_FALSE;
}

//-------------------------------------
//	GtFNg`FW
//	@Əc̃xNgԂ܂B
//	@߂l|邱ƂŁÃ̕xNgɂȂ܂B
//	@
//	@]͎n_ƏI_nĂ炢A
//	@]tɂȂlĐݒ肵܂B
//	@ꍇɂĂ͎n_̒lςƂ܂B
//	@jύXO@n0 I15 ύX@n360 I345
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *	@brief	NCAgio[XxNg擾
 *
 *	@param	we_sys			ZGtFNgVXe[N
 *	@param	client_no		NCAgio[
 *
 *	@retval	1				̕OK
 *	@retval	-1				t̃xNg
 *
 * 퓬̎TChƂłB
 *
 * ]̊֐ŕύXł܂B
 *
 */
//-----------------------------------------------------------------------------
int WazaTool_VecChangeX( WE_SYS_PTR we_sys, int client_no )
{
	int side;
	int out_put = 1;

	// ēx擾
	side = WET_SideCheck( we_sys, client_no );
		
	// ReXg`FbN
	if( WES_ContestFlag_Get( we_sys ) ){
		// ReXĝƂ
		//	TChXtxNg
		//	TChX̂܂
		if( side == SIDE_MINE ){
			out_put = -1;
		}
	}else{
		// 퓬̂Ƃ
		//	TChX̂܂
		//	TChXtxNg
		if( side == SIDE_ENEMY ){
			out_put = -1;
		}
	}

	return out_put;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	NCAgio[YxNg擾
 *
 *	@param	we_sys			ZGtFNgVXe[N
 *	@param	client_no		NCAgio[
 *
 *	@retval	1				̕OK
 *	@retval	-1				t̃xNg
 *
 * 퓬̎TChƂłB
 *
 */
//-----------------------------------------------------------------------------
int WazaTool_VecChangeY( WE_SYS_PTR we_sys, int client_no )
{
	int side;
	int out_put = 1;

	// ēx擾
	side = WET_SideCheck( we_sys, client_no );
		
	//	TChŶ܂
	//	TChYtxNg
	if( side == SIDE_ENEMY ){
		out_put = -1;
	}
	

	return out_put;
}

//-----------------------------------------------------------------------------
/**
 *		@vZ
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	߂
 *
 *	@param	a		n_
 *	@param	an		I_
 *	@param	n		VN
 *
 *	@return	
 *
 *
 */
//-----------------------------------------------------------------------------
fx32 WazaTool_GetDiff( fx32 a, fx32 an, u32 n )
{
	fx32 ans;
	
	ans = FX_Div( (an - a), n << FX32_SHIFT );

	return ans;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	diffa`anɂȂ邽߂ɕKvȃVN
 *	
 *	@param	a		n_
 *	@param	an		I_
 *	@param	diff	
 *
 *	@return	KvVN	(Βlj
 *
 * _ȉ؂グ
 *
 */
//-----------------------------------------------------------------------------
u32 WazaTool_GetDiffSync( fx32 a, fx32 an, fx32 diff )
{
	fx32 ans;
	fx32 smal;		// 

	ans = FX_Div( (an - a), diff );

	// _ȉ؂グ
	smal = FX_Modf( ans, &ans );
	if( smal ){
		ans += FX32_ONE;
	}

	ans = MATH_ABS( ans );
	
	return ans >> FX32_SHIFT;
}



//----------------------------------------------------------------------------
/**
 *	@brief	Wf֐
 *
 *	@param	p_wtc	f[^
 *	@param	cap		AN^[
 *	@param	c_x		SW
 *	@param	c_y		SW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_SetCapMatrix( WAZATOOL_CALCMOVE* p_wtc, CATS_ACT_PTR cap, s16 c_x, s16 c_y )
{
	CATS_ObjectPosSetCap( cap, c_x + p_wtc->x, c_y + p_wtc->y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	glf֐
 *
 *	@param	p_wtc	f[^
 *	@param	cap		AN^[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_SetCapScale( WAZATOOL_CALCMOVE* p_wtc, CATS_ACT_PTR cap )
{
	f32 s_x, s_y;
	WazaTool_CalcScaleRateToClactScale( p_wtc, &s_x, &s_y );
	CATS_ObjectScaleSetCap( cap, s_x, s_y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Wf֐
 *
 *	@param	p_wtc	f[^
 *	@param	ssp		\tgEFAXvCg
 *	@param	c_x		SW
 *	@param	c_y		SW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_SetSspMatrix( WAZATOOL_CALCMOVE* p_wtc, SOFT_SPRITE* ssp, s16 c_x, s16 c_y )
{
	SoftSpriteParaSet( ssp, SS_PARA_POS_X, c_x + p_wtc->x );
	SoftSpriteParaSet( ssp, SS_PARA_POS_Y, c_y + p_wtc->y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	glf֐
 *
 *	@param	p_wtc	f[^
 *	@param	ssp		\tgEFAXvCg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_SetSspScale( WAZATOOL_CALCMOVE* p_wtc, SOFT_SPRITE* ssp )
{
	SoftSpriteParaSet( ssp, SS_PARA_AFF_X, p_wtc->x );
	SoftSpriteParaSet( ssp, SS_PARA_AFF_Y, p_wtc->y );
}

//-----------------------------------------------------------------------------
/**
 *		]
 *
 *		px
 *			0x  ->0
 *			360x->65535(0xffff)
 *		łB
 *		FX_GET_ROTA_NUM(x)	( (x*0xffff) / 360 )
 *		̃}Ngp΁A擾ł܂B
 *		j
 *			FX_GET_ROTA_NUM(360) == 0xffff
 *
 *	2005/11/18 tomoya takahashi
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	]vZ
 *
 *	@param	p_wtc	vZ[N
 *	@param	r_sx	Jnpx	(0`65535) 65535360xłB
 *	@param	r_ex	Ipx	(0`65535) 65535360xłB
 *	@param	r_sy	Jnpx	(0`65535) 65535360xłB
 *	@param	r_ey	Ipx	(0`65535) 65535360xłB
 *	@param	wx		
 *	@param	wy		
 *	@param	sync	VN
 *
 *	@return	none
 *
 * X	sinJ[u
 * Y	cosJ[u
 *
 *			1]ݒł܂B
 *			̊֐Őݒ肵work[0]]񐔔{
 *			Ă
 */
//-----------------------------------------------------------------------------
void WazaTool_InitRotaFx( WAZATOOL_CALCMOVE* p_wtc, u16 r_sx, u16 r_ex, u16 r_sy, u16 r_ey, fx32 wx, fx32 wy, int sync )
{
	p_wtc->work[0] = sync;
	p_wtc->work[1] = r_sx;
	p_wtc->work[2] = wx;
	p_wtc->work[3] = r_sy;
	p_wtc->work[4] = wy;
	p_wtc->work[5] = (r_ex - r_sx) / sync;
	p_wtc->work[6] = (r_ey - r_sy) / sync;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]vZ@]x狁߂
 *
 *	@param	p_wtc
 *	@param	r_sx
 *	@param	r_ex
 *	@param	r_sy
 *	@param	r_ey
 *	@param	wx
 *	@param	wy
 *	@param	speed_x 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitRotaSpeedFx( WAZATOOL_CALCMOVE* p_wtc, u16 r_sx, u16 r_ex, u16 r_sy, u16 r_ey, fx32 wx, fx32 wy, u16 speed_x )
{
	s16 sp_x;

	GF_ASSERT(p_wtc);

	// ړݒ
	if( r_sx > r_ex ){
		speed_x = -speed_x;
	}
	sp_x = speed_x;

	//]ړf[^ݒ
	p_wtc->work[0] = WazaTool_GetDiffSync( r_sx*FX32_ONE, r_ex*FX32_ONE, sp_x*FX32_ONE );
	p_wtc->work[1] = r_sx;
	p_wtc->work[2] = wx;
	p_wtc->work[3] = r_sy;
	p_wtc->work[4] = wy;
	p_wtc->work[5] = sp_x;
	p_wtc->work[6] = (r_ey - r_sy) / p_wtc->work[0];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	]vZ
 *
 *	@param	p_wtc	vZ[N
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *	work[0]		vZ
 *	work[1]		]px		(0`65535) 65535360xłB
 *	work[2]		Uꕝ		fx32^
 *	work[3]		]px		(0`65535) 65535360xłB
 *	work[4]		Uꕝ		fx32^
 *	work[5]		]ω	(0`65535) 65535360xłB
 *	work[6]		]ω	(0`65535) 65535360xłB
 *
 * X	sinJ[u
 * Y	cosJ[u
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcRotaFx( WAZATOOL_CALCMOVE* p_wtc )
{
	fx32 x, y;
	GF_ASSERT(p_wtc);
	
	if( p_wtc->work[0] ){
		//pxω
		p_wtc->work[1] += p_wtc->work[5];
		p_wtc->work[3] += p_wtc->work[6];

		// 0`65535[v
		p_wtc->work[1] &= 0xffff;
		p_wtc->work[3] &= 0xffff;

		p_wtc->work[0]--;

		//~`
		p_wtc->x = FX_Mul( FX_SinIdx(p_wtc->work[1]), p_wtc->work[2] ) >> FX32_SHIFT;
		p_wtc->y = FX_Mul( FX_CosIdx(p_wtc->work[3]), p_wtc->work[4] ) >> FX32_SHIFT;
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf֐
 *
 *	@param	p_wtc	vZf[^
 *	@param	c_x		SW
 *	@param	c_y		SW
 *	@param	cap		AN^[
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectRotaFxCap( WAZATOOL_CALCMOVE* p_wtc, s16 c_x, s16 c_y, CATS_ACT_PTR cap )
{
	if( WazaTool_CalcRotaFx( p_wtc ) ){
		WazaTool_SetCapMatrix( p_wtc, cap, c_x, c_y );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf֐
 *
 *	@param	p_wtc	vZf[^
 *	@param	c_x		SW
 *	@param	c_y		SW
 *	@param	ssp		\tgEFAXvCg
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectRotaFxSsp( WAZATOOL_CALCMOVE* p_wtc, s16 c_x, s16 c_y, SOFT_SPRITE* ssp )
{
	if( WazaTool_CalcRotaFx( p_wtc ) ){
		WazaTool_SetSspMatrix( p_wtc, ssp, c_x, c_y );
		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 *		sړ
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 * ړXs[hŏ
 *	@brief	sړvZ֐
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	sx		ړJnW
 *	@param	ex		ړIW
 *	@param	sy		ړJnW
 *	@param	ey		ړIW
 *	@param	speed_x	Xs[h	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_InitStraightSpeed( WAZATOOL_CALCMOVE* p_wtc, s16 sx, s16 ex, s16 sy, s16 ey, u16 speed_x  )
{
	s16 sp_x;

	GF_ASSERT(p_wtc);

	// ړݒ
	if( sx > ex ){
		speed_x = -speed_x;
	}
	sp_x = speed_x;

	// ړf[^ݒ
	p_wtc->x = sx;
	p_wtc->y = sy;
	p_wtc->work[0] = WazaTool_GetDiffSync( sx*FX32_ONE, ex*FX32_ONE, sp_x*FX32_ONE );
	p_wtc->work[1] = sp_x;
	p_wtc->work[2] = WazaTool_GetDiff( sy*FX32_ONE, ey*FX32_ONE, p_wtc->work[0] ) >> FX32_SHIFT;
}

//----------------------------------------------------------------------------
/**
 * ړXs[hŏ
 *	@brief	sړvZ֐	iŒ菭gpj
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	sx		ړJnW
 *	@param	ex		ړIW
 *	@param	sy		ړJnW
 *	@param	ey		ړIW
 *	@param	speed_x	Xs[h	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_InitStraightSpeedFx( WAZATOOL_CALCMOVE* p_wtc, s16 sx, s16 ex, s16 sy, s16 ey, u16 speed_x  )
{
	s16 sp_x;

	GF_ASSERT(p_wtc);

	// ړݒ
	if( sx > ex ){
		speed_x = -speed_x;
	}
	sp_x = speed_x;

	// ړf[^ݒ
	p_wtc->x = sx;
	p_wtc->y = sy;
	p_wtc->work[0] = WazaTool_GetDiffSync( sx*FX32_ONE, ex*FX32_ONE, sp_x*FX32_ONE );
	p_wtc->work[1] = sp_x << FX32_SHIFT;
	p_wtc->work[2] = WazaTool_GetDiff( sy*FX32_ONE, ey*FX32_ONE, p_wtc->work[0] );
	p_wtc->work[3] = sx * FX32_ONE;
	p_wtc->work[4] = sy * FX32_ONE;
}

//----------------------------------------------------------------------------
/**
 * Syncŏ
 *	@brief	sړvZ֐
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	sx		ړJnW
 *	@param	ex		ړIW
 *	@param	sy		ړJnW
 *	@param	ey		ړIW
 *	@param	sync	gpVN	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_InitStraightSync( WAZATOOL_CALCMOVE* p_wtc, s16 sx, s16 ex, s16 sy, s16 ey, u16 sync  )
{
	GF_ASSERT(p_wtc);

	// ړf[^ݒ
	p_wtc->x = sx;
	p_wtc->y = sy;
	p_wtc->work[0] = sync;
	p_wtc->work[1] = WazaTool_GetDiff( sx*FX32_ONE, ex*FX32_ONE, sync ) >> FX32_SHIFT;
	p_wtc->work[2] = WazaTool_GetDiff( sy*FX32_ONE, ey*FX32_ONE, sync ) >> FX32_SHIFT;
}

//----------------------------------------------------------------------------
/**
 * Syncŏ
 *	@brief	sړvZ֐	iŒ菭gpj
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	sx		ړJnW
 *	@param	ex		ړIW
 *	@param	sy		ړJnW
 *	@param	ey		ړIW
 *	@param	sync	gpsync
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_InitStraightSyncFx( WAZATOOL_CALCMOVE* p_wtc, s16 sx, s16 ex, s16 sy, s16 ey, u16 sync )
{

	GF_ASSERT(p_wtc);

	// ړf[^ݒ
	p_wtc->x = sx;
	p_wtc->y = sy;
	p_wtc->work[0] = sync;
	p_wtc->work[1] = WazaTool_GetDiff( sx*FX32_ONE, ex*FX32_ONE, sync );
	p_wtc->work[2] = WazaTool_GetDiff( sy*FX32_ONE, ey*FX32_ONE, sync );
	p_wtc->work[3] = sx*FX32_ONE;
	p_wtc->work[4] = sy*FX32_ONE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	sړvZ
 *
 *	@param	p_wtc	vZ[N
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *	work[0]		vZ
 *	work[1]		xω
 *	work[2]		yω
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcStraight( WAZATOOL_CALCMOVE* p_wtc )
{
	GF_ASSERT(p_wtc);

	if( p_wtc->work[0] ){
		
		p_wtc->x += p_wtc->work[1];
		p_wtc->y += p_wtc->work[2];
		p_wtc->work[0] --;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	sړvZ	iŒ菭gpj
 *
 *	@param	p_wtc	vZ[N
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *	work[0]		vZ
 *	work[1]		ω		fx32^
 *	work[2]		ω		fx32^
 *	work[3]		ωl		fx32^	l͂O
 *	work[4]		ωl		fx32^	l͂O
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcStraightFx( WAZATOOL_CALCMOVE* p_wtc )
{
	GF_ASSERT(p_wtc);

	if( p_wtc->work[0] ){
		
		p_wtc->work[3] += p_wtc->work[1];
		p_wtc->work[4] += p_wtc->work[2];
		p_wtc->x	= p_wtc->work[3] >> FX32_SHIFT;
		p_wtc->y	= p_wtc->work[4] >> FX32_SHIFT;
		p_wtc->work[0] --;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf
 *
 *	@param	p_wtc	vZf[^
 *	@param	cap		AN^[
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectStraightFxCap( WAZATOOL_CALCMOVE* p_wtc, CATS_ACT_PTR cap )
{
	if( WazaTool_CalcStraightFx( p_wtc ) ){

		WazaTool_SetCapMatrix( p_wtc, cap, 0, 0 );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf
 *
 *	@param	p_wtc	vZf[^
 *	@param	ssp		\tgEFAXvCg
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectStraightFxSsp( WAZATOOL_CALCMOVE* p_wtc, SOFT_SPRITE* ssp )
{
	if( WazaTool_CalcStraightFx( p_wtc ) ){

		WazaTool_SetSspMatrix( p_wtc, ssp, 0, 0 );
		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 *		RȂړ
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	RȂړ@Y		(Œ菭gp)
 *
 *	@param	p_wtc_st		sړp[^ݒ
 *	@param	p_wtc_rt		]p[^ݒ
 *	@param	sx				n_W
 *	@param	ex				I_W
 *	@param	sy				n_W
 *	@param	ey				I_W
 *	@param	sync			vZVN
 *	@param	width			܂Ȃ̕	Y
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitCurveYFx( WAZATOOL_CALCMOVE* p_wtc_st, WAZATOOL_CALCMOVE* p_wtc_rt, s16 sx, s16 ex, s16 sy, s16 ey, u16 sync, fx32 width )
{
	// sړݒ
	WazaTool_InitStraightSyncFx( p_wtc_st, sx, ex, sy, ey, sync );
	
	// ]ݒ
	p_wtc_rt->x = 0;
	p_wtc_rt->y	= 0;
	WazaTool_InitRotaFx( p_wtc_rt, 
			0, 0,
			FX_GET_ROTA_NUM(90), FX_GET_ROTA_NUM(270),
			0, width, sync );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	RȂړ@		(Œ菭gp)
 *
 *	@param	p_wtc_st		sړp[^ݒ
 *	@param	p_wtc_rt		]p[^ݒ
 *	@param	sx				n_W
 *	@param	ex				I_W
 *	@param	sy				n_W
 *	@param	ey				I_W
 *	@param	sync			vZVN
 *	@param	width			܂Ȃ̕	X
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitCurveXFx( WAZATOOL_CALCMOVE* p_wtc_st, WAZATOOL_CALCMOVE* p_wtc_rt, s16 sx, s16 ex, s16 sy, s16 ey, u16 sync, fx32 width )
{
	// sړݒ
	WazaTool_InitStraightSyncFx( p_wtc_st, sx, ex, sy, ey, sync );
	
	// ]ݒ
	p_wtc_rt->x = 0;
	p_wtc_rt->y	= 0;
	WazaTool_InitRotaFx( p_wtc_rt, 
			FX_GET_ROTA_NUM(0), FX_GET_ROTA_NUM(180),
			0, 0,
			width, 0, sync );
}

//----------------------------------------------------------------------------
/**
 * sړƉ]̂킹Z
 *	@brief	RȂړvZ	iŒ菭gpj
 *
 *	@param	p_wtc_st	sړvZ[N	(C)
 *	@param	p_wtc_rt	]vZ[N		(Tu)
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *	p_wtc_stx,yWvZʂɂȂ܂B
 *	p_wtc_rtx,y0ŏĂB
 *
 * p_wtc_st	sړp
 *	x			Ŝ̂WvZ
 *	y			Ŝ̂WvZ
 *	work[0]		vZ
 *	work[1]		ω		fx32^
 *	work[2]		ω		fx32^
 *	work[3]		ωl		fx32^	l͂O
 *	work[4]		ωl		fx32^	l͂O
 *
 * p_wtc_rt	]p
 *	x			]݂̂̌vZ
 *	y			]݂̂̌vZ
 *	work[0]		vZ
 *	work[1]		]px		(0`65535) 65535360xłB
 *	work[2]		Uꕝ		fx32^
 *	work[3]		]px		(0`65535) 65535360xłB
 *	work[4]		Uꕝ		fx32^
 *	work[5]		]ω	(0`65535) 65535360xłB
 *	work[6]		]ω	(0`65535) 65535360xłB
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcCurveFx( WAZATOOL_CALCMOVE* p_wtc_st, WAZATOOL_CALCMOVE* p_wtc_rt )
{
	BOOL st_end, rt_end;
	
	GF_ASSERT(p_wtc_st);
	GF_ASSERT(p_wtc_rt);

	// sړvZ
	st_end = WazaTool_CalcStraightFx( p_wtc_st );
	// RȂvZ
	rt_end = WazaTool_CalcRotaFx( p_wtc_rt );

	// sړƉ]̉Z
	p_wtc_st->x += p_wtc_rt->x;
	p_wtc_st->y += p_wtc_rt->y;

	// vZI`FbN
	if( (st_end == rt_end) && (st_end == FALSE) ){
		return FALSE;
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf
 *
 *	@param	p_wtc_st	ړp
 *	@param	p_wtc_rt	]p
 *	@param	cap			AN^[
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectCurveFxCap( WAZATOOL_CALCMOVE* p_wtc_st, WAZATOOL_CALCMOVE* p_wtc_rt, CATS_ACT_PTR cap )
{
	if( WazaTool_CalcCurveFx( p_wtc_st, p_wtc_rt ) ){

		WazaTool_SetCapMatrix( p_wtc_st, cap, 0, 0 );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf
 *
 *	@param	p_wtc_st	ړf[^
 *	@param	p_wtc_rt	]f[^
 *	@param	ssp			\tgEFAXvCg
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectCurveFxSsp( WAZATOOL_CALCMOVE* p_wtc_st, WAZATOOL_CALCMOVE* p_wtc_rt, SOFT_SPRITE* ssp )
{
	if( WazaTool_CalcCurveFx( p_wtc_st, p_wtc_rt ) ){
		WazaTool_SetSspMatrix( p_wtc_st, ssp, 0, 0 );
		return TRUE;
	}

	return FALSE;
}


//WAZATOOL_CALCMOVE_ONE\̗p֐S
//----------------------------------------------------------------------------
/**
 *
 *	@brief	P̒l𓙍œ֐@iVNwj
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	a		Jnl
 *	@param	an		Il
 *	@param	sync	VN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitMoveOneSync( WAZATOOL_CALCMOVE_ONE* p_wtc, s32 a, s32 an, u32 sync )
{
	GF_ASSERT( p_wtc );
	
	p_wtc->num = a;
	p_wtc->work[0] = sync;
	p_wtc->work[1] = WazaTool_GetDiff( a*FX32_ONE, an*FX32_ONE, sync ) >> FX32_SHIFT;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	P̒l𓙍œ֐@iXs[hwj
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	a		Jnl
 *	@param	an		Il
 *	@param	speed	Xs[h
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitMoveOneSpeed( WAZATOOL_CALCMOVE_ONE* p_wtc, s32 a, s32 an, s16 speed )
{
	GF_ASSERT( p_wtc );
	
	p_wtc->num = a;
	p_wtc->work[0] = WazaTool_GetDiffSync( a*FX32_ONE, an*FX32_ONE, speed * FX32_ONE );
	p_wtc->work[1] = speed;
}

//----------------------------------------------------------------------------
/**
 *Œ菭
 *	@brief	P̒l𓙍œ֐@iVNwj
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	a		Jnl
 *	@param	an		Il
 *	@param	sync	VN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitMoveOneSyncFx( WAZATOOL_CALCMOVE_ONE* p_wtc, s16 a, s16 an, u32 sync )
{
	GF_ASSERT( p_wtc );
	
	p_wtc->num = a;
	p_wtc->work[0] = sync;
	p_wtc->work[1] = WazaTool_GetDiff( a*FX32_ONE, an*FX32_ONE, sync );
	p_wtc->work[2] = a * FX32_ONE;
}

//----------------------------------------------------------------------------
/**
 *Œ菭
 *	@brief	P̒l𓙍œ֐@iXs[hwj
 *
 *	@param	p_wtc	f[^ݒ
 *	@param	a		Jnl
 *	@param	an		Il
 *	@param	speed	Xs[h
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitMoveOneSpeedFx( WAZATOOL_CALCMOVE_ONE* p_wtc, s16 a, s16 an, fx32 speed )
{
	GF_ASSERT( p_wtc );
	
	p_wtc->num = a;
	p_wtc->work[0] = WazaTool_GetDiffSync( a*FX32_ONE, an*FX32_ONE, speed * FX32_ONE );
	p_wtc->work[1] = speed * FX32_ONE;
	p_wtc->work[2] = a * FX32_ONE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	1̒l̓vZ
 *
 *	@param	p_wtc	[N
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *	work[0]		vZ
 *	work[1]		ω	
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcMoveOne( WAZATOOL_CALCMOVE_ONE* p_wtc )
{
	GF_ASSERT(p_wtc);

	if( p_wtc->work[0] ){
		p_wtc->num	+= p_wtc->work[1];
		p_wtc->work[0] --;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *Œ菭
 *	@brief	1̒l̓vZ
 *
 *	@param	p_wtc	[N
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *	work[0]		vZ
 *	work[1]		ω	
 *	work[2]		܂łɕω
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcMoveOneFx( WAZATOOL_CALCMOVE_ONE* p_wtc )
{
	GF_ASSERT(p_wtc);

	if( p_wtc->work[0] ){
		p_wtc->work[2] += p_wtc->work[1];
		p_wtc->num	= p_wtc->work[2] >> FX32_SHIFT;
		p_wtc->work[0] --;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TCgvZ֐
 *
 *	@param	p_wtc		vZp[^i[
 *	@param	s_r			Jn]p
 *	@param	e_r			I]p
 *	@param	w			őӂ蕝
 *	@param	sync		VN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_InitSinCosOneSyncFx( WAZATOOL_CALCMOVE_ONE* p_wtc, u16 s_r, u16 e_r, fx32 w, u32 sync )
{
	p_wtc->work[0] = sync;
	p_wtc->work[1] = s_r;
	p_wtc->work[2] = w;
	p_wtc->work[3] = (e_r - s_r) / sync;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	singvZ
 *
 *	@param	p_wtc	vZf[^
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcSinOne( WAZATOOL_CALCMOVE_ONE* p_wtc )
{
	GF_ASSERT(p_wtc);
	
	if( p_wtc->work[0] ){
		//pxω
		p_wtc->work[1] += p_wtc->work[3];

		// 0`65535[v
		p_wtc->work[1] &= 0xffff;

		p_wtc->work[0]--;

		//~`
		p_wtc->num = FX_Mul( FX_SinIdx(p_wtc->work[1]), p_wtc->work[2] ) >> FX32_SHIFT;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	cosgvZ
 *
 *	@param	p_wtc	vZf[^
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcCosOne( WAZATOOL_CALCMOVE_ONE* p_wtc )
{
	GF_ASSERT(p_wtc);
	
	if( p_wtc->work[0] ){
		//pxω
		p_wtc->work[1] += p_wtc->work[3];

		// 0`65535[v
		p_wtc->work[1] &= 0xffff;

		p_wtc->work[0]--;

		//~`
		p_wtc->num = FX_Mul( FX_CosIdx(p_wtc->work[1]), p_wtc->work[2] ) >> FX32_SHIFT;

		return TRUE;
	}

	return FALSE;
}


//--------------------------------------------------------------
/**
 * @brief	gk
 *
 * @param	p_wtc	
 * @param	ss				JnXP[
 * @param	ds				ʏXP[
 * @param	es				IXP[
 * @param	sync			t[
 *
 * @retval	none	
 *
 *		0x100(256) = 100%
 *
 */
//--------------------------------------------------------------
#define SCALE_RATE_PER(p1, p2)	( ((p1) * 0x100) / p2 )
void WazaTool_InitScaleRate(WAZATOOL_CALCMOVE* p_wtc, s16 ss, s16 ds, s16 es, u32 sync)
{
	WAZATOOL_CALCMOVE* wk; 
	
	GF_ASSERT(p_wtc);
	
	wk = p_wtc;
	
	wk->work[0] = sync;			///< 鎞
	
	///< g嗦
	wk->work[1] = WazaTool_GetDiff(SCALE_RATE_PER(ss, ds) * FX32_ONE,
								   SCALE_RATE_PER(es, ds) * FX32_ONE, sync);

	///< ݂̊g嗦x,y
	wk->x = SCALE_RATE_PER(ss, ds);
	wk->y = SCALE_RATE_PER(ss, ds);
	wk->work[3] = wk->x * FX32_ONE;
	wk->work[4] = wk->y * FX32_ONE;
}


//--------------------------------------------------------------
/**
 * @brief	gks
 *
 * @param	p_wtc	
 *
 * @retval	BOOL	
 *
 */
//--------------------------------------------------------------
BOOL WazaTool_CalcScaleRate(WAZATOOL_CALCMOVE* p_wtc)
{
	WAZATOOL_CALCMOVE* wk; 
	
	GF_ASSERT(p_wtc);
	
	wk = p_wtc;

	if (wk->work[0]){
		wk->work[0]--;
		wk->work[3] += wk->work[1];
		wk->work[4] += wk->work[1];
		wk->x = (wk->work[3] >> FX32_SHIFT);
		wk->y = (wk->work[4] >> FX32_SHIFT);
		
		return TRUE;
	}
	
	return FALSE;
}


//--------------------------------------------------------------
/**
 * @brief	gkXYf
 *
 * @param	p_wtc		ėp
 * @param	sx			JnXP[X
 * @param	ex			IXP[X
 * @param	sy			JnXP[Y
 * @param	ey			IXP[Y
 * @param	ds			{l
 * @param	sync		VN
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_InitScaleRateEx(WAZATOOL_CALCMOVE* p_wtc, s16 sx, s16 ex, s16 sy, s16 ey, s16 ds, u32 sync)
{
	WAZATOOL_CALCMOVE* wk; 
	
	GF_ASSERT(p_wtc);
	
	wk = p_wtc;
	
	wk->work[0] = sync;			///< 鎞
	
	///< g嗦
	wk->work[1] = WazaTool_GetDiff(SCALE_RATE_PER(sx, ds) * FX32_ONE,
								   SCALE_RATE_PER(ex, ds) * FX32_ONE, sync);
	
	wk->work[2] = WazaTool_GetDiff(SCALE_RATE_PER(sy, ds) * FX32_ONE,
								   SCALE_RATE_PER(ey, ds) * FX32_ONE, sync);

	///< ݂̊g嗦x,y
	wk->x = SCALE_RATE_PER(sx, ds);
	wk->y = SCALE_RATE_PER(sy, ds);
	wk->work[3] = wk->x * FX32_ONE;
	wk->work[4] = wk->y * FX32_ONE;
}


//--------------------------------------------------------------
/**
 * @brief	gkAXYf
 *
 * @param	p_wtc	
 *
 * @retval	BOOL	
 *
 */
//--------------------------------------------------------------
BOOL WazaTool_CalcScaleRateEx(WAZATOOL_CALCMOVE* p_wtc)
{
	WAZATOOL_CALCMOVE* wk; 
	
	GF_ASSERT(p_wtc);
	
	wk = p_wtc;

	if (wk->work[0]){
		wk->work[0]--;
		wk->work[3] += wk->work[1];
		wk->work[4] += wk->work[2];
		wk->x = (wk->work[3] >> FX32_SHIFT);
		wk->y = (wk->work[4] >> FX32_SHIFT);
		return TRUE;
	}
	
	return FALSE;
}


//--------------------------------------------------------------
/**
 * @brief	gkp[^[ϊ
 *
 * @param	p_wtc	
 * @param	x	
 * @param	y	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_CalcScaleRateToClactScale(WAZATOOL_CALCMOVE* p_wtc, f32* x, f32* y)
{
	*x = (1.0f * p_wtc->x) / 0x0100;
	*y = (1.0f * p_wtc->y) / 0x0100;
}


//--------------------------------------------------------------
/**
 * @brief	{WAAXP[␳W߂
 *
 * @param	def_y		{W
 * @param	poke_h		
 * @param	sy			XP[l
 *
 * @retval	s16	
 *
 */
//--------------------------------------------------------------
s16 WazaTool_CalcScaleRateToYPos(s16 def_y, int poke_h, u32 sy)
{
	fx32 pos = (80 - (poke_h * 2)) * FX32_ONE;
	fx32 tmp;
	s16  ofs;
	
	tmp = (pos - ((pos * sy) / 0x100)) / 2;
	ofs = tmp >> FX32_SHIFT;

	return ofs;
}


//--------------------------------------------------------------
/**
 * @brief	{WAAXP[␳W߂
 *
 * @param	def_y		{W
 * @param	poke_h		
 * @param	sy			XP[l
 *
 * @retval	s16
 *
 */
//--------------------------------------------------------------
s16	WazaTool_CalcScaleRateToYPosFX(s16 def_y, int poke_h, fx32 sy)
{
	fx32 pos = (80 - (poke_h * 2)) * FX32_ONE;
	fx32 def = 0x0100 * FX32_ONE;
	fx32 tmp;
	fx32 mul;
	fx32 div;
	s16  ofs;
	
	mul = FX_Mul(pos, sy);
	div = FX_Div(mul, def);
	tmp = (pos - div);
#if 1
	{
		fx32 integer;
		fx32 decimal;
		decimal = FX_Modf(tmp, &integer);
		if (decimal){
			decimal += FX32_HALF;
		}
		tmp = integer + decimal;
	}
#endif
	
	ofs = (tmp >> FX32_SHIFT) / 2;
	
	return ofs;
}

//--------------------------------------------------------------
/**
 * @brief	\tgEFAXvCgɕ␳n𔽉f
 *
 * @param	ssp	
 * @param	def_y	
 * @param	poke_height	
 * @param	scale	
 * @param	mode			[h	EOFS_MODE Q
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_PokeOffsetSet(SOFT_SPRITE* ssp, s16 def_y, s16 poke_height, fx32 scale, int mode)
{
	s16 ofs_y;
	s16 def;
	
	def   = def_y;
	ofs_y = WazaTool_CalcScaleRateToYPosFX(def_y, poke_height, scale);
	
	if (mode == WAZAEFF_OFS_MODE_TOP){
		ofs_y *= -1;
		def = def_y - poke_height;
	}
	
	SoftSpriteParaSet(ssp, SS_PARA_POS_Y, def + ofs_y);
}

void WazaTool_PokeOffsetSetOAM(CATS_ACT_PTR cap, s16 def_y, s16 poke_height, fx32 scale, int mode)
{
	s16 ofs_y;
	s16 def;
	s16 dx;
	s16 dy;
	
	def   = def_y;
	ofs_y = WazaTool_CalcScaleRateToYPosFX(def_y, poke_height, scale);
	
	if (mode == WAZAEFF_OFS_MODE_TOP){
		ofs_y *= -1;
		def = def_y - poke_height;
	}

	CATS_ObjectPosGetCap(cap, &dx, &dy);
	CATS_ObjectPosSetCap(cap, dx,  def + ofs_y);
}


//----------------------------------------------------------------------------
/**
 *	@brief	vZf
 *
 *	@param	p_wtc	f[^
 *	@param	cap		AN^[
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectScaleRateCap( WAZATOOL_CALCMOVE* p_wtc, CATS_ACT_PTR cap )
{
	if( WazaTool_CalcScaleRate( p_wtc ) ){
		WazaTool_SetCapScale( p_wtc, cap );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	vZf
 *
 *	@param	p_wtc	f[^
 *	@param	ssp		\tgEFAXvCg
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectScaleRateSsp( WAZATOOL_CALCMOVE* p_wtc, SOFT_SPRITE* ssp )
{
	if( WazaTool_CalcScaleRate( p_wtc ) ){
		WazaTool_SetSspScale( p_wtc, ssp );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	vZf
 *
 *	@param	p_wtc	f[^
 *	@param	cap		AN^[
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectScaleRateExCap( WAZATOOL_CALCMOVE* p_wtc, CATS_ACT_PTR cap )
{
	if( WazaTool_CalcScaleRateEx( p_wtc ) ){
		WazaTool_SetCapScale( p_wtc, cap );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	vZf
 *
 *	@param	p_wtc	f[^
 *	@param	ssp		\tgEFAXvCg
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectScaleRateExSsp( WAZATOOL_CALCMOVE* p_wtc, SOFT_SPRITE* ssp )
{
	if( WazaTool_CalcScaleRateEx( p_wtc ) ){
		WazaTool_SetSspScale( p_wtc, ssp );
		return TRUE;
	}

	return FALSE;
}


//--------------------------------------------------------------
/**
 * @brief	ݏ󋵂ƁA1Ȍ󋵂Uʒu߂֐
 *
 * @param	now			
 * @param	befor		1O
 * @param	p			ӂ蕝
 *
 * @retval	static inline void	
 *
 */
//--------------------------------------------------------------
static inline void WazaTool_ShakeTool(s16* now, s32* befor, s32 p)
{
	s32 temp = *befor;
	*befor = *now;
	
	if (temp == 0){
		*now = 0;
	}
	else {
		*now = temp *= -1;
	}
}


//--------------------------------------------------------------
/**
 * @brief	ȈՃVFCN
 *
 * @param	p_wtc	
 * @param	x			x̂ӂ蕝
 * @param	y			ŷӂ蕝
 * @param	sync		h炷^C~O
 * @param	num			h炷
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_InitShake(WAZATOOL_CALCMOVE* p_wtc, s16 x, s16 y, u32 sync, u32 num)
{
	WAZATOOL_CALCMOVE* wk; 
	
	GF_ASSERT(p_wtc);
	
	wk = p_wtc;
	
	wk->work[0] = sync;
	wk->work[1] = sync;
	wk->work[2] = num;
	
	wk->work[3] = 0;			///< EE 1Zbg
	
	wk->work[4] = x;
	wk->work[5] = y;
	
	wk->work[6] = x * -1;		///< 1Ȍ
	wk->work[7] = y * -1;		///< 1Ȍ

	wk->x = 0;
	wk->y = 0;	
}


//--------------------------------------------------------------
/**
 * @brief	h炵
 *
 * @param	p_wtc	
 *
 * @retval	BOOL	
 *
 */
//--------------------------------------------------------------
BOOL WazaTool_CalcShake(WAZATOOL_CALCMOVE* p_wtc)
{
	WAZATOOL_CALCMOVE* wk; 
	
	GF_ASSERT(p_wtc);
	
	wk = p_wtc;
	
	if (wk->work[2]){
		
		wk->work[0]++;
		if (wk->work[0] >= wk->work[1]){
			wk->work[0] = 0;
			WazaTool_ShakeTool(&wk->x, &wk->work[6], wk->work[4]);
			WazaTool_ShakeTool(&wk->y, &wk->work[7], wk->work[5]);
			if ((++wk->work[3]) >= 4){
				wk->work[3] = 0;
				wk->work[2]--;
			}
		}
		
		return TRUE;
	}
	
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf
 *
 *	@param	p_wtc	vZf[^
 *	@param	c_x		SW
 *	@param	c_y		SW
 *	@param	cap		AN^[
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectShakeCap( WAZATOOL_CALCMOVE* p_wtc, s16 c_x, s16 c_y, CATS_ACT_PTR cap )
{
	if( WazaTool_CalcShake( p_wtc ) ){
		WazaTool_SetCapMatrix( p_wtc, cap, c_x, c_y );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	vZf
 *
 *	@param	p_wtc	vZf[^
 *	@param	c_x		SW
 *	@param	c_y		SW
 *	@param	ssp		XvCg
 *
 *	@retval	TRUE	r
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcAndReflectShakeSsp( WAZATOOL_CALCMOVE* p_wtc, s16 c_x, s16 c_y, SOFT_SPRITE* ssp )
{
	if( WazaTool_CalcShake( p_wtc ) ){
		WazaTool_SetSspMatrix( p_wtc, ssp, c_x, c_y );
		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	cf[^p_wtzɐݒ肵܂B
 *
 *	@param	p_wtz		cf[^i[
 *	@param	p_wtc		f[^ieWazaTool_Init`֐ŏ́j
 *	@param	p_func		֐
 *	@param	x			ړ̊ƂȂ邘W
 *	@param	y			ړ̊ƂȂ邙W
 *	@param	wait		c\Ă^C~O
 *	@param	zanzou_num	c̐		Pȏ
 *	@param	type		Wɔf邩gkɔf邩
 *	@param	cap_00		cOAMO
 *	@param	cap_01		cOAMP		c̐Pȉ̎@NULL
 *	@param	cap_02		cOAMQ		c̐Qȉ̎@NULL
 *	@param	cap_03		cOAMR		c̐Rȉ̎@NULL
 *
 *	@return	none
 *
 * type		cf^Cv
	WAZATOOL_ZANZOU_TYPE_MATRIX,	// ^Cv	W
	WAZATOOL_ZANZOU_TYPE_SCALE,		// ^Cv	gk
 * 
 */
//-----------------------------------------------------------------------------
void WazaTool_InitZanzou( WAZATOOL_ZANZOU* p_wtz, WAZATOOL_CALCMOVE* p_wtc, WAZATOOL_CALCFUNC p_func, s16 x, s16 y, u16 wait, u8 zanzou_num, u8 type, CATS_ACT_PTR cap_00, CATS_ACT_PTR cap_01, CATS_ACT_PTR cap_02, CATS_ACT_PTR cap_03 )
{
	int i;		// [vp
	
	// f[^ݒ
	p_wtz->x = x;
	p_wtz->y = y;
	p_wtz->move_func	= p_func;
	p_wtz->wait			= wait;
	p_wtz->count		= 0;
	p_wtz->zanzou_num	= zanzou_num;
	p_wtz->zanzou_move	= 0;
	p_wtz->type			= type;
	for( i=0; i<zanzou_num; i++ ){
		p_wtz->move_param[ i ] = *p_wtc;
	}
	p_wtz->cap[ WAZATOOL_ZANZOU_0 ] = cap_00;
	p_wtz->cap[ WAZATOOL_ZANZOU_1 ] = cap_01;
	p_wtz->cap[ WAZATOOL_ZANZOU_2 ] = cap_02;
	p_wtz->cap[ WAZATOOL_ZANZOU_3 ] = cap_03;

	// c̕\OFF
	for( i=0; i<p_wtz->zanzou_num; i++ ){
		CATS_ObjectEnableCap( p_wtz->cap[i], FALSE );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	c̓p[^ύX
 *
 *	@param	p_wtz		cf[^
 *	@param	p_wtc		ݒ蓮f[^
 *	@param	p_func		ݒ蓮֐
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_ChangeMoveZanzou( WAZATOOL_ZANZOU* p_wtz, WAZATOOL_CALCMOVE* p_wtc, WAZATOOL_CALCFUNC p_func )
{
	int i;

	p_wtz->move_func	= p_func;
	for( i=0; i<p_wtz->zanzou_num; i++ ){
		p_wtz->move_param[ i ] = *p_wtc;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	c𓮍삳
 *
 *	@param	p_wtz		cf[^
 *
 *	@retval	TRUE		r
 *	@retval	FALSE		
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_CalcZanzou( WAZATOOL_ZANZOU* p_wtz )
{
	int i;
	BOOL ret[WAZATOOL_ZANZOU_MAX];
	f32 s_x, s_y;

	// ϐ
	for( i=0; i<WAZATOOL_ZANZOU_MAX; i++ ){
		ret[i] = TRUE;
	}
	
	// o^
	if( p_wtz->wait <= p_wtz->count ){

		// P̓Jn
		CATS_ObjectEnableCap( p_wtz->cap[ p_wtz->zanzou_move ], TRUE );
		p_wtz->zanzou_move++;
		p_wtz->count = 0;
	}

	// o^^C~OJEg
	if( p_wtz->zanzou_move < p_wtz->zanzou_num ){
		p_wtz->count++;
	}
	
	// 쏈
	for( i=0; i<p_wtz->zanzou_move; i++ ){
		
		// vZ	
		ret[ i ] = p_wtz->move_func( &p_wtz->move_param[ i ] );

		// f
		if( ret[ i ] ){
			// 쒆͒l̍XV
			if( p_wtz->type == WAZATOOL_ZANZOU_TYPE_MATRIX ){
				CATS_ObjectPosSetCap( p_wtz->cap[ i ], p_wtz->x + p_wtz->move_param[ i ].x, p_wtz->y + p_wtz->move_param[ i ].y );
			}else{

				// CalcScaleRategpĂƂ
				WazaTool_CalcScaleRateToClactScale( &p_wtz->move_param[ i ], &s_x, &s_y );
				CATS_ObjectScaleSetCap( p_wtz->cap[ i ],
						s_x, s_y);
			}
		}else{
			// 슮\OFF
			CATS_ObjectEnableCap( p_wtz->cap[ i ], FALSE );
		}
	}

	// I`FbN
	for( i=0; i<p_wtz->zanzou_num; i++ ){

		// ܂vZr̃IuWFNg邩`FbN
		if( ret[i] == TRUE ){	
			return TRUE;
		}
	}
		
	// ret[]̒gSFALSEȂSvZ
	return FALSE;
}


//-------------------------------------
//	
//	ėpIɎg铮샏[N
//	쐬֐S
//
//	]ړȂǂ͋ʂ̓邱Ƃߍ쐬
//	
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *	@brief	]ړ̃ftHgݒ
 *
 *	@param	p_wtc		vZf[^i[
 *	@param	rota_num	]
 *	@param	sync		1]VN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WazaTool_MakeDefRota( WAZATOOL_CALCMOVE* p_wtc, int rota_num, int rota_one_sync )
{
	int vec_x;
	
	WazaTool_InitRotaFx( p_wtc,
			0, FX_GET_ROTA_NUM(360),
			0, FX_GET_ROTA_NUM(360),
			WAZATOOL_DEF_ROTA_W_X,
			WAZATOOL_DEF_ROTA_W_Y,
			rota_one_sync);

	p_wtc->work[0] *= rota_num;
}


//-------------------------------------
//	
//	alphatF[h^XN
//	
//=====================================
//tF[h^XN
static void WazaTool_TskAlphaFade( TCB_PTR tcb, void* work )
{
	BOOL check;
	WAZATOOL_ALPHA_FADE* wk = work;

	// vZ
	check = WazaTool_CalcStraightFx( &wk->wtc );

	// I`FbN
	if( check == FALSE ){

		wk->end_flag = TRUE;
		TCB_Delete( tcb );
	}else{

		// }CiX͂O
		if( wk->wtc.x < 0 ){
			wk->wtc.x = 0;
		}
		if( wk->wtc.y < 0 ){
			wk->wtc.y = 0;
		}
		
		// f
		G2_ChangeBlendAlpha( wk->wtc.x, wk->wtc.y );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	At@tF[h^XNJn
 *
 *	@param	p_alfd	f[^i[
 *	@param	sev1	Ώ̖ʂP̊JnW
 *	@param	eev1	Ώ̖ʂP̏IW
 *	@param	sev2	Ώ̖ʂQ̊JnW
 *	@param	eev2	Ώ̖ʂQ̏IW
 *	@param	sync	gpVN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_StartAlphaFade( WAZATOOL_ALPHA_FADE* p_alfd, s16 sev1, s16 eev1, s16 sev2, s16 eev2, int sync )
{
	// ωp[^ݒ
	WazaTool_InitStraightSyncFx( &p_alfd->wtc, sev1, eev1, sev2, eev2, sync );

	// ItO
	p_alfd->end_flag = FALSE;

	// ^XN
	TCB_Add( WazaTool_TskAlphaFade, p_alfd, 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	At@tF[h^XNI`FbN
 *
 *	@param	p_alfd	At@tF[h^XN[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WazaTool_EndCheckAlphaFade( const WAZATOOL_ALPHA_FADE* p_alfd )
{
	return p_alfd->end_flag;
}

//-----------------------------------------------------------------------------
/**
 *		X^[pVXe
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	HDMARg[
//	
//=====================================
typedef void (*pWazaTool_LSVBCFunc)( void* work );
// 1/30 Jo[VXe
typedef struct _WAZATOOL_LASTER_VBLANK_CONT{
	TCB_PTR		vdma_tcb;
	TCB_PTR		vbuff_tcb;
	BOOL vblank_lst_flg;// VBlankōss̃tO
	BOOL dma_set_flg;	//C[vVu`FbNtO
	
	pWazaTool_LSVBCFunc	vblank1;	// ROt[̒ʏVuNp
	pWazaTool_LSVBCFunc	vblank2;	// rVuNp
	void * work;
} WAZATOOL_LSVBC;

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ʏVuN
 *
 *	@param	tcb		TCB[N
 *	@param	work	[N
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_LSVBC_VBlank1( TCB_PTR tcb, void* work )
{
	WAZATOOL_LSVBC* wk = work;
	
	if( wk->vblank_lst_flg ){
		// VuNԒDMAݒs
		// Qڂ͂ōŝłPڂC[v
		// ȂłVuNԒɂĂ炤
		wk->dma_set_flg = TRUE;

		// ʏVuN
		wk->vblank1( wk->work );

	}else{
		LASTER_DmaStop();
	}
}
//----------------------------------------------------------------------------
/**
 *
 *	@brief	rɓVuNԗp֐
 *
 *	@param	tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_LSVBC_VBlank2( TCB_PTR tcb, void* work )
{
	WAZATOOL_LSVBC* wk = work;
	
	if( wk->vblank_lst_flg && wk->dma_set_flg ){

		// rVuN
		wk->vblank2( wk->work );
		
		wk->dma_set_flg = FALSE;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[VuNVXe
 *
 *	@param	p_lsvbc		X^[VuNVXe[N
 *	@param	work		ɓn[N
 *	@param	pfunc1		ʏVuN
 *	@param	pfunc2		rVuN
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_LSVBC_Init( WAZATOOL_LSVBC* p_lsvbc, void* work, pWazaTool_LSVBCFunc pfunc1, pWazaTool_LSVBCFunc pfunc2 )
{
	GF_ASSERT( p_lsvbc );

	p_lsvbc->vblank_lst_flg	= TRUE;
	p_lsvbc->dma_set_flg	= FALSE;
	p_lsvbc->work			= work;
	p_lsvbc->vblank1		= pfunc1;
	p_lsvbc->vblank2		= pfunc2;

	// ^XNo^
	p_lsvbc->vbuff_tcb = VWaitTCB_Add( WazaTool_LSVBC_VBlank1, p_lsvbc, 0 );
	p_lsvbc->vdma_tcb = VIntrTCB_Add( WazaTool_LSVBC_VBlank2, p_lsvbc, 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[pVuNǗVXej
 *
 *	@param	p_lsvbc		j郉X^[VuNǗVXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_LSVBC_Delete( WAZATOOL_LSVBC* p_lsvbc )
{
	GF_ASSERT( p_lsvbc );

	// VBlank֐j
	if( p_lsvbc->vbuff_tcb != NULL ){
		TCB_Delete( p_lsvbc->vbuff_tcb );
	}
	if( p_lsvbc->vdma_tcb != NULL ){
		TCB_Delete( p_lsvbc->vdma_tcb );
	}
	LASTER_DmaStop();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VuNVXêP~
 *
 *	@param	p_lsvbc		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_LSVBC_Stop( WAZATOOL_LSVBC* p_lsvbc )
{
	GF_ASSERT( p_lsvbc );
	p_lsvbc->vblank_lst_flg = FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VuNVXe̍ĊJ
 *
 *	@param	p_lsvbc		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_LSVBC_Start( WAZATOOL_LSVBC* p_lsvbc )
{
	GF_ASSERT( p_lsvbc );
	p_lsvbc->vblank_lst_flg = TRUE;
}


//-------------------------------------
//	
//	obt@삵Ȃ
//	
//=====================================
typedef struct _WAZATOOL_DEFLASTER{
	WAZATOOL_LSVBC vblank;

	// X^[f[^
	LASTER_SYS_PTR lst;	// X^[VXe
	u32	buff1[ WAZATOOL_DEFLASTER_BUFF_SIZE ];	// _uobt@
	u32	buff2[ WAZATOOL_DEFLASTER_BUFF_SIZE ];	// _uobt@
	u32	addr;	// DMA]
} WAZATOOL_DEFLASTER;

//----------------------------------------------------------------------------
/**
 *
 *	@brief	DMA]ݒ
 *
 *	@param	p_lst	ftHgX^[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_DefLasterDmaTransSet( WAZATOOL_DEFLASTER* wk )
{
	const void* buff;

	// QƗpobt@擾
	buff = LASTER_GetReadBuff( wk->lst );

	LASTER_DmaStop();
	
	// HBlankDmaTransɐݒ
	LASTER_DmaSet( buff, (void*)wk->addr, 4, LASTER_DMA_TYPE32 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[pVuNǗVXeɓnʏVuN֐
 *
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_DefLasterNormVblank( void* work )
{
	WAZATOOL_DEFLASTER* wk = work;

	// obt@XCb`
	LASTER_VBlank( wk->lst );

	// HDMAo^
	WazaTool_DefLasterDmaTransSet( wk );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief X^[pVuNǗVXeɓnrɌĂ΂VuNp
 *
 *	@param		work	[N
 *	
 *	@return		none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_DefLasterCenterVblank( void* work )
{
	WAZATOOL_DEFLASTER* wk = work;

	// HDMAo^
	WazaTool_DefLasterDmaTransSet( wk );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ftHgX^[
 *
 *	@param	addr		]惌WX^AhX
 *	@param	init_num	obt@̏l
 *	@param	heap		q[vID
 *
 *	@return	쐬X^[f[^
 *
 *
 */
//-----------------------------------------------------------------------------
WAZATOOL_DEFLASTER_PTR WazaTool_InitDefLaster( u32 addr, u32 init_num, int heap )
{
	WAZATOOL_DEFLASTER_PTR p_lst;
	
	p_lst = sys_AllocMemory( heap, sizeof(WAZATOOL_DEFLASTER) );
	memset( p_lst, 0, sizeof(WAZATOOL_DEFLASTER) );
	GF_ASSERT( p_lst );


	p_lst->lst			= LASTER_Init( heap, p_lst->buff1, p_lst->buff2 );
	GF_ASSERT( p_lst->lst );
	p_lst->addr			= addr;

	// obt@̏
	MI_CpuFill32( p_lst->buff1, init_num, sizeof(u32) * WAZATOOL_DEFLASTER_BUFF_SIZE );
	MI_CpuFill32( p_lst->buff2, init_num, sizeof(u32) * WAZATOOL_DEFLASTER_BUFF_SIZE );

	// VuNǗVXe
	WazaTool_LSVBC_Init( &p_lst->vblank, p_lst, WazaTool_DefLasterNormVblank, WazaTool_DefLasterCenterVblank );

	return p_lst;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[̏I
 *
 *	@param	p_lst	ftHgX^[VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_DeleteDefLaster( WAZATOOL_DEFLASTER_PTR p_lst )
{
	GF_ASSERT( p_lst );

	// VblankǗVXej
	WazaTool_LSVBC_Delete( &p_lst->vblank );
	
	// X^[VXej
	if( p_lst->lst != NULL ){
		LASTER_Delete( p_lst->lst );
	}

	sys_FreeMemoryEz( p_lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ݗpobt@̎擾
 *
 *	@param	cp_lst	ftHgX^[VXe
 *
 *	@return	ݗpobt@
 *
 *
 */
//-----------------------------------------------------------------------------
void* WazaTool_GetDefLasterWriteBuff( CONST_WAZATOOL_DEFLASTER_PTR cp_lst )
{
	GF_ASSERT( cp_lst );

	return LASTER_GetWriteBuff( cp_lst->lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	QƗpobt@擾
 *
 *	@param	cp_lst	ftHgX^[VXe
 *
 *	@return	QƗpobt@
 *
 *
 */
//-----------------------------------------------------------------------------
const void* WazaTool_GetDefLasterReadBuff( CONST_WAZATOOL_DEFLASTER_PTR cp_lst )
{
	GF_ASSERT( cp_lst );

	return LASTER_GetReadBuff( cp_lst->lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[̒~
 *
 *	@param	p_lst	ftHgX^[[N
 *
 *	@return	none
 *
 * VuN֐@\ȂȂ̂ŁA
 * ʂɃX^[fȂȂ܂B
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_StopDefLaster( WAZATOOL_DEFLASTER_PTR p_lst )
{
	GF_ASSERT( p_lst );

	WazaTool_LSVBC_Stop( &p_lst->vblank );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[X^[g
 *
 *	@param	p_lst	ftHgX^[VXe
 *
 *	@return	none
 *
 * ʂɃX^[f悤ɂȂ܂B
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_StartDefLaster( WAZATOOL_DEFLASTER* p_lst )
{
	GF_ASSERT( p_lst );

	WazaTool_LSVBC_Start( &p_lst->vblank );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	f[^]AhXĐݒ
 *
 *	@param	p_lst	ftHgX^[VXe
 *	@param	addr	]AhX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_SetDefLasterTransAddr( WAZATOOL_DEFLASTER_PTR p_lst, u32 addr )
{
	GF_ASSERT( p_lst );

	p_lst->addr = addr;
}


//--------------------------------------------------------------
/**
 * @brief	f[^]AhX擾
 *
 * @param	p_lst	ftHgX^[VXe
 *
 * @retval	u32		]AhX
 *
 */
//--------------------------------------------------------------
u32 WazaTool_GetDefLasterTransAddr( WAZATOOL_DEFLASTER_PTR p_lst )
{
	GF_ASSERT( p_lst );

	return p_lst->addr;
}

//-------------------------------------
//	
//	1/30t[Ή
//	
// X^[XN[bv֐
// SINJ[uXN[܂
//	
//	
//=====================================
typedef struct _WAZATOOL_SCRLASTER{
	WAZATOOL_LSVBC vblank;

	// X^[f[^
	LASTER_SCROLL_PTR lst;	// X^[XN[VXe
} WAZATOOL_SCRLASTER;


//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[pVuNǗVXeɓnʏVuN֐
 *
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_ScrLasterNormVblank( void* work )
{
	WAZATOOL_SCRLASTER* wk = work;
	
	LASTER_ScrollVBuffSwitch( wk->lst );

	LASTER_ScrollVDma( wk->lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief X^[pVuNǗVXeɓnrɌĂ΂VuNp
 *
 *	@param		work	[N
 *	
 *	@return		none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WazaTool_ScrLasterCenterVblank( void* work )
{
	WAZATOOL_SCRLASTER* wk = work;
	
	LASTER_ScrollVDma( wk->lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[VXe
 *
 *	@param	start		XN[JnW
 *	@param	end			XN[IW
 *	@param	add_r		sinJ[ue[u쐬̊px𑫂Ăl(0`65535)
 *	@param	r_w			sinJ[u̔a
 *	@param	scr_sp		X^[XN[Xs[h	*100l	}CiXL
 *	@param	bg_no		X^[BG̔ԍ
 *	@param	tsk_pri		^XND揇
 *	@param	init_num	obt@l
 *	@param	heap		gpq[v
 *
 *	@return	쐬X^[f[^
 * 
 * start <= XN[͈ <= end
 *
 * bg_no = 0`3	CʌŒ
 *
 */
//-----------------------------------------------------------------------------
WAZATOOL_SCRLASTER_PTR WazaTool_InitScrLaster( u8 start, u8 end, u16 add_r, fx32 r_w, s16 scr_sp, u32 bg_no, u32 tsk_pri, u32 init_num, int heap )
{
	WAZATOOL_SCRLASTER_PTR p_lst;
	u32 addr;
	void* buff;
	const void* cbuff;
		
	p_lst = sys_AllocMemory( heap, sizeof(WAZATOOL_SCRLASTER) );
	GF_ASSERT( p_lst );
	memset( p_lst, 0, sizeof(WAZATOOL_SCRLASTER) );

	// bg_no烌WX^̃AhX擾
	addr = WazaTool_GetLasterBGDestAddr( bg_no );

	// X^[XN[VXe쐬
	p_lst->lst = LASTER_ScrollInit( heap );
	LASTER_ScrollStart( p_lst->lst, start, end, add_r, r_w, scr_sp, addr, init_num, tsk_pri );
	
	// VBlankǗVXe쐬
	WazaTool_LSVBC_Init( &p_lst->vblank, p_lst, WazaTool_ScrLasterNormVblank, WazaTool_ScrLasterCenterVblank );

	return p_lst;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[XN[j
 *
 *	@param	p_lst	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_DeleteScrLaster( WAZATOOL_SCRLASTER_PTR p_lst )
{
	GF_ASSERT( p_lst );
	

	// VuNǗVXej
	WazaTool_LSVBC_Delete( &p_lst->vblank );

	// X^[XN[j
	if( p_lst->lst ){
		LASTER_ScrollDelete( p_lst->lst );
	}

	sys_FreeMemoryEz( p_lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ݗpobt@^
 *
 *	@param	cp_lst	[N
 *
 *	@return	obt@
 *
 *
 */
//-----------------------------------------------------------------------------
void* WazaTool_GetScrLasterWriteBuff( CONST_WAZATOOL_SCRLASTER_PTR cp_lst )
{
	GF_ASSERT( cp_lst );
	return LASTER_GetScrollWriteBuff( cp_lst->lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	QƗpobt@擾
 *
 *	@param	cp_lst	[N
 *
 *	@return	obt@
 *
 *
 */
//-----------------------------------------------------------------------------
const void* WazaTool_GetScrLasterReadBuff( CONST_WAZATOOL_SCRLASTER_PTR cp_lst )
{
	GF_ASSERT( cp_lst );
	return LASTER_GetScrollReadBuff( cp_lst->lst );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[f̒~
 *
 *	@param	p_lst	[N
 *
 *	@return	none
 *
 * VuN֐@\ȂȂ̂ŁA
 * ʂɃX^[fȂȂ܂B
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_StopScrLaster( WAZATOOL_SCRLASTER_PTR p_lst )
{
	GF_ASSERT( p_lst );

	WazaTool_LSVBC_Stop( &p_lst->vblank );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[f̊Jn
 *
 *	@param	p_lst	[N
 *
 *	@return	none
 *
 * ʂɃX^[f悤ɂȂ܂B
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_StartScrLaster( WAZATOOL_SCRLASTER_PTR p_lst )
{
	GF_ASSERT( p_lst );

	WazaTool_LSVBC_Start( &p_lst->vblank );
}



//----------------------------------------------------------------------------
/**
 *
 *	@brief	X^[̃obt@ɐݒ肷Wf[^쐬
 *
 *	@param	x	ݒ肘W
 *	@param	y	ݒ肙W
 *
 *	@return	obt@ɐݒ肷l
 *
 *
 */
//-----------------------------------------------------------------------------
u32 WazaTool_GetLasterBuffMatrixData( u16 x, u16 y )
{
	return ( (y << 16) | x );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGio[ɑΉAhXԂ
 *
 *	@param	bg_no	BGio[
 *
 *	@return	AhX
 *
 *
 */
//-----------------------------------------------------------------------------
u32 WazaTool_GetLasterBGDestAddr( int bg_no )
{
	u32 addr;
	switch( bg_no ){
	case 0:
		addr	= LASTER_SCROLL_MBG0;
		break;
	case 1:
		addr	= LASTER_SCROLL_MBG1;
		break;
	case 2:
		addr	= LASTER_SCROLL_MBG2;
		break;
	case 3:
		addr	= LASTER_SCROLL_MBG3;
		break;
	}

	return addr;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	GtFNgBGɗD揇ʂݒ
 *
 *	@param	we_sys		ZGtFNgVXe
 *	@param	pri			D揇 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WazaTool_SetEffectBGPriority( WE_SYS_PTR we_sys, int pri )
{
	int eff_bg;
	
	eff_bg = BT_BGL_BGNoGet( we_sys, WES_BF_EFFECT );
	switch( eff_bg ){
	case 0:
		G2_SetBG0Priority( pri );
		break;

	case 1:
		G2_SetBG1Priority( pri );
		break;

	case 2:
		G2_SetBG2Priority( pri );
		break;

	case 3:
		G2_SetBG3Priority( pri );
		break;
	}
}


// =============================================================================
//
//
//	c[HƂH
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	2_̒_߂
 *
 * @param	x1				_1x
 * @param	y1				_1y
 * @param	x2				_2x
 * @param	y2				_2y
 * @param	mx				_x
 * @param	my				_y
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_MiddlePointGet(s16 px1, s16 py1, s16 px2, s16 py2, s16* mx, s16* my)
{
	*mx = (px1 + px2) / 2;
	*my = (py1 + py2) / 2;
}


//--------------------------------------------------------------
/**
 * @brief	2_̒_߂
 *
 * @param	x1				_1x
 * @param	y1				_1y
 * @param	x2				_2x
 * @param	y2				_2y
 * @param	mx				_x
 * @param	my				_y
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_MiddlePointGetFx(s16 px1, s16 py1, s16 px2, s16 py2, fx32* mx, fx32* my)
{
	*mx = ((px1 + px2) * FX32_ONE) / 2;
	*my = ((py1 + py2) * FX32_ONE) / 2;
}


//--------------------------------------------------------------
/**
 * @brief	2_̋߂
 *
 * @param	x1				_1x
 * @param	y1				_1y
 * @param	x2				_2x
 * @param	y2				_2y
 * @param	range			
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_RangeGetFx(s16 x1, s16 y1, s16 x2, s16 y2, fx32* range)
{
	s16 px = (x1 - x2);
	s16 py = (y1 - y2) * -1;
	*range = FX_Sqrt( ((py*py)+(px*px)) * FX32_ONE );
}


//--------------------------------------------------------------
/**
 * @brief	_Ɠ_px߂
 *
 * @param	x1				_1x
 * @param	y1				_1y
 * @param	x2				_2x
 * @param	y2				_2y
 * @param	angle			px
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WazaTool_PointToPointAngleGet(s16 x1, s16 y1, s16 x2, s16 y2, u16* angle)
{
	s16 px = (x1 - x2);
	s16 py = (y1 - y2) * -1;
	s16 tmp;
	
	*angle = FX_Atan2Idx((py * FX32_ONE), px * FX32_ONE);
	if (*angle > 0 && py < 0){
		*angle = (*angle -FX_GET_ROTA_NUM(180)) * 0xffff;
	}
	else if (*angle < 0 && py > 0){
		*angle += +FX_GET_ROTA_NUM(180);					
	}
}


//--------------------------------------------------------------
/**
 * @brief	p[^̑Ǘ
 *
 * @param	p			Ώ
 * @param	ep			E
 * @param	cp			l
 *
 * @retval	BOOL		TRUE = EɓB
 *
 */
//--------------------------------------------------------------
BOOL WazaTool_ParamCalc(int* p, int ep, s32 cp)
{
	if (cp < 0){
		if (*p + cp > ep){
			*p += cp;
			return FALSE;
		}
		else {
			*p = ep;
			return TRUE;
		}			
	}
	else {
		if (*p + cp < ep){
			*p += cp;
			return FALSE;
		}
		else {
			*p = ep;
			return TRUE;
		}			
	}
	return TRUE;
}



// ----------------------------------------------------------------------------
//
//
//	\tgtF[h֐S
//
//
// ----------------------------------------------------------------------------
// -----------------------------------------
//
//	 \tgtF[h\
//
// -----------------------------------------
typedef struct _TPAL_SOFT_FADE_SYS {
	
	BOOL	active;				///< TRUE = 쒆
	TCB_PTR	tcb;
	
	FADEREQ req;
	u16		start_pos;
	u16		col_num;
	u16		next_rgb;
	u8		start_evy;
	u8		end_evy;
	u8		evy;
	s8		param;
	s8		wait;
	s8		timer;
	
	PALETTE_FADE_PTR	pfd;	///< pfd
	
} TPAL_SOFT_FADE_SYS;


//--------------------------------------------------------------
/**
 * @brief	TCB
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void PSF_Tcb(TCB_PTR tcb, void* work)
{
	PAL_SFS_PTR wk = (PAL_SFS_PTR)work;
	
	if (wk->active == FALSE){ return; }
	
	if ((++wk->timer) >= wk->wait){
		wk->timer = 0;
		
		SoftFadePfd(wk->pfd,
					wk->req,
					wk->start_pos,
					wk->col_num,
					wk->evy,
					wk->next_rgb);
	
		if (wk->evy == wk->end_evy){
			wk->active = FALSE;
		}
		else {
			s8 temp = wk->evy + wk->param;
			
			if (wk->param > 0){
				if (temp > wk->end_evy){
					wk->evy = wk->end_evy;
				}
				else {
					wk->evy += wk->param;
				}
			}
			else {
				if (temp < wk->end_evy){
					wk->evy = wk->end_evy;
				}
				else {
					wk->evy += wk->param;
				}
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief	ԃ`FbN
 *
 * @param	psp			PAL_SFS_PTR
 *
 * @retval	BOOL		TRUE = s
 *
 */
//--------------------------------------------------------------
BOOL IsPaletteSoftFade(PAL_SFS_PTR psp)
{
	GF_ASSERT(psp != NULL);
	
	return psp->active;
}


//--------------------------------------------------------------
/**
 * @brief	I
 *
 * @param	psp	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void PaletteSoftFadeDelete(PAL_SFS_PTR psp)
{
	GF_ASSERT(psp != NULL);
	
	TCB_Delete(psp->tcb);
	sys_FreeMemoryEz(psp);
}


//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	pfd				pfd
 * @param	heap_area		q[v
 * @param	req				f[^ԍ
 * @param	start_pos		Jnʒu
 * @param	col_num			Iʒu
 * @param	wait			EFCg
 * @param	param			evy vZl (start endŕt̂ŐœnĂ)
 * @param	start_evy		JnZx
 * @param	end_evy			IZx
 * @param	next_rgb		ύX̐F
 * @param	tcb_pri			TCBDx
 *
 * @retval	PAL_SFS_PTR	
 *
 */
//--------------------------------------------------------------
PAL_SFS_PTR PaletteSoftFade(PALETTE_FADE_PTR pfd, int heap_area, FADEREQ req,
							u16 start_pos, u16 col_num,
							s8 wait, s8 param,
							u8 start_evy, u8 end_evy, 
							u16 next_rgb, int tcb_pri)
{
	PAL_SFS_PTR wk = NULL;
	
	wk = sys_AllocMemory(heap_area, sizeof(TPAL_SOFT_FADE_SYS));
	
	GF_ASSERT(wk != NULL);
	
	wk->pfd			= pfd;
	
	wk->req			= req;
	wk->start_pos	= start_pos;
	wk->col_num		= col_num;
	wk->next_rgb	= next_rgb;
	wk->start_evy	= start_evy;
	wk->end_evy		= end_evy;
	wk->evy			= start_evy;
	wk->wait		= wait;
	wk->timer		= wait;
	
	if (wk->start_evy < wk->end_evy){
		wk->param	= param;
	}
	else {
		wk->param	= param * -1;
	}
	
	wk->active		= TRUE;
	
	wk->tcb = TCB_Add(PSF_Tcb, wk, tcb_pri);
	
	return wk;
} 



