//==============================================================================
/**
 * @file	we_sys.h
 * @brief	ZGtFNgpVXe
 * @author	goto
 * @date	2005.06.22()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#ifndef	_WE_SYS_H_
#define _WE_SYS_H_

#include "wazaeffect/we_mana.h"
#include "system/particle.h"

// =============================================================================
//
//
//	p
//	
//		[ _WE-SYS_ ]		WE-SYS
//		[ _EXPLANATION_ ]	WE-SYS̐
//		[ _COMMAND_ ]		R}h
//
//
// =============================================================================

// -----------------------------------------
//
//	ǔp
//
// -----------------------------------------
typedef struct _TAMO_SYS * AMO_SYS_PTR;		///< ǔp\
typedef struct _TAMB_SYS * AMB_SYS_PTR;


// -----------------------------------------
//
//	fobO
//
// -----------------------------------------
//#define WE_SYS_CMD_OS_PRINT				///< L = R}hPrint
//#define WE_SYS_INF_OS_PRINT				///< L = Print

// -----------------------------------------
//
//	ZGtFNgp֐|C^^
//
// -----------------------------------------
typedef void (*pWeFunc)(WE_SYS_PTR we_sys);


// -----------------------------------------
//
//	ZGtFNgp ZAN^[T|[g֐
//
// -----------------------------------------
typedef void (*pWeClactFunc)(WE_SYS_PTR we_sys, CATS_SYS_PTR csp, CATS_RES_PTR crp, CATS_ACT_PTR cap);


// -----------------------------------------
//
//	ZGtFNgp AN^[o^֐
//
// -----------------------------------------
typedef void (*pWeOldActFunc)(WE_SYS_PTR we_sys, CATS_SYS_PTR csp, CATS_RES_PTR crp, CLACT_WORK_PTR act);


// -----------------------------------------
//
//	AhXp[^^
//
// -----------------------------------------
typedef int	TAP;

extern void DefaultBlendSet(void);

// =========================================
//
//
//	DEFINE
//
//
// =========================================

#define WE_JUMP_MAX			(3)				///< Wv߂qɂۂ̍ő吔
#define WE_LOOP_MAX			(3)				///< [v߂qɂۂ̍ő吔
#define WE_GENE_WK_MAX		(8)				///< ėp[N
#define WE_SE_WK_MAX		(7)				///< SEp̃[N
#define WE_SE_END_TIMER		(90)			///< 3bԑ҂
#define WE_CRP_MAX			(4)				///< CRP̍ő吔
#define WE_CAP_MAX			(10)			///< CAP̕ۑ
#define WE_POKE_CAP_MAX		(4)				///< |POAMɃhbvł鐔

#define WE_HAIKEI_ARC		(ARC_BATT_BG)	///< wĩA[JCuĂID


// =========================================
//
//
//	ENUM
//
//
// =========================================
// -----------------------------------------
//
//	TEhRg[
//
// -----------------------------------------
enum ESE_SYS_MODE {

	ENUM_SEC_NON 		= 0,				///< Ȃ
	ENUM_SEC_PAN_FLOW,						///< p-ʒu֌Wl
	ENUM_SEC_PAN_FLOW_FIX,					///< p-PT
	ENUM_SEC_PAN_FLOW_AF,					///< p-Ul
	
	ENUM_SEC_REPEAT,						///< s[g
	
	ENUM_SEC_WAIT_PLAY,						///< waitԑ҂ĂĐ

};

// -----------------------------------------
//
//	TCBo^[h
//
// -----------------------------------------
enum ETCB_MODE {

	ENUM_WETCB_NONE		= 0,				///< ɂȂ
	ENUM_WETCB_EFFECT,						///< GtFNgp
	ENUM_WETCB_SOUND,						///< TEhp

};

// -----------------------------------------
//
//	̑̒`
//
// -----------------------------------------
enum EWES_DEFINE {
	
	///< uhΏۃv[
	ENUM_WES_BLD_PLANE_1 = GX_BLEND_PLANEMASK_BG0,
	ENUM_WES_BLD_PLANE_2 = GX_BLEND_PLANEMASK_BG1,
	
};

// =========================================
//
//
//	OQƁFWE-SYST|[g
//
//
// =========================================

// -----------------------------------------
//
// WE-SYSp GtFNgpTCB_Add
//
// -----------------------------------------
extern TCB_PTR WEEffect_TCB_Add(WE_SYS_PTR we_sys, TCB_FUNC func, void* work, u32 pri);
extern TCB_PTR WEEffect_TCB_AddPriSet(WE_SYS_PTR we_sys, TCB_FUNC func, void* work);


// -----------------------------------------
//
// WE-SYSp TEhpTCB_Add
//
// -----------------------------------------
extern TCB_PTR WESound_TCB_Add(WE_SYS_PTR we_sys, TCB_FUNC func, void* work, u32 pri);
extern TCB_PTR WESound_TCB_AddPriSet(WE_SYS_PTR we_sys, TCB_FUNC func, void* work);


// -----------------------------------------
//
// WE-SYSp GtFNgpTCB_Delete
//
// -----------------------------------------
extern void WEEffect_TCB_Delete(WE_SYS_PTR we_sys, TCB_PTR tcb);


// -----------------------------------------
//
// WE-SYSp TEhpTCB_Delete
//
// -----------------------------------------
extern void WESound_TCB_Delete(WE_SYS_PTR we_sys, TCB_PTR tcb);


// =========================================
//
//
//	OQƁFR}h [ _COMMAND_ ]
//
//
// =========================================
// -----------------------------------------
//
// R}h̎擾
//
// -----------------------------------------
extern pWeFunc WazaEffectCommandGet(u32 id);


// -----------------------------------------
//
// ReXgȂ̂`FbN
//
// -----------------------------------------
extern int WeSysModeGet(BTL_SYS_PTR blt_sys);


// -----------------------------------------
//
//	p̏Ԃ擾
//
// -----------------------------------------
extern s8 WeSysSePanGet(WE_SYS_PTR we_sys, s8 pan);


// -----------------------------------------
//
//	p̏Ԃ擾@Up
//
// -----------------------------------------
extern s8 WeSysSePanAttackGet(WE_SYS_PTR we_sys, s8 pan);


// -----------------------------------------
//
//	Jn`I_ɂAp̉Zl߂
//
// -----------------------------------------
extern s8 WeSysSePanAddGet(s8 s_pan, s8 e_pan,  s8 a_pan);


// -----------------------------------------
//
//	WE-SYS̃oANZX֐ {IGet̂
//
// -----------------------------------------
extern int				WeSysHeapAreaGet(WE_SYS_PTR we_sys);
extern u16				WeSysATNoGet(WE_SYS_PTR we_sys);
extern u16				WeSysDFNoGet(WE_SYS_PTR we_sys);
extern PTC_PTR			WeSysPTCPointerGet(WE_SYS_PTR we_sys);
extern GF_BGL_INI*		WeSysBGLPointerGet(WE_SYS_PTR we_sys);
extern s32				WeSysGPWorkGet(WE_SYS_PTR we_sys, int no);
extern BOOL				WeSysExDataGet(WE_SYS_PTR we_sys, int data[], int num);
extern TCATS_OBJECT_ADD_PARAM_S WeSysCoapGet(WE_SYS_PTR we_sys);

extern CATS_ACT_PTR		WeSysOamCapGet(WE_SYS_PTR we_sys, int no);
extern CATS_ACT_PTR		WeSysPokeCapGet(WE_SYS_PTR we_sys, int no);
extern CATS_RES_PTR		WeSysPokeCrpGet(WE_SYS_PTR we_sys);
extern CATS_RES_PTR		WeSysCrpGet(WE_SYS_PTR we_sys);
extern CATS_SYS_PTR		WeSysCspGet(WE_SYS_PTR we_sys);

extern int				WeSysClientTypeGet(WE_SYS_PTR we_sys, int no);
extern SOFT_SPRITE*		WeSysSoftSpritePointerGet(WE_SYS_PTR we_sys, int no);
extern void				WeSysAutoMoveStop(WE_SYS_PTR we_sys, int stop_tr);
extern PALETTE_FADE_PTR WeSysPFDGet(WE_SYS_PTR we_sys);
extern int				WeSysPalIDGet(WE_SYS_PTR we_sys, int client_no);
extern int				WeSysPokeOfsGet(WE_SYS_PTR we_sys, int client_no);

extern int				WeSysHaikeiDataIDGet(int id, int no);
extern void				WeSysBaseBGSet(WE_SYS_PTR wsp, int frm);				///< {wiݒ肷
extern void				WeSysBaseBGReset(WE_SYS_PTR wsp, int frm);				///< {wiݒ肷

extern BOOL				IsWeSysBattleMode2vs2(WE_SYS_PTR we_sys);

// 퓬̒`擾֐ (ReXg`FbN)
enum {
	WES_BF_WINDOW = 0,
	WES_BF_EFFECT,
	WES_BF_BACKGROUND,
	WES_BF_3DFRAME,
};
extern int				BT_3DPriorityGet(WE_SYS_PTR we_sys);
extern int				BT_BGL_FrameGet(WE_SYS_PTR we_sys, int type);
extern int				BT_BGL_BGNoGet(WE_SYS_PTR we_sys, int type);
extern int				BT_BGPriorityGet(WE_SYS_PTR we_sys, int type);



/// Tu

extern void	BT_HaikeiSubSystemStop(WE_SYS_PTR we_sys);
extern void	BT_HaikeiSubSystemFrameChange(WE_SYS_PTR we_sys);


/// J
extern int	WeSysCameraTypeGet(int no, WE_SYS_PTR we_sys);

/// ɃfobOŎg
extern void WE_SYS_CameraModeSet(WE_SYS_PTR we_sys, int mode);


// =============================================================================
//
//
//	WE-SYS  [ _EXPLANATION_ ]
//
//
// =============================================================================
/* ----- explanation -----

	WE-SYSł̃^XNo^
	
	01.͂߂
		^XNo^R}h̔p~A֐ĂяogēTCB_Add
		TCB̓[NƂĂ̂ŁA
		R}hŃ[Npӂ̂͂ǁ[ƎvāB
	
	02.p@
		GtFNgATEhɊւĂ͓ƎTCB_Add𗘗p邱
		֐Ăяo̒ŁATEhAGtFNgɊւTCB쐬ꍇ
		p֐œo^EJs܂B
		ȊÕ^XNɊւẮAK͂܂
		֐ĂяoŎgp֐̌^͌܂Ă܂
		
		Etypedef void (*pWeFunc)(WE_SYS_PTR we_sys);
	
	03.ӓ_
		WE_SYS_PTR̃[ŃAo^TCBł͊JȂI
		̊֐ĂяołĽ^̊֐w肵ĂB(TCB_Add邾ł)
	
	g
	)
	
	ǉTCB̃[N		--	typedef struct { 
									WE_SYS_PTR ws;		///< K{
									int attack;
									int	count;
								} TSAMPLE_WORK;
									
	ǉTCB			--	void SampleTCB(TCB_PTR, void* work);
	R}hŌĂяo֐	--	void SampleTCBCall(WE_SYS_PTR we_sys);
	
	// ------------------------------------------------------------
	//
	//	Ăяop	(R}ḧɂ֐ł)
	//
	// ------------------------------------------------------------
	void SampleTCBCallSampleTCBCall(WE_SYS_PTR we_sys){
		
		SAMPLE_WORK* wk;
		
		wk = sys_AllocMemory();
		
		///< RRprɂĕς܂
		
		///< 01.ZpTCBo^
		wk->ws = we_sys;								///< RRŃ|C^nĂ
		WEEffect_TCB_Add(wk->ws, SampleTCB, wk, 0x1000);

		///< 02.TEhpTCBo^
		wk->ws = we_sys;								///< RRŃ|C^nĂ
		WESound_TCB_Add(wk->ws, SampleTCB, wk, 0x1000);

		///< 03.TCBo^
		TCB_Add(SampleTCB, wk, 0x1000);					///< ʂɎgĂ
	}
	
	// ------------------------------------------------------------
	//
	//	TCB
	//
	// ------------------------------------------------------------	
	void SampleTCB(TCB_PTR tcb, void* work){
		
		TSAMPLE_WORK* wk = (TSAMPLE_WORK*)work;
		
		///< 폜@o^@ɂĈقȂ܂
		
		///< 01.ZpTCBj
		WEEffect_TCB_Delete(wk->ws, tcb);
		
		///< 02.TEhpTCBj
		WESound_TCB_Delete(wk->ws, tcb);
		
		///< 03.TCBj
		TCB_Delete(tcb);
		
		///< WE_SYS_PTR ̊J͍sȂ
		sys_FreeMemory(wk);
	}

----- explanation -----	*/

#endif


