//==============================================================================
/**
 * @file	we_tool.c
 * @brief	ZGtFNg֌W̃c[
 * @author	matsuda
 * @date	2005.07.29()
 */
//==============================================================================
#include "common.h"
#include "system/particle.h"
#include "we_tool.h"
#include "we_err.h"
#include "battle/battle_common.h"

//#include "wazaeffect/we_mana.h"

#include "we_def.h"
#include "wazatool.h"


//==============================================================================
//	O[oϐ`
//==============================================================================
#ifdef PM_DEBUG
///ZGtFNg֘ÃfobOp[N
WE_DEBUG_WORK WeDebugWork;
#endif


//==============================================================================
//	f[^`
//==============================================================================
static const VecFx32 EnemyEye = {
	0x1700, 0x4d00, -0x1000
};
static const VecFx32 EnemyUp = {
	0, -FX32_ONE, 0
};

//--------------------------------------------------------------
/**
 * @brief	NCAgNoANCAg^Cv擾
 *
 * @param	wsp	
 * @param	client_no	
 *
 * @retval	int	
 *
 */
//--------------------------------------------------------------
int WET_ClientTypeGet(WE_SYS_PTR wsp, int client_no)
{
	return WeSysClientTypeGet(wsp, client_no);
}


//--------------------------------------------------------------
/**
 * @brief	NCAgNOTCh擾
 *
 * @param	wsp	
 * @param	client_no	
 *
 * @retval	int	
 *
 */
//--------------------------------------------------------------
int WET_SideCheck(WE_SYS_PTR wsp, int client_no)
{
	int type;
	int side;
	
	type = WeSysClientTypeGet(wsp, client_no);
	
	switch(type){
	case CLIENT_TYPE_AA:
	case CLIENT_TYPE_A:
	case CLIENT_TYPE_C:
		side = SIDE_MINE;
		break;
	
	case CLIENT_TYPE_BB:
	case CLIENT_TYPE_B:
	case CLIENT_TYPE_D:
		side = SIDE_ENEMY;
		break;
	}
	
	return side;
}


//--------------------------------------------------------------
/**
 * @brief	̃NCAgԍ擾
 *
 * @param	we_sys	
 * @param	client_no	
 *
 * @retval	int	
 *
 */
//--------------------------------------------------------------
int WET_AllySideClientNoGet(WE_SYS_PTR wsp, int client_no)
{
	int i;
	int type;
	int check;
	
	type = WeSysClientTypeGet(wsp, client_no);
	
	if (type == CLIENT_TYPE_AA
	||	type == CLIENT_TYPE_BB){
		return type;
	}
	
	for (i = 0; i < CLIENT_MAX; i++){
		check = WeSysClientTypeGet(wsp, i);
		
		switch(type){
		case CLIENT_TYPE_A:
			if (check == CLIENT_TYPE_C){
				return i;
			}
			break;
		case CLIENT_TYPE_C:
			if (check == CLIENT_TYPE_A){
				return i;
			}
			break;
		case CLIENT_TYPE_B:
			if (check == CLIENT_TYPE_D){
				return i;
			}
			break;
		case CLIENT_TYPE_D:
			if (check == CLIENT_TYPE_B){
				return i;
			}
			break;
		}
	}

	GF_ASSERT(0);
	
	return type;
}


//--------------------------------------------------------------
/**
 * @brief	Ίp̃NCAg^Cv擾
 *
 * @param	wsp	
 * @param	client_no	
 *
 * @retval	int	
 *
 */
//--------------------------------------------------------------
int WET_DiagonalClientTypeGet(WE_SYS_PTR wsp, int client_no)
{
	int type;
	
	type = WeSysClientTypeGet(wsp, client_no);
	
	return WazaTool_DiagonalClientTypeGet_ClientType(type);
}

//--------------------------------------------------------------
/**
 * @brief   wNCAg^CvƑΊp̔ΑɂNCAg^Cv擾
 * @param   client_type		NCAg^Cv
 * @retval  Ίpɂ锽Α̃NCAg^Cv
 */
//--------------------------------------------------------------
int WazaTool_DiagonalClientTypeGet_ClientType(int client_type)
{
	switch(client_type){
	case CLIENT_TYPE_AA:
		return CLIENT_TYPE_BB;
	case CLIENT_TYPE_BB:
		return CLIENT_TYPE_AA;
	case CLIENT_TYPE_A:
		return CLIENT_TYPE_B;
	case CLIENT_TYPE_B:
		return CLIENT_TYPE_A;
	case CLIENT_TYPE_C:
		return CLIENT_TYPE_D;
	case CLIENT_TYPE_D:
		return CLIENT_TYPE_C;
	}
	GF_ASSERT(0);
	return CLIENT_TYPE_AA;
}

//--------------------------------------------------------------
/**
 * @brief   NCAg^Cvw肵ă|P̃p[eBNW擾
 *
 * @param   client_type		NCAg^Cv
 * @param   ret				W
 * @param   contest_flag	TRUE=ReXgB@FALSE:퓬
 */
//--------------------------------------------------------------
void WET_PokeParticlePosGet_ClientType(int client_type, VecFx32 *ret, int contest_flag, int camera_mode)
{
	const VecFx32* vec;
	const VecFx32 vec_tbl[][2] = {
		
		{	///< AA
			{ -7936, -5120, WET_PARTICLE_Z_AA },
			{ -9472, -4480,	WET_PARTICLE_Z_AA },
		},
		{	///< BB
			{ 13888, 6912,	WET_PARTICLE_Z_BB },
			{  9472, 4480,	WET_PARTICLE_Z_BB },
		},
		{
			///< A
			{ -14336, -7040, WET_PARTICLE_Z_A },
			{ -14208, -5632, WET_PARTICLE_Z_A }, 
		},
		{
			///< B
			{ 14336, 7040, WET_PARTICLE_Z_B },
			{ 14336, 7296, WET_PARTICLE_Z_B }, 
		},		
		{
			///< C
			{ -5504, -7040, WET_PARTICLE_Z_C },
			{ -6912, -5888, WET_PARTICLE_Z_C }, 
		},
		{
			///< D
			{ 5504, 7040, WET_PARTICLE_Z_D },
			{ 7040, 7680, WET_PARTICLE_Z_D }, 
		},		
	};
#ifdef PM_DEBUG
	if(WeDebugWork.debug_flag & WE_DEBUG_BIT_EMITPOS){
		*ret = WeDebugWork.emit_pos;
		return;
	}
#endif

//	OS_Printf("p[eBNpW擾NCAgԍ = %d\n",client_type);

	//ReXg
	if(contest_flag == TRUE){
		switch(client_type){
		case CLIENT_TYPE_AA:
			VEC_Set(ret, 7936, -5120, WET_PARTICLE_Z_AA);
			break;
		case CLIENT_TYPE_BB:
			VEC_Set(ret, -13888, 6912, WET_PARTICLE_Z_BB);
			break;
		default:
			GF_ASSERT(0 && "ReXgł́A肦ȂNCAg^Cvł\n");
			break;
		}
		return;
	}
	
	vec = &vec_tbl[ client_type ][ camera_mode ];
	
	VEC_Set(ret, vec->x, vec->y, vec->z);
	
	return;
	
	//퓬
	switch(client_type){
	case CLIENT_TYPE_AA:
		VEC_Set(ret, -7936, -5120, WET_PARTICLE_Z_AA);
		break;
	case CLIENT_TYPE_BB:
		VEC_Set(ret, 13888, 6912, WET_PARTICLE_Z_BB);
		break;
	case CLIENT_TYPE_A:
		VEC_Set(ret, -0x1600, -0xf00, WET_PARTICLE_Z_A);
		break;
	case CLIENT_TYPE_B:
		VEC_Set(ret, 0xfc0, 0x2c0, WET_PARTICLE_Z_B);
		break;
	case CLIENT_TYPE_C:
		VEC_Set(ret, 0, 0, WET_PARTICLE_Z_C);
		break;
	case CLIENT_TYPE_D:
	default:
		VEC_Set(ret, 0, 0, WET_PARTICLE_Z_D);
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   wNCAgNõ|P̃p[eBNW擾
 *
 * @param   client_no		NCAgNo
 * @param   ret				W
 */
//--------------------------------------------------------------
void WET_PokeParticlePosGet(WE_SYS_PTR wsp, int client_no, VecFx32 *ret)
{
	int client_type, contest_flag;
	int camera_type;
	PTC_PTR ptc;
	
	ptc = WeSysPTCPointerGet(wsp);
	camera_type = Particle_CameraTypeGet(ptc);
	
//	camera_type = WeSysCameraTypeGet(wsp);
	
	client_type = WET_ClientTypeGet(wsp, client_no);
	contest_flag = WES_ContestFlag_Get(wsp);
	WET_PokeParticlePosGet_ClientType(client_type, ret, contest_flag, camera_type);
}


//--------------------------------------------------------------
/**
 * @brief	NCAg^CvW擾
 *
 * @param	client_type	
 * @param	ret	
 * @param   contest_flag	TRUE:ReXgB@FALSE:퓬
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WET_PokeParticlePosGet_CT(int client_type, VecFx32 *ret, int contest_flag, int camera_type)
{
	WET_PokeParticlePosGet_ClientType(client_type, ret, contest_flag, camera_type);
}


//--------------------------------------------------------------
/**
 * @brief   Ũ|PɂJxNg擾
 *
 * @param   attack		A^bNNo
 * @param   eye			l
 */
//--------------------------------------------------------------
void WET_AttackCameraEyeGet(int attack, VecFx32 *eye)
{
	if(attack == 0){
		Particle_GetDefaultEye(eye);
	}
	else{
		*eye = EnemyEye;
	}
}

//--------------------------------------------------------------
/**
 * @brief   Ũ|PɂJxNg擾
 *
 * @param   attack		A^bNNo
 * @param   eye			l
 */
//--------------------------------------------------------------
void WET_AttackCameraUpGet(int attack, VecFx32 *v_up)
{
	if(attack == 0){
		Particle_GetDefaultUp(v_up);
	}
	else{
		*v_up = EnemyUp;
	}
}


//--------------------------------------------------------------
/**
 * @brief	GtFNgʂŎg܂킹{ݒ
 *
 * @param	we_sys	
 * @param	obj_ba	
 * @param	bg_ba	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WET_DefaultBlendSet(WE_SYS_PTR we_sys, int obj_ba, int bg_ba)
{
	int oba = obj_ba;
	int bba = bg_ba;
	
	if (obj_ba = WET_DEFAULT_BLEND){
		oba = WET_ALPHA_OAM;
	}
	if (bg_ba = WET_DEFAULT_BLEND){
		bba = WET_ALPHA_BG;
	}
	
	G2_SetBlendAlpha( GX_BLEND_PLANEMASK_NONE,
			( 1 << BT_BGL_BGNoGet(we_sys, WES_BF_BACKGROUND) ) | GX_BLEND_PLANEMASK_BG0, oba, bba );	
}

//--------------------------------------------------------------
/**
 * @brief	GtFNgʂŎg܂킹{ݒ
 *
 * @param	we_sys	
 * @param	bg_msk		uh̑2Ώۖ
 * @param	obj_ba	
 * @param	bg_ba	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WET_BGSelectBlendSet(WE_SYS_PTR we_sys, int bg_msk, int obj_ba, int bg_ba)
{
	int oba = obj_ba;
	int bba = bg_ba;
	
	if (obj_ba = WET_DEFAULT_BLEND){
		oba = WET_ALPHA_OAM;
	}
	if (bg_ba = WET_DEFAULT_BLEND){
		bba = WET_ALPHA_BG;
	}
	
	G2_SetBlendAlpha( GX_BLEND_PLANEMASK_NONE,
			bg_msk, oba, bba );	
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	GtFNgBG̃ftHgAt@uh
 *
 *	@param	we_sys		ZGtFNgVXe[N
 *	@param	effe_ba		GtFNgBG̃At@l
 *	@param	bg_ba		obNOEh̃At@l
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WET_DefaultBGEffectBlendSet( WE_SYS_PTR we_sys, int effe_ba, int bg_ba )
{
	int oba = effe_ba;
	int bba = bg_ba;
	
	if (effe_ba = WET_DEFAULT_BLEND){
		oba = WET_ALPHA_OAM;
	}
	if (bg_ba = WET_DEFAULT_BLEND){
		bba = WET_ALPHA_BG;
	}
	
	G2_SetBlendAlpha( ( 1 << BT_BGL_BGNoGet(we_sys, WES_BF_EFFECT) ),
			( 1 << BT_BGL_BGNoGet(we_sys, WES_BF_BACKGROUND) ) | GX_WND_PLANEMASK_BG0 | GX_BLEND_PLANEMASK_OBJ, oba, bba );	
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	EBhE}XNftHgݒ
 *
 *	@param	we_sys		ZGtFNgVXe
 *	@param	wnd_no		EBhEio[
 *	@param	effect		uh̗L
 *
 *	@return	none
 *
 * wnd_no
 *	WET_WNDMSK_0,
 *	WET_WNDMSK_1,
 *
 */
//-----------------------------------------------------------------------------
void WET_DefaultWndMskSet( WE_SYS_PTR we_sys, int wnd_no, BOOL effect )
{
	if( wnd_no == WET_WNDMSK_0 ){
		// wi
		G2_SetWnd0InsidePlane( 
				( 1 << BT_BGL_BGNoGet(we_sys, WES_BF_BACKGROUND) ) | (1 << BT_BGL_BGNoGet(we_sys, WES_BF_WINDOW )) | (1 << BT_BGL_BGNoGet(we_sys, WES_BF_EFFECT)) | GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_OBJ,
				effect );
	}else{
		// wi
		G2_SetWnd1InsidePlane( 
				( 1 << BT_BGL_BGNoGet(we_sys, WES_BF_BACKGROUND) ) | (1 << BT_BGL_BGNoGet(we_sys, WES_BF_WINDOW )) | (1 << BT_BGL_BGNoGet(we_sys, WES_BF_EFFECT)) | GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_OBJ,
				effect );
	}

	// wiȊOOɂ
	G2_SetWndOutsidePlane( 
			(1 << BT_BGL_BGNoGet(we_sys, WES_BF_WINDOW )) | (1 << BT_BGL_BGNoGet(we_sys, WES_BF_EFFECT)) | GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_OBJ,
			TRUE
			);
}

//--------------------------------------------------------------
/**
 * @brief	SSPW擾
 *
 * @param	ssp	
 * @param	p	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WT_SSP_PointGet(SOFT_SPRITE* ssp, WT_POINT* p)
{
	p->x = SoftSpriteParaGet(ssp, SS_PARA_POS_X);
	p->y = SoftSpriteParaGet(ssp, SS_PARA_POS_Y);
}


//--------------------------------------------------------------
/**
 * @brief	CAPW擾
 *
 * @param	cap
 * @param	p	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WT_CAP_PointGet(CATS_ACT_PTR cap, WT_POINT* p)
{
	CATS_ObjectPosGetCap(cap, &(p->x), &(p->y));
}



//--------------------------------------------------------------
/**
 * @brief	c[ėp\̂̏
 *
 * @param	we_sys	
 * @param	wts	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WT_ToolSysInit(WE_SYS_PTR we_sys, TWE_TOOL_SYS* wts)
{
	wts->seq	= 0;
	wts->cnt	= 0;
	wts->step	= 0;
	wts->wait	= 0;

	wts->wsp		= we_sys;
	wts->csp		= WeSysCspGet(we_sys);
	wts->poke_crp	= WeSysPokeCrpGet(we_sys);
	wts->oam_crp	= WeSysCrpGet(we_sys);
	wts->bgl		= WeSysBGLPointerGet(we_sys);
	wts->pfd		= WeSysPFDGet(we_sys);
}

//--------------------------------------------------------------
/**
 * @brief	\tgEFAXvCg̃|C^擾
 *
 * @param	flag	
 * @param	ssp	
 * @param	num	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WT_SSPointerGet(WE_SYS_PTR wsp, int flag, TWE_POKE_SYS* pp, int* num)
{
	*num = 0;
	
	if (IsBitCheck(flag, WE_TOOL_M1) == TRUE){
		pp[*num].ssp = WeSysSoftSpritePointerGet(wsp, WeSysATNoGet(wsp));
		WT_SSP_PointGet(pp[*num].ssp, &pp[*num].p);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_M2) == TRUE){
		pp[*num].ssp = WeSysSoftSpritePointerGet(wsp, WET_AllySideClientNoGet(wsp, WeSysATNoGet(wsp)));
		WT_SSP_PointGet(pp[*num].ssp, &pp[*num].p);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_E1) == TRUE){
		pp[*num].ssp = WeSysSoftSpritePointerGet(wsp, WeSysDFNoGet(wsp));
		WT_SSP_PointGet(pp[*num].ssp, &pp[*num].p);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_E2) == TRUE){
		pp[*num].ssp = WeSysSoftSpritePointerGet(wsp, WET_AllySideClientNoGet(wsp, WeSysDFNoGet(wsp)));
		WT_SSP_PointGet(pp[*num].ssp, &pp[*num].p);
		(*num)++;
	}
}

//--------------------------------------------------------------
/**
 * @brief	CAP̃|C^擾
 *
 * @param	wsp	
 * @param	flag	
 * @param	pp	
 * @param	num	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WT_CAPointerGet(WE_SYS_PTR wsp, int flag, TWE_POKE_SYS* pp, int* num)
{
	*num = 0;
	
	if (IsBitCheck(flag, WE_TOOL_C0) == TRUE){
		pp[*num].cap = WeSysPokeCapGet(wsp, *num);
		WT_CAP_PointGet(pp[*num].cap, &pp[*num].p);
		(*num)++;
	}
	if (IsBitCheck(flag, WE_TOOL_C1) == TRUE){
		pp[*num].cap = WeSysPokeCapGet(wsp, *num);
		WT_CAP_PointGet(pp[*num].cap, &pp[*num].p);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_C2) == TRUE){
		pp[*num].cap = WeSysPokeCapGet(wsp, *num);
		WT_CAP_PointGet(pp[*num].cap, &pp[*num].p);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_C3) == TRUE){
		pp[*num].cap = WeSysPokeCapGet(wsp, *num);
		WT_CAP_PointGet(pp[*num].cap, &pp[*num].p);
		(*num)++;
	}
}


//--------------------------------------------------------------
/**
 * @brief	|P̊{W擾
 *
 * @param	wsp	
 * @param	flag	
 * @param	pp	
 * @param	num	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WT_PokeBasePointGet(WE_SYS_PTR wsp, int flag, TWE_POKE_SYS* pp, int* num)
{
	int fight_type;
	int contest_ofs = 0;
	*num = 0;
	
	if (IsWeSysBattleMode2vs2(wsp) == FALSE){
		fight_type  = 0;
		if (WES_ContestFlag_Get(wsp) == TRUE){
			contest_ofs = 2;
		}
	}
	else {
		fight_type = 1;
	}
	
	if (IsBitCheck(flag, WE_TOOL_M1) == TRUE){
		WazaEffPosGet_Type(fight_type, 0 + contest_ofs,
						   &pp[*num].base_p.x, &pp[*num].base_p.y);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_M2) == TRUE){
		WazaEffPosGet_Type(fight_type, 2,
						   &pp[*num].base_p.x, &pp[*num].base_p.y);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_E1) == TRUE){
		WazaEffPosGet_Type(fight_type, 1 + contest_ofs,
						   &pp[*num].base_p.x, &pp[*num].base_p.y);
		(*num)++;
	}
	
	if (IsBitCheck(flag, WE_TOOL_E2) == TRUE){
		WazaEffPosGet_Type(fight_type, 3,
						   &pp[*num].base_p.x, &pp[*num].base_p.y);
		(*num)++;
	}
}


//--------------------------------------------------------------
/**
 * @brief	we_sysq[v̈擾GtFNgp̃m
 *
 * @param	wsp				we_sys
 * @param	size			TCY
 *
 * @retval	static inline void*	
 *
 */
//--------------------------------------------------------------
void* WazaEffect_AllocMemory(WE_SYS_PTR wsp, int size)
{
	int		heap_area;
	void*	wk;
	
	wk = NULL;
	
	GF_ASSERT(wsp != NULL);
	
	heap_area = WeSysHeapAreaGet(wsp);
	
	wk = sys_AllocMemory(heap_area, size);
	
	GF_ASSERT(wk != NULL);
	
	memset(wk, 0, size);
	
	return wk;
}

//--------------------------------------------------------------
/**
 * @brief	p
 *
 * @param	wk	
 *
 * @retval	static inline void	
 *
 */
//--------------------------------------------------------------
void WazaEffect_FreeMemory(void* wk)
{
	GF_ASSERT(wk != NULL);
	
	sys_FreeMemoryEz(wk);
}