//==============================================================================
/**
 * @file	wp_tbl.c
 * @brief	ZGtFNgp[eBNf[^e[u
 * @author	matsuda
 * @date	2005.07.22()
 */
//==============================================================================
#include "common.h"
#include "system/particle.h"
#include "wazaeffect/wp_tbl.h"
#include "wazaeffect/wp_num.h"
#include "wazaeffect/battle_particle.h"
#include "wazaeffect/wp_callback.h"
#include "wazaeffect/effectdata/we_list.h"
#include "system/arc_tool.h"

#include "wpcb_common.h"

//==============================================================================
//	vg^Cv錾
//==============================================================================
static void DummyEmitCallback(EMIT_PTR emit);

//==============================================================================
//	萔`
//==============================================================================
#define DUMMY_CALLBACK		DummyEmitCallback

//==============================================================================
//	ZGtFNgp[eBNf[^e[u
//==============================================================================
#if 0	//Arc悤ɂȂ̂ŕsv 2005.10.05()
#include "wazaeffect/effectdata/we_list.dat"
#endif


//--------------------------------------------------------------
/**
 * @brief   G~b^쐬ɌĂяoR[obN֐ւ̃|C^z
 *
 * 邽тɁAwp_num.h̒`킹đKv܂B(EMTFUNC_???)
 */
//--------------------------------------------------------------
static const pEmitFunc EmitterCallbackFunc[] = {
	DummyEmitCallback,
	EmitCall_CameraReverseAttack,
	EmitCall_CameraReverseDefence,
	EmitCall_AttackPos,
	EmitCall_DefencePos,
	EmitCall_AxisAttack,
	EmitCall_AxisDefence,
	
	EmitCall_AxisAttack_DefaultCNV,
	EmitCall_AxisAttack_CenterCNV,
	EmitCall_AxisAttack_TargetPokemonCNV,
	EmitCall_AxisAttack_PlayerPokemonCNV,
	EmitCall_AxisAttack_PosSetCNV,
	
	EmitCall_AxisAttack_DefaultMAG,
	EmitCall_AxisAttack_CenterMAG,
	EmitCall_AxisAttack_TargetPokemonMAG,
	EmitCall_AxisAttack_PlayerPokemonMAG,
	EmitCall_AxisAttack_PosSetMAG,
	
	ECB_Operator,
};


#if 0		//======================================
static const WP_DATA WazaParticleDataTbl[] = {
	{
		"wazaeffect/effectdata/test1.spa",
		DUMMY_CALLBACK,
		0,
	},
	{
		"wazaeffect/effectdata/test2.spa",
		DUMMY_CALLBACK,
		0,
	},
	{
		"wazaeffect/effectdata/test3.spa",
		DUMMY_CALLBACK,
		0,
	},
};
#endif




//--------------------------------------------------------------
/**
 * @brief   G~b^ɌĂяoR[obN֐KvȂɎw肷_~[֐
 *
 * @param   emit		G~b^ւ̃|C^
 *
 * NULLwłvǁAɃ}jAɋLڂĂłȂ̂ŁA
 * Slă_~[֐ݒ肷悤ɂ܂B
 */
//--------------------------------------------------------------
static void DummyEmitCallback(EMIT_PTR emit)
{
	return;
}


#if 0	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//--------------------------------------------------------------
/**
 * @brief   ZGtFNgp[eBNf[^e[uAwf[^ԍ̃AhX擾
 *
 * @param   data_no		f[^ԍ(wp_num.h:WP_???)
 *
 * @retval  f[^AhX
 */
//--------------------------------------------------------------
const WP_DATA * Wp_DataPtrGet(int data_no)
{
	if(data_no >= NELEMS(WazaParticleDataTbl)){
		SDK_ASSERT(0);
		return &WazaParticleDataTbl[0];	//΂Ȃ悤ɍŏ̃|C^ꉞԂ
	}
	
	return &WazaParticleDataTbl[data_no];
}

//--------------------------------------------------------------
/**
 * @brief   p[eBN𐶐
 *
 * @param   data_no		f[^ԍ(wp_num.h:WP_???)
 */
//--------------------------------------------------------------
void Wp_ParticleSet(PTC_PTR ptc, int data_no)
{
	const WP_DATA *wpdata;
	
	wpdata = Wp_DataPtrGet(data_no);
	
	Particle_LoadFile(ptc, wpdata->spa_path);
	Particle_CreateEmitterCallback(ptc, wpdata->res_no, wpdata->emit_func);
}
#endif


//--------------------------------------------------------------
/**
 * @brief   p[eBNVXe𐶐A\[Xt@Cǂݍ
 *
 * @param   data_no		f[^ԍ(wp_num.h:SPA_???)
 */
//--------------------------------------------------------------
PTC_PTR Wp_Init(int heap_id, int data_no)
{
	PTC_PTR ptc;
	void *resource;
	
	ptc = BattleParticle_SystemSet(heap_id);
	resource = Particle_ArcResourceLoad(ARC_WAZA_PARTICLE, data_no, heap_id);
	Particle_ResourceSet(ptc, resource, PTC_AUTOTEX_FRM | PTC_AUTOPLTT_FRM);

#ifdef PM_DEBUG

	gDebugPTC = ptc;

#endif
	
	return ptc;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBÑG~b^쐬
 *
 * @param   ptc				p[eBNVXe[Nւ̃|C^
 * @param   resource_no		\[Xԍ
 * @param   func_num		R[obN֐ԍ(wp_num.h:EMTFUNC_???)
 * @param   temp_ptr		G~b^쐬Ƀe|[Nɗa|C^
 */
//--------------------------------------------------------------
void Wp_EmitterCreate(PTC_PTR ptc, int resource_no, int func_num, void *temp_ptr)
{
	Particle_CreateEmitterCallback(ptc, resource_no, EmitterCallbackFunc[func_num], temp_ptr);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBÑG~b^쐬(R[obN֐𒼐ڃ|C^œn)
 *
 * @param   ptc				p[eBNVXe[Nւ̃|C^
 * @param   resource_no		\[Xԍ
 * @param   func_num		R[obN֐ԍ(wp_num.h:EMTFUNC_???)
 * @param   temp_ptr		G~b^쐬Ƀe|[Nɗa|C^
 */
//--------------------------------------------------------------
void Wp_EmitterCreateFunc(PTC_PTR ptc, int resource_no, pEmitFunc func, void *temp_ptr)
{
	Particle_CreateEmitterCallback(ptc, resource_no, func, temp_ptr);
}

//--------------------------------------------------------------
/**
 * @brief   ǂݍł郊\[Xt@C
 *
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void Wp_Exit(PTC_PTR ptc)
{
	BattleParticle_Exit(ptc);
}

