//==============================================================================
/**
 * @file	wpcb_camera.c
 * @brief	R[obNJݒ
 * @author	goto
 * @date	2006.03.02()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================


#include "common.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"
#include "wp_callback.h"
#include "we_tool.h"
#include "we_err.h"
#include "we_def.h"

#include "wpcb_common.h"


// -----------------------------------------
//
//	T|[g֐
//
// -----------------------------------------
static void COT_ExDataGet(ECB_OPERATOR_DATA* odp, int data[]);

// -----------------------------------------
//
//	J֐
//
// -----------------------------------------
static BOOL COT_None(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);
static BOOL COT_SpinCamera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);
static BOOL COT_UserCamera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);
static BOOL COT_MoveCamera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);


//--------------------------------------------------------------
/**
 *
 * @brief	Jݒ֐e[u
 *
 */
//--------------------------------------------------------------
static BOOL (* const CameraOperatorTool[])(EMIT_PTR emit, ECB_OPERATOR_DATA* odp) = {
	COT_None,
	COT_SpinCamera,
	COT_UserCamera,
	COT_MoveCamera,
};


// =============================================================================
//
//
//	 private
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	gf[^擾
 *
 * @param	odp	
 * @param	data[]	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void COT_ExDataGet(ECB_OPERATOR_DATA* odp, int data[])
{
	WeSysExDataGet(odp->wsp, data, OPERATOR_CAMERA_EX_DATA_NUM);
}


//--------------------------------------------------------------
/**
 * @brief	J
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL COT_None(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	GF_CAMERA_PTR camera_ptr;
	CAMERA_ANGLE  angle = { 0, 0, 0 };
	
	camera_ptr = Particle_GetCameraPtr(odp->ptc);
	
//	SetCameraAngleRot(&angle, camera_ptr);
	GFC_SetCameraAngleRev(&angle, camera_ptr);
	
#ifdef WPCB_FREE_EMITTER_MOVE

	DebugWazaEffect_LoopEmitter(odp->ptc, emit, odp->wsp);
	
#endif

	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	XsJݒ
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
#define COT_SPIN_CAMERA_X	(0x1000*2)
#define COT_SPIN_CAMERA_Y	(0x1000*2)
#define COT_SPIN_CAMERA_Z	(0)
static BOOL COT_SpinCamera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	GF_CAMERA_PTR camera_ptr;
	CAMERA_ANGLE  angle = { COT_SPIN_CAMERA_X, COT_SPIN_CAMERA_Y, COT_SPIN_CAMERA_Z };
	
	camera_ptr = Particle_GetCameraPtr(odp->ptc);
	
	Particle_CameraTypeSet(odp->ptc, GF_CAMERA_ORTHO);			///< ˉe
	GFC_SetCameraAngleRev(&angle, camera_ptr);					///< JAOύX
//	SetCameraAngleRot(&angle, camera_ptr);

	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	[U[Jݒ
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL COT_UserCamera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	int data[ OPERATOR_CAMERA_EX_DATA_NUM ];
	CAMERA_ANGLE	angle = { 0,0,0,0 };
	GF_CAMERA_PTR	camera_ptr;
	
	COT_ExDataGet(odp, data);
	
	angle.x = data[1];
	angle.y = data[2];
	angle.z = data[3];
	
	camera_ptr = Particle_GetCameraPtr(odp->ptc);
	
	GFC_SetCameraAngleRev(&angle, camera_ptr);

#ifdef WPCB_FREE_EMITTER_MOVE

	DebugWazaEffect_LoopEmitter(odp->ptc, emit, odp->wsp);
	
#endif
	return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief	ړJݒ
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	static BOOL	
 *
 */
//--------------------------------------------------------------
static BOOL COT_MoveCamera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	return TRUE;
}


// =============================================================================
//
//
//	 public
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	Jݒs֐
 *
 * @param	no	
 * @param	emit	
 * @param	odp	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void CameraOperator_Executed(int no, EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	BOOL res;

	res = CameraOperatorTool[ no ](emit, odp);
	
	if (res == FALSE){
		OS_Printf("camera operator == false\n");
	}	
}

