//==============================================================================
/**
 * @file	wpcd_operator.c
 * @brief	R[obN֐
 * @author	goto
 * @date	2006.02.10()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#include "common.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"
#include "wp_callback.h"
#include "we_tool.h"
#include "we_err.h"
#include "we_def.h"

#include "wpcb_common.h"


static void ECB_Operator_Common(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);				///< {̂璼ڌĂ΂
static void ECB_Operator_Position(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);			///< W
static void ECB_Operator_Axiss(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);				///< 
static void ECB_Operator_Field(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);				///< tB[h
static void ECB_Operator_Camera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);				///< J
static void ECB_Operator_Priority(EMIT_PTR emit, ECB_OPERATOR_DATA* odp);			///< Dx؂ւ

// =============================================================================
//
//
//	 private
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	R[obN֐ - Common
 *
 * @param	wsp	
 * @param	emit
 * @param	odp
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ECB_Operator_Common(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	///< W
	{
		if (odp->mode[ ECB_MODE_POS ] != OPERATOR_POS_NONE){
			
			ECB_Operator_Position(emit, odp);
			
		}
	}
	
	///< 
	{
		if (odp->mode[ ECB_MODE_AXIS ] != OPERATOR_AXIS_NONE){
		
			ECB_Operator_Axiss(emit, odp);
			
		}
	}
	
	///< tB[h
	{
		if (odp->mode[ ECB_MODE_FIELD ] != OPERATOR_FLD_NONE){
			
			ECB_Operator_Field(emit, odp);
			
		}		
	}
	
	///< J
	{
	#if 1
		
		ECB_Operator_Camera(emit, odp);
	
	#else
		if (odp->mode[ ECB_MODE_CAMERA ] != OPERATOR_CAMERA_NONE){
			
			ECB_Operator_Camera(emit, odp);
			
		}
	#endif		
	}
	
	///< D揇ʑ
	{
		if (odp->mode[ ECB_MODE_PRI ] != OPERATOR_PRI_NONE){

			ECB_Operator_Priority(emit, odp);

		}
	}

//	DebugParticle_EmitMove2(odp->ptc, emit, odp->wsp);
}


//--------------------------------------------------------------
/**
 * @brief	W֐
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ECB_Operator_Position(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	VecFx32 vec;
	
	switch(odp->mode[ ECB_MODE_POS ]){
	case OPERATOR_POS_NONE:
		///< Ww薳 Ƃ肠AȂ
		break;
	
	case OPERATOR_POS_SP:
		///< Jn̍Ww
		WET_PokeParticlePosGet(odp->wsp, odp->s_client, &vec);
		break;
	
	case OPERATOR_POS_EP:
		///< I̍Ww
		WET_PokeParticlePosGet(odp->wsp, odp->e_client, &vec);
		break;
	
	case OPERATOR_POS_SET:
		///< [U[wWݒ
		{
			int pos[ OPERATOR_POS_PARAM_MAX + 1];

			WeSysExDataGet(odp->wsp, pos, OPERATOR_POS_PARAM_MAX + 1);
			odp->reverce_flag = ECB_Operator_ReverceFlag(odp);			
			VEC_Set(&vec, pos[1],pos[2],pos[3]);
			
			if (pos[0] == OPERATOR_EX_REVERCE_OFF){				///< ]Ȃ
				odp->reverce_flag = OPERATOR_REVERCE_FLAG_OFF;
			}

			vec.x *= odp->reverce_flag;
			vec.y *= odp->reverce_flag;
			//vec.z *= odp->reverce_flag;						///< sς̂Ŕ]
		}
		break;

	case OPERATOR_POS_SP_OFS:
		///< Jn̍Ww
		WET_PokeParticlePosGet(odp->wsp, odp->s_client, &vec);
		{
			int pos[ OPERATOR_POS_PARAM_MAX + 1];
			VecFx32 ofs = { 0, 0, 0 };

			WeSysExDataGet(odp->wsp, pos, OPERATOR_POS_PARAM_MAX + 1);
			odp->reverce_flag = ECB_Operator_ReverceFlag(odp);			
			VEC_Set(&ofs, pos[1],pos[2],pos[3]);
			
			if (pos[0] == OPERATOR_EX_REVERCE_OFF){				///< ]Ȃ
				odp->reverce_flag = OPERATOR_REVERCE_FLAG_OFF;
			}
			ofs.x *= odp->reverce_flag;
			ofs.y *= odp->reverce_flag;
			ofs.z *= odp->reverce_flag;
			vec.x += ofs.x;
			vec.y += ofs.y;
			vec.z += ofs.z;
		}
		break;
	
	case OPERATOR_POS_EP_OFS:
		///< I̍Ww
		WET_PokeParticlePosGet(odp->wsp, odp->e_client, &vec);
		{
			int pos[ OPERATOR_POS_PARAM_MAX + 1];
			VecFx32 ofs = { 0, 0, 0 };

			WeSysExDataGet(odp->wsp, pos, OPERATOR_POS_PARAM_MAX + 1);
			odp->reverce_flag = ECB_Operator_ReverceFlag(odp);			
			VEC_Set(&ofs, pos[1],pos[2],pos[3]);
			
			if (pos[0] == OPERATOR_EX_REVERCE_OFF){				///< ]Ȃ
				odp->reverce_flag = OPERATOR_REVERCE_FLAG_OFF;
			}
			ofs.x *= odp->reverce_flag;
			ofs.y *= odp->reverce_flag;
			ofs.z *= odp->reverce_flag;
			vec.x += ofs.x;
			vec.y += ofs.y;
			vec.z += ofs.z;
		}
		break;
	}
	
	odp->pos = vec;												///< ۂ̍Wۑ
	SPL_SetEmitterPositionX(emit, vec.x);						///< Wf
	SPL_SetEmitterPositionY(emit, vec.y);
	SPL_SetEmitterPositionZ(emit, vec.z);
}


//--------------------------------------------------------------
/**
 * @brief	֐
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ECB_Operator_Axiss(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	int at_type;
	int df_type;
	VecFx16 axis;
	
	at_type = WET_ClientTypeGet(odp->wsp, odp->s_client);	///< U^Cv
	df_type = WET_ClientTypeGet(odp->wsp, odp->e_client);	///< Ώۑ^Cv

#ifdef WPCB_AXIS_CLIENT_TYPE_MSG

	OS_Printf("at client type = %d\n", at_type);
	OS_Printf("df client type = %d\n", df_type);

#endif

	{
		int aa_bb[ OPERATOR_AXIS_PARAM_MAX + 1];
		int a_b[ OPERATOR_AXIS_PARAM_MAX + 1], a_c[ OPERATOR_AXIS_PARAM_MAX + 1], a_d[ OPERATOR_AXIS_PARAM_MAX + 1];
		int c_a[ OPERATOR_AXIS_PARAM_MAX + 1], c_b[ OPERATOR_AXIS_PARAM_MAX + 1], c_d[ OPERATOR_AXIS_PARAM_MAX + 1];
		
		switch(odp->mode[ ECB_MODE_AXIS ]){
		case OPERATOR_AXIS_NONE:
			///< w薳
			{
				int i;
				for (i = 0; i < OPERATOR_AXIS_PARAM_MAX; i++){
					aa_bb[i] = 0;
					a_b[i]	 = 0;
					a_c[i]	 = 0;
					a_d[i]	 = 0;
					c_a[i]	 = 0;
					c_b[i]	 = 0;
					c_d[i]	 = 0;
				}
			}
			break;

		case OPERATOR_AXIS_AT:
		case OPERATOR_AXIS_DF:
			///< UAh䑤{ݒ
			{
				int i;
				int def[7][ OPERATOR_AXIS_PARAM_MAX+1 ] = {
					{ WP_AXIS_DEF_X, WP_AXIS_DEF_Y, WP_AXIS_DEF_Z, OPERATOR_EX_REVERCE_ON, },
					{ 3232, 1472, 1568, OPERATOR_EX_REVERCE_ON, },
					{ 5984, 2496, 6208, OPERATOR_EX_REVERCE_ON, },
					{ 2688, 1408, 1536, OPERATOR_EX_REVERCE_ON, },
					{ -896,  384,  800, OPERATOR_EX_REVERCE_ON, },
					{ 2336, 1440,  736, OPERATOR_EX_REVERCE_ON, },
					{ 1888, 1856, 1760, OPERATOR_EX_REVERCE_ON, },
				};
				for (i = 0; i < OPERATOR_AXIS_PARAM_MAX+1; i++){
					aa_bb[i] = def[0][i];
					a_b[i]	 = def[1][i];
					a_c[i]	 = def[2][i];
					a_d[i]	 = def[3][i];
					c_a[i]	 = def[4][i];
					c_b[i]	 = def[5][i];
					c_d[i]	 = def[6][i];
				}
			}
			break;

		case OPERATOR_AXIS_SET:
			///< [U[w莲ݒ
			{
				WeSysExDataGet(odp->wsp, aa_bb, OPERATOR_AXIS_PARAM_MAX + 1);
				WeSysExDataGet(odp->wsp, a_b,   OPERATOR_AXIS_PARAM_MAX + 1);
				WeSysExDataGet(odp->wsp, a_d,   OPERATOR_AXIS_PARAM_MAX + 1);
				WeSysExDataGet(odp->wsp, a_c,   OPERATOR_AXIS_PARAM_MAX + 1);
				WeSysExDataGet(odp->wsp, c_b,   OPERATOR_AXIS_PARAM_MAX + 1);
				WeSysExDataGet(odp->wsp, c_d,   OPERATOR_AXIS_PARAM_MAX + 1);
				WeSysExDataGet(odp->wsp, c_a,   OPERATOR_AXIS_PARAM_MAX + 1);
			}
			break;
		}	

		switch(at_type){
		case CLIENT_TYPE_AA:
		default:
			VEC_Fx16Set(&axis, aa_bb[0], aa_bb[1], aa_bb[2]);
			break;
			
		case CLIENT_TYPE_BB:
			if (aa_bb[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
				VEC_Fx16Set(&axis, aa_bb[0], aa_bb[1], aa_bb[2]);
			}
			else {
				VEC_Fx16Set(&axis, -aa_bb[0], -aa_bb[1], -aa_bb[2]);
			}
			break;
			
		case CLIENT_TYPE_A:
			if(df_type == CLIENT_TYPE_B){
				VEC_Fx16Set(&axis, a_b[0], a_b[1], a_b[2]);
			}
			else if(df_type == CLIENT_TYPE_D){
				VEC_Fx16Set(&axis, a_d[0], a_d[1], a_d[2]);
			}
			else{	//CLIENT_TYPE_C
				VEC_Fx16Set(&axis, a_c[0], a_c[1], a_c[2]);
			}
			break;
			
		case CLIENT_TYPE_B:
			if(df_type == CLIENT_TYPE_A){
				if (a_b[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
					VEC_Fx16Set(&axis, a_b[0], a_b[1], a_b[2]);
				}
				else {
					VEC_Fx16Set(&axis, -a_b[0], -a_b[1], -a_b[2]);
				}
			}
			else if(df_type == CLIENT_TYPE_D){
				if (a_c[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
					VEC_Fx16Set(&axis, a_c[0], a_c[1], a_c[2]);
				}
				else {
					VEC_Fx16Set(&axis, -a_c[0], -a_c[1], -a_c[2]);
				}
			}
			else{	//CLIENT_TYPE_C
				if (c_b[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
					VEC_Fx16Set(&axis, c_b[0], c_b[1], c_b[2]);
				}
				else {
					VEC_Fx16Set(&axis, -c_b[0], -c_b[1], -c_b[2]);
				}
			}
			break;
			
		case CLIENT_TYPE_C:
			if(df_type == CLIENT_TYPE_B){
				VEC_Fx16Set(&axis, c_b[0], c_b[1], c_b[2]);
			}
			else if(df_type == CLIENT_TYPE_D){
				VEC_Fx16Set(&axis, c_d[0], c_d[1], c_d[2]);
			}
			else{	//CLIENT_TYPE_C
				VEC_Fx16Set(&axis, c_a[0], c_a[1], c_a[2]);
			}
			break;
			
		case CLIENT_TYPE_D:
			if(df_type == CLIENT_TYPE_B){
				if (a_b[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
					VEC_Fx16Set(&axis, c_a[0], c_a[1], c_a[2]);
				}
				else {
					VEC_Fx16Set(&axis, -c_a[0], -c_a[1], -c_a[2]);
				}
			}
			else if(df_type == CLIENT_TYPE_A){
				if (a_b[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
					VEC_Fx16Set(&axis, a_d[0], a_d[1], a_d[2]);
				}
				else {
					VEC_Fx16Set(&axis, -a_d[0], -a_d[1], -a_d[2]);
				}
			}
			else{	//CLIENT_TYPE_C
				if (a_b[3] == OPERATOR_EX_REVERCE_OFF){			///< ]
					VEC_Fx16Set(&axis, c_d[0], c_d[1], c_d[2]);
				}
				else {
					VEC_Fx16Set(&axis, -c_d[0], -c_d[1], -c_d[2]);
				}
			}
			break;
		}
	}

#ifdef	WPCB_AXIS_POS_MSG

	OS_Printf("axis pos = \(%d, %d, %d\)\n", axis.x, axis.y, axis.z);

#endif
	#if 0
	{
		VecFx32 pos;
		
		WET_PokeParticlePosGet(odp->wsp, odp->e_client, &pos);
		
		axis.x = FX_FX32_TO_F32(pos.x);
		axis.y = FX_FX32_TO_F32(pos.y);
		axis.z = FX_FX32_TO_F32(pos.z);
	}
	
	DebugParticle_AxisLoop(odp->ptc, 0, 0, odp->wsp);
	#endif
	SPL_SetEmitterAxis(emit, &axis);
}


//--------------------------------------------------------------
/**
 * @brief	tB[h
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ECB_Operator_Field(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	int num;
	int i;
	int bit;
	
	num = FieldOperator_BitDataMax();
	
	for (i = 0; i < num; i++){
		
		bit = FieldOperator_BitGet(i);

		if (IsBitCheck(odp->mode[ ECB_MODE_FIELD ], bit) == FALSE){ continue; }
		
		FieldOperator_Executed(i, emit, odp);

	}
}


//--------------------------------------------------------------
/**
 * @brief	J
 *
 * @param	emit	
 * @param	odp	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ECB_Operator_Camera(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	#if 0
	/* ---
	
		ł炤[ĥ܂ܓ֐ɂȂ
		
	--- */
	#endif
	
	CameraOperator_Executed(odp->mode[ ECB_MODE_CAMERA ], emit, odp);
	
}


//--------------------------------------------------------------
/**
 * @brief	Dx؂ւ
 *
 * @param	emit	
 * @param	odp	
 * @param	z	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void ECB_Operator_Priority(EMIT_PTR emit, ECB_OPERATOR_DATA* odp)
{
	#if 0
	/* ---
	
		WݒɁAẐݎwDx؂ւŐ؂ւ
		J͓ˉe[GF_CAMERA_PERSPECTIV]̂ݗL
	
	--- */
	#endif
	
	fx32 z;
	int at_type;
	int df_type;
	int fb_check = 0;
	
	at_type = WET_ClientTypeGet(odp->wsp, odp->s_client);	///< U^Cv
	df_type = WET_ClientTypeGet(odp->wsp, odp->e_client);	///< Ώۑ^Cv
	
	switch(df_type){
	case CLIENT_TYPE_AA:
	case CLIENT_TYPE_A:
	case CLIENT_TYPE_C:
		fb_check = 0;
		break;
	case CLIENT_TYPE_BB:
	case CLIENT_TYPE_B:
	case CLIENT_TYPE_D:
		fb_check = 1;
		break;
	}
	
	switch (odp->mode[ECB_MODE_PRI]){
	case OPERATOR_PRI_NONE:
		break;
	
	case OPERATOR_PRI_FRONT:
		if (df_type == 0){
			z = OPERATOR_DEF_FZ_AA;
		}
		else {
			z = OPERATOR_DEF_FZ_BB;
		}
		break;
	
	case OPERATOR_PRI_BACK:
		if (df_type == 0){
			z = OPERATOR_DEF_BZ_AA;
		}
		else {
			z = OPERATOR_DEF_BZ_BB;
		}
		break;
	
	case OPERATOR_PRI_Z:
		break;
	}

	if (Particle_CameraTypeGet(odp->ptc) != GF_CAMERA_PERSPECTIV){
		OS_Printf("operator pri ˉeŗDx삪sȂ܂ -- f܂B\n");
	}

	SPL_SetEmitterPositionZ(emit, z);
}


// =============================================================================
//
//
//	 public 
//
//
// =============================================================================
//--------------------------------------------------------------
/**
 * @brief	R[obN֐
 *
 * @param	emit	
 *
 * @retval	none	
 *
 *	֐w肷邱ƂłׂĂ̑󂯂邱Ƃ\
 *
 */
//--------------------------------------------------------------
void ECB_Operator(EMIT_PTR emit)
{
	WE_SYS_PTR wsp;
	ECB_OPERATOR_DATA* odp;
	
	wsp = Particle_GetTempPtr();
	odp = sys_AllocMemory(WeSysHeapAreaGet(wsp), sizeof(ECB_OPERATOR_DATA));

	odp->wsp = wsp;
	odp->ptc = WeSysPTCPointerGet(odp->wsp);

	///< 삷郂[h擾
	WeSysExDataGet(odp->wsp, odp->mode, ECB_MODE_NUM);

	///< ^[Qbg擾
	{
		switch(odp->mode[ ECB_MODE_TARGET ]){
		case OPERATOR_TARGET_NONE:
		default:
			///< Ώێw肪ꍇ
			odp->s_client	= WeSysATNoGet(odp->wsp);
			odp->e_client	= WeSysDFNoGet(odp->wsp);
			break;

		case OPERATOR_TARGET_AT:
			///< Ώۂ̏ꍇ
			odp->s_client	= WeSysDFNoGet(odp->wsp);
			odp->e_client	= WeSysATNoGet(odp->wsp);
			break;

		case OPERATOR_TARGET_DF:
			///< Ώۂ̏ꍇ
			odp->s_client	= WeSysATNoGet(odp->wsp);
			odp->e_client	= WeSysDFNoGet(odp->wsp);
			break;
		}
	}
	
	ECB_Operator_Common(emit, odp);
	
#ifdef PM_DEBUG

	Debug_OperatorStatusPrint(odp);
	
#endif

	sys_FreeMemoryEz(odp);
}


//--------------------------------------------------------------
/**
 * @brief	]tO擾֐
 *
 * @param	we_sys	
 * @param	odp	
 *
 * @retval	static s8	
 *
 */
//--------------------------------------------------------------
s8 ECB_Operator_ReverceFlag(ECB_OPERATOR_DATA* odp)
{
	s8 flag = OPERATOR_REVERCE_FLAG_OFF;
	int at_type, df_type;
		
	at_type = WET_ClientTypeGet(odp->wsp, odp->s_client);
	df_type = WET_ClientTypeGet(odp->wsp, odp->e_client);
	
	switch(at_type){
	case CLIENT_TYPE_AA:
	default:
		break;

	case CLIENT_TYPE_BB:
		flag = OPERATOR_REVERCE_FLAG_ON;
		break;

	case CLIENT_TYPE_A:
		break;
	
	case CLIENT_TYPE_B:
		flag = OPERATOR_REVERCE_FLAG_ON;
		break;
	
	case CLIENT_TYPE_C:
		break;
	
	case CLIENT_TYPE_D:
		flag = OPERATOR_REVERCE_FLAG_ON;
		break;
	}
		
	return flag;
}
