//==============================================================================
/**
 * @file	wsp_300.c
 * @brief	ȒPȐ
 * @author	goto
 * @date	2006.02.28
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#include "common.h"				///< K{
#include "system/lib_pack.h"	///< K{
#include "west_sp.h"			///< K{
#include "wsp.h"				///< xxx.cɑ΂xxx.h͕K{

#include "wazatool.h"			///< ZGtFNgx֐S
#include "we_tool.h"			///< 

#include "ball_effect.h"
#include "system/arc_tool.h"	///< A[JCup
#include "system/arc_util.h"	///< A[JCup

#include "we_def.h"

///< No 300-
typedef struct {

	TWE_TOOL_SYS		ts;		///< ZGtFNgėp\
	TWE_POKE_SYS		poke;	///< |Pėp\
	CATS_ACT_PTR		cap;
	
	WAZATOOL_CALCMOVE	cm;		///< ėp[N
	WAZATOOL_CALCMOVE	cm_t;	///< ėp[N
	WAZATOOL_CALCMOVE	cm_t2;	///< ėp[N

	u8	loop;
	u8	wait;
	u8	eva;
	u8	evb;
	
	
} TWE_325_SYS;

static void We325_TCB(TCB_PTR tcb, void* work)
{
	TWE_325_SYS* wk = (TWE_325_SYS*)work;
	
	switch(wk->ts.seq){
	case 0:
		if (wk->loop == 0){
			WazaTool_InitStraightSyncFx(&wk->cm,
										wk->poke.p.x, wk->poke.p.x + 48,
										wk->poke.p.y, wk->poke.p.y,
										3);
			WazaTool_InitStraightSyncFx(&wk->cm_t,
										wk->poke.p.x, wk->poke.p.x + 48,
										wk->poke.p.y, wk->poke.p.y,
										6);
			WazaTool_InitStraightSyncFx(&wk->cm_t2,
										wk->poke.p.x, wk->poke.p.x + 48,
										wk->poke.p.y, wk->poke.p.y,
										8);
		}
		else {
			WazaTool_InitStraightSyncFx(&wk->cm,
										wk->poke.p.x + 48, wk->poke.p.x,
										wk->poke.p.y, wk->poke.p.y,
										3);
			WazaTool_InitStraightSyncFx(&wk->cm_t,
										wk->poke.p.x + 48, wk->poke.p.x,
										wk->poke.p.y, wk->poke.p.y,
										6);
			WazaTool_InitStraightSyncFx(&wk->cm_t2,
										wk->poke.p.x + 48, wk->poke.p.x,
										wk->poke.p.y, wk->poke.p.y,
										9);
		}
		wk->loop++;
		wk->ts.seq++;
		break;
	
	case 1:
		{
			int check = 0;
			if (WazaTool_CalcAndReflectStraightFxCap(&wk->cm_t, wk->poke.cap) == FALSE){
				check++;
			}
			if (WazaTool_CalcAndReflectStraightFxSsp(&wk->cm,   wk->poke.ssp) == FALSE){
				check++;
			}
			if (WazaTool_CalcAndReflectStraightFxCap(&wk->cm_t2,wk->cap) == FALSE){
				check++;
			}
			
			if (check >= 3){
				if (wk->loop == 1){
					wk->ts.seq--;
				}
				else {
					wk->ts.seq++;
				}
			}
		}
		break;
	
	default:
		///< 
		WEEffect_TCB_Delete(wk->ts.wsp, tcb);
		WET_SAFE_RELEASE(wk);
		return;
	}
	
	CATS_ObjectUpdateCap(wk->poke.cap);
	CATS_Draw(wk->ts.poke_crp);
}

void WestSp_WE_325(WE_SYS_PTR we_sys)
{
	TWE_325_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_325_SYS);
	
	WT_ToolSysInit(we_sys, &wk->ts);

	wk->wait = 0;
	wk->eva  = 8;
	wk->evb	 = 8;
	
	WET_DefaultBlendSet(wk->ts.wsp, WET_DEFAULT_BLEND, WET_DEFAULT_BLEND);
	G2_ChangeBlendAlpha(wk->eva, wk->evb);
	
	wk->poke.ssp = WeSysSoftSpritePointerGet(wk->ts.wsp, WeSysATNoGet(wk->ts.wsp));
	wk->poke.p.x = SoftSpriteParaGet(wk->poke.ssp, SS_PARA_POS_X);
	wk->poke.p.y = SoftSpriteParaGet(wk->poke.ssp, SS_PARA_POS_Y);
	wk->poke.cap = WeSysPokeCapGet(wk->ts.wsp, 0);
	wk->cap = WeSysPokeCapGet(wk->ts.wsp, 1);
	
	{
		CATS_ACT_PTR cap;
		int pal_pos;
		int index_no = WeSysPalIDGet(wk->ts.wsp, WeSysATNoGet(wk->ts.wsp));

		cap = wk->poke.cap;
		
		CATS_ObjectBGPriSetCap(cap, BT_3DPriorityGet(wk->ts.wsp)+1);
		pal_pos = GetPlttProxyOffset(CLACT_PaletteProxyGet(cap->act), NNS_G2D_VRAM_TYPE_2DMAIN);
		PokeColorChange(WeSysPFDGet(wk->ts.wsp), ARC_POKE_GRA, index_no,
						WeSysHeapAreaGet(wk->ts.wsp), FADE_MAIN_OBJ, 0x20, pal_pos * 16, 196,196,196);
		CATS_ObjectObjModeSetCap(cap, GX_OAM_MODE_XLU);

		cap = wk->cap;
		CATS_ObjectBGPriSetCap(cap, BT_3DPriorityGet(wk->ts.wsp)+1);
		pal_pos = GetPlttProxyOffset(CLACT_PaletteProxyGet(cap->act), NNS_G2D_VRAM_TYPE_2DMAIN);
		PokeColorChange(WeSysPFDGet(wk->ts.wsp), ARC_POKE_GRA, index_no,
						WeSysHeapAreaGet(wk->ts.wsp), FADE_MAIN_OBJ, 0x20, pal_pos * 16, 196,196,196);
		CATS_ObjectObjModeSetCap(cap, GX_OAM_MODE_XLU);
	}
	
	WEEffect_TCB_AddPriSet(wk->ts.wsp, We325_TCB, wk);
}


/// 338
#define WE338_OAM_MAX	(8)
typedef struct {
	
	TWE_TOOL_SYS	ts;
	
	s16				wait;
	s16				time[WE338_OAM_MAX];
	CATS_ACT_PTR	cap[WE338_OAM_MAX];
	
	WAZATOOL_CALCMOVE	cm;		///< ėp[N

} TWE_338_SYS;

static void We338_TCB(TCB_PTR tcb, void* work)
{
	TWE_338_SYS* wk = (TWE_338_SYS*)work;
	
	{
		int i;
		int check = 0;
		for (i = 0; i < WE338_OAM_MAX; i++){
			wk->time[i]++;
			if (wk->time[i] < 32){ continue; }
			
			EnableCheckAnime(wk->cap[i]);

			if (wk->time[i] >= 160){
				CATS_ObjectEnableCap(wk->cap[i], CATS_ENABLE_FALSE);
				check++;
			}
		}
		if (check == WE338_OAM_MAX){
			for (i = 0; i < WE338_OAM_MAX; i++){
				CATS_ActorPointerDelete_S(wk->cap[i]);
			}
			WEEffect_TCB_Delete(wk->ts.wsp, tcb);
			sys_FreeMemoryEz(wk);
			return;
		}
	}
	
	CATS_Draw(wk->ts.oam_crp);
}

void WestSp_CAT_WE_338(WE_SYS_PTR we_sys, CATS_SYS_PTR csp, CATS_RES_PTR crp, CATS_ACT_PTR cap)
{
	TWE_338_SYS* wk = NULL;
	
	wk = WET_ALLOC_MEMORY(we_sys, TWE_338_SYS);
	
	wk->wait = 10;
	WT_ToolSysInit(we_sys, &wk->ts);
	
	{
		int i;

		///< OAMo^
		{
			s16 ofs1,ofs2;
			TCATS_OBJECT_ADD_PARAM_S coap;
			coap = WeSysCoapGet(wk->ts.wsp);
			wk->cap[0]  = cap;
			for (i = 1; i < WE338_OAM_MAX; i++){
				wk->cap[i]  = CATS_ObjectAdd_S(wk->ts.csp, wk->ts.oam_crp, &coap);
				
				if (i % 2){
					CATS_ObjectFlipSetCap(wk->cap[i], CLACT_FLIP_H);
				}
			}
		}

		///< vZ
		{
			SOFT_SPRITE* ssp;
			s16 x1,x2,y1,y2;
			
			ssp = WeSysSoftSpritePointerGet(wk->ts.wsp, WeSysATNoGet(wk->ts.wsp));
			x1 = SoftSpriteParaGet(ssp, SS_PARA_POS_X);
			y1 = SoftSpriteParaGet(ssp, SS_PARA_POS_Y);
			ssp = WeSysSoftSpritePointerGet(wk->ts.wsp, WeSysDFNoGet(wk->ts.wsp));
			x2 = SoftSpriteParaGet(ssp, SS_PARA_POS_X);
			y2 = SoftSpriteParaGet(ssp, SS_PARA_POS_Y);
			
			WazaTool_InitStraightSyncFx(&wk->cm, x1, x2, y1, y2, (WE338_OAM_MAX+2) * 2);
		}

		///< ̔zu
		{
			BOOL res;
			int  cnt = 0;
			int  no  = 0;
			int skip = 0;
			if (WET_SideCheck(wk->ts.wsp, WeSysATNoGet(wk->ts.wsp)) == SIDE_ENEMY){
				skip = 1;
			}
			do {
				
				res = WazaTool_CalcStraightFx(&wk->cm);
				
				if (cnt % 2){
					if (skip == 0){						
						if (no < WE338_OAM_MAX){ 
							CATS_ObjectPosSetCap(wk->cap[no], wk->cm.x, wk->cm.y);
							no++;
						}
					}
					else {
						skip = 0;
					}
				}
				cnt++;
				
			} while(res == TRUE);
		}
	
		///< \ԌvZ
		{
			int pri = BT_BGL_BGNoGet(wk->ts.wsp, WES_BF_EFFECT);
			
			for (i = 0; i < WE338_OAM_MAX; i++){
				wk->time[i] = (WE338_OAM_MAX - i) * 4;
				
				if (WET_SideCheck(wk->ts.wsp, WeSysATNoGet(wk->ts.wsp)) == SIDE_MINE){
					if (i < 4){
						CATS_ObjectBGPriSetCap(wk->cap[i], pri);
					}
				}
				else {
					if (i >= 4){
						CATS_ObjectBGPriSetCap(wk->cap[i], pri);
					}
				}
				CATS_ObjectPriSetCap(wk->cap[i], WE338_OAM_MAX-i);
			}
		}
	}

	WEEffect_TCB_AddPriSet(wk->ts.wsp, We338_TCB, wk);
}
