//==============================================================================
/**
 * @file	wsp_tool.c
 * @brief	ZT|[g֐S
 * @author	goto
 * @date	2005.12.16()
 *
 * ɐFXȉĂ悢
 *
 */
//==============================================================================

#include "common.h"				///< K{
#include "system/lib_pack.h"	///< K{
#include "west_sp.h"			///< K{
#include "wsp.h"				///< wsp.h

#include "wazatool.h"			///< ZGtFNgx֐S
#include "we_tool.h"			///< 

#include "ball_effect.h"
#include "system/arc_tool.h"	///< A[JCup
#include "system/arc_util.h"	///< A[JCup

#include "we_def.h"

// -----------------------------------------
//
//
//		[ __WE_T01__ ]	
//
//
// -----------------------------------------
// VXe\
typedef struct {
	
	int num;	

	TWE_TOOL_SYS		ts;
	TWE_SHAKE_TOOL		st;
	
	TWE_POKE_SYS		poke[ WE_POKE_DATA_MAX ];

	WAZATOOL_CALCMOVE	cm;
	
} TWE_T01_SYS;

//--------------------------------------------------------------
/**
 * @brief	TCB
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void WeT01_TCB(TCB_PTR tcb, void* work)
{
	int i;
	TWE_T01_SYS* wk = (TWE_T01_SYS*)work;

	switch(wk->ts.seq){
	case 0:
		///< ꕝw
		WazaTool_InitShake(&wk->cm, wk->st.x, wk->st.y, wk->st.w, wk->st.n);
		wk->ts.seq++;
		break;
		
	case 1:
		///< 
		if (WazaTool_CalcShake(&wk->cm) == FALSE){
			wk->ts.seq++;
		}
		else {
			if (IsBitCheck(wk->st.mode, WE_TOOL_SSP) == TRUE){
				for (i = 0; i < wk->num; i++){
					if (wk->poke[i].ssp == NULL){ continue; }
					
					SoftSpriteParaSet(wk->poke[i].ssp, SS_PARA_POS_X, wk->poke[i].p.x + wk->cm.x);
					SoftSpriteParaSet(wk->poke[i].ssp, SS_PARA_POS_Y, wk->poke[i].p.y + wk->cm.y);
				}
			}
			else if (IsBitCheck(wk->st.mode, WE_TOOL_CAP) == TRUE){
				for (i = 0; i < wk->num; i++){
					if (wk->poke[i].cap == NULL){ continue; }
					
					CATS_ObjectPosSetCap(wk->poke[i].cap, wk->poke[i].p.x + wk->cm.x, wk->poke[i].p.y + wk->cm.y);
					CATS_ObjectUpdateCap(wk->poke[i].cap);
				}
				CATS_Draw(wk->ts.poke_crp);
			}

			if (IsBitCheck(wk->st.mode, WE_TOOL_BG) == TRUE){
				GF_BGL_ScrollSet(wk->ts.bgl, BATTLE_FRAME_BACKGROUND, GF_BGL_SCROLL_X_SET, wk->cm.x);
			}
		}
		break;
		
	default:
		WEEffect_TCB_Delete(wk->ts.wsp, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}

void WestSp_WE_T01(WE_SYS_PTR we_sys)
{
	TWE_T01_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_T01_SYS);
	
	int i;

	WT_ToolSysInit(we_sys, &wk->ts);
	
	wk->st.x	= WeSysGPWorkGet(we_sys, 0);
	wk->st.y	= WeSysGPWorkGet(we_sys, 1);
	wk->st.w	= WeSysGPWorkGet(we_sys, 2);
	wk->st.n	= WeSysGPWorkGet(we_sys, 3);
	wk->st.mode = WeSysGPWorkGet(we_sys, 4);
	
	if (IsBitCheck(wk->st.mode, WE_TOOL_SSP) == TRUE){
		WT_SSPointerGet(we_sys, wk->st.mode, &(wk->poke[0]), &wk->num);
	}
	else if (IsBitCheck(wk->st.mode, WE_TOOL_CAP) == TRUE){
		WT_CAPointerGet(we_sys, wk->st.mode, &(wk->poke[0]), &wk->num);
	}
	WEEffect_TCB_AddPriSet(wk->ts.wsp, WeT01_TCB, wk);
}

// -----------------------------------------
//
//
//		[ __WE_T02__ ]	
//
//
// -----------------------------------------
// wiVXe\ gpɂȂ肻B
typedef struct {
	int rev;
	int fade_flag;
	u16	bld_def;
	s16 pos_x;
	s16 pos_y;
	s16 spd_x;
	s16 spd_y;
	
	u16 ev1;
	u16 ev2;

	TWE_TOOL_SYS		ts;
	TWE_SHAKE_TOOL		st;
	
	TWE_POKE_SYS		poke[ WE_POKE_DATA_MAX ];

	WAZATOOL_CALCMOVE	cm;
	
} TWE_T02_SYS;

#define WET02_STOP_Y_1		(512)
#define WET02_STOP_Y_2		(-412)
#define WET02_START_Y_OFS	(128)

//--------------------------------------------------------------
/**
 * @brief	TCB
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void WeT02_TCB(TCB_PTR tcb, void* work)
{
	TWE_T02_SYS* wk = (TWE_T02_SYS*)work;

	switch(wk->ts.seq){
	case 0:
		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2,
						 GX_BLEND_PLANEMASK_BD  | GX_BLEND_PLANEMASK_OBJ |
						 GX_BLEND_PLANEMASK_BG0 | GX_BLEND_PLANEMASK_BG3,
						 wk->ev1, wk->ev2);
		GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_ON);
		wk->ts.seq++;
		
	case 1:
		{
			int ev_sw = 0;
			if (wk->ev1 < wk->bld_def - 2){
				wk->ev1 += 2;
			}
			else {
				ev_sw++;
			}
			if (wk->ev2 > wk->bld_def + 2){
				wk->ev2 -= 2;
			}
			else {
				ev_sw++;
			}
			if (ev_sw == 2){
				wk->ev1 = wk->bld_def;
				wk->ev2 = wk->bld_def;
				wk->ts.seq++;
			}
			G2_ChangeBlendAlpha(wk->ev1, wk->ev2);
		}
		break;
	case 2:
		if (wk->fade_flag){
			wk->ts.seq++;
		}
		break;
	case 3:
		{
			int ev_sw = 0;
			if (wk->ev1 > 2){
				wk->ev1 -= 2;
			}
			else {
				ev_sw++;
			}
			if (wk->ev2 < 31-2){
				wk->ev2 += 2;
			}
			else {
				ev_sw++;
			}
			if (ev_sw == 2){
				wk->ev1 = 0;
				wk->ev2 = 31;
				wk->ts.seq++;
			}
			G2_ChangeBlendAlpha(wk->ev1, wk->ev2);
		}
		break;
	default:
		GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_OFF);
		WEEffect_TCB_Delete(wk->ts.wsp, tcb);
		sys_FreeMemoryEz(wk);
		return;
	}

	if ((wk->spd_y > 0 && wk->pos_y >= WET02_STOP_Y_1)
	||  (wk->spd_y < 0 && wk->pos_y <= WET02_STOP_Y_2)){
		wk->fade_flag = 1;
	}

	wk->pos_x += wk->spd_x;
	wk->pos_y += wk->spd_y;
		
	GF_BGL_ScrollSet(wk->ts.bgl, BATTLE_FRAME_EFFECT, GF_BGL_SCROLL_X_SET, wk->pos_x);
	GF_BGL_ScrollSet(wk->ts.bgl, BATTLE_FRAME_EFFECT, GF_BGL_SCROLL_Y_SET, wk->pos_y);
}


//--------------------------------------------------------------
/**
 * @brief	Ăяo֐
 *
 * @param	we_sys	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WestSp_WE_T02(WE_SYS_PTR we_sys)
{
	TWE_T02_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_T02_SYS);
	
	int i;

	WT_ToolSysInit(we_sys, &wk->ts);
	
	wk->pos_x	= WeSysGPWorkGet(we_sys, 1);
	wk->pos_y	= WeSysGPWorkGet(we_sys, 2);
	wk->spd_x	= WeSysGPWorkGet(we_sys, 3);
	wk->spd_y	= WeSysGPWorkGet(we_sys, 4);
	wk->rev		= WeSysGPWorkGet(we_sys, 5);
	wk->bld_def	= WeSysGPWorkGet(we_sys, 6);
	
	if (wk->rev != 0
	&&	WET_SideCheck(we_sys, WeSysATNoGet(we_sys)) == SIDE_ENEMY){
		wk->pos_x	*= -1;
		wk->pos_y	*= -1;
		wk->spd_x	*= -1;
		wk->spd_y	*= -1;
	}
	
	if (wk->pos_y > 0){
		wk->pos_y += WET02_START_Y_OFS;
	}

	wk->ev1 = 0;
	wk->ev2	= 31;
	wk->fade_flag = 0;
	
	GF_BGL_VisibleSet(BATTLE_FRAME_EFFECT, VISIBLE_OFF);
	{
		int arc = WeSysGPWorkGet(we_sys, 0);
		ArcUtil_BgCharSet(WE_HAIKEI_ARC,
						  WeSysHaikeiDataIDGet(arc, 0),
						  wk->ts.bgl,
						  BATTLE_FRAME_EFFECT, 0, 0, 1, WeSysHeapAreaGet(we_sys));

		PaletteWorkSet_Arc(wk->ts.pfd,
						   WE_HAIKEI_ARC,
						   WeSysHaikeiDataIDGet(arc, 1),
						   WeSysHeapAreaGet(we_sys), FADE_MAIN_BG, 0x20, WEDEF_BG_DATA_COL_POS);
						   
		GF_BGL_ScrClear(wk->ts.bgl, BATTLE_FRAME_EFFECT);
		
		{
			int idx = 2;
			
			if (WET_SideCheck(we_sys, WeSysATNoGet(we_sys)) == SIDE_ENEMY){
				idx = 3;
			}
			ArcUtil_ScrnSet(WE_HAIKEI_ARC,
							WeSysHaikeiDataIDGet(arc, idx),
							wk->ts.bgl,
							BATTLE_FRAME_EFFECT, 0, 0, 1, WeSysHeapAreaGet(we_sys));
		}
	}
	GF_BGL_ScrollSet(wk->ts.bgl, BATTLE_FRAME_EFFECT, GF_BGL_SCROLL_X_SET, wk->pos_x);
	GF_BGL_ScrollSet(wk->ts.bgl, BATTLE_FRAME_EFFECT, GF_BGL_SCROLL_Y_SET, wk->pos_y);
	
	WEEffect_TCB_AddPriSet(wk->ts.wsp, WeT02_TCB, wk);
}


//-----------------------------------------------------------------------------
/**
 *		̃|P]^XN
 */
//-----------------------------------------------------------------------------
//V[PX
enum{
	WAZATOOL_POKE_ROTA00_MAIN = 0,
	WAZATOOL_POKE_ROTA00_REMOVE,
	WAZATOOL_POKE_ROTA00_END,
};
// [N
typedef struct{
	u8	seq;
	WE_SYS_PTR	ws;			///< [U[pӂ郏[NɕK{̃o
	
	// \tgXvCgf[^
	SOFT_SPRITE* ss;

	// ]vZp[N
	WAZATOOL_CALCMOVE_ONE	calc_rota;
	s32	start;	// Jn]px
	int sync;	// ۑ

} TEFFECT_TCB_POKE_ROTA00;

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P]
 *
 *	@param	tcb		tcb[N
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void EffectTCB_PokeRota00(TCB_PTR tcb, void* work)
{
	TEFFECT_TCB_POKE_ROTA00* wk = work;

	switch( wk->seq ){
	case WAZATOOL_POKE_ROTA00_MAIN:
	case WAZATOOL_POKE_ROTA00_REMOVE:
		if( WazaTool_CalcMoveOne( &wk->calc_rota ) == TRUE ){
			
			// |P̉]p[^ݒ
			// I[o[Ă\̂u16ŃLXgēn
			SoftSpriteParaSet( wk->ss, SS_PARA_ROT_Z, (u16)wk->calc_rota.num );
		}else{
			
			// ɖ߂^XN
			WazaTool_InitMoveOneSync( &wk->calc_rota, wk->calc_rota.num, wk->start, wk->sync );
			wk->seq++;
		}
		break;

	case WAZATOOL_POKE_ROTA00_END:
		// ]Wݒ
		SoftSpriteParaSet( wk->ss, SS_PARA_ROT_CX, 0 );
		SoftSpriteParaSet( wk->ss, SS_PARA_ROT_CY, 0 );

		// TCBj
		WEEffect_TCB_Delete(wk->ws, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief	|PƉ]GtFNg^XN
 *
 * @param	we_sys	
 *
 * @retval	none	
 *
 * ŎgpĂ܂B
 *
 * we_sys̈gp܂B
 * wk[0]	Jnpx	(0`65535)	65535360x
 * wk[1]	Ipx	(0`65535)	65535360x
 * wk[2]	VN	(}CiXs\)
 * 
 */
//--------------------------------------------------------------
void WestSp_EffectTCBPokeRota00(WE_SYS_PTR we_sys)
{
	TEFFECT_TCB_POKE_ROTA00* wk;
	int r_vec;	// ]PʃxNg
	int type;
	int clno;
	
	wk = sys_AllocMemory(WeSysHeapAreaGet(we_sys), sizeof(TEFFECT_TCB_POKE_ROTA00));
	
	wk->seq = 0;
	wk->ws	= we_sys;

	wk->sync	= WeSysGPWorkGet(we_sys, 2);	// VN
	wk->start	= WeSysGPWorkGet(we_sys, 0);	// Jn]p

	type = WeSysGPWorkGet(we_sys, 3);	///< Ώ
	
	{
		if (type == 0){
			clno = WeSysDFNoGet(wk->ws);
		}
		else {
			clno = WeSysATNoGet(wk->ws);
		}
	}

	// ]f[^̏s
	//	p[^gp
	WazaTool_InitMoveOneSync( &wk->calc_rota,
			wk->start,
			WeSysGPWorkGet(we_sys, 1),
			wk->sync );
	
	// ]ݒ
	// ]xNg擾
	r_vec = WazaTool_VecChangeX( we_sys, clno );

	// ]xNg|
	wk->calc_rota.work[1] *= r_vec;

	// XvCgf[^擾
	wk->ss = WeSysSoftSpritePointerGet( wk->ws, clno );

	// ]Wݒ
	SoftSpriteParaSet( wk->ss, SS_PARA_ROT_CX, (SOFT_SPRITE_SIZE_X / 2) * r_vec );
	SoftSpriteParaSet( wk->ss, SS_PARA_ROT_CY, SOFT_SPRITE_SIZE_Y / 2 );

	WEEffect_TCB_AddPriSet(wk->ws, EffectTCB_PokeRota00, wk);
}


//-------------------------------------
//	
//	
//	(邭])
//	
//=====================================
typedef struct{
	WE_SYS_PTR	we_sys;

	WAZATOOL_CALCMOVE wtc;
	SOFT_SPRITE*	ssp;
	s16	x;
	s16 y;
} TWE_066_SYS;


//----------------------------------------------------------------------------
/**
 *	@brief	TCB
 *
 *	@param	tcb
 *	@param	work
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void We066_TCB(TCB_PTR tcb, void* work)
{
	TWE_066_SYS* wk = work;

	// 삪SɏI܂ő҂ďI
	// 암
	if( WazaTool_CalcAndReflectRotaFxSsp( &wk->wtc, wk->x, wk->y, wk->ssp ) == FALSE ){

		// Wݒ
		SoftSpriteParaSet( wk->ssp, SS_PARA_POS_X, wk->x );
		SoftSpriteParaSet( wk->ssp, SS_PARA_POS_Y, wk->y + (WAZATOOL_DEF_ROTA_W_Y >> FX32_SHIFT) );

		// I
		WEEffect_TCB_Delete(wk->we_sys, tcb);
		sys_FreeMemoryEz(wk);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief		
 *
 *	@param	we_sys	ZGtFNgVXe[N
 *
 *	@return	none
 *
 * we_sys.work[0]	]
 * we_sys.work[1]	P]VN
 * we_sys.work[2]	Ώۃ|P	iṔj
 *
 */
//-----------------------------------------------------------------------------
void WestSp_WE_066( WE_SYS_PTR we_sys )
{
	TWE_066_SYS* wk;
	
	wk = sys_AllocMemory(WeSysHeapAreaGet(we_sys), sizeof(TWE_066_SYS));

	wk->we_sys	= we_sys;
	
	// |P@f[^쐬
	WazaTool_MakeDefRota(
			&wk->wtc,
			WeSysGPWorkGet(we_sys, 0),
			WeSysGPWorkGet(we_sys, 1) );

	// |PXvCgf[^擾
	switch( WeSysGPWorkGet(we_sys, 2) ){
	case WE_TOOL_M1:
		wk->ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysATNoGet(we_sys) );
		// ]ݒ
		// Ủ] txNgɂ
		wk->wtc.work[2] *= -1;
		break;

	case WE_TOOL_M2:
		wk->ssp = WeSysSoftSpritePointerGet(wk->we_sys, WET_AllySideClientNoGet(wk->we_sys, WeSysATNoGet(wk->we_sys)));

		// ]ݒ
		// Ủ] txNgɂ
		wk->wtc.work[2] *= -1;
		break;
	
	case WE_TOOL_E1:
		wk->ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysDFNoGet(we_sys) );
		break;

	case WE_TOOL_E2:
		wk->ssp = WeSysSoftSpritePointerGet(wk->we_sys, WET_AllySideClientNoGet(wk->we_sys, WeSysDFNoGet(wk->we_sys)));
		break;

	default:
		GF_ASSERT_MSG( 0, "̃|Pw肷邱Ƃo܂B" );
		break;
	}

	wk->x = SoftSpriteParaGet( wk->ssp, SS_PARA_POS_X );
	wk->y = SoftSpriteParaGet( wk->ssp, SS_PARA_POS_Y );
	// W]Yɕ␳
	wk->y -= WAZATOOL_DEF_ROTA_W_Y >> FX32_SHIFT;


	WEEffect_TCB_AddPriSet(wk->we_sys, We066_TCB, wk);
}


//-------------------------------------
//	
//	΂
//		ȂǂŎgp
//		L}[N̕\
//	
//=====================================
// ܁[
enum{
	WE207_KIRESYS_MOVE,
	WE207_KIRESYS_END,
};
enum{
	WE207_KIRE_START,
	WE207_KIRE_1DRAW,
	WE207_KIRE_WAIT,
	WE207_KIRE_2DRAW,
	WE207_KIRE_END
};

#define WE207_SCALE_CAP_S		( 10 )
#define WE207_SCALE_CAP_D		( 10 )
#define WE207_SCALE_CAP_E		( 14 )
#define WE207_SCALE_CAP_SYNC	( 4 )
#define WE207_SCALERET_CAP_S		( 14 )
#define WE207_SCALERET_CAP_D		( 10 )
#define WE207_SCALERET_CAP_E		( 12 )
#define WE207_SCALERET_CAP_SYNC		( 2 )

#define WE207_CAP_OFS_X		( 24 )
#define WE207_CAP_OFS_Y		( 16 )
#define WE207_CAP_OFS_Y2	( 24 )

#define WE207_SCALE_CAP_WAIT	( 4 )

typedef struct {
	WE_SYS_PTR	we_sys;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	int seq;
	int wait;
	
	// ܁[
	CATS_ACT_PTR cap;
	WAZATOOL_CALCMOVE cap_scale;
	int cap_vec_x;
	int cap_scale_flg;
	int cap_wait;
	int cap_seq;
	s16 df_x;
	s16 df_y;

} TWE207_SYS_SUB;

static void We207_InitCapObj(  TWE207_SYS_SUB* wk, s16 x, s16 y  )
{
	CATS_ObjectEnableCap( wk->cap, TRUE );
	CATS_ObjectPosSetCap( wk->cap, x, y );
	wk->cap_scale_flg = 0;
		
	WazaTool_InitScaleRate(
			&wk->cap_scale,
			WE207_SCALE_CAP_S,
			WE207_SCALE_CAP_D,
			WE207_SCALE_CAP_E,
			WE207_SCALE_CAP_SYNC
			);
}

static BOOL We207_MoveCapObj( TWE207_SYS_SUB* wk )
{
	if( WazaTool_CalcAndReflectScaleRateCap( &wk->cap_scale, wk->cap ) == FALSE ){
		
		if( wk->cap_scale_flg ){
			CATS_ObjectEnableCap( wk->cap, FALSE );
			return TRUE;
		}else{
			wk->cap_scale_flg = 1;

			WazaTool_InitScaleRate(
					&wk->cap_scale,
					WE207_SCALERET_CAP_S,
					WE207_SCALERET_CAP_D,
					WE207_SCALERET_CAP_E,
					WE207_SCALERET_CAP_SYNC
					);

		}
	}

	return FALSE;
}

static BOOL We207_CapMove( TWE207_SYS_SUB* wk )
{
	BOOL ret = FALSE;
	
	switch( wk->cap_seq ){
	case WE207_KIRE_START:
		We207_InitCapObj( wk, wk->df_x + (WE207_CAP_OFS_X * wk->cap_vec_x), wk->df_y - WE207_CAP_OFS_Y );
		wk->cap_seq++;
		break;

	case WE207_KIRE_1DRAW:
		if( We207_MoveCapObj( wk ) ){
			wk->cap_seq++;
		}
		break;

	case WE207_KIRE_WAIT:
		wk->cap_wait --;
		if( wk->cap_wait < 0 ){
			wk->cap_seq++;
			We207_InitCapObj( wk, wk->df_x - (WE207_CAP_OFS_X * wk->cap_vec_x), wk->df_y - WE207_CAP_OFS_Y2 );
		}
		break;
		
	case WE207_KIRE_2DRAW:
		if( We207_MoveCapObj( wk ) ){
			wk->cap_seq++;
		}
		break;

	case WE207_KIRE_END:
		ret = TRUE;
		break;
	}

	return ret;
}

static void We207_TCB_SUB( TCB_PTR tcb, void* work )
{
	TWE207_SYS_SUB* wk = work;
	
	switch( wk->seq ){
	case WE207_KIRESYS_MOVE:
		if( We207_CapMove( wk ) ){
			wk->seq++;
		}
		break;

	case WE207_KIRESYS_END:
		CATS_ActorPointerDelete_S(wk->cap);
		// I
		WEEffect_TCB_Delete(wk->we_sys, tcb);
		sys_FreeMemoryEz(wk);
		return;
	}

	// OAM`
	CATS_Draw(wk->crp);	
}

//----------------------------------------------------------------------------
/**
 * @brief	L}[Np^XNo^
 *
 *	@param	we_sys	ZGtFNgVXe[N
 *	@param	csp		ZAN^[c[VXe
 *	@param	crp		ZAN^[\[XVXe
 *	@param	cap		ZAN^[c[IuWF
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void WestSp_CAT_WE_207_SUB(WE_SYS_PTR we_sys, CATS_SYS_PTR csp, CATS_RES_PTR crp, CATS_ACT_PTR cap)
{
	TWE207_SYS_SUB* wk;
	SOFT_SPRITE* df_ssp;

	wk = WET_ALLOC_MEMORY(we_sys, TWE207_SYS_SUB);
	wk->we_sys	= we_sys;
	wk->csp		= csp;
	wk->crp		= crp;

	// ܁[
	wk->cap = cap;
	CATS_ObjectPriSetCap( wk->cap, WAZAEFF_ACT_SOFTPRI );
	CATS_ObjectBGPriSetCap( wk->cap, WAZAEFF_ACT_BGPRI );
	CATS_ObjectAffineSetCap( wk->cap, CLACT_AFFINE_DOUBLE );
	CATS_ObjectEnableCap( wk->cap, FALSE );
	wk->cap_wait = WE207_SCALE_CAP_WAIT;
	wk->cap_vec_x = WazaTool_VecChangeX( wk->we_sys, WeSysATNoGet(wk->we_sys) );
	

	df_ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysDFNoGet(we_sys) );
	wk->df_x = SoftSpriteParaGet( df_ssp, SS_PARA_POS_X );
	wk->df_y = SoftSpriteParaGet( df_ssp, SS_PARA_POS_Y );

	WEEffect_TCB_AddPriSet(wk->we_sys, We207_TCB_SUB, wk);
}



//-------------------------------------
//	
//	wipbgtF[h֐
//	
//=====================================
typedef struct {
	WE_SYS_PTR we_sys;
	PALETTE_FADE_PTR pfd;
} TWEBG_PAL_FADE;

#define TWEBG_BG_PAL_BIT	( WEDEF_BACKGROUND_PAL )
#define TWEBG_EF1_PAL_BIT	( 1 << BATTLE_PAL_EFF_0 )
#define TWEBG_EF2_PAL_BIT	( 1 << BATTLE_PAL_EFF_1 )

static void WeBGPalFade_TCB( TCB_PTR tcb, void* work )
{
	TWEBG_PAL_FADE* wk = work;
	
	if (PaletteFadeCheck(wk->pfd) == 0){
		sys_FreeMemoryEz(wk);
		WEEffect_TCB_Delete(wk->we_sys, tcb);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wipbgtF[hݒ
 *
 *	@param	we_sys		ZGtFNgVXe
 *
 *	@return	none
 *
 * we_sys.work[0]	0=wi 1=GtFNg1(pokemon)  2=GtFNg2(other)
 * we_sys.work[1]	wait	vZ҂
 * we_sys.work[2]	start	Zx
 * we_sys.work[3]	end		ŏIZx
 * we_sys.work[4]	color	ύX̐F
 *
 */
//-----------------------------------------------------------------------------
void WestSp_WE_HaikeiPalFade(WE_SYS_PTR we_sys)
{
	TWEBG_PAL_FADE* wk;
	u16 fade_bit;

	wk = WET_ALLOC_MEMORY(we_sys, TWEBG_PAL_FADE);
	wk->we_sys	= we_sys;
	wk->pfd		= WeSysPFDGet(wk->we_sys);
	
	// ӂ[ǃrbg擾
	switch( WeSysGPWorkGet(we_sys, 0) ){
	case 0:
		fade_bit = TWEBG_BG_PAL_BIT;
		break;
		
	case 1:
		fade_bit = TWEBG_EF1_PAL_BIT;
		break;
	
	case 2:
		fade_bit = TWEBG_EF2_PAL_BIT;
		break;

	default:
		GF_ASSERT_MSG( 0, "color=0,1,2" );
		break;
	}
	
	PaletteFadeReq(wk->pfd, PF_BIT_MAIN_BG, fade_bit,
			WeSysGPWorkGet(we_sys, 1),
			WeSysGPWorkGet(we_sys, 2),
			WeSysGPWorkGet(we_sys, 3),
			WeSysGPWorkGet(we_sys, 4)
			);
	
	WEEffect_TCB_AddPriSet(wk->we_sys, WeBGPalFade_TCB, wk);
}

// SOFT_SPRITE pbgtF[h_
enum{
	TWE_SSP_POKE_PAL_FADEOUT_INIT,
	TWE_SSP_POKE_PAL_FADEOUT_MOVE,
	TWE_SSP_POKE_PAL_FADE_WAIT,
	TWE_SSP_POKE_PAL_FADEIN_INIT,
	TWE_SSP_POKE_PAL_FADEIN_MOVE,
	TWE_SSP_POKE_PAL_FADE_END,
};
typedef struct {
	WE_SYS_PTR we_sys;
	SOFT_SPRITE* ssp;
	int seq;
	int count;
	int fade_wait;
	int rgb;
	int evy_max;
	
	int wait;
} TWE326_SSP_POKE_PAL_FADE;

static void WeSSPPokePalFade_TCB( TCB_PTR tcb, void* work )
{
	TWE326_SSP_POKE_PAL_FADE* wk = work;

	switch( wk->seq ){
	case TWE_SSP_POKE_PAL_FADEOUT_INIT:
		SoftSpritePalFadeSet( wk->ssp, 0, wk->evy_max, wk->fade_wait, wk->rgb );
		wk->seq++;
		break;
		
	case TWE_SSP_POKE_PAL_FADEOUT_MOVE:
		if( SoftSpritePalFadeExist( wk->ssp ) == FALSE ){
			wk->seq++;
		}
		break;
	
	case TWE_SSP_POKE_PAL_FADE_WAIT:
		if (wk->wait == 0){
			wk->seq++;
		}
		else {
			wk->wait--;
			break;
		}
		
	case TWE_SSP_POKE_PAL_FADEIN_INIT:
		SoftSpritePalFadeSet( wk->ssp, wk->evy_max, 0, wk->fade_wait, wk->rgb );
		wk->seq++;
		break;
		
	case TWE_SSP_POKE_PAL_FADEIN_MOVE:
		if( SoftSpritePalFadeExist( wk->ssp ) == FALSE ){
			wk->count --;
			if( wk->count <= 0 ){
				// I
				wk->seq++;
			}else{
				wk->seq = TWE_SSP_POKE_PAL_FADEOUT_INIT;
			}
		}
		break;
		
	case TWE_SSP_POKE_PAL_FADE_END:
		sys_FreeMemoryEz(wk);
		WEEffect_TCB_Delete(wk->we_sys, tcb);
		return;
	}

}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCg@|P@pbgtF[h_
 *
 *	@param	we_sys		ZGtFNgVXe
 *
 *	@return	none
 *
 * we_sys.work[0]			Ώۃ|P WE_TOOL_M1 ... (1wł܂)
 * we_sys.work[1]	wait	vZ҂
 * we_sys.work[2]	num		_Ő
 * we_sys.work[3]	color	ύX̐F
 * we_sys.work[4]	evy_max	ő̃tF[hF(16iK)
 *
 * JnF0ł 
 */
//-----------------------------------------------------------------------------
void WestSp_WE_SSPPokePalFade(WE_SYS_PTR we_sys)
{
	TWE326_SSP_POKE_PAL_FADE* wk;

	wk = WET_ALLOC_MEMORY(we_sys, TWE326_SSP_POKE_PAL_FADE);
	wk->we_sys	= we_sys;
	wk->ssp		= NULL;

	// |PXvCgf[^擾
	switch( WeSysGPWorkGet(we_sys, 0) ){
	case WE_TOOL_M1:
		wk->ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysATNoGet(we_sys) );
		break;

	case WE_TOOL_M2:
		if (IsWeSysBattleMode2vs2(we_sys) == TRUE){
			wk->ssp = WeSysSoftSpritePointerGet(wk->we_sys, WET_AllySideClientNoGet(wk->we_sys, WeSysATNoGet(wk->we_sys)));
		}
		break;
	
	case WE_TOOL_E1:
		wk->ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysDFNoGet(we_sys) );
		break;

	case WE_TOOL_E2:
		if (IsWeSysBattleMode2vs2(we_sys) == TRUE){
			wk->ssp = WeSysSoftSpritePointerGet(wk->we_sys, WET_AllySideClientNoGet(wk->we_sys, WeSysDFNoGet(wk->we_sys)));
		}
		break;

	default:
		GF_ASSERT_MSG( 0, "̃|Pw肷邱Ƃo܂B" );
		break;
	}
	
	if (wk->ssp == NULL){
		sys_FreeMemoryEz(wk);
		return;
	}

	wk->fade_wait	= WeSysGPWorkGet(we_sys, 1);
	wk->count		= WeSysGPWorkGet(we_sys, 2);
	wk->rgb			= WeSysGPWorkGet(we_sys, 3);
	wk->evy_max		= WeSysGPWorkGet(we_sys, 4);
	wk->wait		= WeSysGPWorkGet(we_sys, 5);

	WEEffect_TCB_AddPriSet(wk->we_sys, WeSSPPokePalFade_TCB, wk);
}



//-------------------------------------
//	
// POKE_OAM𔼓ɂĊg債ďk
//	
//=====================================
enum{
	WE326_POKE_OAM_SCALEUP_INIT,
	WE326_POKE_OAM_SCALEUP,
	WE326_POKE_OAM_SCALEDOWN_INIT,
	WE326_POKE_OAM_SCALEDOWN,
	WE326_POKE_OAM_SCALEEND,
};

#define WE326_POKE_OAM_DOWN_OFS	( 40 )
typedef struct {
	WE_SYS_PTR we_sys;
	CATS_RES_PTR crp;
	int seq;

	s16 dy;			// ̃|WV
	s16 poke_h;		// |P̍

	// |P
	CATS_ACT_PTR		cap;
	WAZATOOL_CALCMOVE	cap_scale;

	int poke_alpha;
	int scale_s;
	int scale_e;
	int scale_d;
	int scale_num;		// LтďkނPƂ
	int scale_sync;		// LтďkނɂP̂񂭐
} TWE326_POKE_OAM_SCALE_UPDOWN;

static void WeCAPPokeScaleUpDownTCB( TCB_PTR tcb, void* work )
{
	TWE326_POKE_OAM_SCALE_UPDOWN* wk = work;

	switch( wk->seq ){
	case WE326_POKE_OAM_SCALEUP_INIT:
		WazaTool_InitScaleRate(
				&wk->cap_scale,
				wk->scale_s,
				wk->scale_d,
				wk->scale_e,
				wk->scale_sync >> 16
				);
		// gklݒ
		WazaTool_CalcAndReflectScaleRateCap( &wk->cap_scale, wk->cap );
		wk->seq++;
		break;
		
	case WE326_POKE_OAM_SCALEUP:
		// gklݒ
		if( WazaTool_CalcAndReflectScaleRateCap( &wk->cap_scale, wk->cap ) ){

			WazaTool_PokeOffsetSetOAM(
					wk->cap,
					wk->dy, wk->poke_h,
					wk->cap_scale.work[4], WAZAEFF_OFS_MODE_BOTTOM);

		}else{
			wk->seq++;
		}
		break;
		
	case WE326_POKE_OAM_SCALEDOWN_INIT:
		WazaTool_InitScaleRate(
				&wk->cap_scale,
				wk->scale_e,
				wk->scale_d,
				wk->scale_s,
				wk->scale_sync & 0xffff
				);
		wk->seq++;
		break;
		
	case WE326_POKE_OAM_SCALEDOWN:
		// gklݒ
		if( WazaTool_CalcAndReflectScaleRateCap( &wk->cap_scale, wk->cap ) ){
			WazaTool_PokeOffsetSetOAM(
					wk->cap,
					wk->dy, wk->poke_h,
					wk->cap_scale.work[4], WAZAEFF_OFS_MODE_BOTTOM);
		}else{
			wk->scale_num --;
			if( wk->scale_num <= 0 ){
				// I
				wk->seq++;
			}else{
				wk->seq = WE326_POKE_OAM_SCALEUP_INIT;
			}
		}
		break;
		
	case WE326_POKE_OAM_SCALEEND:
		sys_FreeMemoryEz(wk);
		WEEffect_TCB_Delete(wk->we_sys, tcb);
		return;
	}

	// cOAM`
	CATS_Draw(wk->crp);	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	POKE_OAM 𔼓ԂŐLяk݂	
 *
 *	@param	we_sys		ZGtFNgVXe
 *
 *	@return	none
 *
 * we_sys.work[0]	at or df	0=U	1=h䑤
 * we_sys.work[1]	alpha		|P̃l
 * we_sys.work[2]	scale_s		JnXP[
 * we_sys.work[3]	scale_e		IXP[
 * we_sys.work[4]	scale_d		100%̎̃XP[
 * we_sys.work[5]	scale_num	XP[	LтďkނPƂ
 * we_sys.work[6]	scale_sync	VN	LтVN 16bit	kރVN 16bit
 * we_sys.work[7]	cap_no		|Pcap̔ԍ
 *
 * |PCAPwe_sys.work[7] ԖڂɃ|P̊GĂĂ
 */
//-----------------------------------------------------------------------------
void WestSp_WE_CAPPokeScaleUpDown(WE_SYS_PTR we_sys)
{
	TWE326_POKE_OAM_SCALE_UPDOWN* wk;
	SOFT_SPRITE* ssp;

	wk = WET_ALLOC_MEMORY(we_sys, TWE326_POKE_OAM_SCALE_UPDOWN);
	wk->we_sys	= we_sys;
	wk->crp		= WeSysPokeCrpGet(wk->we_sys);

	// |P̍擾
	if( WeSysGPWorkGet(we_sys, 0) == 0 ){
		ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysATNoGet(we_sys) );

		wk->poke_h	= WeSysPokeOfsGet(wk->we_sys, WeSysATNoGet(wk->we_sys));
	}else{
		ssp = WeSysSoftSpritePointerGet( wk->we_sys, WeSysDFNoGet(wk->we_sys) );
		wk->poke_h	= WeSysPokeOfsGet(wk->we_sys, WeSysDFNoGet(wk->we_sys));
	}
	wk->dy = SoftSpriteParaGet( ssp, SS_PARA_POS_Y );
	
	wk->poke_alpha	= WeSysGPWorkGet(we_sys, 1);
	wk->scale_s		= WeSysGPWorkGet(we_sys, 2);
	wk->scale_e		= WeSysGPWorkGet(we_sys, 3);
	wk->scale_d		= WeSysGPWorkGet(we_sys, 4);
	wk->scale_num	= WeSysGPWorkGet(we_sys, 5);
	wk->scale_sync	= WeSysGPWorkGet(we_sys, 6);

	wk->cap = WeSysPokeCapGet(wk->we_sys, WeSysGPWorkGet(we_sys, 7));
	CATS_ObjectPriSetCap( wk->cap, WAZAEFF_ACT_SOFTPRI );
	CATS_ObjectBGPriSetCap( wk->cap, WAZAEFF_ACT_BGPRI );
	CATS_ObjectObjModeSetCap(wk->cap, GX_OAM_MODE_XLU);
	CATS_ObjectAffineSetCap( wk->cap, CLACT_AFFINE_DOUBLE );

	WET_DefaultBlendSet( wk->we_sys, wk->poke_alpha, 16 - wk->poke_alpha );

	WEEffect_TCB_AddPriSet(wk->we_sys, WeCAPPokeScaleUpDownTCB, wk);
}


//-------------------------------------
//	
//	SSP̊gk
//	
//=====================================
enum{
	WE_POKE_SSP_SCALEUP_INIT,
	WE_POKE_SSP_SCALEUP,
	WE_POKE_SSP_WAIT,
	WE_POKE_SSP_SCALEDOWN_INIT,
	WE_POKE_SSP_SCALEDOWN,
	WE_POKE_SSP_SCALEEND,
};

typedef struct {
	WE_SYS_PTR we_sys;
	int seq;

	s16 dy;			// ̃|WV
	s16 poke_h;		// |P̍

	// |P
	SOFT_SPRITE*	ssp;
	WAZATOOL_CALCMOVE	ssp_scale;

	int scale_sx;
	int scale_ex;
	int scale_sy;
	int scale_ey;
	int scale_d;
	int scale_num;		// LтďkނPƂ
	int scale_sync;		// LтďkނɂP̂񂭐

	int wait;
} TWE_POKE_SSP_SCALE_UPDOWN;

static void WeSSPPokeScaleUpDownTCB( TCB_PTR tcb, void* work )
{
	TWE_POKE_SSP_SCALE_UPDOWN* wk = work;

	switch( wk->seq ){
	case WE_POKE_SSP_SCALEUP_INIT:
		WazaTool_InitScaleRateEx(
				&wk->ssp_scale,
				wk->scale_sx,
				wk->scale_ex,
				wk->scale_sy,
				wk->scale_ey,
				wk->scale_d,
				wk->scale_sync >> 16
				);
		// gklݒ
		WazaTool_CalcAndReflectScaleRateSsp( &wk->ssp_scale, wk->ssp );
		wk->seq++;
		break;
		
	case WE_POKE_SSP_SCALEUP:
		// gklݒ
		if( WazaTool_CalcAndReflectScaleRateExSsp( &wk->ssp_scale, wk->ssp ) ){
			WazaTool_PokeOffsetSet(
					wk->ssp,
					wk->dy, wk->poke_h,
					wk->ssp_scale.work[4], WAZAEFF_OFS_MODE_BOTTOM);//*/
			
		}else{
			wk->seq++;
		}
		break;
		
	case WE_POKE_SSP_WAIT:
	
		if (wk->wait == 0){
			wk->seq++;
		}
		else {
			wk->wait--;
			break;
		}
		
	case WE_POKE_SSP_SCALEDOWN_INIT:
		WazaTool_InitScaleRateEx(
				&wk->ssp_scale,
				wk->scale_ex,
				wk->scale_sx,
				wk->scale_ey,
				wk->scale_sy,
				wk->scale_d,
				wk->scale_sync & 0xffff
				);
		WazaTool_CalcAndReflectScaleRateExSsp( &wk->ssp_scale, wk->ssp );
		wk->seq++;
		break;
		
	case WE_POKE_SSP_SCALEDOWN:
		// gklݒ
		if( WazaTool_CalcAndReflectScaleRateExSsp( &wk->ssp_scale, wk->ssp ) ){
			WazaTool_PokeOffsetSet(
					wk->ssp,
					wk->dy, wk->poke_h,
					wk->ssp_scale.work[4], WAZAEFF_OFS_MODE_BOTTOM);//*/
		}else{
			wk->scale_num --;
			if( wk->scale_num <= 0 ){
				// I
				wk->seq++;
			}else{
				wk->seq = WE_POKE_SSP_SCALEUP_INIT;
			}
		}
		break;
		
	case WE_POKE_SSP_SCALEEND:
		sys_FreeMemoryEz(wk);
		WEEffect_TCB_Delete(wk->we_sys, tcb);
		return;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	POKE_SSP Lяk݂	
 *
 *	@param	we_sys		ZGtFNgVXe
 *
 *	@return	none
 *
 * we_sys.work[0]	Ώۃ|P	iIs\j
 * we_sys.work[1]	scale_sx	JnXP[
 * we_sys.work[2]	scale_ex	IXP[
 * we_sys.work[3]	scale_sy	JnXP[
 * we_sys.work[4]	scale_ey	IXP[
 * we_sys.work[5]	scale_d		100%̎̃XP[
 * we_sys.work[6]	scale_num	XP[	LтďkނPƂ񐔁@16rbg EFCg@16rbg XP[
 
 * we_sys.work[7]	scale_sync	VN	LтVN 16bit	kރVN 16bit
 *
 */
//-----------------------------------------------------------------------------
void WestSp_WE_SSPPokeScaleUpDown(WE_SYS_PTR we_sys)
{
	TWE_POKE_SSP_SCALE_UPDOWN* wk;
	TWE_POKE_SYS pp[ 4 ];
	TCB_PTR tcb;
	int num;

	wk = WET_ALLOC_MEMORY(we_sys, TWE_POKE_SSP_SCALE_UPDOWN);
	wk->we_sys	= we_sys;

	// |P̍擾
	switch( WeSysGPWorkGet(we_sys, 0) ){
	case WE_TOOL_M1 | WE_TOOL_SSP:
	case WE_TOOL_M2 | WE_TOOL_SSP:
		wk->poke_h	= WeSysPokeOfsGet(wk->we_sys, WeSysATNoGet(wk->we_sys));
		break;
		
	case WE_TOOL_E1 | WE_TOOL_SSP:
	case WE_TOOL_E2 | WE_TOOL_SSP:
		wk->poke_h	= WeSysPokeOfsGet(wk->we_sys, WeSysDFNoGet(wk->we_sys));
		break;
	}

	// |P擾
	WT_SSPointerGet( wk->we_sys, WeSysGPWorkGet(we_sys, 0), pp, &num );
	wk->ssp = pp[0].ssp;
	wk->dy = SoftSpriteParaGet( wk->ssp, SS_PARA_POS_Y );
	
	wk->scale_sx	= WeSysGPWorkGet(we_sys, 1);
	wk->scale_ex	= WeSysGPWorkGet(we_sys, 2);
	wk->scale_sy	= WeSysGPWorkGet(we_sys, 3);
	wk->scale_ey	= WeSysGPWorkGet(we_sys, 4);
	wk->scale_d		= WeSysGPWorkGet(we_sys, 5);
	wk->scale_num	= WeSysGPWorkGet(we_sys, 6);
	wk->scale_sync	= WeSysGPWorkGet(we_sys, 7);

	///< [NȂ̂ŁA16rbgEFCgɕύX
	wk->scale_num	= WeSysGPWorkGet(we_sys, 6) & 0xffff;
	wk->wait		= WeSysGPWorkGet(we_sys, 6) >> 16;

	tcb = WEEffect_TCB_AddPriSet(wk->we_sys, WeSSPPokeScaleUpDownTCB, wk);
	
	WeSSPPokeScaleUpDownTCB(tcb, wk);
}



//-------------------------------------
//	
//	At@tF[h
//	
//=====================================
typedef struct {
	WE_SYS_PTR we_sys;
	CATS_RES_PTR crp;

	WAZATOOL_ALPHA_FADE alpha;
} TWE_BG_NORMALALPHA_FADE_SYS;

static void WeCapNormalAlphaTCB( TCB_PTR tcb, void* work )
{
	TWE_BG_NORMALALPHA_FADE_SYS* wk = work;

	if( WazaTool_EndCheckAlphaFade( &wk->alpha ) ){
		sys_FreeMemoryEz(wk);
		WEEffect_TCB_Delete(wk->we_sys, tcb);
	}else{

		// cOAM`
		CATS_Draw(wk->crp);	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tF[h
 *
 *	@param	we_sys		ZGtFNgVXe
 *
 *	@return	none
 *
 *	we_sys.work[0]	Ώcap|P	0bit = 0 1bit = 1
 *	we_sys.work[1]	ΏۂPJnl	0`31
 *	we_sys.work[2]	ΏۂPIl	0`31
 *	we_sys.work[3]	ΏۂQJnl	0`31
 *	we_sys.work[4]	ΏۂQIl	0`31
 *	we_sys.work[5]	VN
 */
//-----------------------------------------------------------------------------
void WestSp_WE_CAP_NormalAlphaFade(WE_SYS_PTR we_sys)
{
	TWE_BG_NORMALALPHA_FADE_SYS* wk;
	int cap_bit;
	int i;
	CATS_ACT_PTR cap;
	int alpha1_s;
	int alpha2_s;
	

	wk = WET_ALLOC_MEMORY(we_sys, TWE_BG_NORMALALPHA_FADE_SYS);
	wk->we_sys	= we_sys;
	wk->crp		= WeSysPokeCrpGet(wk->we_sys);
	
	cap_bit = WeSysGPWorkGet( we_sys, 0 );
	
	// OAMݒ
	for( i=0; i<4; i++ ){
		if( cap_bit & (1 << i) ){
			cap  = WeSysPokeCapGet(wk->we_sys, i);
			CATS_ObjectObjModeSetCap( cap, GX_OAM_MODE_XLU );
		}
	}
	
	alpha1_s = WeSysGPWorkGet( we_sys, 1 );
	alpha2_s = WeSysGPWorkGet( we_sys, 3 );
	
	WET_DefaultBlendSet( wk->we_sys, alpha1_s, alpha2_s );
	WazaTool_StartAlphaFade(
			&wk->alpha,
			alpha1_s,
			WeSysGPWorkGet( we_sys, 2 ),
			alpha2_s,
			WeSysGPWorkGet( we_sys, 4 ),
			WeSysGPWorkGet( we_sys, 5 )
			);
		
	WEEffect_TCB_AddPriSet(wk->we_sys, WeCapNormalAlphaTCB, wk);
}


//-------------------------------------
//	
//	|P̃ojbV
//	
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *	@brief	|P̃ojbVݒ
 *
 *	@param	we_sys	ZGtFNgVXe
 *
 *	@return	none
 *
 * we_sys.work[0]	Ώۃ|P@
 * we_sys.work[1]	0\	1\
 *
 */
//-----------------------------------------------------------------------------
void WestSp_WE_SSP_PokeVanish(WE_SYS_PTR we_sys)
{
	TWE_POKE_SYS pp;
	int num;
	int i;
	
	WT_SSPointerGet( 
			we_sys,
			WeSysGPWorkGet( we_sys, 0 ),
			&pp,
			&num
			);

	for( i=0; i<num; i++ ){
		SoftSpriteParaSet( pp.ssp, SS_PARA_VANISH, WeSysGPWorkGet( we_sys, 1 ) );
	}
}



/// uN
typedef struct {
	
	int num;
	int cnt;
	int	wait;
	
	TWE_POKE_SYS	pp;

	TWE_TOOL_SYS	ts;
	
	WE_SYS_PTR		wsp;
	
} TWE_T03_SYS;

static void WeT03_TCB(TCB_PTR tcb, void* work)
{
	TWE_T03_SYS* wk = (TWE_T03_SYS*)work;
	
	if (wk->cnt >= wk->wait){
		
		if (wk->num == 0){
			SoftSpriteParaSet(wk->pp.ssp, SS_PARA_VANISH, 0);
			sys_FreeMemoryEz(wk);
			WEEffect_TCB_Delete(wk->wsp, tcb);
		}
		else {
			int flag;
			flag = SoftSpriteParaGet(wk->pp.ssp, SS_PARA_VANISH);
			SoftSpriteParaSet(wk->pp.ssp, SS_PARA_VANISH, flag ^ 1);
			wk->num--;
			wk->cnt = 0;
		}				
	}
	else {
		wk->cnt++;
	}
}

void WestSp_WE_T03(WE_SYS_PTR we_sys)
{
	TWE_T03_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_T03_SYS);

	wk->wsp  = we_sys;
	wk->num  = WeSysGPWorkGet(we_sys, 0) * 2;
	wk->wait = WeSysGPWorkGet(we_sys, 1);

	WT_ToolSysInit(we_sys, &wk->ts);
	
	wk->pp.ssp = WeSysSoftSpritePointerGet(we_sys, WeSysATNoGet(we_sys));
		
	WEEffect_TCB_AddPriSet(wk->wsp, WeT03_TCB, wk);
}


/// wU
typedef struct {

	int num;
	int cnt;
	int	wait;
	
	s16	ofs_x;		///< ړ
	
	TWE_POKE_SYS	pp;

	TWE_TOOL_SYS	ts;
	
	WAZATOOL_CALCMOVE cm;
	
	WE_SYS_PTR		wsp;
	
} TWE_T04_SYS;

static void WeT04_TCB(TCB_PTR tcb, void* work)
{
	TWE_T04_SYS* wk = (TWE_T04_SYS*)work;
	
	switch(wk->ts.seq){
	case 0:
		WazaTool_InitStraightSyncFx(&wk->cm, 
									wk->pp.p.x, wk->pp.p.x + wk->ofs_x,
									wk->pp.p.y, wk->pp.p.y, 
									wk->wait);
		wk->ts.seq++;
		break;
	case 1:
		if (WazaTool_CalcStraightFx(&wk->cm) == FALSE){
			wk->ts.seq++;
		}
		SoftSpriteParaSet(wk->pp.ssp, SS_PARA_POS_X, wk->cm.x);
		break;
	default:
		WEEffect_TCB_Delete(wk->wsp, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}

void WestSp_WE_T04(WE_SYS_PTR we_sys)
{
	int r_vec;
	int type;
	int client;
	TWE_T04_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_T04_SYS);

	wk->wsp   = we_sys;
	wk->wait  = WeSysGPWorkGet(we_sys, 0);
	wk->ofs_x = WeSysGPWorkGet(we_sys, 1);
	type = WeSysGPWorkGet(we_sys, 2);
	
	switch(type){
	case WE_TOOL_M1 | WE_TOOL_SSP:
		client = WeSysATNoGet(we_sys);
		break;
	case WE_TOOL_M2 | WE_TOOL_SSP:
		client = WET_AllySideClientNoGet(we_sys, WeSysATNoGet(we_sys));
		break;
	case WE_TOOL_E1 | WE_TOOL_SSP:
		client = WeSysDFNoGet(we_sys);
		break;
	case WE_TOOL_E2 | WE_TOOL_SSP:
		client = WET_AllySideClientNoGet(we_sys, WeSysDFNoGet(we_sys));
		break;
	default:
		GF_ASSERT(0);
		break;
	}

	WT_ToolSysInit(we_sys, &wk->ts);
	
	wk->pp.ssp = WeSysSoftSpritePointerGet(we_sys, client);
	WT_SSP_PointGet(wk->pp.ssp, &wk->pp.p);
	
	r_vec = WazaTool_VecChangeX(we_sys, client);
	if (r_vec > 0){
		wk->ofs_x *= +1;
	}
	else {
		wk->ofs_x *= -1;
	}
		
	WEEffect_TCB_AddPriSet(wk->wsp, WeT04_TCB, wk);
}

/// ̈ʒuɂǂ
typedef struct {

	int num;
	int cnt;
	int	wait;
	
	TWE_POKE_SYS	pp;
	TWE_TOOL_SYS	ts;
	
	WAZATOOL_CALCMOVE cm;
	
	WE_SYS_PTR		wsp;
	
	s16	ofs_x;		///< ړ
	
} TWE_T05_SYS;

static void WeT05_TCB(TCB_PTR tcb, void* work)
{
	TWE_T05_SYS* wk = (TWE_T05_SYS*)work;
	
	switch(wk->ts.seq){
	case 0:
		WazaTool_InitStraightSyncFx(&wk->cm, 
									wk->pp.p.x, wk->pp.p.x + wk->ofs_x,
									wk->pp.p.y, wk->pp.p.y, 
									wk->wait);
		wk->ts.seq++;

	case 1:
		if (WazaTool_CalcStraightFx(&wk->cm) == FALSE){
			wk->ts.seq++;
		}
		SoftSpriteParaSet(wk->pp.ssp, SS_PARA_POS_X, wk->cm.x);
		break;
	default:
		WEEffect_TCB_Delete(wk->wsp, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}

void WestSp_WE_T05(WE_SYS_PTR we_sys)
{
	int r_vec;
	int type;
	int client;
	TWE_T05_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_T05_SYS);

	wk->wsp   = we_sys;
	wk->wait  = WeSysGPWorkGet(we_sys, 0);
	wk->ofs_x = WeSysGPWorkGet(we_sys, 1);
	type = WeSysGPWorkGet(we_sys, 2);

	WT_ToolSysInit(we_sys, &wk->ts);
	
	switch(type){
	case WE_TOOL_M1 | WE_TOOL_SSP:
		client = WeSysATNoGet(we_sys);
		break;
	case WE_TOOL_M2 | WE_TOOL_SSP:
		client = WET_AllySideClientNoGet(we_sys, WeSysATNoGet(we_sys));
		break;
	case WE_TOOL_E1 | WE_TOOL_SSP:
		client = WeSysDFNoGet(we_sys);
		break;
	case WE_TOOL_E2 | WE_TOOL_SSP:
		client = WET_AllySideClientNoGet(we_sys, WeSysDFNoGet(we_sys));
		break;
	default:
		GF_ASSERT(0);
		break;
	}

	wk->pp.ssp = WeSysSoftSpritePointerGet(we_sys, client);
	WT_SSP_PointGet(wk->pp.ssp, &wk->pp.p);
	
	r_vec = WazaTool_VecChangeX(we_sys, client);
	if (r_vec > 0){
		wk->ofs_x *= +1;
	}
	else {
		wk->ofs_x *= -1;
	}

	{
		TCB_PTR tcb;
		
		tcb = WEEffect_TCB_AddPriSet(wk->wsp, WeT05_TCB, wk);
		
		WeT05_TCB(tcb, wk);
	}
}


// т
// -----------------------------------------
//
//	\
//
// -----------------------------------------
typedef struct {
	
	u8	seq;
	u8	wait;
	s16	dy;
	int poke_h;
	
	u8	fade_cnt;
	
	u8	keep_cnt;
	u8	keep_wait;
	
	WE_SYS_PTR		wsp;
	SOFT_SPRITE*	ssp;
	
	WAZATOOL_CALCMOVE cm;
	WAZATOOL_CALCMOVE shake;
	
} TWE_T06_SYS;

#define WET06_FADE_CNT		(3)
#define WET06_SS_FADE_WAIT	(0)
#define WET06_SS_FADE_COL	(0x1F)
#define WET06_END_EVY		(10)

//--------------------------------------------------------------
/**
 * @brief	֐
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void WeT06_TCB(TCB_PTR tcb, void* work)
{
	TWE_T06_SYS* wk = (TWE_T06_SYS*)work;
	
	switch(wk->seq){
	case 0:
		///< k
		if (WazaTool_CalcScaleRate(&wk->cm) == TRUE){
			WazaTool_CalcShake(&wk->shake);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, wk->cm.x);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, wk->cm.y);
			SoftSpriteParaCalc(wk->ssp, SS_PARA_POS_X, wk->shake.x);
			{
				s16 ofs_y = WazaTool_CalcScaleRateToYPosFX(wk->dy, wk->poke_h, wk->cm.work[4]);
				SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy + ofs_y);
			}
		}
		else {
			wk->seq++;
		}		
		break;
	case 1:
		if ((++wk->keep_cnt) > wk->keep_wait){
			WazaTool_InitScaleRate(&wk->cm,
						   		   WeSysGPWorkGet(wk->wsp, 0),
						   		   100,
						   		   WeSysGPWorkGet(wk->wsp, 1),
						   		   WeSysGPWorkGet(wk->wsp, 3));
			wk->seq++;
		}
		break;

	case 2:
		///< т[[[
		if (WazaTool_CalcScaleRate(&wk->cm) == TRUE){
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, wk->cm.x);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, wk->cm.y);
			{
				s16 ofs_y = WazaTool_CalcScaleRateToYPosFX(wk->dy, wk->poke_h, wk->cm.work[4]);
				SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy + ofs_y);
			}
		}
		else {
			wk->seq++;
		}
		break;
	case 3:
		///< ǂ
		if (WazaTool_CalcScaleRate(&wk->cm) == TRUE){
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, wk->cm.x);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, wk->cm.y);
			{
				s16 ofs_y = WazaTool_CalcScaleRateToYPosFX(wk->dy, wk->poke_h, wk->cm.work[4]);
				SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy + ofs_y);
			}
		}
		else {
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, 0x0100);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, 0x0100);
			SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy);
			wk->seq++;
		}
		break;
	default:
		WEEffect_TCB_Delete(wk->wsp, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}


//--------------------------------------------------------------
/**
 * @brief	Ăяo֐
 *
 * @param	we_sys	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WestSp_WE_T06(WE_SYS_PTR we_sys)
{
	TWE_T06_SYS* wk;
	
	wk = sys_AllocMemory(WeSysHeapAreaGet(we_sys), sizeof(TWE_T06_SYS));
	
	wk->fade_cnt = 0;
	wk->seq = 0;
	wk->wsp = we_sys;
	wk->ssp = WeSysSoftSpritePointerGet( wk->wsp, WeSysATNoGet(wk->wsp) );
	
	wk->keep_cnt  = 0;
	wk->keep_wait = WeSysGPWorkGet(we_sys, 4);
	
	wk->dy  = SoftSpriteParaGet(wk->ssp, SS_PARA_POS_Y);
	
	wk->poke_h = WeSysPokeOfsGet(wk->wsp, WeSysATNoGet(wk->wsp));
	
	///< gk
	WazaTool_InitScaleRate(&wk->cm,
						   100,
						   100,
						   WeSysGPWorkGet(we_sys, 0),
						   WeSysGPWorkGet(we_sys, 2));
	///< h炵
	WazaTool_InitShake(&wk->shake, 2,0,0,10);
						   
	
	WEEffect_TCB_AddPriSet(wk->wsp, WeT06_TCB, wk);
}


// т
// -----------------------------------------
//
//	\
//
// -----------------------------------------
typedef struct {
	
	u8	seq;
	u8	wait;
	s16	dy;
	int poke_h;
	
	u8	fade_cnt;
	
	u8	keep_cnt;
	u8	keep_wait;
	
	WE_SYS_PTR		wsp;
	SOFT_SPRITE*	ssp;
	
	WAZATOOL_CALCMOVE cm;
	WAZATOOL_CALCMOVE shake;
	
} TWE_T07_SYS;

#define WET07_FADE_CNT		(3)
#define WET07_SS_FADE_WAIT	(0)
#define WET07_SS_FADE_COL	(0x1F)
#define WET07_END_EVY		(10)

//--------------------------------------------------------------
/**
 * @brief	֐
 *
 * @param	tcb	
 * @param	work	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
static void WeT07_TCB(TCB_PTR tcb, void* work)
{
	TWE_T07_SYS* wk = (TWE_T07_SYS*)work;
	
	switch(wk->seq){
	case 0:
		///< k
		if (WazaTool_CalcScaleRateEx(&wk->cm) == TRUE){
			WazaTool_CalcShake(&wk->shake);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, wk->cm.x);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, wk->cm.y);
			SoftSpriteParaCalc(wk->ssp, SS_PARA_POS_X, wk->shake.x);
			{
				s16 ofs_y = WazaTool_CalcScaleRateToYPosFX(wk->dy, wk->poke_h, wk->cm.work[4]);
				SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy + ofs_y);
			}
		}
		else {
			wk->seq++;
//			WEEffect_TCB_Delete(wk->wsp, tcb);
//			sys_FreeMemoryEz(wk);
		}		
		break;
	case 1:
		if ((++wk->keep_cnt) > wk->keep_wait){
			{
				s16 sx, sy;
				s16 ex, ey;
				sx = WeSysGPWorkGet(wk->wsp, 3) >> 16;
				ex = WeSysGPWorkGet(wk->wsp, 3) & 0x00FF;
				sy = WeSysGPWorkGet(wk->wsp, 4) >> 16;
				ey = WeSysGPWorkGet(wk->wsp, 4) & 0x00FF;
				WazaTool_InitScaleRateEx(&wk->cm,
										sx,ex,
										sy,ey,100,
										WeSysGPWorkGet(wk->wsp, 5));
			}
			wk->seq++;
		}
		break;

	case 2:
		///< т[[[
		if (WazaTool_CalcScaleRateEx(&wk->cm) == TRUE){
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, wk->cm.x);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, wk->cm.y);
			{
				s16 ofs_y = WazaTool_CalcScaleRateToYPosFX(wk->dy, wk->poke_h, wk->cm.work[4]);
				SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy + ofs_y);
			}
		}
		else {
			wk->seq++;
		}
		break;
	case 3:
		///< ǂ
		if (WazaTool_CalcScaleRateEx(&wk->cm) == TRUE){
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, wk->cm.x);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, wk->cm.y);
			{
				s16 ofs_y = WazaTool_CalcScaleRateToYPosFX(wk->dy, wk->poke_h, wk->cm.work[4]);
				SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy + ofs_y);
			}
		}
		else {
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_X, 0x0100);
			SoftSpriteParaSet(wk->ssp, SS_PARA_AFF_Y, 0x0100);
			SoftSpriteParaSet(wk->ssp, SS_PARA_POS_Y, wk->dy);
			wk->seq++;
		}
		break;
	default:
		WEEffect_TCB_Delete(wk->wsp, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}


//--------------------------------------------------------------
/**
 * @brief	Ăяo֐
 *
 * @param	we_sys	
 *
 * @retval	none	
 *
 */
//--------------------------------------------------------------
void WestSp_WE_T07(WE_SYS_PTR we_sys)
{
	TWE_T07_SYS* wk;
	
	wk = sys_AllocMemory(WeSysHeapAreaGet(we_sys), sizeof(TWE_T07_SYS));
	
	wk->fade_cnt = 0;
	wk->seq = 0;
	wk->wsp = we_sys;
	wk->ssp = WeSysSoftSpritePointerGet( wk->wsp, WeSysATNoGet(wk->wsp) );
	
	wk->keep_cnt  = 0;
	wk->keep_wait = WeSysGPWorkGet(we_sys, 6);
	
	WazaEffPosGet_ClientType(we_sys, WeSysATNoGet(wk->wsp), NULL, &wk->dy);
	
	wk->poke_h = WeSysPokeOfsGet(wk->wsp, WeSysATNoGet(wk->wsp));
	
	wk->dy += wk->poke_h;
	
	///< gk
	{
		s16 sx, sy;
		s16 ex, ey;
		s16 ofs_y;
		sx = WeSysGPWorkGet(we_sys, 0) >> 16;
		ex = WeSysGPWorkGet(we_sys, 0) & 0x00FF;
		sy = WeSysGPWorkGet(we_sys, 1) >> 16;
		ey = WeSysGPWorkGet(we_sys, 1) & 0x00FF;
		WazaTool_InitScaleRateEx(&wk->cm,
								sx,ex,
								sy,ey,100,
								WeSysGPWorkGet(we_sys, 2));
	}
	///< h炵
	WazaTool_InitShake(&wk->shake, 2,0,0,10);
						   
	
	WEEffect_TCB_AddPriSet(wk->wsp, WeT07_TCB, wk);
}

// =============================================================================
//
//
//	I[
//
//
// =============================================================================
typedef struct {

	int type;
	
	TWE_TOOL_SYS	ts;
	
	CATS_ACT_PTR	poke_cap;
	CATS_ACT_PTR	obj_win_cap;
	
} TWE_T08_SYS;

static void WeT08_TCB(TCB_PTR tcb, void* work)
{
	TWE_T08_SYS* wk = (TWE_T08_SYS*)work;

	switch(wk->ts.seq){
	default:
		GX_SetVisibleWnd(GX_WNDMASK_NONE);
		WeSysBaseBGReset(wk->ts.wsp, BATTLE_FRAME_EFFECT);
		WEEffect_TCB_Delete(wk->ts.wsp, tcb);
		sys_FreeMemoryEz(wk);
		return;
	}

	CATS_ObjectUpdateCap(wk->obj_win_cap);
//	CATS_ObjectUpdateCap(wk->poke_cap);
	
	CATS_Draw(wk->ts.poke_crp);
}
#define WET08_AURA_OUTSIDE_PLANE (GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ)
#define WET08_AURA_INSIDE_PLANE  (GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 |	GX_WND_PLANEMASK_BG2)
void WestSp_WE_T08(WE_SYS_PTR we_sys)
{
	int type;
	TWE_T08_SYS* wk = NULL;
	
	wk = WET_ALLOC_MEMORY(we_sys, TWE_T08_SYS);

	type = WeSysGPWorkGet(we_sys, 0);

	WT_ToolSysInit(we_sys, &wk->ts);

	WeSysBaseBGSet(wk->ts.wsp, BATTLE_FRAME_EFFECT);

	///< EBhEOBJ
	wk->obj_win_cap = WeSysPokeCapGet(wk->ts.wsp, 0);
	CATS_ObjectObjModeSetCap(wk->obj_win_cap, GX_OAM_MODE_OBJWND);
	CATS_ObjectAffineSetCap(wk->obj_win_cap, CLACT_AFFINE_DOUBLE);
	CATS_ObjectScaleSetCap(wk->obj_win_cap, 1.2f, 1.2f);
	GX_SetVisibleWnd(GX_WNDMASK_OW);
	G2_SetWndOutsidePlane(WET08_AURA_OUTSIDE_PLANE,	FALSE);
	G2_SetWndOBJInsidePlane(WET08_AURA_INSIDE_PLANE, FALSE);
	
	///< OBJ
//	wk->poke_cap = WeSysPokeCapGet(wk->ts.wsp, 1);
	
	WEEffect_TCB_AddPriSet(wk->ts.wsp, WeT08_TCB, wk);
}

/// ̈ʒuɂǂ
typedef struct {

	int num;
	int cnt;
	int	wait;
	
	TWE_POKE_SYS	pp;
	TWE_TOOL_SYS	ts;
	
	WAZATOOL_CALCMOVE cm;
	
	WE_SYS_PTR		wsp;
	
	s16	ofs_x;		///< ړ
	s16	ofs_y;		///< ړ
	
} TWE_T10_SYS;

static void WeT10_TCB(TCB_PTR tcb, void* work)
{
	TWE_T10_SYS* wk = (TWE_T10_SYS*)work;
	
	switch(wk->ts.seq){
	case 0:
		WazaTool_InitStraightSyncFx(&wk->cm, 
									wk->pp.p.x, wk->pp.p.x + wk->ofs_x,
									wk->pp.p.y, wk->pp.p.y + wk->ofs_y, 
									wk->wait);
		wk->ts.seq++;

	case 1:
		if (WazaTool_CalcStraightFx(&wk->cm) == FALSE){
			wk->ts.seq++;
		}
		SoftSpriteParaSet(wk->pp.ssp, SS_PARA_POS_X, wk->cm.x);
		SoftSpriteParaSet(wk->pp.ssp, SS_PARA_POS_Y, wk->cm.y);
		break;
	default:
		WEEffect_TCB_Delete(wk->wsp, tcb);
		sys_FreeMemoryEz(wk);
		break;
	}
}

void WestSp_WE_T10(WE_SYS_PTR we_sys)
{
	int r_vec;
	int type;
	int client;
	TWE_T10_SYS* wk = WET_ALLOC_MEMORY(we_sys, TWE_T10_SYS);

	wk->wsp   = we_sys;
	wk->wait  = WeSysGPWorkGet(we_sys, 0);
	wk->ofs_x = WeSysGPWorkGet(we_sys, 1);
	wk->ofs_y = WeSysGPWorkGet(we_sys, 2);
	type = WeSysGPWorkGet(we_sys, 3);

	WT_ToolSysInit(we_sys, &wk->ts);
	
	switch(type){
	case WE_TOOL_M1 | WE_TOOL_SSP:
		client = WeSysATNoGet(we_sys);
		break;
	case WE_TOOL_M2 | WE_TOOL_SSP:
		client = WET_AllySideClientNoGet(we_sys, WeSysATNoGet(we_sys));
		break;
	case WE_TOOL_E1 | WE_TOOL_SSP:
		client = WeSysDFNoGet(we_sys);
		break;
	case WE_TOOL_E2 | WE_TOOL_SSP:
		client = WET_AllySideClientNoGet(we_sys, WeSysDFNoGet(we_sys));
		break;
	default:
		GF_ASSERT(0);
		break;
	}

	wk->pp.ssp = WeSysSoftSpritePointerGet(we_sys, client);
	WT_SSP_PointGet(wk->pp.ssp, &wk->pp.p);
	
	r_vec = WazaTool_VecChangeX(we_sys, client);
	if (r_vec > 0){
		wk->ofs_x *= +1;
		wk->ofs_y *= +1;
	}
	else {
		wk->ofs_x *= -1;
		wk->ofs_y *= -1;
	}

	{
		TCB_PTR tcb;
		
		tcb = WEEffect_TCB_AddPriSet(wk->wsp, WeT10_TCB, wk);
		
		WeT10_TCB(tcb, wk);
	}
}