#include "memSend.h"
#include <isdbglib.h>

static BOOL isSession;
static u32 sendSize;
static u8* sendDataBuf;
static u8 sendNum;
static unsigned long g_nToolAPIResource = FALSE;
static BOOL sendOKFlag;
u32 sizePerSend = 8*1024;
u32 dummy;

static void MemClearParams();
static void SampleStream_RecvCallback( u32 dwUser, u32 nChn, const void *pAdrs, u32 nSize );

void MemSendInit()
{
	//	ToolAPȈƃfoCX̎擾
	{
		const struct tagNITRODEVCAPS*	pDevice;
		int		total;
		dummy = 0;

		// c[API܂
		NITROToolAPIInit( );

		total = NITROToolAPIGetMaxCaps( );
		if( !total ) {
			OS_TPrintf("foCX܂ł\n" );
		}

		pDevice = NITROToolAPIGetDeviceCaps( 0 );
		if( !NITROToolAPIOpen( pDevice ) ){
			// foCXJ܂ł
			OS_TPrintf("foCXJ܂ł\n" );
		}

		switch( pDevice->m_nDeviceID ){
			case NITRODEVID_CGBEMULATOR:
				OS_TPrintf("Device IS-CGB-EMULATOR open succeeded.\n" );
				break;
			case NITRODEVID_NITEMULATOR:
				OS_TPrintf("Device IS-NITRO-EMULATOR open succeeded.\n" );
				break;
			case NITRODEVID_NITUIC:
				OS_TPrintf("Device IS-NITRO-UIC open succeeded.\n" );
				break;
			default:
				OS_TPrintf("Device UNKNOWN open succeeded.\n" );
				break;
		}

		// f[^M̃R[obNo^܂
		(void)NITROToolAPISetReceiveStreamCallBackFunction( SampleStream_RecvCallback, (u32)(&dummy) );
		g_nToolAPIResource = pDevice->m_dwMaskResource;
	}


	MemClearParams();
}

void MemClearParams()
{
	isSession = FALSE;
	sendOKFlag = FALSE;
	sendSize = 0;
	sendDataBuf = NULL;
	sendNum = 0;
}

void MemSendData(u8* sendData, u32 size)
{
	sendDataBuf = sendData;
	sendSize = size;
	if(isSession)
	{
		OS_TPrintf("ɂQȏ㑗Mł܂\n");
		return;
	}
	else
	{
		isSession = TRUE;
		NITROToolAPIWriteStream(SEND_START , &size, sizeof(u32) );
	}
}

void MemSendLoop()
{
	if(isSession)
	{
		if(sendOKFlag)
		{
			if(sendSize > sizePerSend)
			{
				OS_TPrintf("block[%d]\n",sendNum);
				NITROToolAPIWriteStream(SEND_DATA , sendDataBuf, sizePerSend );	
				sendSize -= sizePerSend;
				sendOKFlag = FALSE;
				sendDataBuf += sizePerSend;
				sendNum++;
			}
			else
			{
				OS_TPrintf("Last block[%d]\n",sendNum);
				NITROToolAPIWriteStream(SEND_END , sendDataBuf, sendSize );
				sendSize = 0;
				MemClearParams();
			}
		}
		
	}

	//	ToolAPIɑ΂|[O
	if( g_nToolAPIResource & NITROMASK_RESOURCE_POLL ) {
		// C[vŌpČĂԕKv܂
		NITROToolAPIPollingIdle();
	}

}

void SampleStream_RecvCallback( u32 dwUser, u32 nChn, const void *pAdrs, u32 nSize )
{
	(void)dwUser;
	(void)pAdrs;
	(void)nSize;
	if(nChn == DATA_SEND_OK)
	{
		sendOKFlag = TRUE;
	}

}

BOOL MemSendIsSending()
{
	return isSession;	
}