#ifndef	COMM_H
#define	COMM_H

#define MEMBLOCK_FILENAME_AREASIZE (12)	// fobOpwb_Ɋi[t@C̈TCY
										// DPƃYlɒ
										//   ensatał̒ʐMVXewordPʂɂȂ̂Œӂ邱ƁB

typedef enum
{
	ALLOC_INFO = 0,
	FREE_INFO,
	CREATE_HEAP_INFO,
	DELETE_HEAP_INFO
}MsgType;

typedef struct		// sizeof(AllocInfo)̐{MAX_SEND_NUMƈvKv
{
	unsigned int	heapID;
	unsigned int	size;
	unsigned int	line_num;
	unsigned int    addr;
	char			filename[MEMBLOCK_FILENAME_AREASIZE];
}AllocInfo;

typedef struct		// AllocInfoƃTCYvĂKv
{
	unsigned int	heapID;
	unsigned int	parentID;
   	unsigned int	size;
	unsigned int    addr;
}HeapInfo;

typedef struct
{
	unsigned int	type;
	union
	{
		AllocInfo	allocInfo;
		HeapInfo	heapInfo;
	};
}MemInfo;

typedef void (*COMM_INIT)(void);
typedef BOOL (*COMM_SEND)(const MemInfo *);
typedef void (*COMM_LOOP)(void);

typedef struct
{
	COMM_INIT		init;
	COMM_SEND		send;
	COMM_LOOP		loop;
}CommFunc;

const CommFunc *get_ensata_func(void);
const CommFunc *get_is_debugger_func(void);

#endif
