#include <nitro.h>
#include "comm.h"
#include "ensata_plugin_comm.h"

static void comm_init(void);
static BOOL comm_send(const MemInfo *data);
static void comm_loop(void);

static s32					s_id;
static RECV_CALLBACK_INFO	s_work;
static CommFunc				s_comm_func = {
	comm_init, comm_send, comm_loop
};

const CommFunc *get_ensata_func(void)
{
	return &s_comm_func;
}

static void comm_init(void)
{
	if (!ensata_plugin_comm_init("MemSnatcher", NULL, NULL, &s_id, &s_work)) {
		OS_TPrintf("fail to ensata_plugin_comm_init_id!\n");
	}
}

static BOOL comm_send(const MemInfo *data)
{
	ensata_plugin_comm_send(s_id, (u32 *)data, sizeof(*data) / sizeof(u32));
	return TRUE;
}

static void comm_loop(void)
{
	// 邱Ƃ͂ȂB
}
