#include <nitro.h>
#include "ensata_plugin_comm.h"

#define	REG_IO_COMMCHKID		(*(u32 *)0x4fff300)
#define	REG_IO_COMMID			(*(u32 *)0x4fff304)
#define	REG_IO_COMMSIZE			(*(u32 *)0x4fff308)
#define	REG_IO_COMMDATA			(*(u32 *)0x4fff30c)
#define	REG_IO_COMMRCVID		(*(u32 *)0x4fff310)

static u32					s_init = 0;
static RECV_CALLBACK_INFO	s_head, *s_tail;

static void ensata_plugin_comm_intr(void);

int ensata_plugin_comm_init(const char *id_str, RECV_CALLBACK func, void *arg, s32 *id,
	RECV_CALLBACK_INFO *work)
{
	OSIntrMode				intr_mode;
	int						ret = 0;
	s32						_id;

	if (!s_init) {
		// ŏ̈xB
		(void)OS_ResetRequestIrqMask(0x8000);
		OS_SetIrqFunction(0x8000, ensata_plugin_comm_intr);
		(void)OS_EnableIrqMask(0x8000);
		s_head.next = NULL;
		s_tail = &s_head;
		s_init = 1;
	}

	intr_mode = OS_EnableInterrupts();
	REG_IO_COMMCHKID = (u32)id_str;
	_id = (s32)REG_IO_COMMCHKID;
	if (_id == -1) {
		goto end;
	}
	*id = _id;
	work->func = func;
	work->arg = arg;
	work->next = NULL;
	s_tail->next = work;
	ret = 1;

end:
	(void)OS_RestoreInterrupts(intr_mode); 
	return ret;
}

void ensata_plugin_comm_send(s32 id, const u32 *data, u32 size)
{
	u32		i;

	REG_IO_COMMID = (u32)id;
	REG_IO_COMMSIZE = size;
	for (i = 0; i < size; i++) {
		REG_IO_COMMDATA = data[i];
	}
}

u32 ensata_plugin_comm_recv(s32 id, u32 *data, u32 size)
{
	u32		_size;

	REG_IO_COMMRCVID = (u32)id;
	_size = REG_IO_COMMSIZE;
	if (data == NULL) {
		return _size;
	} else {
		u32		i;

		if (_size < size) {
			size = _size;
		}
		for (i = 0; i < size; i++) {
			data[i] = REG_IO_COMMDATA;
		}
		return size;
	}
}

static void ensata_plugin_comm_intr(void)
{
	RECV_CALLBACK_INFO		*p = s_head.next;

	while (p != NULL) {
		if (p->func) {
			p->func(p->arg);
		}
		p = p->next;
	}
}
